/*=========================================================================
This is an automatically generated file.  Include errata for any changes.
=========================================================================*/

#include "vtkDICOMCharacterSetTables.h"

// ASCII
const unsigned short CodePageASCII[9] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  2,
  // segment table
       0,    128,
  // compressed segments
  0x0000,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,
  // [     0,   127] -> [0x0000,0x007F] # seg 0
};

// Reverse
const unsigned short CodePageASCII_R[9] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  2,
  // segment table
  0x0000, 0x0080,
  // compressed segments
       0,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,
  // [0x0000,0x007F] -> [     0,   127] # seg 0
};

// JIS X 0201
const unsigned short CodePageJISX0201[23] = {
  // hot segments (indexes into segment table)
  0,
  // number of segments
  7,
  // segment table
       0,     92,     93,    126,    127,    161,    224,
  // compressed segments
  0x0000, 0x00A5, 0x005D, 0x203E, 0x007F, 0xFF61,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [     0,    91] -> [0x0000,0x005B] # seg 0
  // [    92,    92] -> [0x00A5,0x00A5] # seg 1
  // [    93,   125] -> [0x005D,0x007D] # seg 2
  // [   126,   126] -> [0x203E,0x203E] # seg 3
  // [   127,   160] -> [0x007F,0x00A0] # seg 4
  // [   161,   223] -> [0xFF61,0xFF9F] # seg 5
};

// Reverse
const unsigned short CodePageJISX0201_R[165] = {
  // hot segments (indexes into segment table)
  0,
  // number of segments
  16,
  // segment table
  0x0000, 0x00A1, 0x00A5, 0x00A6, 0x203E, 0x203F, 0x3000, 0x300E,
  0x309B, 0x30FD, 0xFF01, 0xFF5F, 0xFF61, 0xFFA0, 0xFFE3, 0xFFE6,
  // compressed segments
       0,  RCHAR,     92,  RCHAR,    126,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,     33,  RCHAR,    161,  RCHAR,  RCHAR,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,      0,  RCHAR,
      14,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    112,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A5,0x00A5] -> [    92,    92] # seg 2
  // [0x203E,0x203E] -> [   126,   126] # seg 4
  // [0x3000,0x300D] -v # seg 6 at pos 0
      32,    164,    161,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,    162,    163,
  // [0x309B,0x30FC] -v # seg 8 at pos 14
     222,    223,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    167,    177,
     168,    178,    169,    179,    170,    180,    171,    181,
     182,  RCHAR,    183,  RCHAR,    184,  RCHAR,    185,  RCHAR,
     186,  RCHAR,    187,  RCHAR,    188,  RCHAR,    189,  RCHAR,
     190,  RCHAR,    191,  RCHAR,    192,  RCHAR,    193,  RCHAR,
     175,    194,  RCHAR,    195,  RCHAR,    196,  RCHAR,    197,
     198,    199,    200,    201,    202,  RCHAR,  RCHAR,    203,
   RCHAR,  RCHAR,    204,  RCHAR,  RCHAR,    205,  RCHAR,  RCHAR,
     206,  RCHAR,  RCHAR,    207,    208,    209,    210,    211,
     172,    212,    173,    213,    174,    214,    215,    216,
     217,    218,    219,  RCHAR,    220,  RCHAR,  RCHAR,    166,
     221,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     165,    176,
  // [0xFF01,0xFF5E] -> [    33,   126] # seg 10
  // [0xFF61,0xFF9F] -> [   161,   223] # seg 12
  // [0xFFE3,0xFFE5] -v # seg 14 at pos 112
     126,  RCHAR,     92,
};

// Latin1, Western Europe
const unsigned short CodePageISO8859_1[6] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  1,
  // segment table
       0,
  // compressed segments
  0x0000,
  // uncompressed segments
   RCHAR,
  // [     0,   255] -> [0x0000,0x00FF] # seg 0
};

// Reverse
const unsigned short CodePageISO8859_1_R[9] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  2,
  // segment table
  0x0000, 0x0100,
  // compressed segments
       0,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,
  // [0x0000,0x00FF] -> [     0,   255] # seg 0
};

// Latin2, Central Europe
const unsigned short CodePageISO8859_2[106] = {
  // hot segments (indexes into segment table)
  2, 0, 1,
  // number of segments
  2,
  // segment table
       0,    160,
  // compressed segments
  0x0000,  RCHAR,
  // uncompressed segments
   RCHAR, 0x0000,
  // [     0,   159] -> [0x0000,0x009F] # seg 0
  // [   160,   255] -v # seg 1 at pos 0
  0x00A0, 0x0104, 0x02D8, 0x0141, 0x00A4, 0x013D, 0x015A, 0x00A7,
  0x00A8, 0x0160, 0x015E, 0x0164, 0x0179, 0x00AD, 0x017D, 0x017B,
  0x00B0, 0x0105, 0x02DB, 0x0142, 0x00B4, 0x013E, 0x015B, 0x02C7,
  0x00B8, 0x0161, 0x015F, 0x0165, 0x017A, 0x02DD, 0x017E, 0x017C,
  0x0154, 0x00C1, 0x00C2, 0x0102, 0x00C4, 0x0139, 0x0106, 0x00C7,
  0x010C, 0x00C9, 0x0118, 0x00CB, 0x011A, 0x00CD, 0x00CE, 0x010E,
  0x0110, 0x0143, 0x0147, 0x00D3, 0x00D4, 0x0150, 0x00D6, 0x00D7,
  0x0158, 0x016E, 0x00DA, 0x0170, 0x00DC, 0x00DD, 0x0162, 0x00DF,
  0x0155, 0x00E1, 0x00E2, 0x0103, 0x00E4, 0x013A, 0x0107, 0x00E7,
  0x010D, 0x00E9, 0x0119, 0x00EB, 0x011B, 0x00ED, 0x00EE, 0x010F,
  0x0111, 0x0144, 0x0148, 0x00F3, 0x00F4, 0x0151, 0x00F6, 0x00F7,
  0x0159, 0x016F, 0x00FA, 0x0171, 0x00FC, 0x00FD, 0x0163, 0x02D9,
};

// Reverse
const unsigned short CodePageISO8859_2_R[229] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  10,
  // segment table
  0x0000, 0x00A1, 0x00A4, 0x011C, 0x0139, 0x017F, 0x02C7, 0x02C8,
  0x02D8, 0x02DE,
  // compressed segments
       0,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    183,  RCHAR,
   RCHAR,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,      0,  RCHAR,    120,  RCHAR,  RCHAR,  RCHAR,
     190,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A4,0x011B] -v # seg 2 at pos 0
     164,  RCHAR,  RCHAR,    167,    168,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    173,  RCHAR,  RCHAR,    176,  RCHAR,  RCHAR,  RCHAR,
     180,  RCHAR,  RCHAR,  RCHAR,    184,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    193,    194,  RCHAR,
     196,  RCHAR,  RCHAR,    199,  RCHAR,    201,  RCHAR,    203,
   RCHAR,    205,    206,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    211,
     212,  RCHAR,    214,    215,  RCHAR,  RCHAR,    218,  RCHAR,
     220,    221,  RCHAR,    223,  RCHAR,    225,    226,  RCHAR,
     228,  RCHAR,  RCHAR,    231,  RCHAR,    233,  RCHAR,    235,
   RCHAR,    237,    238,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    243,
     244,  RCHAR,    246,    247,  RCHAR,  RCHAR,    250,  RCHAR,
     252,    253,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    195,    227,
     161,    177,    198,    230,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     200,    232,    207,    239,    208,    240,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,    202,    234,    204,    236,
  // [0x0139,0x017E] -v # seg 4 at pos 120
     197,    229,  RCHAR,  RCHAR,    165,    181,  RCHAR,  RCHAR,
     163,    179,    209,    241,  RCHAR,  RCHAR,    210,    242,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    213,
     245,  RCHAR,  RCHAR,    192,    224,  RCHAR,  RCHAR,    216,
     248,    166,    182,  RCHAR,  RCHAR,    170,    186,    169,
     185,    222,    254,    171,    187,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    217,    249,    219,
     251,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     172,    188,    175,    191,    174,    190,
  // [0x02C7,0x02C7] -> [   183,   183] # seg 6
  // [0x02D8,0x02DD] -v # seg 8 at pos 190
     162,    255,  RCHAR,    178,  RCHAR,    189,
};

// Latin3, Maltese
const unsigned short CodePageISO8859_3[106] = {
  // hot segments (indexes into segment table)
  2, 0, 1,
  // number of segments
  2,
  // segment table
       0,    160,
  // compressed segments
  0x0000,  RCHAR,
  // uncompressed segments
   RCHAR, 0x0000,
  // [     0,   159] -> [0x0000,0x009F] # seg 0
  // [   160,   255] -v # seg 1 at pos 0
  0x00A0, 0x0126, 0x02D8, 0x00A3, 0x00A4,  RCHAR, 0x0124, 0x00A7,
  0x00A8, 0x0130, 0x015E, 0x011E, 0x0134, 0x00AD,  RCHAR, 0x017B,
  0x00B0, 0x0127, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x0125, 0x00B7,
  0x00B8, 0x0131, 0x015F, 0x011F, 0x0135, 0x00BD,  RCHAR, 0x017C,
  0x00C0, 0x00C1, 0x00C2,  RCHAR, 0x00C4, 0x010A, 0x0108, 0x00C7,
  0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
   RCHAR, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x0120, 0x00D6, 0x00D7,
  0x011C, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x016C, 0x015C, 0x00DF,
  0x00E0, 0x00E1, 0x00E2,  RCHAR, 0x00E4, 0x010B, 0x0109, 0x00E7,
  0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
   RCHAR, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x0121, 0x00F6, 0x00F7,
  0x011D, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x016D, 0x015D, 0x02D9,
};

// Reverse
const unsigned short CodePageISO8859_3_R[199] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  10,
  // segment table
  0x0000, 0x00A1, 0x00A3, 0x010C, 0x011C, 0x0136, 0x015C, 0x017D,
  0x02D8, 0x02DA,
  // compressed segments
       0,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,      0,  RCHAR,    105,  RCHAR,    131,  RCHAR,
     164,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A3,0x010B] -v # seg 2 at pos 0
     163,    164,  RCHAR,  RCHAR,    167,    168,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    173,  RCHAR,  RCHAR,    176,  RCHAR,    178,
     179,    180,    181,  RCHAR,    183,    184,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    189,  RCHAR,  RCHAR,    192,    193,    194,
   RCHAR,    196,  RCHAR,  RCHAR,    199,    200,    201,    202,
     203,    204,    205,    206,    207,  RCHAR,    209,    210,
     211,    212,  RCHAR,    214,    215,  RCHAR,    217,    218,
     219,    220,  RCHAR,  RCHAR,    223,    224,    225,    226,
   RCHAR,    228,  RCHAR,  RCHAR,    231,    232,    233,    234,
     235,    236,    237,    238,    239,  RCHAR,    241,    242,
     243,    244,  RCHAR,    246,    247,  RCHAR,    249,    250,
     251,    252,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    198,    230,    197,
     229,
  // [0x011C,0x0135] -v # seg 4 at pos 105
     216,    248,    171,    187,    213,    245,  RCHAR,  RCHAR,
     166,    182,    161,    177,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,    169,    185,  RCHAR,  RCHAR,
     172,    188,
  // [0x015C,0x017C] -v # seg 6 at pos 131
     222,    254,    170,    186,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     221,    253,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    175,
     191,
  // [0x02D8,0x02D9] -v # seg 8 at pos 164
     162,    255,
};

// Latin4, Northern Europe
const unsigned short CodePageISO8859_4[106] = {
  // hot segments (indexes into segment table)
  2, 0, 1,
  // number of segments
  2,
  // segment table
       0,    160,
  // compressed segments
  0x0000,  RCHAR,
  // uncompressed segments
   RCHAR, 0x0000,
  // [     0,   159] -> [0x0000,0x009F] # seg 0
  // [   160,   255] -v # seg 1 at pos 0
  0x00A0, 0x0104, 0x0138, 0x0156, 0x00A4, 0x0128, 0x013B, 0x00A7,
  0x00A8, 0x0160, 0x0112, 0x0122, 0x0166, 0x00AD, 0x017D, 0x00AF,
  0x00B0, 0x0105, 0x02DB, 0x0157, 0x00B4, 0x0129, 0x013C, 0x02C7,
  0x00B8, 0x0161, 0x0113, 0x0123, 0x0167, 0x014A, 0x017E, 0x014B,
  0x0100, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x012E,
  0x010C, 0x00C9, 0x0118, 0x00CB, 0x0116, 0x00CD, 0x00CE, 0x012A,
  0x0110, 0x0145, 0x014C, 0x0136, 0x00D4, 0x00D5, 0x00D6, 0x00D7,
  0x00D8, 0x0172, 0x00DA, 0x00DB, 0x00DC, 0x0168, 0x016A, 0x00DF,
  0x0101, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x012F,
  0x010D, 0x00E9, 0x0119, 0x00EB, 0x0117, 0x00ED, 0x00EE, 0x012B,
  0x0111, 0x0146, 0x014D, 0x0137, 0x00F4, 0x00F5, 0x00F6, 0x00F7,
  0x00F8, 0x0173, 0x00FA, 0x00FB, 0x00FC, 0x0169, 0x016B, 0x02D9,
};

// Reverse
const unsigned short CodePageISO8859_4_R[249] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  8,
  // segment table
  0x0000, 0x00A1, 0x00A4, 0x017F, 0x02C7, 0x02C8, 0x02D9, 0x02DC,
  // compressed segments
       0,  RCHAR,  RCHAR,  RCHAR,    183,  RCHAR,  RCHAR,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,      0,  RCHAR,  RCHAR,  RCHAR,    219,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A4,0x017E] -v # seg 2 at pos 0
     164,  RCHAR,  RCHAR,    167,    168,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    173,  RCHAR,    175,    176,  RCHAR,  RCHAR,  RCHAR,
     180,  RCHAR,  RCHAR,  RCHAR,    184,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    193,    194,    195,
     196,    197,    198,  RCHAR,  RCHAR,    201,  RCHAR,    203,
   RCHAR,    205,    206,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     212,    213,    214,    215,    216,  RCHAR,    218,    219,
     220,  RCHAR,  RCHAR,    223,  RCHAR,    225,    226,    227,
     228,    229,    230,  RCHAR,  RCHAR,    233,  RCHAR,    235,
   RCHAR,    237,    238,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     244,    245,    246,    247,    248,  RCHAR,    250,    251,
     252,  RCHAR,  RCHAR,  RCHAR,    192,    224,  RCHAR,  RCHAR,
     161,    177,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     200,    232,  RCHAR,  RCHAR,    208,    240,    170,    186,
   RCHAR,  RCHAR,    204,    236,    202,    234,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    171,    187,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,    165,    181,    207,    239,
   RCHAR,  RCHAR,    199,    231,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    211,    243,    162,  RCHAR,  RCHAR,    166,
     182,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    209,    241,  RCHAR,  RCHAR,  RCHAR,    189,    191,
     210,    242,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    163,    179,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,    169,    185,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    172,    188,    221,    253,    222,    254,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    217,    249,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    174,    190,
  // [0x02C7,0x02C7] -> [   183,   183] # seg 4
  // [0x02D9,0x02DB] -v # seg 6 at pos 219
     255,  RCHAR,    178,
};

// Cyrillic
const unsigned short CodePageISO8859_5[27] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  8,
  // segment table
       0,    161,    173,    174,    240,    241,    253,    254,
  // compressed segments
  0x0000, 0x0401, 0x00AD, 0x040E, 0x2116, 0x0451, 0x00A7, 0x045E,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [     0,   160] -> [0x0000,0x00A0] # seg 0
  // [   161,   172] -> [0x0401,0x040C] # seg 1
  // [   173,   173] -> [0x00AD,0x00AD] # seg 2
  // [   174,   239] -> [0x040E,0x044F] # seg 3
  // [   240,   240] -> [0x2116,0x2116] # seg 4
  // [   241,   252] -> [0x0451,0x045C] # seg 5
  // [   253,   253] -> [0x00A7,0x00A7] # seg 6
  // [   254,   255] -> [0x045E,0x045F] # seg 7
};

// Reverse
const unsigned short CodePageISO8859_5_R[51] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  16,
  // segment table
  0x0000, 0x00A1, 0x00A7, 0x00A8, 0x00AD, 0x00AE, 0x0401, 0x040D,
  0x040E, 0x0450, 0x0451, 0x045D, 0x045E, 0x0460, 0x2116, 0x2117,
  // compressed segments
       0,  RCHAR,    253,  RCHAR,    173,  RCHAR,    161,  RCHAR,
     174,  RCHAR,    241,  RCHAR,    254,  RCHAR,    240,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A7,0x00A7] -> [   253,   253] # seg 2
  // [0x00AD,0x00AD] -> [   173,   173] # seg 4
  // [0x0401,0x040C] -> [   161,   172] # seg 6
  // [0x040E,0x044F] -> [   174,   239] # seg 8
  // [0x0451,0x045C] -> [   241,   252] # seg 10
  // [0x045E,0x045F] -> [   254,   255] # seg 12
  // [0x2116,0x2116] -> [   240,   240] # seg 14
};

// Arabic
const unsigned short CodePageISO8859_6[48] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  15,
  // segment table
       0,    161,    164,    165,    172,    173,    174,    187,
     188,    191,    192,    193,    219,    224,    243,
  // compressed segments
  0x0000,  RCHAR, 0x00A4,  RCHAR, 0x060C, 0x00AD,  RCHAR, 0x061B,
   RCHAR, 0x061F,  RCHAR, 0x0621,  RCHAR, 0x0640,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [     0,   160] -> [0x0000,0x00A0] # seg 0
  // [   164,   164] -> [0x00A4,0x00A4] # seg 2
  // [   172,   172] -> [0x060C,0x060C] # seg 4
  // [   173,   173] -> [0x00AD,0x00AD] # seg 5
  // [   187,   187] -> [0x061B,0x061B] # seg 7
  // [   191,   191] -> [0x061F,0x061F] # seg 9
  // [   193,   218] -> [0x0621,0x063A] # seg 11
  // [   224,   242] -> [0x0640,0x0652] # seg 13
};

// Reverse
const unsigned short CodePageISO8859_6_R[51] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  16,
  // segment table
  0x0000, 0x00A1, 0x00A4, 0x00A5, 0x00AD, 0x00AE, 0x060C, 0x060D,
  0x061B, 0x061C, 0x061F, 0x0620, 0x0621, 0x063B, 0x0640, 0x0653,
  // compressed segments
       0,  RCHAR,    164,  RCHAR,    173,  RCHAR,    172,  RCHAR,
     187,  RCHAR,    191,  RCHAR,    193,  RCHAR,    224,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A4,0x00A4] -> [   164,   164] # seg 2
  // [0x00AD,0x00AD] -> [   173,   173] # seg 4
  // [0x060C,0x060C] -> [   172,   172] # seg 6
  // [0x061B,0x061B] -> [   187,   187] # seg 8
  // [0x061F,0x061F] -> [   191,   191] # seg 10
  // [0x0621,0x063A] -> [   193,   218] # seg 12
  // [0x0640,0x0652] -> [   224,   242] # seg 14
};

// Greek
const unsigned short CodePageISO8859_7[66] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  21,
  // segment table
       0,    161,    163,    164,    165,    166,    170,    171,
     174,    175,    176,    180,    183,    184,    187,    188,
     189,    190,    210,    211,    255,
  // compressed segments
  0x0000, 0x2018, 0x00A3, 0x20AC, 0x20AF, 0x00A6, 0x037A, 0x00AB,
   RCHAR, 0x2015, 0x00B0, 0x0384, 0x00B7, 0x0388, 0x00BB, 0x038C,
  0x00BD, 0x038E,  RCHAR, 0x03A3,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [     0,   160] -> [0x0000,0x00A0] # seg 0
  // [   161,   162] -> [0x2018,0x2019] # seg 1
  // [   163,   163] -> [0x00A3,0x00A3] # seg 2
  // [   164,   164] -> [0x20AC,0x20AC] # seg 3
  // [   165,   165] -> [0x20AF,0x20AF] # seg 4
  // [   166,   169] -> [0x00A6,0x00A9] # seg 5
  // [   170,   170] -> [0x037A,0x037A] # seg 6
  // [   171,   173] -> [0x00AB,0x00AD] # seg 7
  // [   175,   175] -> [0x2015,0x2015] # seg 9
  // [   176,   179] -> [0x00B0,0x00B3] # seg 10
  // [   180,   182] -> [0x0384,0x0386] # seg 11
  // [   183,   183] -> [0x00B7,0x00B7] # seg 12
  // [   184,   186] -> [0x0388,0x038A] # seg 13
  // [   187,   187] -> [0x00BB,0x00BB] # seg 14
  // [   188,   188] -> [0x038C,0x038C] # seg 15
  // [   189,   189] -> [0x00BD,0x00BD] # seg 16
  // [   190,   209] -> [0x038E,0x03A1] # seg 17
  // [   211,   254] -> [0x03A3,0x03CE] # seg 19
};

// Reverse
const unsigned short CodePageISO8859_7_R[111] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  36,
  // segment table
  0x0000, 0x00A1, 0x00A3, 0x00A4, 0x00A6, 0x00AA, 0x00AB, 0x00AE,
  0x00B0, 0x00B4, 0x00B7, 0x00B8, 0x00BB, 0x00BC, 0x00BD, 0x00BE,
  0x037A, 0x037B, 0x0384, 0x0387, 0x0388, 0x038B, 0x038C, 0x038D,
  0x038E, 0x03A2, 0x03A3, 0x03CF, 0x2015, 0x2016, 0x2018, 0x201A,
  0x20AC, 0x20AD, 0x20AF, 0x20B0,
  // compressed segments
       0,  RCHAR,    163,  RCHAR,    166,  RCHAR,    171,  RCHAR,
     176,  RCHAR,    183,  RCHAR,    187,  RCHAR,    189,  RCHAR,
     170,  RCHAR,    180,  RCHAR,    184,  RCHAR,    188,  RCHAR,
     190,  RCHAR,    211,  RCHAR,    175,  RCHAR,    161,  RCHAR,
     164,  RCHAR,    165,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A3,0x00A3] -> [   163,   163] # seg 2
  // [0x00A6,0x00A9] -> [   166,   169] # seg 4
  // [0x00AB,0x00AD] -> [   171,   173] # seg 6
  // [0x00B0,0x00B3] -> [   176,   179] # seg 8
  // [0x00B7,0x00B7] -> [   183,   183] # seg 10
  // [0x00BB,0x00BB] -> [   187,   187] # seg 12
  // [0x00BD,0x00BD] -> [   189,   189] # seg 14
  // [0x037A,0x037A] -> [   170,   170] # seg 16
  // [0x0384,0x0386] -> [   180,   182] # seg 18
  // [0x0388,0x038A] -> [   184,   186] # seg 20
  // [0x038C,0x038C] -> [   188,   188] # seg 22
  // [0x038E,0x03A1] -> [   190,   209] # seg 24
  // [0x03A3,0x03CE] -> [   211,   254] # seg 26
  // [0x2015,0x2015] -> [   175,   175] # seg 28
  // [0x2018,0x2019] -> [   161,   162] # seg 30
  // [0x20AC,0x20AC] -> [   164,   164] # seg 32
  // [0x20AF,0x20AF] -> [   165,   165] # seg 34
};

// Hebrew
const unsigned short CodePageISO8859_8[42] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  13,
  // segment table
       0,    161,    162,    170,    171,    186,    187,    191,
     223,    224,    251,    253,    255,
  // compressed segments
  0x0000,  RCHAR, 0x00A2, 0x00D7, 0x00AB, 0x00F7, 0x00BB,  RCHAR,
  0x2017, 0x05D0,  RCHAR, 0x200E,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [     0,   160] -> [0x0000,0x00A0] # seg 0
  // [   162,   169] -> [0x00A2,0x00A9] # seg 2
  // [   170,   170] -> [0x00D7,0x00D7] # seg 3
  // [   171,   185] -> [0x00AB,0x00B9] # seg 4
  // [   186,   186] -> [0x00F7,0x00F7] # seg 5
  // [   187,   190] -> [0x00BB,0x00BE] # seg 6
  // [   223,   223] -> [0x2017,0x2017] # seg 8
  // [   224,   250] -> [0x05D0,0x05EA] # seg 9
  // [   253,   254] -> [0x200E,0x200F] # seg 11
};

// Reverse
const unsigned short CodePageISO8859_8_R[57] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  18,
  // segment table
  0x0000, 0x00A1, 0x00A2, 0x00AA, 0x00AB, 0x00BA, 0x00BB, 0x00BF,
  0x00D7, 0x00D8, 0x00F7, 0x00F8, 0x05D0, 0x05EB, 0x200E, 0x2010,
  0x2017, 0x2018,
  // compressed segments
       0,  RCHAR,    162,  RCHAR,    171,  RCHAR,    187,  RCHAR,
     170,  RCHAR,    186,  RCHAR,    224,  RCHAR,    253,  RCHAR,
     223,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A2,0x00A9] -> [   162,   169] # seg 2
  // [0x00AB,0x00B9] -> [   171,   185] # seg 4
  // [0x00BB,0x00BE] -> [   187,   190] # seg 6
  // [0x00D7,0x00D7] -> [   170,   170] # seg 8
  // [0x00F7,0x00F7] -> [   186,   186] # seg 10
  // [0x05D0,0x05EA] -> [   224,   250] # seg 12
  // [0x200E,0x200F] -> [   253,   254] # seg 14
  // [0x2017,0x2017] -> [   223,   223] # seg 16
};

// Latin5, Turkish
const unsigned short CodePageISO8859_9[36] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  11,
  // segment table
       0,    208,    209,    221,    222,    223,    240,    241,
     253,    254,    255,
  // compressed segments
  0x0000, 0x011E, 0x00D1, 0x0130, 0x015E, 0x00DF, 0x011F, 0x00F1,
  0x0131, 0x015F, 0x00FF,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,
  // [     0,   207] -> [0x0000,0x00CF] # seg 0
  // [   208,   208] -> [0x011E,0x011E] # seg 1
  // [   209,   220] -> [0x00D1,0x00DC] # seg 2
  // [   221,   221] -> [0x0130,0x0130] # seg 3
  // [   222,   222] -> [0x015E,0x015E] # seg 4
  // [   223,   239] -> [0x00DF,0x00EF] # seg 5
  // [   240,   240] -> [0x011F,0x011F] # seg 6
  // [   241,   252] -> [0x00F1,0x00FC] # seg 7
  // [   253,   253] -> [0x0131,0x0131] # seg 8
  // [   254,   254] -> [0x015F,0x015F] # seg 9
  // [   255,   255] -> [0x00FF,0x00FF] # seg 10
};

// Reverse
const unsigned short CodePageISO8859_9_R[60] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  19,
  // segment table
  0x0000, 0x00D0, 0x00D1, 0x00DD, 0x00DF, 0x00F0, 0x00F1, 0x00FD,
  0x00FF, 0x0100, 0x011E, 0x011F, 0x0120, 0x0130, 0x0131, 0x0132,
  0x015E, 0x015F, 0x0160,
  // compressed segments
       0,  RCHAR,    209,  RCHAR,    223,  RCHAR,    241,  RCHAR,
     255,  RCHAR,    208,    240,  RCHAR,    221,    253,  RCHAR,
     222,    254,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,
  // [0x0000,0x00CF] -> [     0,   207] # seg 0
  // [0x00D1,0x00DC] -> [   209,   220] # seg 2
  // [0x00DF,0x00EF] -> [   223,   239] # seg 4
  // [0x00F1,0x00FC] -> [   241,   252] # seg 6
  // [0x00FF,0x00FF] -> [   255,   255] # seg 8
  // [0x011E,0x011E] -> [   208,   208] # seg 10
  // [0x011F,0x011F] -> [   240,   240] # seg 11
  // [0x0130,0x0130] -> [   221,   221] # seg 13
  // [0x0131,0x0131] -> [   253,   253] # seg 14
  // [0x015E,0x015E] -> [   222,   222] # seg 16
  // [0x015F,0x015F] -> [   254,   254] # seg 17
};

// Latin6, Nordic Europe
const unsigned short CodePageISO8859_10[106] = {
  // hot segments (indexes into segment table)
  2, 0, 1,
  // number of segments
  2,
  // segment table
       0,    160,
  // compressed segments
  0x0000,  RCHAR,
  // uncompressed segments
   RCHAR, 0x0000,
  // [     0,   159] -> [0x0000,0x009F] # seg 0
  // [   160,   255] -v # seg 1 at pos 0
  0x00A0, 0x0104, 0x0112, 0x0122, 0x012A, 0x0128, 0x0136, 0x00A7,
  0x013B, 0x0110, 0x0160, 0x0166, 0x017D, 0x00AD, 0x016A, 0x014A,
  0x00B0, 0x0105, 0x0113, 0x0123, 0x012B, 0x0129, 0x0137, 0x00B7,
  0x013C, 0x0111, 0x0161, 0x0167, 0x017E, 0x2015, 0x016B, 0x014B,
  0x0100, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x012E,
  0x010C, 0x00C9, 0x0118, 0x00CB, 0x0116, 0x00CD, 0x00CE, 0x00CF,
  0x00D0, 0x0145, 0x014C, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x0168,
  0x00D8, 0x0172, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x00DE, 0x00DF,
  0x0101, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x012F,
  0x010D, 0x00E9, 0x0119, 0x00EB, 0x0117, 0x00ED, 0x00EE, 0x00EF,
  0x00F0, 0x0146, 0x014D, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x0169,
  0x00F8, 0x0173, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x00FE, 0x0138,
};

// Reverse
const unsigned short CodePageISO8859_10_R[225] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  8,
  // segment table
  0x0000, 0x00A1, 0x00A7, 0x014E, 0x0160, 0x017F, 0x2015, 0x2016,
  // compressed segments
       0,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    189,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,      0,  RCHAR,    167,  RCHAR,  RCHAR,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A7,0x014D] -v # seg 2 at pos 0
     167,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    173,  RCHAR,
   RCHAR,    176,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     183,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    193,    194,    195,    196,    197,    198,
   RCHAR,  RCHAR,    201,  RCHAR,    203,  RCHAR,    205,    206,
     207,    208,  RCHAR,  RCHAR,    211,    212,    213,    214,
   RCHAR,    216,  RCHAR,    218,    219,    220,    221,    222,
     223,  RCHAR,    225,    226,    227,    228,    229,    230,
   RCHAR,  RCHAR,    233,  RCHAR,    235,  RCHAR,    237,    238,
     239,    240,  RCHAR,  RCHAR,    243,    244,    245,    246,
   RCHAR,    248,  RCHAR,    250,    251,    252,    253,    254,
   RCHAR,    192,    224,  RCHAR,  RCHAR,    161,    177,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    200,    232,  RCHAR,
   RCHAR,    169,    185,    162,    178,  RCHAR,  RCHAR,    204,
     236,    202,    234,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,    163,    179,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    165,    181,    164,    180,  RCHAR,  RCHAR,    199,
     231,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    166,
     182,    255,  RCHAR,  RCHAR,    168,    184,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    209,    241,
   RCHAR,  RCHAR,  RCHAR,    175,    191,    210,    242,
  // [0x0160,0x017E] -v # seg 4 at pos 167
     170,    186,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    171,    187,
     215,    247,    174,    190,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    217,    249,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    172,    188,
  // [0x2015,0x2015] -> [   189,   189] # seg 6
};

// Thai, from TIS-620
const unsigned short CodePageISO8859_11[18] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  5,
  // segment table
       0,    161,    219,    223,    252,
  // compressed segments
  0x0000, 0x0E01,  RCHAR, 0x0E3F,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [     0,   160] -> [0x0000,0x00A0] # seg 0
  // [   161,   218] -> [0x0E01,0x0E3A] # seg 1
  // [   223,   251] -> [0x0E3F,0x0E5B] # seg 3
};

// Reverse
const unsigned short CodePageISO8859_11_R[21] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  6,
  // segment table
  0x0000, 0x00A1, 0x0E01, 0x0E3B, 0x0E3F, 0x0E5C,
  // compressed segments
       0,  RCHAR,    161,  RCHAR,    223,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x0E01,0x0E3A] -> [   161,   218] # seg 2
  // [0x0E3F,0x0E5B] -> [   223,   251] # seg 4
};

// Latin7, Baltic Rim
const unsigned short CodePageISO8859_13[106] = {
  // hot segments (indexes into segment table)
  2, 0, 1,
  // number of segments
  2,
  // segment table
       0,    160,
  // compressed segments
  0x0000,  RCHAR,
  // uncompressed segments
   RCHAR, 0x0000,
  // [     0,   159] -> [0x0000,0x009F] # seg 0
  // [   160,   255] -v # seg 1 at pos 0
  0x00A0, 0x201D, 0x00A2, 0x00A3, 0x00A4, 0x201E, 0x00A6, 0x00A7,
  0x00D8, 0x00A9, 0x0156, 0x00AB, 0x00AC, 0x00AD, 0x00AE, 0x00C6,
  0x00B0, 0x00B1, 0x00B2, 0x00B3, 0x201C, 0x00B5, 0x00B6, 0x00B7,
  0x00F8, 0x00B9, 0x0157, 0x00BB, 0x00BC, 0x00BD, 0x00BE, 0x00E6,
  0x0104, 0x012E, 0x0100, 0x0106, 0x00C4, 0x00C5, 0x0118, 0x0112,
  0x010C, 0x00C9, 0x0179, 0x0116, 0x0122, 0x0136, 0x012A, 0x013B,
  0x0160, 0x0143, 0x0145, 0x00D3, 0x014C, 0x00D5, 0x00D6, 0x00D7,
  0x0172, 0x0141, 0x015A, 0x016A, 0x00DC, 0x017B, 0x017D, 0x00DF,
  0x0105, 0x012F, 0x0101, 0x0107, 0x00E4, 0x00E5, 0x0119, 0x0113,
  0x010D, 0x00E9, 0x017A, 0x0117, 0x0123, 0x0137, 0x012B, 0x013C,
  0x0161, 0x0144, 0x0146, 0x00F3, 0x014D, 0x00F5, 0x00F6, 0x00F7,
  0x0173, 0x0142, 0x015B, 0x016B, 0x00FC, 0x017C, 0x017E, 0x2019,
};

// Reverse
const unsigned short CodePageISO8859_13_R[248] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  6,
  // segment table
  0x0000, 0x00A1, 0x00A2, 0x017F, 0x2019, 0x201F,
  // compressed segments
       0,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,      0,  RCHAR,    221,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A2,0x017E] -v # seg 2 at pos 0
     162,    163,    164,  RCHAR,    166,    167,  RCHAR,    169,
   RCHAR,    171,    172,    173,    174,  RCHAR,    176,    177,
     178,    179,  RCHAR,    181,    182,    183,  RCHAR,    185,
   RCHAR,    187,    188,    189,    190,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    196,    197,    175,  RCHAR,  RCHAR,    201,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    211,  RCHAR,    213,    214,    215,    168,  RCHAR,
   RCHAR,  RCHAR,    220,  RCHAR,  RCHAR,    223,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    228,    229,    191,  RCHAR,  RCHAR,    233,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    243,  RCHAR,    245,    246,    247,    184,  RCHAR,
   RCHAR,  RCHAR,    252,  RCHAR,  RCHAR,  RCHAR,    194,    226,
   RCHAR,  RCHAR,    192,    224,    195,    227,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    200,    232,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     199,    231,  RCHAR,  RCHAR,    203,    235,    198,    230,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     204,    236,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     206,    238,  RCHAR,  RCHAR,    193,    225,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,    205,    237,  RCHAR,  RCHAR,
   RCHAR,    207,    239,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    217,
     249,    209,    241,    210,    242,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    212,    244,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,    170,    186,  RCHAR,  RCHAR,
     218,    250,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    208,    240,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     219,    251,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     216,    248,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    202,
     234,    221,    253,    222,    254,
  // [0x2019,0x201E] -v # seg 4 at pos 221
     255,  RCHAR,  RCHAR,    180,    161,    165,
};

// Latin8, Celtic
const unsigned short CodePageISO8859_14[106] = {
  // hot segments (indexes into segment table)
  2, 0, 1,
  // number of segments
  2,
  // segment table
       0,    160,
  // compressed segments
  0x0000,  RCHAR,
  // uncompressed segments
   RCHAR, 0x0000,
  // [     0,   159] -> [0x0000,0x009F] # seg 0
  // [   160,   255] -v # seg 1 at pos 0
  0x00A0, 0x1E02, 0x1E03, 0x00A3, 0x010A, 0x010B, 0x1E0A, 0x00A7,
  0x1E80, 0x00A9, 0x1E82, 0x1E0B, 0x1EF2, 0x00AD, 0x00AE, 0x0178,
  0x1E1E, 0x1E1F, 0x0120, 0x0121, 0x1E40, 0x1E41, 0x00B6, 0x1E56,
  0x1E81, 0x1E57, 0x1E83, 0x1E60, 0x1EF3, 0x1E84, 0x1E85, 0x1E61,
  0x00C0, 0x00C1, 0x00C2, 0x00C3, 0x00C4, 0x00C5, 0x00C6, 0x00C7,
  0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
  0x0174, 0x00D1, 0x00D2, 0x00D3, 0x00D4, 0x00D5, 0x00D6, 0x1E6A,
  0x00D8, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x00DD, 0x0176, 0x00DF,
  0x00E0, 0x00E1, 0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7,
  0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
  0x0175, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F5, 0x00F6, 0x1E6B,
  0x00F8, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x00FD, 0x0177, 0x00FF,
};

// Reverse
const unsigned short CodePageISO8859_14_R[204] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  23,
  // segment table
  0x0000, 0x00A1, 0x00A3, 0x00DF, 0x00F0, 0x00F1, 0x010C, 0x0120,
  0x0122, 0x0174, 0x0179, 0x1E02, 0x1E0C, 0x1E1E, 0x1E20, 0x1E40,
  0x1E42, 0x1E56, 0x1E6C, 0x1E80, 0x1E86, 0x1EF2, 0x1EF4,
  // compressed segments
       0,  RCHAR,  RCHAR,    223,  RCHAR,  RCHAR,  RCHAR,    178,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    176,  RCHAR,    180,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,      0,  RCHAR,  RCHAR,     60,  RCHAR,  RCHAR,
   RCHAR,     87,  RCHAR,     92,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    102,  RCHAR,    124,  RCHAR,    130,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A3,0x00DE] -v # seg 2 at pos 0
     163,  RCHAR,  RCHAR,  RCHAR,    167,  RCHAR,    169,  RCHAR,
   RCHAR,  RCHAR,    173,    174,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,    182,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    192,    193,    194,
     195,    196,    197,    198,    199,    200,    201,    202,
     203,    204,    205,    206,    207,  RCHAR,    209,    210,
     211,    212,    213,    214,  RCHAR,    216,    217,    218,
     219,    220,    221,  RCHAR,
  // [0x00DF,0x00EF] -> [   223,   239] # seg 3
  // [0x00F1,0x010B] -v # seg 5 at pos 60
     241,    242,    243,    244,    245,    246,  RCHAR,    248,
     249,    250,    251,    252,    253,  RCHAR,    255,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    164,    165,
  // [0x0120,0x0121] -> [   178,   179] # seg 7
  // [0x0174,0x0178] -v # seg 9 at pos 87
     208,    240,    222,    254,    175,
  // [0x1E02,0x1E0B] -v # seg 11 at pos 92
     161,    162,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     166,    171,
  // [0x1E1E,0x1E1F] -> [   176,   177] # seg 13
  // [0x1E40,0x1E41] -> [   180,   181] # seg 15
  // [0x1E56,0x1E6B] -v # seg 17 at pos 102
     183,    185,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    187,    191,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,    215,    247,
  // [0x1E80,0x1E85] -v # seg 19 at pos 124
     168,    184,    170,    186,    189,    190,
  // [0x1EF2,0x1EF3] -v # seg 21 at pos 130
     172,    188,
};

// Latin9, Euro 1
const unsigned short CodePageISO8859_15[45] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  14,
  // segment table
       0,    164,    165,    166,    167,    168,    169,    180,
     181,    184,    185,    188,    190,    191,
  // compressed segments
  0x0000, 0x20AC, 0x00A5, 0x0160, 0x00A7, 0x0161, 0x00A9, 0x017D,
  0x00B5, 0x017E, 0x00B9, 0x0152, 0x0178, 0x00BF,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [     0,   163] -> [0x0000,0x00A3] # seg 0
  // [   164,   164] -> [0x20AC,0x20AC] # seg 1
  // [   165,   165] -> [0x00A5,0x00A5] # seg 2
  // [   166,   166] -> [0x0160,0x0160] # seg 3
  // [   167,   167] -> [0x00A7,0x00A7] # seg 4
  // [   168,   168] -> [0x0161,0x0161] # seg 5
  // [   169,   179] -> [0x00A9,0x00B3] # seg 6
  // [   180,   180] -> [0x017D,0x017D] # seg 7
  // [   181,   183] -> [0x00B5,0x00B7] # seg 8
  // [   184,   184] -> [0x017E,0x017E] # seg 9
  // [   185,   187] -> [0x00B9,0x00BB] # seg 10
  // [   188,   189] -> [0x0152,0x0153] # seg 11
  // [   190,   190] -> [0x0178,0x0178] # seg 12
  // [   191,   255] -> [0x00BF,0x00FF] # seg 13
};

// Reverse
const unsigned short CodePageISO8859_15_R[81] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  26,
  // segment table
  0x0000, 0x00A4, 0x00A5, 0x00A6, 0x00A7, 0x00A8, 0x00A9, 0x00B4,
  0x00B5, 0x00B8, 0x00B9, 0x00BC, 0x00BF, 0x0100, 0x0152, 0x0154,
  0x0160, 0x0161, 0x0162, 0x0178, 0x0179, 0x017D, 0x017E, 0x017F,
  0x20AC, 0x20AD,
  // compressed segments
       0,  RCHAR,    165,  RCHAR,    167,  RCHAR,    169,  RCHAR,
     181,  RCHAR,    185,  RCHAR,    191,  RCHAR,    188,  RCHAR,
     166,    168,  RCHAR,    190,  RCHAR,    180,    184,  RCHAR,
     164,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,
  // [0x0000,0x00A3] -> [     0,   163] # seg 0
  // [0x00A5,0x00A5] -> [   165,   165] # seg 2
  // [0x00A7,0x00A7] -> [   167,   167] # seg 4
  // [0x00A9,0x00B3] -> [   169,   179] # seg 6
  // [0x00B5,0x00B7] -> [   181,   183] # seg 8
  // [0x00B9,0x00BB] -> [   185,   187] # seg 10
  // [0x00BF,0x00FF] -> [   191,   255] # seg 12
  // [0x0152,0x0153] -> [   188,   189] # seg 14
  // [0x0160,0x0160] -> [   166,   166] # seg 16
  // [0x0161,0x0161] -> [   168,   168] # seg 17
  // [0x0178,0x0178] -> [   190,   190] # seg 19
  // [0x017D,0x017D] -> [   180,   180] # seg 21
  // [0x017E,0x017E] -> [   184,   184] # seg 22
  // [0x20AC,0x20AC] -> [   164,   164] # seg 24
};

// Latin10, Euro 2
const unsigned short CodePageISO8859_16[106] = {
  // hot segments (indexes into segment table)
  2, 0, 1,
  // number of segments
  2,
  // segment table
       0,    160,
  // compressed segments
  0x0000,  RCHAR,
  // uncompressed segments
   RCHAR, 0x0000,
  // [     0,   159] -> [0x0000,0x009F] # seg 0
  // [   160,   255] -v # seg 1 at pos 0
  0x00A0, 0x0104, 0x0105, 0x0141, 0x20AC, 0x201E, 0x0160, 0x00A7,
  0x0161, 0x00A9, 0x0218, 0x00AB, 0x0179, 0x00AD, 0x017A, 0x017B,
  0x00B0, 0x00B1, 0x010C, 0x0142, 0x017D, 0x201D, 0x00B6, 0x00B7,
  0x017E, 0x010D, 0x0219, 0x00BB, 0x0152, 0x0153, 0x0178, 0x017C,
  0x00C0, 0x00C1, 0x00C2, 0x0102, 0x00C4, 0x0106, 0x00C6, 0x00C7,
  0x00C8, 0x00C9, 0x00CA, 0x00CB, 0x00CC, 0x00CD, 0x00CE, 0x00CF,
  0x0110, 0x0143, 0x00D2, 0x00D3, 0x00D4, 0x0150, 0x00D6, 0x015A,
  0x0170, 0x00D9, 0x00DA, 0x00DB, 0x00DC, 0x0118, 0x021A, 0x00DF,
  0x00E0, 0x00E1, 0x00E2, 0x0103, 0x00E4, 0x0107, 0x00E6, 0x00E7,
  0x00E8, 0x00E9, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
  0x0111, 0x0144, 0x00F2, 0x00F3, 0x00F4, 0x0151, 0x00F6, 0x015B,
  0x0171, 0x00F9, 0x00FA, 0x00FB, 0x00FC, 0x0119, 0x021B, 0x00FF,
};

// Reverse
const unsigned short CodePageISO8859_16_R[222] = {
  // hot segments (indexes into segment table)
  1, 0,
  // number of segments
  12,
  // segment table
  0x0000, 0x00A1, 0x00A7, 0x011A, 0x0141, 0x017F, 0x0218, 0x021C,
  0x201D, 0x201F, 0x20AC, 0x20AD,
  // compressed segments
       0,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    164,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,      0,  RCHAR,    115,  RCHAR,    177,  RCHAR,
     181,  RCHAR,  RCHAR,  RCHAR,
  // [0x0000,0x00A0] -> [     0,   160] # seg 0
  // [0x00A7,0x0119] -v # seg 2 at pos 0
     167,  RCHAR,    169,  RCHAR,    171,  RCHAR,    173,  RCHAR,
   RCHAR,    176,    177,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    182,
     183,  RCHAR,  RCHAR,  RCHAR,    187,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    192,    193,    194,  RCHAR,    196,  RCHAR,    198,
     199,    200,    201,    202,    203,    204,    205,    206,
     207,  RCHAR,  RCHAR,    210,    211,    212,  RCHAR,    214,
   RCHAR,  RCHAR,    217,    218,    219,    220,  RCHAR,  RCHAR,
     223,    224,    225,    226,  RCHAR,    228,  RCHAR,    230,
     231,    232,    233,    234,    235,    236,    237,    238,
     239,  RCHAR,  RCHAR,    242,    243,    244,  RCHAR,    246,
   RCHAR,  RCHAR,    249,    250,    251,    252,  RCHAR,  RCHAR,
     255,  RCHAR,  RCHAR,    195,    227,    161,    162,    197,
     229,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    178,    185,  RCHAR,
   RCHAR,    208,    240,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    221,    253,
  // [0x0141,0x017E] -v # seg 4 at pos 115
     163,    179,    209,    241,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    213,
     245,    188,    189,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    215,    247,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    166,
     168,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    216,
     248,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    190,
     172,    174,    175,    191,    180,    184,
  // [0x0218,0x021B] -v # seg 6 at pos 177
     170,    186,    222,    254,
  // [0x201D,0x201E] -v # seg 8 at pos 181
     181,    165,
  // [0x20AC,0x20AC] -> [   164,   164] # seg 10
};

// Korean KS X 1001:1998(codes over 8836 are for CP949 compatibility)
const unsigned short CodePageKSX1001[13389] = {
  // hot segments (indexes into segment table)
  2, 0, 43,
  // number of segments
  358,
  // segment table
       0,    164,    165,    188,    247,    248,    281,    282,
     376,    386,    391,    401,    408,    425,    432,    440,
     457,    538,    564,    574,    584,    594,    604,    643,
     658,    674,    702,    728,    743,    768,    796,    822,
     837,    846,    929,    940,   1026,   1034,   1041,   1067,
    1082,   1089,   1115,   1410,   3760,   3854,   4650,   4661,
    8742,   8836,   8870,   8880,   8893,   8912,   9103,   9114,
    9120,   9138,   9146,   9173,   9192,   9210,   9237,   9294,
    9341,   9361,   9372,   9387,   9397,   9403,   9430,   9453,
    9464,   9470,   9489,   9517,   9544,   9569,   9580,   9620,
    9630,   9657,   9671,   9701,   9767,   9801,   9857,   9880,
    9903,   9914,   9949,  10011,  10030,  10037,  10064,  10077,
   10087,  10131,  10150,  10197,  10252,  10291,  10302,  10311,
   10334,  10355,  10374,  10393,  10422,  10449,  10469,  10488,
   10495,  10515,  10584,  10611,  10659,  10721,  10756,  10775,
   10810,  10815,  10827,  10840,  10859,  10886,  10889,  10940,
   10955,  10989,  11016,  11032,  11066,  11099,  11109,  11167,
   11181,  11182,  11216,  11276,  11288,  11320,  11336,  11362,
   11432,  11451,  11458,  11485,  11542,  11571,  11628,  11640,
   11674,  11715,  11725,  11730,  11757,  11778,  11793,  11827,
   11909,  11936,  11942,  11961,  11999,  12035,  12083,  12095,
   12133,  12190,  12213,  12235,  12250,  12257,  12276,  12295,
   12305,  12308,  12331,  12353,  12364,  12371,  12398,  12403,
   12415,  12456,  12492,  12545,  12559,  12598,  12617,  12637,
   12643,  12657,  12658,  12692,  12707,  12769,  12796,  12816,
   12837,  12927,  12947,  12966,  13004,  13157,  13169,  13197,
   13209,  13295,  13314,  13398,  13432,  13481,  13508,  13542,
   13567,  13618,  13641,  13662,  13677,  13684,  13703,  13723,
   13733,  13760,  13781,  13800,  13807,  13834,  13837,  13881,
   13897,  13907,  13920,  13931,  14013,  14023,  14123,  14134,
   14392,  14411,  14470,  14497,  14535,  14554,  14583,  14599,
   14623,  14642,  14649,  14676,  14710,  14721,  14735,  14769,
   14823,  14839,  14873,  14892,  14912,  14918,  14937,  14972,
   14997,  15008,  15015,  15034,  15054,  15085,  15112,  15131,
   15165,  15192,  15219,  15234,  15237,  15271,  15342,  15376,
   15418,  15433,  15443,  15459,  15491,  15503,  15537,  15558,
   15573,  15584,  15604,  15623,  15633,  15656,  15714,  15748,
   15805,  15824,  15858,  15916,  15943,  15985,  16005,  16018,
   16037,  16064,  16090,  16102,  16108,  16128,  16167,  16178,
   16193,  16227,  16284,  16304,  16338,  16379,  16394,  16404,
   16427,  16449,  16472,  16499,  16502,  16516,  16523,  16550,
   16570,  16589,  16596,  16623,  16699,  16709,  16764,  16818,
   16922,  16942,  16976,  16979,  17002,  17043,  17063,  17097,
   17156,  17192,  17250,  17270,  17304,  17376,  17386,  17409,
   17419,  17428,  17442,  17541,  17553,  17658,
  // compressed segments
   RCHAR, 0x00AE,  RCHAR, 0xFF01, 0xFFE6, 0xFF3D, 0xFFE3, 0x3131,
  0x2170,  RCHAR, 0x2160,  RCHAR, 0x0391, 0x03A3,  RCHAR, 0x03B1,
   RCHAR,  RCHAR,  RCHAR, 0x3399,  RCHAR, 0x33B0,  RCHAR,  RCHAR,
   RCHAR, 0x3260, 0x24D0, 0x2460,  RCHAR, 0x3200, 0x249C, 0x2474,
   RCHAR, 0x3041,  RCHAR, 0x30A1,  RCHAR,  RCHAR, 0x0416,  RCHAR,
   RCHAR, 0x0436,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0xF939,  RCHAR,
   RCHAR,  RCHAR, 0xAC41,  RCHAR, 0xAC5D,  RCHAR, 0xAD91, 0xAD9E,
  0xADA5, 0xADB8,  RCHAR, 0xADE5,  RCHAR, 0xAE15,  RCHAR, 0xAE8D,
   RCHAR, 0xAEDD,  RCHAR, 0xAEFD,  RCHAR, 0xAF11,  RCHAR, 0xAF51,
  0xAF5E, 0xAF66,  RCHAR, 0xAF9D,  RCHAR, 0xAFDD,  RCHAR, 0xB01E,
  0xB029,  RCHAR, 0xB05E,  RCHAR, 0xB0E6,  RCHAR, 0xB161,  RCHAR,
  0xB19D, 0xB1A9,  RCHAR, 0xB221, 0xB235, 0xB23D,  RCHAR, 0xB26A,
   RCHAR, 0xB2B5,  RCHAR, 0xB31D,  RCHAR, 0xB395,  RCHAR, 0xB3AD,
   RCHAR, 0xB3E9, 0xB3FD,  RCHAR, 0xB435,  RCHAR, 0xB46D, 0xB481,
  0xB489,  RCHAR, 0xB4F9,  RCHAR, 0xB562,  RCHAR, 0xB5D9, 0xB5ED,
   RCHAR, 0xB619,  RCHAR, 0xB635, 0xB649, 0xB665, 0xB669,  RCHAR,
  0xB6B2, 0xB6D5,  RCHAR, 0xB706,  RCHAR, 0xB756,  RCHAR, 0xB7B9,
  0xB7C8, 0xB7CA,  RCHAR, 0xB845,  RCHAR, 0xB87D, 0xB88E,  RCHAR,
  0xB905, 0xB919, 0xB921,  RCHAR, 0xB98F,  RCHAR, 0xBA09, 0xBA16,
   RCHAR, 0xBA79,  RCHAR, 0xBA8D,  RCHAR, 0xBAC9, 0xBADA,  RCHAR,
  0xBB6D,  RCHAR, 0xBB91,  RCHAR, 0xBBD4,  RCHAR, 0xBC51, 0xBC5E,
   RCHAR, 0xBCDD,  RCHAR, 0xBD15, 0xBD25, 0xBD2D,  RCHAR, 0xBD5A,
  0xBD65, 0xBD69,  RCHAR, 0xBDA5, 0xBDB1, 0xBDB9,  RCHAR, 0xBDDD,
   RCHAR, 0xBE20,  RCHAR, 0xBE9A, 0xBEA9,  RCHAR, 0xBEED, 0xBF02,
  0xBF0A, 0xBF1A, 0xBF1E,  RCHAR, 0xBF56, 0xBF95, 0xBFB1,  RCHAR,
  0xBFE2, 0xC03D,  RCHAR, 0xC06A,  RCHAR, 0xC179,  RCHAR, 0xC1B1,
   RCHAR, 0xC235,  RCHAR, 0xC2BA,  RCHAR, 0xC32A, 0xC346,  RCHAR,
  0xC38D, 0xC3C1,  RCHAR, 0xC3F9, 0xC409, 0xC411,  RCHAR, 0xC43E,
  0xC449,  RCHAR, 0xC481, 0xC495, 0xC49D, 0xC4B9, 0xC4BD,  RCHAR,
  0xC502,  RCHAR, 0xC51D,  RCHAR, 0xC5AA,  RCHAR, 0xC661,  RCHAR,
  0xC7ED,  RCHAR, 0xC855,  RCHAR, 0xC8A9,  RCHAR, 0xC8E5,  RCHAR,
  0xC919, 0xC92D, 0xC935,  RCHAR, 0xC97D,  RCHAR, 0xC99E,  RCHAR,
  0xCA19, 0xCA2A,  RCHAR, 0xCA69, 0xCA7E, 0xCA85, 0xCA99,  RCHAR,
  0xCAE1, 0xCAED, 0xCAF5,  RCHAR, 0xCB22,  RCHAR, 0xCB65, 0xCB7A,
  0xCB9D, 0xCBB9, 0xCBD5,  RCHAR, 0xCBEA,  RCHAR, 0xCC76,  RCHAR,
  0xCCD5,  RCHAR, 0xCCF1,  RCHAR, 0xCD2D, 0xCD3A,  RCHAR, 0xCD79,
  0xCD89,  RCHAR, 0xCDB1,  RCHAR, 0xCDD1,  RCHAR, 0xCE36,  RCHAR,
  0xCEAE, 0xCEC2,  RCHAR, 0xCF39,  RCHAR, 0xCF8D,  RCHAR, 0xCFB1,
  0xCFC5,  RCHAR, 0xD005, 0xD012, 0xD019,  RCHAR, 0xD061,  RCHAR,
  0xD082,  RCHAR, 0xD0F9, 0xD10E,  RCHAR, 0xD16D,  RCHAR, 0xD189,
   RCHAR, 0xD1C1, 0xD1D9, 0xD1F5, 0xD1F9,  RCHAR, 0xD211,  RCHAR,
  0xD249, 0xD25D, 0xD265,  RCHAR, 0xD2E6,  RCHAR, 0xD346,  RCHAR,
  0xD409, 0xD41E, 0xD441, 0xD445,  RCHAR, 0xD495, 0xD4AA,  RCHAR,
  0xD518,  RCHAR, 0xD591, 0xD5A6,  RCHAR, 0xD62E,  RCHAR, 0xD65D,
   RCHAR, 0xD675,  RCHAR, 0xD705,  RCHAR,  RCHAR,
  // uncompressed segments
  0x0000,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  0x09D2,  RCHAR, 0x0A23,  RCHAR, 0x0A2D,  RCHAR, 0x0A37,  RCHAR,
  0x0A5E,  RCHAR,  RCHAR,  RCHAR, 0x0A6E,  RCHAR,  RCHAR,  RCHAR,
  0x0A87,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x0A90,  RCHAR,  RCHAR,
  0x0A97,  RCHAR,  RCHAR, 0x00A4,  RCHAR, 0x0A9E,  RCHAR, 0x0DBA,
   RCHAR, 0x1DAB,  RCHAR, 0x1DCD,  RCHAR, 0x1DDA,  RCHAR,  RCHAR,
   RCHAR,  RCHAR, 0x1E99,  RCHAR, 0x1EB4,  RCHAR, 0x1EC6,  RCHAR,
  0x1EFF,  RCHAR, 0x1F13,  RCHAR, 0x1F22,  RCHAR, 0x1F28,  RCHAR,
   RCHAR,  RCHAR, 0x1F3F,  RCHAR, 0x1F5B,  RCHAR, 0x1F74,  RCHAR,
   RCHAR, 0x1F9C,  RCHAR, 0x1FAA,  RCHAR, 0x1FEC,  RCHAR, 0x2024,
   RCHAR,  RCHAR, 0x203B,  RCHAR,  RCHAR,  RCHAR, 0x2079,  RCHAR,
  0x2086,  RCHAR, 0x20B2,  RCHAR, 0x20E1,  RCHAR, 0x2108,  RCHAR,
  0x2111,  RCHAR,  RCHAR, 0x2126,  RCHAR, 0x2143,  RCHAR,  RCHAR,
   RCHAR, 0x2157,  RCHAR, 0x219C,  RCHAR, 0x21CC,  RCHAR,  RCHAR,
  0x21EF,  RCHAR, 0x21F4,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2201,
   RCHAR,  RCHAR, 0x2210,  RCHAR, 0x2220,  RCHAR, 0x2241,  RCHAR,
   RCHAR,  RCHAR, 0x227B,  RCHAR, 0x22B7,  RCHAR,  RCHAR, 0x22D7,
   RCHAR,  RCHAR,  RCHAR, 0x231D,  RCHAR, 0x2356,  RCHAR,  RCHAR,
  0x238F,  RCHAR, 0x23B8,  RCHAR, 0x23BD,  RCHAR,  RCHAR, 0x23D2,
   RCHAR, 0x2424,  RCHAR, 0x242A,  RCHAR, 0x2450,  RCHAR,  RCHAR,
  0x2480,  RCHAR, 0x24B9,  RCHAR,  RCHAR,  RCHAR, 0x24CF,  RCHAR,
   RCHAR,  RCHAR, 0x24E2,  RCHAR,  RCHAR,  RCHAR, 0x24F8,  RCHAR,
  0x24FD,  RCHAR, 0x2526,  RCHAR,  RCHAR, 0x255B,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR, 0x256E,  RCHAR,  RCHAR,  RCHAR, 0x257D,
   RCHAR,  RCHAR, 0x2592,  RCHAR, 0x25A5,  RCHAR, 0x263E,  RCHAR,
  0x265A,  RCHAR, 0x26B0,  RCHAR, 0x2704,  RCHAR,  RCHAR, 0x2735,
   RCHAR,  RCHAR, 0x274E,  RCHAR,  RCHAR,  RCHAR, 0x2763,  RCHAR,
   RCHAR, 0x2777,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x278C,
   RCHAR, 0x279C,  RCHAR, 0x27A9,  RCHAR, 0x27FB,  RCHAR, 0x285F,
   RCHAR, 0x2961,  RCHAR, 0x299C,  RCHAR, 0x29C2,  RCHAR, 0x29DF,
   RCHAR,  RCHAR,  RCHAR, 0x29F7,  RCHAR, 0x2A19,  RCHAR, 0x2A27,
   RCHAR,  RCHAR, 0x2A5D,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2A70,
   RCHAR,  RCHAR,  RCHAR, 0x2A89,  RCHAR, 0x2A9D,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR, 0x2AB8,  RCHAR, 0x2ABB,  RCHAR, 0x2B02,
   RCHAR, 0x2B2C,  RCHAR, 0x2B36,  RCHAR,  RCHAR, 0x2B56,  RCHAR,
   RCHAR, 0x2B6B,  RCHAR, 0x2B7F,  RCHAR, 0x2B89,  RCHAR, 0x2BC3,
   RCHAR,  RCHAR, 0x2BFC,  RCHAR, 0x2C36,  RCHAR, 0x2C60,  RCHAR,
   RCHAR, 0x2C6D,  RCHAR,  RCHAR,  RCHAR, 0x2C87,  RCHAR, 0x2CAE,
   RCHAR, 0x2CBD,  RCHAR,  RCHAR, 0x2CF6,  RCHAR, 0x2D1F,  RCHAR,
  0x2D29,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2D3F,  RCHAR, 0x2D46,
   RCHAR,  RCHAR,  RCHAR, 0x2D5A,  RCHAR, 0x2DA6,  RCHAR, 0x2DDD,
   RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2E45,  RCHAR,  RCHAR, 0x2E6E,
   RCHAR, 0x2EA9,  RCHAR,  RCHAR, 0x2EE3,  RCHAR, 0x2F2B,  RCHAR,
  0x2F42,  RCHAR, 0x2F4B,  RCHAR, 0x2FAE,  RCHAR,
  // [     0,   163] -v # seg 0 at pos 0
  0x3000, 0x3001, 0x3002, 0x00B7, 0x2025, 0x2026, 0x00A8, 0x3003,
  0x00AD, 0x2015, 0x2225, 0xFF3C, 0x223C, 0x2018, 0x2019, 0x201C,
  0x201D, 0x3014, 0x3015, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C,
  0x300D, 0x300E, 0x300F, 0x3010, 0x3011, 0x00B1, 0x00D7, 0x00F7,
  0x2260, 0x2264, 0x2265, 0x221E, 0x2234, 0x00B0, 0x2032, 0x2033,
  0x2103, 0x212B, 0xFFE0, 0xFFE1, 0xFFE5, 0x2642, 0x2640, 0x2220,
  0x22A5, 0x2312, 0x2202, 0x2207, 0x2261, 0x2252, 0x00A7, 0x203B,
  0x2606, 0x2605, 0x25CB, 0x25CF, 0x25CE, 0x25C7, 0x25C6, 0x25A1,
  0x25A0, 0x25B3, 0x25B2, 0x25BD, 0x25BC, 0x2192, 0x2190, 0x2191,
  0x2193, 0x2194, 0x3013, 0x226A, 0x226B, 0x221A, 0x223D, 0x221D,
  0x2235, 0x222B, 0x222C, 0x2208, 0x220B, 0x2286, 0x2287, 0x2282,
  0x2283, 0x222A, 0x2229, 0x2227, 0x2228, 0xFFE2, 0x21D2, 0x21D4,
  0x2200, 0x2203, 0x00B4, 0xFF5E, 0x02C7, 0x02D8, 0x02DD, 0x02DA,
  0x02D9, 0x00B8, 0x02DB, 0x00A1, 0x00BF, 0x02D0, 0x222E, 0x2211,
  0x220F, 0x00A4, 0x2109, 0x2030, 0x25C1, 0x25C0, 0x25B7, 0x25B6,
  0x2664, 0x2660, 0x2661, 0x2665, 0x2667, 0x2663, 0x2299, 0x25C8,
  0x25A3, 0x25D0, 0x25D1, 0x2592, 0x25A4, 0x25A5, 0x25A8, 0x25A7,
  0x25A6, 0x25A9, 0x2668, 0x260F, 0x260E, 0x261C, 0x261E, 0x00B6,
  0x2020, 0x2021, 0x2195, 0x2197, 0x2199, 0x2196, 0x2198, 0x266D,
  0x2669, 0x266A, 0x266C, 0x327F, 0x321C, 0x2116, 0x33C7, 0x2122,
  0x33C2, 0x33D8, 0x2121, 0x20AC,
  // [   164,   164] -> [0x00AE,0x00AE] # seg 1
  // [   188,   246] -> [0xFF01,0xFF3B] # seg 3
  // [   247,   247] -> [0xFFE6,0xFFE6] # seg 4
  // [   248,   280] -> [0xFF3D,0xFF5D] # seg 5
  // [   281,   281] -> [0xFFE3,0xFFE3] # seg 6
  // [   282,   375] -> [0x3131,0x318E] # seg 7
  // [   376,   385] -> [0x2170,0x2179] # seg 8
  // [   391,   400] -> [0x2160,0x2169] # seg 10
  // [   408,   424] -> [0x0391,0x03A1] # seg 12
  // [   425,   431] -> [0x03A3,0x03A9] # seg 13
  // [   440,   456] -> [0x03B1,0x03C1] # seg 15
  // [   594,   603] -> [0x33B0,0x33B9] # seg 21
  // [  1041,  1066] -> [0x0416,0x042F] # seg 38
  // [  1089,  1114] -> [0x0436,0x044F] # seg 41
  // [  1410,  3759] -v # seg 43 at pos 164
  0xAC00, 0xAC01, 0xAC04, 0xAC07, 0xAC08, 0xAC09, 0xAC0A, 0xAC10,
  0xAC11, 0xAC12, 0xAC13, 0xAC14, 0xAC15, 0xAC16, 0xAC17, 0xAC19,
  0xAC1A, 0xAC1B, 0xAC1C, 0xAC1D, 0xAC20, 0xAC24, 0xAC2C, 0xAC2D,
  0xAC2F, 0xAC30, 0xAC31, 0xAC38, 0xAC39, 0xAC3C, 0xAC40, 0xAC4B,
  0xAC4D, 0xAC54, 0xAC58, 0xAC5C, 0xAC70, 0xAC71, 0xAC74, 0xAC77,
  0xAC78, 0xAC7A, 0xAC80, 0xAC81, 0xAC83, 0xAC84, 0xAC85, 0xAC86,
  0xAC89, 0xAC8A, 0xAC8B, 0xAC8C, 0xAC90, 0xAC94, 0xAC9C, 0xAC9D,
  0xAC9F, 0xACA0, 0xACA1, 0xACA8, 0xACA9, 0xACAA, 0xACAC, 0xACAF,
  0xACB0, 0xACB8, 0xACB9, 0xACBB, 0xACBC, 0xACBD, 0xACC1, 0xACC4,
  0xACC8, 0xACCC, 0xACD5, 0xACD7, 0xACE0, 0xACE1, 0xACE4, 0xACE7,
  0xACE8, 0xACEA, 0xACEC, 0xACEF, 0xACF0, 0xACF1, 0xACF3, 0xACF5,
  0xACF6, 0xACFC, 0xACFD, 0xAD00, 0xAD04, 0xAD06, 0xAD0C, 0xAD0D,
  0xAD0F, 0xAD11, 0xAD18, 0xAD1C, 0xAD20, 0xAD29, 0xAD2C, 0xAD2D,
  0xAD34, 0xAD35, 0xAD38, 0xAD3C, 0xAD44, 0xAD45, 0xAD47, 0xAD49,
  0xAD50, 0xAD54, 0xAD58, 0xAD61, 0xAD63, 0xAD6C, 0xAD6D, 0xAD70,
  0xAD73, 0xAD74, 0xAD75, 0xAD76, 0xAD7B, 0xAD7C, 0xAD7D, 0xAD7F,
  0xAD81, 0xAD82, 0xAD88, 0xAD89, 0xAD8C, 0xAD90, 0xAD9C, 0xAD9D,
  0xADA4, 0xADB7, 0xADC0, 0xADC1, 0xADC4, 0xADC8, 0xADD0, 0xADD1,
  0xADD3, 0xADDC, 0xADE0, 0xADE4, 0xADF8, 0xADF9, 0xADFC, 0xADFF,
  0xAE00, 0xAE01, 0xAE08, 0xAE09, 0xAE0B, 0xAE0D, 0xAE14, 0xAE30,
  0xAE31, 0xAE34, 0xAE37, 0xAE38, 0xAE3A, 0xAE40, 0xAE41, 0xAE43,
  0xAE45, 0xAE46, 0xAE4A, 0xAE4C, 0xAE4D, 0xAE4E, 0xAE50, 0xAE54,
  0xAE56, 0xAE5C, 0xAE5D, 0xAE5F, 0xAE60, 0xAE61, 0xAE65, 0xAE68,
  0xAE69, 0xAE6C, 0xAE70, 0xAE78, 0xAE79, 0xAE7B, 0xAE7C, 0xAE7D,
  0xAE84, 0xAE85, 0xAE8C, 0xAEBC, 0xAEBD, 0xAEBE, 0xAEC0, 0xAEC4,
  0xAECC, 0xAECD, 0xAECF, 0xAED0, 0xAED1, 0xAED8, 0xAED9, 0xAEDC,
  0xAEE8, 0xAEEB, 0xAEED, 0xAEF4, 0xAEF8, 0xAEFC, 0xAF07, 0xAF08,
  0xAF0D, 0xAF10, 0xAF2C, 0xAF2D, 0xAF30, 0xAF32, 0xAF34, 0xAF3C,
  0xAF3D, 0xAF3F, 0xAF41, 0xAF42, 0xAF43, 0xAF48, 0xAF49, 0xAF50,
  0xAF5C, 0xAF5D, 0xAF64, 0xAF65, 0xAF79, 0xAF80, 0xAF84, 0xAF88,
  0xAF90, 0xAF91, 0xAF95, 0xAF9C, 0xAFB8, 0xAFB9, 0xAFBC, 0xAFC0,
  0xAFC7, 0xAFC8, 0xAFC9, 0xAFCB, 0xAFCD, 0xAFCE, 0xAFD4, 0xAFDC,
  0xAFE8, 0xAFE9, 0xAFF0, 0xAFF1, 0xAFF4, 0xAFF8, 0xB000, 0xB001,
  0xB004, 0xB00C, 0xB010, 0xB014, 0xB01C, 0xB01D, 0xB028, 0xB044,
  0xB045, 0xB048, 0xB04A, 0xB04C, 0xB04E, 0xB053, 0xB054, 0xB055,
  0xB057, 0xB059, 0xB05D, 0xB07C, 0xB07D, 0xB080, 0xB084, 0xB08C,
  0xB08D, 0xB08F, 0xB091, 0xB098, 0xB099, 0xB09A, 0xB09C, 0xB09F,
  0xB0A0, 0xB0A1, 0xB0A2, 0xB0A8, 0xB0A9, 0xB0AB, 0xB0AC, 0xB0AD,
  0xB0AE, 0xB0AF, 0xB0B1, 0xB0B3, 0xB0B4, 0xB0B5, 0xB0B8, 0xB0BC,
  0xB0C4, 0xB0C5, 0xB0C7, 0xB0C8, 0xB0C9, 0xB0D0, 0xB0D1, 0xB0D4,
  0xB0D8, 0xB0E0, 0xB0E5, 0xB108, 0xB109, 0xB10B, 0xB10C, 0xB110,
  0xB112, 0xB113, 0xB118, 0xB119, 0xB11B, 0xB11C, 0xB11D, 0xB123,
  0xB124, 0xB125, 0xB128, 0xB12C, 0xB134, 0xB135, 0xB137, 0xB138,
  0xB139, 0xB140, 0xB141, 0xB144, 0xB148, 0xB150, 0xB151, 0xB154,
  0xB155, 0xB158, 0xB15C, 0xB160, 0xB178, 0xB179, 0xB17C, 0xB180,
  0xB182, 0xB188, 0xB189, 0xB18B, 0xB18D, 0xB192, 0xB193, 0xB194,
  0xB198, 0xB19C, 0xB1A8, 0xB1CC, 0xB1D0, 0xB1D4, 0xB1DC, 0xB1DD,
  0xB1DF, 0xB1E8, 0xB1E9, 0xB1EC, 0xB1F0, 0xB1F9, 0xB1FB, 0xB1FD,
  0xB204, 0xB205, 0xB208, 0xB20B, 0xB20C, 0xB214, 0xB215, 0xB217,
  0xB219, 0xB220, 0xB234, 0xB23C, 0xB258, 0xB25C, 0xB260, 0xB268,
  0xB269, 0xB274, 0xB275, 0xB27C, 0xB284, 0xB285, 0xB289, 0xB290,
  0xB291, 0xB294, 0xB298, 0xB299, 0xB29A, 0xB2A0, 0xB2A1, 0xB2A3,
  0xB2A5, 0xB2A6, 0xB2AA, 0xB2AC, 0xB2B0, 0xB2B4, 0xB2C8, 0xB2C9,
  0xB2CC, 0xB2D0, 0xB2D2, 0xB2D8, 0xB2D9, 0xB2DB, 0xB2DD, 0xB2E2,
  0xB2E4, 0xB2E5, 0xB2E6, 0xB2E8, 0xB2EB, 0xB2EC, 0xB2ED, 0xB2EE,
  0xB2EF, 0xB2F3, 0xB2F4, 0xB2F5, 0xB2F7, 0xB2F8, 0xB2F9, 0xB2FA,
  0xB2FB, 0xB2FF, 0xB300, 0xB301, 0xB304, 0xB308, 0xB310, 0xB311,
  0xB313, 0xB314, 0xB315, 0xB31C, 0xB354, 0xB355, 0xB356, 0xB358,
  0xB35B, 0xB35C, 0xB35E, 0xB35F, 0xB364, 0xB365, 0xB367, 0xB369,
  0xB36B, 0xB36E, 0xB370, 0xB371, 0xB374, 0xB378, 0xB380, 0xB381,
  0xB383, 0xB384, 0xB385, 0xB38C, 0xB390, 0xB394, 0xB3A0, 0xB3A1,
  0xB3A8, 0xB3AC, 0xB3C4, 0xB3C5, 0xB3C8, 0xB3CB, 0xB3CC, 0xB3CE,
  0xB3D0, 0xB3D4, 0xB3D5, 0xB3D7, 0xB3D9, 0xB3DB, 0xB3DD, 0xB3E0,
  0xB3E4, 0xB3E8, 0xB3FC, 0xB410, 0xB418, 0xB41C, 0xB420, 0xB428,
  0xB429, 0xB42B, 0xB434, 0xB450, 0xB451, 0xB454, 0xB458, 0xB460,
  0xB461, 0xB463, 0xB465, 0xB46C, 0xB480, 0xB488, 0xB49D, 0xB4A4,
  0xB4A8, 0xB4AC, 0xB4B5, 0xB4B7, 0xB4B9, 0xB4C0, 0xB4C4, 0xB4C8,
  0xB4D0, 0xB4D5, 0xB4DC, 0xB4DD, 0xB4E0, 0xB4E3, 0xB4E4, 0xB4E6,
  0xB4EC, 0xB4ED, 0xB4EF, 0xB4F1, 0xB4F8, 0xB514, 0xB515, 0xB518,
  0xB51B, 0xB51C, 0xB524, 0xB525, 0xB527, 0xB528, 0xB529, 0xB52A,
  0xB530, 0xB531, 0xB534, 0xB538, 0xB540, 0xB541, 0xB543, 0xB544,
  0xB545, 0xB54B, 0xB54C, 0xB54D, 0xB550, 0xB554, 0xB55C, 0xB55D,
  0xB55F, 0xB560, 0xB561, 0xB5A0, 0xB5A1, 0xB5A4, 0xB5A8, 0xB5AA,
  0xB5AB, 0xB5B0, 0xB5B1, 0xB5B3, 0xB5B4, 0xB5B5, 0xB5BB, 0xB5BC,
  0xB5BD, 0xB5C0, 0xB5C4, 0xB5CC, 0xB5CD, 0xB5CF, 0xB5D0, 0xB5D1,
  0xB5D8, 0xB5EC, 0xB610, 0xB611, 0xB614, 0xB618, 0xB625, 0xB62C,
  0xB634, 0xB648, 0xB664, 0xB668, 0xB69C, 0xB69D, 0xB6A0, 0xB6A4,
  0xB6AB, 0xB6AC, 0xB6B1, 0xB6D4, 0xB6F0, 0xB6F4, 0xB6F8, 0xB700,
  0xB701, 0xB705, 0xB728, 0xB729, 0xB72C, 0xB72F, 0xB730, 0xB738,
  0xB739, 0xB73B, 0xB744, 0xB748, 0xB74C, 0xB754, 0xB755, 0xB760,
  0xB764, 0xB768, 0xB770, 0xB771, 0xB773, 0xB775, 0xB77C, 0xB77D,
  0xB780, 0xB784, 0xB78C, 0xB78D, 0xB78F, 0xB790, 0xB791, 0xB792,
  0xB796, 0xB797, 0xB798, 0xB799, 0xB79C, 0xB7A0, 0xB7A8, 0xB7A9,
  0xB7AB, 0xB7AC, 0xB7AD, 0xB7B4, 0xB7B5, 0xB7B8, 0xB7C7, 0xB7C9,
  0xB7EC, 0xB7ED, 0xB7F0, 0xB7F4, 0xB7FC, 0xB7FD, 0xB7FF, 0xB800,
  0xB801, 0xB807, 0xB808, 0xB809, 0xB80C, 0xB810, 0xB818, 0xB819,
  0xB81B, 0xB81D, 0xB824, 0xB825, 0xB828, 0xB82C, 0xB834, 0xB835,
  0xB837, 0xB838, 0xB839, 0xB840, 0xB844, 0xB851, 0xB853, 0xB85C,
  0xB85D, 0xB860, 0xB864, 0xB86C, 0xB86D, 0xB86F, 0xB871, 0xB878,
  0xB87C, 0xB88D, 0xB8A8, 0xB8B0, 0xB8B4, 0xB8B8, 0xB8C0, 0xB8C1,
  0xB8C3, 0xB8C5, 0xB8CC, 0xB8D0, 0xB8D4, 0xB8DD, 0xB8DF, 0xB8E1,
  0xB8E8, 0xB8E9, 0xB8EC, 0xB8F0, 0xB8F8, 0xB8F9, 0xB8FB, 0xB8FD,
  0xB904, 0xB918, 0xB920, 0xB93C, 0xB93D, 0xB940, 0xB944, 0xB94C,
  0xB94F, 0xB951, 0xB958, 0xB959, 0xB95C, 0xB960, 0xB968, 0xB969,
  0xB96B, 0xB96D, 0xB974, 0xB975, 0xB978, 0xB97C, 0xB984, 0xB985,
  0xB987, 0xB989, 0xB98A, 0xB98D, 0xB98E, 0xB9AC, 0xB9AD, 0xB9B0,
  0xB9B4, 0xB9BC, 0xB9BD, 0xB9BF, 0xB9C1, 0xB9C8, 0xB9C9, 0xB9CC,
  0xB9CE, 0xB9CF, 0xB9D0, 0xB9D1, 0xB9D2, 0xB9D8, 0xB9D9, 0xB9DB,
  0xB9DD, 0xB9DE, 0xB9E1, 0xB9E3, 0xB9E4, 0xB9E5, 0xB9E8, 0xB9EC,
  0xB9F4, 0xB9F5, 0xB9F7, 0xB9F8, 0xB9F9, 0xB9FA, 0xBA00, 0xBA01,
  0xBA08, 0xBA15, 0xBA38, 0xBA39, 0xBA3C, 0xBA40, 0xBA42, 0xBA48,
  0xBA49, 0xBA4B, 0xBA4D, 0xBA4E, 0xBA53, 0xBA54, 0xBA55, 0xBA58,
  0xBA5C, 0xBA64, 0xBA65, 0xBA67, 0xBA68, 0xBA69, 0xBA70, 0xBA71,
  0xBA74, 0xBA78, 0xBA83, 0xBA84, 0xBA85, 0xBA87, 0xBA8C, 0xBAA8,
  0xBAA9, 0xBAAB, 0xBAAC, 0xBAB0, 0xBAB2, 0xBAB8, 0xBAB9, 0xBABB,
  0xBABD, 0xBAC4, 0xBAC8, 0xBAD8, 0xBAD9, 0xBAFC, 0xBB00, 0xBB04,
  0xBB0D, 0xBB0F, 0xBB11, 0xBB18, 0xBB1C, 0xBB20, 0xBB29, 0xBB2B,
  0xBB34, 0xBB35, 0xBB36, 0xBB38, 0xBB3B, 0xBB3C, 0xBB3D, 0xBB3E,
  0xBB44, 0xBB45, 0xBB47, 0xBB49, 0xBB4D, 0xBB4F, 0xBB50, 0xBB54,
  0xBB58, 0xBB61, 0xBB63, 0xBB6C, 0xBB88, 0xBB8C, 0xBB90, 0xBBA4,
  0xBBA8, 0xBBAC, 0xBBB4, 0xBBB7, 0xBBC0, 0xBBC4, 0xBBC8, 0xBBD0,
  0xBBD3, 0xBBF8, 0xBBF9, 0xBBFC, 0xBBFF, 0xBC00, 0xBC02, 0xBC08,
  0xBC09, 0xBC0B, 0xBC0C, 0xBC0D, 0xBC0F, 0xBC11, 0xBC14, 0xBC15,
  0xBC16, 0xBC17, 0xBC18, 0xBC1B, 0xBC1C, 0xBC1D, 0xBC1E, 0xBC1F,
  0xBC24, 0xBC25, 0xBC27, 0xBC29, 0xBC2D, 0xBC30, 0xBC31, 0xBC34,
  0xBC38, 0xBC40, 0xBC41, 0xBC43, 0xBC44, 0xBC45, 0xBC49, 0xBC4C,
  0xBC4D, 0xBC50, 0xBC5D, 0xBC84, 0xBC85, 0xBC88, 0xBC8B, 0xBC8C,
  0xBC8E, 0xBC94, 0xBC95, 0xBC97, 0xBC99, 0xBC9A, 0xBCA0, 0xBCA1,
  0xBCA4, 0xBCA7, 0xBCA8, 0xBCB0, 0xBCB1, 0xBCB3, 0xBCB4, 0xBCB5,
  0xBCBC, 0xBCBD, 0xBCC0, 0xBCC4, 0xBCCD, 0xBCCF, 0xBCD0, 0xBCD1,
  0xBCD5, 0xBCD8, 0xBCDC, 0xBCF4, 0xBCF5, 0xBCF6, 0xBCF8, 0xBCFC,
  0xBD04, 0xBD05, 0xBD07, 0xBD09, 0xBD10, 0xBD14, 0xBD24, 0xBD2C,
  0xBD40, 0xBD48, 0xBD49, 0xBD4C, 0xBD50, 0xBD58, 0xBD59, 0xBD64,
  0xBD68, 0xBD80, 0xBD81, 0xBD84, 0xBD87, 0xBD88, 0xBD89, 0xBD8A,
  0xBD90, 0xBD91, 0xBD93, 0xBD95, 0xBD99, 0xBD9A, 0xBD9C, 0xBDA4,
  0xBDB0, 0xBDB8, 0xBDD4, 0xBDD5, 0xBDD8, 0xBDDC, 0xBDE9, 0xBDF0,
  0xBDF4, 0xBDF8, 0xBE00, 0xBE03, 0xBE05, 0xBE0C, 0xBE0D, 0xBE10,
  0xBE14, 0xBE1C, 0xBE1D, 0xBE1F, 0xBE44, 0xBE45, 0xBE48, 0xBE4C,
  0xBE4E, 0xBE54, 0xBE55, 0xBE57, 0xBE59, 0xBE5A, 0xBE5B, 0xBE60,
  0xBE61, 0xBE64, 0xBE68, 0xBE6A, 0xBE70, 0xBE71, 0xBE73, 0xBE74,
  0xBE75, 0xBE7B, 0xBE7C, 0xBE7D, 0xBE80, 0xBE84, 0xBE8C, 0xBE8D,
  0xBE8F, 0xBE90, 0xBE91, 0xBE98, 0xBE99, 0xBEA8, 0xBED0, 0xBED1,
  0xBED4, 0xBED7, 0xBED8, 0xBEE0, 0xBEE3, 0xBEE4, 0xBEE5, 0xBEEC,
  0xBF01, 0xBF08, 0xBF09, 0xBF18, 0xBF19, 0xBF1B, 0xBF1C, 0xBF1D,
  0xBF40, 0xBF41, 0xBF44, 0xBF48, 0xBF50, 0xBF51, 0xBF55, 0xBF94,
  0xBFB0, 0xBFC5, 0xBFCC, 0xBFCD, 0xBFD0, 0xBFD4, 0xBFDC, 0xBFDF,
  0xBFE1, 0xC03C, 0xC051, 0xC058, 0xC05C, 0xC060, 0xC068, 0xC069,
  0xC090, 0xC091, 0xC094, 0xC098, 0xC0A0, 0xC0A1, 0xC0A3, 0xC0A5,
  0xC0AC, 0xC0AD, 0xC0AF, 0xC0B0, 0xC0B3, 0xC0B4, 0xC0B5, 0xC0B6,
  0xC0BC, 0xC0BD, 0xC0BF, 0xC0C0, 0xC0C1, 0xC0C5, 0xC0C8, 0xC0C9,
  0xC0CC, 0xC0D0, 0xC0D8, 0xC0D9, 0xC0DB, 0xC0DC, 0xC0DD, 0xC0E4,
  0xC0E5, 0xC0E8, 0xC0EC, 0xC0F4, 0xC0F5, 0xC0F7, 0xC0F9, 0xC100,
  0xC104, 0xC108, 0xC110, 0xC115, 0xC11C, 0xC11D, 0xC11E, 0xC11F,
  0xC120, 0xC123, 0xC124, 0xC126, 0xC127, 0xC12C, 0xC12D, 0xC12F,
  0xC130, 0xC131, 0xC136, 0xC138, 0xC139, 0xC13C, 0xC140, 0xC148,
  0xC149, 0xC14B, 0xC14C, 0xC14D, 0xC154, 0xC155, 0xC158, 0xC15C,
  0xC164, 0xC165, 0xC167, 0xC168, 0xC169, 0xC170, 0xC174, 0xC178,
  0xC185, 0xC18C, 0xC18D, 0xC18E, 0xC190, 0xC194, 0xC196, 0xC19C,
  0xC19D, 0xC19F, 0xC1A1, 0xC1A5, 0xC1A8, 0xC1A9, 0xC1AC, 0xC1B0,
  0xC1BD, 0xC1C4, 0xC1C8, 0xC1CC, 0xC1D4, 0xC1D7, 0xC1D8, 0xC1E0,
  0xC1E4, 0xC1E8, 0xC1F0, 0xC1F1, 0xC1F3, 0xC1FC, 0xC1FD, 0xC200,
  0xC204, 0xC20C, 0xC20D, 0xC20F, 0xC211, 0xC218, 0xC219, 0xC21C,
  0xC21F, 0xC220, 0xC228, 0xC229, 0xC22B, 0xC22D, 0xC22F, 0xC231,
  0xC232, 0xC234, 0xC248, 0xC250, 0xC251, 0xC254, 0xC258, 0xC260,
  0xC265, 0xC26C, 0xC26D, 0xC270, 0xC274, 0xC27C, 0xC27D, 0xC27F,
  0xC281, 0xC288, 0xC289, 0xC290, 0xC298, 0xC29B, 0xC29D, 0xC2A4,
  0xC2A5, 0xC2A8, 0xC2AC, 0xC2AD, 0xC2B4, 0xC2B5, 0xC2B7, 0xC2B9,
  0xC2DC, 0xC2DD, 0xC2E0, 0xC2E3, 0xC2E4, 0xC2EB, 0xC2EC, 0xC2ED,
  0xC2EF, 0xC2F1, 0xC2F6, 0xC2F8, 0xC2F9, 0xC2FB, 0xC2FC, 0xC300,
  0xC308, 0xC309, 0xC30C, 0xC30D, 0xC313, 0xC314, 0xC315, 0xC318,
  0xC31C, 0xC324, 0xC325, 0xC328, 0xC329, 0xC345, 0xC368, 0xC369,
  0xC36C, 0xC370, 0xC372, 0xC378, 0xC379, 0xC37C, 0xC37D, 0xC384,
  0xC388, 0xC38C, 0xC3C0, 0xC3D8, 0xC3D9, 0xC3DC, 0xC3DF, 0xC3E0,
  0xC3E2, 0xC3E8, 0xC3E9, 0xC3ED, 0xC3F4, 0xC3F5, 0xC3F8, 0xC408,
  0xC410, 0xC424, 0xC42C, 0xC430, 0xC434, 0xC43C, 0xC43D, 0xC448,
  0xC464, 0xC465, 0xC468, 0xC46C, 0xC474, 0xC475, 0xC479, 0xC480,
  0xC494, 0xC49C, 0xC4B8, 0xC4BC, 0xC4E9, 0xC4F0, 0xC4F1, 0xC4F4,
  0xC4F8, 0xC4FA, 0xC4FF, 0xC500, 0xC501, 0xC50C, 0xC510, 0xC514,
  0xC51C, 0xC528, 0xC529, 0xC52C, 0xC530, 0xC538, 0xC539, 0xC53B,
  0xC53D, 0xC544, 0xC545, 0xC548, 0xC549, 0xC54A, 0xC54C, 0xC54D,
  0xC54E, 0xC553, 0xC554, 0xC555, 0xC557, 0xC558, 0xC559, 0xC55D,
  0xC55E, 0xC560, 0xC561, 0xC564, 0xC568, 0xC570, 0xC571, 0xC573,
  0xC574, 0xC575, 0xC57C, 0xC57D, 0xC580, 0xC584, 0xC587, 0xC58C,
  0xC58D, 0xC58F, 0xC591, 0xC595, 0xC597, 0xC598, 0xC59C, 0xC5A0,
  0xC5A9, 0xC5B4, 0xC5B5, 0xC5B8, 0xC5B9, 0xC5BB, 0xC5BC, 0xC5BD,
  0xC5BE, 0xC5C4, 0xC5C5, 0xC5C6, 0xC5C7, 0xC5C8, 0xC5C9, 0xC5CA,
  0xC5CC, 0xC5CE, 0xC5D0, 0xC5D1, 0xC5D4, 0xC5D8, 0xC5E0, 0xC5E1,
  0xC5E3, 0xC5E5, 0xC5EC, 0xC5ED, 0xC5EE, 0xC5F0, 0xC5F4, 0xC5F6,
  0xC5F7, 0xC5FC, 0xC5FD, 0xC5FE, 0xC5FF, 0xC600, 0xC601, 0xC605,
  0xC606, 0xC607, 0xC608, 0xC60C, 0xC610, 0xC618, 0xC619, 0xC61B,
  0xC61C, 0xC624, 0xC625, 0xC628, 0xC62C, 0xC62D, 0xC62E, 0xC630,
  0xC633, 0xC634, 0xC635, 0xC637, 0xC639, 0xC63B, 0xC640, 0xC641,
  0xC644, 0xC648, 0xC650, 0xC651, 0xC653, 0xC654, 0xC655, 0xC65C,
  0xC65D, 0xC660, 0xC66C, 0xC66F, 0xC671, 0xC678, 0xC679, 0xC67C,
  0xC680, 0xC688, 0xC689, 0xC68B, 0xC68D, 0xC694, 0xC695, 0xC698,
  0xC69C, 0xC6A4, 0xC6A5, 0xC6A7, 0xC6A9, 0xC6B0, 0xC6B1, 0xC6B4,
  0xC6B8, 0xC6B9, 0xC6BA, 0xC6C0, 0xC6C1, 0xC6C3, 0xC6C5, 0xC6CC,
  0xC6CD, 0xC6D0, 0xC6D4, 0xC6DC, 0xC6DD, 0xC6E0, 0xC6E1, 0xC6E8,
  0xC6E9, 0xC6EC, 0xC6F0, 0xC6F8, 0xC6F9, 0xC6FD, 0xC704, 0xC705,
  0xC708, 0xC70C, 0xC714, 0xC715, 0xC717, 0xC719, 0xC720, 0xC721,
  0xC724, 0xC728, 0xC730, 0xC731, 0xC733, 0xC735, 0xC737, 0xC73C,
  0xC73D, 0xC740, 0xC744, 0xC74A, 0xC74C, 0xC74D, 0xC74F, 0xC751,
  0xC752, 0xC753, 0xC754, 0xC755, 0xC756, 0xC757, 0xC758, 0xC75C,
  0xC760, 0xC768, 0xC76B, 0xC774, 0xC775, 0xC778, 0xC77C, 0xC77D,
  0xC77E, 0xC783, 0xC784, 0xC785, 0xC787, 0xC788, 0xC789, 0xC78A,
  0xC78E, 0xC790, 0xC791, 0xC794, 0xC796, 0xC797, 0xC798, 0xC79A,
  0xC7A0, 0xC7A1, 0xC7A3, 0xC7A4, 0xC7A5, 0xC7A6, 0xC7AC, 0xC7AD,
  0xC7B0, 0xC7B4, 0xC7BC, 0xC7BD, 0xC7BF, 0xC7C0, 0xC7C1, 0xC7C8,
  0xC7C9, 0xC7CC, 0xC7CE, 0xC7D0, 0xC7D8, 0xC7DD, 0xC7E4, 0xC7E8,
  0xC7EC, 0xC800, 0xC801, 0xC804, 0xC808, 0xC80A, 0xC810, 0xC811,
  0xC813, 0xC815, 0xC816, 0xC81C, 0xC81D, 0xC820, 0xC824, 0xC82C,
  0xC82D, 0xC82F, 0xC831, 0xC838, 0xC83C, 0xC840, 0xC848, 0xC849,
  0xC84C, 0xC84D, 0xC854, 0xC870, 0xC871, 0xC874, 0xC878, 0xC87A,
  0xC880, 0xC881, 0xC883, 0xC885, 0xC886, 0xC887, 0xC88B, 0xC88C,
  0xC88D, 0xC894, 0xC89D, 0xC89F, 0xC8A1, 0xC8A8, 0xC8BC, 0xC8BD,
  0xC8C4, 0xC8C8, 0xC8CC, 0xC8D4, 0xC8D5, 0xC8D7, 0xC8D9, 0xC8E0,
  0xC8E1, 0xC8E4, 0xC8F5, 0xC8FC, 0xC8FD, 0xC900, 0xC904, 0xC905,
  0xC906, 0xC90C, 0xC90D, 0xC90F, 0xC911, 0xC918, 0xC92C, 0xC934,
  0xC950, 0xC951, 0xC954, 0xC958, 0xC960, 0xC961, 0xC963, 0xC96C,
  0xC970, 0xC974, 0xC97C, 0xC988, 0xC989, 0xC98C, 0xC990, 0xC998,
  0xC999, 0xC99B, 0xC99D, 0xC9C0, 0xC9C1, 0xC9C4, 0xC9C7, 0xC9C8,
  0xC9CA, 0xC9D0, 0xC9D1, 0xC9D3, 0xC9D5, 0xC9D6, 0xC9D9, 0xC9DA,
  0xC9DC, 0xC9DD, 0xC9E0, 0xC9E2, 0xC9E4, 0xC9E7, 0xC9EC, 0xC9ED,
  0xC9EF, 0xC9F0, 0xC9F1, 0xC9F8, 0xC9F9, 0xC9FC, 0xCA00, 0xCA08,
  0xCA09, 0xCA0B, 0xCA0C, 0xCA0D, 0xCA14, 0xCA18, 0xCA29, 0xCA4C,
  0xCA4D, 0xCA50, 0xCA54, 0xCA5C, 0xCA5D, 0xCA5F, 0xCA60, 0xCA61,
  0xCA68, 0xCA7D, 0xCA84, 0xCA98, 0xCABC, 0xCABD, 0xCAC0, 0xCAC4,
  0xCACC, 0xCACD, 0xCACF, 0xCAD1, 0xCAD3, 0xCAD8, 0xCAD9, 0xCAE0,
  0xCAEC, 0xCAF4, 0xCB08, 0xCB10, 0xCB14, 0xCB18, 0xCB20, 0xCB21,
  0xCB41, 0xCB48, 0xCB49, 0xCB4C, 0xCB50, 0xCB58, 0xCB59, 0xCB5D,
  0xCB64, 0xCB78, 0xCB79, 0xCB9C, 0xCBB8, 0xCBD4, 0xCBE4, 0xCBE7,
  0xCBE9, 0xCC0C, 0xCC0D, 0xCC10, 0xCC14, 0xCC1C, 0xCC1D, 0xCC21,
  0xCC22, 0xCC27, 0xCC28, 0xCC29, 0xCC2C, 0xCC2E, 0xCC30, 0xCC38,
  0xCC39, 0xCC3B, 0xCC3C, 0xCC3D, 0xCC3E, 0xCC44, 0xCC45, 0xCC48,
  0xCC4C, 0xCC54, 0xCC55, 0xCC57, 0xCC58, 0xCC59, 0xCC60, 0xCC64,
  0xCC66, 0xCC68, 0xCC70, 0xCC75, 0xCC98, 0xCC99, 0xCC9C, 0xCCA0,
  0xCCA8, 0xCCA9, 0xCCAB, 0xCCAC, 0xCCAD, 0xCCB4, 0xCCB5, 0xCCB8,
  0xCCBC, 0xCCC4, 0xCCC5, 0xCCC7, 0xCCC9, 0xCCD0, 0xCCD4, 0xCCE4,
  0xCCEC, 0xCCF0, 0xCD01, 0xCD08, 0xCD09, 0xCD0C, 0xCD10, 0xCD18,
  0xCD19, 0xCD1B, 0xCD1D, 0xCD24, 0xCD28, 0xCD2C, 0xCD39, 0xCD5C,
  0xCD60, 0xCD64, 0xCD6C, 0xCD6D, 0xCD6F, 0xCD71, 0xCD78, 0xCD88,
  0xCD94, 0xCD95, 0xCD98, 0xCD9C, 0xCDA4, 0xCDA5, 0xCDA7, 0xCDA9,
  0xCDB0, 0xCDC4, 0xCDCC, 0xCDD0, 0xCDE8, 0xCDEC, 0xCDF0, 0xCDF8,
  0xCDF9, 0xCDFB, 0xCDFD, 0xCE04, 0xCE08, 0xCE0C, 0xCE14, 0xCE19,
  0xCE20, 0xCE21, 0xCE24, 0xCE28, 0xCE30, 0xCE31, 0xCE33, 0xCE35,
  0xCE58, 0xCE59, 0xCE5C, 0xCE5F, 0xCE60, 0xCE61, 0xCE68, 0xCE69,
  0xCE6B, 0xCE6D, 0xCE74, 0xCE75, 0xCE78, 0xCE7C, 0xCE84, 0xCE85,
  0xCE87, 0xCE89, 0xCE90, 0xCE91, 0xCE94, 0xCE98, 0xCEA0, 0xCEA1,
  0xCEA3, 0xCEA4, 0xCEA5, 0xCEAC, 0xCEAD, 0xCEC1, 0xCEE4, 0xCEE5,
  0xCEE8, 0xCEEB, 0xCEEC, 0xCEF4, 0xCEF5, 0xCEF7, 0xCEF8, 0xCEF9,
  0xCF00, 0xCF01, 0xCF04, 0xCF08, 0xCF10, 0xCF11, 0xCF13, 0xCF15,
  0xCF1C, 0xCF20, 0xCF24, 0xCF2C, 0xCF2D, 0xCF2F, 0xCF30, 0xCF31,
  0xCF38, 0xCF54, 0xCF55, 0xCF58, 0xCF5C, 0xCF64, 0xCF65, 0xCF67,
  0xCF69, 0xCF70, 0xCF71, 0xCF74, 0xCF78, 0xCF80, 0xCF85, 0xCF8C,
  0xCFA1, 0xCFA8, 0xCFB0, 0xCFC4, 0xCFE0, 0xCFE1, 0xCFE4, 0xCFE8,
  0xCFF0, 0xCFF1, 0xCFF3, 0xCFF5, 0xCFFC, 0xD000, 0xD004, 0xD011,
  0xD018, 0xD02D, 0xD034, 0xD035, 0xD038, 0xD03C, 0xD044, 0xD045,
  0xD047, 0xD049, 0xD050, 0xD054, 0xD058, 0xD060, 0xD06C, 0xD06D,
  0xD070, 0xD074, 0xD07C, 0xD07D, 0xD081, 0xD0A4, 0xD0A5, 0xD0A8,
  0xD0AC, 0xD0B4, 0xD0B5, 0xD0B7, 0xD0B9, 0xD0C0, 0xD0C1, 0xD0C4,
  0xD0C8, 0xD0C9, 0xD0D0, 0xD0D1, 0xD0D3, 0xD0D4, 0xD0D5, 0xD0DC,
  0xD0DD, 0xD0E0, 0xD0E4, 0xD0EC, 0xD0ED, 0xD0EF, 0xD0F0, 0xD0F1,
  0xD0F8, 0xD10D, 0xD130, 0xD131, 0xD134, 0xD138, 0xD13A, 0xD140,
  0xD141, 0xD143, 0xD144, 0xD145, 0xD14C, 0xD14D, 0xD150, 0xD154,
  0xD15C, 0xD15D, 0xD15F, 0xD161, 0xD168, 0xD16C, 0xD17C, 0xD184,
  0xD188, 0xD1A0, 0xD1A1, 0xD1A4, 0xD1A8, 0xD1B0, 0xD1B1, 0xD1B3,
  0xD1B5, 0xD1BA, 0xD1BC, 0xD1C0, 0xD1D8, 0xD1F4, 0xD1F8, 0xD207,
  0xD209, 0xD210, 0xD22C, 0xD22D, 0xD230, 0xD234, 0xD23C, 0xD23D,
  0xD23F, 0xD241, 0xD248, 0xD25C, 0xD264, 0xD280, 0xD281, 0xD284,
  0xD288, 0xD290, 0xD291, 0xD295, 0xD29C, 0xD2A0, 0xD2A4, 0xD2AC,
  0xD2B1, 0xD2B8, 0xD2B9, 0xD2BC, 0xD2BF, 0xD2C0, 0xD2C2, 0xD2C8,
  0xD2C9, 0xD2CB, 0xD2D4, 0xD2D8, 0xD2DC, 0xD2E4, 0xD2E5, 0xD2F0,
  0xD2F1, 0xD2F4, 0xD2F8, 0xD300, 0xD301, 0xD303, 0xD305, 0xD30C,
  0xD30D, 0xD30E, 0xD310, 0xD314, 0xD316, 0xD31C, 0xD31D, 0xD31F,
  0xD320, 0xD321, 0xD325, 0xD328, 0xD329, 0xD32C, 0xD330, 0xD338,
  0xD339, 0xD33B, 0xD33C, 0xD33D, 0xD344, 0xD345, 0xD37C, 0xD37D,
  0xD380, 0xD384, 0xD38C, 0xD38D, 0xD38F, 0xD390, 0xD391, 0xD398,
  0xD399, 0xD39C, 0xD3A0, 0xD3A8, 0xD3A9, 0xD3AB, 0xD3AD, 0xD3B4,
  0xD3B8, 0xD3BC, 0xD3C4, 0xD3C5, 0xD3C8, 0xD3C9, 0xD3D0, 0xD3D8,
  0xD3E1, 0xD3E3, 0xD3EC, 0xD3ED, 0xD3F0, 0xD3F4, 0xD3FC, 0xD3FD,
  0xD3FF, 0xD401, 0xD408, 0xD41D, 0xD440, 0xD444, 0xD45C, 0xD460,
  0xD464, 0xD46D, 0xD46F, 0xD478, 0xD479, 0xD47C, 0xD47F, 0xD480,
  0xD482, 0xD488, 0xD489, 0xD48B, 0xD48D, 0xD494, 0xD4A9, 0xD4CC,
  0xD4D0, 0xD4D4, 0xD4DC, 0xD4DF, 0xD4E8, 0xD4EC, 0xD4F0, 0xD4F8,
  0xD4FB, 0xD4FD, 0xD504, 0xD508, 0xD50C, 0xD514, 0xD515, 0xD517,
  0xD53C, 0xD53D, 0xD540, 0xD544, 0xD54C, 0xD54D, 0xD54F, 0xD551,
  0xD558, 0xD559, 0xD55C, 0xD560, 0xD565, 0xD568, 0xD569, 0xD56B,
  0xD56D, 0xD574, 0xD575, 0xD578, 0xD57C, 0xD584, 0xD585, 0xD587,
  0xD588, 0xD589, 0xD590, 0xD5A5, 0xD5C8, 0xD5C9, 0xD5CC, 0xD5D0,
  0xD5D2, 0xD5D8, 0xD5D9, 0xD5DB, 0xD5DD, 0xD5E4, 0xD5E5, 0xD5E8,
  0xD5EC, 0xD5F4, 0xD5F5, 0xD5F7, 0xD5F9, 0xD600, 0xD601, 0xD604,
  0xD608, 0xD610, 0xD611, 0xD613, 0xD614, 0xD615, 0xD61C, 0xD620,
  0xD624, 0xD62D, 0xD638, 0xD639, 0xD63C, 0xD640, 0xD645, 0xD648,
  0xD649, 0xD64B, 0xD64D, 0xD651, 0xD654, 0xD655, 0xD658, 0xD65C,
  0xD667, 0xD669, 0xD670, 0xD671, 0xD674, 0xD683, 0xD685, 0xD68C,
  0xD68D, 0xD690, 0xD694, 0xD69D, 0xD69F, 0xD6A1, 0xD6A8, 0xD6AC,
  0xD6B0, 0xD6B9, 0xD6BB, 0xD6C4, 0xD6C5, 0xD6C8, 0xD6CC, 0xD6D1,
  0xD6D4, 0xD6D7, 0xD6D9, 0xD6E0, 0xD6E4, 0xD6E8, 0xD6F0, 0xD6F5,
  0xD6FC, 0xD6FD, 0xD700, 0xD704, 0xD711, 0xD718, 0xD719, 0xD71C,
  0xD720, 0xD728, 0xD729, 0xD72B, 0xD72D, 0xD734, 0xD735, 0xD738,
  0xD73C, 0xD744, 0xD747, 0xD749, 0xD750, 0xD751, 0xD754, 0xD756,
  0xD757, 0xD758, 0xD759, 0xD760, 0xD761, 0xD763, 0xD765, 0xD769,
  0xD76C, 0xD770, 0xD774, 0xD77C, 0xD77D, 0xD781, 0xD788, 0xD789,
  0xD78C, 0xD790, 0xD798, 0xD799, 0xD79B, 0xD79D,
  // [   457,   537] -v # seg 16 at pos 2514
  0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2500, 0x2502, 0x250C,
  0x2510, 0x2518, 0x2514, 0x251C, 0x252C, 0x2524, 0x2534, 0x253C,
  0x2501, 0x2503, 0x250F, 0x2513, 0x251B, 0x2517, 0x2523, 0x2533,
  0x252B, 0x253B, 0x254B, 0x2520, 0x252F, 0x2528, 0x2537, 0x253F,
  0x251D, 0x2530, 0x2525, 0x2538, 0x2542, 0x2512, 0x2511, 0x251A,
  0x2519, 0x2516, 0x2515, 0x250E, 0x250D, 0x251E, 0x251F, 0x2521,
  0x2522, 0x2526, 0x2527, 0x2529, 0x252A, 0x252D, 0x252E, 0x2531,
  0x2532, 0x2535, 0x2536, 0x2539, 0x253A, 0x253D, 0x253E, 0x2540,
  0x2541, 0x2543, 0x2544, 0x2545, 0x2546, 0x2547, 0x2548, 0x2549,
  0x254A,
  // [   564,   573] -v # seg 18 at pos 2595
  0x3395, 0x3396, 0x3397, 0x2113, 0x3398, 0x33C4, 0x33A3, 0x33A4,
  0x33A5, 0x33A6,
  // [   574,   583] -> [0x3399,0x33A2] # seg 19
  // [   584,   593] -v # seg 20 at pos 2605
  0x33CA, 0x338D, 0x338E, 0x338F, 0x33CF, 0x3388, 0x3389, 0x33C8,
  0x33A7, 0x33A8,
  // [   604,   642] -v # seg 22 at pos 2615
  0x3380, 0x3381, 0x3382, 0x3383, 0x3384, 0x33BA, 0x33BB, 0x33BC,
  0x33BD, 0x33BE, 0x33BF, 0x3390, 0x3391, 0x3392, 0x3393, 0x3394,
  0x2126, 0x33C0, 0x33C1, 0x338A, 0x338B, 0x338C, 0x33D6, 0x33C5,
  0x33AD, 0x33AE, 0x33AF, 0x33DB, 0x33A9, 0x33AA, 0x33AB, 0x33AC,
  0x33DD, 0x33D0, 0x33D3, 0x33C3, 0x33C9, 0x33DC, 0x33C6,
  // [   658,   673] -v # seg 24 at pos 2654
  0x00C6, 0x00D0, 0x00AA, 0x0126,  RCHAR, 0x0132,  RCHAR, 0x013F,
  0x0141, 0x00D8, 0x0152, 0x00BA, 0x00DE, 0x0166, 0x014A,  RCHAR,
  // [   674,   701] -> [0x3260,0x327B] # seg 25
  // [   702,   727] -> [0x24D0,0x24E9] # seg 26
  // [   728,   742] -> [0x2460,0x246E] # seg 27
  // [   743,   767] -v # seg 28 at pos 2670
  0x00BD, 0x2153, 0x2154, 0x00BC, 0x00BE, 0x215B, 0x215C, 0x215D,
  0x215E, 0x00E6, 0x0111, 0x00F0, 0x0127, 0x0131, 0x0133, 0x0138,
  0x0140, 0x0142, 0x00F8, 0x0153, 0x00DF, 0x00FE, 0x0167, 0x014B,
  0x0149,
  // [   768,   795] -> [0x3200,0x321B] # seg 29
  // [   796,   821] -> [0x249C,0x24B5] # seg 30
  // [   822,   836] -> [0x2474,0x2482] # seg 31
  // [   837,   845] -v # seg 32 at pos 2695
  0x00B9, 0x00B2, 0x00B3, 0x2074, 0x207F, 0x2081, 0x2082, 0x2083,
  0x2084,
  // [   846,   928] -> [0x3041,0x3093] # seg 33
  // [   940,  1025] -> [0x30A1,0x30F6] # seg 35
  // [  1034,  1040] -v # seg 37 at pos 2704
  0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401,
  // [  1082,  1088] -v # seg 40 at pos 2711
  0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451,
  // [  3854,  4649] -v # seg 45 at pos 2718
  0x4F3D, 0x4F73, 0x5047, 0x50F9, 0x52A0, 0x53EF, 0x5475, 0x54E5,
  0x5609, 0x5AC1, 0x5BB6, 0x6687, 0x67B6, 0x67B7, 0x67EF, 0x6B4C,
  0x73C2, 0x75C2, 0x7A3C, 0x82DB, 0x8304, 0x8857, 0x8888, 0x8A36,
  0x8CC8, 0x8DCF, 0x8EFB, 0x8FE6, 0x99D5, 0x523B, 0x5374, 0x5404,
  0x606A, 0x6164, 0x6BBC, 0x73CF, 0x811A, 0x89BA, 0x89D2, 0x95A3,
  0x4F83, 0x520A, 0x58BE, 0x5978, 0x59E6, 0x5E72, 0x5E79, 0x61C7,
  0x63C0, 0x6746, 0x67EC, 0x687F, 0x6F97, 0x764E, 0x770B, 0x78F5,
  0x7A08, 0x7AFF, 0x7C21, 0x809D, 0x826E, 0x8271, 0x8AEB, 0x9593,
  0x4E6B, 0x559D, 0x66F7, 0x6E34, 0x78A3, 0x7AED, 0x845B, 0x8910,
  0x874E, 0x97A8, 0x52D8, 0x574E, 0x582A, 0x5D4C, 0x611F, 0x61BE,
  0x6221, 0x6562, 0x67D1, 0x6A44, 0x6E1B, 0x7518, 0x75B3, 0x76E3,
  0x77B0, 0x7D3A, 0x90AF, 0x9451, 0x9452, 0x9F95, 0x5323, 0x5CAC,
  0x7532, 0x80DB, 0x9240, 0x9598, 0x525B, 0x5808, 0x59DC, 0x5CA1,
  0x5D17, 0x5EB7, 0x5F3A, 0x5F4A, 0x6177, 0x6C5F, 0x757A, 0x7586,
  0x7CE0, 0x7D73, 0x7DB1, 0x7F8C, 0x8154, 0x8221, 0x8591, 0x8941,
  0x8B1B, 0x92FC, 0x964D, 0x9C47, 0x4ECB, 0x4EF7, 0x500B, 0x51F1,
  0x584F, 0x6137, 0x613E, 0x6168, 0x6539, 0x69EA, 0x6F11, 0x75A5,
  0x7686, 0x76D6, 0x7B87, 0x82A5, 0x84CB, 0xF900, 0x93A7, 0x958B,
  0x5580, 0x5BA2, 0x5751, 0xF901, 0x7CB3, 0x7FB9, 0x91B5, 0x5028,
  0x53BB, 0x5C45, 0x5DE8, 0x62D2, 0x636E, 0x64DA, 0x64E7, 0x6E20,
  0x70AC, 0x795B, 0x8DDD, 0x8E1E, 0xF902, 0x907D, 0x9245, 0x92F8,
  0x4E7E, 0x4EF6, 0x5065, 0x5DFE, 0x5EFA, 0x6106, 0x6957, 0x8171,
  0x8654, 0x8E47, 0x9375, 0x9A2B, 0x4E5E, 0x5091, 0x6770, 0x6840,
  0x5109, 0x528D, 0x5292, 0x6AA2, 0x77BC, 0x9210, 0x9ED4, 0x52AB,
  0x602F, 0x8FF2, 0x5048, 0x61A9, 0x63ED, 0x64CA, 0x683C, 0x6A84,
  0x6FC0, 0x8188, 0x89A1, 0x9694, 0x5805, 0x727D, 0x72AC, 0x7504,
  0x7D79, 0x7E6D, 0x80A9, 0x898B, 0x8B74, 0x9063, 0x9D51, 0x6289,
  0x6C7A, 0x6F54, 0x7D50, 0x7F3A, 0x8A23, 0x517C, 0x614A, 0x7B9D,
  0x8B19, 0x9257, 0x938C, 0x4EAC, 0x4FD3, 0x501E, 0x50BE, 0x5106,
  0x52C1, 0x52CD, 0x537F, 0x5770, 0x5883, 0x5E9A, 0x5F91, 0x6176,
  0x61AC, 0x64CE, 0x656C, 0x666F, 0x66BB, 0x66F4, 0x6897, 0x6D87,
  0x7085, 0x70F1, 0x749F, 0x74A5, 0x74CA, 0x75D9, 0x786C, 0x78EC,
  0x7ADF, 0x7AF6, 0x7D45, 0x7D93, 0x8015, 0x803F, 0x811B, 0x8396,
  0x8B66, 0x8F15, 0x9015, 0x93E1, 0x9803, 0x9838, 0x9A5A, 0x9BE8,
  0x4FC2, 0x5553, 0x583A, 0x5951, 0x5B63, 0x5C46, 0x60B8, 0x6212,
  0x6842, 0x68B0, 0x68E8, 0x6EAA, 0x754C, 0x7678, 0x78CE, 0x7A3D,
  0x7CFB, 0x7E6B, 0x7E7C, 0x8A08, 0x8AA1, 0x8C3F, 0x968E, 0x9DC4,
  0x53E4, 0x53E9, 0x544A, 0x5471, 0x56FA, 0x59D1, 0x5B64, 0x5C3B,
  0x5EAB, 0x62F7, 0x6537, 0x6545, 0x6572, 0x66A0, 0x67AF, 0x69C1,
  0x6CBD, 0x75FC, 0x7690, 0x777E, 0x7A3F, 0x7F94, 0x8003, 0x80A1,
  0x818F, 0x82E6, 0x82FD, 0x83F0, 0x85C1, 0x8831, 0x88B4, 0x8AA5,
  0xF903, 0x8F9C, 0x932E, 0x96C7, 0x9867, 0x9AD8, 0x9F13, 0x54ED,
  0x659B, 0x66F2, 0x688F, 0x7A40, 0x8C37, 0x9D60, 0x56F0, 0x5764,
  0x5D11, 0x6606, 0x68B1, 0x68CD, 0x6EFE, 0x7428, 0x889E, 0x9BE4,
  0x6C68, 0xF904, 0x9AA8, 0x4F9B, 0x516C, 0x5171, 0x529F, 0x5B54,
  0x5DE5, 0x6050, 0x606D, 0x62F1, 0x63A7, 0x653B, 0x73D9, 0x7A7A,
  0x86A3, 0x8CA2, 0x978F, 0x4E32, 0x5BE1, 0x6208, 0x679C, 0x74DC,
  0x79D1, 0x83D3, 0x8A87, 0x8AB2, 0x8DE8, 0x904E, 0x934B, 0x9846,
  0x5ED3, 0x69E8, 0x85FF, 0x90ED, 0xF905, 0x51A0, 0x5B98, 0x5BEC,
  0x6163, 0x68FA, 0x6B3E, 0x704C, 0x742F, 0x74D8, 0x7BA1, 0x7F50,
  0x83C5, 0x89C0, 0x8CAB, 0x95DC, 0x9928, 0x522E, 0x605D, 0x62EC,
  0x9002, 0x4F8A, 0x5149, 0x5321, 0x58D9, 0x5EE3, 0x66E0, 0x6D38,
  0x709A, 0x72C2, 0x73D6, 0x7B50, 0x80F1, 0x945B, 0x5366, 0x639B,
  0x7F6B, 0x4E56, 0x5080, 0x584A, 0x58DE, 0x602A, 0x6127, 0x62D0,
  0x69D0, 0x9B41, 0x5B8F, 0x7D18, 0x80B1, 0x8F5F, 0x4EA4, 0x50D1,
  0x54AC, 0x55AC, 0x5B0C, 0x5DA0, 0x5DE7, 0x652A, 0x654E, 0x6821,
  0x6A4B, 0x72E1, 0x768E, 0x77EF, 0x7D5E, 0x7FF9, 0x81A0, 0x854E,
  0x86DF, 0x8F03, 0x8F4E, 0x90CA, 0x9903, 0x9A55, 0x9BAB, 0x4E18,
  0x4E45, 0x4E5D, 0x4EC7, 0x4FF1, 0x5177, 0x52FE, 0x5340, 0x53E3,
  0x53E5, 0x548E, 0x5614, 0x5775, 0x57A2, 0x5BC7, 0x5D87, 0x5ED0,
  0x61FC, 0x62D8, 0x6551, 0x67B8, 0x67E9, 0x69CB, 0x6B50, 0x6BC6,
  0x6BEC, 0x6C42, 0x6E9D, 0x7078, 0x72D7, 0x7396, 0x7403, 0x77BF,
  0x77E9, 0x7A76, 0x7D7F, 0x8009, 0x81FC, 0x8205, 0x820A, 0x82DF,
  0x8862, 0x8B33, 0x8CFC, 0x8EC0, 0x9011, 0x90B1, 0x9264, 0x92B6,
  0x99D2, 0x9A45, 0x9CE9, 0x9DD7, 0x9F9C, 0x570B, 0x5C40, 0x83CA,
  0x97A0, 0x97AB, 0x9EB4, 0x541B, 0x7A98, 0x7FA4, 0x88D9, 0x8ECD,
  0x90E1, 0x5800, 0x5C48, 0x6398, 0x7A9F, 0x5BAE, 0x5F13, 0x7A79,
  0x7AAE, 0x828E, 0x8EAC, 0x5026, 0x5238, 0x52F8, 0x5377, 0x5708,
  0x62F3, 0x6372, 0x6B0A, 0x6DC3, 0x7737, 0x53A5, 0x7357, 0x8568,
  0x8E76, 0x95D5, 0x673A, 0x6AC3, 0x6F70, 0x8A6D, 0x8ECC, 0x994B,
  0xF906, 0x6677, 0x6B78, 0x8CB4, 0x9B3C, 0xF907, 0x53EB, 0x572D,
  0x594E, 0x63C6, 0x69FB, 0x73EA, 0x7845, 0x7ABA, 0x7AC5, 0x7CFE,
  0x8475, 0x898F, 0x8D73, 0x9035, 0x95A8, 0x52FB, 0x5747, 0x7547,
  0x7B60, 0x83CC, 0x921E, 0xF908, 0x6A58, 0x514B, 0x524B, 0x5287,
  0x621F, 0x68D8, 0x6975, 0x9699, 0x50C5, 0x52A4, 0x52E4, 0x61C3,
  0x65A4, 0x6839, 0x69FF, 0x747E, 0x7B4B, 0x82B9, 0x83EB, 0x89B2,
  0x8B39, 0x8FD1, 0x9949, 0xF909, 0x4ECA, 0x5997, 0x64D2, 0x6611,
  0x6A8E, 0x7434, 0x7981, 0x79BD, 0x82A9, 0x887E, 0x887F, 0x895F,
  0xF90A, 0x9326, 0x4F0B, 0x53CA, 0x6025, 0x6271, 0x6C72, 0x7D1A,
  0x7D66, 0x4E98, 0x5162, 0x77DC, 0x80AF, 0x4F01, 0x4F0E, 0x5176,
  0x5180, 0x55DC, 0x5668, 0x573B, 0x57FA, 0x57FC, 0x5914, 0x5947,
  0x5993, 0x5BC4, 0x5C90, 0x5D0E, 0x5DF1, 0x5E7E, 0x5FCC, 0x6280,
  0x65D7, 0x65E3, 0x671E, 0x671F, 0x675E, 0x68CB, 0x68C4, 0x6A5F,
  0x6B3A, 0x6C23, 0x6C7D, 0x6C82, 0x6DC7, 0x7398, 0x7426, 0x742A,
  0x7482, 0x74A3, 0x7578, 0x757F, 0x7881, 0x78EF, 0x7941, 0x7947,
  0x7948, 0x797A, 0x7B95, 0x7D00, 0x7DBA, 0x7F88, 0x8006, 0x802D,
  0x808C, 0x8A18, 0x8B4F, 0x8C48, 0x8D77, 0x9321, 0x9324, 0x98E2,
  0x9951, 0x9A0E, 0x9A0F, 0x9A65, 0x9E92, 0x7DCA, 0x4F76, 0x5409,
  0x62EE, 0x6854, 0x91D1, 0x55AB, 0x513A, 0xF90B, 0xF90C, 0x5A1C,
  0x61E6, 0xF90D, 0x62CF, 0x62FF, 0xF90E, 0xF90F, 0xF910, 0xF911,
  0xF912, 0xF913, 0x90A3, 0xF914, 0xF915, 0xF916, 0xF917, 0xF918,
  0x8AFE, 0xF919, 0xF91A, 0xF91B, 0xF91C, 0x6696, 0xF91D, 0x7156,
  0xF91E, 0xF91F, 0x96E3, 0xF920, 0x634F, 0x637A, 0x5357, 0xF921,
  0x678F, 0x6960, 0x6E73, 0xF922, 0x7537, 0xF923, 0xF924, 0xF925,
  0x7D0D, 0xF926, 0xF927, 0x8872, 0x56CA, 0x5A18, 0xF928, 0xF929,
  0xF92A, 0xF92B, 0xF92C, 0x4E43, 0xF92D, 0x5167, 0x5948, 0x67F0,
  0x8010, 0xF92E, 0x5973, 0x5E74, 0x649A, 0x79CA, 0x5FF5, 0x606C,
  0x62C8, 0x637B, 0x5BE7, 0x5BD7, 0x52AA, 0xF92F, 0x5974, 0x5F29,
  0x6012, 0xF930, 0xF931, 0xF932, 0x7459, 0xF933, 0xF934, 0xF935,
  0xF936, 0xF937, 0xF938, 0x99D1,
  // [  4650,  4660] -> [0xF939,0xF943] # seg 46
  // [  4661,  8741] -v # seg 47 at pos 3514
  0x6FC3, 0xF944, 0xF945, 0x81BF, 0x8FB2, 0x60F1, 0xF946, 0xF947,
  0x8166, 0xF948, 0xF949, 0x5C3F, 0xF94A, 0xF94B, 0xF94C, 0xF94D,
  0xF94E, 0xF94F, 0xF950, 0xF951, 0x5AE9, 0x8A25, 0x677B, 0x7D10,
  0xF952, 0xF953, 0xF954, 0xF955, 0xF956, 0xF957, 0x80FD, 0xF958,
  0xF959, 0x5C3C, 0x6CE5, 0x533F, 0x6EBA, 0x591A, 0x8336, 0x4E39,
  0x4EB6, 0x4F46, 0x55AE, 0x5718, 0x58C7, 0x5F56, 0x65B7, 0x65E6,
  0x6A80, 0x6BB5, 0x6E4D, 0x77ED, 0x7AEF, 0x7C1E, 0x7DDE, 0x86CB,
  0x8892, 0x9132, 0x935B, 0x64BB, 0x6FBE, 0x737A, 0x75B8, 0x9054,
  0x5556, 0x574D, 0x61BA, 0x64D4, 0x66C7, 0x6DE1, 0x6E5B, 0x6F6D,
  0x6FB9, 0x75F0, 0x8043, 0x81BD, 0x8541, 0x8983, 0x8AC7, 0x8B5A,
  0x931F, 0x6C93, 0x7553, 0x7B54, 0x8E0F, 0x905D, 0x5510, 0x5802,
  0x5858, 0x5E62, 0x6207, 0x649E, 0x68E0, 0x7576, 0x7CD6, 0x87B3,
  0x9EE8, 0x4EE3, 0x5788, 0x576E, 0x5927, 0x5C0D, 0x5CB1, 0x5E36,
  0x5F85, 0x6234, 0x64E1, 0x73B3, 0x81FA, 0x888B, 0x8CB8, 0x968A,
  0x9EDB, 0x5B85, 0x5FB7, 0x60B3, 0x5012, 0x5200, 0x5230, 0x5716,
  0x5835, 0x5857, 0x5C0E, 0x5C60, 0x5CF6, 0x5D8B, 0x5EA6, 0x5F92,
  0x60BC, 0x6311, 0x6389, 0x6417, 0x6843, 0x68F9, 0x6AC2, 0x6DD8,
  0x6E21, 0x6ED4, 0x6FE4, 0x71FE, 0x76DC, 0x7779, 0x79B1, 0x7A3B,
  0x8404, 0x89A9, 0x8CED, 0x8DF3, 0x8E48, 0x9003, 0x9014, 0x9053,
  0x90FD, 0x934D, 0x9676, 0x97DC, 0x6BD2, 0x7006, 0x7258, 0x72A2,
  0x7368, 0x7763, 0x79BF, 0x7BE4, 0x7E9B, 0x8B80, 0x58A9, 0x60C7,
  0x6566, 0x65FD, 0x66BE, 0x6C8C, 0x711E, 0x71C9, 0x8C5A, 0x9813,
  0x4E6D, 0x7A81, 0x4EDD, 0x51AC, 0x51CD, 0x52D5, 0x540C, 0x61A7,
  0x6771, 0x6850, 0x68DF, 0x6D1E, 0x6F7C, 0x75BC, 0x77B3, 0x7AE5,
  0x80F4, 0x8463, 0x9285, 0x515C, 0x6597, 0x675C, 0x6793, 0x75D8,
  0x7AC7, 0x8373, 0xF95A, 0x8C46, 0x9017, 0x982D, 0x5C6F, 0x81C0,
  0x829A, 0x9041, 0x906F, 0x920D, 0x5F97, 0x5D9D, 0x6A59, 0x71C8,
  0x767B, 0x7B49, 0x85E4, 0x8B04, 0x9127, 0x9A30, 0x5587, 0x61F6,
  0xF95B, 0x7669, 0x7F85, 0x863F, 0x87BA, 0x88F8, 0x908F, 0xF95C,
  0x6D1B, 0x70D9, 0x73DE, 0x7D61, 0x843D, 0xF95D, 0x916A, 0x99F1,
  0xF95E, 0x4E82, 0x5375, 0x6B04, 0x6B12, 0x703E, 0x721B, 0x862D,
  0x9E1E, 0x524C, 0x8FA3, 0x5D50, 0x64E5, 0x652C, 0x6B16, 0x6FEB,
  0x7C43, 0x7E9C, 0x85CD, 0x8964, 0x89BD, 0x62C9, 0x81D8, 0x881F,
  0x5ECA, 0x6717, 0x6D6A, 0x72FC, 0x7405, 0x746F, 0x8782, 0x90DE,
  0x4F86, 0x5D0D, 0x5FA0, 0x840A, 0x51B7, 0x63A0, 0x7565, 0x4EAE,
  0x5006, 0x5169, 0x51C9, 0x6881, 0x6A11, 0x7CAE, 0x7CB1, 0x7CE7,
  0x826F, 0x8AD2, 0x8F1B, 0x91CF, 0x4FB6, 0x5137, 0x52F5, 0x5442,
  0x5EEC, 0x616E, 0x623E, 0x65C5, 0x6ADA, 0x6FFE, 0x792A, 0x85DC,
  0x8823, 0x95AD, 0x9A62, 0x9A6A, 0x9E97, 0x9ECE, 0x529B, 0x66C6,
  0x6B77, 0x701D, 0x792B, 0x8F62, 0x9742, 0x6190, 0x6200, 0x6523,
  0x6F23, 0x7149, 0x7489, 0x7DF4, 0x806F, 0x84EE, 0x8F26, 0x9023,
  0x934A, 0x51BD, 0x5217, 0x52A3, 0x6D0C, 0x70C8, 0x88C2, 0x5EC9,
  0x6582, 0x6BAE, 0x6FC2, 0x7C3E, 0x7375, 0x4EE4, 0x4F36, 0x56F9,
  0xF95F, 0x5CBA, 0x5DBA, 0x601C, 0x73B2, 0x7B2D, 0x7F9A, 0x7FCE,
  0x8046, 0x901E, 0x9234, 0x96F6, 0x9748, 0x9818, 0x9F61, 0x4F8B,
  0x6FA7, 0x79AE, 0x91B4, 0x96B7, 0x52DE, 0xF960, 0x6488, 0x64C4,
  0x6AD3, 0x6F5E, 0x7018, 0x7210, 0x76E7, 0x8001, 0x8606, 0x865C,
  0x8DEF, 0x8F05, 0x9732, 0x9B6F, 0x9DFA, 0x9E75, 0x788C, 0x797F,
  0x7DA0, 0x83C9, 0x9304, 0x9E7F, 0x9E93, 0x8AD6, 0x58DF, 0x5F04,
  0x6727, 0x7027, 0x74CF, 0x7C60, 0x807E, 0x5121, 0x7028, 0x7262,
  0x78CA, 0x8CC2, 0x8CDA, 0x8CF4, 0x96F7, 0x4E86, 0x50DA, 0x5BEE,
  0x5ED6, 0x6599, 0x71CE, 0x7642, 0x77AD, 0x804A, 0x84FC, 0x907C,
  0x9B27, 0x9F8D, 0x58D8, 0x5A41, 0x5C62, 0x6A13, 0x6DDA, 0x6F0F,
  0x763B, 0x7D2F, 0x7E37, 0x851E, 0x8938, 0x93E4, 0x964B, 0x5289,
  0x65D2, 0x67F3, 0x69B4, 0x6D41, 0x6E9C, 0x700F, 0x7409, 0x7460,
  0x7559, 0x7624, 0x786B, 0x8B2C, 0x985E, 0x516D, 0x622E, 0x9678,
  0x4F96, 0x502B, 0x5D19, 0x6DEA, 0x7DB8, 0x8F2A, 0x5F8B, 0x6144,
  0x6817, 0xF961, 0x9686, 0x52D2, 0x808B, 0x51DC, 0x51CC, 0x695E,
  0x7A1C, 0x7DBE, 0x83F1, 0x9675, 0x4FDA, 0x5229, 0x5398, 0x540F,
  0x550E, 0x5C65, 0x60A7, 0x674E, 0x68A8, 0x6D6C, 0x7281, 0x72F8,
  0x7406, 0x7483, 0xF962, 0x75E2, 0x7C6C, 0x7F79, 0x7FB8, 0x8389,
  0x88CF, 0x88E1, 0x91CC, 0x91D0, 0x96E2, 0x9BC9, 0x541D, 0x6F7E,
  0x71D0, 0x7498, 0x85FA, 0x8EAA, 0x96A3, 0x9C57, 0x9E9F, 0x6797,
  0x6DCB, 0x7433, 0x81E8, 0x9716, 0x782C, 0x7ACB, 0x7B20, 0x7C92,
  0x6469, 0x746A, 0x75F2, 0x78BC, 0x78E8, 0x99AC, 0x9B54, 0x9EBB,
  0x5BDE, 0x5E55, 0x6F20, 0x819C, 0x83AB, 0x9088, 0x4E07, 0x534D,
  0x5A29, 0x5DD2, 0x5F4E, 0x6162, 0x633D, 0x6669, 0x66FC, 0x6EFF,
  0x6F2B, 0x7063, 0x779E, 0x842C, 0x8513, 0x883B, 0x8F13, 0x9945,
  0x9C3B, 0x551C, 0x62B9, 0x672B, 0x6CAB, 0x8309, 0x896A, 0x977A,
  0x4EA1, 0x5984, 0x5FD8, 0x5FD9, 0x671B, 0x7DB2, 0x7F54, 0x8292,
  0x832B, 0x83BD, 0x8F1E, 0x9099, 0x57CB, 0x59B9, 0x5A92, 0x5BD0,
  0x6627, 0x679A, 0x6885, 0x6BCF, 0x7164, 0x7F75, 0x8CB7, 0x8CE3,
  0x9081, 0x9B45, 0x8108, 0x8C8A, 0x964C, 0x9A40, 0x9EA5, 0x5B5F,
  0x6C13, 0x731B, 0x76F2, 0x76DF, 0x840C, 0x51AA, 0x8993, 0x514D,
  0x5195, 0x52C9, 0x68C9, 0x6C94, 0x7704, 0x7720, 0x7DBF, 0x7DEC,
  0x9762, 0x9EB5, 0x6EC5, 0x8511, 0x51A5, 0x540D, 0x547D, 0x660E,
  0x669D, 0x6927, 0x6E9F, 0x76BF, 0x7791, 0x8317, 0x84C2, 0x879F,
  0x9169, 0x9298, 0x9CF4, 0x8882, 0x4FAE, 0x5192, 0x52DF, 0x59C6,
  0x5E3D, 0x6155, 0x6478, 0x6479, 0x66AE, 0x67D0, 0x6A21, 0x6BCD,
  0x6BDB, 0x725F, 0x7261, 0x7441, 0x7738, 0x77DB, 0x8017, 0x82BC,
  0x8305, 0x8B00, 0x8B28, 0x8C8C, 0x6728, 0x6C90, 0x7267, 0x76EE,
  0x7766, 0x7A46, 0x9DA9, 0x6B7F, 0x6C92, 0x5922, 0x6726, 0x8499,
  0x536F, 0x5893, 0x5999, 0x5EDF, 0x63CF, 0x6634, 0x6773, 0x6E3A,
  0x732B, 0x7AD7, 0x82D7, 0x9328, 0x52D9, 0x5DEB, 0x61AE, 0x61CB,
  0x620A, 0x62C7, 0x64AB, 0x65E0, 0x6959, 0x6B66, 0x6BCB, 0x7121,
  0x73F7, 0x755D, 0x7E46, 0x821E, 0x8302, 0x856A, 0x8AA3, 0x8CBF,
  0x9727, 0x9D61, 0x58A8, 0x9ED8, 0x5011, 0x520E, 0x543B, 0x554F,
  0x6587, 0x6C76, 0x7D0A, 0x7D0B, 0x805E, 0x868A, 0x9580, 0x96EF,
  0x52FF, 0x6C95, 0x7269, 0x5473, 0x5A9A, 0x5C3E, 0x5D4B, 0x5F4C,
  0x5FAE, 0x672A, 0x68B6, 0x6963, 0x6E3C, 0x6E44, 0x7709, 0x7C73,
  0x7F8E, 0x8587, 0x8B0E, 0x8FF7, 0x9761, 0x9EF4, 0x5CB7, 0x60B6,
  0x610D, 0x61AB, 0x654F, 0x65FB, 0x65FC, 0x6C11, 0x6CEF, 0x739F,
  0x73C9, 0x7DE1, 0x9594, 0x5BC6, 0x871C, 0x8B10, 0x525D, 0x535A,
  0x62CD, 0x640F, 0x64B2, 0x6734, 0x6A38, 0x6CCA, 0x73C0, 0x749E,
  0x7B94, 0x7C95, 0x7E1B, 0x818A, 0x8236, 0x8584, 0x8FEB, 0x96F9,
  0x99C1, 0x4F34, 0x534A, 0x53CD, 0x53DB, 0x62CC, 0x642C, 0x6500,
  0x6591, 0x69C3, 0x6CEE, 0x6F58, 0x73ED, 0x7554, 0x7622, 0x76E4,
  0x76FC, 0x78D0, 0x78FB, 0x792C, 0x7D46, 0x822C, 0x87E0, 0x8FD4,
  0x9812, 0x98EF, 0x52C3, 0x62D4, 0x64A5, 0x6E24, 0x6F51, 0x767C,
  0x8DCB, 0x91B1, 0x9262, 0x9AEE, 0x9B43, 0x5023, 0x508D, 0x574A,
  0x59A8, 0x5C28, 0x5E47, 0x5F77, 0x623F, 0x653E, 0x65B9, 0x65C1,
  0x6609, 0x678B, 0x699C, 0x6EC2, 0x78C5, 0x7D21, 0x80AA, 0x8180,
  0x822B, 0x82B3, 0x84A1, 0x868C, 0x8A2A, 0x8B17, 0x90A6, 0x9632,
  0x9F90, 0x500D, 0x4FF3, 0xF963, 0x57F9, 0x5F98, 0x62DC, 0x6392,
  0x676F, 0x6E43, 0x7119, 0x76C3, 0x80CC, 0x80DA, 0x88F4, 0x88F5,
  0x8919, 0x8CE0, 0x8F29, 0x914D, 0x966A, 0x4F2F, 0x4F70, 0x5E1B,
  0x67CF, 0x6822, 0x767D, 0x767E, 0x9B44, 0x5E61, 0x6A0A, 0x7169,
  0x71D4, 0x756A, 0xF964, 0x7E41, 0x8543, 0x85E9, 0x98DC, 0x4F10,
  0x7B4F, 0x7F70, 0x95A5, 0x51E1, 0x5E06, 0x68B5, 0x6C3E, 0x6C4E,
  0x6CDB, 0x72AF, 0x7BC4, 0x8303, 0x6CD5, 0x743A, 0x50FB, 0x5288,
  0x58C1, 0x64D8, 0x6A97, 0x74A7, 0x7656, 0x78A7, 0x8617, 0x95E2,
  0x9739, 0xF965, 0x535E, 0x5F01, 0x8B8A, 0x8FA8, 0x8FAF, 0x908A,
  0x5225, 0x77A5, 0x9C49, 0x9F08, 0x4E19, 0x5002, 0x5175, 0x5C5B,
  0x5E77, 0x661E, 0x663A, 0x67C4, 0x68C5, 0x70B3, 0x7501, 0x75C5,
  0x79C9, 0x7ADD, 0x8F27, 0x9920, 0x9A08, 0x4FDD, 0x5821, 0x5831,
  0x5BF6, 0x666E, 0x6B65, 0x6D11, 0x6E7A, 0x6F7D, 0x73E4, 0x752B,
  0x83E9, 0x88DC, 0x8913, 0x8B5C, 0x8F14, 0x4F0F, 0x50D5, 0x5310,
  0x535C, 0x5B93, 0x5FA9, 0x670D, 0x798F, 0x8179, 0x832F, 0x8514,
  0x8907, 0x8986, 0x8F39, 0x8F3B, 0x99A5, 0x9C12, 0x672C, 0x4E76,
  0x4FF8, 0x5949, 0x5C01, 0x5CEF, 0x5CF0, 0x6367, 0x68D2, 0x70FD,
  0x71A2, 0x742B, 0x7E2B, 0x84EC, 0x8702, 0x9022, 0x92D2, 0x9CF3,
  0x4E0D, 0x4ED8, 0x4FEF, 0x5085, 0x5256, 0x526F, 0x5426, 0x5490,
  0x57E0, 0x592B, 0x5A66, 0x5B5A, 0x5B75, 0x5BCC, 0x5E9C, 0xF966,
  0x6276, 0x6577, 0x65A7, 0x6D6E, 0x6EA5, 0x7236, 0x7B26, 0x7C3F,
  0x7F36, 0x8150, 0x8151, 0x819A, 0x8240, 0x8299, 0x83A9, 0x8A03,
  0x8CA0, 0x8CE6, 0x8CFB, 0x8D74, 0x8DBA, 0x90E8, 0x91DC, 0x961C,
  0x9644, 0x99D9, 0x9CE7, 0x5317, 0x5206, 0x5429, 0x5674, 0x58B3,
  0x5954, 0x596E, 0x5FFF, 0x61A4, 0x626E, 0x6610, 0x6C7E, 0x711A,
  0x76C6, 0x7C89, 0x7CDE, 0x7D1B, 0x82AC, 0x8CC1, 0x96F0, 0xF967,
  0x4F5B, 0x5F17, 0x5F7F, 0x62C2, 0x5D29, 0x670B, 0x68DA, 0x787C,
  0x7E43, 0x9D6C, 0x4E15, 0x5099, 0x5315, 0x532A, 0x5351, 0x5983,
  0x5A62, 0x5E87, 0x60B2, 0x618A, 0x6249, 0x6279, 0x6590, 0x6787,
  0x69A7, 0x6BD4, 0x6BD6, 0x6BD7, 0x6BD8, 0x6CB8, 0xF968, 0x7435,
  0x75FA, 0x7812, 0x7891, 0x79D5, 0x79D8, 0x7C83, 0x7DCB, 0x7FE1,
  0x80A5, 0x813E, 0x81C2, 0x83F2, 0x871A, 0x88E8, 0x8AB9, 0x8B6C,
  0x8CBB, 0x9119, 0x975E, 0x98DB, 0x9F3B, 0x56AC, 0x5B2A, 0x5F6C,
  0x658C, 0x6AB3, 0x6BAF, 0x6D5C, 0x6FF1, 0x7015, 0x725D, 0x73AD,
  0x8CA7, 0x8CD3, 0x983B, 0x6191, 0x6C37, 0x8058, 0x9A01, 0x4E4D,
  0x4E8B, 0x4E9B, 0x4ED5, 0x4F3A, 0x4F3C, 0x4F7F, 0x4FDF, 0x50FF,
  0x53F2, 0x53F8, 0x5506, 0x55E3, 0x56DB, 0x58EB, 0x5962, 0x5A11,
  0x5BEB, 0x5BFA, 0x5C04, 0x5DF3, 0x5E2B, 0x5F99, 0x601D, 0x6368,
  0x659C, 0x65AF, 0x67F6, 0x67FB, 0x68AD, 0x6B7B, 0x6C99, 0x6CD7,
  0x6E23, 0x7009, 0x7345, 0x7802, 0x793E, 0x7940, 0x7960, 0x79C1,
  0x7BE9, 0x7D17, 0x7D72, 0x8086, 0x820D, 0x838E, 0x84D1, 0x86C7,
  0x88DF, 0x8A50, 0x8A5E, 0x8B1D, 0x8CDC, 0x8D66, 0x8FAD, 0x90AA,
  0x98FC, 0x99DF, 0x9E9D, 0x524A, 0xF969, 0x6714, 0xF96A, 0x5098,
  0x522A, 0x5C71, 0x6563, 0x6C55, 0x73CA, 0x7523, 0x759D, 0x7B97,
  0x849C, 0x9178, 0x9730, 0x4E77, 0x6492, 0x6BBA, 0x715E, 0x85A9,
  0x4E09, 0xF96B, 0x6749, 0x68EE, 0x6E17, 0x829F, 0x8518, 0x886B,
  0x63F7, 0x6F81, 0x9212, 0x98AF, 0x4E0A, 0x50B7, 0x50CF, 0x511F,
  0x5546, 0x55AA, 0x5617, 0x5B40, 0x5C19, 0x5CE0, 0x5E38, 0x5E8A,
  0x5EA0, 0x5EC2, 0x60F3, 0x6851, 0x6A61, 0x6E58, 0x723D, 0x7240,
  0x72C0, 0x76F8, 0x7965, 0x7BB1, 0x7FD4, 0x88F3, 0x89F4, 0x8A73,
  0x8C61, 0x8CDE, 0x971C, 0x585E, 0x74BD, 0x8CFD, 0x55C7, 0xF96C,
  0x7A61, 0x7D22, 0x8272, 0x7272, 0x751F, 0x7525, 0xF96D, 0x7B19,
  0x5885, 0x58FB, 0x5DBC, 0x5E8F, 0x5EB6, 0x5F90, 0x6055, 0x6292,
  0x637F, 0x654D, 0x6691, 0x66D9, 0x66F8, 0x6816, 0x68F2, 0x7280,
  0x745E, 0x7B6E, 0x7D6E, 0x7DD6, 0x7F72, 0x80E5, 0x8212, 0x85AF,
  0x897F, 0x8A93, 0x901D, 0x92E4, 0x9ECD, 0x9F20, 0x5915, 0x596D,
  0x5E2D, 0x60DC, 0x6614, 0x6673, 0x6790, 0x6C50, 0x6DC5, 0x6F5F,
  0x77F3, 0x78A9, 0x84C6, 0x91CB, 0x932B, 0x4ED9, 0x50CA, 0x5148,
  0x5584, 0x5B0B, 0x5BA3, 0x6247, 0x657E, 0x65CB, 0x6E32, 0x717D,
  0x7401, 0x7444, 0x7487, 0x74BF, 0x766C, 0x79AA, 0x7DDA, 0x7E55,
  0x7FA8, 0x817A, 0x81B3, 0x8239, 0x861A, 0x87EC, 0x8A75, 0x8DE3,
  0x9078, 0x9291, 0x9425, 0x994D, 0x9BAE, 0x5368, 0x5C51, 0x6954,
  0x6CC4, 0x6D29, 0x6E2B, 0x820C, 0x859B, 0x893B, 0x8A2D, 0x8AAA,
  0x96EA, 0x9F67, 0x5261, 0x66B9, 0x6BB2, 0x7E96, 0x87FE, 0x8D0D,
  0x9583, 0x965D, 0x651D, 0x6D89, 0x71EE, 0xF96E, 0x57CE, 0x59D3,
  0x5BAC, 0x6027, 0x60FA, 0x6210, 0x661F, 0x665F, 0x7329, 0x73F9,
  0x76DB, 0x7701, 0x7B6C, 0x8056, 0x8072, 0x8165, 0x8AA0, 0x9192,
  0x4E16, 0x52E2, 0x6B72, 0x6D17, 0x7A05, 0x7B39, 0x7D30, 0xF96F,
  0x8CB0, 0x53EC, 0x562F, 0x5851, 0x5BB5, 0x5C0F, 0x5C11, 0x5DE2,
  0x6240, 0x6383, 0x6414, 0x662D, 0x68B3, 0x6CBC, 0x6D88, 0x6EAF,
  0x701F, 0x70A4, 0x71D2, 0x7526, 0x758F, 0x758E, 0x7619, 0x7B11,
  0x7BE0, 0x7C2B, 0x7D20, 0x7D39, 0x852C, 0x856D, 0x8607, 0x8A34,
  0x900D, 0x9061, 0x90B5, 0x92B7, 0x97F6, 0x9A37, 0x4FD7, 0x5C6C,
  0x675F, 0x6D91, 0x7C9F, 0x7E8C, 0x8B16, 0x8D16, 0x901F, 0x5B6B,
  0x5DFD, 0x640D, 0x84C0, 0x905C, 0x98E1, 0x7387, 0x5B8B, 0x609A,
  0x677E, 0x6DDE, 0x8A1F, 0x8AA6, 0x9001, 0x980C, 0x5237, 0xF970,
  0x7051, 0x788E, 0x9396, 0x8870, 0x91D7, 0x4FEE, 0x53D7, 0x55FD,
  0x56DA, 0x5782, 0x58FD, 0x5AC2, 0x5B88, 0x5CAB, 0x5CC0, 0x5E25,
  0x6101, 0x620D, 0x624B, 0x6388, 0x641C, 0x6536, 0x6578, 0x6A39,
  0x6B8A, 0x6C34, 0x6D19, 0x6F31, 0x71E7, 0x72E9, 0x7378, 0x7407,
  0x74B2, 0x7626, 0x7761, 0x79C0, 0x7A57, 0x7AEA, 0x7CB9, 0x7D8F,
  0x7DAC, 0x7E61, 0x7F9E, 0x8129, 0x8331, 0x8490, 0x84DA, 0x85EA,
  0x8896, 0x8AB0, 0x8B90, 0x8F38, 0x9042, 0x9083, 0x916C, 0x9296,
  0x92B9, 0x968B, 0x96A7, 0x96A8, 0x96D6, 0x9700, 0x9808, 0x9996,
  0x9AD3, 0x9B1A, 0x53D4, 0x587E, 0x5919, 0x5B70, 0x5BBF, 0x6DD1,
  0x6F5A, 0x719F, 0x7421, 0x74B9, 0x8085, 0x83FD, 0x5DE1, 0x5F87,
  0x5FAA, 0x6042, 0x65EC, 0x6812, 0x696F, 0x6A53, 0x6B89, 0x6D35,
  0x6DF3, 0x73E3, 0x76FE, 0x77AC, 0x7B4D, 0x7D14, 0x8123, 0x821C,
  0x8340, 0x84F4, 0x8563, 0x8A62, 0x8AC4, 0x9187, 0x931E, 0x9806,
  0x99B4, 0x620C, 0x8853, 0x8FF0, 0x9265, 0x5D07, 0x5D27, 0x5D69,
  0x745F, 0x819D, 0x8768, 0x6FD5, 0x62FE, 0x7FD2, 0x8936, 0x8972,
  0x4E1E, 0x4E58, 0x50E7, 0x52DD, 0x5347, 0x627F, 0x6607, 0x7E69,
  0x8805, 0x965E, 0x4F8D, 0x5319, 0x5636, 0x59CB, 0x5AA4, 0x5C38,
  0x5C4E, 0x5C4D, 0x5E02, 0x5F11, 0x6043, 0x65BD, 0x662F, 0x6642,
  0x67BE, 0x67F4, 0x731C, 0x77E2, 0x793A, 0x7FC5, 0x8494, 0x84CD,
  0x8996, 0x8A66, 0x8A69, 0x8AE1, 0x8C55, 0x8C7A, 0x57F4, 0x5BD4,
  0x5F0F, 0x606F, 0x62ED, 0x690D, 0x6B96, 0x6E5C, 0x7184, 0x7BD2,
  0x8755, 0x8B58, 0x8EFE, 0x98DF, 0x98FE, 0x4F38, 0x4F81, 0x4FE1,
  0x547B, 0x5A20, 0x5BB8, 0x613C, 0x65B0, 0x6668, 0x71FC, 0x7533,
  0x795E, 0x7D33, 0x814E, 0x81E3, 0x8398, 0x85AA, 0x85CE, 0x8703,
  0x8A0A, 0x8EAB, 0x8F9B, 0xF971, 0x8FC5, 0x5931, 0x5BA4, 0x5BE6,
  0x6089, 0x5BE9, 0x5C0B, 0x5FC3, 0x6C81, 0xF972, 0x6DF1, 0x700B,
  0x751A, 0x82AF, 0x8AF6, 0x4EC0, 0x5341, 0xF973, 0x96D9, 0x6C0F,
  0x4E9E, 0x4FC4, 0x5152, 0x555E, 0x5A25, 0x5CE8, 0x6211, 0x7259,
  0x82BD, 0x83AA, 0x86FE, 0x8859, 0x8A1D, 0x963F, 0x96C5, 0x9913,
  0x9D09, 0x9D5D, 0x580A, 0x5CB3, 0x5DBD, 0x5E44, 0x60E1, 0x6115,
  0x63E1, 0x6A02, 0x6E25, 0x9102, 0x9354, 0x984E, 0x9C10, 0x9F77,
  0x5B89, 0x5CB8, 0x6309, 0x664F, 0x6848, 0x773C, 0x96C1, 0x978D,
  0x9854, 0x9B9F, 0x65A1, 0x8B01, 0x8ECB, 0x95BC, 0x5535, 0x5CA9,
  0x5DD6, 0x5EB5, 0x6697, 0x764C, 0x83F4, 0x95C7, 0x58D3, 0x62BC,
  0x72CE, 0x9D28, 0x4EF0, 0x592E, 0x600F, 0x663B, 0x6B83, 0x79E7,
  0x9D26, 0x5393, 0x54C0, 0x57C3, 0x5D16, 0x611B, 0x66D6, 0x6DAF,
  0x788D, 0x827E, 0x9698, 0x9744, 0x5384, 0x627C, 0x6396, 0x6DB2,
  0x7E0A, 0x814B, 0x984D, 0x6AFB, 0x7F4C, 0x9DAF, 0x9E1A, 0x4E5F,
  0x503B, 0x51B6, 0x591C, 0x60F9, 0x63F6, 0x6930, 0x723A, 0x8036,
  0xF974, 0x91CE, 0x5F31, 0xF975, 0xF976, 0x7D04, 0x82E5, 0x846F,
  0x84BB, 0x85E5, 0x8E8D, 0xF977, 0x4F6F, 0xF978, 0xF979, 0x58E4,
  0x5B43, 0x6059, 0x63DA, 0x6518, 0x656D, 0x6698, 0xF97A, 0x694A,
  0x6A23, 0x6D0B, 0x7001, 0x716C, 0x75D2, 0x760D, 0x79B3, 0x7A70,
  0xF97B, 0x7F8A, 0xF97C, 0x8944, 0xF97D, 0x8B93, 0x91C0, 0x967D,
  0xF97E, 0x990A, 0x5704, 0x5FA1, 0x65BC, 0x6F01, 0x7600, 0x79A6,
  0x8A9E, 0x99AD, 0x9B5A, 0x9F6C, 0x5104, 0x61B6, 0x6291, 0x6A8D,
  0x81C6, 0x5043, 0x5830, 0x5F66, 0x7109, 0x8A00, 0x8AFA, 0x5B7C,
  0x8616, 0x4FFA, 0x513C, 0x56B4, 0x5944, 0x63A9, 0x6DF9, 0x5DAA,
  0x696D, 0x5186, 0x4E88, 0x4F59, 0xF97F, 0xF980, 0xF981, 0x5982,
  0xF982, 0xF983, 0x6B5F, 0x6C5D, 0xF984, 0x74B5, 0x7916, 0xF985,
  0x8207, 0x8245, 0x8339, 0x8F3F, 0x8F5D, 0xF986, 0x9918, 0xF987,
  0xF988, 0xF989, 0x4EA6, 0xF98A, 0x57DF, 0x5F79, 0x6613, 0xF98B,
  0xF98C, 0x75AB, 0x7E79, 0x8B6F, 0xF98D, 0x9006, 0x9A5B, 0x56A5,
  0x5827, 0x59F8, 0x5A1F, 0x5BB4, 0xF98E, 0x5EF6, 0xF98F, 0xF990,
  0x6350, 0x633B, 0xF991, 0x693D, 0x6C87, 0x6CBF, 0x6D8E, 0x6D93,
  0x6DF5, 0x6F14, 0xF992, 0x70DF, 0x7136, 0x7159, 0xF993, 0x71C3,
  0x71D5, 0xF994, 0x784F, 0x786F, 0xF995, 0x7B75, 0x7DE3, 0xF996,
  0x7E2F, 0xF997, 0x884D, 0x8EDF, 0xF998, 0xF999, 0xF99A, 0x925B,
  0xF99B, 0x9CF6, 0xF99C, 0xF99D, 0xF99E, 0x6085, 0x6D85, 0xF99F,
  0x71B1, 0xF9A0, 0xF9A1, 0x95B1, 0x53AD, 0xF9A2, 0xF9A3, 0xF9A4,
  0x67D3, 0xF9A5, 0x708E, 0x7130, 0x7430, 0x8276, 0x82D2, 0xF9A6,
  0x95BB, 0x9AE5, 0x9E7D, 0x66C4, 0xF9A7, 0x71C1, 0x8449, 0xF9A8,
  0xF9A9, 0x584B, 0xF9AA, 0xF9AB, 0x5DB8, 0x5F71, 0xF9AC, 0x6620,
  0x668E, 0x6979, 0x69AE, 0x6C38, 0x6CF3, 0x6E36, 0x6F41, 0x6FDA,
  0x701B, 0x702F, 0x7150, 0x71DF, 0x7370, 0xF9AD, 0x745B, 0xF9AE,
  0x74D4, 0x76C8, 0x7A4E, 0x7E93, 0xF9AF, 0xF9B0, 0x82F1, 0x8A60,
  0x8FCE, 0xF9B1, 0x9348, 0xF9B2, 0x9719, 0xF9B3, 0xF9B4, 0x4E42,
  0x502A, 0xF9B5, 0x5208, 0x53E1, 0x66F3, 0x6C6D, 0x6FCA, 0x730A,
  0x777F, 0x7A62, 0x82AE, 0x85DD, 0x8602, 0xF9B6, 0x88D4, 0x8A63,
  0x8B7D, 0x8C6B, 0xF9B7, 0x92B3, 0xF9B8, 0x9713, 0x9810, 0x4E94,
  0x4F0D, 0x4FC9, 0x50B2, 0x5348, 0x543E, 0x5433, 0x55DA, 0x5862,
  0x58BA, 0x5967, 0x5A1B, 0x5BE4, 0x609F, 0xF9B9, 0x61CA, 0x6556,
  0x65FF, 0x6664, 0x68A7, 0x6C5A, 0x6FB3, 0x70CF, 0x71AC, 0x7352,
  0x7B7D, 0x8708, 0x8AA4, 0x9C32, 0x9F07, 0x5C4B, 0x6C83, 0x7344,
  0x7389, 0x923A, 0x6EAB, 0x7465, 0x761F, 0x7A69, 0x7E15, 0x860A,
  0x5140, 0x58C5, 0x64C1, 0x74EE, 0x7515, 0x7670, 0x7FC1, 0x9095,
  0x96CD, 0x9954, 0x6E26, 0x74E6, 0x7AA9, 0x7AAA, 0x81E5, 0x86D9,
  0x8778, 0x8A1B, 0x5A49, 0x5B8C, 0x5B9B, 0x68A1, 0x6900, 0x6D63,
  0x73A9, 0x7413, 0x742C, 0x7897, 0x7DE9, 0x7FEB, 0x8118, 0x8155,
  0x839E, 0x8C4C, 0x962E, 0x9811, 0x66F0, 0x5F80, 0x65FA, 0x6789,
  0x6C6A, 0x738B, 0x502D, 0x5A03, 0x6B6A, 0x77EE, 0x5916, 0x5D6C,
  0x5DCD, 0x7325, 0x754F, 0xF9BA, 0xF9BB, 0x50E5, 0x51F9, 0x582F,
  0x592D, 0x5996, 0x59DA, 0x5BE5, 0xF9BC, 0xF9BD, 0x5DA2, 0x62D7,
  0x6416, 0x6493, 0x64FE, 0xF9BE, 0x66DC, 0xF9BF, 0x6A48, 0xF9C0,
  0x71FF, 0x7464, 0xF9C1, 0x7A88, 0x7AAF, 0x7E47, 0x7E5E, 0x8000,
  0x8170, 0xF9C2, 0x87EF, 0x8981, 0x8B20, 0x9059, 0xF9C3, 0x9080,
  0x9952, 0x617E, 0x6B32, 0x6D74, 0x7E1F, 0x8925, 0x8FB1, 0x4FD1,
  0x50AD, 0x5197, 0x52C7, 0x57C7, 0x5889, 0x5BB9, 0x5EB8, 0x6142,
  0x6995, 0x6D8C, 0x6E67, 0x6EB6, 0x7194, 0x7462, 0x7528, 0x752C,
  0x8073, 0x8338, 0x84C9, 0x8E0A, 0x9394, 0x93DE, 0xF9C4, 0x4E8E,
  0x4F51, 0x5076, 0x512A, 0x53C8, 0x53CB, 0x53F3, 0x5B87, 0x5BD3,
  0x5C24, 0x611A, 0x6182, 0x65F4, 0x725B, 0x7397, 0x7440, 0x76C2,
  0x7950, 0x7991, 0x79B9, 0x7D06, 0x7FBD, 0x828B, 0x85D5, 0x865E,
  0x8FC2, 0x9047, 0x90F5, 0x91EA, 0x9685, 0x96E8, 0x96E9, 0x52D6,
  0x5F67, 0x65ED, 0x6631, 0x682F, 0x715C, 0x7A36, 0x90C1, 0x980A,
  0x4E91, 0xF9C5, 0x6A52, 0x6B9E, 0x6F90, 0x7189, 0x8018, 0x82B8,
  0x8553, 0x904B, 0x9695, 0x96F2, 0x97FB, 0x851A, 0x9B31, 0x4E90,
  0x718A, 0x96C4, 0x5143, 0x539F, 0x54E1, 0x5713, 0x5712, 0x57A3,
  0x5A9B, 0x5AC4, 0x5BC3, 0x6028, 0x613F, 0x63F4, 0x6C85, 0x6D39,
  0x6E72, 0x6E90, 0x7230, 0x733F, 0x7457, 0x82D1, 0x8881, 0x8F45,
  0x9060, 0xF9C6, 0x9662, 0x9858, 0x9D1B, 0x6708, 0x8D8A, 0x925E,
  0x4F4D, 0x5049, 0x50DE, 0x5371, 0x570D, 0x59D4, 0x5A01, 0x5C09,
  0x6170, 0x6690, 0x6E2D, 0x7232, 0x744B, 0x7DEF, 0x80C3, 0x840E,
  0x8466, 0x853F, 0x875F, 0x885B, 0x8918, 0x8B02, 0x9055, 0x97CB,
  0x9B4F, 0x4E73, 0x4F91, 0x5112, 0x516A, 0xF9C7, 0x552F, 0x55A9,
  0x5B7A, 0x5BA5, 0x5E7C, 0x5E7D, 0x5EBE, 0x60A0, 0x60DF, 0x6108,
  0x6109, 0x63C4, 0x6538, 0x6709, 0xF9C8, 0x67D4, 0x67DA, 0xF9C9,
  0x6961, 0x6962, 0x6CB9, 0x6D27, 0xF9CA, 0x6E38, 0xF9CB, 0x6FE1,
  0x7336, 0x7337, 0xF9CC, 0x745C, 0x7531, 0xF9CD, 0x7652, 0xF9CE,
  0xF9CF, 0x7DAD, 0x81FE, 0x8438, 0x88D5, 0x8A98, 0x8ADB, 0x8AED,
  0x8E30, 0x8E42, 0x904A, 0x903E, 0x907A, 0x9149, 0x91C9, 0x936E,
  0xF9D0, 0xF9D1, 0x5809, 0xF9D2, 0x6BD3, 0x8089, 0x80B2, 0xF9D3,
  0xF9D4, 0x5141, 0x596B, 0x5C39, 0xF9D5, 0xF9D6, 0x6F64, 0x73A7,
  0x80E4, 0x8D07, 0xF9D7, 0x9217, 0x958F, 0xF9D8, 0xF9D9, 0xF9DA,
  0xF9DB, 0x807F, 0x620E, 0x701C, 0x7D68, 0x878D, 0xF9DC, 0x57A0,
  0x6069, 0x6147, 0x6BB7, 0x8ABE, 0x9280, 0x96B1, 0x4E59, 0x541F,
  0x6DEB, 0x852D, 0x9670, 0x97F3, 0x98EE, 0x63D6, 0x6CE3, 0x9091,
  0x51DD, 0x61C9, 0x81BA, 0x9DF9, 0x4F9D, 0x501A, 0x5100, 0x5B9C,
  0x610F, 0x61FF, 0x64EC, 0x6905, 0x6BC5, 0x7591, 0x77E3, 0x7FA9,
  0x8264, 0x858F, 0x87FB, 0x8863, 0x8ABC, 0x8B70, 0x91AB, 0x4E8C,
  0x4EE5, 0x4F0A, 0xF9DD, 0xF9DE, 0x5937, 0x59E8, 0xF9DF, 0x5DF2,
  0x5F1B, 0x5F5B, 0x6021, 0xF9E0, 0xF9E1, 0xF9E2, 0xF9E3, 0x723E,
  0x73E5, 0xF9E4, 0x7570, 0x75CD, 0xF9E5, 0x79FB, 0xF9E6, 0x800C,
  0x8033, 0x8084, 0x82E1, 0x8351, 0xF9E7, 0xF9E8, 0x8CBD, 0x8CB3,
  0x9087, 0xF9E9, 0xF9EA, 0x98F4, 0x990C, 0xF9EB, 0xF9EC, 0x7037,
  0x76CA, 0x7FCA, 0x7FCC, 0x7FFC, 0x8B1A, 0x4EBA, 0x4EC1, 0x5203,
  0x5370, 0xF9ED, 0x54BD, 0x56E0, 0x59FB, 0x5BC5, 0x5F15, 0x5FCD,
  0x6E6E, 0xF9EE, 0xF9EF, 0x7D6A, 0x8335, 0xF9F0, 0x8693, 0x8A8D,
  0xF9F1, 0x976D, 0x9777, 0xF9F2, 0xF9F3, 0x4E00, 0x4F5A, 0x4F7E,
  0x58F9, 0x65E5, 0x6EA2, 0x9038, 0x93B0, 0x99B9, 0x4EFB, 0x58EC,
  0x598A, 0x59D9, 0x6041, 0xF9F4, 0xF9F5, 0x7A14, 0xF9F6, 0x834F,
  0x8CC3, 0x5165, 0x5344, 0xF9F7, 0xF9F8, 0xF9F9, 0x4ECD, 0x5269,
  0x5B55, 0x82BF, 0x4ED4, 0x523A, 0x54A8, 0x59C9, 0x59FF, 0x5B50,
  0x5B57, 0x5B5C, 0x6063, 0x6148, 0x6ECB, 0x7099, 0x716E, 0x7386,
  0x74F7, 0x75B5, 0x78C1, 0x7D2B, 0x8005, 0x81EA, 0x8328, 0x8517,
  0x85C9, 0x8AEE, 0x8CC7, 0x96CC, 0x4F5C, 0x52FA, 0x56BC, 0x65AB,
  0x6628, 0x707C, 0x70B8, 0x7235, 0x7DBD, 0x828D, 0x914C, 0x96C0,
  0x9D72, 0x5B71, 0x68E7, 0x6B98, 0x6F7A, 0x76DE, 0x5C91, 0x66AB,
  0x6F5B, 0x7BB4, 0x7C2A, 0x8836, 0x96DC, 0x4E08, 0x4ED7, 0x5320,
  0x5834, 0x58BB, 0x58EF, 0x596C, 0x5C07, 0x5E33, 0x5E84, 0x5F35,
  0x638C, 0x66B2, 0x6756, 0x6A1F, 0x6AA3, 0x6B0C, 0x6F3F, 0x7246,
  0xF9FA, 0x7350, 0x748B, 0x7AE0, 0x7CA7, 0x8178, 0x81DF, 0x81E7,
  0x838A, 0x846C, 0x8523, 0x8594, 0x85CF, 0x88DD, 0x8D13, 0x91AC,
  0x9577, 0x969C, 0x518D, 0x54C9, 0x5728, 0x5BB0, 0x624D, 0x6750,
  0x683D, 0x6893, 0x6E3D, 0x6ED3, 0x707D, 0x7E21, 0x88C1, 0x8CA1,
  0x8F09, 0x9F4B, 0x9F4E, 0x722D, 0x7B8F, 0x8ACD, 0x931A, 0x4F47,
  0x4F4E, 0x5132, 0x5480, 0x59D0, 0x5E95, 0x62B5, 0x6775, 0x696E,
  0x6A17, 0x6CAE, 0x6E1A, 0x72D9, 0x732A, 0x75BD, 0x7BB8, 0x7D35,
  0x82E7, 0x83F9, 0x8457, 0x85F7, 0x8A5B, 0x8CAF, 0x8E87, 0x9019,
  0x90B8, 0x96CE, 0x9F5F, 0x52E3, 0x540A, 0x5AE1, 0x5BC2, 0x6458,
  0x6575, 0x6EF4, 0x72C4, 0xF9FB, 0x7684, 0x7A4D, 0x7B1B, 0x7C4D,
  0x7E3E, 0x7FDF, 0x837B, 0x8B2B, 0x8CCA, 0x8D64, 0x8DE1, 0x8E5F,
  0x8FEA, 0x8FF9, 0x9069, 0x93D1, 0x4F43, 0x4F7A, 0x50B3, 0x5168,
  0x5178, 0x524D, 0x526A, 0x5861, 0x587C, 0x5960, 0x5C08, 0x5C55,
  0x5EDB, 0x609B, 0x6230, 0x6813, 0x6BBF, 0x6C08, 0x6FB1, 0x714E,
  0x7420, 0x7530, 0x7538, 0x7551, 0x7672, 0x7B4C, 0x7B8B, 0x7BAD,
  0x7BC6, 0x7E8F, 0x8A6E, 0x8F3E, 0x8F49, 0x923F, 0x9293, 0x9322,
  0x942B, 0x96FB, 0x985A, 0x986B, 0x991E, 0x5207, 0x622A, 0x6298,
  0x6D59, 0x7664, 0x7ACA, 0x7BC0, 0x7D76, 0x5360, 0x5CBE, 0x5E97,
  0x6F38, 0x70B9, 0x7C98, 0x9711, 0x9B8E, 0x9EDE, 0x63A5, 0x647A,
  0x8776, 0x4E01, 0x4E95, 0x4EAD, 0x505C, 0x5075, 0x5448, 0x59C3,
  0x5B9A, 0x5E40, 0x5EAD, 0x5EF7, 0x5F81, 0x60C5, 0x633A, 0x653F,
  0x6574, 0x65CC, 0x6676, 0x6678, 0x67FE, 0x6968, 0x6A89, 0x6B63,
  0x6C40, 0x6DC0, 0x6DE8, 0x6E1F, 0x6E5E, 0x701E, 0x70A1, 0x738E,
  0x73FD, 0x753A, 0x775B, 0x7887, 0x798E, 0x7A0B, 0x7A7D, 0x7CBE,
  0x7D8E, 0x8247, 0x8A02, 0x8AEA, 0x8C9E, 0x912D, 0x914A, 0x91D8,
  0x9266, 0x92CC, 0x9320, 0x9706, 0x9756, 0x975C, 0x9802, 0x9F0E,
  0x5236, 0x5291, 0x557C, 0x5824, 0x5E1D, 0x5F1F, 0x608C, 0x63D0,
  0x68AF, 0x6FDF, 0x796D, 0x7B2C, 0x81CD, 0x85BA, 0x88FD, 0x8AF8,
  0x8E44, 0x918D, 0x9664, 0x969B, 0x973D, 0x984C, 0x9F4A, 0x4FCE,
  0x5146, 0x51CB, 0x52A9, 0x5632, 0x5F14, 0x5F6B, 0x63AA, 0x64CD,
  0x65E9, 0x6641, 0x66FA, 0x66F9, 0x671D, 0x689D, 0x68D7, 0x69FD,
  0x6F15, 0x6F6E, 0x7167, 0x71E5, 0x722A, 0x74AA, 0x773A, 0x7956,
  0x795A, 0x79DF, 0x7A20, 0x7A95, 0x7C97, 0x7CDF, 0x7D44, 0x7E70,
  0x8087, 0x85FB, 0x86A4, 0x8A54, 0x8ABF, 0x8D99, 0x8E81, 0x9020,
  0x906D, 0x91E3, 0x963B, 0x96D5, 0x9CE5, 0x65CF, 0x7C07, 0x8DB3,
  0x93C3, 0x5B58, 0x5C0A, 0x5352, 0x62D9, 0x731D, 0x5027, 0x5B97,
  0x5F9E, 0x60B0, 0x616B, 0x68D5, 0x6DD9, 0x742E, 0x7A2E, 0x7D42,
  0x7D9C, 0x7E31, 0x816B, 0x8E2A, 0x8E35, 0x937E, 0x9418, 0x4F50,
  0x5750, 0x5DE6, 0x5EA7, 0x632B, 0x7F6A, 0x4E3B, 0x4F4F, 0x4F8F,
  0x505A, 0x59DD, 0x80C4, 0x546A, 0x5468, 0x55FE, 0x594F, 0x5B99,
  0x5DDE, 0x5EDA, 0x665D, 0x6731, 0x67F1, 0x682A, 0x6CE8, 0x6D32,
  0x6E4A, 0x6F8D, 0x70B7, 0x73E0, 0x7587, 0x7C4C, 0x7D02, 0x7D2C,
  0x7DA2, 0x821F, 0x86DB, 0x8A3B, 0x8A85, 0x8D70, 0x8E8A, 0x8F33,
  0x9031, 0x914E, 0x9152, 0x9444, 0x99D0, 0x7AF9, 0x7CA5, 0x4FCA,
  0x5101, 0x51C6, 0x57C8, 0x5BEF, 0x5CFB, 0x6659, 0x6A3D, 0x6D5A,
  0x6E96, 0x6FEC, 0x710C, 0x756F, 0x7AE3, 0x8822, 0x9021, 0x9075,
  0x96CB, 0x99FF, 0x8301, 0x4E2D, 0x4EF2, 0x8846, 0x91CD, 0x537D,
  0x6ADB, 0x696B, 0x6C41, 0x847A, 0x589E, 0x618E, 0x66FE, 0x62EF,
  0x70DD, 0x7511, 0x75C7, 0x7E52, 0x84B8, 0x8B49, 0x8D08, 0x4E4B,
  0x53EA, 0x54AB, 0x5730, 0x5740, 0x5FD7, 0x6301, 0x6307, 0x646F,
  0x652F, 0x65E8, 0x667A, 0x679D, 0x67B3, 0x6B62, 0x6C60, 0x6C9A,
  0x6F2C, 0x77E5, 0x7825, 0x7949, 0x7957, 0x7D19, 0x80A2, 0x8102,
  0x81F3, 0x829D, 0x82B7, 0x8718, 0x8A8C, 0xF9FC, 0x8D04, 0x8DBE,
  0x9072, 0x76F4, 0x7A19, 0x7A37, 0x7E54, 0x8077, 0x5507, 0x55D4,
  0x5875, 0x632F, 0x6422, 0x6649, 0x664B, 0x686D, 0x699B, 0x6B84,
  0x6D25, 0x6EB1, 0x73CD, 0x7468, 0x74A1, 0x755B, 0x75B9, 0x76E1,
  0x771E, 0x778B, 0x79E6, 0x7E09, 0x7E1D, 0x81FB, 0x852F, 0x8897,
  0x8A3A, 0x8CD1, 0x8EEB, 0x8FB0, 0x9032, 0x93AD, 0x9663, 0x9673,
  0x9707, 0x4F84, 0x53F1, 0x59EA, 0x5AC9, 0x5E19, 0x684E, 0x74C6,
  0x75BE, 0x79E9, 0x7A92, 0x81A3, 0x86ED, 0x8CEA, 0x8DCC, 0x8FED,
  0x659F, 0x6715, 0xF9FD, 0x57F7, 0x6F57, 0x7DDD, 0x8F2F, 0x93F6,
  0x96C6, 0x5FB5, 0x61F2, 0x6F84, 0x4E14, 0x4F98, 0x501F, 0x53C9,
  0x55DF, 0x5D6F, 0x5DEE, 0x6B21, 0x6B64, 0x78CB, 0x7B9A, 0xF9FE,
  0x8E49, 0x8ECA, 0x906E, 0x6349, 0x643E, 0x7740, 0x7A84, 0x932F,
  0x947F, 0x9F6A, 0x64B0, 0x6FAF, 0x71E6, 0x74A8, 0x74DA, 0x7AC4,
  0x7C12, 0x7E82, 0x7CB2, 0x7E98, 0x8B9A, 0x8D0A, 0x947D, 0x9910,
  0x994C, 0x5239, 0x5BDF, 0x64E6, 0x672D, 0x7D2E, 0x50ED, 0x53C3,
  0x5879, 0x6158, 0x6159, 0x61FA, 0x65AC, 0x7AD9, 0x8B92, 0x8B96,
  0x5009, 0x5021, 0x5275, 0x5531, 0x5A3C, 0x5EE0, 0x5F70, 0x6134,
  0x655E, 0x660C, 0x6636, 0x66A2, 0x69CD, 0x6EC4, 0x6F32, 0x7316,
  0x7621, 0x7A93, 0x8139, 0x8259, 0x83D6, 0x84BC, 0x50B5, 0x57F0,
  0x5BC0, 0x5BE8, 0x5F69, 0x63A1, 0x7826, 0x7DB5, 0x83DC, 0x8521,
  0x91C7, 0x91F5, 0x518A, 0x67F5, 0x7B56, 0x8CAC, 0x51C4, 0x59BB,
  0x60BD, 0x8655, 0x501C, 0xF9FF, 0x5254, 0x5C3A, 0x617D, 0x621A,
  0x62D3, 0x64F2, 0x65A5, 0x6ECC, 0x7620, 0x810A, 0x8E60, 0x965F,
  0x96BB, 0x4EDF, 0x5343, 0x5598, 0x5929, 0x5DDD, 0x64C5, 0x6CC9,
  0x6DFA, 0x7394, 0x7A7F, 0x821B, 0x85A6, 0x8CE4, 0x8E10, 0x9077,
  0x91E7, 0x95E1, 0x9621, 0x97C6, 0x51F8, 0x54F2, 0x5586, 0x5FB9,
  0x64A4, 0x6F88, 0x7DB4, 0x8F1F, 0x8F4D, 0x9435, 0x50C9, 0x5C16,
  0x6CBE, 0x6DFB, 0x751B, 0x77BB, 0x7C3D, 0x7C64, 0x8A79, 0x8AC2,
  0x581E, 0x59BE, 0x5E16, 0x6377, 0x7252, 0x758A, 0x776B, 0x8ADC,
  0x8CBC, 0x8F12, 0x5EF3, 0x6674, 0x6DF8, 0x807D, 0x83C1, 0x8ACB,
  0x9751, 0x9BD6, 0xFA00, 0x5243, 0x66FF, 0x6D95, 0x6EEF, 0x7DE0,
  0x8AE6, 0x902E, 0x905E, 0x9AD4, 0x521D, 0x527F, 0x54E8, 0x6194,
  0x6284, 0x62DB, 0x68A2, 0x6912, 0x695A, 0x6A35, 0x7092, 0x7126,
  0x785D, 0x7901, 0x790E, 0x79D2, 0x7A0D, 0x8096, 0x8278, 0x82D5,
  0x8349, 0x8549, 0x8C82, 0x8D85, 0x9162, 0x918B, 0x91AE, 0x4FC3,
  0x56D1, 0x71ED, 0x77D7, 0x8700, 0x89F8, 0x5BF8, 0x5FD6, 0x6751,
  0x90A8, 0x53E2, 0x585A, 0x5BF5, 0x60A4, 0x6181, 0x6460, 0x7E3D,
  0x8070, 0x8525, 0x9283, 0x64AE, 0x50AC, 0x5D14, 0x6700, 0x589C,
  0x62BD, 0x63A8, 0x690E, 0x6978, 0x6A1E, 0x6E6B, 0x76BA, 0x79CB,
  0x82BB, 0x8429, 0x8ACF, 0x8DA8, 0x8FFD, 0x9112, 0x914B, 0x919C,
  0x9310, 0x9318, 0x939A, 0x96DB, 0x9A36, 0x9C0D, 0x4E11, 0x755C,
  0x795D, 0x7AFA, 0x7B51, 0x7BC9, 0x7E2E, 0x84C4, 0x8E59, 0x8E74,
  0x8EF8, 0x9010, 0x6625, 0x693F, 0x7443, 0x51FA, 0x672E, 0x9EDC,
  0x5145, 0x5FE0, 0x6C96, 0x87F2, 0x885D, 0x8877, 0x60B4, 0x81B5,
  0x8403, 0x8D05, 0x53D6, 0x5439, 0x5634, 0x5A36, 0x5C31, 0x708A,
  0x7FE0, 0x805A, 0x8106, 0x81ED, 0x8DA3, 0x9189, 0x9A5F, 0x9DF2,
  0x5074, 0x4EC4, 0x53A0, 0x60FB, 0x6E2C, 0x5C64, 0x4F88, 0x5024,
  0x55E4, 0x5CD9, 0x5E5F, 0x6065, 0x6894, 0x6CBB, 0x6DC4, 0x71BE,
  0x75D4, 0x75F4, 0x7661, 0x7A1A, 0x7A49, 0x7DC7, 0x7DFB, 0x7F6E,
  0x81F4, 0x86A9, 0x8F1C, 0x96C9, 0x99B3, 0x9F52, 0x5247, 0x52C5,
  0x98ED, 0x89AA, 0x4E03, 0x67D2, 0x6F06, 0x4FB5, 0x5BE2, 0x6795,
  0x6C88, 0x6D78, 0x741B, 0x7827, 0x91DD, 0x937C, 0x87C4, 0x79E4,
  0x7A31, 0x5FEB, 0x4ED6, 0x54A4, 0x553E, 0x58AE, 0x59A5, 0x60F0,
  0x6253, 0x62D6, 0x6736, 0x6955, 0x8235, 0x9640, 0x99B1, 0x99DD,
  0x502C, 0x5353, 0x5544, 0x577C, 0xFA01, 0x6258, 0xFA02, 0x64E2,
  0x666B, 0x67DD, 0x6FC1, 0x6FEF, 0x7422, 0x7438, 0x8A17, 0x9438,
  0x5451, 0x5606, 0x5766, 0x5F48, 0x619A, 0x6B4E, 0x7058, 0x70AD,
  0x7DBB, 0x8A95, 0x596A, 0x812B, 0x63A2, 0x7708, 0x803D, 0x8CAA,
  0x5854, 0x642D, 0x69BB, 0x5B95, 0x5E11, 0x6E6F, 0xFA03, 0x8569,
  0x514C, 0x53F0, 0x592A, 0x6020, 0x614B, 0x6B86, 0x6C70, 0x6CF0,
  0x7B1E, 0x80CE, 0x82D4, 0x8DC6, 0x90B0, 0x98B1, 0xFA04, 0x64C7,
  0x6FA4, 0x6491, 0x6504, 0x514E, 0x5410, 0x571F, 0x8A0E, 0x615F,
  0x6876, 0xFA05, 0x75DB, 0x7B52, 0x7D71, 0x901A, 0x5806, 0x69CC,
  0x817F, 0x892A, 0x9000, 0x9839, 0x5078, 0x5957, 0x59AC, 0x6295,
  0x900F, 0x9B2A, 0x615D, 0x7279, 0x95D6, 0x5761, 0x5A46, 0x5DF4,
  0x628A, 0x64AD, 0x64FA, 0x6777, 0x6CE2, 0x6D3E, 0x722C, 0x7436,
  0x7834, 0x7F77, 0x82AD, 0x8DDB, 0x9817, 0x5224, 0x5742, 0x677F,
  0x7248, 0x74E3, 0x8CA9, 0x8FA6, 0x9211, 0x962A, 0x516B, 0x53ED,
  0x634C, 0x4F69, 0x5504, 0x6096, 0x6557, 0x6C9B, 0x6D7F, 0x724C,
  0x72FD, 0x7A17, 0x8987, 0x8C9D, 0x5F6D, 0x6F8E, 0x70F9, 0x81A8,
  0x610E, 0x4FBF, 0x504F, 0x6241, 0x7247, 0x7BC7, 0x7DE8, 0x7FE9,
  0x904D, 0x97AD, 0x9A19, 0x8CB6, 0x576A, 0x5E73, 0x67B0, 0x840D,
  0x8A55, 0x5420, 0x5B16, 0x5E63, 0x5EE2, 0x5F0A, 0x6583, 0x80BA,
  0x853D, 0x9589, 0x965B, 0x4F48, 0x5305, 0x530D, 0x530F, 0x5486,
  0x54FA, 0x5703, 0x5E03, 0x6016, 0x629B, 0x62B1, 0x6355, 0xFA06,
  0x6CE1, 0x6D66, 0x75B1, 0x7832, 0x80DE, 0x812F, 0x82DE, 0x8461,
  0x84B2, 0x888D, 0x8912, 0x900B, 0x92EA, 0x98FD, 0x9B91, 0x5E45,
  0x66B4, 0x66DD, 0x7011, 0x7206, 0xFA07, 0x4FF5, 0x527D, 0x5F6A,
  0x6153, 0x6753, 0x6A19, 0x6F02, 0x74E2, 0x7968, 0x8868, 0x8C79,
  0x98C7, 0x98C4, 0x9A43, 0x54C1, 0x7A1F, 0x6953, 0x8AF7, 0x8C4A,
  0x98A8, 0x99AE, 0x5F7C, 0x62AB, 0x75B2, 0x76AE, 0x88AB, 0x907F,
  0x9642, 0x5339, 0x5F3C, 0x5FC5, 0x6CCC, 0x73CC, 0x7562, 0x758B,
  0x7B46, 0x82FE, 0x999D, 0x4E4F, 0x903C, 0x4E0B, 0x4F55, 0x53A6,
  0x590F, 0x5EC8, 0x6630, 0x6CB3, 0x7455, 0x8377, 0x8766, 0x8CC0,
  0x9050, 0x971E, 0x9C15, 0x58D1, 0x5B78, 0x8650, 0x8B14, 0x9DB4,
  0x5BD2, 0x6068, 0x608D, 0x65F1, 0x6C57, 0x6F22, 0x6FA3, 0x701A,
  0x7F55, 0x7FF0, 0x9591, 0x9592, 0x9650, 0x97D3, 0x5272, 0x8F44,
  0x51FD, 0x542B, 0x54B8, 0x5563, 0x558A, 0x6ABB, 0x6DB5, 0x7DD8,
  0x8266, 0x929C, 0x9677, 0x9E79, 0x5408, 0x54C8, 0x76D2, 0x86E4,
  0x95A4, 0x95D4, 0x965C, 0x4EA2, 0x4F09, 0x59EE, 0x5AE6, 0x5DF7,
  0x6052, 0x6297, 0x676D, 0x6841, 0x6C86, 0x6E2F, 0x7F38, 0x809B,
  0x822A, 0xFA08, 0xFA09, 0x9805, 0x4EA5, 0x5055, 0x54B3, 0x5793,
  0x595A, 0x5B69, 0x5BB3, 0x61C8, 0x6977, 0x6D77, 0x7023, 0x87F9,
  0x89E3, 0x8A72, 0x8AE7, 0x9082, 0x99ED, 0x9AB8, 0x52BE, 0x6838,
  0x5016, 0x5E78, 0x674F, 0x8347, 0x884C, 0x4EAB, 0x5411, 0x56AE,
  0x73E6, 0x9115, 0x97FF, 0x9909, 0x9957, 0x9999, 0x5653, 0x589F,
  0x865B, 0x8A31, 0x61B2, 0x6AF6, 0x737B, 0x8ED2, 0x6B47, 0x96AA,
  0x9A57, 0x5955, 0x7200, 0x8D6B, 0x9769, 0x4FD4, 0x5CF4, 0x5F26,
  0x61F8, 0x665B, 0x6CEB, 0x70AB, 0x7384, 0x73B9, 0x73FE, 0x7729,
  0x774D, 0x7D43, 0x7D62, 0x7E23, 0x8237, 0x8852, 0xFA0A, 0x8CE2,
  0x9249, 0x986F, 0x5B51, 0x7A74, 0x8840, 0x9801, 0x5ACC, 0x4FE0,
  0x5354, 0x593E, 0x5CFD, 0x633E, 0x6D79, 0x72F9, 0x8105, 0x8107,
  0x83A2, 0x92CF, 0x9830, 0x4EA8, 0x5144, 0x5211, 0x578B, 0x5F62,
  0x6CC2, 0x6ECE, 0x7005, 0x7050, 0x70AF, 0x7192, 0x73E9, 0x7469,
  0x834A, 0x87A2, 0x8861, 0x9008, 0x90A2, 0x93A3, 0x99A8, 0x516E,
  0x5F57, 0x60E0, 0x6167, 0x66B3, 0x8559, 0x8E4A, 0x91AF, 0x978B,
  0x4E4E, 0x4E92, 0x547C, 0x58D5, 0x58FA, 0x597D, 0x5CB5, 0x5F27,
  0x6236, 0x6248, 0x660A, 0x6667, 0x6BEB, 0x6D69, 0x6DCF, 0x6E56,
  0x6EF8, 0x6F94, 0x6FE0, 0x6FE9, 0x705D, 0x72D0, 0x7425, 0x745A,
  0x74E0, 0x7693, 0x795C, 0x7CCA, 0x7E1E, 0x80E1, 0x82A6, 0x846B,
  0x84BF, 0x864E, 0x865F, 0x8774, 0x8B77, 0x8C6A, 0x93AC, 0x9800,
  0x9865, 0x60D1, 0x6216, 0x9177, 0x5A5A, 0x660F, 0x6DF7, 0x6E3E,
  0x743F, 0x9B42, 0x5FFD, 0x60DA, 0x7B0F, 0x54C4, 0x5F18, 0x6C5E,
  0x6CD3, 0x6D2A, 0x70D8, 0x7D05, 0x8679, 0x8A0C, 0x9D3B, 0x5316,
  0x548C, 0x5B05, 0x6A3A, 0x706B, 0x7575, 0x798D, 0x79BE, 0x82B1,
  0x83EF, 0x8A71, 0x8B41, 0x8CA8, 0x9774, 0xFA0B, 0x64F4, 0x652B,
  0x78BA, 0x78BB, 0x7A6B, 0x4E38, 0x559A, 0x5950, 0x5BA6, 0x5E7B,
  0x60A3, 0x63DB, 0x6B61, 0x6665, 0x6853, 0x6E19, 0x7165, 0x74B0,
  0x7D08, 0x9084, 0x9A69, 0x9C25, 0x6D3B, 0x6ED1, 0x733E, 0x8C41,
  0x95CA, 0x51F0, 0x5E4C, 0x5FA8, 0x604D, 0x60F6, 0x6130, 0x614C,
  0x6643, 0x6644, 0x69A5, 0x6CC1, 0x6E5F, 0x6EC9, 0x6F62, 0x714C,
  0x749C, 0x7687, 0x7BC1, 0x7C27, 0x8352, 0x8757, 0x9051, 0x968D,
  0x9EC3, 0x532F, 0x56DE, 0x5EFB, 0x5F8A, 0x6062, 0x6094, 0x61F7,
  0x6666, 0x6703, 0x6A9C, 0x6DEE, 0x6FAE, 0x7070, 0x736A, 0x7E6A,
  0x81BE, 0x8334, 0x86D4, 0x8AA8, 0x8CC4, 0x5283, 0x7372, 0x5B96,
  0x6A6B, 0x9404, 0x54EE, 0x5686, 0x5B5D, 0x6548, 0x6585, 0x66C9,
  0x689F, 0x6D8D, 0x6DC6, 0x723B, 0x80B4, 0x9175, 0x9A4D, 0x4FAF,
  0x5019, 0x539A, 0x540E, 0x543C, 0x5589, 0x55C5, 0x5E3F, 0x5F8C,
  0x673D, 0x7166, 0x73DD, 0x9005, 0x52DB, 0x52F3, 0x5864, 0x58CE,
  0x7104, 0x718F, 0x71FB, 0x85B0, 0x8A13, 0x6688, 0x85A8, 0x55A7,
  0x6684, 0x714A, 0x8431, 0x5349, 0x5599, 0x6BC1, 0x5F59, 0x5FBD,
  0x63EE, 0x6689, 0x7147, 0x8AF1, 0x8F1D, 0x9EBE, 0x4F11, 0x643A,
  0x70CB, 0x7566, 0x8667, 0x6064, 0x8B4E, 0x9DF8, 0x5147, 0x51F6,
  0x5308, 0x6D36, 0x80F8, 0x9ED1, 0x6615, 0x6B23, 0x7098, 0x75D5,
  0x5403, 0x5C79, 0x7D07, 0x8A16, 0x6B20, 0x6B3D, 0x6B46, 0x5438,
  0x6070, 0x6D3D, 0x7FD5, 0x8208, 0x50D6, 0x51DE, 0x559C, 0x566B,
  0x56CD, 0x59EC, 0x5B09, 0x5E0C, 0x6199, 0x6198, 0x6231, 0x665E,
  0x66E6, 0x7199, 0x71B9, 0x71BA, 0x72A7, 0x79A7, 0x7A00, 0x7FB2,
  0x8A70,
  // [  8836,  8869] -v # seg 49 at pos 7595
  0xAC02, 0xAC03, 0xAC05, 0xAC06, 0xAC0B, 0xAC0C, 0xAC0D, 0xAC0E,
  0xAC0F, 0xAC18, 0xAC1E, 0xAC1F, 0xAC21, 0xAC22, 0xAC23, 0xAC25,
  0xAC26, 0xAC27, 0xAC28, 0xAC29, 0xAC2A, 0xAC2B, 0xAC2E, 0xAC32,
  0xAC33, 0xAC34, 0xAC35, 0xAC36, 0xAC37, 0xAC3A, 0xAC3B, 0xAC3D,
  0xAC3E, 0xAC3F,
  // [  8870,  8879] -> [0xAC41,0xAC4A] # seg 50
  // [  8880,  8892] -v # seg 51 at pos 7629
  0xAC4C, 0xAC4E, 0xAC4F, 0xAC50, 0xAC51, 0xAC52, 0xAC53, 0xAC55,
  0xAC56, 0xAC57, 0xAC59, 0xAC5A, 0xAC5B,
  // [  8893,  8911] -> [0xAC5D,0xAC6F] # seg 52
  // [  8912,  9102] -v # seg 53 at pos 7642
  0xAC72, 0xAC73, 0xAC75, 0xAC76, 0xAC79, 0xAC7B, 0xAC7C, 0xAC7D,
  0xAC7E, 0xAC7F, 0xAC82, 0xAC87, 0xAC88, 0xAC8D, 0xAC8E, 0xAC8F,
  0xAC91, 0xAC92, 0xAC93, 0xAC95, 0xAC96, 0xAC97, 0xAC98, 0xAC99,
  0xAC9A, 0xAC9B, 0xAC9E, 0xACA2, 0xACA3, 0xACA4, 0xACA5, 0xACA6,
  0xACA7, 0xACAB, 0xACAD, 0xACAE, 0xACB1, 0xACB2, 0xACB3, 0xACB4,
  0xACB5, 0xACB6, 0xACB7, 0xACBA, 0xACBE, 0xACBF, 0xACC0, 0xACC2,
  0xACC3, 0xACC5, 0xACC6, 0xACC7, 0xACC9, 0xACCA, 0xACCB, 0xACCD,
  0xACCE, 0xACCF, 0xACD0, 0xACD1, 0xACD2, 0xACD3, 0xACD4, 0xACD6,
  0xACD8, 0xACD9, 0xACDA, 0xACDB, 0xACDC, 0xACDD, 0xACDE, 0xACDF,
  0xACE2, 0xACE3, 0xACE5, 0xACE6, 0xACE9, 0xACEB, 0xACED, 0xACEE,
  0xACF2, 0xACF4, 0xACF7, 0xACF8, 0xACF9, 0xACFA, 0xACFB, 0xACFE,
  0xACFF, 0xAD01, 0xAD02, 0xAD03, 0xAD05, 0xAD07, 0xAD08, 0xAD09,
  0xAD0A, 0xAD0B, 0xAD0E, 0xAD10, 0xAD12, 0xAD13, 0xAD14, 0xAD15,
  0xAD16, 0xAD17, 0xAD19, 0xAD1A, 0xAD1B, 0xAD1D, 0xAD1E, 0xAD1F,
  0xAD21, 0xAD22, 0xAD23, 0xAD24, 0xAD25, 0xAD26, 0xAD27, 0xAD28,
  0xAD2A, 0xAD2B, 0xAD2E, 0xAD2F, 0xAD30, 0xAD31, 0xAD32, 0xAD33,
  0xAD36, 0xAD37, 0xAD39, 0xAD3A, 0xAD3B, 0xAD3D, 0xAD3E, 0xAD3F,
  0xAD40, 0xAD41, 0xAD42, 0xAD43, 0xAD46, 0xAD48, 0xAD4A, 0xAD4B,
  0xAD4C, 0xAD4D, 0xAD4E, 0xAD4F, 0xAD51, 0xAD52, 0xAD53, 0xAD55,
  0xAD56, 0xAD57, 0xAD59, 0xAD5A, 0xAD5B, 0xAD5C, 0xAD5D, 0xAD5E,
  0xAD5F, 0xAD60, 0xAD62, 0xAD64, 0xAD65, 0xAD66, 0xAD67, 0xAD68,
  0xAD69, 0xAD6A, 0xAD6B, 0xAD6E, 0xAD6F, 0xAD71, 0xAD72, 0xAD77,
  0xAD78, 0xAD79, 0xAD7A, 0xAD7E, 0xAD80, 0xAD83, 0xAD84, 0xAD85,
  0xAD86, 0xAD87, 0xAD8A, 0xAD8B, 0xAD8D, 0xAD8E, 0xAD8F,
  // [  9103,  9113] -> [0xAD91,0xAD9B] # seg 54
  // [  9114,  9119] -> [0xAD9E,0xADA3] # seg 55
  // [  9120,  9137] -> [0xADA5,0xADB6] # seg 56
  // [  9138,  9145] -> [0xADB8,0xADBF] # seg 57
  // [  9146,  9172] -v # seg 58 at pos 7833
  0xADC2, 0xADC3, 0xADC5, 0xADC6, 0xADC7, 0xADC9, 0xADCA, 0xADCB,
  0xADCC, 0xADCD, 0xADCE, 0xADCF, 0xADD2, 0xADD4, 0xADD5, 0xADD6,
  0xADD7, 0xADD8, 0xADD9, 0xADDA, 0xADDB, 0xADDD, 0xADDE, 0xADDF,
  0xADE1, 0xADE2, 0xADE3,
  // [  9173,  9191] -> [0xADE5,0xADF7] # seg 59
  // [  9192,  9209] -v # seg 60 at pos 7860
  0xADFA, 0xADFB, 0xADFD, 0xADFE, 0xAE02, 0xAE03, 0xAE04, 0xAE05,
  0xAE06, 0xAE07, 0xAE0A, 0xAE0C, 0xAE0E, 0xAE0F, 0xAE10, 0xAE11,
  0xAE12, 0xAE13,
  // [  9210,  9236] -> [0xAE15,0xAE2F] # seg 61
  // [  9237,  9293] -v # seg 62 at pos 7878
  0xAE32, 0xAE33, 0xAE35, 0xAE36, 0xAE39, 0xAE3B, 0xAE3C, 0xAE3D,
  0xAE3E, 0xAE3F, 0xAE42, 0xAE44, 0xAE47, 0xAE48, 0xAE49, 0xAE4B,
  0xAE4F, 0xAE51, 0xAE52, 0xAE53, 0xAE55, 0xAE57, 0xAE58, 0xAE59,
  0xAE5A, 0xAE5B, 0xAE5E, 0xAE62, 0xAE63, 0xAE64, 0xAE66, 0xAE67,
  0xAE6A, 0xAE6B, 0xAE6D, 0xAE6E, 0xAE6F, 0xAE71, 0xAE72, 0xAE73,
  0xAE74, 0xAE75, 0xAE76, 0xAE77, 0xAE7A, 0xAE7E, 0xAE7F, 0xAE80,
  0xAE81, 0xAE82, 0xAE83, 0xAE86, 0xAE87, 0xAE88, 0xAE89, 0xAE8A,
  0xAE8B,
  // [  9294,  9340] -> [0xAE8D,0xAEBB] # seg 63
  // [  9341,  9360] -v # seg 64 at pos 7935
  0xAEBF, 0xAEC1, 0xAEC2, 0xAEC3, 0xAEC5, 0xAEC6, 0xAEC7, 0xAEC8,
  0xAEC9, 0xAECA, 0xAECB, 0xAECE, 0xAED2, 0xAED3, 0xAED4, 0xAED5,
  0xAED6, 0xAED7, 0xAEDA, 0xAEDB,
  // [  9361,  9371] -> [0xAEDD,0xAEE7] # seg 65
  // [  9372,  9386] -v # seg 66 at pos 7955
  0xAEE9, 0xAEEA, 0xAEEC, 0xAEEE, 0xAEEF, 0xAEF0, 0xAEF1, 0xAEF2,
  0xAEF3, 0xAEF5, 0xAEF6, 0xAEF7, 0xAEF9, 0xAEFA, 0xAEFB,
  // [  9387,  9396] -> [0xAEFD,0xAF06] # seg 67
  // [  9397,  9402] -v # seg 68 at pos 7970
  0xAF09, 0xAF0A, 0xAF0B, 0xAF0C, 0xAF0E, 0xAF0F,
  // [  9403,  9429] -> [0xAF11,0xAF2B] # seg 69
  // [  9430,  9452] -v # seg 70 at pos 7976
  0xAF2E, 0xAF2F, 0xAF31, 0xAF33, 0xAF35, 0xAF36, 0xAF37, 0xAF38,
  0xAF39, 0xAF3A, 0xAF3B, 0xAF3E, 0xAF40, 0xAF44, 0xAF45, 0xAF46,
  0xAF47, 0xAF4A, 0xAF4B, 0xAF4C, 0xAF4D, 0xAF4E, 0xAF4F,
  // [  9453,  9463] -> [0xAF51,0xAF5B] # seg 71
  // [  9464,  9469] -> [0xAF5E,0xAF63] # seg 72
  // [  9470,  9488] -> [0xAF66,0xAF78] # seg 73
  // [  9489,  9516] -v # seg 74 at pos 7999
  0xAF7A, 0xAF7B, 0xAF7C, 0xAF7D, 0xAF7E, 0xAF7F, 0xAF81, 0xAF82,
  0xAF83, 0xAF85, 0xAF86, 0xAF87, 0xAF89, 0xAF8A, 0xAF8B, 0xAF8C,
  0xAF8D, 0xAF8E, 0xAF8F, 0xAF92, 0xAF93, 0xAF94, 0xAF96, 0xAF97,
  0xAF98, 0xAF99, 0xAF9A, 0xAF9B,
  // [  9517,  9543] -> [0xAF9D,0xAFB7] # seg 75
  // [  9544,  9568] -v # seg 76 at pos 8027
  0xAFBA, 0xAFBB, 0xAFBD, 0xAFBE, 0xAFBF, 0xAFC1, 0xAFC2, 0xAFC3,
  0xAFC4, 0xAFC5, 0xAFC6, 0xAFCA, 0xAFCC, 0xAFCF, 0xAFD0, 0xAFD1,
  0xAFD2, 0xAFD3, 0xAFD5, 0xAFD6, 0xAFD7, 0xAFD8, 0xAFD9, 0xAFDA,
  0xAFDB,
  // [  9569,  9579] -> [0xAFDD,0xAFE7] # seg 77
  // [  9580,  9619] -v # seg 78 at pos 8052
  0xAFEA, 0xAFEB, 0xAFEC, 0xAFED, 0xAFEE, 0xAFEF, 0xAFF2, 0xAFF3,
  0xAFF5, 0xAFF6, 0xAFF7, 0xAFF9, 0xAFFA, 0xAFFB, 0xAFFC, 0xAFFD,
  0xAFFE, 0xAFFF, 0xB002, 0xB003, 0xB005, 0xB006, 0xB007, 0xB008,
  0xB009, 0xB00A, 0xB00B, 0xB00D, 0xB00E, 0xB00F, 0xB011, 0xB012,
  0xB013, 0xB015, 0xB016, 0xB017, 0xB018, 0xB019, 0xB01A, 0xB01B,
  // [  9620,  9629] -> [0xB01E,0xB027] # seg 79
  // [  9630,  9656] -> [0xB029,0xB043] # seg 80
  // [  9657,  9670] -v # seg 81 at pos 8092
  0xB046, 0xB047, 0xB049, 0xB04B, 0xB04D, 0xB04F, 0xB050, 0xB051,
  0xB052, 0xB056, 0xB058, 0xB05A, 0xB05B, 0xB05C,
  // [  9671,  9700] -> [0xB05E,0xB07B] # seg 82
  // [  9701,  9766] -v # seg 83 at pos 8106
  0xB07E, 0xB07F, 0xB081, 0xB082, 0xB083, 0xB085, 0xB086, 0xB087,
  0xB088, 0xB089, 0xB08A, 0xB08B, 0xB08E, 0xB090, 0xB092, 0xB093,
  0xB094, 0xB095, 0xB096, 0xB097, 0xB09B, 0xB09D, 0xB09E, 0xB0A3,
  0xB0A4, 0xB0A5, 0xB0A6, 0xB0A7, 0xB0AA, 0xB0B0, 0xB0B2, 0xB0B6,
  0xB0B7, 0xB0B9, 0xB0BA, 0xB0BB, 0xB0BD, 0xB0BE, 0xB0BF, 0xB0C0,
  0xB0C1, 0xB0C2, 0xB0C3, 0xB0C6, 0xB0CA, 0xB0CB, 0xB0CC, 0xB0CD,
  0xB0CE, 0xB0CF, 0xB0D2, 0xB0D3, 0xB0D5, 0xB0D6, 0xB0D7, 0xB0D9,
  0xB0DA, 0xB0DB, 0xB0DC, 0xB0DD, 0xB0DE, 0xB0DF, 0xB0E1, 0xB0E2,
  0xB0E3, 0xB0E4,
  // [  9767,  9800] -> [0xB0E6,0xB107] # seg 84
  // [  9801,  9856] -v # seg 85 at pos 8172
  0xB10A, 0xB10D, 0xB10E, 0xB10F, 0xB111, 0xB114, 0xB115, 0xB116,
  0xB117, 0xB11A, 0xB11E, 0xB11F, 0xB120, 0xB121, 0xB122, 0xB126,
  0xB127, 0xB129, 0xB12A, 0xB12B, 0xB12D, 0xB12E, 0xB12F, 0xB130,
  0xB131, 0xB132, 0xB133, 0xB136, 0xB13A, 0xB13B, 0xB13C, 0xB13D,
  0xB13E, 0xB13F, 0xB142, 0xB143, 0xB145, 0xB146, 0xB147, 0xB149,
  0xB14A, 0xB14B, 0xB14C, 0xB14D, 0xB14E, 0xB14F, 0xB152, 0xB153,
  0xB156, 0xB157, 0xB159, 0xB15A, 0xB15B, 0xB15D, 0xB15E, 0xB15F,
  // [  9857,  9879] -> [0xB161,0xB177] # seg 86
  // [  9880,  9902] -v # seg 87 at pos 8228
  0xB17A, 0xB17B, 0xB17D, 0xB17E, 0xB17F, 0xB181, 0xB183, 0xB184,
  0xB185, 0xB186, 0xB187, 0xB18A, 0xB18C, 0xB18E, 0xB18F, 0xB190,
  0xB191, 0xB195, 0xB196, 0xB197, 0xB199, 0xB19A, 0xB19B,
  // [  9903,  9913] -> [0xB19D,0xB1A7] # seg 88
  // [  9914,  9948] -> [0xB1A9,0xB1CB] # seg 89
  // [  9949, 10010] -v # seg 90 at pos 8251
  0xB1CD, 0xB1CE, 0xB1CF, 0xB1D1, 0xB1D2, 0xB1D3, 0xB1D5, 0xB1D6,
  0xB1D7, 0xB1D8, 0xB1D9, 0xB1DA, 0xB1DB, 0xB1DE, 0xB1E0, 0xB1E1,
  0xB1E2, 0xB1E3, 0xB1E4, 0xB1E5, 0xB1E6, 0xB1E7, 0xB1EA, 0xB1EB,
  0xB1ED, 0xB1EE, 0xB1EF, 0xB1F1, 0xB1F2, 0xB1F3, 0xB1F4, 0xB1F5,
  0xB1F6, 0xB1F7, 0xB1F8, 0xB1FA, 0xB1FC, 0xB1FE, 0xB1FF, 0xB200,
  0xB201, 0xB202, 0xB203, 0xB206, 0xB207, 0xB209, 0xB20A, 0xB20D,
  0xB20E, 0xB20F, 0xB210, 0xB211, 0xB212, 0xB213, 0xB216, 0xB218,
  0xB21A, 0xB21B, 0xB21C, 0xB21D, 0xB21E, 0xB21F,
  // [ 10011, 10029] -> [0xB221,0xB233] # seg 91
  // [ 10030, 10036] -> [0xB235,0xB23B] # seg 92
  // [ 10037, 10063] -> [0xB23D,0xB257] # seg 93
  // [ 10064, 10076] -v # seg 94 at pos 8313
  0xB259, 0xB25A, 0xB25B, 0xB25D, 0xB25E, 0xB25F, 0xB261, 0xB262,
  0xB263, 0xB264, 0xB265, 0xB266, 0xB267,
  // [ 10077, 10086] -> [0xB26A,0xB273] # seg 95
  // [ 10087, 10130] -v # seg 96 at pos 8326
  0xB276, 0xB277, 0xB278, 0xB279, 0xB27A, 0xB27B, 0xB27D, 0xB27E,
  0xB27F, 0xB280, 0xB281, 0xB282, 0xB283, 0xB286, 0xB287, 0xB288,
  0xB28A, 0xB28B, 0xB28C, 0xB28D, 0xB28E, 0xB28F, 0xB292, 0xB293,
  0xB295, 0xB296, 0xB297, 0xB29B, 0xB29C, 0xB29D, 0xB29E, 0xB29F,
  0xB2A2, 0xB2A4, 0xB2A7, 0xB2A8, 0xB2A9, 0xB2AB, 0xB2AD, 0xB2AE,
  0xB2AF, 0xB2B1, 0xB2B2, 0xB2B3,
  // [ 10131, 10149] -> [0xB2B5,0xB2C7] # seg 97
  // [ 10150, 10196] -v # seg 98 at pos 8370
  0xB2CA, 0xB2CB, 0xB2CD, 0xB2CE, 0xB2CF, 0xB2D1, 0xB2D3, 0xB2D4,
  0xB2D5, 0xB2D6, 0xB2D7, 0xB2DA, 0xB2DC, 0xB2DE, 0xB2DF, 0xB2E0,
  0xB2E1, 0xB2E3, 0xB2E7, 0xB2E9, 0xB2EA, 0xB2F0, 0xB2F1, 0xB2F2,
  0xB2F6, 0xB2FC, 0xB2FD, 0xB2FE, 0xB302, 0xB303, 0xB305, 0xB306,
  0xB307, 0xB309, 0xB30A, 0xB30B, 0xB30C, 0xB30D, 0xB30E, 0xB30F,
  0xB312, 0xB316, 0xB317, 0xB318, 0xB319, 0xB31A, 0xB31B,
  // [ 10197, 10251] -> [0xB31D,0xB353] # seg 99
  // [ 10252, 10290] -v # seg 100 at pos 8417
  0xB357, 0xB359, 0xB35A, 0xB35D, 0xB360, 0xB361, 0xB362, 0xB363,
  0xB366, 0xB368, 0xB36A, 0xB36C, 0xB36D, 0xB36F, 0xB372, 0xB373,
  0xB375, 0xB376, 0xB377, 0xB379, 0xB37A, 0xB37B, 0xB37C, 0xB37D,
  0xB37E, 0xB37F, 0xB382, 0xB386, 0xB387, 0xB388, 0xB389, 0xB38A,
  0xB38B, 0xB38D, 0xB38E, 0xB38F, 0xB391, 0xB392, 0xB393,
  // [ 10291, 10301] -> [0xB395,0xB39F] # seg 101
  // [ 10302, 10310] -v # seg 102 at pos 8456
  0xB3A2, 0xB3A3, 0xB3A4, 0xB3A5, 0xB3A6, 0xB3A7, 0xB3A9, 0xB3AA,
  0xB3AB,
  // [ 10311, 10333] -> [0xB3AD,0xB3C3] # seg 103
  // [ 10334, 10354] -v # seg 104 at pos 8465
  0xB3C6, 0xB3C7, 0xB3C9, 0xB3CA, 0xB3CD, 0xB3CF, 0xB3D1, 0xB3D2,
  0xB3D3, 0xB3D6, 0xB3D8, 0xB3DA, 0xB3DC, 0xB3DE, 0xB3DF, 0xB3E1,
  0xB3E2, 0xB3E3, 0xB3E5, 0xB3E6, 0xB3E7,
  // [ 10355, 10373] -> [0xB3E9,0xB3FB] # seg 105
  // [ 10374, 10392] -> [0xB3FD,0xB40F] # seg 106
  // [ 10393, 10421] -v # seg 107 at pos 8486
  0xB411, 0xB412, 0xB413, 0xB414, 0xB415, 0xB416, 0xB417, 0xB419,
  0xB41A, 0xB41B, 0xB41D, 0xB41E, 0xB41F, 0xB421, 0xB422, 0xB423,
  0xB424, 0xB425, 0xB426, 0xB427, 0xB42A, 0xB42C, 0xB42D, 0xB42E,
  0xB42F, 0xB430, 0xB431, 0xB432, 0xB433,
  // [ 10422, 10448] -> [0xB435,0xB44F] # seg 108
  // [ 10449, 10468] -v # seg 109 at pos 8515
  0xB452, 0xB453, 0xB455, 0xB456, 0xB457, 0xB459, 0xB45A, 0xB45B,
  0xB45C, 0xB45D, 0xB45E, 0xB45F, 0xB462, 0xB464, 0xB466, 0xB467,
  0xB468, 0xB469, 0xB46A, 0xB46B,
  // [ 10469, 10487] -> [0xB46D,0xB47F] # seg 110
  // [ 10488, 10494] -> [0xB481,0xB487] # seg 111
  // [ 10495, 10514] -> [0xB489,0xB49C] # seg 112
  // [ 10515, 10583] -v # seg 113 at pos 8535
  0xB49E, 0xB49F, 0xB4A0, 0xB4A1, 0xB4A2, 0xB4A3, 0xB4A5, 0xB4A6,
  0xB4A7, 0xB4A9, 0xB4AA, 0xB4AB, 0xB4AD, 0xB4AE, 0xB4AF, 0xB4B0,
  0xB4B1, 0xB4B2, 0xB4B3, 0xB4B4, 0xB4B6, 0xB4B8, 0xB4BA, 0xB4BB,
  0xB4BC, 0xB4BD, 0xB4BE, 0xB4BF, 0xB4C1, 0xB4C2, 0xB4C3, 0xB4C5,
  0xB4C6, 0xB4C7, 0xB4C9, 0xB4CA, 0xB4CB, 0xB4CC, 0xB4CD, 0xB4CE,
  0xB4CF, 0xB4D1, 0xB4D2, 0xB4D3, 0xB4D4, 0xB4D6, 0xB4D7, 0xB4D8,
  0xB4D9, 0xB4DA, 0xB4DB, 0xB4DE, 0xB4DF, 0xB4E1, 0xB4E2, 0xB4E5,
  0xB4E7, 0xB4E8, 0xB4E9, 0xB4EA, 0xB4EB, 0xB4EE, 0xB4F0, 0xB4F2,
  0xB4F3, 0xB4F4, 0xB4F5, 0xB4F6, 0xB4F7,
  // [ 10584, 10610] -> [0xB4F9,0xB513] # seg 114
  // [ 10611, 10658] -v # seg 115 at pos 8604
  0xB516, 0xB517, 0xB519, 0xB51A, 0xB51D, 0xB51E, 0xB51F, 0xB520,
  0xB521, 0xB522, 0xB523, 0xB526, 0xB52B, 0xB52C, 0xB52D, 0xB52E,
  0xB52F, 0xB532, 0xB533, 0xB535, 0xB536, 0xB537, 0xB539, 0xB53A,
  0xB53B, 0xB53C, 0xB53D, 0xB53E, 0xB53F, 0xB542, 0xB546, 0xB547,
  0xB548, 0xB549, 0xB54A, 0xB54E, 0xB54F, 0xB551, 0xB552, 0xB553,
  0xB555, 0xB556, 0xB557, 0xB558, 0xB559, 0xB55A, 0xB55B, 0xB55E,
  // [ 10659, 10720] -> [0xB562,0xB59F] # seg 116
  // [ 10721, 10755] -v # seg 117 at pos 8652
  0xB5A2, 0xB5A3, 0xB5A5, 0xB5A6, 0xB5A7, 0xB5A9, 0xB5AC, 0xB5AD,
  0xB5AE, 0xB5AF, 0xB5B2, 0xB5B6, 0xB5B7, 0xB5B8, 0xB5B9, 0xB5BA,
  0xB5BE, 0xB5BF, 0xB5C1, 0xB5C2, 0xB5C3, 0xB5C5, 0xB5C6, 0xB5C7,
  0xB5C8, 0xB5C9, 0xB5CA, 0xB5CB, 0xB5CE, 0xB5D2, 0xB5D3, 0xB5D4,
  0xB5D5, 0xB5D6, 0xB5D7,
  // [ 10756, 10774] -> [0xB5D9,0xB5EB] # seg 118
  // [ 10775, 10809] -> [0xB5ED,0xB60F] # seg 119
  // [ 10810, 10814] -v # seg 120 at pos 8687
  0xB612, 0xB613, 0xB615, 0xB616, 0xB617,
  // [ 10815, 10826] -> [0xB619,0xB624] # seg 121
  // [ 10827, 10839] -v # seg 122 at pos 8692
  0xB626, 0xB627, 0xB628, 0xB629, 0xB62A, 0xB62B, 0xB62D, 0xB62E,
  0xB62F, 0xB630, 0xB631, 0xB632, 0xB633,
  // [ 10840, 10858] -> [0xB635,0xB647] # seg 123
  // [ 10859, 10885] -> [0xB649,0xB663] # seg 124
  // [ 10886, 10888] -> [0xB665,0xB667] # seg 125
  // [ 10889, 10939] -> [0xB669,0xB69B] # seg 126
  // [ 10940, 10954] -v # seg 127 at pos 8705
  0xB69E, 0xB69F, 0xB6A1, 0xB6A2, 0xB6A3, 0xB6A5, 0xB6A6, 0xB6A7,
  0xB6A8, 0xB6A9, 0xB6AA, 0xB6AD, 0xB6AE, 0xB6AF, 0xB6B0,
  // [ 10955, 10988] -> [0xB6B2,0xB6D3] # seg 128
  // [ 10989, 11015] -> [0xB6D5,0xB6EF] # seg 129
  // [ 11016, 11031] -v # seg 130 at pos 8720
  0xB6F1, 0xB6F2, 0xB6F3, 0xB6F5, 0xB6F6, 0xB6F7, 0xB6F9, 0xB6FA,
  0xB6FB, 0xB6FC, 0xB6FD, 0xB6FE, 0xB6FF, 0xB702, 0xB703, 0xB704,
  // [ 11032, 11065] -> [0xB706,0xB727] # seg 131
  // [ 11066, 11098] -v # seg 132 at pos 8736
  0xB72A, 0xB72B, 0xB72D, 0xB72E, 0xB731, 0xB732, 0xB733, 0xB734,
  0xB735, 0xB736, 0xB737, 0xB73A, 0xB73C, 0xB73D, 0xB73E, 0xB73F,
  0xB740, 0xB741, 0xB742, 0xB743, 0xB745, 0xB746, 0xB747, 0xB749,
  0xB74A, 0xB74B, 0xB74D, 0xB74E, 0xB74F, 0xB750, 0xB751, 0xB752,
  0xB753,
  // [ 11099, 11108] -> [0xB756,0xB75F] # seg 133
  // [ 11109, 11166] -v # seg 134 at pos 8769
  0xB761, 0xB762, 0xB763, 0xB765, 0xB766, 0xB767, 0xB769, 0xB76A,
  0xB76B, 0xB76C, 0xB76D, 0xB76E, 0xB76F, 0xB772, 0xB774, 0xB776,
  0xB777, 0xB778, 0xB779, 0xB77A, 0xB77B, 0xB77E, 0xB77F, 0xB781,
  0xB782, 0xB783, 0xB785, 0xB786, 0xB787, 0xB788, 0xB789, 0xB78A,
  0xB78B, 0xB78E, 0xB793, 0xB794, 0xB795, 0xB79A, 0xB79B, 0xB79D,
  0xB79E, 0xB79F, 0xB7A1, 0xB7A2, 0xB7A3, 0xB7A4, 0xB7A5, 0xB7A6,
  0xB7A7, 0xB7AA, 0xB7AE, 0xB7AF, 0xB7B0, 0xB7B1, 0xB7B2, 0xB7B3,
  0xB7B6, 0xB7B7,
  // [ 11167, 11180] -> [0xB7B9,0xB7C6] # seg 135
  // [ 11181, 11181] -> [0xB7C8,0xB7C8] # seg 136
  // [ 11182, 11215] -> [0xB7CA,0xB7EB] # seg 137
  // [ 11216, 11275] -v # seg 138 at pos 8827
  0xB7EE, 0xB7EF, 0xB7F1, 0xB7F2, 0xB7F3, 0xB7F5, 0xB7F6, 0xB7F7,
  0xB7F8, 0xB7F9, 0xB7FA, 0xB7FB, 0xB7FE, 0xB802, 0xB803, 0xB804,
  0xB805, 0xB806, 0xB80A, 0xB80B, 0xB80D, 0xB80E, 0xB80F, 0xB811,
  0xB812, 0xB813, 0xB814, 0xB815, 0xB816, 0xB817, 0xB81A, 0xB81C,
  0xB81E, 0xB81F, 0xB820, 0xB821, 0xB822, 0xB823, 0xB826, 0xB827,
  0xB829, 0xB82A, 0xB82B, 0xB82D, 0xB82E, 0xB82F, 0xB830, 0xB831,
  0xB832, 0xB833, 0xB836, 0xB83A, 0xB83B, 0xB83C, 0xB83D, 0xB83E,
  0xB83F, 0xB841, 0xB842, 0xB843,
  // [ 11276, 11287] -> [0xB845,0xB850] # seg 139
  // [ 11288, 11319] -v # seg 140 at pos 8887
  0xB852, 0xB854, 0xB855, 0xB856, 0xB857, 0xB858, 0xB859, 0xB85A,
  0xB85B, 0xB85E, 0xB85F, 0xB861, 0xB862, 0xB863, 0xB865, 0xB866,
  0xB867, 0xB868, 0xB869, 0xB86A, 0xB86B, 0xB86E, 0xB870, 0xB872,
  0xB873, 0xB874, 0xB875, 0xB876, 0xB877, 0xB879, 0xB87A, 0xB87B,
  // [ 11320, 11335] -> [0xB87D,0xB88C] # seg 141
  // [ 11336, 11361] -> [0xB88E,0xB8A7] # seg 142
  // [ 11362, 11431] -v # seg 143 at pos 8919
  0xB8A9, 0xB8AA, 0xB8AB, 0xB8AC, 0xB8AD, 0xB8AE, 0xB8AF, 0xB8B1,
  0xB8B2, 0xB8B3, 0xB8B5, 0xB8B6, 0xB8B7, 0xB8B9, 0xB8BA, 0xB8BB,
  0xB8BC, 0xB8BD, 0xB8BE, 0xB8BF, 0xB8C2, 0xB8C4, 0xB8C6, 0xB8C7,
  0xB8C8, 0xB8C9, 0xB8CA, 0xB8CB, 0xB8CD, 0xB8CE, 0xB8CF, 0xB8D1,
  0xB8D2, 0xB8D3, 0xB8D5, 0xB8D6, 0xB8D7, 0xB8D8, 0xB8D9, 0xB8DA,
  0xB8DB, 0xB8DC, 0xB8DE, 0xB8E0, 0xB8E2, 0xB8E3, 0xB8E4, 0xB8E5,
  0xB8E6, 0xB8E7, 0xB8EA, 0xB8EB, 0xB8ED, 0xB8EE, 0xB8EF, 0xB8F1,
  0xB8F2, 0xB8F3, 0xB8F4, 0xB8F5, 0xB8F6, 0xB8F7, 0xB8FA, 0xB8FC,
  0xB8FE, 0xB8FF, 0xB900, 0xB901, 0xB902, 0xB903,
  // [ 11432, 11450] -> [0xB905,0xB917] # seg 144
  // [ 11451, 11457] -> [0xB919,0xB91F] # seg 145
  // [ 11458, 11484] -> [0xB921,0xB93B] # seg 146
  // [ 11485, 11541] -v # seg 147 at pos 8989
  0xB93E, 0xB93F, 0xB941, 0xB942, 0xB943, 0xB945, 0xB946, 0xB947,
  0xB948, 0xB949, 0xB94A, 0xB94B, 0xB94D, 0xB94E, 0xB950, 0xB952,
  0xB953, 0xB954, 0xB955, 0xB956, 0xB957, 0xB95A, 0xB95B, 0xB95D,
  0xB95E, 0xB95F, 0xB961, 0xB962, 0xB963, 0xB964, 0xB965, 0xB966,
  0xB967, 0xB96A, 0xB96C, 0xB96E, 0xB96F, 0xB970, 0xB971, 0xB972,
  0xB973, 0xB976, 0xB977, 0xB979, 0xB97A, 0xB97B, 0xB97D, 0xB97E,
  0xB97F, 0xB980, 0xB981, 0xB982, 0xB983, 0xB986, 0xB988, 0xB98B,
  0xB98C,
  // [ 11542, 11570] -> [0xB98F,0xB9AB] # seg 148
  // [ 11571, 11627] -v # seg 149 at pos 9046
  0xB9AE, 0xB9AF, 0xB9B1, 0xB9B2, 0xB9B3, 0xB9B5, 0xB9B6, 0xB9B7,
  0xB9B8, 0xB9B9, 0xB9BA, 0xB9BB, 0xB9BE, 0xB9C0, 0xB9C2, 0xB9C3,
  0xB9C4, 0xB9C5, 0xB9C6, 0xB9C7, 0xB9CA, 0xB9CB, 0xB9CD, 0xB9D3,
  0xB9D4, 0xB9D5, 0xB9D6, 0xB9D7, 0xB9DA, 0xB9DC, 0xB9DF, 0xB9E0,
  0xB9E2, 0xB9E6, 0xB9E7, 0xB9E9, 0xB9EA, 0xB9EB, 0xB9ED, 0xB9EE,
  0xB9EF, 0xB9F0, 0xB9F1, 0xB9F2, 0xB9F3, 0xB9F6, 0xB9FB, 0xB9FC,
  0xB9FD, 0xB9FE, 0xB9FF, 0xBA02, 0xBA03, 0xBA04, 0xBA05, 0xBA06,
  0xBA07,
  // [ 11628, 11639] -> [0xBA09,0xBA14] # seg 150
  // [ 11640, 11673] -> [0xBA16,0xBA37] # seg 151
  // [ 11674, 11714] -v # seg 152 at pos 9103
  0xBA3A, 0xBA3B, 0xBA3D, 0xBA3E, 0xBA3F, 0xBA41, 0xBA43, 0xBA44,
  0xBA45, 0xBA46, 0xBA47, 0xBA4A, 0xBA4C, 0xBA4F, 0xBA50, 0xBA51,
  0xBA52, 0xBA56, 0xBA57, 0xBA59, 0xBA5A, 0xBA5B, 0xBA5D, 0xBA5E,
  0xBA5F, 0xBA60, 0xBA61, 0xBA62, 0xBA63, 0xBA66, 0xBA6A, 0xBA6B,
  0xBA6C, 0xBA6D, 0xBA6E, 0xBA6F, 0xBA72, 0xBA73, 0xBA75, 0xBA76,
  0xBA77,
  // [ 11715, 11724] -> [0xBA79,0xBA82] # seg 153
  // [ 11725, 11729] -v # seg 154 at pos 9144
  0xBA86, 0xBA88, 0xBA89, 0xBA8A, 0xBA8B,
  // [ 11730, 11756] -> [0xBA8D,0xBAA7] # seg 155
  // [ 11757, 11777] -v # seg 156 at pos 9149
  0xBAAA, 0xBAAD, 0xBAAE, 0xBAAF, 0xBAB1, 0xBAB3, 0xBAB4, 0xBAB5,
  0xBAB6, 0xBAB7, 0xBABA, 0xBABC, 0xBABE, 0xBABF, 0xBAC0, 0xBAC1,
  0xBAC2, 0xBAC3, 0xBAC5, 0xBAC6, 0xBAC7,
  // [ 11778, 11792] -> [0xBAC9,0xBAD7] # seg 157
  // [ 11793, 11826] -> [0xBADA,0xBAFB] # seg 158
  // [ 11827, 11908] -v # seg 159 at pos 9170
  0xBAFD, 0xBAFE, 0xBAFF, 0xBB01, 0xBB02, 0xBB03, 0xBB05, 0xBB06,
  0xBB07, 0xBB08, 0xBB09, 0xBB0A, 0xBB0B, 0xBB0C, 0xBB0E, 0xBB10,
  0xBB12, 0xBB13, 0xBB14, 0xBB15, 0xBB16, 0xBB17, 0xBB19, 0xBB1A,
  0xBB1B, 0xBB1D, 0xBB1E, 0xBB1F, 0xBB21, 0xBB22, 0xBB23, 0xBB24,
  0xBB25, 0xBB26, 0xBB27, 0xBB28, 0xBB2A, 0xBB2C, 0xBB2D, 0xBB2E,
  0xBB2F, 0xBB30, 0xBB31, 0xBB32, 0xBB33, 0xBB37, 0xBB39, 0xBB3A,
  0xBB3F, 0xBB40, 0xBB41, 0xBB42, 0xBB43, 0xBB46, 0xBB48, 0xBB4A,
  0xBB4B, 0xBB4C, 0xBB4E, 0xBB51, 0xBB52, 0xBB53, 0xBB55, 0xBB56,
  0xBB57, 0xBB59, 0xBB5A, 0xBB5B, 0xBB5C, 0xBB5D, 0xBB5E, 0xBB5F,
  0xBB60, 0xBB62, 0xBB64, 0xBB65, 0xBB66, 0xBB67, 0xBB68, 0xBB69,
  0xBB6A, 0xBB6B,
  // [ 11909, 11935] -> [0xBB6D,0xBB87] # seg 160
  // [ 11936, 11941] -v # seg 161 at pos 9252
  0xBB89, 0xBB8A, 0xBB8B, 0xBB8D, 0xBB8E, 0xBB8F,
  // [ 11942, 11960] -> [0xBB91,0xBBA3] # seg 162
  // [ 11961, 11998] -v # seg 163 at pos 9258
  0xBBA5, 0xBBA6, 0xBBA7, 0xBBA9, 0xBBAA, 0xBBAB, 0xBBAD, 0xBBAE,
  0xBBAF, 0xBBB0, 0xBBB1, 0xBBB2, 0xBBB3, 0xBBB5, 0xBBB6, 0xBBB8,
  0xBBB9, 0xBBBA, 0xBBBB, 0xBBBC, 0xBBBD, 0xBBBE, 0xBBBF, 0xBBC1,
  0xBBC2, 0xBBC3, 0xBBC5, 0xBBC6, 0xBBC7, 0xBBC9, 0xBBCA, 0xBBCB,
  0xBBCC, 0xBBCD, 0xBBCE, 0xBBCF, 0xBBD1, 0xBBD2,
  // [ 11999, 12034] -> [0xBBD4,0xBBF7] # seg 164
  // [ 12035, 12082] -v # seg 165 at pos 9296
  0xBBFA, 0xBBFB, 0xBBFD, 0xBBFE, 0xBC01, 0xBC03, 0xBC04, 0xBC05,
  0xBC06, 0xBC07, 0xBC0A, 0xBC0E, 0xBC10, 0xBC12, 0xBC13, 0xBC19,
  0xBC1A, 0xBC20, 0xBC21, 0xBC22, 0xBC23, 0xBC26, 0xBC28, 0xBC2A,
  0xBC2B, 0xBC2C, 0xBC2E, 0xBC2F, 0xBC32, 0xBC33, 0xBC35, 0xBC36,
  0xBC37, 0xBC39, 0xBC3A, 0xBC3B, 0xBC3C, 0xBC3D, 0xBC3E, 0xBC3F,
  0xBC42, 0xBC46, 0xBC47, 0xBC48, 0xBC4A, 0xBC4B, 0xBC4E, 0xBC4F,
  // [ 12083, 12094] -> [0xBC51,0xBC5C] # seg 166
  // [ 12095, 12132] -> [0xBC5E,0xBC83] # seg 167
  // [ 12133, 12189] -v # seg 168 at pos 9344
  0xBC86, 0xBC87, 0xBC89, 0xBC8A, 0xBC8D, 0xBC8F, 0xBC90, 0xBC91,
  0xBC92, 0xBC93, 0xBC96, 0xBC98, 0xBC9B, 0xBC9C, 0xBC9D, 0xBC9E,
  0xBC9F, 0xBCA2, 0xBCA3, 0xBCA5, 0xBCA6, 0xBCA9, 0xBCAA, 0xBCAB,
  0xBCAC, 0xBCAD, 0xBCAE, 0xBCAF, 0xBCB2, 0xBCB6, 0xBCB7, 0xBCB8,
  0xBCB9, 0xBCBA, 0xBCBB, 0xBCBE, 0xBCBF, 0xBCC1, 0xBCC2, 0xBCC3,
  0xBCC5, 0xBCC6, 0xBCC7, 0xBCC8, 0xBCC9, 0xBCCA, 0xBCCB, 0xBCCC,
  0xBCCE, 0xBCD2, 0xBCD3, 0xBCD4, 0xBCD6, 0xBCD7, 0xBCD9, 0xBCDA,
  0xBCDB,
  // [ 12190, 12212] -> [0xBCDD,0xBCF3] # seg 169
  // [ 12213, 12234] -v # seg 170 at pos 9401
  0xBCF7, 0xBCF9, 0xBCFA, 0xBCFB, 0xBCFD, 0xBCFE, 0xBCFF, 0xBD00,
  0xBD01, 0xBD02, 0xBD03, 0xBD06, 0xBD08, 0xBD0A, 0xBD0B, 0xBD0C,
  0xBD0D, 0xBD0E, 0xBD0F, 0xBD11, 0xBD12, 0xBD13,
  // [ 12235, 12249] -> [0xBD15,0xBD23] # seg 171
  // [ 12250, 12256] -> [0xBD25,0xBD2B] # seg 172
  // [ 12257, 12275] -> [0xBD2D,0xBD3F] # seg 173
  // [ 12276, 12294] -v # seg 174 at pos 9423
  0xBD41, 0xBD42, 0xBD43, 0xBD44, 0xBD45, 0xBD46, 0xBD47, 0xBD4A,
  0xBD4B, 0xBD4D, 0xBD4E, 0xBD4F, 0xBD51, 0xBD52, 0xBD53, 0xBD54,
  0xBD55, 0xBD56, 0xBD57,
  // [ 12295, 12304] -> [0xBD5A,0xBD63] # seg 175
  // [ 12305, 12307] -> [0xBD65,0xBD67] # seg 176
  // [ 12308, 12330] -> [0xBD69,0xBD7F] # seg 177
  // [ 12331, 12352] -v # seg 178 at pos 9442
  0xBD82, 0xBD83, 0xBD85, 0xBD86, 0xBD8B, 0xBD8C, 0xBD8D, 0xBD8E,
  0xBD8F, 0xBD92, 0xBD94, 0xBD96, 0xBD97, 0xBD98, 0xBD9B, 0xBD9D,
  0xBD9E, 0xBD9F, 0xBDA0, 0xBDA1, 0xBDA2, 0xBDA3,
  // [ 12353, 12363] -> [0xBDA5,0xBDAF] # seg 179
  // [ 12364, 12370] -> [0xBDB1,0xBDB7] # seg 180
  // [ 12371, 12397] -> [0xBDB9,0xBDD3] # seg 181
  // [ 12398, 12402] -v # seg 182 at pos 9464
  0xBDD6, 0xBDD7, 0xBDD9, 0xBDDA, 0xBDDB,
  // [ 12403, 12414] -> [0xBDDD,0xBDE8] # seg 183
  // [ 12415, 12455] -v # seg 184 at pos 9469
  0xBDEA, 0xBDEB, 0xBDEC, 0xBDED, 0xBDEE, 0xBDEF, 0xBDF1, 0xBDF2,
  0xBDF3, 0xBDF5, 0xBDF6, 0xBDF7, 0xBDF9, 0xBDFA, 0xBDFB, 0xBDFC,
  0xBDFD, 0xBDFE, 0xBDFF, 0xBE01, 0xBE02, 0xBE04, 0xBE06, 0xBE07,
  0xBE08, 0xBE09, 0xBE0A, 0xBE0B, 0xBE0E, 0xBE0F, 0xBE11, 0xBE12,
  0xBE13, 0xBE15, 0xBE16, 0xBE17, 0xBE18, 0xBE19, 0xBE1A, 0xBE1B,
  0xBE1E,
  // [ 12456, 12491] -> [0xBE20,0xBE43] # seg 185
  // [ 12492, 12544] -v # seg 186 at pos 9510
  0xBE46, 0xBE47, 0xBE49, 0xBE4A, 0xBE4B, 0xBE4D, 0xBE4F, 0xBE50,
  0xBE51, 0xBE52, 0xBE53, 0xBE56, 0xBE58, 0xBE5C, 0xBE5D, 0xBE5E,
  0xBE5F, 0xBE62, 0xBE63, 0xBE65, 0xBE66, 0xBE67, 0xBE69, 0xBE6B,
  0xBE6C, 0xBE6D, 0xBE6E, 0xBE6F, 0xBE72, 0xBE76, 0xBE77, 0xBE78,
  0xBE79, 0xBE7A, 0xBE7E, 0xBE7F, 0xBE81, 0xBE82, 0xBE83, 0xBE85,
  0xBE86, 0xBE87, 0xBE88, 0xBE89, 0xBE8A, 0xBE8B, 0xBE8E, 0xBE92,
  0xBE93, 0xBE94, 0xBE95, 0xBE96, 0xBE97,
  // [ 12545, 12558] -> [0xBE9A,0xBEA7] # seg 187
  // [ 12559, 12597] -> [0xBEA9,0xBECF] # seg 188
  // [ 12598, 12616] -v # seg 189 at pos 9563
  0xBED2, 0xBED3, 0xBED5, 0xBED6, 0xBED9, 0xBEDA, 0xBEDB, 0xBEDC,
  0xBEDD, 0xBEDE, 0xBEDF, 0xBEE1, 0xBEE2, 0xBEE6, 0xBEE7, 0xBEE8,
  0xBEE9, 0xBEEA, 0xBEEB,
  // [ 12617, 12636] -> [0xBEED,0xBF00] # seg 190
  // [ 12637, 12642] -> [0xBF02,0xBF07] # seg 191
  // [ 12643, 12656] -> [0xBF0A,0xBF17] # seg 192
  // [ 12657, 12657] -> [0xBF1A,0xBF1A] # seg 193
  // [ 12658, 12691] -> [0xBF1E,0xBF3F] # seg 194
  // [ 12692, 12706] -v # seg 195 at pos 9582
  0xBF42, 0xBF43, 0xBF45, 0xBF46, 0xBF47, 0xBF49, 0xBF4A, 0xBF4B,
  0xBF4C, 0xBF4D, 0xBF4E, 0xBF4F, 0xBF52, 0xBF53, 0xBF54,
  // [ 12707, 12768] -> [0xBF56,0xBF93] # seg 196
  // [ 12769, 12795] -> [0xBF95,0xBFAF] # seg 197
  // [ 12796, 12815] -> [0xBFB1,0xBFC4] # seg 198
  // [ 12816, 12836] -v # seg 199 at pos 9597
  0xBFC6, 0xBFC7, 0xBFC8, 0xBFC9, 0xBFCA, 0xBFCB, 0xBFCE, 0xBFCF,
  0xBFD1, 0xBFD2, 0xBFD3, 0xBFD5, 0xBFD6, 0xBFD7, 0xBFD8, 0xBFD9,
  0xBFDA, 0xBFDB, 0xBFDD, 0xBFDE, 0xBFE0,
  // [ 12837, 12926] -> [0xBFE2,0xC03B] # seg 200
  // [ 12927, 12946] -> [0xC03D,0xC050] # seg 201
  // [ 12947, 12965] -v # seg 202 at pos 9618
  0xC052, 0xC053, 0xC054, 0xC055, 0xC056, 0xC057, 0xC059, 0xC05A,
  0xC05B, 0xC05D, 0xC05E, 0xC05F, 0xC061, 0xC062, 0xC063, 0xC064,
  0xC065, 0xC066, 0xC067,
  // [ 12966, 13003] -> [0xC06A,0xC08F] # seg 203
  // [ 13004, 13156] -v # seg 204 at pos 9637
  0xC092, 0xC093, 0xC095, 0xC096, 0xC097, 0xC099, 0xC09A, 0xC09B,
  0xC09C, 0xC09D, 0xC09E, 0xC09F, 0xC0A2, 0xC0A4, 0xC0A6, 0xC0A7,
  0xC0A8, 0xC0A9, 0xC0AA, 0xC0AB, 0xC0AE, 0xC0B1, 0xC0B2, 0xC0B7,
  0xC0B8, 0xC0B9, 0xC0BA, 0xC0BB, 0xC0BE, 0xC0C2, 0xC0C3, 0xC0C4,
  0xC0C6, 0xC0C7, 0xC0CA, 0xC0CB, 0xC0CD, 0xC0CE, 0xC0CF, 0xC0D1,
  0xC0D2, 0xC0D3, 0xC0D4, 0xC0D5, 0xC0D6, 0xC0D7, 0xC0DA, 0xC0DE,
  0xC0DF, 0xC0E0, 0xC0E1, 0xC0E2, 0xC0E3, 0xC0E6, 0xC0E7, 0xC0E9,
  0xC0EA, 0xC0EB, 0xC0ED, 0xC0EE, 0xC0EF, 0xC0F0, 0xC0F1, 0xC0F2,
  0xC0F3, 0xC0F6, 0xC0F8, 0xC0FA, 0xC0FB, 0xC0FC, 0xC0FD, 0xC0FE,
  0xC0FF, 0xC101, 0xC102, 0xC103, 0xC105, 0xC106, 0xC107, 0xC109,
  0xC10A, 0xC10B, 0xC10C, 0xC10D, 0xC10E, 0xC10F, 0xC111, 0xC112,
  0xC113, 0xC114, 0xC116, 0xC117, 0xC118, 0xC119, 0xC11A, 0xC11B,
  0xC121, 0xC122, 0xC125, 0xC128, 0xC129, 0xC12A, 0xC12B, 0xC12E,
  0xC132, 0xC133, 0xC134, 0xC135, 0xC137, 0xC13A, 0xC13B, 0xC13D,
  0xC13E, 0xC13F, 0xC141, 0xC142, 0xC143, 0xC144, 0xC145, 0xC146,
  0xC147, 0xC14A, 0xC14E, 0xC14F, 0xC150, 0xC151, 0xC152, 0xC153,
  0xC156, 0xC157, 0xC159, 0xC15A, 0xC15B, 0xC15D, 0xC15E, 0xC15F,
  0xC160, 0xC161, 0xC162, 0xC163, 0xC166, 0xC16A, 0xC16B, 0xC16C,
  0xC16D, 0xC16E, 0xC16F, 0xC171, 0xC172, 0xC173, 0xC175, 0xC176,
  0xC177,
  // [ 13157, 13168] -> [0xC179,0xC184] # seg 205
  // [ 13169, 13196] -v # seg 206 at pos 9790
  0xC186, 0xC187, 0xC188, 0xC189, 0xC18A, 0xC18B, 0xC18F, 0xC191,
  0xC192, 0xC193, 0xC195, 0xC197, 0xC198, 0xC199, 0xC19A, 0xC19B,
  0xC19E, 0xC1A0, 0xC1A2, 0xC1A3, 0xC1A4, 0xC1A6, 0xC1A7, 0xC1AA,
  0xC1AB, 0xC1AD, 0xC1AE, 0xC1AF,
  // [ 13197, 13208] -> [0xC1B1,0xC1BC] # seg 207
  // [ 13209, 13294] -v # seg 208 at pos 9818
  0xC1BE, 0xC1BF, 0xC1C0, 0xC1C1, 0xC1C2, 0xC1C3, 0xC1C5, 0xC1C6,
  0xC1C7, 0xC1C9, 0xC1CA, 0xC1CB, 0xC1CD, 0xC1CE, 0xC1CF, 0xC1D0,
  0xC1D1, 0xC1D2, 0xC1D3, 0xC1D5, 0xC1D6, 0xC1D9, 0xC1DA, 0xC1DB,
  0xC1DC, 0xC1DD, 0xC1DE, 0xC1DF, 0xC1E1, 0xC1E2, 0xC1E3, 0xC1E5,
  0xC1E6, 0xC1E7, 0xC1E9, 0xC1EA, 0xC1EB, 0xC1EC, 0xC1ED, 0xC1EE,
  0xC1EF, 0xC1F2, 0xC1F4, 0xC1F5, 0xC1F6, 0xC1F7, 0xC1F8, 0xC1F9,
  0xC1FA, 0xC1FB, 0xC1FE, 0xC1FF, 0xC201, 0xC202, 0xC203, 0xC205,
  0xC206, 0xC207, 0xC208, 0xC209, 0xC20A, 0xC20B, 0xC20E, 0xC210,
  0xC212, 0xC213, 0xC214, 0xC215, 0xC216, 0xC217, 0xC21A, 0xC21B,
  0xC21D, 0xC21E, 0xC221, 0xC222, 0xC223, 0xC224, 0xC225, 0xC226,
  0xC227, 0xC22A, 0xC22C, 0xC22E, 0xC230, 0xC233,
  // [ 13295, 13313] -> [0xC235,0xC247] # seg 209
  // [ 13314, 13397] -v # seg 210 at pos 9904
  0xC249, 0xC24A, 0xC24B, 0xC24C, 0xC24D, 0xC24E, 0xC24F, 0xC252,
  0xC253, 0xC255, 0xC256, 0xC257, 0xC259, 0xC25A, 0xC25B, 0xC25C,
  0xC25D, 0xC25E, 0xC25F, 0xC261, 0xC262, 0xC263, 0xC264, 0xC266,
  0xC267, 0xC268, 0xC269, 0xC26A, 0xC26B, 0xC26E, 0xC26F, 0xC271,
  0xC272, 0xC273, 0xC275, 0xC276, 0xC277, 0xC278, 0xC279, 0xC27A,
  0xC27B, 0xC27E, 0xC280, 0xC282, 0xC283, 0xC284, 0xC285, 0xC286,
  0xC287, 0xC28A, 0xC28B, 0xC28C, 0xC28D, 0xC28E, 0xC28F, 0xC291,
  0xC292, 0xC293, 0xC294, 0xC295, 0xC296, 0xC297, 0xC299, 0xC29A,
  0xC29C, 0xC29E, 0xC29F, 0xC2A0, 0xC2A1, 0xC2A2, 0xC2A3, 0xC2A6,
  0xC2A7, 0xC2A9, 0xC2AA, 0xC2AB, 0xC2AE, 0xC2AF, 0xC2B0, 0xC2B1,
  0xC2B2, 0xC2B3, 0xC2B6, 0xC2B8,
  // [ 13398, 13431] -> [0xC2BA,0xC2DB] # seg 211
  // [ 13432, 13480] -v # seg 212 at pos 9988
  0xC2DE, 0xC2DF, 0xC2E1, 0xC2E2, 0xC2E5, 0xC2E6, 0xC2E7, 0xC2E8,
  0xC2E9, 0xC2EA, 0xC2EE, 0xC2F0, 0xC2F2, 0xC2F3, 0xC2F4, 0xC2F5,
  0xC2F7, 0xC2FA, 0xC2FD, 0xC2FE, 0xC2FF, 0xC301, 0xC302, 0xC303,
  0xC304, 0xC305, 0xC306, 0xC307, 0xC30A, 0xC30B, 0xC30E, 0xC30F,
  0xC310, 0xC311, 0xC312, 0xC316, 0xC317, 0xC319, 0xC31A, 0xC31B,
  0xC31D, 0xC31E, 0xC31F, 0xC320, 0xC321, 0xC322, 0xC323, 0xC326,
  0xC327,
  // [ 13481, 13507] -> [0xC32A,0xC344] # seg 213
  // [ 13508, 13541] -> [0xC346,0xC367] # seg 214
  // [ 13542, 13566] -v # seg 215 at pos 10037
  0xC36A, 0xC36B, 0xC36D, 0xC36E, 0xC36F, 0xC371, 0xC373, 0xC374,
  0xC375, 0xC376, 0xC377, 0xC37A, 0xC37B, 0xC37E, 0xC37F, 0xC380,
  0xC381, 0xC382, 0xC383, 0xC385, 0xC386, 0xC387, 0xC389, 0xC38A,
  0xC38B,
  // [ 13567, 13617] -> [0xC38D,0xC3BF] # seg 216
  // [ 13618, 13640] -> [0xC3C1,0xC3D7] # seg 217
  // [ 13641, 13661] -v # seg 218 at pos 10062
  0xC3DA, 0xC3DB, 0xC3DD, 0xC3DE, 0xC3E1, 0xC3E3, 0xC3E4, 0xC3E5,
  0xC3E6, 0xC3E7, 0xC3EA, 0xC3EB, 0xC3EC, 0xC3EE, 0xC3EF, 0xC3F0,
  0xC3F1, 0xC3F2, 0xC3F3, 0xC3F6, 0xC3F7,
  // [ 13662, 13676] -> [0xC3F9,0xC407] # seg 219
  // [ 13677, 13683] -> [0xC409,0xC40F] # seg 220
  // [ 13684, 13702] -> [0xC411,0xC423] # seg 221
  // [ 13703, 13722] -v # seg 222 at pos 10083
  0xC425, 0xC426, 0xC427, 0xC428, 0xC429, 0xC42A, 0xC42B, 0xC42D,
  0xC42E, 0xC42F, 0xC431, 0xC432, 0xC433, 0xC435, 0xC436, 0xC437,
  0xC438, 0xC439, 0xC43A, 0xC43B,
  // [ 13723, 13732] -> [0xC43E,0xC447] # seg 223
  // [ 13733, 13759] -> [0xC449,0xC463] # seg 224
  // [ 13760, 13780] -v # seg 225 at pos 10103
  0xC466, 0xC467, 0xC469, 0xC46A, 0xC46B, 0xC46D, 0xC46E, 0xC46F,
  0xC470, 0xC471, 0xC472, 0xC473, 0xC476, 0xC477, 0xC478, 0xC47A,
  0xC47B, 0xC47C, 0xC47D, 0xC47E, 0xC47F,
  // [ 13781, 13799] -> [0xC481,0xC493] # seg 226
  // [ 13800, 13806] -> [0xC495,0xC49B] # seg 227
  // [ 13807, 13833] -> [0xC49D,0xC4B7] # seg 228
  // [ 13834, 13836] -> [0xC4B9,0xC4BB] # seg 229
  // [ 13837, 13880] -> [0xC4BD,0xC4E8] # seg 230
  // [ 13881, 13896] -v # seg 231 at pos 10124
  0xC4EA, 0xC4EB, 0xC4EC, 0xC4ED, 0xC4EE, 0xC4EF, 0xC4F2, 0xC4F3,
  0xC4F5, 0xC4F6, 0xC4F7, 0xC4F9, 0xC4FB, 0xC4FC, 0xC4FD, 0xC4FE,
  // [ 13897, 13906] -> [0xC502,0xC50B] # seg 232
  // [ 13907, 13919] -v # seg 233 at pos 10140
  0xC50D, 0xC50E, 0xC50F, 0xC511, 0xC512, 0xC513, 0xC515, 0xC516,
  0xC517, 0xC518, 0xC519, 0xC51A, 0xC51B,
  // [ 13920, 13930] -> [0xC51D,0xC527] # seg 234
  // [ 13931, 14012] -v # seg 235 at pos 10153
  0xC52A, 0xC52B, 0xC52D, 0xC52E, 0xC52F, 0xC531, 0xC532, 0xC533,
  0xC534, 0xC535, 0xC536, 0xC537, 0xC53A, 0xC53C, 0xC53E, 0xC53F,
  0xC540, 0xC541, 0xC542, 0xC543, 0xC546, 0xC547, 0xC54B, 0xC54F,
  0xC550, 0xC551, 0xC552, 0xC556, 0xC55A, 0xC55B, 0xC55C, 0xC55F,
  0xC562, 0xC563, 0xC565, 0xC566, 0xC567, 0xC569, 0xC56A, 0xC56B,
  0xC56C, 0xC56D, 0xC56E, 0xC56F, 0xC572, 0xC576, 0xC577, 0xC578,
  0xC579, 0xC57A, 0xC57B, 0xC57E, 0xC57F, 0xC581, 0xC582, 0xC583,
  0xC585, 0xC586, 0xC588, 0xC589, 0xC58A, 0xC58B, 0xC58E, 0xC590,
  0xC592, 0xC593, 0xC594, 0xC596, 0xC599, 0xC59A, 0xC59B, 0xC59D,
  0xC59E, 0xC59F, 0xC5A1, 0xC5A2, 0xC5A3, 0xC5A4, 0xC5A5, 0xC5A6,
  0xC5A7, 0xC5A8,
  // [ 14013, 14022] -> [0xC5AA,0xC5B3] # seg 236
  // [ 14023, 14122] -v # seg 237 at pos 10235
  0xC5B6, 0xC5B7, 0xC5BA, 0xC5BF, 0xC5C0, 0xC5C1, 0xC5C2, 0xC5C3,
  0xC5CB, 0xC5CD, 0xC5CF, 0xC5D2, 0xC5D3, 0xC5D5, 0xC5D6, 0xC5D7,
  0xC5D9, 0xC5DA, 0xC5DB, 0xC5DC, 0xC5DD, 0xC5DE, 0xC5DF, 0xC5E2,
  0xC5E4, 0xC5E6, 0xC5E7, 0xC5E8, 0xC5E9, 0xC5EA, 0xC5EB, 0xC5EF,
  0xC5F1, 0xC5F2, 0xC5F3, 0xC5F5, 0xC5F8, 0xC5F9, 0xC5FA, 0xC5FB,
  0xC602, 0xC603, 0xC604, 0xC609, 0xC60A, 0xC60B, 0xC60D, 0xC60E,
  0xC60F, 0xC611, 0xC612, 0xC613, 0xC614, 0xC615, 0xC616, 0xC617,
  0xC61A, 0xC61D, 0xC61E, 0xC61F, 0xC620, 0xC621, 0xC622, 0xC623,
  0xC626, 0xC627, 0xC629, 0xC62A, 0xC62B, 0xC62F, 0xC631, 0xC632,
  0xC636, 0xC638, 0xC63A, 0xC63C, 0xC63D, 0xC63E, 0xC63F, 0xC642,
  0xC643, 0xC645, 0xC646, 0xC647, 0xC649, 0xC64A, 0xC64B, 0xC64C,
  0xC64D, 0xC64E, 0xC64F, 0xC652, 0xC656, 0xC657, 0xC658, 0xC659,
  0xC65A, 0xC65B, 0xC65E, 0xC65F,
  // [ 14123, 14133] -> [0xC661,0xC66B] # seg 238
  // [ 14134, 14391] -v # seg 239 at pos 10335
  0xC66D, 0xC66E, 0xC670, 0xC672, 0xC673, 0xC674, 0xC675, 0xC676,
  0xC677, 0xC67A, 0xC67B, 0xC67D, 0xC67E, 0xC67F, 0xC681, 0xC682,
  0xC683, 0xC684, 0xC685, 0xC686, 0xC687, 0xC68A, 0xC68C, 0xC68E,
  0xC68F, 0xC690, 0xC691, 0xC692, 0xC693, 0xC696, 0xC697, 0xC699,
  0xC69A, 0xC69B, 0xC69D, 0xC69E, 0xC69F, 0xC6A0, 0xC6A1, 0xC6A2,
  0xC6A3, 0xC6A6, 0xC6A8, 0xC6AA, 0xC6AB, 0xC6AC, 0xC6AD, 0xC6AE,
  0xC6AF, 0xC6B2, 0xC6B3, 0xC6B5, 0xC6B6, 0xC6B7, 0xC6BB, 0xC6BC,
  0xC6BD, 0xC6BE, 0xC6BF, 0xC6C2, 0xC6C4, 0xC6C6, 0xC6C7, 0xC6C8,
  0xC6C9, 0xC6CA, 0xC6CB, 0xC6CE, 0xC6CF, 0xC6D1, 0xC6D2, 0xC6D3,
  0xC6D5, 0xC6D6, 0xC6D7, 0xC6D8, 0xC6D9, 0xC6DA, 0xC6DB, 0xC6DE,
  0xC6DF, 0xC6E2, 0xC6E3, 0xC6E4, 0xC6E5, 0xC6E6, 0xC6E7, 0xC6EA,
  0xC6EB, 0xC6ED, 0xC6EE, 0xC6EF, 0xC6F1, 0xC6F2, 0xC6F3, 0xC6F4,
  0xC6F5, 0xC6F6, 0xC6F7, 0xC6FA, 0xC6FB, 0xC6FC, 0xC6FE, 0xC6FF,
  0xC700, 0xC701, 0xC702, 0xC703, 0xC706, 0xC707, 0xC709, 0xC70A,
  0xC70B, 0xC70D, 0xC70E, 0xC70F, 0xC710, 0xC711, 0xC712, 0xC713,
  0xC716, 0xC718, 0xC71A, 0xC71B, 0xC71C, 0xC71D, 0xC71E, 0xC71F,
  0xC722, 0xC723, 0xC725, 0xC726, 0xC727, 0xC729, 0xC72A, 0xC72B,
  0xC72C, 0xC72D, 0xC72E, 0xC72F, 0xC732, 0xC734, 0xC736, 0xC738,
  0xC739, 0xC73A, 0xC73B, 0xC73E, 0xC73F, 0xC741, 0xC742, 0xC743,
  0xC745, 0xC746, 0xC747, 0xC748, 0xC749, 0xC74B, 0xC74E, 0xC750,
  0xC759, 0xC75A, 0xC75B, 0xC75D, 0xC75E, 0xC75F, 0xC761, 0xC762,
  0xC763, 0xC764, 0xC765, 0xC766, 0xC767, 0xC769, 0xC76A, 0xC76C,
  0xC76D, 0xC76E, 0xC76F, 0xC770, 0xC771, 0xC772, 0xC773, 0xC776,
  0xC777, 0xC779, 0xC77A, 0xC77B, 0xC77F, 0xC780, 0xC781, 0xC782,
  0xC786, 0xC78B, 0xC78C, 0xC78D, 0xC78F, 0xC792, 0xC793, 0xC795,
  0xC799, 0xC79B, 0xC79C, 0xC79D, 0xC79E, 0xC79F, 0xC7A2, 0xC7A7,
  0xC7A8, 0xC7A9, 0xC7AA, 0xC7AB, 0xC7AE, 0xC7AF, 0xC7B1, 0xC7B2,
  0xC7B3, 0xC7B5, 0xC7B6, 0xC7B7, 0xC7B8, 0xC7B9, 0xC7BA, 0xC7BB,
  0xC7BE, 0xC7C2, 0xC7C3, 0xC7C4, 0xC7C5, 0xC7C6, 0xC7C7, 0xC7CA,
  0xC7CB, 0xC7CD, 0xC7CF, 0xC7D1, 0xC7D2, 0xC7D3, 0xC7D4, 0xC7D5,
  0xC7D6, 0xC7D7, 0xC7D9, 0xC7DA, 0xC7DB, 0xC7DC, 0xC7DE, 0xC7DF,
  0xC7E0, 0xC7E1, 0xC7E2, 0xC7E3, 0xC7E5, 0xC7E6, 0xC7E7, 0xC7E9,
  0xC7EA, 0xC7EB,
  // [ 14392, 14410] -> [0xC7ED,0xC7FF] # seg 240
  // [ 14411, 14469] -v # seg 241 at pos 10593
  0xC802, 0xC803, 0xC805, 0xC806, 0xC807, 0xC809, 0xC80B, 0xC80C,
  0xC80D, 0xC80E, 0xC80F, 0xC812, 0xC814, 0xC817, 0xC818, 0xC819,
  0xC81A, 0xC81B, 0xC81E, 0xC81F, 0xC821, 0xC822, 0xC823, 0xC825,
  0xC826, 0xC827, 0xC828, 0xC829, 0xC82A, 0xC82B, 0xC82E, 0xC830,
  0xC832, 0xC833, 0xC834, 0xC835, 0xC836, 0xC837, 0xC839, 0xC83A,
  0xC83B, 0xC83D, 0xC83E, 0xC83F, 0xC841, 0xC842, 0xC843, 0xC844,
  0xC845, 0xC846, 0xC847, 0xC84A, 0xC84B, 0xC84E, 0xC84F, 0xC850,
  0xC851, 0xC852, 0xC853,
  // [ 14470, 14496] -> [0xC855,0xC86F] # seg 242
  // [ 14497, 14534] -v # seg 243 at pos 10652
  0xC872, 0xC873, 0xC875, 0xC876, 0xC877, 0xC879, 0xC87B, 0xC87C,
  0xC87D, 0xC87E, 0xC87F, 0xC882, 0xC884, 0xC888, 0xC889, 0xC88A,
  0xC88E, 0xC88F, 0xC890, 0xC891, 0xC892, 0xC893, 0xC895, 0xC896,
  0xC897, 0xC898, 0xC899, 0xC89A, 0xC89B, 0xC89C, 0xC89E, 0xC8A0,
  0xC8A2, 0xC8A3, 0xC8A4, 0xC8A5, 0xC8A6, 0xC8A7,
  // [ 14535, 14553] -> [0xC8A9,0xC8BB] # seg 244
  // [ 14554, 14582] -v # seg 245 at pos 10690
  0xC8BE, 0xC8BF, 0xC8C0, 0xC8C1, 0xC8C2, 0xC8C3, 0xC8C5, 0xC8C6,
  0xC8C7, 0xC8C9, 0xC8CA, 0xC8CB, 0xC8CD, 0xC8CE, 0xC8CF, 0xC8D0,
  0xC8D1, 0xC8D2, 0xC8D3, 0xC8D6, 0xC8D8, 0xC8DA, 0xC8DB, 0xC8DC,
  0xC8DD, 0xC8DE, 0xC8DF, 0xC8E2, 0xC8E3,
  // [ 14583, 14598] -> [0xC8E5,0xC8F4] # seg 246
  // [ 14599, 14622] -v # seg 247 at pos 10719
  0xC8F6, 0xC8F7, 0xC8F8, 0xC8F9, 0xC8FA, 0xC8FB, 0xC8FE, 0xC8FF,
  0xC901, 0xC902, 0xC903, 0xC907, 0xC908, 0xC909, 0xC90A, 0xC90B,
  0xC90E, 0xC910, 0xC912, 0xC913, 0xC914, 0xC915, 0xC916, 0xC917,
  // [ 14623, 14641] -> [0xC919,0xC92B] # seg 248
  // [ 14642, 14648] -> [0xC92D,0xC933] # seg 249
  // [ 14649, 14675] -> [0xC935,0xC94F] # seg 250
  // [ 14676, 14709] -v # seg 251 at pos 10743
  0xC952, 0xC953, 0xC955, 0xC956, 0xC957, 0xC959, 0xC95A, 0xC95B,
  0xC95C, 0xC95D, 0xC95E, 0xC95F, 0xC962, 0xC964, 0xC965, 0xC966,
  0xC967, 0xC968, 0xC969, 0xC96A, 0xC96B, 0xC96D, 0xC96E, 0xC96F,
  0xC971, 0xC972, 0xC973, 0xC975, 0xC976, 0xC977, 0xC978, 0xC979,
  0xC97A, 0xC97B,
  // [ 14710, 14720] -> [0xC97D,0xC987] # seg 252
  // [ 14721, 14734] -v # seg 253 at pos 10777
  0xC98A, 0xC98B, 0xC98D, 0xC98E, 0xC98F, 0xC991, 0xC992, 0xC993,
  0xC994, 0xC995, 0xC996, 0xC997, 0xC99A, 0xC99C,
  // [ 14735, 14768] -> [0xC99E,0xC9BF] # seg 254
  // [ 14769, 14822] -v # seg 255 at pos 10791
  0xC9C2, 0xC9C3, 0xC9C5, 0xC9C6, 0xC9C9, 0xC9CB, 0xC9CC, 0xC9CD,
  0xC9CE, 0xC9CF, 0xC9D2, 0xC9D4, 0xC9D7, 0xC9D8, 0xC9DB, 0xC9DE,
  0xC9DF, 0xC9E1, 0xC9E3, 0xC9E5, 0xC9E6, 0xC9E8, 0xC9E9, 0xC9EA,
  0xC9EB, 0xC9EE, 0xC9F2, 0xC9F3, 0xC9F4, 0xC9F5, 0xC9F6, 0xC9F7,
  0xC9FA, 0xC9FB, 0xC9FD, 0xC9FE, 0xC9FF, 0xCA01, 0xCA02, 0xCA03,
  0xCA04, 0xCA05, 0xCA06, 0xCA07, 0xCA0A, 0xCA0E, 0xCA0F, 0xCA10,
  0xCA11, 0xCA12, 0xCA13, 0xCA15, 0xCA16, 0xCA17,
  // [ 14823, 14838] -> [0xCA19,0xCA28] # seg 256
  // [ 14839, 14872] -> [0xCA2A,0xCA4B] # seg 257
  // [ 14873, 14891] -v # seg 258 at pos 10845
  0xCA4E, 0xCA4F, 0xCA51, 0xCA52, 0xCA53, 0xCA55, 0xCA56, 0xCA57,
  0xCA58, 0xCA59, 0xCA5A, 0xCA5B, 0xCA5E, 0xCA62, 0xCA63, 0xCA64,
  0xCA65, 0xCA66, 0xCA67,
  // [ 14892, 14911] -> [0xCA69,0xCA7C] # seg 259
  // [ 14912, 14917] -> [0xCA7E,0xCA83] # seg 260
  // [ 14918, 14936] -> [0xCA85,0xCA97] # seg 261
  // [ 14937, 14971] -> [0xCA99,0xCABB] # seg 262
  // [ 14972, 14996] -v # seg 263 at pos 10864
  0xCABE, 0xCABF, 0xCAC1, 0xCAC2, 0xCAC3, 0xCAC5, 0xCAC6, 0xCAC7,
  0xCAC8, 0xCAC9, 0xCACA, 0xCACB, 0xCACE, 0xCAD0, 0xCAD2, 0xCAD4,
  0xCAD5, 0xCAD6, 0xCAD7, 0xCADA, 0xCADB, 0xCADC, 0xCADD, 0xCADE,
  0xCADF,
  // [ 14997, 15007] -> [0xCAE1,0xCAEB] # seg 264
  // [ 15008, 15014] -> [0xCAED,0xCAF3] # seg 265
  // [ 15015, 15033] -> [0xCAF5,0xCB07] # seg 266
  // [ 15034, 15053] -v # seg 267 at pos 10889
  0xCB09, 0xCB0A, 0xCB0B, 0xCB0C, 0xCB0D, 0xCB0E, 0xCB0F, 0xCB11,
  0xCB12, 0xCB13, 0xCB15, 0xCB16, 0xCB17, 0xCB19, 0xCB1A, 0xCB1B,
  0xCB1C, 0xCB1D, 0xCB1E, 0xCB1F,
  // [ 15054, 15084] -> [0xCB22,0xCB40] # seg 268
  // [ 15085, 15111] -v # seg 269 at pos 10909
  0xCB42, 0xCB43, 0xCB44, 0xCB45, 0xCB46, 0xCB47, 0xCB4A, 0xCB4B,
  0xCB4D, 0xCB4E, 0xCB4F, 0xCB51, 0xCB52, 0xCB53, 0xCB54, 0xCB55,
  0xCB56, 0xCB57, 0xCB5A, 0xCB5B, 0xCB5C, 0xCB5E, 0xCB5F, 0xCB60,
  0xCB61, 0xCB62, 0xCB63,
  // [ 15112, 15130] -> [0xCB65,0xCB77] # seg 270
  // [ 15131, 15164] -> [0xCB7A,0xCB9B] # seg 271
  // [ 15165, 15191] -> [0xCB9D,0xCBB7] # seg 272
  // [ 15192, 15218] -> [0xCBB9,0xCBD3] # seg 273
  // [ 15219, 15233] -> [0xCBD5,0xCBE3] # seg 274
  // [ 15234, 15236] -v # seg 275 at pos 10936
  0xCBE5, 0xCBE6, 0xCBE8,
  // [ 15237, 15270] -> [0xCBEA,0xCC0B] # seg 276
  // [ 15271, 15341] -v # seg 277 at pos 10939
  0xCC0E, 0xCC0F, 0xCC11, 0xCC12, 0xCC13, 0xCC15, 0xCC16, 0xCC17,
  0xCC18, 0xCC19, 0xCC1A, 0xCC1B, 0xCC1E, 0xCC1F, 0xCC20, 0xCC23,
  0xCC24, 0xCC25, 0xCC26, 0xCC2A, 0xCC2B, 0xCC2D, 0xCC2F, 0xCC31,
  0xCC32, 0xCC33, 0xCC34, 0xCC35, 0xCC36, 0xCC37, 0xCC3A, 0xCC3F,
  0xCC40, 0xCC41, 0xCC42, 0xCC43, 0xCC46, 0xCC47, 0xCC49, 0xCC4A,
  0xCC4B, 0xCC4D, 0xCC4E, 0xCC4F, 0xCC50, 0xCC51, 0xCC52, 0xCC53,
  0xCC56, 0xCC5A, 0xCC5B, 0xCC5C, 0xCC5D, 0xCC5E, 0xCC5F, 0xCC61,
  0xCC62, 0xCC63, 0xCC65, 0xCC67, 0xCC69, 0xCC6A, 0xCC6B, 0xCC6C,
  0xCC6D, 0xCC6E, 0xCC6F, 0xCC71, 0xCC72, 0xCC73, 0xCC74,
  // [ 15342, 15375] -> [0xCC76,0xCC97] # seg 278
  // [ 15376, 15417] -v # seg 279 at pos 11010
  0xCC9A, 0xCC9B, 0xCC9D, 0xCC9E, 0xCC9F, 0xCCA1, 0xCCA2, 0xCCA3,
  0xCCA4, 0xCCA5, 0xCCA6, 0xCCA7, 0xCCAA, 0xCCAE, 0xCCAF, 0xCCB0,
  0xCCB1, 0xCCB2, 0xCCB3, 0xCCB6, 0xCCB7, 0xCCB9, 0xCCBA, 0xCCBB,
  0xCCBD, 0xCCBE, 0xCCBF, 0xCCC0, 0xCCC1, 0xCCC2, 0xCCC3, 0xCCC6,
  0xCCC8, 0xCCCA, 0xCCCB, 0xCCCC, 0xCCCD, 0xCCCE, 0xCCCF, 0xCCD1,
  0xCCD2, 0xCCD3,
  // [ 15418, 15432] -> [0xCCD5,0xCCE3] # seg 280
  // [ 15433, 15442] -v # seg 281 at pos 11052
  0xCCE5, 0xCCE6, 0xCCE7, 0xCCE8, 0xCCE9, 0xCCEA, 0xCCEB, 0xCCED,
  0xCCEE, 0xCCEF,
  // [ 15443, 15458] -> [0xCCF1,0xCD00] # seg 282
  // [ 15459, 15490] -v # seg 283 at pos 11062
  0xCD02, 0xCD03, 0xCD04, 0xCD05, 0xCD06, 0xCD07, 0xCD0A, 0xCD0B,
  0xCD0D, 0xCD0E, 0xCD0F, 0xCD11, 0xCD12, 0xCD13, 0xCD14, 0xCD15,
  0xCD16, 0xCD17, 0xCD1A, 0xCD1C, 0xCD1E, 0xCD1F, 0xCD20, 0xCD21,
  0xCD22, 0xCD23, 0xCD25, 0xCD26, 0xCD27, 0xCD29, 0xCD2A, 0xCD2B,
  // [ 15491, 15502] -> [0xCD2D,0xCD38] # seg 284
  // [ 15503, 15536] -> [0xCD3A,0xCD5B] # seg 285
  // [ 15537, 15557] -v # seg 286 at pos 11094
  0xCD5D, 0xCD5E, 0xCD5F, 0xCD61, 0xCD62, 0xCD63, 0xCD65, 0xCD66,
  0xCD67, 0xCD68, 0xCD69, 0xCD6A, 0xCD6B, 0xCD6E, 0xCD70, 0xCD72,
  0xCD73, 0xCD74, 0xCD75, 0xCD76, 0xCD77,
  // [ 15558, 15572] -> [0xCD79,0xCD87] # seg 287
  // [ 15573, 15583] -> [0xCD89,0xCD93] # seg 288
  // [ 15584, 15603] -v # seg 289 at pos 11115
  0xCD96, 0xCD97, 0xCD99, 0xCD9A, 0xCD9B, 0xCD9D, 0xCD9E, 0xCD9F,
  0xCDA0, 0xCDA1, 0xCDA2, 0xCDA3, 0xCDA6, 0xCDA8, 0xCDAA, 0xCDAB,
  0xCDAC, 0xCDAD, 0xCDAE, 0xCDAF,
  // [ 15604, 15622] -> [0xCDB1,0xCDC3] # seg 290
  // [ 15623, 15632] -v # seg 291 at pos 11135
  0xCDC5, 0xCDC6, 0xCDC7, 0xCDC8, 0xCDC9, 0xCDCA, 0xCDCB, 0xCDCD,
  0xCDCE, 0xCDCF,
  // [ 15633, 15655] -> [0xCDD1,0xCDE7] # seg 292
  // [ 15656, 15713] -v # seg 293 at pos 11145
  0xCDE9, 0xCDEA, 0xCDEB, 0xCDED, 0xCDEE, 0xCDEF, 0xCDF1, 0xCDF2,
  0xCDF3, 0xCDF4, 0xCDF5, 0xCDF6, 0xCDF7, 0xCDFA, 0xCDFC, 0xCDFE,
  0xCDFF, 0xCE00, 0xCE01, 0xCE02, 0xCE03, 0xCE05, 0xCE06, 0xCE07,
  0xCE09, 0xCE0A, 0xCE0B, 0xCE0D, 0xCE0E, 0xCE0F, 0xCE10, 0xCE11,
  0xCE12, 0xCE13, 0xCE15, 0xCE16, 0xCE17, 0xCE18, 0xCE1A, 0xCE1B,
  0xCE1C, 0xCE1D, 0xCE1E, 0xCE1F, 0xCE22, 0xCE23, 0xCE25, 0xCE26,
  0xCE27, 0xCE29, 0xCE2A, 0xCE2B, 0xCE2C, 0xCE2D, 0xCE2E, 0xCE2F,
  0xCE32, 0xCE34,
  // [ 15714, 15747] -> [0xCE36,0xCE57] # seg 294
  // [ 15748, 15804] -v # seg 295 at pos 11203
  0xCE5A, 0xCE5B, 0xCE5D, 0xCE5E, 0xCE62, 0xCE63, 0xCE64, 0xCE65,
  0xCE66, 0xCE67, 0xCE6A, 0xCE6C, 0xCE6E, 0xCE6F, 0xCE70, 0xCE71,
  0xCE72, 0xCE73, 0xCE76, 0xCE77, 0xCE79, 0xCE7A, 0xCE7B, 0xCE7D,
  0xCE7E, 0xCE7F, 0xCE80, 0xCE81, 0xCE82, 0xCE83, 0xCE86, 0xCE88,
  0xCE8A, 0xCE8B, 0xCE8C, 0xCE8D, 0xCE8E, 0xCE8F, 0xCE92, 0xCE93,
  0xCE95, 0xCE96, 0xCE97, 0xCE99, 0xCE9A, 0xCE9B, 0xCE9C, 0xCE9D,
  0xCE9E, 0xCE9F, 0xCEA2, 0xCEA6, 0xCEA7, 0xCEA8, 0xCEA9, 0xCEAA,
  0xCEAB,
  // [ 15805, 15823] -> [0xCEAE,0xCEC0] # seg 296
  // [ 15824, 15857] -> [0xCEC2,0xCEE3] # seg 297
  // [ 15858, 15915] -v # seg 298 at pos 11260
  0xCEE6, 0xCEE7, 0xCEE9, 0xCEEA, 0xCEED, 0xCEEE, 0xCEEF, 0xCEF0,
  0xCEF1, 0xCEF2, 0xCEF3, 0xCEF6, 0xCEFA, 0xCEFB, 0xCEFC, 0xCEFD,
  0xCEFE, 0xCEFF, 0xCF02, 0xCF03, 0xCF05, 0xCF06, 0xCF07, 0xCF09,
  0xCF0A, 0xCF0B, 0xCF0C, 0xCF0D, 0xCF0E, 0xCF0F, 0xCF12, 0xCF14,
  0xCF16, 0xCF17, 0xCF18, 0xCF19, 0xCF1A, 0xCF1B, 0xCF1D, 0xCF1E,
  0xCF1F, 0xCF21, 0xCF22, 0xCF23, 0xCF25, 0xCF26, 0xCF27, 0xCF28,
  0xCF29, 0xCF2A, 0xCF2B, 0xCF2E, 0xCF32, 0xCF33, 0xCF34, 0xCF35,
  0xCF36, 0xCF37,
  // [ 15916, 15942] -> [0xCF39,0xCF53] # seg 299
  // [ 15943, 15984] -v # seg 300 at pos 11318
  0xCF56, 0xCF57, 0xCF59, 0xCF5A, 0xCF5B, 0xCF5D, 0xCF5E, 0xCF5F,
  0xCF60, 0xCF61, 0xCF62, 0xCF63, 0xCF66, 0xCF68, 0xCF6A, 0xCF6B,
  0xCF6C, 0xCF6D, 0xCF6E, 0xCF6F, 0xCF72, 0xCF73, 0xCF75, 0xCF76,
  0xCF77, 0xCF79, 0xCF7A, 0xCF7B, 0xCF7C, 0xCF7D, 0xCF7E, 0xCF7F,
  0xCF81, 0xCF82, 0xCF83, 0xCF84, 0xCF86, 0xCF87, 0xCF88, 0xCF89,
  0xCF8A, 0xCF8B,
  // [ 15985, 16004] -> [0xCF8D,0xCFA0] # seg 301
  // [ 16005, 16017] -v # seg 302 at pos 11360
  0xCFA2, 0xCFA3, 0xCFA4, 0xCFA5, 0xCFA6, 0xCFA7, 0xCFA9, 0xCFAA,
  0xCFAB, 0xCFAC, 0xCFAD, 0xCFAE, 0xCFAF,
  // [ 16018, 16036] -> [0xCFB1,0xCFC3] # seg 303
  // [ 16037, 16063] -> [0xCFC5,0xCFDF] # seg 304
  // [ 16064, 16089] -v # seg 305 at pos 11373
  0xCFE2, 0xCFE3, 0xCFE5, 0xCFE6, 0xCFE7, 0xCFE9, 0xCFEA, 0xCFEB,
  0xCFEC, 0xCFED, 0xCFEE, 0xCFEF, 0xCFF2, 0xCFF4, 0xCFF6, 0xCFF7,
  0xCFF8, 0xCFF9, 0xCFFA, 0xCFFB, 0xCFFD, 0xCFFE, 0xCFFF, 0xD001,
  0xD002, 0xD003,
  // [ 16090, 16101] -> [0xD005,0xD010] # seg 306
  // [ 16102, 16107] -> [0xD012,0xD017] # seg 307
  // [ 16108, 16127] -> [0xD019,0xD02C] # seg 308
  // [ 16128, 16166] -v # seg 309 at pos 11399
  0xD02E, 0xD02F, 0xD030, 0xD031, 0xD032, 0xD033, 0xD036, 0xD037,
  0xD039, 0xD03A, 0xD03B, 0xD03D, 0xD03E, 0xD03F, 0xD040, 0xD041,
  0xD042, 0xD043, 0xD046, 0xD048, 0xD04A, 0xD04B, 0xD04C, 0xD04D,
  0xD04E, 0xD04F, 0xD051, 0xD052, 0xD053, 0xD055, 0xD056, 0xD057,
  0xD059, 0xD05A, 0xD05B, 0xD05C, 0xD05D, 0xD05E, 0xD05F,
  // [ 16167, 16177] -> [0xD061,0xD06B] # seg 310
  // [ 16178, 16192] -v # seg 311 at pos 11438
  0xD06E, 0xD06F, 0xD071, 0xD072, 0xD073, 0xD075, 0xD076, 0xD077,
  0xD078, 0xD079, 0xD07A, 0xD07B, 0xD07E, 0xD07F, 0xD080,
  // [ 16193, 16226] -> [0xD082,0xD0A3] # seg 312
  // [ 16227, 16283] -v # seg 313 at pos 11453
  0xD0A6, 0xD0A7, 0xD0A9, 0xD0AA, 0xD0AB, 0xD0AD, 0xD0AE, 0xD0AF,
  0xD0B0, 0xD0B1, 0xD0B2, 0xD0B3, 0xD0B6, 0xD0B8, 0xD0BA, 0xD0BB,
  0xD0BC, 0xD0BD, 0xD0BE, 0xD0BF, 0xD0C2, 0xD0C3, 0xD0C5, 0xD0C6,
  0xD0C7, 0xD0CA, 0xD0CB, 0xD0CC, 0xD0CD, 0xD0CE, 0xD0CF, 0xD0D2,
  0xD0D6, 0xD0D7, 0xD0D8, 0xD0D9, 0xD0DA, 0xD0DB, 0xD0DE, 0xD0DF,
  0xD0E1, 0xD0E2, 0xD0E3, 0xD0E5, 0xD0E6, 0xD0E7, 0xD0E8, 0xD0E9,
  0xD0EA, 0xD0EB, 0xD0EE, 0xD0F2, 0xD0F3, 0xD0F4, 0xD0F5, 0xD0F6,
  0xD0F7,
  // [ 16284, 16303] -> [0xD0F9,0xD10C] # seg 314
  // [ 16304, 16337] -> [0xD10E,0xD12F] # seg 315
  // [ 16338, 16378] -v # seg 316 at pos 11510
  0xD132, 0xD133, 0xD135, 0xD136, 0xD137, 0xD139, 0xD13B, 0xD13C,
  0xD13D, 0xD13E, 0xD13F, 0xD142, 0xD146, 0xD147, 0xD148, 0xD149,
  0xD14A, 0xD14B, 0xD14E, 0xD14F, 0xD151, 0xD152, 0xD153, 0xD155,
  0xD156, 0xD157, 0xD158, 0xD159, 0xD15A, 0xD15B, 0xD15E, 0xD160,
  0xD162, 0xD163, 0xD164, 0xD165, 0xD166, 0xD167, 0xD169, 0xD16A,
  0xD16B,
  // [ 16379, 16393] -> [0xD16D,0xD17B] # seg 317
  // [ 16394, 16403] -v # seg 318 at pos 11551
  0xD17D, 0xD17E, 0xD17F, 0xD180, 0xD181, 0xD182, 0xD183, 0xD185,
  0xD186, 0xD187,
  // [ 16404, 16426] -> [0xD189,0xD19F] # seg 319
  // [ 16427, 16448] -v # seg 320 at pos 11561
  0xD1A2, 0xD1A3, 0xD1A5, 0xD1A6, 0xD1A7, 0xD1A9, 0xD1AA, 0xD1AB,
  0xD1AC, 0xD1AD, 0xD1AE, 0xD1AF, 0xD1B2, 0xD1B4, 0xD1B6, 0xD1B7,
  0xD1B8, 0xD1B9, 0xD1BB, 0xD1BD, 0xD1BE, 0xD1BF,
  // [ 16449, 16471] -> [0xD1C1,0xD1D7] # seg 321
  // [ 16472, 16498] -> [0xD1D9,0xD1F3] # seg 322
  // [ 16499, 16501] -> [0xD1F5,0xD1F7] # seg 323
  // [ 16502, 16515] -> [0xD1F9,0xD206] # seg 324
  // [ 16516, 16522] -v # seg 325 at pos 11583
  0xD208, 0xD20A, 0xD20B, 0xD20C, 0xD20D, 0xD20E, 0xD20F,
  // [ 16523, 16549] -> [0xD211,0xD22B] # seg 326
  // [ 16550, 16569] -v # seg 327 at pos 11590
  0xD22E, 0xD22F, 0xD231, 0xD232, 0xD233, 0xD235, 0xD236, 0xD237,
  0xD238, 0xD239, 0xD23A, 0xD23B, 0xD23E, 0xD240, 0xD242, 0xD243,
  0xD244, 0xD245, 0xD246, 0xD247,
  // [ 16570, 16588] -> [0xD249,0xD25B] # seg 328
  // [ 16589, 16595] -> [0xD25D,0xD263] # seg 329
  // [ 16596, 16622] -> [0xD265,0xD27F] # seg 330
  // [ 16623, 16698] -v # seg 331 at pos 11610
  0xD282, 0xD283, 0xD285, 0xD286, 0xD287, 0xD289, 0xD28A, 0xD28B,
  0xD28C, 0xD28D, 0xD28E, 0xD28F, 0xD292, 0xD293, 0xD294, 0xD296,
  0xD297, 0xD298, 0xD299, 0xD29A, 0xD29B, 0xD29D, 0xD29E, 0xD29F,
  0xD2A1, 0xD2A2, 0xD2A3, 0xD2A5, 0xD2A6, 0xD2A7, 0xD2A8, 0xD2A9,
  0xD2AA, 0xD2AB, 0xD2AD, 0xD2AE, 0xD2AF, 0xD2B0, 0xD2B2, 0xD2B3,
  0xD2B4, 0xD2B5, 0xD2B6, 0xD2B7, 0xD2BA, 0xD2BB, 0xD2BD, 0xD2BE,
  0xD2C1, 0xD2C3, 0xD2C4, 0xD2C5, 0xD2C6, 0xD2C7, 0xD2CA, 0xD2CC,
  0xD2CD, 0xD2CE, 0xD2CF, 0xD2D0, 0xD2D1, 0xD2D2, 0xD2D3, 0xD2D5,
  0xD2D6, 0xD2D7, 0xD2D9, 0xD2DA, 0xD2DB, 0xD2DD, 0xD2DE, 0xD2DF,
  0xD2E0, 0xD2E1, 0xD2E2, 0xD2E3,
  // [ 16699, 16708] -> [0xD2E6,0xD2EF] # seg 332
  // [ 16709, 16763] -v # seg 333 at pos 11686
  0xD2F2, 0xD2F3, 0xD2F5, 0xD2F6, 0xD2F7, 0xD2F9, 0xD2FA, 0xD2FB,
  0xD2FC, 0xD2FD, 0xD2FE, 0xD2FF, 0xD302, 0xD304, 0xD306, 0xD307,
  0xD308, 0xD309, 0xD30A, 0xD30B, 0xD30F, 0xD311, 0xD312, 0xD313,
  0xD315, 0xD317, 0xD318, 0xD319, 0xD31A, 0xD31B, 0xD31E, 0xD322,
  0xD323, 0xD324, 0xD326, 0xD327, 0xD32A, 0xD32B, 0xD32D, 0xD32E,
  0xD32F, 0xD331, 0xD332, 0xD333, 0xD334, 0xD335, 0xD336, 0xD337,
  0xD33A, 0xD33E, 0xD33F, 0xD340, 0xD341, 0xD342, 0xD343,
  // [ 16764, 16817] -> [0xD346,0xD37B] # seg 334
  // [ 16818, 16921] -v # seg 335 at pos 11741
  0xD37E, 0xD37F, 0xD381, 0xD382, 0xD383, 0xD385, 0xD386, 0xD387,
  0xD388, 0xD389, 0xD38A, 0xD38B, 0xD38E, 0xD392, 0xD393, 0xD394,
  0xD395, 0xD396, 0xD397, 0xD39A, 0xD39B, 0xD39D, 0xD39E, 0xD39F,
  0xD3A1, 0xD3A2, 0xD3A3, 0xD3A4, 0xD3A5, 0xD3A6, 0xD3A7, 0xD3AA,
  0xD3AC, 0xD3AE, 0xD3AF, 0xD3B0, 0xD3B1, 0xD3B2, 0xD3B3, 0xD3B5,
  0xD3B6, 0xD3B7, 0xD3B9, 0xD3BA, 0xD3BB, 0xD3BD, 0xD3BE, 0xD3BF,
  0xD3C0, 0xD3C1, 0xD3C2, 0xD3C3, 0xD3C6, 0xD3C7, 0xD3CA, 0xD3CB,
  0xD3CC, 0xD3CD, 0xD3CE, 0xD3CF, 0xD3D1, 0xD3D2, 0xD3D3, 0xD3D4,
  0xD3D5, 0xD3D6, 0xD3D7, 0xD3D9, 0xD3DA, 0xD3DB, 0xD3DC, 0xD3DD,
  0xD3DE, 0xD3DF, 0xD3E0, 0xD3E2, 0xD3E4, 0xD3E5, 0xD3E6, 0xD3E7,
  0xD3E8, 0xD3E9, 0xD3EA, 0xD3EB, 0xD3EE, 0xD3EF, 0xD3F1, 0xD3F2,
  0xD3F3, 0xD3F5, 0xD3F6, 0xD3F7, 0xD3F8, 0xD3F9, 0xD3FA, 0xD3FB,
  0xD3FE, 0xD400, 0xD402, 0xD403, 0xD404, 0xD405, 0xD406, 0xD407,
  // [ 16922, 16941] -> [0xD409,0xD41C] # seg 336
  // [ 16942, 16975] -> [0xD41E,0xD43F] # seg 337
  // [ 16976, 16978] -> [0xD441,0xD443] # seg 338
  // [ 16979, 17001] -> [0xD445,0xD45B] # seg 339
  // [ 17002, 17042] -v # seg 340 at pos 11845
  0xD45D, 0xD45E, 0xD45F, 0xD461, 0xD462, 0xD463, 0xD465, 0xD466,
  0xD467, 0xD468, 0xD469, 0xD46A, 0xD46B, 0xD46C, 0xD46E, 0xD470,
  0xD471, 0xD472, 0xD473, 0xD474, 0xD475, 0xD476, 0xD477, 0xD47A,
  0xD47B, 0xD47D, 0xD47E, 0xD481, 0xD483, 0xD484, 0xD485, 0xD486,
  0xD487, 0xD48A, 0xD48C, 0xD48E, 0xD48F, 0xD490, 0xD491, 0xD492,
  0xD493,
  // [ 17043, 17062] -> [0xD495,0xD4A8] # seg 341
  // [ 17063, 17096] -> [0xD4AA,0xD4CB] # seg 342
  // [ 17097, 17155] -v # seg 343 at pos 11886
  0xD4CD, 0xD4CE, 0xD4CF, 0xD4D1, 0xD4D2, 0xD4D3, 0xD4D5, 0xD4D6,
  0xD4D7, 0xD4D8, 0xD4D9, 0xD4DA, 0xD4DB, 0xD4DD, 0xD4DE, 0xD4E0,
  0xD4E1, 0xD4E2, 0xD4E3, 0xD4E4, 0xD4E5, 0xD4E6, 0xD4E7, 0xD4E9,
  0xD4EA, 0xD4EB, 0xD4ED, 0xD4EE, 0xD4EF, 0xD4F1, 0xD4F2, 0xD4F3,
  0xD4F4, 0xD4F5, 0xD4F6, 0xD4F7, 0xD4F9, 0xD4FA, 0xD4FC, 0xD4FE,
  0xD4FF, 0xD500, 0xD501, 0xD502, 0xD503, 0xD505, 0xD506, 0xD507,
  0xD509, 0xD50A, 0xD50B, 0xD50D, 0xD50E, 0xD50F, 0xD510, 0xD511,
  0xD512, 0xD513, 0xD516,
  // [ 17156, 17191] -> [0xD518,0xD53B] # seg 344
  // [ 17192, 17249] -v # seg 345 at pos 11945
  0xD53E, 0xD53F, 0xD541, 0xD542, 0xD543, 0xD545, 0xD546, 0xD547,
  0xD548, 0xD549, 0xD54A, 0xD54B, 0xD54E, 0xD550, 0xD552, 0xD553,
  0xD554, 0xD555, 0xD556, 0xD557, 0xD55A, 0xD55B, 0xD55D, 0xD55E,
  0xD55F, 0xD561, 0xD562, 0xD563, 0xD564, 0xD566, 0xD567, 0xD56A,
  0xD56C, 0xD56E, 0xD56F, 0xD570, 0xD571, 0xD572, 0xD573, 0xD576,
  0xD577, 0xD579, 0xD57A, 0xD57B, 0xD57D, 0xD57E, 0xD57F, 0xD580,
  0xD581, 0xD582, 0xD583, 0xD586, 0xD58A, 0xD58B, 0xD58C, 0xD58D,
  0xD58E, 0xD58F,
  // [ 17250, 17269] -> [0xD591,0xD5A4] # seg 346
  // [ 17270, 17303] -> [0xD5A6,0xD5C7] # seg 347
  // [ 17304, 17375] -v # seg 348 at pos 12003
  0xD5CA, 0xD5CB, 0xD5CD, 0xD5CE, 0xD5CF, 0xD5D1, 0xD5D3, 0xD5D4,
  0xD5D5, 0xD5D6, 0xD5D7, 0xD5DA, 0xD5DC, 0xD5DE, 0xD5DF, 0xD5E0,
  0xD5E1, 0xD5E2, 0xD5E3, 0xD5E6, 0xD5E7, 0xD5E9, 0xD5EA, 0xD5EB,
  0xD5ED, 0xD5EE, 0xD5EF, 0xD5F0, 0xD5F1, 0xD5F2, 0xD5F3, 0xD5F6,
  0xD5F8, 0xD5FA, 0xD5FB, 0xD5FC, 0xD5FD, 0xD5FE, 0xD5FF, 0xD602,
  0xD603, 0xD605, 0xD606, 0xD607, 0xD609, 0xD60A, 0xD60B, 0xD60C,
  0xD60D, 0xD60E, 0xD60F, 0xD612, 0xD616, 0xD617, 0xD618, 0xD619,
  0xD61A, 0xD61B, 0xD61D, 0xD61E, 0xD61F, 0xD621, 0xD622, 0xD623,
  0xD625, 0xD626, 0xD627, 0xD628, 0xD629, 0xD62A, 0xD62B, 0xD62C,
  // [ 17376, 17385] -> [0xD62E,0xD637] # seg 349
  // [ 17386, 17408] -v # seg 350 at pos 12075
  0xD63A, 0xD63B, 0xD63D, 0xD63E, 0xD63F, 0xD641, 0xD642, 0xD643,
  0xD644, 0xD646, 0xD647, 0xD64A, 0xD64C, 0xD64E, 0xD64F, 0xD650,
  0xD652, 0xD653, 0xD656, 0xD657, 0xD659, 0xD65A, 0xD65B,
  // [ 17409, 17418] -> [0xD65D,0xD666] # seg 351
  // [ 17419, 17427] -v # seg 352 at pos 12098
  0xD668, 0xD66A, 0xD66B, 0xD66C, 0xD66D, 0xD66E, 0xD66F, 0xD672,
  0xD673,
  // [ 17428, 17441] -> [0xD675,0xD682] # seg 353
  // [ 17442, 17540] -v # seg 354 at pos 12107
  0xD684, 0xD686, 0xD687, 0xD688, 0xD689, 0xD68A, 0xD68B, 0xD68E,
  0xD68F, 0xD691, 0xD692, 0xD693, 0xD695, 0xD696, 0xD697, 0xD698,
  0xD699, 0xD69A, 0xD69B, 0xD69C, 0xD69E, 0xD6A0, 0xD6A2, 0xD6A3,
  0xD6A4, 0xD6A5, 0xD6A6, 0xD6A7, 0xD6A9, 0xD6AA, 0xD6AB, 0xD6AD,
  0xD6AE, 0xD6AF, 0xD6B1, 0xD6B2, 0xD6B3, 0xD6B4, 0xD6B5, 0xD6B6,
  0xD6B7, 0xD6B8, 0xD6BA, 0xD6BC, 0xD6BD, 0xD6BE, 0xD6BF, 0xD6C0,
  0xD6C1, 0xD6C2, 0xD6C3, 0xD6C6, 0xD6C7, 0xD6C9, 0xD6CA, 0xD6CB,
  0xD6CD, 0xD6CE, 0xD6CF, 0xD6D0, 0xD6D2, 0xD6D3, 0xD6D5, 0xD6D6,
  0xD6D8, 0xD6DA, 0xD6DB, 0xD6DC, 0xD6DD, 0xD6DE, 0xD6DF, 0xD6E1,
  0xD6E2, 0xD6E3, 0xD6E5, 0xD6E6, 0xD6E7, 0xD6E9, 0xD6EA, 0xD6EB,
  0xD6EC, 0xD6ED, 0xD6EE, 0xD6EF, 0xD6F1, 0xD6F2, 0xD6F3, 0xD6F4,
  0xD6F6, 0xD6F7, 0xD6F8, 0xD6F9, 0xD6FA, 0xD6FB, 0xD6FE, 0xD6FF,
  0xD701, 0xD702, 0xD703,
  // [ 17541, 17552] -> [0xD705,0xD710] # seg 355
  // [ 17553, 17657] -v # seg 356 at pos 12206
  0xD712, 0xD713, 0xD714, 0xD715, 0xD716, 0xD717, 0xD71A, 0xD71B,
  0xD71D, 0xD71E, 0xD71F, 0xD721, 0xD722, 0xD723, 0xD724, 0xD725,
  0xD726, 0xD727, 0xD72A, 0xD72C, 0xD72E, 0xD72F, 0xD730, 0xD731,
  0xD732, 0xD733, 0xD736, 0xD737, 0xD739, 0xD73A, 0xD73B, 0xD73D,
  0xD73E, 0xD73F, 0xD740, 0xD741, 0xD742, 0xD743, 0xD745, 0xD746,
  0xD748, 0xD74A, 0xD74B, 0xD74C, 0xD74D, 0xD74E, 0xD74F, 0xD752,
  0xD753, 0xD755, 0xD75A, 0xD75B, 0xD75C, 0xD75D, 0xD75E, 0xD75F,
  0xD762, 0xD764, 0xD766, 0xD767, 0xD768, 0xD76A, 0xD76B, 0xD76D,
  0xD76E, 0xD76F, 0xD771, 0xD772, 0xD773, 0xD775, 0xD776, 0xD777,
  0xD778, 0xD779, 0xD77A, 0xD77B, 0xD77E, 0xD77F, 0xD780, 0xD782,
  0xD783, 0xD784, 0xD785, 0xD786, 0xD787, 0xD78A, 0xD78B, 0xD78D,
  0xD78E, 0xD78F, 0xD791, 0xD792, 0xD793, 0xD794, 0xD795, 0xD796,
  0xD797, 0xD79A, 0xD79C, 0xD79E, 0xD79F, 0xD7A0, 0xD7A1, 0xD7A2,
  0xD7A3,
};

// Reverse
const unsigned short CodePageKSX1001_R[27595] = {
  // hot segments (indexes into segment table)
  2, 109, 1486,
  // number of segments
  1499,
  // segment table
  0x0000, 0x00A1, 0x00C7, 0x00D0, 0x00E7, 0x00F0, 0x00FF, 0x0111,
  0x0112, 0x0126, 0x0128, 0x0131, 0x0154, 0x0166, 0x0168, 0x02C7,
  0x02C8, 0x02D0, 0x02D1, 0x02D8, 0x02DE, 0x0391, 0x03A2, 0x03A3,
  0x03AA, 0x03B1, 0x03C2, 0x03C3, 0x03CA, 0x0401, 0x0402, 0x0410,
  0x0416, 0x0430, 0x0436, 0x0450, 0x0451, 0x0452, 0x2013, 0x2027,
  0x2030, 0x2034, 0x203B, 0x203C, 0x2074, 0x2075, 0x207F, 0x2085,
  0x20AC, 0x20AD, 0x2103, 0x210A, 0x2113, 0x2117, 0x2121, 0x212C,
  0x2153, 0x2160, 0x216A, 0x2170, 0x217A, 0x2190, 0x219A, 0x21D2,
  0x21D5, 0x2200, 0x2212, 0x221A, 0x223E, 0x2252, 0x2253, 0x2260,
  0x226C, 0x2282, 0x2288, 0x2299, 0x229A, 0x22A5, 0x22A6, 0x2312,
  0x2313, 0x2460, 0x246F, 0x2474, 0x2483, 0x249C, 0x24B6, 0x24D0,
  0x24EA, 0x2500, 0x2504, 0x250C, 0x254C, 0x2592, 0x2593, 0x25A0,
  0x25AA, 0x25B2, 0x25D2, 0x2605, 0x2607, 0x260E, 0x2610, 0x261C,
  0x261F, 0x2640, 0x2643, 0x2660, 0x266E, 0x3000, 0x3020, 0x3041,
  0x3094, 0x30A1, 0x30F7, 0x30FB, 0x30FC, 0x3131, 0x318F, 0x3200,
  0x321C, 0x321D, 0x3260, 0x327C, 0x327F, 0x3280, 0x3380, 0x3399,
  0x33A3, 0x33B0, 0x33BA, 0x33DE, 0x4E00, 0x4E1F, 0x4E2D, 0x4E60,
  0x4E6B, 0x4EAF, 0x4EB6, 0x4EE6, 0x4EF0, 0x4F02, 0x4F09, 0x4F12,
  0x4F2F, 0x4F5D, 0x4F69, 0x4F9E, 0x4FAE, 0x4FB7, 0x4FBF, 0x4FE2,
  0x4FEE, 0x4FFB, 0x5002, 0x502E, 0x503B, 0x503C, 0x5043, 0x505D,
  0x5065, 0x5066, 0x5074, 0x5079, 0x5080, 0x5086, 0x508D, 0x509A,
  0x50AC, 0x50EE, 0x50F9, 0x510A, 0x5112, 0x5113, 0x511F, 0x5122,
  0x512A, 0x512B, 0x5132, 0x5153, 0x515C, 0x5198, 0x51A0, 0x51AD,
  0x51B6, 0x51CE, 0x51DC, 0x51E2, 0x51F0, 0x523C, 0x5243, 0x5262,
  0x5269, 0x5276, 0x527D, 0x5293, 0x529B, 0x52AC, 0x52BE, 0x52E5,
  0x52F3, 0x5330, 0x5339, 0x5385, 0x5393, 0x53AE, 0x53BB, 0x53BC,
  0x53C3, 0x53F9, 0x5403, 0x5412, 0x541B, 0x542C, 0x5433, 0x5452,
  0x5468, 0x5491, 0x54A4, 0x54CA, 0x54E1, 0x54F3, 0x54FA, 0x54FB,
  0x5504, 0x5511, 0x551C, 0x551D, 0x552F, 0x5536, 0x553E, 0x5547,
  0x554F, 0x5557, 0x555E, 0x5564, 0x557C, 0x558B, 0x5598, 0x559E,
  0x55A7, 0x55AF, 0x55C5, 0x55C8, 0x55D4, 0x55E5, 0x55FD, 0x55FF,
  0x5606, 0x560A, 0x5614, 0x5618, 0x562F, 0x5637, 0x5653, 0x5654,
  0x5668, 0x566C, 0x5674, 0x5675, 0x5686, 0x5687, 0x56A5, 0x56B5,
  0x56BC, 0x56BD, 0x56CA, 0x56D2, 0x56DA, 0x56E1, 0x56F0, 0x56F1,
  0x56F9, 0x56FB, 0x5703, 0x5720, 0x5728, 0x5731, 0x573B, 0x5752,
  0x5761, 0x578C, 0x5793, 0x5794, 0x57A0, 0x57A4, 0x57C3, 0x57CF,
  0x57DF, 0x57E1, 0x57F0, 0x580B, 0x581E, 0x583B, 0x584A, 0x5865,
  0x5875, 0x588A, 0x5893, 0x5894, 0x589C, 0x58A0, 0x58A8, 0x58F0,
  0x58F9, 0x58FE, 0x590F, 0x598B, 0x5993, 0x599A, 0x59A5, 0x59AD,
  0x59B9, 0x59DE, 0x59E6, 0x59EF, 0x59F8, 0x5A04, 0x5A11, 0x5A2A,
  0x5A36, 0x5A4A, 0x5A5A, 0x5A5B, 0x5A62, 0x5A67, 0x5A92, 0x5A93,
  0x5A9A, 0x5A9C, 0x5AA4, 0x5AA5, 0x5AC1, 0x5ACD, 0x5AE1, 0x5AEA,
  0x5B05, 0x5B0D, 0x5B16, 0x5B17, 0x5B2A, 0x5B2B, 0x5B40, 0x5B44,
  0x5B50, 0x5B7D, 0x5B85, 0x5C1A, 0x5C24, 0x5C29, 0x5C31, 0x5C72,
  0x5C79, 0x5C7A, 0x5C90, 0x5C92, 0x5CA1, 0x5CA2, 0x5CA9, 0x5CC1,
  0x5CD9, 0x5CE1, 0x5CE8, 0x5CFE, 0x5D07, 0x5D1A, 0x5D27, 0x5D2A,
  0x5D4B, 0x5D51, 0x5D69, 0x5D70, 0x5D87, 0x5D8C, 0x5D9D, 0x5DA3,
  0x5DAA, 0x5DAB, 0x5DB8, 0x5DBE, 0x5DCD, 0x5E1E, 0x5E25, 0x5E4D,
  0x5E55, 0x5E56, 0x5E5F, 0x5E64, 0x5E72, 0x5EAE, 0x5EB5, 0x5EE4,
  0x5EEC, 0x5F2A, 0x5F31, 0x5F3D, 0x5F48, 0x5F4F, 0x5F56, 0x5FCE,
  0x5FD6, 0x5FE1, 0x5FEB, 0x5FEC, 0x5FF5, 0x5FF6, 0x5FFD, 0x6000,
  0x600F, 0x6030, 0x6041, 0x6044, 0x604D, 0x6071, 0x6085, 0x60A8,
  0x60B0, 0x60BE, 0x60C5, 0x60C8, 0x60D1, 0x60D2, 0x60DA, 0x60E2,
  0x60F0, 0x6120, 0x6127, 0x6128, 0x6130, 0x6183, 0x618A, 0x619B,
  0x61A4, 0x61CC, 0x61E6, 0x61E7, 0x61F2, 0x6222, 0x622A, 0x6237,
  0x623E, 0x6259, 0x626E, 0x629C, 0x62AB, 0x62DD, 0x62EC, 0x630A,
  0x6311, 0x6312, 0x632B, 0x6330, 0x633A, 0x633F, 0x6349, 0x6356,
  0x6367, 0x63AB, 0x63C0, 0x63C7, 0x63CF, 0x63E2, 0x63ED, 0x63F8,
  0x640D, 0x6423, 0x642C, 0x642E, 0x643A, 0x643F, 0x6458, 0x6459,
  0x6460, 0x6461, 0x6469, 0x6470, 0x6478, 0x647B, 0x6488, 0x6489,
  0x6491, 0x64B3, 0x64BB, 0x6505, 0x6518, 0x65D8, 0x65E0, 0x6616,
  0x661E, 0x6650, 0x6659, 0x667B, 0x6684, 0x66A3, 0x66AB, 0x66CA,
  0x66D6, 0x66E7, 0x66F0, 0x673E, 0x6746, 0x6760, 0x676D, 0x6780,
  0x6787, 0x679E, 0x67AF, 0x67C5, 0x67CF, 0x67DE, 0x67E9, 0x67FF,
  0x6812, 0x6818, 0x6821, 0x6823, 0x682A, 0x6830, 0x6838, 0x6855,
  0x686D, 0x686E, 0x6876, 0x6877, 0x687F, 0x6886, 0x688F, 0x68B7,
  0x68C4, 0x6906, 0x690D, 0x6913, 0x6927, 0x6928, 0x6930, 0x6931,
  0x693D, 0x6940, 0x694A, 0x694B, 0x6953, 0x697A, 0x6995, 0x699D,
  0x69A5, 0x69C4, 0x69CB, 0x69D1, 0x69E8, 0x69EB, 0x69FB, 0x6A03,
  0x6A0A, 0x6A24, 0x6A35, 0x6A62, 0x6A6B, 0x6A6C, 0x6A80, 0x6A8F,
  0x6A97, 0x6AA4, 0x6AB3, 0x6AB4, 0x6ABB, 0x6AC4, 0x6AD3, 0x6ADC,
  0x6AF6, 0x6AFC, 0x6B04, 0x6B17, 0x6B20, 0x6B24, 0x6B32, 0x6B33,
  0x6B3A, 0x6B3F, 0x6B46, 0x6B51, 0x6B5F, 0x6B6B, 0x6B72, 0x6B8B,
  0x6B96, 0x6B9F, 0x6BAE, 0x6BDC, 0x6BEB, 0x6BED, 0x6C08, 0x6C14,
  0x6C23, 0x6C24, 0x6C34, 0x6C43, 0x6C4E, 0x6C61, 0x6C68, 0x6C9C,
  0x6CAB, 0x6CF4, 0x6D0B, 0x6D2B, 0x6D32, 0x6D42, 0x6D59, 0x6D96,
  0x6DAF, 0x6DB6, 0x6DC0, 0x6DFC, 0x6E17, 0x6E4E, 0x6E56, 0x6E60,
  0x6E67, 0x6E7B, 0x6E90, 0x6EBB, 0x6EC2, 0x6ED5, 0x6EEF, 0x6F07,
  0x6F0F, 0x6F16, 0x6F20, 0x6F24, 0x6F2B, 0x6F42, 0x6F51, 0x6F65,
  0x6F6D, 0x6F71, 0x6F7A, 0x6F98, 0x6FA3, 0x6FCB, 0x6FD5, 0x6FF2,
  0x6FFE, 0x7030, 0x7037, 0x703F, 0x704C, 0x7064, 0x706B, 0x7071,
  0x7078, 0x707E, 0x7085, 0x70BA, 0x70C8, 0x70D0, 0x70D8, 0x70E0,
  0x70F1, 0x70F2, 0x70F9, 0x710D, 0x7119, 0x7127, 0x7130, 0x7137,
  0x7147, 0x716F, 0x717D, 0x71A3, 0x71AC, 0x71B2, 0x71B9, 0x71D6,
  0x71DF, 0x71EF, 0x71FB, 0x7207, 0x7210, 0x7211, 0x721B, 0x721C,
  0x722A, 0x726A, 0x7272, 0x7282, 0x72A2, 0x72B0, 0x72C0, 0x72C5,
  0x72CE, 0x72DA, 0x72E1, 0x72E2, 0x72E9, 0x72EA, 0x72F8, 0x72FE,
  0x730A, 0x730B, 0x7316, 0x731E, 0x7325, 0x732C, 0x7336, 0x7346,
  0x7350, 0x7358, 0x7368, 0x737C, 0x7384, 0x73A0, 0x73A7, 0x73EE,
  0x73F7, 0x740A, 0x7413, 0x7414, 0x741B, 0x744C, 0x7455, 0x7470,
  0x747E, 0x748C, 0x7498, 0x74E7, 0x74EE, 0x74EF, 0x74F7, 0x74F8,
  0x7501, 0x7505, 0x7511, 0x753B, 0x7547, 0x7592, 0x759D, 0x759E,
  0x75A5, 0x75E3, 0x75F0, 0x7601, 0x760D, 0x760E, 0x7619, 0x7627,
  0x763B, 0x7643, 0x764C, 0x7657, 0x7661, 0x7694, 0x76AE, 0x76AF,
  0x76BA, 0x76CB, 0x76D2, 0x770C, 0x771E, 0x7721, 0x7729, 0x772A,
  0x7737, 0x7741, 0x774D, 0x774E, 0x775B, 0x776C, 0x7779, 0x7780,
  0x778B, 0x7792, 0x779E, 0x77B4, 0x77BB, 0x77C0, 0x77D7, 0x77F4,
  0x7802, 0x7803, 0x7812, 0x7813, 0x7825, 0x7835, 0x7845, 0x7846,
  0x784F, 0x7850, 0x785D, 0x785E, 0x786B, 0x7870, 0x787C, 0x7898,
  0x78A3, 0x78AA, 0x78BA, 0x78D1, 0x78E8, 0x7902, 0x790E, 0x790F,
  0x7916, 0x7917, 0x792A, 0x792D, 0x793A, 0x796E, 0x797A, 0x7982,
  0x798D, 0x7992, 0x79A6, 0x79C2, 0x79C9, 0x79EA, 0x79FB, 0x7A21,
  0x7A2E, 0x7A4F, 0x7A57, 0x7A58, 0x7A61, 0x7A89, 0x7A92, 0x7AA0,
  0x7AA9, 0x7AB0, 0x7ABA, 0x7ABB, 0x7AC4, 0x7ACC, 0x7AD7, 0x7B00,
  0x7B0F, 0x7B12, 0x7B19, 0x7B2E, 0x7B39, 0x7B3A, 0x7B46, 0x7B57,
  0x7B60, 0x7B61, 0x7B6C, 0x7B76, 0x7B7D, 0x7B7E, 0x7B87, 0x7BA2,
  0x7BAD, 0x7BB9, 0x7BC0, 0x7BCA, 0x7BD2, 0x7BD3, 0x7BE0, 0x7BEA,
  0x7C07, 0x7C08, 0x7C12, 0x7C13, 0x7C1E, 0x7C2C, 0x7C3D, 0x7C44,
  0x7C4C, 0x7C4E, 0x7C60, 0x7C65, 0x7C6C, 0x7C74, 0x7C83, 0x7C8A,
  0x7C92, 0x7CBF, 0x7CCA, 0x7CCB, 0x7CD6, 0x7CD7, 0x7CDE, 0x7CE8,
  0x7CFB, 0x7D23, 0x7D2B, 0x7D3B, 0x7D42, 0x7D47, 0x7D50, 0x7D51,
  0x7D5E, 0x7D80, 0x7D8E, 0x7D94, 0x7D9C, 0x7DA3, 0x7DAC, 0x7DC0,
  0x7DC7, 0x7DCC, 0x7DD6, 0x7DFC, 0x7E09, 0x7E0B, 0x7E15, 0x7E24,
  0x7E2B, 0x7E48, 0x7E52, 0x7E56, 0x7E5E, 0x7E62, 0x7E69, 0x7E71,
  0x7E79, 0x7E83, 0x7E8C, 0x7E9D, 0x7F36, 0x7F3B, 0x7F4C, 0x7F56,
  0x7F6A, 0x7F7A, 0x7F85, 0x7FAA, 0x7FB2, 0x7FD6, 0x7FDF, 0x7FE2,
  0x7FE9, 0x7FF1, 0x7FF9, 0x8019, 0x802D, 0x804B, 0x8056, 0x805F,
  0x806F, 0x808D, 0x8096, 0x80BB, 0x80C3, 0x80C5, 0x80CC, 0x80CF,
  0x80DA, 0x80E6, 0x80F1, 0x810B, 0x8118, 0x811C, 0x8123, 0x8130,
  0x8139, 0x813F, 0x814B, 0x8156, 0x8165, 0x8181, 0x8188, 0x8190,
  0x819A, 0x81A9, 0x81B3, 0x81CE, 0x81D8, 0x8213, 0x821B, 0x8222,
  0x822A, 0x822D, 0x8235, 0x8248, 0x8259, 0x825A, 0x8264, 0x8267,
  0x826E, 0x827F, 0x828B, 0x82C0, 0x82D1, 0x82E8, 0x82F1, 0x82F2,
  0x82FD, 0x830A, 0x8317, 0x8318, 0x8328, 0x8353, 0x8373, 0x837C,
  0x8389, 0x838F, 0x8396, 0x83AC, 0x83BD, 0x83DD, 0x83E9, 0x840F,
  0x8429, 0x843E, 0x8449, 0x844A, 0x8457, 0x847B, 0x8490, 0x84A2,
  0x84B2, 0x84D2, 0x84DA, 0x84DB, 0x84EC, 0x84F5, 0x84FC, 0x84FD,
  0x8511, 0x8530, 0x853D, 0x855A, 0x8563, 0x856E, 0x8584, 0x8588,
  0x858F, 0x859C, 0x85A6, 0x85B1, 0x85BA, 0x85C2, 0x85C9, 0x85EB,
  0x85F7, 0x860B, 0x8616, 0x861B, 0x862D, 0x862E, 0x863F, 0x8640,
  0x864E, 0x8660, 0x8667, 0x8668, 0x8679, 0x867A, 0x868A, 0x8694,
  0x86A3, 0x86AA, 0x86C7, 0x86CC, 0x86D4, 0x86E5, 0x86ED, 0x86EE,
  0x86FE, 0x8709, 0x8718, 0x871D, 0x874E, 0x8758, 0x875F, 0x8769,
  0x8774, 0x8779, 0x8782, 0x8783, 0x878D, 0x878E, 0x879F, 0x87A3,
  0x87B3, 0x87BB, 0x87C4, 0x87C5, 0x87E0, 0x87E1, 0x87EC, 0x8806,
  0x881F, 0x8824, 0x8831, 0x889F, 0x88AB, 0x88AC, 0x88B4, 0x88B5,
  0x88C1, 0x88C3, 0x88CF, 0x88E9, 0x88F3, 0x88FE, 0x8907, 0x8908,
  0x8910, 0x891A, 0x8925, 0x892B, 0x8936, 0x8945, 0x895F, 0x896B,
  0x8972, 0x8973, 0x897F, 0x8997, 0x89A1, 0x89A2, 0x89A9, 0x89AB,
  0x89B2, 0x89B3, 0x89BA, 0x89C1, 0x89D2, 0x89D3, 0x89E3, 0x89E4,
  0x89F4, 0x89F9, 0x8A00, 0x8A3C, 0x8A50, 0x8A7A, 0x8A85, 0x8B05,
  0x8B0E, 0x8B21, 0x8B28, 0x8B3A, 0x8B41, 0x8B42, 0x8B49, 0x8B50,
  0x8B58, 0x8B5D, 0x8B66, 0x8B81, 0x8B8A, 0x8B9B, 0x8C37, 0x8C38,
  0x8C3F, 0x8C4D, 0x8C55, 0x8C62, 0x8C6A, 0x8C6C, 0x8C79, 0x8C7B,
  0x8C82, 0x8C83, 0x8C8A, 0x8C8D, 0x8C9D, 0x8D17, 0x8D64, 0x8D78,
  0x8D85, 0x8D8B, 0x8D99, 0x8D9A, 0x8DA3, 0x8DA9, 0x8DB3, 0x8DBF,
  0x8DC6, 0x8DD0, 0x8DDB, 0x8DF4, 0x8E0A, 0x8E11, 0x8E1E, 0x8E1F,
  0x8E2A, 0x8E36, 0x8E42, 0x8E4B, 0x8E59, 0x8E61, 0x8E74, 0x8E77,
  0x8E81, 0x8E8E, 0x8EAA, 0x8EAD, 0x8EC0, 0x8EC1, 0x8ECA, 0x8ED3,
  0x8EDF, 0x8EE0, 0x8EEB, 0x8EEC, 0x8EF8, 0x8F0A, 0x8F12, 0x8F4F,
  0x8F5D, 0x8F63, 0x8F9B, 0x8FB3, 0x8FC2, 0x8FC6, 0x8FCE, 0x8FD5,
  0x8FE6, 0x9024, 0x902E, 0x909A, 0x90A2, 0x90B9, 0x90C1, 0x90C2,
  0x90CA, 0x90CB, 0x90DE, 0x90EE, 0x90F5, 0x90F6, 0x90FD, 0x9103,
  0x9112, 0x911A, 0x9127, 0x9133, 0x9149, 0x9153, 0x9162, 0x916D,
  0x9175, 0x9179, 0x9187, 0x9193, 0x919C, 0x919D, 0x91AB, 0x91B6,
  0x91C0, 0x91EB, 0x91F5, 0x91F6, 0x920D, 0x921F, 0x9234, 0x924A,
  0x9257, 0x9267, 0x9280, 0x9286, 0x9291, 0x929D, 0x92B3, 0x92BA,
  0x92CC, 0x92D3, 0x92E4, 0x92EB, 0x92F8, 0x92FD, 0x9304, 0x9305,
  0x9310, 0x9311, 0x9318, 0x9330, 0x9348, 0x935C, 0x936E, 0x937F,
  0x938C, 0x938D, 0x9394, 0x939B, 0x93A3, 0x93B1, 0x93C3, 0x93C4,
  0x93D1, 0x93D2, 0x93DE, 0x93E5, 0x93F6, 0x93F7, 0x9404, 0x9405,
  0x9418, 0x9419, 0x9425, 0x942C, 0x9435, 0x9439, 0x9444, 0x9445,
  0x9451, 0x9453, 0x945B, 0x945C, 0x947D, 0x9480, 0x9577, 0x9578,
  0x9580, 0x9599, 0x95A3, 0x95B2, 0x95BB, 0x95BD, 0x95C7, 0x95CB,
  0x95D4, 0x95E3, 0x961C, 0x9622, 0x962A, 0x9633, 0x963B, 0x9651,
  0x965B, 0x967E, 0x9685, 0x9708, 0x9711, 0x971F, 0x9727, 0x9728,
  0x9730, 0x9749, 0x9751, 0x977B, 0x978B, 0x9790, 0x97A0, 0x97A1,
  0x97A8, 0x97AE, 0x97C6, 0x97CC, 0x97D3, 0x97D4, 0x97DC, 0x97DD,
  0x97F3, 0x9819, 0x982D, 0x9831, 0x9838, 0x983C, 0x9846, 0x9870,
  0x98A8, 0x98B2, 0x98C4, 0x98C8, 0x98DB, 0x98E3, 0x98ED, 0x98F5,
  0x98FC, 0x9921, 0x9928, 0x9929, 0x9945, 0x9958, 0x9996, 0x999E,
  0x99A5, 0x99BA, 0x99C1, 0x99C2, 0x99D0, 0x99E0, 0x99ED, 0x99F2,
  0x99FF, 0x9A10, 0x9A19, 0x9A1A, 0x9A2B, 0x9A38, 0x9A40, 0x9A46,
  0x9A4D, 0x9A4E, 0x9A55, 0x9A6B, 0x9AA8, 0x9AA9, 0x9AB8, 0x9AB9,
  0x9AD3, 0x9AD9, 0x9AE5, 0x9AE6, 0x9AEE, 0x9AEF, 0x9B1A, 0x9B1B,
  0x9B27, 0x9B32, 0x9B3C, 0x9B46, 0x9B4F, 0x9B5B, 0x9B6F, 0x9B70,
  0x9B8E, 0x9B92, 0x9B9F, 0x9BA0, 0x9BAB, 0x9BAF, 0x9BC9, 0x9BCA,
  0x9BD6, 0x9BD7, 0x9BE4, 0x9BE9, 0x9C0D, 0x9C16, 0x9C25, 0x9C26,
  0x9C32, 0x9C33, 0x9C3B, 0x9C3C, 0x9C47, 0x9C4A, 0x9C57, 0x9C58,
  0x9CE5, 0x9CEA, 0x9CF3, 0x9CF7, 0x9D09, 0x9D0A, 0x9D1B, 0x9D1C,
  0x9D26, 0x9D29, 0x9D3B, 0x9D3C, 0x9D51, 0x9D52, 0x9D5D, 0x9D62,
  0x9D6C, 0x9D73, 0x9DA9, 0x9DB5, 0x9DC4, 0x9DC5, 0x9DD7, 0x9DD8,
  0x9DF2, 0x9DFB, 0x9E1A, 0x9E1F, 0x9E75, 0x9E80, 0x9E92, 0x9EA6,
  0x9EB4, 0x9EC4, 0x9ECD, 0x9EDF, 0x9EE8, 0x9EE9, 0x9EF4, 0x9EF5,
  0x9F07, 0x9F14, 0x9F20, 0x9F21, 0x9F3B, 0x9F3C, 0x9F4A, 0x9F53,
  0x9F5F, 0x9F6D, 0x9F77, 0x9F78, 0x9F8D, 0x9F9D, 0xAC00, 0xD7A4,
  0xF900, 0xF939, 0xF944, 0xFA0C, 0xFF01, 0xFF3C, 0xFF3D, 0xFF5E,
  0xFF5F, 0xFFE0, 0xFFE7,
  // compressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    753,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    100,
   RCHAR,    109,  RCHAR,  RCHAR,  RCHAR,    408,  RCHAR,    425,
   RCHAR,    440,  RCHAR,    457,  RCHAR,   1040,  RCHAR,   1034,
    1041,   1082,   1089,  RCHAR,   1088,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,     55,  RCHAR,    840,  RCHAR,  RCHAR,  RCHAR,
     163,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    391,  RCHAR,    376,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,     53,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,    126,  RCHAR,     48,  RCHAR,     49,
   RCHAR,    728,  RCHAR,    822,  RCHAR,    796,  RCHAR,    702,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    131,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    846,
   RCHAR,    940,  RCHAR,      3,  RCHAR,    282,  RCHAR,    768,
     156,  RCHAR,    674,  RCHAR,    155,  RCHAR,  RCHAR,    574,
   RCHAR,    594,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6397,  RCHAR,  RCHAR,  RCHAR,
    4024,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6928,  RCHAR,  RCHAR,  RCHAR,
    6815,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4006,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8229,  RCHAR,
   RCHAR,  RCHAR,   5206,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8403,  RCHAR,
   RCHAR,  RCHAR,   5675,  RCHAR,   8640,  RCHAR,  RCHAR,  RCHAR,
    7179,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4196,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8372,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5318,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8529,  RCHAR,  RCHAR,  RCHAR,   5227,  RCHAR,
   RCHAR,  RCHAR,   6227,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8215,  RCHAR,   5747,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8710,  RCHAR,  RCHAR,  RCHAR,   3957,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6476,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5182,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8054,  RCHAR,   4628,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8526,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4284,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4566,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4790,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7292,  RCHAR,
    7931,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5027,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7658,  RCHAR,   8133,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5270,  RCHAR,   6402,  RCHAR,
   RCHAR,  RCHAR,   6428,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8637,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5750,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6783,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4519,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4103,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5032,  RCHAR,   4907,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4303,  RCHAR,   6122,  RCHAR,  RCHAR,  RCHAR,
    6636,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6718,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6696,  RCHAR,   7165,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5835,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6434,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8282,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8428,  RCHAR,
   RCHAR,  RCHAR,   8429,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5800,  RCHAR,   5726,  RCHAR,  RCHAR,  RCHAR,   4426,  RCHAR,
    6543,  RCHAR,   7901,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7903,  RCHAR,
    6491,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6129,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4427,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6026,  RCHAR,  RCHAR,  RCHAR,
    4438,  RCHAR,  RCHAR,  RCHAR,   6677,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6260,  RCHAR,  RCHAR,  RCHAR,
    7499,  RCHAR,   7741,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8512,  RCHAR,   4755,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4072,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7784,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6619,  RCHAR,
   RCHAR,  RCHAR,   5274,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6587,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6139,  RCHAR,  RCHAR,  RCHAR,   5075,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4908,  RCHAR,   4888,  RCHAR,
   RCHAR,  RCHAR,   8695,  RCHAR,   8545,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7697,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4931,  RCHAR,   7010,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8051,  RCHAR,   5443,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8283,  RCHAR,   4180,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5605,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6212,  RCHAR,  RCHAR,  RCHAR,   4056,  RCHAR,  RCHAR,  RCHAR,
    4461,  RCHAR,  RCHAR,  RCHAR,   3892,  RCHAR,   8381,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8559,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4194,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7911,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7490,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4017,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4361,  RCHAR,  RCHAR,  RCHAR,
    6552,  RCHAR,   7679,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6851,  RCHAR,
    4313,  RCHAR,  RCHAR,  RCHAR,   6839,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7956,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7798,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5047,  RCHAR,
    7957,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4080,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7501,  RCHAR,
    7312,  RCHAR,  RCHAR,  RCHAR,   7708,  RCHAR,   8638,  RCHAR,
    7523,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7568,  RCHAR,
    3945,  RCHAR,   4275,  RCHAR,  RCHAR,  RCHAR,   7237,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5349,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4374,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8330,  RCHAR,   4816,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4258,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5421,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8207,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8651,  RCHAR,  RCHAR,  RCHAR,   4208,  RCHAR,   8386,  RCHAR,
   RCHAR,  RCHAR,   6582,  RCHAR,   5456,  RCHAR,   6158,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5040,  RCHAR,
   RCHAR,  RCHAR,   6350,  RCHAR,  RCHAR,  RCHAR,   5154,  RCHAR,
    7878,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8584,  RCHAR,
    6680,  RCHAR,   5205,  RCHAR,  RCHAR,  RCHAR,   5162,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6325,  RCHAR,   6897,  RCHAR,
   RCHAR,  RCHAR,   8547,  RCHAR,   4068,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4149,  RCHAR,   4369,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4757,  RCHAR,   5386,  RCHAR,
   RCHAR,  RCHAR,   5930,  RCHAR,   5745,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6340,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4650,  RCHAR,  RCHAR,    188,     11,    248,     99,
   RCHAR,  RCHAR,  RCHAR,
  // uncompressed segments
   RCHAR,  11204,  RCHAR,  11242,  RCHAR,  11265,  RCHAR,  RCHAR,
   RCHAR,  11280,  RCHAR,  11282,  RCHAR,  11317,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  11319,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11325,  RCHAR,
   11345,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11349,  RCHAR,
   RCHAR,  RCHAR,  11355,  RCHAR,  11362,  RCHAR,  11366,  RCHAR,
   11377,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11390,  RCHAR,  11400,
   RCHAR,  11403,  RCHAR,  11421,  RCHAR,  RCHAR,  RCHAR,  11457,
   RCHAR,  11469,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  11475,  RCHAR,  11479,  RCHAR,  RCHAR,  RCHAR,  11543,
   RCHAR,  11553,  RCHAR,  11585,  RCHAR,  11587,  RCHAR,  11589,
   RCHAR,  11592,  RCHAR,  11595,  RCHAR,      0,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11609,  RCHAR,
   11634,  RCHAR,  11647,  RCHAR,  11683,  RCHAR,  11714,  RCHAR,
   11765,  RCHAR,  11833,  RCHAR,  11881,  RCHAR,  11899,  RCHAR,
   11908,  RCHAR,  11954,  RCHAR,  12007,  RCHAR,  12016,  RCHAR,
   12051,  RCHAR,  12064,  RCHAR,  RCHAR,  RCHAR,  12108,  RCHAR,
   RCHAR,  RCHAR,  12134,  RCHAR,  12139,  RCHAR,  12145,  RCHAR,
   12158,  RCHAR,  12224,  RCHAR,  RCHAR,  RCHAR,  12241,  RCHAR,
   RCHAR,  RCHAR,  12244,  RCHAR,  12277,  RCHAR,  12337,  RCHAR,
   12350,  RCHAR,  12374,  RCHAR,  12380,  RCHAR,  12456,  RCHAR,
   12487,  RCHAR,  12500,  RCHAR,  12522,  RCHAR,  12539,  RCHAR,
   12578,  RCHAR,  12639,  RCHAR,  12715,  RCHAR,  RCHAR,  RCHAR,
   12742,  RCHAR,  12796,  RCHAR,  12811,  RCHAR,  12828,  RCHAR,
   12859,  RCHAR,  12900,  RCHAR,  12938,  RCHAR,  RCHAR,  RCHAR,
   12956,  RCHAR,  RCHAR,  RCHAR,  12969,  RCHAR,  12976,  RCHAR,
   12985,  RCHAR,  12993,  RCHAR,  12999,  RCHAR,  13014,  RCHAR,
   13020,  RCHAR,  13028,  RCHAR,  13031,  RCHAR,  13048,  RCHAR,
   13050,  RCHAR,  13054,  RCHAR,  13058,  RCHAR,  RCHAR,  RCHAR,
   13066,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  13070,  RCHAR,
   RCHAR,  RCHAR,  13086,  RCHAR,  13094,  RCHAR,  RCHAR,  RCHAR,
   13101,  RCHAR,  13103,  RCHAR,  13132,  RCHAR,  13141,  RCHAR,
   13164,  RCHAR,  RCHAR,  RCHAR,  13207,  RCHAR,  13211,  RCHAR,
   13223,  RCHAR,  13225,  RCHAR,  13252,  RCHAR,  13281,  RCHAR,
   13308,  RCHAR,  RCHAR,  RCHAR,  13329,  RCHAR,  13333,  RCHAR,
   13405,  RCHAR,  13410,  RCHAR,  13534,  RCHAR,  13541,  RCHAR,
   13549,  RCHAR,  13586,  RCHAR,  13595,  RCHAR,  13607,  RCHAR,
   13632,  RCHAR,  RCHAR,  RCHAR,  13652,  RCHAR,  RCHAR,  RCHAR,
   13657,  RCHAR,  RCHAR,  RCHAR,  13659,  RCHAR,  13671,  RCHAR,
   13680,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  13688,  RCHAR,
   13692,  RCHAR,  13737,  RCHAR,  13886,  RCHAR,  13891,  RCHAR,
   RCHAR,  RCHAR,  13956,  RCHAR,  RCHAR,  RCHAR,  13958,  RCHAR,
   13982,  RCHAR,  13990,  RCHAR,  14012,  RCHAR,  14031,  RCHAR,
   14034,  RCHAR,  14040,  RCHAR,  14047,  RCHAR,  14052,  RCHAR,
   RCHAR,  RCHAR,  14058,  RCHAR,  14064,  RCHAR,  14145,  RCHAR,
   RCHAR,  RCHAR,  14185,  RCHAR,  14190,  RCHAR,  14250,  RCHAR,
   14297,  RCHAR,  14359,  RCHAR,  14371,  RCHAR,  14378,  RCHAR,
   14498,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  14509,  RCHAR,
   14512,  RCHAR,  14545,  RCHAR,  14548,  RCHAR,  14584,  RCHAR,
   14619,  RCHAR,  14633,  RCHAR,  RCHAR,  RCHAR,  14636,  RCHAR,
   14644,  RCHAR,  RCHAR,  RCHAR,  14692,  RCHAR,  14775,  RCHAR,
   14792,  RCHAR,  RCHAR,  RCHAR,  14832,  RCHAR,  14880,  RCHAR,
   14893,  RCHAR,  14920,  RCHAR,  14966,  RCHAR,  15016,  RCHAR,
   RCHAR,  RCHAR,  15046,  RCHAR,  15051,  RCHAR,  15056,  RCHAR,
   15069,  RCHAR,  15137,  RCHAR,  15144,  RCHAR,  15163,  RCHAR,
   15174,  RCHAR,  15196,  RCHAR,  15198,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  15203,  RCHAR,  15210,  RCHAR,  RCHAR,  RCHAR,
   15213,  RCHAR,  15247,  RCHAR,  15321,  RCHAR,  15513,  RCHAR,
   15567,  RCHAR,  15617,  RCHAR,  15651,  RCHAR,  15682,  RCHAR,
   15713,  RCHAR,  15730,  RCHAR,  15808,  RCHAR,  15834,  RCHAR,
   15853,  RCHAR,  15876,  RCHAR,  15898,  RCHAR,  15913,  RCHAR,
   15935,  RCHAR,  15941,  RCHAR,  15943,  RCHAR,  15949,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  15978,  RCHAR,  15985,  RCHAR,
   16025,  RCHAR,  16091,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   16097,  RCHAR,  RCHAR,  RCHAR,  16100,  RCHAR,  16139,  RCHAR,
   16147,  RCHAR,  16178,  RCHAR,  16184,  RCHAR,  16187,  RCHAR,
   16195,  RCHAR,  16221,  RCHAR,  RCHAR,  RCHAR,  16266,  RCHAR,
   16281,  RCHAR,  RCHAR,  RCHAR,  16294,  RCHAR,  16303,  RCHAR,
   16312,  RCHAR,  16318,  RCHAR,  16337,  RCHAR,  RCHAR,  RCHAR,
   16341,  RCHAR,  16346,  RCHAR,  16357,  RCHAR,  16369,  RCHAR,
   16394,  RCHAR,  16403,  RCHAR,  16449,  RCHAR,  16451,  RCHAR,
   RCHAR,  RCHAR,  16463,  RCHAR,  16478,  RCHAR,  16497,  RCHAR,
   16549,  RCHAR,  16622,  RCHAR,  16654,  RCHAR,  16670,  RCHAR,
   16731,  RCHAR,  16738,  RCHAR,  16798,  RCHAR,  16853,  RCHAR,
   16863,  RCHAR,  16883,  RCHAR,  16926,  RCHAR,  16945,  RCHAR,
   16969,  RCHAR,  16976,  RCHAR,  16980,  RCHAR,  17003,  RCHAR,
   17023,  RCHAR,  17027,  RCHAR,  17057,  RCHAR,  17097,  RCHAR,
   17126,  RCHAR,  17176,  RCHAR,  17184,  RCHAR,  17208,  RCHAR,
   17214,  RCHAR,  17220,  RCHAR,  17273,  RCHAR,  17281,  RCHAR,
   RCHAR,  RCHAR,  17289,  RCHAR,  17309,  RCHAR,  17323,  RCHAR,
   17330,  RCHAR,  17370,  RCHAR,  17408,  RCHAR,  17414,  RCHAR,
   17443,  RCHAR,  17459,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   17471,  RCHAR,  17535,  RCHAR,  17551,  RCHAR,  17565,  RCHAR,
   17570,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  17582,  RCHAR,
   RCHAR,  RCHAR,  17588,  RCHAR,  17596,  RCHAR,  17603,  RCHAR,
   17619,  RCHAR,  17627,  RCHAR,  17647,  RCHAR,  17675,  RCHAR,
   17746,  RCHAR,  RCHAR,  RCHAR,  17765,  RCHAR,  17814,  RCHAR,
   17841,  RCHAR,  17855,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   17934,  RCHAR,  17938,  RCHAR,  17980,  RCHAR,  RCHAR,  RCHAR,
   18055,  RCHAR,  18117,  RCHAR,  RCHAR,  RCHAR,  18134,  RCHAR,
   18148,  RCHAR,  18156,  RCHAR,  18167,  RCHAR,  RCHAR,  RCHAR,
   18218,  RCHAR,  18235,  RCHAR,  18293,  RCHAR,  RCHAR,  RCHAR,
   18296,  RCHAR,  RCHAR,  RCHAR,  18306,  RCHAR,  18323,  RCHAR,
   18330,  RCHAR,  18337,  RCHAR,  18359,  RCHAR,  18364,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  18393,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  18409,  RCHAR,  18414,  RCHAR,
   18442,  RCHAR,  18449,  RCHAR,  18472,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  18498,  RCHAR,  18501,  RCHAR,  18553,  RCHAR,
   18561,  RCHAR,  18566,  RCHAR,  18594,  RCHAR,  18627,  RCHAR,
   18665,  RCHAR,  RCHAR,  RCHAR,  18698,  RCHAR,  18738,  RCHAR,
   18752,  RCHAR,  RCHAR,  RCHAR,  18759,  RCHAR,  18767,  RCHAR,
   18808,  RCHAR,  18811,  RCHAR,  RCHAR,  RCHAR,  18832,  RCHAR,
   RCHAR,  RCHAR,  18849,  RCHAR,  RCHAR,  RCHAR,  18859,  RCHAR,
   18886,  RCHAR,  18898,  RCHAR,  RCHAR,  RCHAR,  18908,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  18918,  RCHAR,  18932,  RCHAR,
   18939,  RCHAR,  18941,  RCHAR,  18946,  RCHAR,  18954,  RCHAR,
   18961,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  19006,  RCHAR,
   19016,  RCHAR,  19056,  RCHAR,  19072,  RCHAR,  RCHAR,  RCHAR,
   19077,  RCHAR,  19111,  RCHAR,  19117,  RCHAR,  19124,  RCHAR,
   19144,  RCHAR,  19149,  RCHAR,  19187,  RCHAR,  19189,  RCHAR,
   19204,  RCHAR,  19233,  RCHAR,  19237,  RCHAR,  19241,  RCHAR,
   19249,  RCHAR,  19259,  RCHAR,  19276,  RCHAR,  19281,  RCHAR,
   19291,  RCHAR,  19307,  RCHAR,  19344,  RCHAR,  19380,  RCHAR,
   19383,  RCHAR,  19391,  RCHAR,  19423,  RCHAR,  19453,  RCHAR,
   19462,  RCHAR,  19492,  RCHAR,  19529,  RCHAR,  19531,  RCHAR,
   19534,  RCHAR,  19546,  RCHAR,  19572,  RCHAR,  19576,  RCHAR,
   19589,  RCHAR,  19595,  RCHAR,  19606,  RCHAR,  19634,  RCHAR,
   19642,  RCHAR,  19657,  RCHAR,  19684,  RCHAR,  19743,  RCHAR,
   19750,  RCHAR,  19753,  RCHAR,  RCHAR,  RCHAR,  19772,  RCHAR,
   19775,  RCHAR,  19792,  RCHAR,  19845,  RCHAR,  RCHAR,  RCHAR,
   19868,  RCHAR,  RCHAR,  RCHAR,  19881,  RCHAR,  19924,  RCHAR,
   19933,  RCHAR,  19939,  RCHAR,  19961,  RCHAR,  19993,  RCHAR,
   20031,  RCHAR,  RCHAR,  RCHAR,  20052,  RCHAR,  20088,  RCHAR,
   20106,  RCHAR,  RCHAR,  RCHAR,  20138,  RCHAR,  RCHAR,  RCHAR,
   20147,  RCHAR,  20178,  RCHAR,  20207,  RCHAR,  20218,  RCHAR,
   20222,  RCHAR,  20235,  RCHAR,  20246,  RCHAR,  20254,  RCHAR,
   20288,  RCHAR,  20308,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   20313,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  20331,  RCHAR,
   20341,  RCHAR,  20348,  RCHAR,  20353,  RCHAR,  RCHAR,  RCHAR,
   20370,  RCHAR,  20381,  RCHAR,  20386,  RCHAR,  20396,  RCHAR,
   20406,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  20411,  RCHAR,
   20415,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  20423,  RCHAR,
   20449,  RCHAR,  20454,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   20564,  RCHAR,  20566,  RCHAR,  20592,  RCHAR,  RCHAR,  RCHAR,
   20603,  RCHAR,  20613,  RCHAR,  20619,  RCHAR,  20634,  RCHAR,
   RCHAR,  RCHAR,  20646,  RCHAR,  RCHAR,  RCHAR,  20670,  RCHAR,
   RCHAR,  RCHAR,  20672,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   20679,  RCHAR,  20684,  RCHAR,  20744,  RCHAR,  20786,  RCHAR,
   20914,  RCHAR,  20933,  RCHAR,  RCHAR,  RCHAR,  20951,  RCHAR,
   20958,  RCHAR,  20963,  RCHAR,  20990,  RCHAR,  RCHAR,  RCHAR,
   21007,  RCHAR,  21021,  RCHAR,  21034,  RCHAR,  21036,  RCHAR,
   RCHAR,  RCHAR,  21038,  RCHAR,  21041,  RCHAR,  21163,  RCHAR,
   21183,  RCHAR,  RCHAR,  RCHAR,  21189,  RCHAR,  21195,  RCHAR,
   21207,  RCHAR,  21217,  RCHAR,  21242,  RCHAR,  RCHAR,  RCHAR,
   21249,  RCHAR,  21261,  RCHAR,  21270,  RCHAR,  21278,  RCHAR,
   21281,  RCHAR,  21294,  RCHAR,  RCHAR,  RCHAR,  21297,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  21306,  RCHAR,  21324,  RCHAR,
   21385,  RCHAR,  21391,  RCHAR,  21415,  RCHAR,  21419,  RCHAR,
   21426,  RCHAR,  21488,  RCHAR,  21596,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  21619,  RCHAR,  RCHAR,  RCHAR,  21635,  RCHAR,
   21641,  RCHAR,  21649,  RCHAR,  21661,  RCHAR,  21671,  RCHAR,
   21682,  RCHAR,  21686,  RCHAR,  RCHAR,  RCHAR,  21698,  RCHAR,
   21709,  RCHAR,  RCHAR,  RCHAR,  21752,  RCHAR,  21770,  RCHAR,
   21792,  RCHAR,  21808,  RCHAR,  21814,  RCHAR,  21826,  RCHAR,
   21833,  RCHAR,  21840,  RCHAR,  21847,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  21852,  RCHAR,  21876,  RCHAR,  21896,  RCHAR,
   RCHAR,  RCHAR,  21913,  RCHAR,  21920,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  21934,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  21941,  RCHAR,  21948,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  21952,  RCHAR,  RCHAR,  RCHAR,
   21955,  RCHAR,  21980,  RCHAR,  21995,  RCHAR,  21997,  RCHAR,
   22001,  RCHAR,  22016,  RCHAR,  22022,  RCHAR,  22031,  RCHAR,
   22053,  RCHAR,  22088,  RCHAR,  22219,  RCHAR,  RCHAR,  RCHAR,
   22233,  RCHAR,  22258,  RCHAR,  22300,  RCHAR,  RCHAR,  RCHAR,
   22305,  RCHAR,  22311,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   22317,  RCHAR,  22355,  RCHAR,  22359,  RCHAR,  22363,  RCHAR,
   22405,  RCHAR,  22415,  RCHAR,  22419,  RCHAR,  22427,  RCHAR,
   22435,  RCHAR,  RCHAR,  RCHAR,  22472,  RCHAR,  22491,  RCHAR,
   22499,  RCHAR,  RCHAR,  RCHAR,  22520,  RCHAR,  22536,  RCHAR,
   22541,  RCHAR,  RCHAR,  RCHAR,  22558,  RCHAR,  22571,  RCHAR,
   RCHAR,  RCHAR,  22577,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   22599,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   22605,  RCHAR,  22616,  RCHAR,  22626,  RCHAR,  RCHAR,  RCHAR,
   22638,  RCHAR,  RCHAR,  RCHAR,  22642,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  22646,  RCHAR,  22651,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  22660,  RCHAR,  RCHAR,  RCHAR,
   22663,  RCHAR,  22668,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   22672,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  22675,  RCHAR,
   22680,  RCHAR,  22687,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   22699,  RCHAR,  22708,  RCHAR,  22713,  RCHAR,  22724,  RCHAR,
   22744,  RCHAR,  22760,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   22778,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  22791,  RCHAR,
   22800,  RCHAR,  RCHAR,  RCHAR,  22814,  RCHAR,     32,  RCHAR,
   22830,  RCHAR,  22887,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  23087,  RCHAR,
  // [0x0111,0x0111] -> [   753,   753] # seg 7
  // [0x0416,0x042F] -> [  1041,  1066] # seg 32
  // [0x0436,0x044F] -> [  1089,  1114] # seg 34
  // [0x0451,0x0451] -> [  1088,  1088] # seg 36
  // [0x203B,0x203B] -> [    55,    55] # seg 42
  // [0x2074,0x2074] -> [   840,   840] # seg 44
  // [0x20AC,0x20AC] -> [   163,   163] # seg 48
  // [0x2160,0x2169] -> [   391,   400] # seg 57
  // [0x3000,0x301F] -v # seg 109 at pos 0
       0,      1,      2,      7,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
      19,     20,     21,     22,     23,     24,     25,     26,
      27,     28,  RCHAR,     74,     17,     18,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,     12,  RCHAR,  RCHAR,  RCHAR,
  // [0x30A1,0x30F6] -> [   940,  1025] # seg 113
  // [0x30FB,0x30FB] -> [     3,     3] # seg 115
  // [0x3131,0x318E] -> [   282,   375] # seg 117
  // [0x3200,0x321B] -> [   768,   795] # seg 119
  // [0x3399,0x33A2] -> [   574,   583] # seg 127
  // [0x33B0,0x33B9] -> [   594,   603] # seg 129
  // [0xAC00,0xD7A3] -v # seg 1486 at pos 32
    1410,   1411,   8836,   8837,   1412,   8838,   8839,   1413,
    1414,   1415,   1416,   8840,   8841,   8842,   8843,   8844,
    1417,   1418,   1419,   1420,   1421,   1422,   1423,   1424,
    8845,   1425,   1426,   1427,   1428,   1429,   8846,   8847,
    1430,   8848,   8849,   8850,   1431,   8851,   8852,   8853,
    8854,   8855,   8856,   8857,   1432,   1433,   8858,   1434,
    1435,   1436,   8859,   8860,   8861,   8862,   8863,   8864,
    1437,   1438,   8865,   8866,   1439,   8867,   8868,   8869,
    1440,   8870,   8871,   8872,   8873,   8874,   8875,   8876,
    8877,   8878,   8879,   1441,   8880,   1442,   8881,   8882,
    8883,   8884,   8885,   8886,   1443,   8887,   8888,   8889,
    1444,   8890,   8891,   8892,   1445,   8893,   8894,   8895,
    8896,   8897,   8898,   8899,   8900,   8901,   8902,   8903,
    8904,   8905,   8906,   8907,   8908,   8909,   8910,   8911,
    1446,   1447,   8912,   8913,   1448,   8914,   8915,   1449,
    1450,   8916,   1451,   8917,   8918,   8919,   8920,   8921,
    1452,   1453,   8922,   1454,   1455,   1456,   1457,   8923,
    8924,   1458,   1459,   1460,   1461,   8925,   8926,   8927,
    1462,   8928,   8929,   8930,   1463,   8931,   8932,   8933,
    8934,   8935,   8936,   8937,   1464,   1465,   8938,   1466,
    1467,   1468,   8939,   8940,   8941,   8942,   8943,   8944,
    1469,   1470,   1471,   8945,   1472,   8946,   8947,   1473,
    1474,   8948,   8949,   8950,   8951,   8952,   8953,   8954,
    1475,   1476,   8955,   1477,   1478,   1479,   8956,   8957,
    8958,   1480,   8959,   8960,   1481,   8961,   8962,   8963,
    1482,   8964,   8965,   8966,   1483,   8967,   8968,   8969,
    8970,   8971,   8972,   8973,   8974,   1484,   8975,   1485,
    8976,   8977,   8978,   8979,   8980,   8981,   8982,   8983,
    1486,   1487,   8984,   8985,   1488,   8986,   8987,   1489,
    1490,   8988,   1491,   8989,   1492,   8990,   8991,   1493,
    1494,   1495,   8992,   1496,   8993,   1497,   1498,   8994,
    8995,   8996,   8997,   8998,   1499,   1500,   8999,   9000,
    1501,   9001,   9002,   9003,   1502,   9004,   1503,   9005,
    9006,   9007,   9008,   9009,   1504,   1505,   9010,   1506,
    9011,   1507,   9012,   9013,   9014,   9015,   9016,   9017,
    1508,   9018,   9019,   9020,   1509,   9021,   9022,   9023,
    1510,   9024,   9025,   9026,   9027,   9028,   9029,   9030,
    9031,   1511,   9032,   9033,   1512,   1513,   9034,   9035,
    9036,   9037,   9038,   9039,   1514,   1515,   9040,   9041,
    1516,   9042,   9043,   9044,   1517,   9045,   9046,   9047,
    9048,   9049,   9050,   9051,   1518,   1519,   9052,   1520,
    9053,   1521,   9054,   9055,   9056,   9057,   9058,   9059,
    1522,   9060,   9061,   9062,   1523,   9063,   9064,   9065,
    1524,   9066,   9067,   9068,   9069,   9070,   9071,   9072,
    9073,   1525,   9074,   1526,   9075,   9076,   9077,   9078,
    9079,   9080,   9081,   9082,   1527,   1528,   9083,   9084,
    1529,   9085,   9086,   1530,   1531,   1532,   1533,   9087,
    9088,   9089,   9090,   1534,   1535,   1536,   9091,   1537,
    9092,   1538,   1539,   9093,   9094,   9095,   9096,   9097,
    1540,   1541,   9098,   9099,   1542,   9100,   9101,   9102,
    1543,   9103,   9104,   9105,   9106,   9107,   9108,   9109,
    9110,   9111,   9112,   9113,   1544,   1545,   9114,   9115,
    9116,   9117,   9118,   9119,   1546,   9120,   9121,   9122,
    9123,   9124,   9125,   9126,   9127,   9128,   9129,   9130,
    9131,   9132,   9133,   9134,   9135,   9136,   9137,   1547,
    9138,   9139,   9140,   9141,   9142,   9143,   9144,   9145,
    1548,   1549,   9146,   9147,   1550,   9148,   9149,   9150,
    1551,   9151,   9152,   9153,   9154,   9155,   9156,   9157,
    1552,   1553,   9158,   1554,   9159,   9160,   9161,   9162,
    9163,   9164,   9165,   9166,   1555,   9167,   9168,   9169,
    1556,   9170,   9171,   9172,   1557,   9173,   9174,   9175,
    9176,   9177,   9178,   9179,   9180,   9181,   9182,   9183,
    9184,   9185,   9186,   9187,   9188,   9189,   9190,   9191,
    1558,   1559,   9192,   9193,   1560,   9194,   9195,   1561,
    1562,   1563,   9196,   9197,   9198,   9199,   9200,   9201,
    1564,   1565,   9202,   1566,   9203,   1567,   9204,   9205,
    9206,   9207,   9208,   9209,   1568,   9210,   9211,   9212,
    9213,   9214,   9215,   9216,   9217,   9218,   9219,   9220,
    9221,   9222,   9223,   9224,   9225,   9226,   9227,   9228,
    9229,   9230,   9231,   9232,   9233,   9234,   9235,   9236,
    1569,   1570,   9237,   9238,   1571,   9239,   9240,   1572,
    1573,   9241,   1574,   9242,   9243,   9244,   9245,   9246,
    1575,   1576,   9247,   1577,   9248,   1578,   1579,   9249,
    9250,   9251,   1580,   9252,   1581,   1582,   1583,   9253,
    1584,   9254,   9255,   9256,   1585,   9257,   1586,   9258,
    9259,   9260,   9261,   9262,   1587,   1588,   9263,   1589,
    1590,   1591,   9264,   9265,   9266,   1592,   9267,   9268,
    1593,   1594,   9269,   9270,   1595,   9271,   9272,   9273,
    1596,   9274,   9275,   9276,   9277,   9278,   9279,   9280,
    1597,   1598,   9281,   1599,   1600,   1601,   9282,   9283,
    9284,   9285,   9286,   9287,   1602,   1603,   9288,   9289,
    9290,   9291,   9292,   9293,   1604,   9294,   9295,   9296,
    9297,   9298,   9299,   9300,   9301,   9302,   9303,   9304,
    9305,   9306,   9307,   9308,   9309,   9310,   9311,   9312,
    9313,   9314,   9315,   9316,   9317,   9318,   9319,   9320,
    9321,   9322,   9323,   9324,   9325,   9326,   9327,   9328,
    9329,   9330,   9331,   9332,   9333,   9334,   9335,   9336,
    9337,   9338,   9339,   9340,   1605,   1606,   1607,   9341,
    1608,   9342,   9343,   9344,   1609,   9345,   9346,   9347,
    9348,   9349,   9350,   9351,   1610,   1611,   9352,   1612,
    1613,   1614,   9353,   9354,   9355,   9356,   9357,   9358,
    1615,   1616,   9359,   9360,   1617,   9361,   9362,   9363,
    9364,   9365,   9366,   9367,   9368,   9369,   9370,   9371,
    1618,   9372,   9373,   1619,   9374,   1620,   9375,   9376,
    9377,   9378,   9379,   9380,   1621,   9381,   9382,   9383,
    1622,   9384,   9385,   9386,   1623,   9387,   9388,   9389,
    9390,   9391,   9392,   9393,   9394,   9395,   9396,   1624,
    1625,   9397,   9398,   9399,   9400,   1626,   9401,   9402,
    1627,   9403,   9404,   9405,   9406,   9407,   9408,   9409,
    9410,   9411,   9412,   9413,   9414,   9415,   9416,   9417,
    9418,   9419,   9420,   9421,   9422,   9423,   9424,   9425,
    9426,   9427,   9428,   9429,   1628,   1629,   9430,   9431,
    1630,   9432,   1631,   9433,   1632,   9434,   9435,   9436,
    9437,   9438,   9439,   9440,   1633,   1634,   9441,   1635,
    9442,   1636,   1637,   1638,   9443,   9444,   9445,   9446,
    1639,   1640,   9447,   9448,   9449,   9450,   9451,   9452,
    1641,   9453,   9454,   9455,   9456,   9457,   9458,   9459,
    9460,   9461,   9462,   9463,   1642,   1643,   9464,   9465,
    9466,   9467,   9468,   9469,   1644,   1645,   9470,   9471,
    9472,   9473,   9474,   9475,   9476,   9477,   9478,   9479,
    9480,   9481,   9482,   9483,   9484,   9485,   9486,   9487,
    9488,   1646,   9489,   9490,   9491,   9492,   9493,   9494,
    1647,   9495,   9496,   9497,   1648,   9498,   9499,   9500,
    1649,   9501,   9502,   9503,   9504,   9505,   9506,   9507,
    1650,   1651,   9508,   9509,   9510,   1652,   9511,   9512,
    9513,   9514,   9515,   9516,   1653,   9517,   9518,   9519,
    9520,   9521,   9522,   9523,   9524,   9525,   9526,   9527,
    9528,   9529,   9530,   9531,   9532,   9533,   9534,   9535,
    9536,   9537,   9538,   9539,   9540,   9541,   9542,   9543,
    1654,   1655,   9544,   9545,   1656,   9546,   9547,   9548,
    1657,   9549,   9550,   9551,   9552,   9553,   9554,   1658,
    1659,   1660,   9555,   1661,   9556,   1662,   1663,   9557,
    9558,   9559,   9560,   9561,   1664,   9562,   9563,   9564,
    9565,   9566,   9567,   9568,   1665,   9569,   9570,   9571,
    9572,   9573,   9574,   9575,   9576,   9577,   9578,   9579,
    1666,   1667,   9580,   9581,   9582,   9583,   9584,   9585,
    1668,   1669,   9586,   9587,   1670,   9588,   9589,   9590,
    1671,   9591,   9592,   9593,   9594,   9595,   9596,   9597,
    1672,   1673,   9598,   9599,   1674,   9600,   9601,   9602,
    9603,   9604,   9605,   9606,   1675,   9607,   9608,   9609,
    1676,   9610,   9611,   9612,   1677,   9613,   9614,   9615,
    9616,   9617,   9618,   9619,   1678,   1679,   9620,   9621,
    9622,   9623,   9624,   9625,   9626,   9627,   9628,   9629,
    1680,   9630,   9631,   9632,   9633,   9634,   9635,   9636,
    9637,   9638,   9639,   9640,   9641,   9642,   9643,   9644,
    9645,   9646,   9647,   9648,   9649,   9650,   9651,   9652,
    9653,   9654,   9655,   9656,   1681,   1682,   9657,   9658,
    1683,   9659,   1684,   9660,   1685,   9661,   1686,   9662,
    9663,   9664,   9665,   1687,   1688,   1689,   9666,   1690,
    9667,   1691,   9668,   9669,   9670,   1692,   9671,   9672,
    9673,   9674,   9675,   9676,   9677,   9678,   9679,   9680,
    9681,   9682,   9683,   9684,   9685,   9686,   9687,   9688,
    9689,   9690,   9691,   9692,   9693,   9694,   9695,   9696,
    9697,   9698,   9699,   9700,   1693,   1694,   9701,   9702,
    1695,   9703,   9704,   9705,   1696,   9706,   9707,   9708,
    9709,   9710,   9711,   9712,   1697,   1698,   9713,   1699,
    9714,   1700,   9715,   9716,   9717,   9718,   9719,   9720,
    1701,   1702,   1703,   9721,   1704,   9722,   9723,   1705,
    1706,   1707,   1708,   9724,   9725,   9726,   9727,   9728,
    1709,   1710,   9729,   1711,   1712,   1713,   1714,   1715,
    9730,   1716,   9731,   1717,   1718,   1719,   9732,   9733,
    1720,   9734,   9735,   9736,   1721,   9737,   9738,   9739,
    9740,   9741,   9742,   9743,   1722,   1723,   9744,   1724,
    1725,   1726,   9745,   9746,   9747,   9748,   9749,   9750,
    1727,   1728,   9751,   9752,   1729,   9753,   9754,   9755,
    1730,   9756,   9757,   9758,   9759,   9760,   9761,   9762,
    1731,   9763,   9764,   9765,   9766,   1732,   9767,   9768,
    9769,   9770,   9771,   9772,   9773,   9774,   9775,   9776,
    9777,   9778,   9779,   9780,   9781,   9782,   9783,   9784,
    9785,   9786,   9787,   9788,   9789,   9790,   9791,   9792,
    9793,   9794,   9795,   9796,   9797,   9798,   9799,   9800,
    1733,   1734,   9801,   1735,   1736,   9802,   9803,   9804,
    1737,   9805,   1738,   1739,   9806,   9807,   9808,   9809,
    1740,   1741,   9810,   1742,   1743,   1744,   9811,   9812,
    9813,   9814,   9815,   1745,   1746,   1747,   9816,   9817,
    1748,   9818,   9819,   9820,   1749,   9821,   9822,   9823,
    9824,   9825,   9826,   9827,   1750,   1751,   9828,   1752,
    1753,   1754,   9829,   9830,   9831,   9832,   9833,   9834,
    1755,   1756,   9835,   9836,   1757,   9837,   9838,   9839,
    1758,   9840,   9841,   9842,   9843,   9844,   9845,   9846,
    1759,   1760,   9847,   9848,   1761,   1762,   9849,   9850,
    1763,   9851,   9852,   9853,   1764,   9854,   9855,   9856,
    1765,   9857,   9858,   9859,   9860,   9861,   9862,   9863,
    9864,   9865,   9866,   9867,   9868,   9869,   9870,   9871,
    9872,   9873,   9874,   9875,   9876,   9877,   9878,   9879,
    1766,   1767,   9880,   9881,   1768,   9882,   9883,   9884,
    1769,   9885,   1770,   9886,   9887,   9888,   9889,   9890,
    1771,   1772,   9891,   1773,   9892,   1774,   9893,   9894,
    9895,   9896,   1775,   1776,   1777,   9897,   9898,   9899,
    1778,   9900,   9901,   9902,   1779,   9903,   9904,   9905,
    9906,   9907,   9908,   9909,   9910,   9911,   9912,   9913,
    1780,   9914,   9915,   9916,   9917,   9918,   9919,   9920,
    9921,   9922,   9923,   9924,   9925,   9926,   9927,   9928,
    9929,   9930,   9931,   9932,   9933,   9934,   9935,   9936,
    9937,   9938,   9939,   9940,   9941,   9942,   9943,   9944,
    9945,   9946,   9947,   9948,   1781,   9949,   9950,   9951,
    1782,   9952,   9953,   9954,   1783,   9955,   9956,   9957,
    9958,   9959,   9960,   9961,   1784,   1785,   9962,   1786,
    9963,   9964,   9965,   9966,   9967,   9968,   9969,   9970,
    1787,   1788,   9971,   9972,   1789,   9973,   9974,   9975,
    1790,   9976,   9977,   9978,   9979,   9980,   9981,   9982,
    9983,   1791,   9984,   1792,   9985,   1793,   9986,   9987,
    9988,   9989,   9990,   9991,   1794,   1795,   9992,   9993,
    1796,   9994,   9995,   1797,   1798,   9996,   9997,   9998,
    9999,  10000,  10001,  10002,   1799,   1800,  10003,   1801,
   10004,   1802,  10005,  10006,  10007,  10008,  10009,  10010,
    1803,  10011,  10012,  10013,  10014,  10015,  10016,  10017,
   10018,  10019,  10020,  10021,  10022,  10023,  10024,  10025,
   10026,  10027,  10028,  10029,   1804,  10030,  10031,  10032,
   10033,  10034,  10035,  10036,   1805,  10037,  10038,  10039,
   10040,  10041,  10042,  10043,  10044,  10045,  10046,  10047,
   10048,  10049,  10050,  10051,  10052,  10053,  10054,  10055,
   10056,  10057,  10058,  10059,  10060,  10061,  10062,  10063,
    1806,  10064,  10065,  10066,   1807,  10067,  10068,  10069,
    1808,  10070,  10071,  10072,  10073,  10074,  10075,  10076,
    1809,   1810,  10077,  10078,  10079,  10080,  10081,  10082,
   10083,  10084,  10085,  10086,   1811,   1812,  10087,  10088,
   10089,  10090,  10091,  10092,   1813,  10093,  10094,  10095,
   10096,  10097,  10098,  10099,   1814,   1815,  10100,  10101,
   10102,   1816,  10103,  10104,  10105,  10106,  10107,  10108,
    1817,   1818,  10109,  10110,   1819,  10111,  10112,  10113,
    1820,   1821,   1822,  10114,  10115,  10116,  10117,  10118,
    1823,   1824,  10119,   1825,  10120,   1826,   1827,  10121,
   10122,  10123,   1828,  10124,   1829,  10125,  10126,  10127,
    1830,  10128,  10129,  10130,   1831,  10131,  10132,  10133,
   10134,  10135,  10136,  10137,  10138,  10139,  10140,  10141,
   10142,  10143,  10144,  10145,  10146,  10147,  10148,  10149,
    1832,   1833,  10150,  10151,   1834,  10152,  10153,  10154,
    1835,  10155,   1836,  10156,  10157,  10158,  10159,  10160,
    1837,   1838,  10161,   1839,  10162,   1840,  10163,  10164,
   10165,  10166,   1841,  10167,   1842,   1843,   1844,  10168,
    1845,  10169,  10170,   1846,   1847,   1848,   1849,   1850,
   10171,  10172,  10173,   1851,   1852,   1853,  10174,   1854,
    1855,   1856,   1857,   1858,  10175,  10176,  10177,   1859,
    1860,   1861,  10178,  10179,   1862,  10180,  10181,  10182,
    1863,  10183,  10184,  10185,  10186,  10187,  10188,  10189,
    1864,   1865,  10190,   1866,   1867,   1868,  10191,  10192,
   10193,  10194,  10195,  10196,   1869,  10197,  10198,  10199,
   10200,  10201,  10202,  10203,  10204,  10205,  10206,  10207,
   10208,  10209,  10210,  10211,  10212,  10213,  10214,  10215,
   10216,  10217,  10218,  10219,  10220,  10221,  10222,  10223,
   10224,  10225,  10226,  10227,  10228,  10229,  10230,  10231,
   10232,  10233,  10234,  10235,  10236,  10237,  10238,  10239,
   10240,  10241,  10242,  10243,  10244,  10245,  10246,  10247,
   10248,  10249,  10250,  10251,   1870,   1871,   1872,  10252,
    1873,  10253,  10254,   1874,   1875,  10255,   1876,   1877,
   10256,  10257,  10258,  10259,   1878,   1879,  10260,   1880,
   10261,   1881,  10262,   1882,  10263,  10264,   1883,  10265,
    1884,   1885,  10266,  10267,   1886,  10268,  10269,  10270,
    1887,  10271,  10272,  10273,  10274,  10275,  10276,  10277,
    1888,   1889,  10278,   1890,   1891,   1892,  10279,  10280,
   10281,  10282,  10283,  10284,   1893,  10285,  10286,  10287,
    1894,  10288,  10289,  10290,   1895,  10291,  10292,  10293,
   10294,  10295,  10296,  10297,  10298,  10299,  10300,  10301,
    1896,   1897,  10302,  10303,  10304,  10305,  10306,  10307,
    1898,  10308,  10309,  10310,   1899,  10311,  10312,  10313,
   10314,  10315,  10316,  10317,  10318,  10319,  10320,  10321,
   10322,  10323,  10324,  10325,  10326,  10327,  10328,  10329,
   10330,  10331,  10332,  10333,   1900,   1901,  10334,  10335,
    1902,  10336,  10337,   1903,   1904,  10338,   1905,  10339,
    1906,  10340,  10341,  10342,   1907,   1908,  10343,   1909,
   10344,   1910,  10345,   1911,  10346,   1912,  10347,  10348,
    1913,  10349,  10350,  10351,   1914,  10352,  10353,  10354,
    1915,  10355,  10356,  10357,  10358,  10359,  10360,  10361,
   10362,  10363,  10364,  10365,  10366,  10367,  10368,  10369,
   10370,  10371,  10372,  10373,   1916,  10374,  10375,  10376,
   10377,  10378,  10379,  10380,  10381,  10382,  10383,  10384,
   10385,  10386,  10387,  10388,  10389,  10390,  10391,  10392,
    1917,  10393,  10394,  10395,  10396,  10397,  10398,  10399,
    1918,  10400,  10401,  10402,   1919,  10403,  10404,  10405,
    1920,  10406,  10407,  10408,  10409,  10410,  10411,  10412,
    1921,   1922,  10413,   1923,  10414,  10415,  10416,  10417,
   10418,  10419,  10420,  10421,   1924,  10422,  10423,  10424,
   10425,  10426,  10427,  10428,  10429,  10430,  10431,  10432,
   10433,  10434,  10435,  10436,  10437,  10438,  10439,  10440,
   10441,  10442,  10443,  10444,  10445,  10446,  10447,  10448,
    1925,   1926,  10449,  10450,   1927,  10451,  10452,  10453,
    1928,  10454,  10455,  10456,  10457,  10458,  10459,  10460,
    1929,   1930,  10461,   1931,  10462,   1932,  10463,  10464,
   10465,  10466,  10467,  10468,   1933,  10469,  10470,  10471,
   10472,  10473,  10474,  10475,  10476,  10477,  10478,  10479,
   10480,  10481,  10482,  10483,  10484,  10485,  10486,  10487,
    1934,  10488,  10489,  10490,  10491,  10492,  10493,  10494,
    1935,  10495,  10496,  10497,  10498,  10499,  10500,  10501,
   10502,  10503,  10504,  10505,  10506,  10507,  10508,  10509,
   10510,  10511,  10512,  10513,  10514,   1936,  10515,  10516,
   10517,  10518,  10519,  10520,   1937,  10521,  10522,  10523,
    1938,  10524,  10525,  10526,   1939,  10527,  10528,  10529,
   10530,  10531,  10532,  10533,  10534,   1940,  10535,   1941,
   10536,   1942,  10537,  10538,  10539,  10540,  10541,  10542,
    1943,  10543,  10544,  10545,   1944,  10546,  10547,  10548,
    1945,  10549,  10550,  10551,  10552,  10553,  10554,  10555,
    1946,  10556,  10557,  10558,  10559,   1947,  10560,  10561,
   10562,  10563,  10564,  10565,   1948,   1949,  10566,  10567,
    1950,  10568,  10569,   1951,   1952,  10570,   1953,  10571,
   10572,  10573,  10574,  10575,   1954,   1955,  10576,   1956,
   10577,   1957,  10578,  10579,  10580,  10581,  10582,  10583,
    1958,  10584,  10585,  10586,  10587,  10588,  10589,  10590,
   10591,  10592,  10593,  10594,  10595,  10596,  10597,  10598,
   10599,  10600,  10601,  10602,  10603,  10604,  10605,  10606,
   10607,  10608,  10609,  10610,   1959,   1960,  10611,  10612,
    1961,  10613,  10614,   1962,   1963,  10615,  10616,  10617,
   10618,  10619,  10620,  10621,   1964,   1965,  10622,   1966,
    1967,   1968,   1969,  10623,  10624,  10625,  10626,  10627,
    1970,   1971,  10628,  10629,   1972,  10630,  10631,  10632,
    1973,  10633,  10634,  10635,  10636,  10637,  10638,  10639,
    1974,   1975,  10640,   1976,   1977,   1978,  10641,  10642,
   10643,  10644,  10645,   1979,   1980,   1981,  10646,  10647,
    1982,  10648,  10649,  10650,   1983,  10651,  10652,  10653,
   10654,  10655,  10656,  10657,   1984,   1985,  10658,   1986,
    1987,   1988,  10659,  10660,  10661,  10662,  10663,  10664,
   10665,  10666,  10667,  10668,  10669,  10670,  10671,  10672,
   10673,  10674,  10675,  10676,  10677,  10678,  10679,  10680,
   10681,  10682,  10683,  10684,  10685,  10686,  10687,  10688,
   10689,  10690,  10691,  10692,  10693,  10694,  10695,  10696,
   10697,  10698,  10699,  10700,  10701,  10702,  10703,  10704,
   10705,  10706,  10707,  10708,  10709,  10710,  10711,  10712,
   10713,  10714,  10715,  10716,  10717,  10718,  10719,  10720,
    1989,   1990,  10721,  10722,   1991,  10723,  10724,  10725,
    1992,  10726,   1993,   1994,  10727,  10728,  10729,  10730,
    1995,   1996,  10731,   1997,   1998,   1999,  10732,  10733,
   10734,  10735,  10736,   2000,   2001,   2002,  10737,  10738,
    2003,  10739,  10740,  10741,   2004,  10742,  10743,  10744,
   10745,  10746,  10747,  10748,   2005,   2006,  10749,   2007,
    2008,   2009,  10750,  10751,  10752,  10753,  10754,  10755,
    2010,  10756,  10757,  10758,  10759,  10760,  10761,  10762,
   10763,  10764,  10765,  10766,  10767,  10768,  10769,  10770,
   10771,  10772,  10773,  10774,   2011,  10775,  10776,  10777,
   10778,  10779,  10780,  10781,  10782,  10783,  10784,  10785,
   10786,  10787,  10788,  10789,  10790,  10791,  10792,  10793,
   10794,  10795,  10796,  10797,  10798,  10799,  10800,  10801,
   10802,  10803,  10804,  10805,  10806,  10807,  10808,  10809,
    2012,   2013,  10810,  10811,   2014,  10812,  10813,  10814,
    2015,  10815,  10816,  10817,  10818,  10819,  10820,  10821,
   10822,  10823,  10824,  10825,  10826,   2016,  10827,  10828,
   10829,  10830,  10831,  10832,   2017,  10833,  10834,  10835,
   10836,  10837,  10838,  10839,   2018,  10840,  10841,  10842,
   10843,  10844,  10845,  10846,  10847,  10848,  10849,  10850,
   10851,  10852,  10853,  10854,  10855,  10856,  10857,  10858,
    2019,  10859,  10860,  10861,  10862,  10863,  10864,  10865,
   10866,  10867,  10868,  10869,  10870,  10871,  10872,  10873,
   10874,  10875,  10876,  10877,  10878,  10879,  10880,  10881,
   10882,  10883,  10884,  10885,   2020,  10886,  10887,  10888,
    2021,  10889,  10890,  10891,  10892,  10893,  10894,  10895,
   10896,  10897,  10898,  10899,  10900,  10901,  10902,  10903,
   10904,  10905,  10906,  10907,  10908,  10909,  10910,  10911,
   10912,  10913,  10914,  10915,  10916,  10917,  10918,  10919,
   10920,  10921,  10922,  10923,  10924,  10925,  10926,  10927,
   10928,  10929,  10930,  10931,  10932,  10933,  10934,  10935,
   10936,  10937,  10938,  10939,   2022,   2023,  10940,  10941,
    2024,  10942,  10943,  10944,   2025,  10945,  10946,  10947,
   10948,  10949,  10950,   2026,   2027,  10951,  10952,  10953,
   10954,   2028,  10955,  10956,  10957,  10958,  10959,  10960,
   10961,  10962,  10963,  10964,  10965,  10966,  10967,  10968,
   10969,  10970,  10971,  10972,  10973,  10974,  10975,  10976,
   10977,  10978,  10979,  10980,  10981,  10982,  10983,  10984,
   10985,  10986,  10987,  10988,   2029,  10989,  10990,  10991,
   10992,  10993,  10994,  10995,  10996,  10997,  10998,  10999,
   11000,  11001,  11002,  11003,  11004,  11005,  11006,  11007,
   11008,  11009,  11010,  11011,  11012,  11013,  11014,  11015,
    2030,  11016,  11017,  11018,   2031,  11019,  11020,  11021,
    2032,  11022,  11023,  11024,  11025,  11026,  11027,  11028,
    2033,   2034,  11029,  11030,  11031,   2035,  11032,  11033,
   11034,  11035,  11036,  11037,  11038,  11039,  11040,  11041,
   11042,  11043,  11044,  11045,  11046,  11047,  11048,  11049,
   11050,  11051,  11052,  11053,  11054,  11055,  11056,  11057,
   11058,  11059,  11060,  11061,  11062,  11063,  11064,  11065,
    2036,   2037,  11066,  11067,   2038,  11068,  11069,   2039,
    2040,  11070,  11071,  11072,  11073,  11074,  11075,  11076,
    2041,   2042,  11077,   2043,  11078,  11079,  11080,  11081,
   11082,  11083,  11084,  11085,   2044,  11086,  11087,  11088,
    2045,  11089,  11090,  11091,   2046,  11092,  11093,  11094,
   11095,  11096,  11097,  11098,   2047,   2048,  11099,  11100,
   11101,  11102,  11103,  11104,  11105,  11106,  11107,  11108,
    2049,  11109,  11110,  11111,   2050,  11112,  11113,  11114,
    2051,  11115,  11116,  11117,  11118,  11119,  11120,  11121,
    2052,   2053,  11122,   2054,  11123,   2055,  11124,  11125,
   11126,  11127,  11128,  11129,   2056,   2057,  11130,  11131,
    2058,  11132,  11133,  11134,   2059,  11135,  11136,  11137,
   11138,  11139,  11140,  11141,   2060,   2061,  11142,   2062,
    2063,   2064,   2065,  11143,  11144,  11145,   2066,   2067,
    2068,   2069,  11146,  11147,   2070,  11148,  11149,  11150,
    2071,  11151,  11152,  11153,  11154,  11155,  11156,  11157,
    2072,   2073,  11158,   2074,   2075,   2076,  11159,  11160,
   11161,  11162,  11163,  11164,   2077,   2078,  11165,  11166,
    2079,  11167,  11168,  11169,  11170,  11171,  11172,  11173,
   11174,  11175,  11176,  11177,  11178,  11179,  11180,   2080,
   11181,   2081,  11182,  11183,  11184,  11185,  11186,  11187,
   11188,  11189,  11190,  11191,  11192,  11193,  11194,  11195,
   11196,  11197,  11198,  11199,  11200,  11201,  11202,  11203,
   11204,  11205,  11206,  11207,  11208,  11209,  11210,  11211,
   11212,  11213,  11214,  11215,   2082,   2083,  11216,  11217,
    2084,  11218,  11219,  11220,   2085,  11221,  11222,  11223,
   11224,  11225,  11226,  11227,   2086,   2087,  11228,   2088,
    2089,   2090,  11229,  11230,  11231,  11232,  11233,   2091,
    2092,   2093,  11234,  11235,   2094,  11236,  11237,  11238,
    2095,  11239,  11240,  11241,  11242,  11243,  11244,  11245,
    2096,   2097,  11246,   2098,  11247,   2099,  11248,  11249,
   11250,  11251,  11252,  11253,   2100,   2101,  11254,  11255,
    2102,  11256,  11257,  11258,   2103,  11259,  11260,  11261,
   11262,  11263,  11264,  11265,   2104,   2105,  11266,   2106,
    2107,   2108,  11267,  11268,  11269,  11270,  11271,  11272,
    2109,  11273,  11274,  11275,   2110,  11276,  11277,  11278,
   11279,  11280,  11281,  11282,  11283,  11284,  11285,  11286,
   11287,   2111,  11288,   2112,  11289,  11290,  11291,  11292,
   11293,  11294,  11295,  11296,   2113,   2114,  11297,  11298,
    2115,  11299,  11300,  11301,   2116,  11302,  11303,  11304,
   11305,  11306,  11307,  11308,   2117,   2118,  11309,   2119,
   11310,   2120,  11311,  11312,  11313,  11314,  11315,  11316,
    2121,  11317,  11318,  11319,   2122,  11320,  11321,  11322,
   11323,  11324,  11325,  11326,  11327,  11328,  11329,  11330,
   11331,  11332,  11333,  11334,  11335,   2123,  11336,  11337,
   11338,  11339,  11340,  11341,  11342,  11343,  11344,  11345,
   11346,  11347,  11348,  11349,  11350,  11351,  11352,  11353,
   11354,  11355,  11356,  11357,  11358,  11359,  11360,  11361,
    2124,  11362,  11363,  11364,  11365,  11366,  11367,  11368,
    2125,  11369,  11370,  11371,   2126,  11372,  11373,  11374,
    2127,  11375,  11376,  11377,  11378,  11379,  11380,  11381,
    2128,   2129,  11382,   2130,  11383,   2131,  11384,  11385,
   11386,  11387,  11388,  11389,   2132,  11390,  11391,  11392,
    2133,  11393,  11394,  11395,   2134,  11396,  11397,  11398,
   11399,  11400,  11401,  11402,  11403,   2135,  11404,   2136,
   11405,   2137,  11406,  11407,  11408,  11409,  11410,  11411,
    2138,   2139,  11412,  11413,   2140,  11414,  11415,  11416,
    2141,  11417,  11418,  11419,  11420,  11421,  11422,  11423,
    2142,   2143,  11424,   2144,  11425,   2145,  11426,  11427,
   11428,  11429,  11430,  11431,   2146,  11432,  11433,  11434,
   11435,  11436,  11437,  11438,  11439,  11440,  11441,  11442,
   11443,  11444,  11445,  11446,  11447,  11448,  11449,  11450,
    2147,  11451,  11452,  11453,  11454,  11455,  11456,  11457,
    2148,  11458,  11459,  11460,  11461,  11462,  11463,  11464,
   11465,  11466,  11467,  11468,  11469,  11470,  11471,  11472,
   11473,  11474,  11475,  11476,  11477,  11478,  11479,  11480,
   11481,  11482,  11483,  11484,   2149,   2150,  11485,  11486,
    2151,  11487,  11488,  11489,   2152,  11490,  11491,  11492,
   11493,  11494,  11495,  11496,   2153,  11497,  11498,   2154,
   11499,   2155,  11500,  11501,  11502,  11503,  11504,  11505,
    2156,   2157,  11506,  11507,   2158,  11508,  11509,  11510,
    2159,  11511,  11512,  11513,  11514,  11515,  11516,  11517,
    2160,   2161,  11518,   2162,  11519,   2163,  11520,  11521,
   11522,  11523,  11524,  11525,   2164,   2165,  11526,  11527,
    2166,  11528,  11529,  11530,   2167,  11531,  11532,  11533,
   11534,  11535,  11536,  11537,   2168,   2169,  11538,   2170,
   11539,   2171,   2172,  11540,  11541,   2173,   2174,  11542,
   11543,  11544,  11545,  11546,  11547,  11548,  11549,  11550,
   11551,  11552,  11553,  11554,  11555,  11556,  11557,  11558,
   11559,  11560,  11561,  11562,  11563,  11564,  11565,  11566,
   11567,  11568,  11569,  11570,   2175,   2176,  11571,  11572,
    2177,  11573,  11574,  11575,   2178,  11576,  11577,  11578,
   11579,  11580,  11581,  11582,   2179,   2180,  11583,   2181,
   11584,   2182,  11585,  11586,  11587,  11588,  11589,  11590,
    2183,   2184,  11591,  11592,   2185,  11593,   2186,   2187,
    2188,   2189,   2190,  11594,  11595,  11596,  11597,  11598,
    2191,   2192,  11599,   2193,  11600,   2194,   2195,  11601,
   11602,   2196,  11603,   2197,   2198,   2199,  11604,  11605,
    2200,  11606,  11607,  11608,   2201,  11609,  11610,  11611,
   11612,  11613,  11614,  11615,   2202,   2203,  11616,   2204,
    2205,   2206,   2207,  11617,  11618,  11619,  11620,  11621,
    2208,   2209,  11622,  11623,  11624,  11625,  11626,  11627,
    2210,  11628,  11629,  11630,  11631,  11632,  11633,  11634,
   11635,  11636,  11637,  11638,  11639,   2211,  11640,  11641,
   11642,  11643,  11644,  11645,  11646,  11647,  11648,  11649,
   11650,  11651,  11652,  11653,  11654,  11655,  11656,  11657,
   11658,  11659,  11660,  11661,  11662,  11663,  11664,  11665,
   11666,  11667,  11668,  11669,  11670,  11671,  11672,  11673,
    2212,   2213,  11674,  11675,   2214,  11676,  11677,  11678,
    2215,  11679,   2216,  11680,  11681,  11682,  11683,  11684,
    2217,   2218,  11685,   2219,  11686,   2220,   2221,  11687,
   11688,  11689,  11690,   2222,   2223,   2224,  11691,  11692,
    2225,  11693,  11694,  11695,   2226,  11696,  11697,  11698,
   11699,  11700,  11701,  11702,   2227,   2228,  11703,   2229,
    2230,   2231,  11704,  11705,  11706,  11707,  11708,  11709,
    2232,   2233,  11710,  11711,   2234,  11712,  11713,  11714,
    2235,  11715,  11716,  11717,  11718,  11719,  11720,  11721,
   11722,  11723,  11724,   2236,   2237,   2238,  11725,   2239,
   11726,  11727,  11728,  11729,   2240,  11730,  11731,  11732,
   11733,  11734,  11735,  11736,  11737,  11738,  11739,  11740,
   11741,  11742,  11743,  11744,  11745,  11746,  11747,  11748,
   11749,  11750,  11751,  11752,  11753,  11754,  11755,  11756,
    2241,   2242,  11757,   2243,   2244,  11758,  11759,  11760,
    2245,  11761,   2246,  11762,  11763,  11764,  11765,  11766,
    2247,   2248,  11767,   2249,  11768,   2250,  11769,  11770,
   11771,  11772,  11773,  11774,   2251,  11775,  11776,  11777,
    2252,  11778,  11779,  11780,  11781,  11782,  11783,  11784,
   11785,  11786,  11787,  11788,  11789,  11790,  11791,  11792,
    2253,   2254,  11793,  11794,  11795,  11796,  11797,  11798,
   11799,  11800,  11801,  11802,  11803,  11804,  11805,  11806,
   11807,  11808,  11809,  11810,  11811,  11812,  11813,  11814,
   11815,  11816,  11817,  11818,  11819,  11820,  11821,  11822,
   11823,  11824,  11825,  11826,   2255,  11827,  11828,  11829,
    2256,  11830,  11831,  11832,   2257,  11833,  11834,  11835,
   11836,  11837,  11838,  11839,  11840,   2258,  11841,   2259,
   11842,   2260,  11843,  11844,  11845,  11846,  11847,  11848,
    2261,  11849,  11850,  11851,   2262,  11852,  11853,  11854,
    2263,  11855,  11856,  11857,  11858,  11859,  11860,  11861,
   11862,   2264,  11863,   2265,  11864,  11865,  11866,  11867,
   11868,  11869,  11870,  11871,   2266,   2267,   2268,  11872,
    2269,  11873,  11874,   2270,   2271,   2272,   2273,  11875,
   11876,  11877,  11878,  11879,   2274,   2275,  11880,   2276,
   11881,   2277,  11882,  11883,  11884,   2278,  11885,   2279,
    2280,  11886,  11887,  11888,   2281,  11889,  11890,  11891,
    2282,  11892,  11893,  11894,  11895,  11896,  11897,  11898,
   11899,   2283,  11900,   2284,  11901,  11902,  11903,  11904,
   11905,  11906,  11907,  11908,   2285,  11909,  11910,  11911,
   11912,  11913,  11914,  11915,  11916,  11917,  11918,  11919,
   11920,  11921,  11922,  11923,  11924,  11925,  11926,  11927,
   11928,  11929,  11930,  11931,  11932,  11933,  11934,  11935,
    2286,  11936,  11937,  11938,   2287,  11939,  11940,  11941,
    2288,  11942,  11943,  11944,  11945,  11946,  11947,  11948,
   11949,  11950,  11951,  11952,  11953,  11954,  11955,  11956,
   11957,  11958,  11959,  11960,   2289,  11961,  11962,  11963,
    2290,  11964,  11965,  11966,   2291,  11967,  11968,  11969,
   11970,  11971,  11972,  11973,   2292,  11974,  11975,   2293,
   11976,  11977,  11978,  11979,  11980,  11981,  11982,  11983,
    2294,  11984,  11985,  11986,   2295,  11987,  11988,  11989,
    2296,  11990,  11991,  11992,  11993,  11994,  11995,  11996,
    2297,  11997,  11998,   2298,  11999,  12000,  12001,  12002,
   12003,  12004,  12005,  12006,  12007,  12008,  12009,  12010,
   12011,  12012,  12013,  12014,  12015,  12016,  12017,  12018,
   12019,  12020,  12021,  12022,  12023,  12024,  12025,  12026,
   12027,  12028,  12029,  12030,  12031,  12032,  12033,  12034,
    2299,   2300,  12035,  12036,   2301,  12037,  12038,   2302,
    2303,  12039,   2304,  12040,  12041,  12042,  12043,  12044,
    2305,   2306,  12045,   2307,   2308,   2309,  12046,   2310,
   12047,   2311,  12048,  12049,   2312,   2313,   2314,   2315,
    2316,  12050,  12051,   2317,   2318,   2319,   2320,   2321,
   12052,  12053,  12054,  12055,   2322,   2323,  12056,   2324,
   12057,   2325,  12058,  12059,  12060,   2326,  12061,  12062,
    2327,   2328,  12063,  12064,   2329,  12065,  12066,  12067,
    2330,  12068,  12069,  12070,  12071,  12072,  12073,  12074,
    2331,   2332,  12075,   2333,   2334,   2335,  12076,  12077,
   12078,   2336,  12079,  12080,   2337,   2338,  12081,  12082,
    2339,  12083,  12084,  12085,  12086,  12087,  12088,  12089,
   12090,  12091,  12092,  12093,  12094,   2340,  12095,  12096,
   12097,  12098,  12099,  12100,  12101,  12102,  12103,  12104,
   12105,  12106,  12107,  12108,  12109,  12110,  12111,  12112,
   12113,  12114,  12115,  12116,  12117,  12118,  12119,  12120,
   12121,  12122,  12123,  12124,  12125,  12126,  12127,  12128,
   12129,  12130,  12131,  12132,   2341,   2342,  12133,  12134,
    2343,  12135,  12136,   2344,   2345,  12137,   2346,  12138,
   12139,  12140,  12141,  12142,   2347,   2348,  12143,   2349,
   12144,   2350,   2351,  12145,  12146,  12147,  12148,  12149,
    2352,   2353,  12150,  12151,   2354,  12152,  12153,   2355,
    2356,  12154,  12155,  12156,  12157,  12158,  12159,  12160,
    2357,   2358,  12161,   2359,   2360,   2361,  12162,  12163,
   12164,  12165,  12166,  12167,   2362,   2363,  12168,  12169,
    2364,  12170,  12171,  12172,   2365,  12173,  12174,  12175,
   12176,  12177,  12178,  12179,  12180,   2366,  12181,   2367,
    2368,   2369,  12182,  12183,  12184,   2370,  12185,  12186,
    2371,  12187,  12188,  12189,   2372,  12190,  12191,  12192,
   12193,  12194,  12195,  12196,  12197,  12198,  12199,  12200,
   12201,  12202,  12203,  12204,  12205,  12206,  12207,  12208,
   12209,  12210,  12211,  12212,   2373,   2374,   2375,  12213,
    2376,  12214,  12215,  12216,   2377,  12217,  12218,  12219,
   12220,  12221,  12222,  12223,   2378,   2379,  12224,   2380,
   12225,   2381,  12226,  12227,  12228,  12229,  12230,  12231,
    2382,  12232,  12233,  12234,   2383,  12235,  12236,  12237,
   12238,  12239,  12240,  12241,  12242,  12243,  12244,  12245,
   12246,  12247,  12248,  12249,   2384,  12250,  12251,  12252,
   12253,  12254,  12255,  12256,   2385,  12257,  12258,  12259,
   12260,  12261,  12262,  12263,  12264,  12265,  12266,  12267,
   12268,  12269,  12270,  12271,  12272,  12273,  12274,  12275,
    2386,  12276,  12277,  12278,  12279,  12280,  12281,  12282,
    2387,   2388,  12283,  12284,   2389,  12285,  12286,  12287,
    2390,  12288,  12289,  12290,  12291,  12292,  12293,  12294,
    2391,   2392,  12295,  12296,  12297,  12298,  12299,  12300,
   12301,  12302,  12303,  12304,   2393,  12305,  12306,  12307,
    2394,  12308,  12309,  12310,  12311,  12312,  12313,  12314,
   12315,  12316,  12317,  12318,  12319,  12320,  12321,  12322,
   12323,  12324,  12325,  12326,  12327,  12328,  12329,  12330,
    2395,   2396,  12331,  12332,   2397,  12333,  12334,   2398,
    2399,   2400,   2401,  12335,  12336,  12337,  12338,  12339,
    2402,   2403,  12340,   2404,  12341,   2405,  12342,  12343,
   12344,   2406,   2407,  12345,   2408,  12346,  12347,  12348,
   12349,  12350,  12351,  12352,   2409,  12353,  12354,  12355,
   12356,  12357,  12358,  12359,  12360,  12361,  12362,  12363,
    2410,  12364,  12365,  12366,  12367,  12368,  12369,  12370,
    2411,  12371,  12372,  12373,  12374,  12375,  12376,  12377,
   12378,  12379,  12380,  12381,  12382,  12383,  12384,  12385,
   12386,  12387,  12388,  12389,  12390,  12391,  12392,  12393,
   12394,  12395,  12396,  12397,   2412,   2413,  12398,  12399,
    2414,  12400,  12401,  12402,   2415,  12403,  12404,  12405,
   12406,  12407,  12408,  12409,  12410,  12411,  12412,  12413,
   12414,   2416,  12415,  12416,  12417,  12418,  12419,  12420,
    2417,  12421,  12422,  12423,   2418,  12424,  12425,  12426,
    2419,  12427,  12428,  12429,  12430,  12431,  12432,  12433,
    2420,  12434,  12435,   2421,  12436,   2422,  12437,  12438,
   12439,  12440,  12441,  12442,   2423,   2424,  12443,  12444,
    2425,  12445,  12446,  12447,   2426,  12448,  12449,  12450,
   12451,  12452,  12453,  12454,   2427,   2428,  12455,   2429,
   12456,  12457,  12458,  12459,  12460,  12461,  12462,  12463,
   12464,  12465,  12466,  12467,  12468,  12469,  12470,  12471,
   12472,  12473,  12474,  12475,  12476,  12477,  12478,  12479,
   12480,  12481,  12482,  12483,  12484,  12485,  12486,  12487,
   12488,  12489,  12490,  12491,   2430,   2431,  12492,  12493,
    2432,  12494,  12495,  12496,   2433,  12497,   2434,  12498,
   12499,  12500,  12501,  12502,   2435,   2436,  12503,   2437,
   12504,   2438,   2439,   2440,  12505,  12506,  12507,  12508,
    2441,   2442,  12509,  12510,   2443,  12511,  12512,  12513,
    2444,  12514,   2445,  12515,  12516,  12517,  12518,  12519,
    2446,   2447,  12520,   2448,   2449,   2450,  12521,  12522,
   12523,  12524,  12525,   2451,   2452,   2453,  12526,  12527,
    2454,  12528,  12529,  12530,   2455,  12531,  12532,  12533,
   12534,  12535,  12536,  12537,   2456,   2457,  12538,   2458,
    2459,   2460,  12539,  12540,  12541,  12542,  12543,  12544,
    2461,   2462,  12545,  12546,  12547,  12548,  12549,  12550,
   12551,  12552,  12553,  12554,  12555,  12556,  12557,  12558,
    2463,  12559,  12560,  12561,  12562,  12563,  12564,  12565,
   12566,  12567,  12568,  12569,  12570,  12571,  12572,  12573,
   12574,  12575,  12576,  12577,  12578,  12579,  12580,  12581,
   12582,  12583,  12584,  12585,  12586,  12587,  12588,  12589,
   12590,  12591,  12592,  12593,  12594,  12595,  12596,  12597,
    2464,   2465,  12598,  12599,   2466,  12600,  12601,   2467,
    2468,  12602,  12603,  12604,  12605,  12606,  12607,  12608,
    2469,  12609,  12610,   2470,   2471,   2472,  12611,  12612,
   12613,  12614,  12615,  12616,   2473,  12617,  12618,  12619,
   12620,  12621,  12622,  12623,  12624,  12625,  12626,  12627,
   12628,  12629,  12630,  12631,  12632,  12633,  12634,  12635,
   12636,   2474,  12637,  12638,  12639,  12640,  12641,  12642,
    2475,   2476,  12643,  12644,  12645,  12646,  12647,  12648,
   12649,  12650,  12651,  12652,  12653,  12654,  12655,  12656,
    2477,   2478,  12657,   2479,   2480,   2481,  12658,  12659,
   12660,  12661,  12662,  12663,  12664,  12665,  12666,  12667,
   12668,  12669,  12670,  12671,  12672,  12673,  12674,  12675,
   12676,  12677,  12678,  12679,  12680,  12681,  12682,  12683,
   12684,  12685,  12686,  12687,  12688,  12689,  12690,  12691,
    2482,   2483,  12692,  12693,   2484,  12694,  12695,  12696,
    2485,  12697,  12698,  12699,  12700,  12701,  12702,  12703,
    2486,   2487,  12704,  12705,  12706,   2488,  12707,  12708,
   12709,  12710,  12711,  12712,  12713,  12714,  12715,  12716,
   12717,  12718,  12719,  12720,  12721,  12722,  12723,  12724,
   12725,  12726,  12727,  12728,  12729,  12730,  12731,  12732,
   12733,  12734,  12735,  12736,  12737,  12738,  12739,  12740,
   12741,  12742,  12743,  12744,  12745,  12746,  12747,  12748,
   12749,  12750,  12751,  12752,  12753,  12754,  12755,  12756,
   12757,  12758,  12759,  12760,  12761,  12762,  12763,  12764,
   12765,  12766,  12767,  12768,   2489,  12769,  12770,  12771,
   12772,  12773,  12774,  12775,  12776,  12777,  12778,  12779,
   12780,  12781,  12782,  12783,  12784,  12785,  12786,  12787,
   12788,  12789,  12790,  12791,  12792,  12793,  12794,  12795,
    2490,  12796,  12797,  12798,  12799,  12800,  12801,  12802,
   12803,  12804,  12805,  12806,  12807,  12808,  12809,  12810,
   12811,  12812,  12813,  12814,  12815,   2491,  12816,  12817,
   12818,  12819,  12820,  12821,   2492,   2493,  12822,  12823,
    2494,  12824,  12825,  12826,   2495,  12827,  12828,  12829,
   12830,  12831,  12832,  12833,   2496,  12834,  12835,   2497,
   12836,   2498,  12837,  12838,  12839,  12840,  12841,  12842,
   12843,  12844,  12845,  12846,  12847,  12848,  12849,  12850,
   12851,  12852,  12853,  12854,  12855,  12856,  12857,  12858,
   12859,  12860,  12861,  12862,  12863,  12864,  12865,  12866,
   12867,  12868,  12869,  12870,  12871,  12872,  12873,  12874,
   12875,  12876,  12877,  12878,  12879,  12880,  12881,  12882,
   12883,  12884,  12885,  12886,  12887,  12888,  12889,  12890,
   12891,  12892,  12893,  12894,  12895,  12896,  12897,  12898,
   12899,  12900,  12901,  12902,  12903,  12904,  12905,  12906,
   12907,  12908,  12909,  12910,  12911,  12912,  12913,  12914,
   12915,  12916,  12917,  12918,  12919,  12920,  12921,  12922,
   12923,  12924,  12925,  12926,   2499,  12927,  12928,  12929,
   12930,  12931,  12932,  12933,  12934,  12935,  12936,  12937,
   12938,  12939,  12940,  12941,  12942,  12943,  12944,  12945,
   12946,   2500,  12947,  12948,  12949,  12950,  12951,  12952,
    2501,  12953,  12954,  12955,   2502,  12956,  12957,  12958,
    2503,  12959,  12960,  12961,  12962,  12963,  12964,  12965,
    2504,   2505,  12966,  12967,  12968,  12969,  12970,  12971,
   12972,  12973,  12974,  12975,  12976,  12977,  12978,  12979,
   12980,  12981,  12982,  12983,  12984,  12985,  12986,  12987,
   12988,  12989,  12990,  12991,  12992,  12993,  12994,  12995,
   12996,  12997,  12998,  12999,  13000,  13001,  13002,  13003,
    2506,   2507,  13004,  13005,   2508,  13006,  13007,  13008,
    2509,  13009,  13010,  13011,  13012,  13013,  13014,  13015,
    2510,   2511,  13016,   2512,  13017,   2513,  13018,  13019,
   13020,  13021,  13022,  13023,   2514,   2515,  13024,   2516,
    2517,  13025,  13026,   2518,   2519,   2520,   2521,  13027,
   13028,  13029,  13030,  13031,   2522,   2523,  13032,   2524,
    2525,   2526,  13033,  13034,  13035,   2527,  13036,  13037,
    2528,   2529,  13038,  13039,   2530,  13040,  13041,  13042,
    2531,  13043,  13044,  13045,  13046,  13047,  13048,  13049,
    2532,   2533,  13050,   2534,   2535,   2536,  13051,  13052,
   13053,  13054,  13055,  13056,   2537,   2538,  13057,  13058,
    2539,  13059,  13060,  13061,   2540,  13062,  13063,  13064,
   13065,  13066,  13067,  13068,   2541,   2542,  13069,   2543,
   13070,   2544,  13071,  13072,  13073,  13074,  13075,  13076,
    2545,  13077,  13078,  13079,   2546,  13080,  13081,  13082,
    2547,  13083,  13084,  13085,  13086,  13087,  13088,  13089,
    2548,  13090,  13091,  13092,  13093,   2549,  13094,  13095,
   13096,  13097,  13098,  13099,   2550,   2551,   2552,   2553,
    2554,  13100,  13101,   2555,   2556,  13102,   2557,   2558,
   13103,  13104,  13105,  13106,   2559,   2560,  13107,   2561,
    2562,   2563,  13108,  13109,  13110,  13111,   2564,  13112,
    2565,   2566,  13113,  13114,   2567,  13115,  13116,  13117,
    2568,  13118,  13119,  13120,  13121,  13122,  13123,  13124,
    2569,   2570,  13125,   2571,   2572,   2573,  13126,  13127,
   13128,  13129,  13130,  13131,   2574,   2575,  13132,  13133,
    2576,  13134,  13135,  13136,   2577,  13137,  13138,  13139,
   13140,  13141,  13142,  13143,   2578,   2579,  13144,   2580,
    2581,   2582,  13145,  13146,  13147,  13148,  13149,  13150,
    2583,  13151,  13152,  13153,   2584,  13154,  13155,  13156,
    2585,  13157,  13158,  13159,  13160,  13161,  13162,  13163,
   13164,  13165,  13166,  13167,  13168,   2586,  13169,  13170,
   13171,  13172,  13173,  13174,   2587,   2588,   2589,  13175,
    2590,  13176,  13177,  13178,   2591,  13179,   2592,  13180,
   13181,  13182,  13183,  13184,   2593,   2594,  13185,   2595,
   13186,   2596,  13187,  13188,  13189,   2597,  13190,  13191,
    2598,   2599,  13192,  13193,   2600,  13194,  13195,  13196,
    2601,  13197,  13198,  13199,  13200,  13201,  13202,  13203,
   13204,  13205,  13206,  13207,  13208,   2602,  13209,  13210,
   13211,  13212,  13213,  13214,   2603,  13215,  13216,  13217,
    2604,  13218,  13219,  13220,   2605,  13221,  13222,  13223,
   13224,  13225,  13226,  13227,   2606,  13228,  13229,   2607,
    2608,  13230,  13231,  13232,  13233,  13234,  13235,  13236,
    2609,  13237,  13238,  13239,   2610,  13240,  13241,  13242,
    2611,  13243,  13244,  13245,  13246,  13247,  13248,  13249,
    2612,   2613,  13250,   2614,  13251,  13252,  13253,  13254,
   13255,  13256,  13257,  13258,   2615,   2616,  13259,  13260,
    2617,  13261,  13262,  13263,   2618,  13264,  13265,  13266,
   13267,  13268,  13269,  13270,   2619,   2620,  13271,   2621,
   13272,   2622,  13273,  13274,  13275,  13276,  13277,  13278,
    2623,   2624,  13279,  13280,   2625,  13281,  13282,   2626,
    2627,  13283,  13284,  13285,  13286,  13287,  13288,  13289,
    2628,   2629,  13290,   2630,  13291,   2631,  13292,   2632,
   13293,   2633,   2634,  13294,   2635,  13295,  13296,  13297,
   13298,  13299,  13300,  13301,  13302,  13303,  13304,  13305,
   13306,  13307,  13308,  13309,  13310,  13311,  13312,  13313,
    2636,  13314,  13315,  13316,  13317,  13318,  13319,  13320,
    2637,   2638,  13321,  13322,   2639,  13323,  13324,  13325,
    2640,  13326,  13327,  13328,  13329,  13330,  13331,  13332,
    2641,  13333,  13334,  13335,  13336,   2642,  13337,  13338,
   13339,  13340,  13341,  13342,   2643,   2644,  13343,  13344,
    2645,  13345,  13346,  13347,   2646,  13348,  13349,  13350,
   13351,  13352,  13353,  13354,   2647,   2648,  13355,   2649,
   13356,   2650,  13357,  13358,  13359,  13360,  13361,  13362,
    2651,   2652,  13363,  13364,  13365,  13366,  13367,  13368,
    2653,  13369,  13370,  13371,  13372,  13373,  13374,  13375,
    2654,  13376,  13377,   2655,  13378,   2656,  13379,  13380,
   13381,  13382,  13383,  13384,   2657,   2658,  13385,  13386,
    2659,  13387,  13388,  13389,   2660,   2661,  13390,  13391,
   13392,  13393,  13394,  13395,   2662,   2663,  13396,   2664,
   13397,   2665,  13398,  13399,  13400,  13401,  13402,  13403,
   13404,  13405,  13406,  13407,  13408,  13409,  13410,  13411,
   13412,  13413,  13414,  13415,  13416,  13417,  13418,  13419,
   13420,  13421,  13422,  13423,  13424,  13425,  13426,  13427,
   13428,  13429,  13430,  13431,   2666,   2667,  13432,  13433,
    2668,  13434,  13435,   2669,   2670,  13436,  13437,  13438,
   13439,  13440,  13441,   2671,   2672,   2673,  13442,   2674,
   13443,   2675,  13444,  13445,  13446,  13447,   2676,  13448,
    2677,   2678,  13449,   2679,   2680,  13450,  13451,  13452,
    2681,  13453,  13454,  13455,  13456,  13457,  13458,  13459,
    2682,   2683,  13460,  13461,   2684,   2685,  13462,  13463,
   13464,  13465,  13466,   2686,   2687,   2688,  13467,  13468,
    2689,  13469,  13470,  13471,   2690,  13472,  13473,  13474,
   13475,  13476,  13477,  13478,   2691,   2692,  13479,  13480,
    2693,   2694,  13481,  13482,  13483,  13484,  13485,  13486,
   13487,  13488,  13489,  13490,  13491,  13492,  13493,  13494,
   13495,  13496,  13497,  13498,  13499,  13500,  13501,  13502,
   13503,  13504,  13505,  13506,  13507,   2695,  13508,  13509,
   13510,  13511,  13512,  13513,  13514,  13515,  13516,  13517,
   13518,  13519,  13520,  13521,  13522,  13523,  13524,  13525,
   13526,  13527,  13528,  13529,  13530,  13531,  13532,  13533,
   13534,  13535,  13536,  13537,  13538,  13539,  13540,  13541,
    2696,   2697,  13542,  13543,   2698,  13544,  13545,  13546,
    2699,  13547,   2700,  13548,  13549,  13550,  13551,  13552,
    2701,   2702,  13553,  13554,   2703,   2704,  13555,  13556,
   13557,  13558,  13559,  13560,   2705,  13561,  13562,  13563,
    2706,  13564,  13565,  13566,   2707,  13567,  13568,  13569,
   13570,  13571,  13572,  13573,  13574,  13575,  13576,  13577,
   13578,  13579,  13580,  13581,  13582,  13583,  13584,  13585,
   13586,  13587,  13588,  13589,  13590,  13591,  13592,  13593,
   13594,  13595,  13596,  13597,  13598,  13599,  13600,  13601,
   13602,  13603,  13604,  13605,  13606,  13607,  13608,  13609,
   13610,  13611,  13612,  13613,  13614,  13615,  13616,  13617,
    2708,  13618,  13619,  13620,  13621,  13622,  13623,  13624,
   13625,  13626,  13627,  13628,  13629,  13630,  13631,  13632,
   13633,  13634,  13635,  13636,  13637,  13638,  13639,  13640,
    2709,   2710,  13641,  13642,   2711,  13643,  13644,   2712,
    2713,  13645,   2714,  13646,  13647,  13648,  13649,  13650,
    2715,   2716,  13651,  13652,  13653,   2717,  13654,  13655,
   13656,  13657,  13658,  13659,   2718,   2719,  13660,  13661,
    2720,  13662,  13663,  13664,  13665,  13666,  13667,  13668,
   13669,  13670,  13671,  13672,  13673,  13674,  13675,  13676,
    2721,  13677,  13678,  13679,  13680,  13681,  13682,  13683,
    2722,  13684,  13685,  13686,  13687,  13688,  13689,  13690,
   13691,  13692,  13693,  13694,  13695,  13696,  13697,  13698,
   13699,  13700,  13701,  13702,   2723,  13703,  13704,  13705,
   13706,  13707,  13708,  13709,   2724,  13710,  13711,  13712,
    2725,  13713,  13714,  13715,   2726,  13716,  13717,  13718,
   13719,  13720,  13721,  13722,   2727,   2728,  13723,  13724,
   13725,  13726,  13727,  13728,  13729,  13730,  13731,  13732,
    2729,  13733,  13734,  13735,  13736,  13737,  13738,  13739,
   13740,  13741,  13742,  13743,  13744,  13745,  13746,  13747,
   13748,  13749,  13750,  13751,  13752,  13753,  13754,  13755,
   13756,  13757,  13758,  13759,   2730,   2731,  13760,  13761,
    2732,  13762,  13763,  13764,   2733,  13765,  13766,  13767,
   13768,  13769,  13770,  13771,   2734,   2735,  13772,  13773,
   13774,   2736,  13775,  13776,  13777,  13778,  13779,  13780,
    2737,  13781,  13782,  13783,  13784,  13785,  13786,  13787,
   13788,  13789,  13790,  13791,  13792,  13793,  13794,  13795,
   13796,  13797,  13798,  13799,   2738,  13800,  13801,  13802,
   13803,  13804,  13805,  13806,   2739,  13807,  13808,  13809,
   13810,  13811,  13812,  13813,  13814,  13815,  13816,  13817,
   13818,  13819,  13820,  13821,  13822,  13823,  13824,  13825,
   13826,  13827,  13828,  13829,  13830,  13831,  13832,  13833,
    2740,  13834,  13835,  13836,   2741,  13837,  13838,  13839,
   13840,  13841,  13842,  13843,  13844,  13845,  13846,  13847,
   13848,  13849,  13850,  13851,  13852,  13853,  13854,  13855,
   13856,  13857,  13858,  13859,  13860,  13861,  13862,  13863,
   13864,  13865,  13866,  13867,  13868,  13869,  13870,  13871,
   13872,  13873,  13874,  13875,  13876,  13877,  13878,  13879,
   13880,   2742,  13881,  13882,  13883,  13884,  13885,  13886,
    2743,   2744,  13887,  13888,   2745,  13889,  13890,  13891,
    2746,  13892,   2747,  13893,  13894,  13895,  13896,   2748,
    2749,   2750,  13897,  13898,  13899,  13900,  13901,  13902,
   13903,  13904,  13905,  13906,   2751,  13907,  13908,  13909,
    2752,  13910,  13911,  13912,   2753,  13913,  13914,  13915,
   13916,  13917,  13918,  13919,   2754,  13920,  13921,  13922,
   13923,  13924,  13925,  13926,  13927,  13928,  13929,  13930,
    2755,   2756,  13931,  13932,   2757,  13933,  13934,  13935,
    2758,  13936,  13937,  13938,  13939,  13940,  13941,  13942,
    2759,   2760,  13943,   2761,  13944,   2762,  13945,  13946,
   13947,  13948,  13949,  13950,   2763,   2764,  13951,  13952,
    2765,   2766,   2767,  13953,   2768,   2769,   2770,  13954,
   13955,  13956,  13957,   2771,   2772,   2773,  13958,   2774,
    2775,   2776,  13959,  13960,  13961,   2777,   2778,  13962,
    2779,   2780,  13963,  13964,   2781,  13965,  13966,  13967,
    2782,  13968,  13969,  13970,  13971,  13972,  13973,  13974,
    2783,   2784,  13975,   2785,   2786,   2787,  13976,  13977,
   13978,  13979,  13980,  13981,   2788,   2789,  13982,  13983,
    2790,  13984,  13985,  13986,   2791,  13987,  13988,   2792,
   13989,  13990,  13991,  13992,   2793,   2794,  13993,   2795,
   13994,   2796,  13995,  13996,  13997,   2797,  13998,   2798,
    2799,  13999,  14000,  14001,   2800,  14002,  14003,  14004,
    2801,  14005,  14006,  14007,  14008,  14009,  14010,  14011,
   14012,   2802,  14013,  14014,  14015,  14016,  14017,  14018,
   14019,  14020,  14021,  14022,   2803,   2804,  14023,  14024,
    2805,   2806,  14025,   2807,   2808,   2809,   2810,  14026,
   14027,  14028,  14029,  14030,   2811,   2812,   2813,   2814,
    2815,   2816,   2817,  14031,   2818,  14032,   2819,  14033,
    2820,   2821,  14034,  14035,   2822,  14036,  14037,  14038,
    2823,  14039,  14040,  14041,  14042,  14043,  14044,  14045,
    2824,   2825,  14046,   2826,  14047,   2827,  14048,  14049,
   14050,  14051,  14052,  14053,   2828,   2829,   2830,  14054,
    2831,  14055,  14056,  14057,   2832,  14058,   2833,   2834,
   14059,  14060,  14061,  14062,   2835,   2836,   2837,   2838,
    2839,   2840,  14063,  14064,  14065,   2841,   2842,   2843,
    2844,  14066,  14067,  14068,   2845,  14069,  14070,  14071,
    2846,  14072,  14073,  14074,  14075,  14076,  14077,  14078,
    2847,   2848,  14079,   2849,   2850,  14080,  14081,  14082,
   14083,  14084,  14085,  14086,   2851,   2852,  14087,  14088,
    2853,  14089,  14090,  14091,   2854,   2855,   2856,  14092,
    2857,  14093,  14094,   2858,   2859,   2860,  14095,   2861,
   14096,   2862,  14097,   2863,  14098,  14099,  14100,  14101,
    2864,   2865,  14102,  14103,   2866,  14104,  14105,  14106,
    2867,  14107,  14108,  14109,  14110,  14111,  14112,  14113,
    2868,   2869,  14114,   2870,   2871,   2872,  14115,  14116,
   14117,  14118,  14119,  14120,   2873,   2874,  14121,  14122,
    2875,  14123,  14124,  14125,  14126,  14127,  14128,  14129,
   14130,  14131,  14132,  14133,   2876,  14134,  14135,   2877,
   14136,   2878,  14137,  14138,  14139,  14140,  14141,  14142,
    2879,   2880,  14143,  14144,   2881,  14145,  14146,  14147,
    2882,  14148,  14149,  14150,  14151,  14152,  14153,  14154,
    2883,   2884,  14155,   2885,  14156,   2886,  14157,  14158,
   14159,  14160,  14161,  14162,   2887,   2888,  14163,  14164,
    2889,  14165,  14166,  14167,   2890,  14168,  14169,  14170,
   14171,  14172,  14173,  14174,   2891,   2892,  14175,   2893,
   14176,   2894,  14177,  14178,  14179,  14180,  14181,  14182,
    2895,   2896,  14183,  14184,   2897,  14185,  14186,  14187,
    2898,   2899,   2900,  14188,  14189,  14190,  14191,  14192,
    2901,   2902,  14193,   2903,  14194,   2904,  14195,  14196,
   14197,  14198,  14199,  14200,   2905,   2906,  14201,  14202,
    2907,  14203,  14204,  14205,   2908,  14206,  14207,  14208,
   14209,  14210,  14211,  14212,   2909,   2910,  14213,  14214,
    2911,   2912,  14215,  14216,  14217,  14218,  14219,  14220,
    2913,   2914,  14221,  14222,   2915,  14223,  14224,  14225,
    2916,  14226,  14227,  14228,  14229,  14230,  14231,  14232,
    2917,   2918,  14233,  14234,  14235,   2919,  14236,  14237,
   14238,  14239,  14240,  14241,   2920,   2921,  14242,  14243,
    2922,  14244,  14245,  14246,   2923,  14247,  14248,  14249,
   14250,  14251,  14252,  14253,   2924,   2925,  14254,   2926,
   14255,   2927,  14256,  14257,  14258,  14259,  14260,  14261,
    2928,   2929,  14262,  14263,   2930,  14264,  14265,  14266,
    2931,  14267,  14268,  14269,  14270,  14271,  14272,  14273,
    2932,   2933,  14274,   2934,  14275,   2935,  14276,   2936,
   14277,  14278,  14279,  14280,   2937,   2938,  14281,  14282,
    2939,  14283,  14284,  14285,   2940,  14286,  14287,  14288,
   14289,  14290,   2941,  14291,   2942,   2943,  14292,   2944,
   14293,   2945,   2946,   2947,   2948,   2949,   2950,   2951,
    2952,  14294,  14295,  14296,   2953,  14297,  14298,  14299,
    2954,  14300,  14301,  14302,  14303,  14304,  14305,  14306,
    2955,  14307,  14308,   2956,  14309,  14310,  14311,  14312,
   14313,  14314,  14315,  14316,   2957,   2958,  14317,  14318,
    2959,  14319,  14320,  14321,   2960,   2961,   2962,  14322,
   14323,  14324,  14325,   2963,   2964,   2965,  14326,   2966,
    2967,   2968,   2969,  14327,  14328,  14329,   2970,  14330,
    2971,   2972,  14331,  14332,   2973,  14333,   2974,   2975,
    2976,  14334,   2977,  14335,  14336,  14337,  14338,  14339,
    2978,   2979,  14340,   2980,   2981,   2982,   2983,  14341,
   14342,  14343,  14344,  14345,   2984,   2985,  14346,  14347,
    2986,  14348,  14349,  14350,   2987,  14351,  14352,  14353,
   14354,  14355,  14356,  14357,   2988,   2989,  14358,   2990,
    2991,   2992,  14359,  14360,  14361,  14362,  14363,  14364,
    2993,   2994,  14365,  14366,   2995,  14367,   2996,  14368,
    2997,  14369,  14370,  14371,  14372,  14373,  14374,  14375,
    2998,  14376,  14377,  14378,  14379,   2999,  14380,  14381,
   14382,  14383,  14384,  14385,   3000,  14386,  14387,  14388,
    3001,  14389,  14390,  14391,   3002,  14392,  14393,  14394,
   14395,  14396,  14397,  14398,  14399,  14400,  14401,  14402,
   14403,  14404,  14405,  14406,  14407,  14408,  14409,  14410,
    3003,   3004,  14411,  14412,   3005,  14413,  14414,  14415,
    3006,  14416,   3007,  14417,  14418,  14419,  14420,  14421,
    3008,   3009,  14422,   3010,  14423,   3011,   3012,  14424,
   14425,  14426,  14427,  14428,   3013,   3014,  14429,  14430,
    3015,  14431,  14432,  14433,   3016,  14434,  14435,  14436,
   14437,  14438,  14439,  14440,   3017,   3018,  14441,   3019,
   14442,   3020,  14443,  14444,  14445,  14446,  14447,  14448,
    3021,  14449,  14450,  14451,   3022,  14452,  14453,  14454,
    3023,  14455,  14456,  14457,  14458,  14459,  14460,  14461,
    3024,   3025,  14462,  14463,   3026,   3027,  14464,  14465,
   14466,  14467,  14468,  14469,   3028,  14470,  14471,  14472,
   14473,  14474,  14475,  14476,  14477,  14478,  14479,  14480,
   14481,  14482,  14483,  14484,  14485,  14486,  14487,  14488,
   14489,  14490,  14491,  14492,  14493,  14494,  14495,  14496,
    3029,   3030,  14497,  14498,   3031,  14499,  14500,  14501,
    3032,  14502,   3033,  14503,  14504,  14505,  14506,  14507,
    3034,   3035,  14508,   3036,  14509,   3037,   3038,   3039,
   14510,  14511,  14512,   3040,   3041,   3042,  14513,  14514,
   14515,  14516,  14517,  14518,   3043,  14519,  14520,  14521,
   14522,  14523,  14524,  14525,  14526,   3044,  14527,   3045,
   14528,   3046,  14529,  14530,  14531,  14532,  14533,  14534,
    3047,  14535,  14536,  14537,  14538,  14539,  14540,  14541,
   14542,  14543,  14544,  14545,  14546,  14547,  14548,  14549,
   14550,  14551,  14552,  14553,   3048,   3049,  14554,  14555,
   14556,  14557,  14558,  14559,   3050,  14560,  14561,  14562,
    3051,  14563,  14564,  14565,   3052,  14566,  14567,  14568,
   14569,  14570,  14571,  14572,   3053,   3054,  14573,   3055,
   14574,   3056,  14575,  14576,  14577,  14578,  14579,  14580,
    3057,   3058,  14581,  14582,   3059,  14583,  14584,  14585,
   14586,  14587,  14588,  14589,  14590,  14591,  14592,  14593,
   14594,  14595,  14596,  14597,  14598,   3060,  14599,  14600,
   14601,  14602,  14603,  14604,   3061,   3062,  14605,  14606,
    3063,  14607,  14608,  14609,   3064,   3065,   3066,  14610,
   14611,  14612,  14613,  14614,   3067,   3068,  14615,   3069,
   14616,   3070,  14617,  14618,  14619,  14620,  14621,  14622,
    3071,  14623,  14624,  14625,  14626,  14627,  14628,  14629,
   14630,  14631,  14632,  14633,  14634,  14635,  14636,  14637,
   14638,  14639,  14640,  14641,   3072,  14642,  14643,  14644,
   14645,  14646,  14647,  14648,   3073,  14649,  14650,  14651,
   14652,  14653,  14654,  14655,  14656,  14657,  14658,  14659,
   14660,  14661,  14662,  14663,  14664,  14665,  14666,  14667,
   14668,  14669,  14670,  14671,  14672,  14673,  14674,  14675,
    3074,   3075,  14676,  14677,   3076,  14678,  14679,  14680,
    3077,  14681,  14682,  14683,  14684,  14685,  14686,  14687,
    3078,   3079,  14688,   3080,  14689,  14690,  14691,  14692,
   14693,  14694,  14695,  14696,   3081,  14697,  14698,  14699,
    3082,  14700,  14701,  14702,   3083,  14703,  14704,  14705,
   14706,  14707,  14708,  14709,   3084,  14710,  14711,  14712,
   14713,  14714,  14715,  14716,  14717,  14718,  14719,  14720,
    3085,   3086,  14721,  14722,   3087,  14723,  14724,  14725,
    3088,  14726,  14727,  14728,  14729,  14730,  14731,  14732,
    3089,   3090,  14733,   3091,  14734,   3092,  14735,  14736,
   14737,  14738,  14739,  14740,  14741,  14742,  14743,  14744,
   14745,  14746,  14747,  14748,  14749,  14750,  14751,  14752,
   14753,  14754,  14755,  14756,  14757,  14758,  14759,  14760,
   14761,  14762,  14763,  14764,  14765,  14766,  14767,  14768,
    3093,   3094,  14769,  14770,   3095,  14771,  14772,   3096,
    3097,  14773,   3098,  14774,  14775,  14776,  14777,  14778,
    3099,   3100,  14779,   3101,  14780,   3102,   3103,  14781,
   14782,   3104,   3105,  14783,   3106,   3107,  14784,  14785,
    3108,  14786,   3109,  14787,   3110,  14788,  14789,   3111,
   14790,  14791,  14792,  14793,   3112,   3113,  14794,   3114,
    3115,   3116,  14795,  14796,  14797,  14798,  14799,  14800,
    3117,   3118,  14801,  14802,   3119,  14803,  14804,  14805,
    3120,  14806,  14807,  14808,  14809,  14810,  14811,  14812,
    3121,   3122,  14813,   3123,   3124,   3125,  14814,  14815,
   14816,  14817,  14818,  14819,   3126,  14820,  14821,  14822,
    3127,  14823,  14824,  14825,  14826,  14827,  14828,  14829,
   14830,  14831,  14832,  14833,  14834,  14835,  14836,  14837,
   14838,   3128,  14839,  14840,  14841,  14842,  14843,  14844,
   14845,  14846,  14847,  14848,  14849,  14850,  14851,  14852,
   14853,  14854,  14855,  14856,  14857,  14858,  14859,  14860,
   14861,  14862,  14863,  14864,  14865,  14866,  14867,  14868,
   14869,  14870,  14871,  14872,   3129,   3130,  14873,  14874,
    3131,  14875,  14876,  14877,   3132,  14878,  14879,  14880,
   14881,  14882,  14883,  14884,   3133,   3134,  14885,   3135,
    3136,   3137,  14886,  14887,  14888,  14889,  14890,  14891,
    3138,  14892,  14893,  14894,  14895,  14896,  14897,  14898,
   14899,  14900,  14901,  14902,  14903,  14904,  14905,  14906,
   14907,  14908,  14909,  14910,  14911,   3139,  14912,  14913,
   14914,  14915,  14916,  14917,   3140,  14918,  14919,  14920,
   14921,  14922,  14923,  14924,  14925,  14926,  14927,  14928,
   14929,  14930,  14931,  14932,  14933,  14934,  14935,  14936,
    3141,  14937,  14938,  14939,  14940,  14941,  14942,  14943,
   14944,  14945,  14946,  14947,  14948,  14949,  14950,  14951,
   14952,  14953,  14954,  14955,  14956,  14957,  14958,  14959,
   14960,  14961,  14962,  14963,  14964,  14965,  14966,  14967,
   14968,  14969,  14970,  14971,   3142,   3143,  14972,  14973,
    3144,  14974,  14975,  14976,   3145,  14977,  14978,  14979,
   14980,  14981,  14982,  14983,   3146,   3147,  14984,   3148,
   14985,   3149,  14986,   3150,  14987,  14988,  14989,  14990,
    3151,   3152,  14991,  14992,  14993,  14994,  14995,  14996,
    3153,  14997,  14998,  14999,  15000,  15001,  15002,  15003,
   15004,  15005,  15006,  15007,   3154,  15008,  15009,  15010,
   15011,  15012,  15013,  15014,   3155,  15015,  15016,  15017,
   15018,  15019,  15020,  15021,  15022,  15023,  15024,  15025,
   15026,  15027,  15028,  15029,  15030,  15031,  15032,  15033,
    3156,  15034,  15035,  15036,  15037,  15038,  15039,  15040,
    3157,  15041,  15042,  15043,   3158,  15044,  15045,  15046,
    3159,  15047,  15048,  15049,  15050,  15051,  15052,  15053,
    3160,   3161,  15054,  15055,  15056,  15057,  15058,  15059,
   15060,  15061,  15062,  15063,  15064,  15065,  15066,  15067,
   15068,  15069,  15070,  15071,  15072,  15073,  15074,  15075,
   15076,  15077,  15078,  15079,  15080,  15081,  15082,  15083,
   15084,   3162,  15085,  15086,  15087,  15088,  15089,  15090,
    3163,   3164,  15091,  15092,   3165,  15093,  15094,  15095,
    3166,  15096,  15097,  15098,  15099,  15100,  15101,  15102,
    3167,   3168,  15103,  15104,  15105,   3169,  15106,  15107,
   15108,  15109,  15110,  15111,   3170,  15112,  15113,  15114,
   15115,  15116,  15117,  15118,  15119,  15120,  15121,  15122,
   15123,  15124,  15125,  15126,  15127,  15128,  15129,  15130,
    3171,   3172,  15131,  15132,  15133,  15134,  15135,  15136,
   15137,  15138,  15139,  15140,  15141,  15142,  15143,  15144,
   15145,  15146,  15147,  15148,  15149,  15150,  15151,  15152,
   15153,  15154,  15155,  15156,  15157,  15158,  15159,  15160,
   15161,  15162,  15163,  15164,   3173,  15165,  15166,  15167,
   15168,  15169,  15170,  15171,  15172,  15173,  15174,  15175,
   15176,  15177,  15178,  15179,  15180,  15181,  15182,  15183,
   15184,  15185,  15186,  15187,  15188,  15189,  15190,  15191,
    3174,  15192,  15193,  15194,  15195,  15196,  15197,  15198,
   15199,  15200,  15201,  15202,  15203,  15204,  15205,  15206,
   15207,  15208,  15209,  15210,  15211,  15212,  15213,  15214,
   15215,  15216,  15217,  15218,   3175,  15219,  15220,  15221,
   15222,  15223,  15224,  15225,  15226,  15227,  15228,  15229,
   15230,  15231,  15232,  15233,   3176,  15234,  15235,   3177,
   15236,   3178,  15237,  15238,  15239,  15240,  15241,  15242,
   15243,  15244,  15245,  15246,  15247,  15248,  15249,  15250,
   15251,  15252,  15253,  15254,  15255,  15256,  15257,  15258,
   15259,  15260,  15261,  15262,  15263,  15264,  15265,  15266,
   15267,  15268,  15269,  15270,   3179,   3180,  15271,  15272,
    3181,  15273,  15274,  15275,   3182,  15276,  15277,  15278,
   15279,  15280,  15281,  15282,   3183,   3184,  15283,  15284,
   15285,   3185,   3186,  15286,  15287,  15288,  15289,   3187,
    3188,   3189,  15290,  15291,   3190,  15292,   3191,  15293,
    3192,  15294,  15295,  15296,  15297,  15298,  15299,  15300,
    3193,   3194,  15301,   3195,   3196,   3197,   3198,  15302,
   15303,  15304,  15305,  15306,   3199,   3200,  15307,  15308,
    3201,  15309,  15310,  15311,   3202,  15312,  15313,  15314,
   15315,  15316,  15317,  15318,   3203,   3204,  15319,   3205,
    3206,   3207,  15320,  15321,  15322,  15323,  15324,  15325,
    3208,  15326,  15327,  15328,   3209,  15329,   3210,  15330,
    3211,  15331,  15332,  15333,  15334,  15335,  15336,  15337,
    3212,  15338,  15339,  15340,  15341,   3213,  15342,  15343,
   15344,  15345,  15346,  15347,  15348,  15349,  15350,  15351,
   15352,  15353,  15354,  15355,  15356,  15357,  15358,  15359,
   15360,  15361,  15362,  15363,  15364,  15365,  15366,  15367,
   15368,  15369,  15370,  15371,  15372,  15373,  15374,  15375,
    3214,   3215,  15376,  15377,   3216,  15378,  15379,  15380,
    3217,  15381,  15382,  15383,  15384,  15385,  15386,  15387,
    3218,   3219,  15388,   3220,   3221,   3222,  15389,  15390,
   15391,  15392,  15393,  15394,   3223,   3224,  15395,  15396,
    3225,  15397,  15398,  15399,   3226,  15400,  15401,  15402,
   15403,  15404,  15405,  15406,   3227,   3228,  15407,   3229,
   15408,   3230,  15409,  15410,  15411,  15412,  15413,  15414,
    3231,  15415,  15416,  15417,   3232,  15418,  15419,  15420,
   15421,  15422,  15423,  15424,  15425,  15426,  15427,  15428,
   15429,  15430,  15431,  15432,   3233,  15433,  15434,  15435,
   15436,  15437,  15438,  15439,   3234,  15440,  15441,  15442,
    3235,  15443,  15444,  15445,  15446,  15447,  15448,  15449,
   15450,  15451,  15452,  15453,  15454,  15455,  15456,  15457,
   15458,   3236,  15459,  15460,  15461,  15462,  15463,  15464,
    3237,   3238,  15465,  15466,   3239,  15467,  15468,  15469,
    3240,  15470,  15471,  15472,  15473,  15474,  15475,  15476,
    3241,   3242,  15477,   3243,  15478,   3244,  15479,  15480,
   15481,  15482,  15483,  15484,   3245,  15485,  15486,  15487,
    3246,  15488,  15489,  15490,   3247,  15491,  15492,  15493,
   15494,  15495,  15496,  15497,  15498,  15499,  15500,  15501,
   15502,   3248,  15503,  15504,  15505,  15506,  15507,  15508,
   15509,  15510,  15511,  15512,  15513,  15514,  15515,  15516,
   15517,  15518,  15519,  15520,  15521,  15522,  15523,  15524,
   15525,  15526,  15527,  15528,  15529,  15530,  15531,  15532,
   15533,  15534,  15535,  15536,   3249,  15537,  15538,  15539,
    3250,  15540,  15541,  15542,   3251,  15543,  15544,  15545,
   15546,  15547,  15548,  15549,   3252,   3253,  15550,   3254,
   15551,   3255,  15552,  15553,  15554,  15555,  15556,  15557,
    3256,  15558,  15559,  15560,  15561,  15562,  15563,  15564,
   15565,  15566,  15567,  15568,  15569,  15570,  15571,  15572,
    3257,  15573,  15574,  15575,  15576,  15577,  15578,  15579,
   15580,  15581,  15582,  15583,   3258,   3259,  15584,  15585,
    3260,  15586,  15587,  15588,   3261,  15589,  15590,  15591,
   15592,  15593,  15594,  15595,   3262,   3263,  15596,   3264,
   15597,   3265,  15598,  15599,  15600,  15601,  15602,  15603,
    3266,  15604,  15605,  15606,  15607,  15608,  15609,  15610,
   15611,  15612,  15613,  15614,  15615,  15616,  15617,  15618,
   15619,  15620,  15621,  15622,   3267,  15623,  15624,  15625,
   15626,  15627,  15628,  15629,   3268,  15630,  15631,  15632,
    3269,  15633,  15634,  15635,  15636,  15637,  15638,  15639,
   15640,  15641,  15642,  15643,  15644,  15645,  15646,  15647,
   15648,  15649,  15650,  15651,  15652,  15653,  15654,  15655,
    3270,  15656,  15657,  15658,   3271,  15659,  15660,  15661,
    3272,  15662,  15663,  15664,  15665,  15666,  15667,  15668,
    3273,   3274,  15669,   3275,  15670,   3276,  15671,  15672,
   15673,  15674,  15675,  15676,   3277,  15677,  15678,  15679,
    3278,  15680,  15681,  15682,   3279,  15683,  15684,  15685,
   15686,  15687,  15688,  15689,   3280,  15690,  15691,  15692,
   15693,   3281,  15694,  15695,  15696,  15697,  15698,  15699,
    3282,   3283,  15700,  15701,   3284,  15702,  15703,  15704,
    3285,  15705,  15706,  15707,  15708,  15709,  15710,  15711,
    3286,   3287,  15712,   3288,  15713,   3289,  15714,  15715,
   15716,  15717,  15718,  15719,  15720,  15721,  15722,  15723,
   15724,  15725,  15726,  15727,  15728,  15729,  15730,  15731,
   15732,  15733,  15734,  15735,  15736,  15737,  15738,  15739,
   15740,  15741,  15742,  15743,  15744,  15745,  15746,  15747,
    3290,   3291,  15748,  15749,   3292,  15750,  15751,   3293,
    3294,   3295,  15752,  15753,  15754,  15755,  15756,  15757,
    3296,   3297,  15758,   3298,  15759,   3299,  15760,  15761,
   15762,  15763,  15764,  15765,   3300,   3301,  15766,  15767,
    3302,  15768,  15769,  15770,   3303,  15771,  15772,  15773,
   15774,  15775,  15776,  15777,   3304,   3305,  15778,   3306,
   15779,   3307,  15780,  15781,  15782,  15783,  15784,  15785,
    3308,   3309,  15786,  15787,   3310,  15788,  15789,  15790,
    3311,  15791,  15792,  15793,  15794,  15795,  15796,  15797,
    3312,   3313,  15798,   3314,   3315,   3316,  15799,  15800,
   15801,  15802,  15803,  15804,   3317,   3318,  15805,  15806,
   15807,  15808,  15809,  15810,  15811,  15812,  15813,  15814,
   15815,  15816,  15817,  15818,  15819,  15820,  15821,  15822,
   15823,   3319,  15824,  15825,  15826,  15827,  15828,  15829,
   15830,  15831,  15832,  15833,  15834,  15835,  15836,  15837,
   15838,  15839,  15840,  15841,  15842,  15843,  15844,  15845,
   15846,  15847,  15848,  15849,  15850,  15851,  15852,  15853,
   15854,  15855,  15856,  15857,   3320,   3321,  15858,  15859,
    3322,  15860,  15861,   3323,   3324,  15862,  15863,  15864,
   15865,  15866,  15867,  15868,   3325,   3326,  15869,   3327,
    3328,   3329,  15870,  15871,  15872,  15873,  15874,  15875,
    3330,   3331,  15876,  15877,   3332,  15878,  15879,  15880,
    3333,  15881,  15882,  15883,  15884,  15885,  15886,  15887,
    3334,   3335,  15888,   3336,  15889,   3337,  15890,  15891,
   15892,  15893,  15894,  15895,   3338,  15896,  15897,  15898,
    3339,  15899,  15900,  15901,   3340,  15902,  15903,  15904,
   15905,  15906,  15907,  15908,   3341,   3342,  15909,   3343,
    3344,   3345,  15910,  15911,  15912,  15913,  15914,  15915,
    3346,  15916,  15917,  15918,  15919,  15920,  15921,  15922,
   15923,  15924,  15925,  15926,  15927,  15928,  15929,  15930,
   15931,  15932,  15933,  15934,  15935,  15936,  15937,  15938,
   15939,  15940,  15941,  15942,   3347,   3348,  15943,  15944,
    3349,  15945,  15946,  15947,   3350,  15948,  15949,  15950,
   15951,  15952,  15953,  15954,   3351,   3352,  15955,   3353,
   15956,   3354,  15957,  15958,  15959,  15960,  15961,  15962,
    3355,   3356,  15963,  15964,   3357,  15965,  15966,  15967,
    3358,  15968,  15969,  15970,  15971,  15972,  15973,  15974,
    3359,  15975,  15976,  15977,  15978,   3360,  15979,  15980,
   15981,  15982,  15983,  15984,   3361,  15985,  15986,  15987,
   15988,  15989,  15990,  15991,  15992,  15993,  15994,  15995,
   15996,  15997,  15998,  15999,  16000,  16001,  16002,  16003,
   16004,   3362,  16005,  16006,  16007,  16008,  16009,  16010,
    3363,  16011,  16012,  16013,  16014,  16015,  16016,  16017,
    3364,  16018,  16019,  16020,  16021,  16022,  16023,  16024,
   16025,  16026,  16027,  16028,  16029,  16030,  16031,  16032,
   16033,  16034,  16035,  16036,   3365,  16037,  16038,  16039,
   16040,  16041,  16042,  16043,  16044,  16045,  16046,  16047,
   16048,  16049,  16050,  16051,  16052,  16053,  16054,  16055,
   16056,  16057,  16058,  16059,  16060,  16061,  16062,  16063,
    3366,   3367,  16064,  16065,   3368,  16066,  16067,  16068,
    3369,  16069,  16070,  16071,  16072,  16073,  16074,  16075,
    3370,   3371,  16076,   3372,  16077,   3373,  16078,  16079,
   16080,  16081,  16082,  16083,   3374,  16084,  16085,  16086,
    3375,  16087,  16088,  16089,   3376,  16090,  16091,  16092,
   16093,  16094,  16095,  16096,  16097,  16098,  16099,  16100,
   16101,   3377,  16102,  16103,  16104,  16105,  16106,  16107,
    3378,  16108,  16109,  16110,  16111,  16112,  16113,  16114,
   16115,  16116,  16117,  16118,  16119,  16120,  16121,  16122,
   16123,  16124,  16125,  16126,  16127,   3379,  16128,  16129,
   16130,  16131,  16132,  16133,   3380,   3381,  16134,  16135,
    3382,  16136,  16137,  16138,   3383,  16139,  16140,  16141,
   16142,  16143,  16144,  16145,   3384,   3385,  16146,   3386,
   16147,   3387,  16148,  16149,  16150,  16151,  16152,  16153,
    3388,  16154,  16155,  16156,   3389,  16157,  16158,  16159,
    3390,  16160,  16161,  16162,  16163,  16164,  16165,  16166,
    3391,  16167,  16168,  16169,  16170,  16171,  16172,  16173,
   16174,  16175,  16176,  16177,   3392,   3393,  16178,  16179,
    3394,  16180,  16181,  16182,   3395,  16183,  16184,  16185,
   16186,  16187,  16188,  16189,   3396,   3397,  16190,  16191,
   16192,   3398,  16193,  16194,  16195,  16196,  16197,  16198,
   16199,  16200,  16201,  16202,  16203,  16204,  16205,  16206,
   16207,  16208,  16209,  16210,  16211,  16212,  16213,  16214,
   16215,  16216,  16217,  16218,  16219,  16220,  16221,  16222,
   16223,  16224,  16225,  16226,   3399,   3400,  16227,  16228,
    3401,  16229,  16230,  16231,   3402,  16232,  16233,  16234,
   16235,  16236,  16237,  16238,   3403,   3404,  16239,   3405,
   16240,   3406,  16241,  16242,  16243,  16244,  16245,  16246,
    3407,   3408,  16247,  16248,   3409,  16249,  16250,  16251,
    3410,   3411,  16252,  16253,  16254,  16255,  16256,  16257,
    3412,   3413,  16258,   3414,   3415,   3416,  16259,  16260,
   16261,  16262,  16263,  16264,   3417,   3418,  16265,  16266,
    3419,  16267,  16268,  16269,   3420,  16270,  16271,  16272,
   16273,  16274,  16275,  16276,   3421,   3422,  16277,   3423,
    3424,   3425,  16278,  16279,  16280,  16281,  16282,  16283,
    3426,  16284,  16285,  16286,  16287,  16288,  16289,  16290,
   16291,  16292,  16293,  16294,  16295,  16296,  16297,  16298,
   16299,  16300,  16301,  16302,  16303,   3427,  16304,  16305,
   16306,  16307,  16308,  16309,  16310,  16311,  16312,  16313,
   16314,  16315,  16316,  16317,  16318,  16319,  16320,  16321,
   16322,  16323,  16324,  16325,  16326,  16327,  16328,  16329,
   16330,  16331,  16332,  16333,  16334,  16335,  16336,  16337,
    3428,   3429,  16338,  16339,   3430,  16340,  16341,  16342,
    3431,  16343,   3432,  16344,  16345,  16346,  16347,  16348,
    3433,   3434,  16349,   3435,   3436,   3437,  16350,  16351,
   16352,  16353,  16354,  16355,   3438,   3439,  16356,  16357,
    3440,  16358,  16359,  16360,   3441,  16361,  16362,  16363,
   16364,  16365,  16366,  16367,   3442,   3443,  16368,   3444,
   16369,   3445,  16370,  16371,  16372,  16373,  16374,  16375,
    3446,  16376,  16377,  16378,   3447,  16379,  16380,  16381,
   16382,  16383,  16384,  16385,  16386,  16387,  16388,  16389,
   16390,  16391,  16392,  16393,   3448,  16394,  16395,  16396,
   16397,  16398,  16399,  16400,   3449,  16401,  16402,  16403,
    3450,  16404,  16405,  16406,  16407,  16408,  16409,  16410,
   16411,  16412,  16413,  16414,  16415,  16416,  16417,  16418,
   16419,  16420,  16421,  16422,  16423,  16424,  16425,  16426,
    3451,   3452,  16427,  16428,   3453,  16429,  16430,  16431,
    3454,  16432,  16433,  16434,  16435,  16436,  16437,  16438,
    3455,   3456,  16439,   3457,  16440,   3458,  16441,  16442,
   16443,  16444,   3459,  16445,   3460,  16446,  16447,  16448,
    3461,  16449,  16450,  16451,  16452,  16453,  16454,  16455,
   16456,  16457,  16458,  16459,  16460,  16461,  16462,  16463,
   16464,  16465,  16466,  16467,  16468,  16469,  16470,  16471,
    3462,  16472,  16473,  16474,  16475,  16476,  16477,  16478,
   16479,  16480,  16481,  16482,  16483,  16484,  16485,  16486,
   16487,  16488,  16489,  16490,  16491,  16492,  16493,  16494,
   16495,  16496,  16497,  16498,   3463,  16499,  16500,  16501,
    3464,  16502,  16503,  16504,  16505,  16506,  16507,  16508,
   16509,  16510,  16511,  16512,  16513,  16514,  16515,   3465,
   16516,   3466,  16517,  16518,  16519,  16520,  16521,  16522,
    3467,  16523,  16524,  16525,  16526,  16527,  16528,  16529,
   16530,  16531,  16532,  16533,  16534,  16535,  16536,  16537,
   16538,  16539,  16540,  16541,  16542,  16543,  16544,  16545,
   16546,  16547,  16548,  16549,   3468,   3469,  16550,  16551,
    3470,  16552,  16553,  16554,   3471,  16555,  16556,  16557,
   16558,  16559,  16560,  16561,   3472,   3473,  16562,   3474,
   16563,   3475,  16564,  16565,  16566,  16567,  16568,  16569,
    3476,  16570,  16571,  16572,  16573,  16574,  16575,  16576,
   16577,  16578,  16579,  16580,  16581,  16582,  16583,  16584,
   16585,  16586,  16587,  16588,   3477,  16589,  16590,  16591,
   16592,  16593,  16594,  16595,   3478,  16596,  16597,  16598,
   16599,  16600,  16601,  16602,  16603,  16604,  16605,  16606,
   16607,  16608,  16609,  16610,  16611,  16612,  16613,  16614,
   16615,  16616,  16617,  16618,  16619,  16620,  16621,  16622,
    3479,   3480,  16623,  16624,   3481,  16625,  16626,  16627,
    3482,  16628,  16629,  16630,  16631,  16632,  16633,  16634,
    3483,   3484,  16635,  16636,  16637,   3485,  16638,  16639,
   16640,  16641,  16642,  16643,   3486,  16644,  16645,  16646,
    3487,  16647,  16648,  16649,   3488,  16650,  16651,  16652,
   16653,  16654,  16655,  16656,   3489,  16657,  16658,  16659,
   16660,   3490,  16661,  16662,  16663,  16664,  16665,  16666,
    3491,   3492,  16667,  16668,   3493,  16669,  16670,   3494,
    3495,  16671,   3496,  16672,  16673,  16674,  16675,  16676,
    3497,   3498,  16677,   3499,  16678,  16679,  16680,  16681,
   16682,  16683,  16684,  16685,   3500,  16686,  16687,  16688,
    3501,  16689,  16690,  16691,   3502,  16692,  16693,  16694,
   16695,  16696,  16697,  16698,   3503,   3504,  16699,  16700,
   16701,  16702,  16703,  16704,  16705,  16706,  16707,  16708,
    3505,   3506,  16709,  16710,   3507,  16711,  16712,  16713,
    3508,  16714,  16715,  16716,  16717,  16718,  16719,  16720,
    3509,   3510,  16721,   3511,  16722,   3512,  16723,  16724,
   16725,  16726,  16727,  16728,   3513,   3514,   3515,  16729,
    3516,  16730,  16731,  16732,   3517,  16733,   3518,  16734,
   16735,  16736,  16737,  16738,   3519,   3520,  16739,   3521,
    3522,   3523,  16740,  16741,  16742,   3524,  16743,  16744,
    3525,   3526,  16745,  16746,   3527,  16747,  16748,  16749,
    3528,  16750,  16751,  16752,  16753,  16754,  16755,  16756,
    3529,   3530,  16757,   3531,   3532,   3533,  16758,  16759,
   16760,  16761,  16762,  16763,   3534,   3535,  16764,  16765,
   16766,  16767,  16768,  16769,  16770,  16771,  16772,  16773,
   16774,  16775,  16776,  16777,  16778,  16779,  16780,  16781,
   16782,  16783,  16784,  16785,  16786,  16787,  16788,  16789,
   16790,  16791,  16792,  16793,  16794,  16795,  16796,  16797,
   16798,  16799,  16800,  16801,  16802,  16803,  16804,  16805,
   16806,  16807,  16808,  16809,  16810,  16811,  16812,  16813,
   16814,  16815,  16816,  16817,   3536,   3537,  16818,  16819,
    3538,  16820,  16821,  16822,   3539,  16823,  16824,  16825,
   16826,  16827,  16828,  16829,   3540,   3541,  16830,   3542,
    3543,   3544,  16831,  16832,  16833,  16834,  16835,  16836,
    3545,   3546,  16837,  16838,   3547,  16839,  16840,  16841,
    3548,  16842,  16843,  16844,  16845,  16846,  16847,  16848,
    3549,   3550,  16849,   3551,  16850,   3552,  16851,  16852,
   16853,  16854,  16855,  16856,   3553,  16857,  16858,  16859,
    3554,  16860,  16861,  16862,   3555,  16863,  16864,  16865,
   16866,  16867,  16868,  16869,   3556,   3557,  16870,  16871,
    3558,   3559,  16872,  16873,  16874,  16875,  16876,  16877,
    3560,  16878,  16879,  16880,  16881,  16882,  16883,  16884,
    3561,  16885,  16886,  16887,  16888,  16889,  16890,  16891,
   16892,   3562,  16893,   3563,  16894,  16895,  16896,  16897,
   16898,  16899,  16900,  16901,   3564,   3565,  16902,  16903,
    3566,  16904,  16905,  16906,   3567,  16907,  16908,  16909,
   16910,  16911,  16912,  16913,   3568,   3569,  16914,   3570,
   16915,   3571,  16916,  16917,  16918,  16919,  16920,  16921,
    3572,  16922,  16923,  16924,  16925,  16926,  16927,  16928,
   16929,  16930,  16931,  16932,  16933,  16934,  16935,  16936,
   16937,  16938,  16939,  16940,  16941,   3573,  16942,  16943,
   16944,  16945,  16946,  16947,  16948,  16949,  16950,  16951,
   16952,  16953,  16954,  16955,  16956,  16957,  16958,  16959,
   16960,  16961,  16962,  16963,  16964,  16965,  16966,  16967,
   16968,  16969,  16970,  16971,  16972,  16973,  16974,  16975,
    3574,  16976,  16977,  16978,   3575,  16979,  16980,  16981,
   16982,  16983,  16984,  16985,  16986,  16987,  16988,  16989,
   16990,  16991,  16992,  16993,  16994,  16995,  16996,  16997,
   16998,  16999,  17000,  17001,   3576,  17002,  17003,  17004,
    3577,  17005,  17006,  17007,   3578,  17008,  17009,  17010,
   17011,  17012,  17013,  17014,  17015,   3579,  17016,   3580,
   17017,  17018,  17019,  17020,  17021,  17022,  17023,  17024,
    3581,   3582,  17025,  17026,   3583,  17027,  17028,   3584,
    3585,  17029,   3586,  17030,  17031,  17032,  17033,  17034,
    3587,   3588,  17035,   3589,  17036,   3590,  17037,  17038,
   17039,  17040,  17041,  17042,   3591,  17043,  17044,  17045,
   17046,  17047,  17048,  17049,  17050,  17051,  17052,  17053,
   17054,  17055,  17056,  17057,  17058,  17059,  17060,  17061,
   17062,   3592,  17063,  17064,  17065,  17066,  17067,  17068,
   17069,  17070,  17071,  17072,  17073,  17074,  17075,  17076,
   17077,  17078,  17079,  17080,  17081,  17082,  17083,  17084,
   17085,  17086,  17087,  17088,  17089,  17090,  17091,  17092,
   17093,  17094,  17095,  17096,   3593,  17097,  17098,  17099,
    3594,  17100,  17101,  17102,   3595,  17103,  17104,  17105,
   17106,  17107,  17108,  17109,   3596,  17110,  17111,   3597,
   17112,  17113,  17114,  17115,  17116,  17117,  17118,  17119,
    3598,  17120,  17121,  17122,   3599,  17123,  17124,  17125,
    3600,  17126,  17127,  17128,  17129,  17130,  17131,  17132,
    3601,  17133,  17134,   3602,  17135,   3603,  17136,  17137,
   17138,  17139,  17140,  17141,   3604,  17142,  17143,  17144,
    3605,  17145,  17146,  17147,   3606,  17148,  17149,  17150,
   17151,  17152,  17153,  17154,   3607,   3608,  17155,   3609,
   17156,  17157,  17158,  17159,  17160,  17161,  17162,  17163,
   17164,  17165,  17166,  17167,  17168,  17169,  17170,  17171,
   17172,  17173,  17174,  17175,  17176,  17177,  17178,  17179,
   17180,  17181,  17182,  17183,  17184,  17185,  17186,  17187,
   17188,  17189,  17190,  17191,   3610,   3611,  17192,  17193,
    3612,  17194,  17195,  17196,   3613,  17197,  17198,  17199,
   17200,  17201,  17202,  17203,   3614,   3615,  17204,   3616,
   17205,   3617,  17206,  17207,  17208,  17209,  17210,  17211,
    3618,   3619,  17212,  17213,   3620,  17214,  17215,  17216,
    3621,  17217,  17218,  17219,  17220,   3622,  17221,  17222,
    3623,   3624,  17223,   3625,  17224,   3626,  17225,  17226,
   17227,  17228,  17229,  17230,   3627,   3628,  17231,  17232,
    3629,  17233,  17234,  17235,   3630,  17236,  17237,  17238,
   17239,  17240,  17241,  17242,   3631,   3632,  17243,   3633,
    3634,   3635,  17244,  17245,  17246,  17247,  17248,  17249,
    3636,  17250,  17251,  17252,  17253,  17254,  17255,  17256,
   17257,  17258,  17259,  17260,  17261,  17262,  17263,  17264,
   17265,  17266,  17267,  17268,  17269,   3637,  17270,  17271,
   17272,  17273,  17274,  17275,  17276,  17277,  17278,  17279,
   17280,  17281,  17282,  17283,  17284,  17285,  17286,  17287,
   17288,  17289,  17290,  17291,  17292,  17293,  17294,  17295,
   17296,  17297,  17298,  17299,  17300,  17301,  17302,  17303,
    3638,   3639,  17304,  17305,   3640,  17306,  17307,  17308,
    3641,  17309,   3642,  17310,  17311,  17312,  17313,  17314,
    3643,   3644,  17315,   3645,  17316,   3646,  17317,  17318,
   17319,  17320,  17321,  17322,   3647,   3648,  17323,  17324,
    3649,  17325,  17326,  17327,   3650,  17328,  17329,  17330,
   17331,  17332,  17333,  17334,   3651,   3652,  17335,   3653,
   17336,   3654,  17337,  17338,  17339,  17340,  17341,  17342,
    3655,   3656,  17343,  17344,   3657,  17345,  17346,  17347,
    3658,  17348,  17349,  17350,  17351,  17352,  17353,  17354,
    3659,   3660,  17355,   3661,   3662,   3663,  17356,  17357,
   17358,  17359,  17360,  17361,   3664,  17362,  17363,  17364,
    3665,  17365,  17366,  17367,   3666,  17368,  17369,  17370,
   17371,  17372,  17373,  17374,  17375,   3667,  17376,  17377,
   17378,  17379,  17380,  17381,  17382,  17383,  17384,  17385,
    3668,   3669,  17386,  17387,   3670,  17388,  17389,  17390,
    3671,  17391,  17392,  17393,  17394,   3672,  17395,  17396,
    3673,   3674,  17397,   3675,  17398,   3676,  17399,  17400,
   17401,   3677,  17402,  17403,   3678,   3679,  17404,  17405,
    3680,  17406,  17407,  17408,   3681,  17409,  17410,  17411,
   17412,  17413,  17414,  17415,  17416,  17417,  17418,   3682,
   17419,   3683,  17420,  17421,  17422,  17423,  17424,  17425,
    3684,   3685,  17426,  17427,   3686,  17428,  17429,  17430,
   17431,  17432,  17433,  17434,  17435,  17436,  17437,  17438,
   17439,  17440,  17441,   3687,  17442,   3688,  17443,  17444,
   17445,  17446,  17447,  17448,   3689,   3690,  17449,  17450,
    3691,  17451,  17452,  17453,   3692,  17454,  17455,  17456,
   17457,  17458,  17459,  17460,  17461,   3693,  17462,   3694,
   17463,   3695,  17464,  17465,  17466,  17467,  17468,  17469,
    3696,  17470,  17471,  17472,   3697,  17473,  17474,  17475,
    3698,  17476,  17477,  17478,  17479,  17480,  17481,  17482,
   17483,   3699,  17484,   3700,  17485,  17486,  17487,  17488,
   17489,  17490,  17491,  17492,   3701,   3702,  17493,  17494,
    3703,  17495,  17496,  17497,   3704,  17498,  17499,  17500,
   17501,   3705,  17502,  17503,   3706,  17504,  17505,   3707,
   17506,   3708,  17507,  17508,  17509,  17510,  17511,  17512,
    3709,  17513,  17514,  17515,   3710,  17516,  17517,  17518,
    3711,  17519,  17520,  17521,  17522,  17523,  17524,  17525,
    3712,  17526,  17527,  17528,  17529,   3713,  17530,  17531,
   17532,  17533,  17534,  17535,   3714,   3715,  17536,  17537,
    3716,  17538,  17539,  17540,   3717,  17541,  17542,  17543,
   17544,  17545,  17546,  17547,  17548,  17549,  17550,  17551,
   17552,   3718,  17553,  17554,  17555,  17556,  17557,  17558,
    3719,   3720,  17559,  17560,   3721,  17561,  17562,  17563,
    3722,  17564,  17565,  17566,  17567,  17568,  17569,  17570,
    3723,   3724,  17571,   3725,  17572,   3726,  17573,  17574,
   17575,  17576,  17577,  17578,   3727,   3728,  17579,  17580,
    3729,  17581,  17582,  17583,   3730,  17584,  17585,  17586,
   17587,  17588,  17589,  17590,   3731,  17591,  17592,   3732,
   17593,   3733,  17594,  17595,  17596,  17597,  17598,  17599,
    3734,   3735,  17600,  17601,   3736,  17602,   3737,   3738,
    3739,   3740,  17603,  17604,  17605,  17606,  17607,  17608,
    3741,   3742,  17609,   3743,  17610,   3744,  17611,  17612,
   17613,   3745,  17614,  17615,   3746,  17616,  17617,  17618,
    3747,  17619,  17620,  17621,   3748,  17622,  17623,  17624,
   17625,  17626,  17627,  17628,   3749,   3750,  17629,  17630,
   17631,   3751,  17632,  17633,  17634,  17635,  17636,  17637,
    3752,   3753,  17638,  17639,   3754,  17640,  17641,  17642,
    3755,  17643,  17644,  17645,  17646,  17647,  17648,  17649,
    3756,   3757,  17650,   3758,  17651,   3759,  17652,  17653,
   17654,  17655,  17656,  17657,
  // [0x00A1,0x00C6] -v # seg 1 at pos 11204
     107,     42,     43,    113,     44,  RCHAR,     54,      6,
   RCHAR,    660,  RCHAR,     93,      8,    164,  RCHAR,     37,
      29,    838,    839,     98,  RCHAR,    143,      3,    105,
     837,    669,  RCHAR,    746,    743,    747,    108,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    658,
  // [0x00D0,0x00E6] -v # seg 3 at pos 11242
     659,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,     30,
     667,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    670,    763,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    752,
  // [0x00F0,0x00FE] -v # seg 5 at pos 11265
     754,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,     31,
     761,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    764,
  // [0x0126,0x0127] -v # seg 9 at pos 11280
     661,    755,
  // [0x0131,0x0153] -v # seg 11 at pos 11282
     756,    663,    757,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    758,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    665,    759,
     666,    760,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     767,    672,    766,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    668,    762,
  // [0x0166,0x0167] -v # seg 13 at pos 11317
     671,    765,
  // [0x02C7,0x02C7] -> [   100,   100] # seg 15
  // [0x02D0,0x02D0] -> [   109,   109] # seg 17
  // [0x02D8,0x02DD] -v # seg 19 at pos 11319
     101,    104,    103,    106,     99,    102,
  // [0x0391,0x03A1] -> [   408,   424] # seg 21
  // [0x03A3,0x03A9] -> [   425,   431] # seg 23
  // [0x03B1,0x03C1] -> [   440,   456] # seg 25
  // [0x03C3,0x03C9] -> [   457,   463] # seg 27
  // [0x0401,0x0401] -> [  1040,  1040] # seg 29
  // [0x0410,0x0415] -> [  1034,  1039] # seg 31
  // [0x0430,0x0435] -> [  1082,  1087] # seg 33
  // [0x2013,0x2026] -v # seg 38 at pos 11325
       8,      9,      9,     10,  RCHAR,     13,     14,  RCHAR,
   RCHAR,     15,     16,  RCHAR,  RCHAR,    144,    145,  RCHAR,
   RCHAR,  RCHAR,      4,      5,
  // [0x2030,0x2033] -v # seg 40 at pos 11345
     115,  RCHAR,     38,     39,
  // [0x207F,0x2084] -v # seg 46 at pos 11349
     841,  RCHAR,    842,    843,    844,    845,
  // [0x2103,0x2109] -v # seg 50 at pos 11355
      40,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    114,
  // [0x2113,0x2116] -v # seg 52 at pos 11362
     567,  RCHAR,  RCHAR,    157,
  // [0x2121,0x212B] -v # seg 54 at pos 11366
     162,    159,  RCHAR,  RCHAR,  RCHAR,    620,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,     41,
  // [0x2153,0x215F] -v # seg 56 at pos 11377
     744,    745,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     748,    749,    750,    751,  RCHAR,
  // [0x2170,0x2179] -> [   376,   385] # seg 59
  // [0x2190,0x2199] -v # seg 61 at pos 11390
      70,     71,     69,     72,     73,    146,    149,    147,
     150,    148,
  // [0x21D2,0x21D4] -v # seg 63 at pos 11400
      94,  RCHAR,     95,
  // [0x2200,0x2211] -v # seg 65 at pos 11403
      96,  RCHAR,     50,     97,  RCHAR,  RCHAR,  RCHAR,     51,
      83,  RCHAR,  RCHAR,     84,  RCHAR,  RCHAR,  RCHAR,    112,
   RCHAR,    111,
  // [0x221A,0x223D] -v # seg 67 at pos 11421
      77,  RCHAR,  RCHAR,     79,     35,  RCHAR,     47,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,     10,  RCHAR,     91,     92,     90,
      89,     81,     82,  RCHAR,    110,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,     36,     80,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,     12,     78,
  // [0x2252,0x2252] -> [    53,    53] # seg 69
  // [0x2260,0x226B] -v # seg 71 at pos 11457
      32,     52,  RCHAR,  RCHAR,     33,     34,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,     75,     76,
  // [0x2282,0x2287] -v # seg 73 at pos 11469
      87,     88,  RCHAR,  RCHAR,     85,     86,
  // [0x2299,0x2299] -> [   126,   126] # seg 75
  // [0x22A5,0x22A5] -> [    48,    48] # seg 77
  // [0x2312,0x2312] -> [    49,    49] # seg 79
  // [0x2460,0x246E] -> [   728,   742] # seg 81
  // [0x2474,0x2482] -> [   822,   836] # seg 83
  // [0x249C,0x24B5] -> [   796,   821] # seg 85
  // [0x24D0,0x24E9] -> [   702,   727] # seg 87
  // [0x2500,0x2503] -v # seg 89 at pos 11475
     470,    481,    471,    482,
  // [0x250C,0x254B] -v # seg 91 at pos 11479
     472,    509,    508,    483,    473,    503,    502,    484,
     475,    507,    506,    486,    474,    505,    504,    485,
     476,    497,    510,    511,    492,    512,    513,    487,
     478,    499,    514,    515,    494,    516,    517,    489,
     477,    518,    519,    493,    498,    520,    521,    488,
     479,    522,    523,    495,    500,    524,    525,    490,
     480,    526,    527,    496,    528,    529,    501,    530,
     531,    532,    533,    534,    535,    536,    537,    491,
  // [0x2592,0x2592] -> [   131,   131] # seg 93
  // [0x25A0,0x25A9] -v # seg 95 at pos 11543
      64,     63,  RCHAR,    128,    132,    133,    136,    135,
     134,    137,
  // [0x25B2,0x25D1] -v # seg 97 at pos 11553
      66,     65,  RCHAR,  RCHAR,    119,    118,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,     68,     67,  RCHAR,  RCHAR,    117,    116,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,     62,     61,    127,    126,
   RCHAR,     58,  RCHAR,  RCHAR,     60,     59,    129,    130,
  // [0x2605,0x2606] -v # seg 99 at pos 11585
      57,     56,
  // [0x260E,0x260F] -v # seg 101 at pos 11587
     140,    139,
  // [0x261C,0x261E] -v # seg 103 at pos 11589
     141,  RCHAR,    142,
  // [0x2640,0x2642] -v # seg 105 at pos 11592
      46,  RCHAR,     45,
  // [0x2660,0x266D] -v # seg 107 at pos 11595
     121,    122,  RCHAR,    125,    120,    123,  RCHAR,    124,
     138,    152,    153,  RCHAR,    154,    151,
  // [0x3041,0x3093] -> [   846,   928] # seg 111
  // [0x321C,0x321C] -> [   156,   156] # seg 120
  // [0x3260,0x327B] -> [   674,   701] # seg 122
  // [0x327F,0x327F] -> [   155,   155] # seg 124
  // [0x3380,0x3398] -v # seg 126 at pos 11609
     604,    605,    606,    607,    608,  RCHAR,  RCHAR,  RCHAR,
     589,    590,    623,    624,    625,    585,    586,    587,
     615,    616,    617,    618,    619,    564,    565,    566,
     568,
  // [0x33A3,0x33AF] -v # seg 128 at pos 11634
     570,    571,    572,    573,    592,    593,    632,    633,
     634,    635,    628,    629,    630,
  // [0x33BA,0x33DD] -v # seg 130 at pos 11647
     609,    610,    611,    612,    613,    614,    621,    622,
     160,    639,    569,    627,    642,    158,    591,    640,
     584,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    588,    637,  RCHAR,
   RCHAR,    638,  RCHAR,  RCHAR,    626,  RCHAR,    161,  RCHAR,
   RCHAR,    631,    641,    636,
  // [0x4E00,0x4E1E] -v # seg 132 at pos 11683
    7122,   7374,  RCHAR,   8039,  RCHAR,  RCHAR,  RCHAR,   5187,
    7202,   5845,   5857,   8298,  RCHAR,   5629,  RCHAR,  RCHAR,
   RCHAR,   7963,  RCHAR,  RCHAR,   7713,   5703,   6021,  RCHAR,
    4317,   5561,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6213,
  // [0x4E2D,0x4E5F] -v # seg 134 at pos 11714
    7592,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4225,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8568,   4700,  RCHAR,   7530,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6628,   4617,  RCHAR,
    4318,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7612,  RCHAR,
    5764,   8485,   8296,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4279,  RCHAR,   6214,   7019,  RCHAR,  RCHAR,  RCHAR,
    4319,   4034,   6396,
  // [0x4E6B,0x4EAE] -v # seg 136 at pos 11765
    3918,  RCHAR,   4837,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6926,  RCHAR,  RCHAR,   5612,   5840,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4022,  RCHAR,  RCHAR,  RCHAR,   4902,
   RCHAR,  RCHAR,  RCHAR,   5066,  RCHAR,   6479,  RCHAR,  RCHAR,
    5765,   7052,  RCHAR,   6812,  RCHAR,   6868,   6853,   8486,
   RCHAR,   6652,   7375,  RCHAR,  RCHAR,   4487,  RCHAR,  RCHAR,
    5766,  RCHAR,  RCHAR,   6309,  RCHAR,  RCHAR,   5213,   8352,
   RCHAR,   4292,   8369,   6503,  RCHAR,   8456,  RCHAR,  RCHAR,
    8394,   4081,   7376,   4940,
  // [0x4EB6,0x4EE5] -v # seg 138 at pos 11833
    4701,  RCHAR,  RCHAR,  RCHAR,   7098,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6304,   7099,  RCHAR,  RCHAR,   8006,  RCHAR,
   RCHAR,   4320,  RCHAR,  RCHAR,   4466,   3978,  RCHAR,   7147,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7151,   5767,
    8055,   7203,   5630,   5946,  RCHAR,  RCHAR,  RCHAR,   4839,
   RCHAR,   7822,  RCHAR,  RCHAR,  RCHAR,   4758,   5002,   7053,
  // [0x4EF0,0x4F01] -v # seg 140 at pos 11881
    6367,  RCHAR,   7593,  RCHAR,  RCHAR,  RCHAR,   4023,   3979,
   RCHAR,  RCHAR,  RCHAR,   7131,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4491,
  // [0x4F09,0x4F11] -v # seg 142 at pos 11899
    8353,   7054,   4480,  RCHAR,   6653,   4492,   5594,   5524,
    8691,
  // [0x4F2F,0x4F5C] -v # seg 144 at pos 11908
    5506,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5422,  RCHAR,   5003,
   RCHAR,   6266,  RCHAR,   5768,  RCHAR,   5769,   3854,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7313,  RCHAR,  RCHAR,   4702,
    7260,   8224,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6901,   7261,
    7531,   7524,   6813,  RCHAR,  RCHAR,  RCHAR,   8299,  RCHAR,
   RCHAR,  RCHAR,   6480,   7123,   5693,   7177,
  // [0x4F69,0x4F9D] -v # seg 146 at pos 11954
    8182,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6417,   5507,
   RCHAR,  RCHAR,   3855,  RCHAR,  RCHAR,   4556,  RCHAR,  RCHAR,
   RCHAR,   7314,  RCHAR,  RCHAR,  RCHAR,   7124,   5770,  RCHAR,
    6267,  RCHAR,   3894,   7686,  RCHAR,   4933,  RCHAR,   8011,
   RCHAR,   4263,   5020,  RCHAR,   6223,  RCHAR,   7532,  RCHAR,
    6927,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5109,  RCHAR,   7714,
   RCHAR,  RCHAR,   4209,  RCHAR,   7033,
  // [0x4FAE,0x4FB6] -v # seg 148 at pos 12007
    5281,   8652,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8042,
    4953,
  // [0x4FBF,0x4FE1] -v # seg 150 at pos 12016
    8198,  RCHAR,  RCHAR,   4126,   7916,   6310,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6654,   7572,  RCHAR,  RCHAR,  RCHAR,   7452,
   RCHAR,  RCHAR,   6788,  RCHAR,   4082,   8418,  RCHAR,  RCHAR,
    6067,  RCHAR,  RCHAR,   5129,  RCHAR,  RCHAR,   5578,  RCHAR,
    5771,   8444,   6268,
  // [0x4FEE,0x4FFA] -v # seg 152 at pos 12051
    6098,   5631,  RCHAR,   4321,  RCHAR,   5487,  RCHAR,   8258,
   RCHAR,  RCHAR,   5613,  RCHAR,   6470,
  // [0x5002,0x502D] -v # seg 154 at pos 12064
    5562,  RCHAR,  RCHAR,  RCHAR,   4941,  RCHAR,  RCHAR,   7765,
   RCHAR,   3980,  RCHAR,   5486,  RCHAR,  RCHAR,  RCHAR,   5353,
    4777,  RCHAR,  RCHAR,  RCHAR,   8389,  RCHAR,  RCHAR,   8653,
    7034,  RCHAR,   7807,  RCHAR,   4083,   7715,  RCHAR,   7766,
   RCHAR,   5458,   8012,  RCHAR,   4393,   7507,   4005,  RCHAR,
    6629,   5110,   8069,   6735,
  // [0x503B,0x503B] -> [  6397,  6397] # seg 156
  // [0x5043,0x505C] -v # seg 158 at pos 12108
    6462,  RCHAR,  RCHAR,  RCHAR,   3856,   4048,   6902,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8199,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8370,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7533,
   RCHAR,   7377,
  // [0x5065,0x5065] -> [  4024,  4024] # seg 160
  // [0x5074,0x5078] -v # seg 162 at pos 12134
    8005,   7378,   6814,  RCHAR,   8145,
  // [0x5080,0x5085] -v # seg 164 at pos 12139
    4280,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5632,
  // [0x508D,0x5099] -v # seg 166 at pos 12145
    5459,  RCHAR,  RCHAR,  RCHAR,   4035,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5828,   5704,
  // [0x50AC,0x50ED] -v # seg 168 at pos 12158
    7937,   6789,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6655,   7315,
   RCHAR,   7787,  RCHAR,   5858,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4084,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4450,  RCHAR,  RCHAR,  RCHAR,   7851,   5947,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5859,  RCHAR,   4293,  RCHAR,  RCHAR,
   RCHAR,   5595,   8721,  RCHAR,  RCHAR,  RCHAR,   5067,  RCHAR,
   RCHAR,  RCHAR,   6903,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6746,  RCHAR,   6215,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7755,
  // [0x50F9,0x5109] -v # seg 170 at pos 12224
    3857,  RCHAR,   5539,  RCHAR,  RCHAR,  RCHAR,   5772,   7035,
    7573,  RCHAR,  RCHAR,   6457,  RCHAR,   4085,  RCHAR,  RCHAR,
    4038,
  // [0x5112,0x5112] -> [  6928,  6928] # seg 172
  // [0x511F,0x5121] -v # seg 174 at pos 12241
    5860,  RCHAR,   5058,
  // [0x512A,0x512A] -> [  6815,  6815] # seg 176
  // [0x5132,0x5152] -v # seg 178 at pos 12244
    7262,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4954,  RCHAR,  RCHAR,
    4562,  RCHAR,   6471,  RCHAR,  RCHAR,  RCHAR,   6693,   6990,
   RCHAR,   6871,   8457,   7981,   7453,   8699,   5948,   4264,
   RCHAR,   4443,   8109,   5252,   8128,  RCHAR,  RCHAR,  RCHAR,
    6311,
  // [0x515C,0x5197] -v # seg 180 at pos 12277
    4856,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4488,  RCHAR,
   RCHAR,   7142,  RCHAR,   4619,   7316,   4942,   6929,   8179,
    4210,   5106,   8476,  RCHAR,  RCHAR,   4211,  RCHAR,  RCHAR,
   RCHAR,   5563,   4493,   4322,   7317,  RCHAR,  RCHAR,  RCHAR,
    4075,  RCHAR,  RCHAR,  RCHAR,   4494,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6478,  RCHAR,  RCHAR,  RCHAR,   7799,  RCHAR,
   RCHAR,   7239,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5282,  RCHAR,
   RCHAR,   5253,  RCHAR,   6790,
  // [0x51A0,0x51AC] -v # seg 182 at pos 12337
    4243,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5265,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5250,  RCHAR,   4840,
  // [0x51B6,0x51CD] -v # seg 184 at pos 12350
    6398,   4937,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4990,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7803,  RCHAR,
    7574,  RCHAR,  RCHAR,   4943,  RCHAR,   7454,   5123,   4841,
  // [0x51DC,0x51E1] -v # seg 186 at pos 12374
    5122,   7029,   8722,  RCHAR,  RCHAR,   5528,
  // [0x51F0,0x523B] -v # seg 188 at pos 12380
    8590,   3981,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8700,  RCHAR,
    7841,   6747,   7978,  RCHAR,  RCHAR,   8333,  RCHAR,  RCHAR,
    4778,  RCHAR,  RCHAR,   7100,  RCHAR,  RCHAR,   5673,   7354,
    6631,  RCHAR,   3895,  RCHAR,  RCHAR,  RCHAR,   5354,  RCHAR,
   RCHAR,   8458,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4991,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7889,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8170,   5557,  RCHAR,  RCHAR,
   RCHAR,   5130,   5829,  RCHAR,  RCHAR,  RCHAR,   4259,  RCHAR,
    4779,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7429,   6091,
    4394,   7750,   7152,   3883,
  // [0x5243,0x5261] -v # seg 190 at pos 12456
    7880,  RCHAR,  RCHAR,  RCHAR,   8035,  RCHAR,  RCHAR,   5824,
    4444,   4910,   7318,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7809,  RCHAR,   5633,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    3954,  RCHAR,   5403,  RCHAR,  RCHAR,  RCHAR,   5991,
  // [0x5269,0x5275] -v # seg 192 at pos 12487
    7148,   7319,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5634,  RCHAR,
   RCHAR,   8331,  RCHAR,  RCHAR,   7767,
  // [0x527D,0x5292] -v # seg 194 at pos 12500
    8259,  RCHAR,   7890,  RCHAR,  RCHAR,  RCHAR,   8634,  RCHAR,
   RCHAR,  RCHAR,   4445,   5540,   5092,  RCHAR,  RCHAR,  RCHAR,
    4039,  RCHAR,  RCHAR,  RCHAR,   7430,   4040,
  // [0x529B,0x52AB] -v # seg 196 at pos 12522
    4971,  RCHAR,  RCHAR,  RCHAR,   4212,   3858,  RCHAR,  RCHAR,
    4992,   4451,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7455,   4634,
    4045,
  // [0x52BE,0x52E4] -v # seg 198 at pos 12539
    8387,  RCHAR,  RCHAR,   4086,  RCHAR,   5447,  RCHAR,   8036,
   RCHAR,   6791,  RCHAR,   5254,  RCHAR,  RCHAR,  RCHAR,   4087,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5120,  RCHAR,  RCHAR,   4842,
    6844,  RCHAR,   3928,   5329,  RCHAR,   8665,  RCHAR,   6216,
    5025,   5283,  RCHAR,  RCHAR,   6022,   7288,   4452,
  // [0x52F3,0x532F] -v # seg 200 at pos 12578
    8666,  RCHAR,   4955,  RCHAR,  RCHAR,   4395,  RCHAR,   7178,
    4435,  RCHAR,  RCHAR,   4323,   5365,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8225,  RCHAR,  RCHAR,   8701,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8226,  RCHAR,   8227,   5596,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5705,   8548,   5672,  RCHAR,   6224,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7204,   4265,  RCHAR,
    3948,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5706,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8614,
  // [0x5339,0x5384] -v # seg 202 at pos 12639
    8286,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4696,   4324,
    6305,  RCHAR,   7823,   7143,  RCHAR,  RCHAR,   6217,   6656,
    8680,   5423,  RCHAR,  RCHAR,   5188,  RCHAR,  RCHAR,  RCHAR,
    5707,   7504,   8070,   8445,  RCHAR,  RCHAR,   4596,  RCHAR,
   RCHAR,   5404,  RCHAR,   5597,  RCHAR,   5551,  RCHAR,   7362,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4276,  RCHAR,   5978,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5317,   7101,
    6904,  RCHAR,  RCHAR,   3884,   4903,  RCHAR,   4396,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7596,  RCHAR,   4088,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6385,
  // [0x5393,0x53AD] -v # seg 204 at pos 12715
    6374,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5131,  RCHAR,   8654,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6872,   8007,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4403,   8300,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6569,
  // [0x53BB,0x53BB] -> [  4006,  4006] # seg 206
  // [0x53C3,0x53F8] -v # seg 208 at pos 12742
    7756,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6816,   7716,   4481,
    6817,  RCHAR,   5424,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6159,  RCHAR,   7991,   6099,  RCHAR,  RCHAR,  RCHAR,
    5425,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6632,   7926,
    4325,   4150,   4326,  RCHAR,  RCHAR,  RCHAR,   4151,   7613,
    4420,   6030,   8180,  RCHAR,   3859,   8110,   7687,   5773,
    6818,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5774,
  // [0x5403,0x5411] -v # seg 210 at pos 12796
    8709,   3885,  RCHAR,  RCHAR,  RCHAR,   8345,   4557,   7289,
   RCHAR,   4843,   5266,   8655,   5132,   8129,   8395,
  // [0x541B,0x542B] -v # seg 212 at pos 12811
    4377,  RCHAR,   5155,  RCHAR,   7020,   8214,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5635,  RCHAR,  RCHAR,   5674,  RCHAR,
    8334,
  // [0x5433,0x5451] -v # seg 214 at pos 12828
    6658,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8716,   7992,  RCHAR,
    5355,   8656,  RCHAR,   6657,  RCHAR,  RCHAR,  RCHAR,   4956,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7379,  RCHAR,   4152,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8085,
  // [0x5468,0x5490] -v # seg 216 at pos 12859
    7537,  RCHAR,   7536,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4153,  RCHAR,   5368,  RCHAR,   3860,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6269,   8487,   5267,  RCHAR,  RCHAR,
    7263,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8228,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8549,  RCHAR,   4327,  RCHAR,
    5636,
  // [0x54A4,0x54C9] -v # seg 218 at pos 12900
    8056,  RCHAR,  RCHAR,  RCHAR,   7153,  RCHAR,  RCHAR,   7614,
    4294,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8371,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8335,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7103,  RCHAR,  RCHAR,   6375,   8272,  RCHAR,  RCHAR,
    8538,  RCHAR,  RCHAR,  RCHAR,   8346,   7240,
  // [0x54E1,0x54F2] -v # seg 220 at pos 12938
    6873,  RCHAR,  RCHAR,  RCHAR,   3861,  RCHAR,  RCHAR,   7891,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4189,   8639,  RCHAR,  RCHAR,
   RCHAR,   7842,
  // [0x54FA,0x54FA] -> [  8229,  8229] # seg 222
  // [0x5504,0x5510] -v # seg 224 at pos 12956
    8183,  RCHAR,   5775,   7651,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5133,  RCHAR,   4747,
  // [0x551C,0x551C] -> [  5206,  5206] # seg 226
  // [0x552F,0x5535] -v # seg 228 at pos 12969
    6931,  RCHAR,   7768,  RCHAR,  RCHAR,  RCHAR,   6355,
  // [0x553E,0x5546] -v # seg 230 at pos 12976
    8057,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8071,  RCHAR,
    5861,
  // [0x554F,0x5556] -v # seg 232 at pos 12985
    5356,  RCHAR,  RCHAR,  RCHAR,   4127,  RCHAR,  RCHAR,   4725,
  // [0x555E,0x5563] -v # seg 234 at pos 12993
    6312,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8336,
  // [0x557C,0x558A] -v # seg 236 at pos 12999
    7431,  RCHAR,  RCHAR,  RCHAR,   3998,  RCHAR,  RCHAR,  RCHAR,
    5949,  RCHAR,   7843,   4883,  RCHAR,   8657,   8337,
  // [0x5598,0x559D] -v # seg 238 at pos 13014
    7824,   8681,   8569,  RCHAR,   8723,   3919,
  // [0x55A7,0x55AE] -v # seg 240 at pos 13020
    8676,  RCHAR,   6932,   5862,   4561,   4295,  RCHAR,   4703,
  // [0x55C5,0x55C7] -v # seg 242 at pos 13028
    8658,  RCHAR,   5891,
  // [0x55D4,0x55E4] -v # seg 244 at pos 13031
    7652,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6659,  RCHAR,
    4495,  RCHAR,  RCHAR,   7717,  RCHAR,  RCHAR,  RCHAR,   5776,
    8013,
  // [0x55FD,0x55FE] -v # seg 246 at pos 13048
    6100,   7538,
  // [0x5606,0x5609] -v # seg 248 at pos 13050
    8086,  RCHAR,  RCHAR,   3862,
  // [0x5614,0x5617] -v # seg 250 at pos 13054
    4328,  RCHAR,  RCHAR,   5863,
  // [0x562F,0x5636] -v # seg 252 at pos 13058
    6031,  RCHAR,  RCHAR,   7456,  RCHAR,   7993,  RCHAR,   6225,
  // [0x5653,0x5653] -> [  8403,  8403] # seg 254
  // [0x5668,0x566B] -v # seg 256 at pos 13066
    4496,  RCHAR,  RCHAR,   8724,
  // [0x5674,0x5674] -> [  5675,  5675] # seg 258
  // [0x5686,0x5686] -> [  8640,  8640] # seg 260
  // [0x56A5,0x56B4] -v # seg 262 at pos 13070
    6516,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5746,
   RCHAR,   8396,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6472,
  // [0x56BC,0x56BC] -> [  7179,  7179] # seg 264
  // [0x56CA,0x56D1] -v # seg 266 at pos 13086
    4610,  RCHAR,  RCHAR,   8725,  RCHAR,  RCHAR,  RCHAR,   7917,
  // [0x56DA,0x56E0] -v # seg 268 at pos 13094
    6101,   5777,  RCHAR,  RCHAR,   8615,  RCHAR,   7104,
  // [0x56F0,0x56F0] -> [  4196,  4196] # seg 270
  // [0x56F9,0x56FA] -v # seg 272 at pos 13101
    5004,   4154,
  // [0x5703,0x571F] -v # seg 274 at pos 13103
    8230,   6447,  RCHAR,  RCHAR,  RCHAR,   4397,  RCHAR,  RCHAR,
    4371,  RCHAR,   6905,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6875,
    6874,  RCHAR,  RCHAR,   4780,  RCHAR,   4704,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8130,
  // [0x5728,0x5730] -v # seg 276 at pos 13132
    7241,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4421,  RCHAR,  RCHAR,
    7615,
  // [0x573B,0x5751] -v # seg 278 at pos 13141
    4497,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7616,  RCHAR,   8171,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4436,  RCHAR,  RCHAR,   5460,
   RCHAR,  RCHAR,   4726,   3929,  RCHAR,   7525,   4000,
  // [0x5761,0x578B] -v # seg 280 at pos 13164
    8154,  RCHAR,  RCHAR,   4197,  RCHAR,   8087,  RCHAR,  RCHAR,
   RCHAR,   8209,  RCHAR,  RCHAR,  RCHAR,   4760,  RCHAR,   4089,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4329,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8072,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6102,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4759,
   RCHAR,  RCHAR,   8459,
  // [0x5793,0x5793] -> [  8372,  8372] # seg 282
  // [0x57A0,0x57A3] -v # seg 284 at pos 13207
    7012,  RCHAR,   4330,   6876,
  // [0x57C3,0x57CE] -v # seg 286 at pos 13211
    6376,  RCHAR,  RCHAR,  RCHAR,   6792,   7575,  RCHAR,  RCHAR,
    5225,  RCHAR,  RCHAR,   6003,
  // [0x57DF,0x57E0] -v # seg 288 at pos 13223
    6505,   5637,
  // [0x57F0,0x580A] -v # seg 290 at pos 13225
    7788,  RCHAR,  RCHAR,  RCHAR,   6251,  RCHAR,  RCHAR,   7704,
   RCHAR,   5489,   4498,  RCHAR,   4499,  RCHAR,  RCHAR,  RCHAR,
    4383,  RCHAR,   4748,  RCHAR,  RCHAR,   4058,   8139,  RCHAR,
    3955,   6983,   6327,
  // [0x581E,0x583A] -v # seg 292 at pos 13252
    7861,  RCHAR,  RCHAR,   5579,  RCHAR,  RCHAR,   7432,  RCHAR,
   RCHAR,   6517,  RCHAR,  RCHAR,   3930,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6748,   6463,   5580,  RCHAR,  RCHAR,   7205,   4781,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4128,
  // [0x584A,0x5864] -v # seg 294 at pos 13281
    4281,   6590,  RCHAR,  RCHAR,  RCHAR,   3982,  RCHAR,   6032,
   RCHAR,  RCHAR,   8101,  RCHAR,  RCHAR,   4782,   4749,  RCHAR,
    7927,  RCHAR,  RCHAR,  RCHAR,   5888,  RCHAR,  RCHAR,   7320,
    6660,  RCHAR,   8667,
  // [0x5875,0x5889] -v # seg 296 at pos 13308
    7653,  RCHAR,  RCHAR,  RCHAR,   7757,  RCHAR,  RCHAR,   7321,
   RCHAR,   6160,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4090,  RCHAR,
    5901,  RCHAR,  RCHAR,  RCHAR,   6793,
  // [0x5893,0x5893] -> [  5318,  5318] # seg 298
  // [0x589C,0x589F] -v # seg 300 at pos 13329
    7940,  RCHAR,   7601,   8404,
  // [0x58A8,0x58EF] -v # seg 302 at pos 13333
    5351,   4827,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8058,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5676,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6661,   7206,  RCHAR,  RCHAR,   3896,  RCHAR,
   RCHAR,   5541,  RCHAR,  RCHAR,  RCHAR,   6694,  RCHAR,   4705,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8668,  RCHAR,
   RCHAR,   8312,  RCHAR,   6363,  RCHAR,   8488,  RCHAR,  RCHAR,
    5079,   4266,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4282,   5051,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6420,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5778,   7132,  RCHAR,  RCHAR,   7207,
  // [0x58F9,0x58FD] -v # seg 304 at pos 13405
    7125,   8489,   5902,  RCHAR,   6103,
  // [0x590F,0x598A] -v # seg 306 at pos 13410
    8301,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4500,   5931,   6739,
   RCHAR,  RCHAR,   6161,   4698,  RCHAR,   6399,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5314,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4761,  RCHAR,   7825,   8111,   5638,  RCHAR,   6749,   6368,
   RCHAR,  RCHAR,   6290,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7057,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8446,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6473,  RCHAR,  RCHAR,
    4501,   4620,   5614,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4422,
    7539,   8570,   4129,  RCHAR,  RCHAR,   5677,   8414,  RCHAR,
    8146,  RCHAR,  RCHAR,   8373,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7322,  RCHAR,   5779,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6662,  RCHAR,  RCHAR,   8095,   6991,   7208,   5932,   5678,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4624,   4636,  RCHAR,  RCHAR,
   RCHAR,   3897,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8490,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6484,   5708,   5214,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7133,
  // [0x5993,0x5999] -v # seg 308 at pos 13534
    4502,  RCHAR,  RCHAR,   6750,   4467,  RCHAR,   5319,
  // [0x59A5,0x59AC] -v # seg 310 at pos 13541
    8059,  RCHAR,  RCHAR,   5461,  RCHAR,  RCHAR,  RCHAR,   8147,
  // [0x59B9,0x59DD] -v # seg 312 at pos 13549
    5226,  RCHAR,   7804,  RCHAR,  RCHAR,   7862,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7380,  RCHAR,  RCHAR,   5284,  RCHAR,  RCHAR,
    7154,  RCHAR,   6226,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7264,
    4155,  RCHAR,   6004,   6906,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7134,   6751,  RCHAR,   3956,   7534,
  // [0x59E6,0x59EE] -v # seg 314 at pos 13586
    3898,  RCHAR,   7058,  RCHAR,   7688,  RCHAR,   8726,  RCHAR,
    8354,
  // [0x59F8,0x5A03] -v # seg 316 at pos 13595
    6518,  RCHAR,  RCHAR,   7105,  RCHAR,  RCHAR,  RCHAR,   7155,
   RCHAR,   6907,  RCHAR,   6736,
  // [0x5A11,0x5A29] -v # seg 318 at pos 13607
    5780,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4611,
   RCHAR,  RCHAR,   6663,   4565,  RCHAR,  RCHAR,   6519,   6270,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6313,  RCHAR,  RCHAR,  RCHAR,
    5189,
  // [0x5A36,0x5A49] -v # seg 320 at pos 13632
    7994,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7769,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5080,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8155,  RCHAR,  RCHAR,   6711,
  // [0x5A5A,0x5A5A] -> [  8529,  8529] # seg 322
  // [0x5A62,0x5A66] -v # seg 324 at pos 13652
    5709,  RCHAR,  RCHAR,  RCHAR,   5639,
  // [0x5A92,0x5A92] -> [  5227,  5227] # seg 326
  // [0x5A9A,0x5A9B] -v # seg 328 at pos 13657
    5369,   6877,
  // [0x5AA4,0x5AA4] -> [  6227,  6227] # seg 330
  // [0x5AC1,0x5ACC] -v # seg 332 at pos 13659
    3863,   6104,  RCHAR,   6878,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7689,  RCHAR,  RCHAR,   8443,
  // [0x5AE1,0x5AE9] -v # seg 334 at pos 13671
    7290,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8355,  RCHAR,  RCHAR,
    4681,
  // [0x5B05,0x5B0C] -v # seg 336 at pos 13680
    8550,  RCHAR,  RCHAR,  RCHAR,   8727,  RCHAR,   5950,   4296,
  // [0x5B16,0x5B16] -> [  8215,  8215] # seg 338
  // [0x5B2A,0x5B2A] -> [  5747,  5747] # seg 340
  // [0x5B40,0x5B43] -v # seg 342 at pos 13688
    5864,  RCHAR,  RCHAR,   6421,
  // [0x5B50,0x5B7C] -v # seg 344 at pos 13692
    7156,   8439,  RCHAR,  RCHAR,   4213,   7149,  RCHAR,   7157,
    7502,  RCHAR,   5640,  RCHAR,   7158,   8641,  RCHAR,   5244,
   RCHAR,  RCHAR,  RCHAR,   4130,   4156,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   8374,  RCHAR,   6076,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6162,   7190,  RCHAR,  RCHAR,  RCHAR,   5641,  RCHAR,  RCHAR,
    8313,  RCHAR,   6933,  RCHAR,   6468,
  // [0x5B85,0x5C19] -v # seg 346 at pos 13737
    4774,  RCHAR,   6819,   6105,   6341,  RCHAR,   6083,   6712,
   RCHAR,  RCHAR,   4288,  RCHAR,  RCHAR,  RCHAR,   5598,  RCHAR,
    8104,   8636,   7508,   4244,   7540,   7381,   6713,   7036,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3999,   5951,   6291,
    6934,   8571,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6005,
   RCHAR,   4387,  RCHAR,   7242,  RCHAR,  RCHAR,   8375,   6520,
    6033,   3864,  RCHAR,   6271,   6794,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6163,   7789,  RCHAR,   7291,   6879,   4503,
    7106,   5400,   4331,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5642,
   RCHAR,  RCHAR,  RCHAR,   5228,  RCHAR,   8317,   6820,   6252,
   RCHAR,  RCHAR,   4633,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5181,   7751,  RCHAR,   4226,   8043,  RCHAR,   6664,
    6752,   6292,   4632,   7790,   6294,  RCHAR,   5781,   4245,
   RCHAR,   5068,   7576,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7928,   5581,  RCHAR,   7922,  RCHAR,   5782,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5615,  RCHAR,  RCHAR,   5783,
   RCHAR,  RCHAR,   7209,   7323,   6908,   7503,   6295,  RCHAR,
    4762,   4783,   6034,  RCHAR,   6035,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7852,  RCHAR,  RCHAR,   5865,
  // [0x5C24,0x5C28] -v # seg 348 at pos 13886
    6821,  RCHAR,  RCHAR,  RCHAR,   5462,
  // [0x5C31,0x5C71] -v # seg 350 at pos 13891
    7995,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6228,
    6992,   7810,   4157,   4694,  RCHAR,   5370,   4672,   4372,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4007,   4131,  RCHAR,   4384,
   RCHAR,  RCHAR,   6682,  RCHAR,   6230,   6229,  RCHAR,  RCHAR,
    5979,  RCHAR,  RCHAR,  RCHAR,   7324,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5564,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4784,
   RCHAR,   5081,  RCHAR,   8010,   5134,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6068,  RCHAR,  RCHAR,   4867,  RCHAR,
    5830,
  // [0x5C79,0x5C79] -> [  8710,  8710] # seg 352
  // [0x5C90,0x5C91] -v # seg 354 at pos 13956
    4504,   7195,
  // [0x5CA1,0x5CA1] -> [  3957,  3957] # seg 356
  // [0x5CA9,0x5CC0] -v # seg 358 at pos 13958
    6356,  RCHAR,   6106,   3949,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4763,  RCHAR,   6328,  RCHAR,   8491,  RCHAR,   5387,   6342,
   RCHAR,   5006,  RCHAR,  RCHAR,  RCHAR,   7363,  RCHAR,   6107,
  // [0x5CD9,0x5CE0] -v # seg 360 at pos 13982
    8014,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5866,
  // [0x5CE8,0x5CFD] -v # seg 362 at pos 13990
    6314,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5616,
    5617,  RCHAR,  RCHAR,  RCHAR,   8419,  RCHAR,   4785,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7577,  RCHAR,   8447,
  // [0x5D07,0x5D19] -v # seg 364 at pos 14012
    6202,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4934,   4505,
   RCHAR,  RCHAR,   4198,  RCHAR,  RCHAR,   7938,  RCHAR,   6377,
    3958,  RCHAR,   5111,
  // [0x5D27,0x5D29] -v # seg 366 at pos 14031
    6203,  RCHAR,   5697,
  // [0x5D4B,0x5D50] -v # seg 368 at pos 14034
    5371,   3931,  RCHAR,  RCHAR,  RCHAR,   4912,
  // [0x5D69,0x5D6F] -v # seg 370 at pos 14040
    6204,  RCHAR,  RCHAR,   6740,  RCHAR,  RCHAR,   7718,
  // [0x5D87,0x5D8B] -v # seg 372 at pos 14047
    4332,  RCHAR,  RCHAR,  RCHAR,   4786,
  // [0x5D9D,0x5DA2] -v # seg 374 at pos 14052
    4874,  RCHAR,  RCHAR,   4297,  RCHAR,   6755,
  // [0x5DAA,0x5DAA] -> [  6476,  6476] # seg 376
  // [0x5DB8,0x5DBD] -v # seg 378 at pos 14058
    6593,  RCHAR,   5007,  RCHAR,   5903,   6329,
  // [0x5DCD,0x5E1D] -v # seg 380 at pos 14064
    6741,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5190,  RCHAR,  RCHAR,
   RCHAR,   6357,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7826,   7541,  RCHAR,  RCHAR,   6171,   6036,  RCHAR,  RCHAR,
    4214,   7526,   4298,   4008,  RCHAR,  RCHAR,   5330,  RCHAR,
   RCHAR,   7719,  RCHAR,  RCHAR,   4506,   7060,   5784,   8156,
   RCHAR,  RCHAR,   8356,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6077,   4025,  RCHAR,  RCHAR,  RCHAR,   6231,   8231,  RCHAR,
   RCHAR,   5529,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8728,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8105,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7863,  RCHAR,  RCHAR,   7690,  RCHAR,   5508,  RCHAR,
    7433,
  // [0x5E25,0x5E4C] -v # seg 382 at pos 14145
    6108,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5785,  RCHAR,
    5933,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7210,  RCHAR,
   RCHAR,   4764,  RCHAR,   5867,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5285,  RCHAR,   8659,   7382,  RCHAR,  RCHAR,  RCHAR,   6330,
    8252,  RCHAR,   5463,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8591,
  // [0x5E55,0x5E55] -> [  5182,  5182] # seg 384
  // [0x5E5F,0x5E63] -v # seg 386 at pos 14185
    8015,  RCHAR,   5514,   4750,   8216,
  // [0x5E72,0x5EAD] -v # seg 388 at pos 14190
    3899,   8210,   4625,  RCHAR,  RCHAR,   5565,   8390,   3900,
   RCHAR,   8572,   6935,   6936,   4507,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7211,  RCHAR,  RCHAR,   5710,  RCHAR,  RCHAR,
    5868,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5904,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7265,  RCHAR,   7364,  RCHAR,  RCHAR,
    4091,  RCHAR,   5643,  RCHAR,  RCHAR,  RCHAR,   5869,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4787,   7527,  RCHAR,  RCHAR,
   RCHAR,   4158,  RCHAR,   7383,
  // [0x5EB5,0x5EE3] -v # seg 390 at pos 14250
    6358,   5905,   3959,   6795,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6937,  RCHAR,  RCHAR,  RCHAR,   5870,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8302,   4996,   4925,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4333,  RCHAR,  RCHAR,   4238,  RCHAR,
   RCHAR,   5069,  RCHAR,  RCHAR,  RCHAR,   7542,   7325,  RCHAR,
   RCHAR,  RCHAR,   5320,   7770,  RCHAR,   8217,   4267,
  // [0x5EEC,0x5F29] -v # seg 392 at pos 14297
    4957,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7871,
   RCHAR,  RCHAR,   6522,   7384,  RCHAR,  RCHAR,   4026,   8616,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5552,  RCHAR,  RCHAR,
    5052,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8218,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6253,  RCHAR,   6232,  RCHAR,   4388,
    7457,   7107,  RCHAR,   5694,   8539,  RCHAR,  RCHAR,   7061,
   RCHAR,  RCHAR,  RCHAR,   7434,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8420,   8492,  RCHAR,   4637,
  // [0x5F31,0x5F3C] -v # seg 394 at pos 14359
    6407,  RCHAR,  RCHAR,  RCHAR,   7212,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   3960,  RCHAR,   8287,
  // [0x5F48,0x5F4E] -v # seg 396 at pos 14371
    8088,  RCHAR,   3961,  RCHAR,   5372,  RCHAR,   5191,
  // [0x5F56,0x5FCD] -v # seg 398 at pos 14378
    4706,   8477,  RCHAR,   8683,  RCHAR,   7062,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8460,  RCHAR,  RCHAR,  RCHAR,
    6464,   6845,  RCHAR,   7791,   8260,   7458,   5748,   8193,
   RCHAR,  RCHAR,   7771,   6594,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5464,  RCHAR,   6506,  RCHAR,  RCHAR,   8279,  RCHAR,
   RCHAR,   5695,   6730,   7385,  RCHAR,  RCHAR,  RCHAR,   4765,
   RCHAR,   6172,  RCHAR,  RCHAR,   8617,   5115,   8660,  RCHAR,
   RCHAR,  RCHAR,   5906,   4092,   4788,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4873,   5490,   5786,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7509,  RCHAR,   4935,   6448,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8592,   5599,   6173,  RCHAR,  RCHAR,  RCHAR,
    5373,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7710,
   RCHAR,   4775,  RCHAR,   7844,  RCHAR,  RCHAR,  RCHAR,   8684,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6296,  RCHAR,   8288,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4508,   7108,
  // [0x5FD6,0x5FE0] -v # seg 400 at pos 14498
    7923,   7617,   5215,   5216,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7982,
  // [0x5FEB,0x5FEB] -> [  8054,  8054] # seg 402
  // [0x5FF5,0x5FF5] -> [  4628,  4628] # seg 404
  // [0x5FFD,0x5FFF] -v # seg 406 at pos 14509
    8535,  RCHAR,   5679,
  // [0x600F,0x602F] -v # seg 408 at pos 14512
    6369,  RCHAR,  RCHAR,   4638,  RCHAR,  RCHAR,  RCHAR,   8232,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5008,   5787,  RCHAR,
   RCHAR,   8112,   7063,  RCHAR,  RCHAR,  RCHAR,   4482,  RCHAR,
    6006,   6880,  RCHAR,   4283,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4046,
  // [0x6041,0x6043] -v # seg 410 at pos 14545
    7135,   6174,   6233,
  // [0x604D,0x6070] -v # seg 412 at pos 14548
    8593,  RCHAR,  RCHAR,   4215,  RCHAR,   8357,  RCHAR,  RCHAR,
    5907,  RCHAR,  RCHAR,  RCHAR,   6422,  RCHAR,  RCHAR,  RCHAR,
    4260,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8618,   7159,   8696,
    8016,  RCHAR,  RCHAR,   8318,   7013,   3886,  RCHAR,   4629,
    4216,  RCHAR,   6254,   8717,
  // [0x6085,0x60A7] -v # seg 414 at pos 14584
    6562,  RCHAR,  RCHAR,  RCHAR,   6293,  RCHAR,  RCHAR,   7435,
    8319,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8619,
   RCHAR,   8184,  RCHAR,  RCHAR,  RCHAR,   6084,   7326,  RCHAR,
   RCHAR,  RCHAR,   6665,   6938,  RCHAR,  RCHAR,   8573,   7929,
   RCHAR,  RCHAR,   5135,
  // [0x60B0,0x60BD] -v # seg 416 at pos 14619
    7510,  RCHAR,   5711,   4776,   7987,  RCHAR,   5388,  RCHAR,
    4132,  RCHAR,  RCHAR,  RCHAR,   4789,   7805,
  // [0x60C5,0x60C7] -v # seg 418 at pos 14633
    7386,  RCHAR,   4828,
  // [0x60D1,0x60D1] -> [  8526,  8526] # seg 420
  // [0x60DA,0x60E1] -v # seg 422 at pos 14636
    8536,  RCHAR,   5934,  RCHAR,  RCHAR,   6939,   8478,   6331,
  // [0x60F0,0x611F] -v # seg 424 at pos 14644
    8060,   4666,  RCHAR,   5871,  RCHAR,  RCHAR,   8594,  RCHAR,
   RCHAR,   6400,   6007,   8008,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6109,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4027,  RCHAR,
    6940,   6941,  RCHAR,  RCHAR,  RCHAR,   5389,   8197,   7037,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6332,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6822,   6378,  RCHAR,  RCHAR,  RCHAR,   3932,
  // [0x6127,0x6127] -> [  4284,  4284] # seg 426
  // [0x6130,0x6182] -v # seg 428 at pos 14692
    8595,  RCHAR,  RCHAR,  RCHAR,   7772,  RCHAR,  RCHAR,   3983,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6272,  RCHAR,   3984,   6881,
   RCHAR,  RCHAR,   6796,  RCHAR,   5116,  RCHAR,  RCHAR,   7014,
    7160,  RCHAR,   4076,   8113,   8596,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8261,  RCHAR,   5286,  RCHAR,  RCHAR,
    7758,   7759,  RCHAR,  RCHAR,  RCHAR,   8151,  RCHAR,   8132,
   RCHAR,  RCHAR,   5192,   4246,   3887,  RCHAR,  RCHAR,   8479,
    3985,  RCHAR,  RCHAR,   7511,  RCHAR,  RCHAR,   4958,  RCHAR,
    6909,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4093,   3962,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7811,   6782,  RCHAR,
   RCHAR,   7930,   6823,
  // [0x618A,0x619A] -v # seg 430 at pos 14775
    5712,  RCHAR,  RCHAR,  RCHAR,   7602,  RCHAR,   4978,   5760,
   RCHAR,  RCHAR,   7892,  RCHAR,  RCHAR,  RCHAR,   8730,   8729,
    8089,
  // [0x61A4,0x61CB] -v # seg 432 at pos 14792
    5680,  RCHAR,  RCHAR,   4844,  RCHAR,   4049,  RCHAR,   5390,
    4094,  RCHAR,   5331,  RCHAR,  RCHAR,  RCHAR,   8407,  RCHAR,
   RCHAR,  RCHAR,   6458,  RCHAR,  RCHAR,  RCHAR,   4727,  RCHAR,
   RCHAR,  RCHAR,   3933,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4453,
   RCHAR,  RCHAR,  RCHAR,   3901,   8376,   7030,   6667,   5332,
  // [0x61E6,0x61E6] -> [  4566,  4566] # seg 434
  // [0x61F2,0x6221] -v # seg 436 at pos 14832
    7711,  RCHAR,  RCHAR,  RCHAR,   4884,   8620,   8421,  RCHAR,
    7760,  RCHAR,   4334,  RCHAR,  RCHAR,   7038,   4979,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4751,   4227,  RCHAR,
    5333,  RCHAR,   6198,   6110,   7007,  RCHAR,   6008,   6315,
    4133,  RCHAR,  RCHAR,  RCHAR,   8527,  RCHAR,  RCHAR,  RCHAR,
    7812,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4446,  RCHAR,   3934,
  // [0x622A,0x6236] -v # seg 438 at pos 14880
    7355,  RCHAR,  RCHAR,  RCHAR,   5107,  RCHAR,   7327,   8731,
   RCHAR,  RCHAR,   4766,  RCHAR,   8493,
  // [0x623E,0x6258] -v # seg 440 at pos 14893
    4959,   5465,   6037,   8200,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5952,   8494,   5713,  RCHAR,   6111,  RCHAR,   7243,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8061,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8074,
  // [0x626E,0x629B] -v # seg 442 at pos 14920
    5681,  RCHAR,  RCHAR,   4483,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5645,  RCHAR,  RCHAR,   5714,  RCHAR,  RCHAR,   6386,  RCHAR,
   RCHAR,   6218,   4509,  RCHAR,  RCHAR,  RCHAR,   7893,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4069,   8157,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6459,   5908,  RCHAR,  RCHAR,   8148,
   RCHAR,   8358,   7356,  RCHAR,  RCHAR,   8233,
  // [0x62AB,0x62DC] -v # seg 444 at pos 14966
    8280,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8234,  RCHAR,
   RCHAR,  RCHAR,   7266,  RCHAR,  RCHAR,  RCHAR,   5207,  RCHAR,
   RCHAR,   6364,   7941,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5696,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5334,   4630,   4922,  RCHAR,
   RCHAR,   5426,   5405,  RCHAR,   4568,   4285,  RCHAR,   4009,
    7813,   5448,  RCHAR,   8062,   6756,   4335,   7505,  RCHAR,
    7894,   5491,
  // [0x62EC,0x6309] -v # seg 446 at pos 15016
    4261,   6255,   4558,   7604,  RCHAR,   4217,  RCHAR,   4398,
   RCHAR,  RCHAR,  RCHAR,   4159,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6209,   4569,  RCHAR,   7618,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7619,  RCHAR,   6343,
  // [0x6311,0x6311] -> [  4790,  4790] # seg 448
  // [0x632B,0x632F] -v # seg 450 at pos 15046
    7528,  RCHAR,  RCHAR,  RCHAR,   7654,
  // [0x633A,0x633E] -v # seg 452 at pos 15051
    7387,   6526,  RCHAR,   5193,   8448,
  // [0x6349,0x6355] -v # seg 454 at pos 15056
    7728,  RCHAR,  RCHAR,   8181,  RCHAR,  RCHAR,   4594,   6525,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8235,
  // [0x6367,0x63AA] -v # seg 456 at pos 15069
    5618,   5788,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4010,
   RCHAR,  RCHAR,  RCHAR,   4399,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7864,  RCHAR,  RCHAR,   4595,   4631,  RCHAR,  RCHAR,  RCHAR,
    5909,  RCHAR,  RCHAR,  RCHAR,   6038,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6112,   4791,  RCHAR,  RCHAR,   7213,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5492,  RCHAR,  RCHAR,  RCHAR,   6387,
   RCHAR,   4385,  RCHAR,  RCHAR,   4277,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4938,   7792,   8097,  RCHAR,  RCHAR,   7371,  RCHAR,
    4218,   7942,   6474,   7459,
  // [0x63C0,0x63C6] -v # seg 458 at pos 15137
    3902,  RCHAR,  RCHAR,  RCHAR,   6942,  RCHAR,   4423,
  // [0x63CF,0x63E1] -v # seg 460 at pos 15144
    5321,   7436,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7026,
   RCHAR,  RCHAR,  RCHAR,   6423,   8574,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6333,
  // [0x63ED,0x63F7] -v # seg 462 at pos 15163
    4050,   8685,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6882,
   RCHAR,   6401,   5853,
  // [0x640D,0x6422] -v # seg 464 at pos 15174
    6078,  RCHAR,   5406,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6039,
   RCHAR,   6757,   4792,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6113,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7655,
  // [0x642C,0x642D] -v # seg 466 at pos 15196
    5427,   8102,
  // [0x643A,0x643E] -v # seg 468 at pos 15198
    8692,  RCHAR,  RCHAR,  RCHAR,   7729,
  // [0x6458,0x6458] -> [  7292,  7292] # seg 470
  // [0x6460,0x6460] -> [  7931,  7931] # seg 472
  // [0x6469,0x646F] -v # seg 474 at pos 15203
    5173,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7620,
  // [0x6478,0x647A] -v # seg 476 at pos 15210
    5287,   5288,   7372,
  // [0x6488,0x6488] -> [  5027,  5027] # seg 478
  // [0x6491,0x64B2] -v # seg 480 at pos 15213
    8126,   5841,   6758,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4626,  RCHAR,  RCHAR,  RCHAR,   4752,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7845,   5449,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5335,  RCHAR,   8158,   7936,  RCHAR,   7735,
   RCHAR,   5407,
  // [0x64BB,0x6504] -v # seg 482 at pos 15247
    4720,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6695,  RCHAR,
   RCHAR,   5028,   7827,  RCHAR,   8124,  RCHAR,  RCHAR,   4051,
   RCHAR,  RCHAR,   7460,   4095,  RCHAR,  RCHAR,  RCHAR,   4468,
   RCHAR,   4728,  RCHAR,  RCHAR,  RCHAR,   5542,  RCHAR,   4011,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4767,   8076,
   RCHAR,  RCHAR,   4913,   7752,   4012,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7039,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7814,
   RCHAR,   8563,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8159,
   RCHAR,  RCHAR,  RCHAR,   6759,  RCHAR,   5428,  RCHAR,  RCHAR,
   RCHAR,   8127,
  // [0x6518,0x65D7] -v # seg 484 at pos 15321
    6424,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5999,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4980,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4299,   8564,   4914,  RCHAR,  RCHAR,   7621,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6114,   4160,
    6943,   3986,  RCHAR,   4219,  RCHAR,  RCHAR,   5466,   7388,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4161,  RCHAR,  RCHAR,
    8642,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5910,   4300,   5391,
   RCHAR,   4336,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6668,   8185,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7773,  RCHAR,
   RCHAR,  RCHAR,   3935,   5831,  RCHAR,  RCHAR,   4829,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4096,   6425,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4162,  RCHAR,   7389,   7293,  RCHAR,   5646,
    6115,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5953,  RCHAR,
   RCHAR,  RCHAR,   4997,   8219,  RCHAR,   8643,  RCHAR,   5357,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5749,  RCHAR,  RCHAR,  RCHAR,
    5715,   5429,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4857,
   RCHAR,   5070,  RCHAR,   4190,   5789,  RCHAR,  RCHAR,   7701,
   RCHAR,   6351,  RCHAR,  RCHAR,   4454,   7815,  RCHAR,   5647,
   RCHAR,  RCHAR,  RCHAR,   7180,   7761,  RCHAR,  RCHAR,   5790,
    6273,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4707,
   RCHAR,   5467,  RCHAR,  RCHAR,   6449,   6234,  RCHAR,  RCHAR,
   RCHAR,   5468,  RCHAR,  RCHAR,  RCHAR,   4960,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5954,   7390,  RCHAR,  RCHAR,   7498,
   RCHAR,  RCHAR,   5093,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4510,
  // [0x65E0,0x6615] -v # seg 486 at pos 15513
    5336,  RCHAR,  RCHAR,   4511,  RCHAR,   7126,   4708,  RCHAR,
    7622,   7461,  RCHAR,  RCHAR,   6175,   6846,  RCHAR,  RCHAR,
   RCHAR,   8320,  RCHAR,  RCHAR,   6824,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6731,   5392,   5393,   4830,  RCHAR,   6669,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4199,   6219,
   RCHAR,   5469,   8495,  RCHAR,   7774,  RCHAR,   5268,   8530,
    5682,   4469,  RCHAR,   6507,   5935,   8705,
  // [0x661E,0x664F] -v # seg 488 at pos 15567
    5566,   6009,   6596,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7975,
   RCHAR,   5229,   7181,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6040,
   RCHAR,   6235,   8303,   6847,  RCHAR,  RCHAR,   5322,  RCHAR,
    7775,  RCHAR,  RCHAR,  RCHAR,   5567,   6370,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7462,   6236,   8597,   8598,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7656,  RCHAR,   7657,  RCHAR,  RCHAR,
   RCHAR,   6344,
  // [0x6659,0x667A] -v # seg 490 at pos 15617
    7578,  RCHAR,   8422,  RCHAR,   7543,   8732,   6010,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6670,   8576,   8621,   8496,   6274,
    5194,  RCHAR,   8077,  RCHAR,  RCHAR,   5582,   4097,  RCHAR,
   RCHAR,  RCHAR,   5936,   7872,  RCHAR,   7391,   4415,   7392,
   RCHAR,   7623,
  // [0x6684,0x66A2] -v # seg 492 at pos 15651
    8677,  RCHAR,  RCHAR,   3865,   8674,   8686,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6597,  RCHAR,   6910,   5911,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4587,   6359,   6426,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5269,  RCHAR,  RCHAR,   4163,  RCHAR,   7776,
  // [0x66AB,0x66C9] -v # seg 494 at pos 15682
    7196,  RCHAR,  RCHAR,   5289,  RCHAR,  RCHAR,  RCHAR,   7214,
    8480,   8253,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5992,  RCHAR,
    4098,  RCHAR,  RCHAR,   4831,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6584,  RCHAR,   4972,   4729,  RCHAR,   8644,
  // [0x66D6,0x66E6] -v # seg 496 at pos 15713
    6379,  RCHAR,  RCHAR,   5912,  RCHAR,  RCHAR,   6761,   8254,
   RCHAR,  RCHAR,   4268,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8733,
  // [0x66F0,0x673D] -v # seg 498 at pos 15730
    6729,  RCHAR,   4191,   6633,   4099,  RCHAR,  RCHAR,   3920,
    5913,   7464,   7463,  RCHAR,   5195,  RCHAR,   7603,   7881,
    7939,  RCHAR,  RCHAR,   8622,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6898,   6944,  RCHAR,   5698,  RCHAR,   5600,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5826,   7702,  RCHAR,   4926,
   RCHAR,  RCHAR,  RCHAR,   5217,  RCHAR,   7465,   4512,   4513,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5315,   5053,
    5305,  RCHAR,   5374,   5208,   5611,   7753,   7979,  RCHAR,
   RCHAR,   7544,  RCHAR,  RCHAR,   5408,  RCHAR,   8063,  RCHAR,
   RCHAR,  RCHAR,   4408,  RCHAR,  RCHAR,   8661,
  // [0x6746,0x675F] -v # seg 500 at pos 15808
    3903,  RCHAR,  RCHAR,   5847,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5136,   8391,   7244,   7924,  RCHAR,   8262,  RCHAR,  RCHAR,
    7215,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4858,  RCHAR,
    4514,   6069,
  // [0x676D,0x677F] -v # seg 502 at pos 15834
    8359,  RCHAR,   5493,   4036,   4845,  RCHAR,   5323,  RCHAR,
    7267,  RCHAR,   8160,  RCHAR,  RCHAR,  RCHAR,   4683,  RCHAR,
   RCHAR,   6085,   8172,
  // [0x6787,0x679D] -v # seg 504 at pos 15853
    5716,  RCHAR,   6732,  RCHAR,   5470,  RCHAR,  RCHAR,  RCHAR,
    4598,   5937,  RCHAR,  RCHAR,   4859,  RCHAR,   8044,  RCHAR,
    5164,  RCHAR,  RCHAR,   5230,  RCHAR,   4228,   7624,
  // [0x67AF,0x67C4] -v # seg 506 at pos 15876
    4164,   8211,  RCHAR,  RCHAR,   7625,  RCHAR,  RCHAR,   3866,
    3867,   4337,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6237,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5568,
  // [0x67CF,0x67DD] -v # seg 508 at pos 15898
    5509,   5290,   3936,   8040,   6573,   6946,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6947,  RCHAR,  RCHAR,   8078,
  // [0x67E9,0x67FE] -v # seg 510 at pos 15913
    4338,  RCHAR,  RCHAR,   3904,  RCHAR,  RCHAR,   3868,   4621,
    7545,  RCHAR,   5094,   6238,   7800,   5791,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5792,  RCHAR,  RCHAR,   7393,
  // [0x6812,0x6817] -v # seg 512 at pos 15935
    6176,   7328,  RCHAR,  RCHAR,   5914,   5117,
  // [0x6821,0x6822] -v # seg 514 at pos 15941
    4301,   5510,
  // [0x682A,0x682F] -v # seg 516 at pos 15943
    7546,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6848,
  // [0x6838,0x6854] -v # seg 518 at pos 15949
    8388,   4455,  RCHAR,  RCHAR,   4052,   7245,  RCHAR,  RCHAR,
    4037,   8360,   4134,   4793,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6345,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7691,  RCHAR,
    4846,   5872,  RCHAR,   8577,   4559,
  // [0x686D,0x686D] -> [  7658,  7658] # seg 520
  // [0x6876,0x6876] -> [  8133,  8133] # seg 522
  // [0x687F,0x6885] -v # seg 524 at pos 15978
    3905,  RCHAR,   4944,  RCHAR,  RCHAR,  RCHAR,   5231,
  // [0x688F,0x68B6] -v # seg 526 at pos 15985
    4192,  RCHAR,  RCHAR,  RCHAR,   7246,   8017,  RCHAR,  RCHAR,
    4100,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7466,  RCHAR,
    8645,  RCHAR,   6714,   7895,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6671,   5137,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5793,  RCHAR,
    7437,   4135,   4200,  RCHAR,   6041,  RCHAR,   5530,   5375,
  // [0x68C4,0x6905] -v # seg 528 at pos 16025
    4516,   5569,  RCHAR,  RCHAR,  RCHAR,   5255,  RCHAR,   4515,
   RCHAR,   4201,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5619,  RCHAR,
   RCHAR,   7512,  RCHAR,   7467,   4447,  RCHAR,   5699,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4847,   4753,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7191,   4136,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5848,  RCHAR,  RCHAR,  RCHAR,   5915,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4794,   4247,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6715,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7040,
  // [0x690D,0x6912] -v # seg 530 at pos 16091
    6256,   7943,  RCHAR,  RCHAR,  RCHAR,   7896,
  // [0x6927,0x6927] -> [  5270,  5270] # seg 532
  // [0x6930,0x6930] -> [  6402,  6402] # seg 534
  // [0x693D,0x693F] -v # seg 536 at pos 16097
    6528,  RCHAR,   7976,
  // [0x694A,0x694A] -> [  6428,  6428] # seg 538
  // [0x6953,0x6979] -v # seg 540 at pos 16100
    8274,   5980,   8064,  RCHAR,   4028,  RCHAR,   5337,   7897,
   RCHAR,  RCHAR,  RCHAR,   5124,  RCHAR,   4599,   6949,   6950,
    5376,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7394,  RCHAR,  RCHAR,
    7598,  RCHAR,   6477,   7268,   6177,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4448,  RCHAR,   8377,   7944,   6598,
  // [0x6995,0x699C] -v # seg 542 at pos 16139
    6797,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7659,   5471,
  // [0x69A5,0x69C3] -v # seg 544 at pos 16147
    8599,  RCHAR,   5717,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6599,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5095,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8103,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4165,  RCHAR,   5430,
  // [0x69CB,0x69D0] -v # seg 546 at pos 16178
    4339,   8140,   7777,  RCHAR,  RCHAR,   4286,
  // [0x69E8,0x69EA] -v # seg 548 at pos 16184
    4239,  RCHAR,   3987,
  // [0x69FB,0x6A02] -v # seg 550 at pos 16187
    4424,  RCHAR,   7468,  RCHAR,   4456,  RCHAR,  RCHAR,   6334,
  // [0x6A0A,0x6A23] -v # seg 552 at pos 16195
    5515,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4945,
   RCHAR,   5082,  RCHAR,  RCHAR,  RCHAR,   7269,  RCHAR,   8263,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7945,   7216,  RCHAR,   5291,
   RCHAR,   6429,
  // [0x6A35,0x6A61] -v # seg 554 at pos 16221
    7898,  RCHAR,  RCHAR,   5409,   6116,   8551,  RCHAR,  RCHAR,
    7579,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3937,
   RCHAR,  RCHAR,  RCHAR,   6763,  RCHAR,  RCHAR,   4302,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6855,   6178,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4442,   4875,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4517,  RCHAR,   5873,
  // [0x6A6B,0x6A6B] -> [  8637,  8637] # seg 556
  // [0x6A80,0x6A8E] -v # seg 558 at pos 16266
    4709,  RCHAR,  RCHAR,  RCHAR,   4053,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7395,  RCHAR,  RCHAR,  RCHAR,   6460,   4470,
  // [0x6A97,0x6AA3] -v # seg 560 at pos 16281
    5543,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8623,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4041,   7217,
  // [0x6AB3,0x6AB3] -> [  5750,  5750] # seg 562
  // [0x6ABB,0x6AC3] -v # seg 564 at pos 16294
    8338,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4795,
    4409,
  // [0x6AD3,0x6ADB] -v # seg 566 at pos 16303
    5029,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4961,
    7597,
  // [0x6AF6,0x6AFB] -v # seg 568 at pos 16312
    8408,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6392,
  // [0x6B04,0x6B16] -v # seg 570 at pos 16318
    4904,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4400,  RCHAR,
    7218,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4905,  RCHAR,
   RCHAR,  RCHAR,   4915,
  // [0x6B20,0x6B23] -v # seg 572 at pos 16337
    8713,   7720,  RCHAR,   8706,
  // [0x6B32,0x6B32] -> [  6783,  6783] # seg 574
  // [0x6B3A,0x6B3E] -v # seg 576 at pos 16341
    4518,  RCHAR,  RCHAR,   8714,   4248,
  // [0x6B46,0x6B50] -v # seg 578 at pos 16346
    8715,   8411,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3869,  RCHAR,
    8090,  RCHAR,   4340,
  // [0x6B5F,0x6B6A] -v # seg 580 at pos 16357
    6487,  RCHAR,   8575,   7626,   7396,   7721,   5583,   5338,
   RCHAR,  RCHAR,  RCHAR,   6737,
  // [0x6B72,0x6B8A] -v # seg 582 at pos 16369
    6023,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4973,   4416,  RCHAR,
   RCHAR,   5794,  RCHAR,  RCHAR,  RCHAR,   5312,  RCHAR,  RCHAR,
   RCHAR,   6371,   7660,  RCHAR,   8114,  RCHAR,  RCHAR,   6179,
    6117,
  // [0x6B96,0x6B9E] -v # seg 584 at pos 16394
    6257,  RCHAR,   7192,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6856,
  // [0x6BAE,0x6BDB] -v # seg 586 at pos 16403
    4998,   5751,  RCHAR,  RCHAR,   5993,  RCHAR,  RCHAR,   4710,
   RCHAR,   7015,  RCHAR,  RCHAR,   5842,  RCHAR,   3888,  RCHAR,
   RCHAR,   7329,  RCHAR,   8682,  RCHAR,  RCHAR,  RCHAR,   7041,
    4341,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5339,  RCHAR,   5292,
   RCHAR,   5232,  RCHAR,  RCHAR,   4817,   6985,   5718,  RCHAR,
    5719,   5720,   5721,  RCHAR,  RCHAR,   5293,
  // [0x6BEB,0x6BEC] -v # seg 588 at pos 16449
    8497,   4342,
  // [0x6C08,0x6C13] -v # seg 590 at pos 16451
    7330,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6308,
   RCHAR,   5394,  RCHAR,   5245,
  // [0x6C23,0x6C23] -> [  4519,  4519] # seg 592
  // [0x6C34,0x6C42] -v # seg 594 at pos 16463
    6118,  RCHAR,  RCHAR,   5761,   6600,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5531,  RCHAR,   7397,   7599,   4343,
  // [0x6C4E,0x6C60] -v # seg 596 at pos 16478
    5532,  RCHAR,   5938,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5832,
   RCHAR,   8321,  RCHAR,  RCHAR,   6672,  RCHAR,  RCHAR,   6488,
    8540,   3963,   7627,
  // [0x6C68,0x6C9B] -v # seg 598 at pos 16497
    4206,  RCHAR,   6733,  RCHAR,  RCHAR,   6634,  RCHAR,  RCHAR,
    8115,  RCHAR,   4484,  RCHAR,  RCHAR,  RCHAR,   5358,  RCHAR,
   RCHAR,  RCHAR,   4070,  RCHAR,  RCHAR,   4520,   5683,  RCHAR,
   RCHAR,   6297,   4521,   6683,  RCHAR,   6883,   8361,   6529,
    8045,  RCHAR,  RCHAR,  RCHAR,   4832,  RCHAR,  RCHAR,  RCHAR,
    5306,  RCHAR,   5313,   4742,   5256,   5366,   7983,  RCHAR,
   RCHAR,   5795,   7628,   8186,
  // [0x6CAB,0x6CF3] -v # seg 600 at pos 16549
    5209,  RCHAR,  RCHAR,   7270,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8304,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5722,   6951,  RCHAR,
    8018,   6042,   4166,   7853,   6530,  RCHAR,   8600,   8461,
   RCHAR,   5981,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7828,   5410,
   RCHAR,   8289,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8541,  RCHAR,   5537,  RCHAR,   5796,  RCHAR,  RCHAR,  RCHAR,
    5533,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8237,   8161,
    7027,  RCHAR,   4695,  RCHAR,  RCHAR,   7547,  RCHAR,  RCHAR,
    8423,  RCHAR,  RCHAR,   5431,   5395,   8116,  RCHAR,  RCHAR,
    6601,
  // [0x6D0B,0x6D2A] -v # seg 602 at pos 16622
    6430,   4993,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5584,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6024,  RCHAR,   6119,  RCHAR,
    4893,  RCHAR,  RCHAR,   4848,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7661,  RCHAR,   6952,  RCHAR,   5982,   8542,
  // [0x6D32,0x6D41] -v # seg 604 at pos 16654
    7548,  RCHAR,  RCHAR,   6180,   8702,  RCHAR,   4269,   6884,
   RCHAR,   8585,  RCHAR,   8718,   8162,  RCHAR,  RCHAR,   5096,
  // [0x6D59,0x6D95] -v # seg 606 at pos 16670
    7357,   7580,  RCHAR,   5752,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6716,  RCHAR,  RCHAR,   8238,  RCHAR,  RCHAR,
    8498,   4927,  RCHAR,   5138,  RCHAR,   5648,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6784,  RCHAR,  RCHAR,   8378,   8046,
    8449,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8187,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6563,  RCHAR,   4101,   6043,
    6000,  RCHAR,  RCHAR,   6798,   8646,   6531,  RCHAR,  RCHAR,
    6070,  RCHAR,   6532,  RCHAR,   7882,
  // [0x6DAF,0x6DB5] -v # seg 608 at pos 16731
    6380,  RCHAR,  RCHAR,   6388,  RCHAR,  RCHAR,   8339,
  // [0x6DC0,0x6DFB] -v # seg 610 at pos 16738
    7398,  RCHAR,  RCHAR,   4401,   8019,   5939,   8647,   4522,
   RCHAR,  RCHAR,  RCHAR,   5165,  RCHAR,  RCHAR,  RCHAR,   8499,
   RCHAR,   6164,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4796,   7513,   5083,  RCHAR,  RCHAR,  RCHAR,   6086,  RCHAR,
   RCHAR,   4730,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7399,  RCHAR,   5112,   7021,  RCHAR,  RCHAR,   8624,  RCHAR,
   RCHAR,   6299,  RCHAR,   6181,  RCHAR,   6533,  RCHAR,   8531,
    7873,   6475,   7829,   7854,
  // [0x6E17,0x6E4D] -v # seg 612 at pos 16798
    5849,  RCHAR,   8578,   7271,   3938,  RCHAR,  RCHAR,  RCHAR,
    7400,   4013,   4797,  RCHAR,   5797,   5450,   6335,   6703,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5983,   8009,   6911,  RCHAR,
    8362,  RCHAR,  RCHAR,   5955,  RCHAR,   3921,  RCHAR,   6602,
   RCHAR,   6954,  RCHAR,   5324,  RCHAR,   5377,   7247,   8532,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5494,   5378,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7549,  RCHAR,  RCHAR,   4711,
  // [0x6E56,0x6E5F] -v # seg 614 at pos 16853
    8500,  RCHAR,   5874,  RCHAR,  RCHAR,   4731,   6258,  RCHAR,
    7401,   8601,
  // [0x6E67,0x6E7A] -v # seg 616 at pos 16863
    6799,  RCHAR,  RCHAR,  RCHAR,   7946,  RCHAR,  RCHAR,   7109,
    8106,  RCHAR,  RCHAR,   6885,   4600,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5585,
  // [0x6E90,0x6EBA] -v # seg 618 at pos 16883
    6886,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7581,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5097,   4344,  RCHAR,   5271,
   RCHAR,  RCHAR,   7127,  RCHAR,  RCHAR,   5649,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4137,   6687,  RCHAR,  RCHAR,  RCHAR,   6044,
   RCHAR,   7662,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6800,  RCHAR,
   RCHAR,  RCHAR,   4697,
  // [0x6EC2,0x6ED4] -v # seg 620 at pos 16926
    5472,  RCHAR,   7778,   5263,  RCHAR,  RCHAR,  RCHAR,   8602,
   RCHAR,   7161,   7816,  RCHAR,   8462,  RCHAR,  RCHAR,   8586,
   RCHAR,   7248,   4798,
  // [0x6EEF,0x6F06] -v # seg 622 at pos 16945
    7883,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7294,  RCHAR,  RCHAR,
   RCHAR,   8501,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4202,
    5196,  RCHAR,   6450,   8264,  RCHAR,  RCHAR,  RCHAR,   8041,
  // [0x6F0F,0x6F15] -v # seg 624 at pos 16969
    5084,  RCHAR,   3988,  RCHAR,  RCHAR,   6534,   7469,
  // [0x6F20,0x6F23] -v # seg 626 at pos 16976
    5183,  RCHAR,   8322,   4981,
  // [0x6F2B,0x6F41] -v # seg 628 at pos 16980
    5197,   7629,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6120,   7779,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7365,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7219,  RCHAR,   6603,
  // [0x6F51,0x6F64] -v # seg 630 at pos 17003
    5451,  RCHAR,  RCHAR,   4071,  RCHAR,  RCHAR,   7705,   5432,
   RCHAR,   6165,   7197,  RCHAR,  RCHAR,   5030,   5940,  RCHAR,
   RCHAR,   8603,  RCHAR,   6995,
  // [0x6F6D,0x6F70] -v # seg 632 at pos 17023
    4732,   7470,  RCHAR,   4410,
  // [0x6F7A,0x6F97] -v # seg 634 at pos 17027
    7193,  RCHAR,   4849,   5586,   5156,  RCHAR,  RCHAR,   5854,
   RCHAR,  RCHAR,   7712,  RCHAR,  RCHAR,  RCHAR,   7846,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7550,   8194,  RCHAR,   6857,  RCHAR,
   RCHAR,  RCHAR,   8502,  RCHAR,  RCHAR,   3906,
  // [0x6FA3,0x6FCA] -v # seg 636 at pos 17057
    8323,   8125,  RCHAR,  RCHAR,   5021,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8625,   7736,  RCHAR,   7331,  RCHAR,
    6673,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4733,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4721,  RCHAR,   4054,   8079,   4999,
    4661,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6635,
  // [0x6FD5,0x6FF1] -v # seg 638 at pos 17097
    6208,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6604,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7438,   8503,   6956,  RCHAR,  RCHAR,   4799,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8504,  RCHAR,   4916,   7582,
   RCHAR,  RCHAR,   8080,  RCHAR,   5753,
  // [0x6FFE,0x702F] -v # seg 640 at pos 17126
    4962,  RCHAR,  RCHAR,   6431,  RCHAR,  RCHAR,  RCHAR,   8463,
    4818,  RCHAR,  RCHAR,   5798,  RCHAR,   6300,  RCHAR,  RCHAR,
   RCHAR,   5098,  RCHAR,   8255,  RCHAR,  RCHAR,  RCHAR,   5754,
   RCHAR,  RCHAR,   5031,  RCHAR,   8324,   6605,   7008,   4974,
    7402,   6045,  RCHAR,  RCHAR,  RCHAR,   8379,  RCHAR,  RCHAR,
   RCHAR,   5054,   5059,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6606,
  // [0x7037,0x703E] -v # seg 642 at pos 17176
    7092,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4906,
  // [0x704C,0x7063] -v # seg 644 at pos 17184
    4249,  RCHAR,  RCHAR,  RCHAR,   8464,   6093,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8091,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   8505,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5198,
  // [0x706B,0x7070] -v # seg 646 at pos 17208
    8552,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8626,
  // [0x7078,0x707D] -v # seg 648 at pos 17214
    4345,  RCHAR,  RCHAR,  RCHAR,   7182,   7249,
  // [0x7085,0x70B9] -v # seg 650 at pos 17220
    4102,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7996,  RCHAR,  RCHAR,
   RCHAR,   6575,  RCHAR,  RCHAR,  RCHAR,   7899,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8707,   7162,   4270,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7403,  RCHAR,  RCHAR,   6046,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8424,   4014,
    8092,  RCHAR,   8465,  RCHAR,  RCHAR,  RCHAR,   5570,  RCHAR,
   RCHAR,  RCHAR,   7551,   7183,   7366,
  // [0x70C8,0x70CF] -v # seg 652 at pos 17273
    4994,  RCHAR,  RCHAR,   8693,  RCHAR,  RCHAR,  RCHAR,   6674,
  // [0x70D8,0x70DF] -v # seg 654 at pos 17281
    8543,   4894,  RCHAR,  RCHAR,  RCHAR,   7605,  RCHAR,   6536,
  // [0x70F1,0x70F1] -> [  4103,  4103] # seg 656
  // [0x70F9,0x710C] -v # seg 658 at pos 17289
    8195,  RCHAR,  RCHAR,  RCHAR,   5620,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8669,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6465,  RCHAR,  RCHAR,   7583,
  // [0x7119,0x7126] -v # seg 660 at pos 17309
    5495,   5684,  RCHAR,  RCHAR,  RCHAR,   4833,  RCHAR,  RCHAR,
    5340,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7900,
  // [0x7130,0x7136] -v # seg 662 at pos 17323
    6576,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6537,
  // [0x7147,0x716E] -v # seg 664 at pos 17330
    8687,  RCHAR,   4982,   8678,  RCHAR,   8604,  RCHAR,   7332,
   RCHAR,   6607,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4589,
   RCHAR,  RCHAR,   6538,  RCHAR,  RCHAR,   6849,  RCHAR,   5843,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5233,   8579,   8662,
    7471,  RCHAR,   5516,  RCHAR,  RCHAR,   6432,  RCHAR,   7163,
  // [0x717D,0x71A2] -v # seg 666 at pos 17370
    5956,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6259,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6858,   6869,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8670,  RCHAR,  RCHAR,   8466,  RCHAR,   6801,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8734,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6166,  RCHAR,  RCHAR,   5621,
  // [0x71AC,0x71B1] -v # seg 668 at pos 17408
    6675,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6565,
  // [0x71B9,0x71D5] -v # seg 670 at pos 17414
    8735,   8736,  RCHAR,  RCHAR,  RCHAR,   8020,  RCHAR,  RCHAR,
    6586,  RCHAR,   6540,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4876,
    4834,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5071,  RCHAR,   5157,
   RCHAR,   6047,  RCHAR,   5517,   6541,
  // [0x71DF,0x71EE] -v # seg 672 at pos 17443
    6608,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7472,   7737,
    6121,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7918,   6001,
  // [0x71FB,0x7206] -v # seg 674 at pos 17459
    8671,   6275,  RCHAR,   4800,   6765,   8415,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8256,
  // [0x7210,0x7210] -> [  5032,  5032] # seg 676
  // [0x721B,0x721B] -> [  4907,  4907] # seg 678
  // [0x722A,0x7269] -v # seg 680 at pos 17471
    7473,  RCHAR,   8163,   7256,  RCHAR,  RCHAR,   6887,  RCHAR,
    6912,  RCHAR,  RCHAR,   7184,   5650,  RCHAR,  RCHAR,  RCHAR,
    6403,   8648,  RCHAR,   5875,   7068,  RCHAR,   5876,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7220,   8201,   8173,  RCHAR,
   RCHAR,  RCHAR,   8188,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7865,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4819,   6316,
   RCHAR,   6825,  RCHAR,   5755,  RCHAR,   5294,  RCHAR,   5295,
    5060,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5307,  RCHAR,   5367,
  // [0x7272,0x7281] -v # seg 682 at pos 17535
    5896,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8152,
   RCHAR,  RCHAR,  RCHAR,   4059,  RCHAR,  RCHAR,   5916,   5139,
  // [0x72A2,0x72AF] -v # seg 684 at pos 17551
    4820,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8737,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4060,  RCHAR,  RCHAR,   5534,
  // [0x72C0,0x72C4] -v # seg 686 at pos 17565
    5877,  RCHAR,   4271,  RCHAR,   7295,
  // [0x72CE,0x72D9] -v # seg 688 at pos 17570
    6365,  RCHAR,   8506,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4346,  RCHAR,   7272,
  // [0x72E1,0x72E1] -> [  4303,  4303] # seg 690
  // [0x72E9,0x72E9] -> [  6122,  6122] # seg 692
  // [0x72F8,0x72FD] -v # seg 694 at pos 17582
    5140,   8450,  RCHAR,  RCHAR,   4928,   8189,
  // [0x730A,0x730A] -> [  6636,  6636] # seg 696
  // [0x7316,0x731D] -v # seg 698 at pos 17588
    7780,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5246,   6239,   7506,
  // [0x7325,0x732B] -v # seg 700 at pos 17596
    6742,  RCHAR,  RCHAR,  RCHAR,   6011,   7273,   5325,
  // [0x7336,0x7345] -v # seg 702 at pos 17603
    6957,   6958,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8587,   6888,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6684,   5799,
  // [0x7350,0x7357] -v # seg 704 at pos 17619
    7222,  RCHAR,   6676,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4404,
  // [0x7368,0x737B] -v # seg 706 at pos 17627
    4821,  RCHAR,   8627,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6609,  RCHAR,   8635,  RCHAR,  RCHAR,   5001,  RCHAR,  RCHAR,
    6123,  RCHAR,   4722,   8409,
  // [0x7384,0x739F] -v # seg 708 at pos 17647
    8425,  RCHAR,   7164,   6082,  RCHAR,   6685,  RCHAR,   6734,
   RCHAR,  RCHAR,   7404,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7830,  RCHAR,   4347,   6826,   4523,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5396,
  // [0x73A7,0x73ED] -v # seg 710 at pos 17675
    6996,  RCHAR,   6717,  RCHAR,  RCHAR,  RCHAR,   5756,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5009,   4768,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8426,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5411,  RCHAR,   3870,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5397,   5833,  RCHAR,   8290,   7663,  RCHAR,
    3889,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4272,
   RCHAR,  RCHAR,   4220,  RCHAR,  RCHAR,  RCHAR,   8663,   4895,
   RCHAR,   7552,  RCHAR,  RCHAR,   6182,   5587,   7069,   8397,
   RCHAR,  RCHAR,   8467,   4425,  RCHAR,  RCHAR,   5433,
  // [0x73F7,0x7409] -v # seg 712 at pos 17746
    5341,  RCHAR,   6012,  RCHAR,  RCHAR,  RCHAR,   7405,   8427,
   RCHAR,  RCHAR,   5957,  RCHAR,   4348,  RCHAR,   4929,   5141,
    6124,  RCHAR,   5099,
  // [0x7413,0x7413] -> [  6718,  6718] # seg 714
  // [0x741B,0x744B] -v # seg 716 at pos 17765
    8047,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7333,   6167,   8081,
   RCHAR,  RCHAR,   8507,   4524,  RCHAR,   4203,  RCHAR,   4525,
    5622,   6719,  RCHAR,   7514,   4250,   6577,  RCHAR,  RCHAR,
    5166,   4471,   5724,   8164,  RCHAR,   8082,  RCHAR,   5538,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8533,   6827,   5296,  RCHAR,
    7977,   5958,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6913,
  // [0x7455,0x746F] -v # seg 718 at pos 17814
    8305,  RCHAR,   6889,  RCHAR,   4642,   8508,   6611,   6960,
   RCHAR,   5917,   6205,   5100,  RCHAR,   6802,  RCHAR,   6766,
    6688,  RCHAR,  RCHAR,   7664,   8468,   5174,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4930,
  // [0x747E,0x748B] -v # seg 720 at pos 17841
    4457,  RCHAR,  RCHAR,  RCHAR,   4526,   5142,  RCHAR,  RCHAR,
   RCHAR,   5959,  RCHAR,   4983,  RCHAR,   7223,
  // [0x7498,0x74E6] -v # seg 722 at pos 17855
    5158,  RCHAR,  RCHAR,  RCHAR,   8605,  RCHAR,   5412,   4104,
   RCHAR,   7665,  RCHAR,   4527,  RCHAR,   4105,  RCHAR,   5544,
    7738,  RCHAR,   7474,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8580,  RCHAR,   6125,  RCHAR,  RCHAR,   6490,  RCHAR,  RCHAR,
   RCHAR,   6168,  RCHAR,  RCHAR,  RCHAR,   5889,  RCHAR,   5960,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7692,  RCHAR,
   RCHAR,  RCHAR,   4106,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5055,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6613,  RCHAR,  RCHAR,  RCHAR,
    4251,  RCHAR,   7739,  RCHAR,   4229,  RCHAR,  RCHAR,  RCHAR,
    8509,  RCHAR,   8265,   8174,  RCHAR,  RCHAR,   6704,
  // [0x74EE,0x74EE] -> [  6696,  6696] # seg 724
  // [0x74F7,0x74F7] -> [  7165,  7165] # seg 726
  // [0x7501,0x7504] -v # seg 728 at pos 17934
    5571,  RCHAR,  RCHAR,   4061,
  // [0x7511,0x753A] -v # seg 730 at pos 17938
    7606,  RCHAR,  RCHAR,  RCHAR,   6697,  RCHAR,  RCHAR,   3939,
   RCHAR,   6301,   7855,  RCHAR,  RCHAR,  RCHAR,   5897,  RCHAR,
   RCHAR,  RCHAR,   5834,  RCHAR,   5898,   6048,  RCHAR,   6803,
   RCHAR,  RCHAR,   5588,   6804,  RCHAR,  RCHAR,  RCHAR,   7334,
    6961,   3950,   6276,  RCHAR,  RCHAR,  RCHAR,   4602,   7335,
   RCHAR,   7406,
  // [0x7547,0x7591] -v # seg 732 at pos 17980
    4437,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4138,  RCHAR,  RCHAR,
    6743,  RCHAR,   7336,  RCHAR,   4743,   5434,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5101,  RCHAR,   7666,   7964,   5342,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8291,  RCHAR,  RCHAR,   4939,   8694,
   RCHAR,  RCHAR,  RCHAR,   5518,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7584,   7071,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8553,   4754,
   RCHAR,   4528,  RCHAR,   3964,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4529,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3965,
    7553,  RCHAR,  RCHAR,   7866,   8292,  RCHAR,  RCHAR,   6050,
    6049,  RCHAR,   7042,
  // [0x759D,0x759D] -> [  5835,  5835] # seg 734
  // [0x75A5,0x75E2] -v # seg 736 at pos 18055
    3989,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6510,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8239,   8281,   3940,  RCHAR,
    7166,  RCHAR,  RCHAR,   4723,   7667,  RCHAR,  RCHAR,   4850,
    7274,   7693,  RCHAR,  RCHAR,  RCHAR,   3871,  RCHAR,  RCHAR,
    5572,  RCHAR,   7607,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7072,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6433,  RCHAR,   8021,
    8708,  RCHAR,  RCHAR,   4860,   4107,  RCHAR,   8135,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5144,
  // [0x75F0,0x7600] -v # seg 738 at pos 18117
    4734,  RCHAR,   5175,  RCHAR,   8022,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5725,  RCHAR,   4167,  RCHAR,  RCHAR,  RCHAR,
    6451,
  // [0x760D,0x760D] -> [  6434,  6434] # seg 740
  // [0x7619,0x7626] -v # seg 742 at pos 18134
    6051,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6689,   7817,
    7781,   5435,  RCHAR,   5102,  RCHAR,   6126,
  // [0x763B,0x7642] -v # seg 744 at pos 18148
    5085,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5072,
  // [0x764C,0x7656] -v # seg 746 at pos 18156
    6360,  RCHAR,   3907,  RCHAR,  RCHAR,  RCHAR,   6963,  RCHAR,
   RCHAR,  RCHAR,   5545,
  // [0x7661,0x7693] -v # seg 748 at pos 18167
    8023,  RCHAR,  RCHAR,   7358,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4886,  RCHAR,  RCHAR,   5961,  RCHAR,  RCHAR,  RCHAR,   6698,
   RCHAR,   7337,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4139,
   RCHAR,  RCHAR,   4877,   5452,   5511,   5512,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7297,  RCHAR,   3990,   8606,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4304,  RCHAR,   4168,
   RCHAR,  RCHAR,   8510,
  // [0x76AE,0x76AE] -> [  8282,  8282] # seg 750
  // [0x76BA,0x76CA] -v # seg 752 at pos 18218
    7947,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5272,  RCHAR,  RCHAR,
    6828,   5496,  RCHAR,  RCHAR,   5685,  RCHAR,   6614,  RCHAR,
    7093,
  // [0x76D2,0x770B] -v # seg 754 at pos 18235
    8347,  RCHAR,  RCHAR,  RCHAR,   3991,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6013,   4801,  RCHAR,   7194,   5248,  RCHAR,   7668,
   RCHAR,   3941,   5436,  RCHAR,  RCHAR,   5033,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5308,  RCHAR,  RCHAR,  RCHAR,
    5247,  RCHAR,   7646,  RCHAR,  RCHAR,  RCHAR,   5878,  RCHAR,
   RCHAR,  RCHAR,   5437,  RCHAR,   6183,  RCHAR,  RCHAR,   6014,
   RCHAR,  RCHAR,   5257,  RCHAR,  RCHAR,  RCHAR,   8098,   5379,
   RCHAR,   3908,
  // [0x771E,0x7720] -v # seg 756 at pos 18293
    7669,  RCHAR,   5258,
  // [0x7729,0x7729] -> [  8428,  8428] # seg 758
  // [0x7737,0x7740] -v # seg 760 at pos 18296
    4402,   5297,  RCHAR,   7475,  RCHAR,   6346,  RCHAR,  RCHAR,
   RCHAR,   7730,
  // [0x774D,0x774D] -> [  8429,  8429] # seg 762
  // [0x775B,0x776B] -v # seg 764 at pos 18306
    7407,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6127,  RCHAR,
    4822,  RCHAR,  RCHAR,   5309,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7867,
  // [0x7779,0x777F] -v # seg 766 at pos 18323
    4802,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4169,   6637,
  // [0x778B,0x7791] -v # seg 768 at pos 18330
    7670,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5273,
  // [0x779E,0x77B3] -v # seg 770 at pos 18337
    5199,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5558,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6184,   5073,
   RCHAR,  RCHAR,   3942,  RCHAR,  RCHAR,   4851,
  // [0x77BB,0x77BF] -v # seg 772 at pos 18359
    7856,   4042,  RCHAR,  RCHAR,   4349,
  // [0x77D7,0x77F3] -v # seg 774 at pos 18364
    7919,  RCHAR,  RCHAR,  RCHAR,   5298,   4489,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6240,   7043,  RCHAR,   7630,  RCHAR,
   RCHAR,  RCHAR,   4350,  RCHAR,  RCHAR,  RCHAR,   4712,   6738,
    4305,  RCHAR,  RCHAR,  RCHAR,   5941,
  // [0x7802,0x7802] -> [  5800,  5800] # seg 776
  // [0x7812,0x7812] -> [  5726,  5726] # seg 778
  // [0x7825,0x7834] -v # seg 780 at pos 18393
    7631,   7793,   8048,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5169,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8240,  RCHAR,   8165,
  // [0x7845,0x7845] -> [  4426,  4426] # seg 782
  // [0x784F,0x784F] -> [  6543,  6543] # seg 784
  // [0x785D,0x785D] -> [  7901,  7901] # seg 786
  // [0x786B,0x786F] -v # seg 788 at pos 18409
    5103,   4108,  RCHAR,  RCHAR,   6544,
  // [0x787C,0x7897] -v # seg 790 at pos 18414
    5700,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4530,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7408,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5043,   6381,   6094,  RCHAR,  RCHAR,   5727,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6720,
  // [0x78A3,0x78A9] -v # seg 792 at pos 18442
    3922,  RCHAR,  RCHAR,  RCHAR,   5546,  RCHAR,   5942,
  // [0x78BA,0x78D0] -v # seg 794 at pos 18449
    8565,   8566,   5176,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7167,
   RCHAR,  RCHAR,  RCHAR,   5473,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5061,   7722,  RCHAR,  RCHAR,   4140,  RCHAR,   5438,
  // [0x78E8,0x7901] -v # seg 796 at pos 18472
    5177,  RCHAR,  RCHAR,  RCHAR,   4109,  RCHAR,  RCHAR,   4531,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3909,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5439,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7902,
  // [0x790E,0x790E] -> [  7903,  7903] # seg 798
  // [0x7916,0x7916] -> [  6491,  6491] # seg 800
  // [0x792A,0x792C] -v # seg 802 at pos 18498
    4963,   4975,   5440,
  // [0x793A,0x796D] -v # seg 804 at pos 18501
    6241,  RCHAR,  RCHAR,  RCHAR,   5801,  RCHAR,   5802,   4532,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4533,   4534,   7632,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6829,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7476,   7633,  RCHAR,  RCHAR,
    7477,   4015,   8511,   7965,   6277,  RCHAR,   5803,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5879,  RCHAR,  RCHAR,   8266,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7439,
  // [0x797A,0x7981] -v # seg 806 at pos 18553
    4535,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5044,  RCHAR,   4472,
  // [0x798D,0x7991] -v # seg 808 at pos 18561
    8554,   7409,   5601,  RCHAR,   6830,
  // [0x79A6,0x79C1] -v # seg 810 at pos 18566
    6452,   8738,  RCHAR,  RCHAR,   5962,  RCHAR,  RCHAR,  RCHAR,
    5022,  RCHAR,  RCHAR,   4803,  RCHAR,   6435,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6831,  RCHAR,  RCHAR,  RCHAR,   4473,
    8555,   4823,   6128,   5804,
  // [0x79C9,0x79E9] -v # seg 812 at pos 18594
    5573,   4627,   7948,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4230,   7904,  RCHAR,  RCHAR,   5728,  RCHAR,  RCHAR,   5729,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7478,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8052,  RCHAR,   7671,   6372,  RCHAR,
    7694,
  // [0x79FB,0x7A20] -v # seg 814 at pos 18627
    7074,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8739,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6025,  RCHAR,  RCHAR,   3910,  RCHAR,  RCHAR,
    7410,  RCHAR,   7905,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7138,  RCHAR,  RCHAR,   8190,  RCHAR,   7647,   8024,
   RCHAR,   5125,  RCHAR,  RCHAR,   8273,   7479,
  // [0x7A2E,0x7A4E] -v # seg 816 at pos 18665
    7515,  RCHAR,  RCHAR,   8053,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6850,   7648,  RCHAR,  RCHAR,  RCHAR,   4804,   3872,   4141,
   RCHAR,   4170,   4193,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5310,  RCHAR,  RCHAR,   8025,  RCHAR,  RCHAR,  RCHAR,   7298,
    6615,
  // [0x7A57,0x7A57] -> [  6129,  6129] # seg 818
  // [0x7A61,0x7A88] -v # seg 820 at pos 18698
    5893,   6638,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6690,  RCHAR,   8567,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6436,
   RCHAR,  RCHAR,  RCHAR,   8440,  RCHAR,   4351,  RCHAR,  RCHAR,
    4389,   4221,  RCHAR,  RCHAR,   7411,  RCHAR,   7831,  RCHAR,
    4838,  RCHAR,  RCHAR,   7731,  RCHAR,  RCHAR,  RCHAR,   6768,
  // [0x7A92,0x7A9F] -v # seg 822 at pos 18738
    7695,   7782,  RCHAR,   7480,  RCHAR,  RCHAR,   4378,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4386,
  // [0x7AA9,0x7AAF] -v # seg 824 at pos 18752
    6705,   6706,  RCHAR,  RCHAR,  RCHAR,   4390,   6769,
  // [0x7ABA,0x7ABA] -> [  4427,  4427] # seg 826
  // [0x7AC4,0x7ACB] -v # seg 828 at pos 18759
    7740,   4428,  RCHAR,   4861,  RCHAR,  RCHAR,   7359,   5170,
  // [0x7AD7,0x7AFF] -v # seg 830 at pos 18767
    5326,  RCHAR,   7762,  RCHAR,  RCHAR,  RCHAR,   5574,  RCHAR,
    4110,   7224,  RCHAR,  RCHAR,   7585,  RCHAR,   4852,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6130,  RCHAR,  RCHAR,   3923,  RCHAR,
    4713,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4111,
   RCHAR,  RCHAR,   7570,   7966,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    3911,
  // [0x7B0F,0x7B11] -v # seg 832 at pos 18808
    8537,  RCHAR,   6052,
  // [0x7B19,0x7B2D] -v # seg 834 at pos 18811
    5900,  RCHAR,   7299,  RCHAR,  RCHAR,   8117,  RCHAR,   5171,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5651,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7440,   5010,
  // [0x7B39,0x7B39] -> [  6026,  6026] # seg 836
  // [0x7B46,0x7B56] -v # seg 838 at pos 18832
    8293,  RCHAR,  RCHAR,   4878,  RCHAR,   4458,   7338,   6185,
   RCHAR,   5525,   4273,   7967,   8136,  RCHAR,   4744,  RCHAR,
    7801,
  // [0x7B60,0x7B60] -> [  4438,  4438] # seg 840
  // [0x7B6C,0x7B75] -v # seg 842 at pos 18849
    6015,  RCHAR,   5918,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6546,
  // [0x7B7D,0x7B7D] -> [  6677,  6677] # seg 844
  // [0x7B87,0x7BA1] -v # seg 846 at pos 18859
    3992,  RCHAR,  RCHAR,  RCHAR,   7339,  RCHAR,  RCHAR,  RCHAR,
    7257,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5413,   4536,  RCHAR,
    5836,  RCHAR,  RCHAR,   7723,  RCHAR,  RCHAR,   4077,  RCHAR,
   RCHAR,  RCHAR,   4252,
  // [0x7BAD,0x7BB8] -v # seg 848 at pos 18886
    7340,  RCHAR,  RCHAR,  RCHAR,   5880,  RCHAR,  RCHAR,   7198,
   RCHAR,  RCHAR,  RCHAR,   7275,
  // [0x7BC0,0x7BC9] -v # seg 850 at pos 18898
    7360,   8607,  RCHAR,  RCHAR,   5535,  RCHAR,   7341,   8202,
   RCHAR,   7968,
  // [0x7BD2,0x7BD2] -> [  6260,  6260] # seg 852
  // [0x7BE0,0x7BE9] -v # seg 854 at pos 18908
    6053,  RCHAR,  RCHAR,  RCHAR,   4824,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5805,
  // [0x7C07,0x7C07] -> [  7499,  7499] # seg 856
  // [0x7C12,0x7C12] -> [  7741,  7741] # seg 858
  // [0x7C1E,0x7C2B] -v # seg 860 at pos 18918
    4714,  RCHAR,  RCHAR,   3912,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   8608,  RCHAR,  RCHAR,   7199,   6054,
  // [0x7C3D,0x7C43] -v # seg 862 at pos 18932
    7857,   5000,   5652,  RCHAR,  RCHAR,  RCHAR,   4917,
  // [0x7C4C,0x7C4D] -v # seg 864 at pos 18939
    7554,   7300,
  // [0x7C60,0x7C64] -v # seg 866 at pos 18941
    5056,  RCHAR,  RCHAR,  RCHAR,   7858,
  // [0x7C6C,0x7C73] -v # seg 868 at pos 18946
    5145,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5380,
  // [0x7C83,0x7C89] -v # seg 870 at pos 18954
    5730,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5686,
  // [0x7C92,0x7CBE] -v # seg 872 at pos 18961
    5172,  RCHAR,  RCHAR,   5414,  RCHAR,   7481,   7367,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6071,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7571,  RCHAR,   7225,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4946,  RCHAR,  RCHAR,   4947,
    7743,   4002,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6131,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7412,
  // [0x7CCA,0x7CCA] -> [  8512,  8512] # seg 874
  // [0x7CD6,0x7CD6] -> [  4755,  4755] # seg 876
  // [0x7CDE,0x7CE7] -v # seg 878 at pos 19006
    5687,   7482,   3966,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4948,
  // [0x7CFB,0x7D22] -v # seg 880 at pos 19016
    4142,  RCHAR,  RCHAR,   4429,  RCHAR,   4537,  RCHAR,   7555,
   RCHAR,   6410,   8544,   6832,   8711,   8581,  RCHAR,   5359,
    5360,  RCHAR,   4606,  RCHAR,  RCHAR,   4684,  RCHAR,  RCHAR,
   RCHAR,   6186,  RCHAR,  RCHAR,   5806,   4289,   7634,   4485,
    5688,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6055,   5474,   5894,
  // [0x7D2B,0x7D3A] -v # seg 882 at pos 19056
    7168,   7556,  RCHAR,   7754,   5086,   6027,  RCHAR,  RCHAR,
    6278,  RCHAR,   7276,  RCHAR,  RCHAR,  RCHAR,   6056,   3943,
  // [0x7D42,0x7D46] -v # seg 884 at pos 19072
    7516,   8430,   7483,   4112,   5441,
  // [0x7D50,0x7D50] -> [  4072,  4072] # seg 886
  // [0x7D5E,0x7D7F] -v # seg 888 at pos 19077
    4306,  RCHAR,  RCHAR,   4896,   8431,  RCHAR,  RCHAR,  RCHAR,
    4486,  RCHAR,   7009,  RCHAR,   7112,  RCHAR,  RCHAR,  RCHAR,
    5919,  RCHAR,  RCHAR,   8137,   5807,   3967,  RCHAR,  RCHAR,
    7361,  RCHAR,  RCHAR,   4062,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4352,
  // [0x7D8E,0x7D93] -v # seg 890 at pos 19111
    7413,   6132,  RCHAR,  RCHAR,  RCHAR,   4113,
  // [0x7D9C,0x7DA2] -v # seg 892 at pos 19117
    7517,  RCHAR,  RCHAR,  RCHAR,   5045,  RCHAR,   7557,
  // [0x7DAC,0x7DBF] -v # seg 894 at pos 19124
    6133,   6966,  RCHAR,  RCHAR,  RCHAR,   3968,   5218,  RCHAR,
    7847,   7794,  RCHAR,  RCHAR,   5113,  RCHAR,   4538,   8093,
   RCHAR,   7185,   5126,   5259,
  // [0x7DC7,0x7DCB] -v # seg 896 at pos 19144
    8026,  RCHAR,  RCHAR,   4555,   5731,
  // [0x7DD6,0x7DFB] -v # seg 898 at pos 19149
    5920,  RCHAR,   8340,  RCHAR,   5963,  RCHAR,  RCHAR,   7706,
    4715,  RCHAR,   7884,   5398,  RCHAR,   6547,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8203,   6721,  RCHAR,  RCHAR,   5260,  RCHAR,
   RCHAR,   6914,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4984,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8027,
  // [0x7E09,0x7E0A] -v # seg 900 at pos 19187
    7672,   6389,
  // [0x7E15,0x7E23] -v # seg 902 at pos 19189
    6691,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5415,  RCHAR,
    7673,   8513,   6785,  RCHAR,   7250,  RCHAR,   8432,
  // [0x7E2B,0x7E47] -v # seg 904 at pos 19204
    5623,  RCHAR,  RCHAR,   7969,   6549,  RCHAR,   7518,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5087,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7932,   7301,  RCHAR,  RCHAR,   5520,  RCHAR,
    5701,  RCHAR,  RCHAR,   5343,   6770,
  // [0x7E52,0x7E55] -v # seg 906 at pos 19233
    7608,  RCHAR,   7649,   5964,
  // [0x7E5E,0x7E61] -v # seg 908 at pos 19237
    6771,  RCHAR,  RCHAR,   6134,
  // [0x7E69,0x7E70] -v # seg 910 at pos 19241
    6220,   8628,   4143,  RCHAR,   4063,  RCHAR,  RCHAR,   7484,
  // [0x7E79,0x7E82] -v # seg 912 at pos 19249
    6511,  RCHAR,  RCHAR,   4144,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7742,
  // [0x7E8C,0x7E9C] -v # seg 914 at pos 19259
    6072,  RCHAR,  RCHAR,   7342,  RCHAR,  RCHAR,  RCHAR,   6616,
   RCHAR,  RCHAR,   5994,  RCHAR,   7744,  RCHAR,  RCHAR,   4825,
    4918,
  // [0x7F36,0x7F3A] -v # seg 916 at pos 19276
    5653,  RCHAR,   8363,  RCHAR,   4073,
  // [0x7F4C,0x7F55] -v # seg 918 at pos 19281
    6393,  RCHAR,  RCHAR,  RCHAR,   4253,  RCHAR,  RCHAR,  RCHAR,
    5219,   8325,
  // [0x7F6A,0x7F79] -v # seg 920 at pos 19291
    7529,   4278,  RCHAR,  RCHAR,   8028,  RCHAR,   5526,  RCHAR,
    5921,  RCHAR,  RCHAR,   5234,  RCHAR,   8166,  RCHAR,   5146,
  // [0x7F85,0x7FA9] -v # seg 922 at pos 19307
    4887,  RCHAR,  RCHAR,   4539,  RCHAR,   6438,  RCHAR,   3969,
   RCHAR,   5381,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4171,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5011,  RCHAR,  RCHAR,
   RCHAR,   6135,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4379,
   RCHAR,  RCHAR,  RCHAR,   5965,   7044,
  // [0x7FB2,0x7FD5] -v # seg 924 at pos 19344
    8740,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5147,   4003,
   RCHAR,  RCHAR,  RCHAR,   6833,  RCHAR,  RCHAR,  RCHAR,   6699,
   RCHAR,  RCHAR,  RCHAR,   6242,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7094,  RCHAR,   7095,  RCHAR,   5012,  RCHAR,  RCHAR,  RCHAR,
    6210,  RCHAR,   5881,   8719,
  // [0x7FDF,0x7FE1] -v # seg 926 at pos 19380
    7302,   7997,   5732,
  // [0x7FE9,0x7FF0] -v # seg 928 at pos 19383
    8204,  RCHAR,   6722,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8326,
  // [0x7FF9,0x8018] -v # seg 930 at pos 19391
    4307,  RCHAR,  RCHAR,   7096,  RCHAR,  RCHAR,  RCHAR,   6772,
    5034,  RCHAR,   4172,  RCHAR,   7169,   4540,  RCHAR,  RCHAR,
    4353,  RCHAR,  RCHAR,   7076,  RCHAR,  RCHAR,  RCHAR,   4622,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4114,  RCHAR,   5299,   6859,
  // [0x802D,0x804A] -v # seg 932 at pos 19423
    4541,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7077,  RCHAR,
   RCHAR,   6404,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8099,  RCHAR,   4115,  RCHAR,  RCHAR,  RCHAR,   4735,  RCHAR,
   RCHAR,   5013,  RCHAR,  RCHAR,  RCHAR,   5074,
  // [0x8056,0x805E] -v # seg 934 at pos 19453
    6016,  RCHAR,   5762,  RCHAR,   7998,  RCHAR,  RCHAR,  RCHAR,
    5361,
  // [0x806F,0x808C] -v # seg 936 at pos 19462
    4985,   7933,  RCHAR,   6017,   6805,  RCHAR,  RCHAR,  RCHAR,
    7650,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7874,   5057,
    7006,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7078,   6169,   5808,
    7485,  RCHAR,   6986,  RCHAR,   5121,   4542,
  // [0x8096,0x80BA] -v # seg 938 at pos 19492
    7906,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8364,  RCHAR,   3913,
   RCHAR,  RCHAR,  RCHAR,   4173,   7635,  RCHAR,  RCHAR,   5733,
   RCHAR,  RCHAR,  RCHAR,   4064,   5475,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4490,  RCHAR,   4290,   6987,  RCHAR,   8649,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8220,
  // [0x80C3,0x80C4] -v # seg 940 at pos 19529
    6915,   7535,
  // [0x80CC,0x80CE] -v # seg 942 at pos 19531
    5497,  RCHAR,   8118,
  // [0x80DA,0x80E5] -v # seg 944 at pos 19534
    5498,   3951,  RCHAR,  RCHAR,   8241,  RCHAR,  RCHAR,   8514,
   RCHAR,  RCHAR,   6997,   5922,
  // [0x80F1,0x810A] -v # seg 946 at pos 19546
    4274,  RCHAR,  RCHAR,   4853,  RCHAR,  RCHAR,  RCHAR,   8703,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4691,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7636,  RCHAR,  RCHAR,   8451,   7999,   8452,   5239,
   RCHAR,   7818,
  // [0x8118,0x811B] -v # seg 948 at pos 19572
    6723,  RCHAR,   3890,   4116,
  // [0x8123,0x812F] -v # seg 950 at pos 19576
    6187,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6136,  RCHAR,
    8096,  RCHAR,  RCHAR,  RCHAR,   8242,
  // [0x8139,0x813E] -v # seg 952 at pos 19589
    7783,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5734,
  // [0x814B,0x8155] -v # seg 954 at pos 19595
    6390,  RCHAR,  RCHAR,   6279,  RCHAR,   5654,   5655,  RCHAR,
   RCHAR,   3970,   6724,
  // [0x8165,0x8180] -v # seg 956 at pos 19606
    6018,   4669,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7519,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6773,   4029,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7226,   5602,   5966,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8141,   5476,
  // [0x8188,0x818F] -v # seg 958 at pos 19634
    4055,  RCHAR,   5416,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4174,
  // [0x819A,0x81A8] -v # seg 960 at pos 19642
    5656,  RCHAR,   5184,   6206,  RCHAR,  RCHAR,   4308,  RCHAR,
   RCHAR,   7696,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8196,
  // [0x81B3,0x81CD] -v # seg 962 at pos 19657
    5967,  RCHAR,   7988,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7031,
   RCHAR,  RCHAR,   4736,   8629,   4664,   4868,  RCHAR,   5735,
   RCHAR,  RCHAR,  RCHAR,   6461,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7441,
  // [0x81D8,0x8212] -v # seg 964 at pos 19684
    4923,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7227,
   RCHAR,  RCHAR,  RCHAR,   6280,  RCHAR,   6707,  RCHAR,   7228,
    5167,  RCHAR,   7170,  RCHAR,  RCHAR,   8000,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7637,   8029,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4769,   7674,   4354,  RCHAR,   6967,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4355,  RCHAR,   6493,
    8720,  RCHAR,   4356,  RCHAR,   5984,   5809,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5923,
  // [0x821B,0x8221] -v # seg 966 at pos 19743
    7832,   6188,  RCHAR,   5344,   7558,  RCHAR,   3971,
  // [0x822A,0x822C] -v # seg 968 at pos 19750
    8365,   5477,   5442,
  // [0x8235,0x8247] -v # seg 970 at pos 19753
    8065,   5417,   8433,  RCHAR,   5968,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5657,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6494,  RCHAR,   7414,
  // [0x8259,0x8259] -> [  7784,  7784] # seg 972
  // [0x8264,0x8266] -v # seg 974 at pos 19772
    7045,  RCHAR,   8341,
  // [0x826E,0x827E] -v # seg 976 at pos 19775
    3914,   4949,  RCHAR,   3915,   5895,  RCHAR,  RCHAR,  RCHAR,
    6578,  RCHAR,   7907,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6382,
  // [0x828B,0x82BF] -v # seg 978 at pos 19792
    6834,  RCHAR,   7186,   4391,  RCHAR,  RCHAR,  RCHAR,   5220,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5658,   4869,
   RCHAR,  RCHAR,   7638,  RCHAR,   5850,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   3993,   8515,  RCHAR,  RCHAR,   4474,  RCHAR,
   RCHAR,   5689,   8167,   6639,   6302,  RCHAR,   8556,  RCHAR,
    5478,  RCHAR,  RCHAR,  RCHAR,   7639,   6860,   4459,  RCHAR,
    7949,   5300,   6317,  RCHAR,   7150,
  // [0x82D1,0x82E7] -v # seg 980 at pos 19845
    6890,   6579,  RCHAR,   8119,   7908,  RCHAR,   5327,  RCHAR,
   RCHAR,  RCHAR,   3873,  RCHAR,  RCHAR,   8243,   4357,  RCHAR,
    7079,  RCHAR,  RCHAR,  RCHAR,   6411,   4175,   7277,
  // [0x82F1,0x82F1] -> [  6619,  6619] # seg 982
  // [0x82FD,0x8309] -v # seg 984 at pos 19868
    4176,   8294,  RCHAR,  RCHAR,   7591,   5345,   5536,   3874,
    5301,  RCHAR,  RCHAR,  RCHAR,   5210,
  // [0x8317,0x8317] -> [  5274,  5274] # seg 986
  // [0x8328,0x8352] -v # seg 988 at pos 19881
    7171,  RCHAR,  RCHAR,   5221,  RCHAR,  RCHAR,  RCHAR,   5603,
   RCHAR,   6137,  RCHAR,  RCHAR,   8630,   7113,   4699,  RCHAR,
    6806,   6495,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6189,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8392,
   RCHAR,   7909,   8469,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7140,
   RCHAR,   7080,   8609,
  // [0x8373,0x837B] -v # seg 990 at pos 19924
    4862,  RCHAR,  RCHAR,  RCHAR,   8306,  RCHAR,  RCHAR,  RCHAR,
    7303,
  // [0x8389,0x838E] -v # seg 992 at pos 19933
    5148,   7229,  RCHAR,  RCHAR,  RCHAR,   5810,
  // [0x8396,0x83AB] -v # seg 994 at pos 19939
    4117,  RCHAR,   6281,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6725,  RCHAR,  RCHAR,  RCHAR,   8453,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5659,   6318,   5185,
  // [0x83BD,0x83DC] -v # seg 996 at pos 19961
    5222,  RCHAR,  RCHAR,  RCHAR,   7875,  RCHAR,  RCHAR,  RCHAR,
    4254,  RCHAR,  RCHAR,  RCHAR,   5046,   4373,  RCHAR,   4439,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4231,  RCHAR,
   RCHAR,   7785,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7795,
  // [0x83E9,0x840E] -v # seg 998 at pos 19993
    5589,  RCHAR,   4460,  RCHAR,  RCHAR,  RCHAR,   8557,   4177,
    5127,   5736,  RCHAR,   6361,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7278,  RCHAR,  RCHAR,  RCHAR,   6170,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7989,   4805,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4936,  RCHAR,   5249,   8212,   6916,
  // [0x8429,0x843D] -v # seg 1000 at pos 20031
    7950,  RCHAR,  RCHAR,   5200,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8679,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6968,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4897,
  // [0x8449,0x8449] -> [  6587,  6587] # seg 1002
  // [0x8457,0x847A] -v # seg 1004 at pos 20052
    7279,  RCHAR,  RCHAR,  RCHAR,   3924,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8244,  RCHAR,   4854,  RCHAR,  RCHAR,   6917,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8516,   7230,  RCHAR,  RCHAR,
    6412,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4430,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7600,
  // [0x8490,0x84A1] -v # seg 1006 at pos 20088
    6138,  RCHAR,  RCHAR,  RCHAR,   6243,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5316,  RCHAR,  RCHAR,   5837,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5479,
  // [0x84B2,0x84D1] -v # seg 1008 at pos 20106
    8245,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7609,  RCHAR,
   RCHAR,   6413,   7786,  RCHAR,  RCHAR,   8517,   6079,  RCHAR,
    5275,  RCHAR,   7970,  RCHAR,   5943,  RCHAR,  RCHAR,   6807,
   RCHAR,   3994,  RCHAR,   6244,  RCHAR,  RCHAR,  RCHAR,   5811,
  // [0x84DA,0x84DA] -> [  6139,  6139] # seg 1010
  // [0x84EC,0x84F4] -v # seg 1012 at pos 20138
    5624,  RCHAR,   4986,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6190,
  // [0x84FC,0x84FC] -> [  5075,  5075] # seg 1014
  // [0x8511,0x852F] -v # seg 1016 at pos 20147
    5264,  RCHAR,   5201,   5604,  RCHAR,  RCHAR,   7172,   5851,
   RCHAR,   6866,  RCHAR,  RCHAR,  RCHAR,   5088,  RCHAR,  RCHAR,
    7796,  RCHAR,   7231,  RCHAR,   7934,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6057,   7022,  RCHAR,   7675,
  // [0x853D,0x8559] -v # seg 1018 at pos 20178
    8221,  RCHAR,   6918,  RCHAR,   4737,  RCHAR,   5521,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7910,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4309,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6861,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   8481,
  // [0x8563,0x856D] -v # seg 1020 at pos 20207
    6191,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4405,   8108,   5346,
   RCHAR,  RCHAR,   6058,
  // [0x8584,0x8587] -v # seg 1022 at pos 20218
    5418,  RCHAR,  RCHAR,   5382,
  // [0x858F,0x859B] -v # seg 1024 at pos 20222
    7046,  RCHAR,   3972,  RCHAR,  RCHAR,   7232,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5985,
  // [0x85A6,0x85B0] -v # seg 1026 at pos 20235
    7833,  RCHAR,   8675,   5844,   6282,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5924,   8672,
  // [0x85BA,0x85C1] -v # seg 1028 at pos 20246
    7442,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4178,
  // [0x85C9,0x85EA] -v # seg 1030 at pos 20254
    7173,  RCHAR,  RCHAR,  RCHAR,   4919,   6283,   7233,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6835,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4964,   6640,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4879,   6414,  RCHAR,  RCHAR,  RCHAR,
    5522,   6140,
  // [0x85F7,0x860A] -v # seg 1032 at pos 20288
    7280,  RCHAR,  RCHAR,   5159,   7486,  RCHAR,  RCHAR,  RCHAR,
    4240,  RCHAR,  RCHAR,   6641,  RCHAR,  RCHAR,  RCHAR,   5035,
    6059,  RCHAR,  RCHAR,   6692,
  // [0x8616,0x861A] -v # seg 1034 at pos 20308
    6469,   5547,  RCHAR,  RCHAR,   5969,
  // [0x862D,0x862D] -> [  4908,  4908] # seg 1036
  // [0x863F,0x863F] -> [  4888,  4888] # seg 1038
  // [0x864E,0x865F] -v # seg 1040 at pos 20313
    8518,  RCHAR,   8314,  RCHAR,  RCHAR,  RCHAR,   4030,   7806,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8405,   5036,  RCHAR,
    6836,   8519,
  // [0x8667,0x8667] -> [  8695,  8695] # seg 1042
  // [0x8679,0x8679] -> [  8545,  8545] # seg 1044
  // [0x868A,0x8693] -v # seg 1046 at pos 20331
    5362,  RCHAR,   5480,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7115,
  // [0x86A3,0x86A9] -v # seg 1048 at pos 20341
    4222,   7487,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8030,
  // [0x86C7,0x86CB] -v # seg 1050 at pos 20348
    5812,  RCHAR,  RCHAR,  RCHAR,   4716,
  // [0x86D4,0x86E4] -v # seg 1052 at pos 20353
    8631,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6708,  RCHAR,   7559,
   RCHAR,  RCHAR,  RCHAR,   4310,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8348,
  // [0x86ED,0x86ED] -> [  7697,  7697] # seg 1054
  // [0x86FE,0x8708] -v # seg 1056 at pos 20370
    6319,  RCHAR,   7920,  RCHAR,   5625,   6284,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6678,
  // [0x8718,0x871C] -v # seg 1058 at pos 20381
    7640,  RCHAR,   5737,  RCHAR,   5401,
  // [0x874E,0x8757] -v # seg 1060 at pos 20386
    3926,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6261,
   RCHAR,   8610,
  // [0x875F,0x8768] -v # seg 1062 at pos 20396
    6919,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8307,
   RCHAR,   6207,
  // [0x8774,0x8778] -v # seg 1064 at pos 20406
    8520,  RCHAR,   7373,  RCHAR,   6709,
  // [0x8782,0x8782] -> [  4931,  4931] # seg 1066
  // [0x878D,0x878D] -> [  7010,  7010] # seg 1068
  // [0x879F,0x87A2] -v # seg 1070 at pos 20411
    5276,  RCHAR,  RCHAR,   8470,
  // [0x87B3,0x87BA] -v # seg 1072 at pos 20415
    4756,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4889,
  // [0x87C4,0x87C4] -> [  8051,  8051] # seg 1074
  // [0x87E0,0x87E0] -> [  5443,  5443] # seg 1076
  // [0x87EC,0x8805] -v # seg 1078 at pos 20423
    5970,  RCHAR,  RCHAR,   6775,  RCHAR,  RCHAR,   7984,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8380,  RCHAR,   7047,
   RCHAR,  RCHAR,   5995,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6221,
  // [0x881F,0x8823] -v # seg 1080 at pos 20449
    4924,  RCHAR,  RCHAR,   7586,   4965,
  // [0x8831,0x889E] -v # seg 1082 at pos 20454
    4179,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7200,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5202,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8441,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7594,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8393,   6551,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   8434,   6199,  RCHAR,  RCHAR,  RCHAR,   3875,  RCHAR,
    6320,  RCHAR,   6920,  RCHAR,   7985,  RCHAR,  RCHAR,  RCHAR,
    8471,   4358,   7048,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8267,
   RCHAR,  RCHAR,   5852,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6096,
   RCHAR,   4609,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7986,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4475,   4476,  RCHAR,
    6891,   5280,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3876,
   RCHAR,  RCHAR,   4770,  RCHAR,   8246,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4717,  RCHAR,  RCHAR,  RCHAR,   6141,   7676,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4204,
  // [0x88AB,0x88AB] -> [  8283,  8283] # seg 1084
  // [0x88B4,0x88B4] -> [  4180,  4180] # seg 1086
  // [0x88C1,0x88C2] -v # seg 1088 at pos 20564
    7251,   4995,
  // [0x88CF,0x88E8] -v # seg 1090 at pos 20566
    5149,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6643,   6969,  RCHAR,
   RCHAR,  RCHAR,   4380,  RCHAR,  RCHAR,   5590,   7234,  RCHAR,
    5813,  RCHAR,   5150,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5738,
  // [0x88F3,0x88FD] -v # seg 1092 at pos 20592
    5882,   5499,   5500,  RCHAR,  RCHAR,   4890,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7443,
  // [0x8907,0x8907] -> [  5605,  5605] # seg 1094
  // [0x8910,0x8919] -v # seg 1096 at pos 20603
    3925,  RCHAR,   8247,   5591,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6921,   5501,
  // [0x8925,0x892A] -v # seg 1098 at pos 20613
    6786,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8142,
  // [0x8936,0x8944] -v # seg 1100 at pos 20619
    6211,  RCHAR,   5089,  RCHAR,  RCHAR,   5986,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   3973,  RCHAR,  RCHAR,   6440,
  // [0x895F,0x896A] -v # seg 1102 at pos 20634
    4477,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4920,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5211,
  // [0x8972,0x8972] -> [  6212,  6212] # seg 1104
  // [0x897F,0x8996] -v # seg 1106 at pos 20646
    5925,  RCHAR,   6776,  RCHAR,   4738,  RCHAR,  RCHAR,   5606,
    8191,  RCHAR,  RCHAR,  RCHAR,   4065,  RCHAR,  RCHAR,  RCHAR,
    4431,  RCHAR,  RCHAR,  RCHAR,   5251,  RCHAR,  RCHAR,   6245,
  // [0x89A1,0x89A1] -> [  4056,  4056] # seg 1108
  // [0x89A9,0x89AA] -v # seg 1110 at pos 20670
    4806,   8038,
  // [0x89B2,0x89B2] -> [  4461,  4461] # seg 1112
  // [0x89BA,0x89C0] -v # seg 1114 at pos 20672
    3891,  RCHAR,  RCHAR,   4921,  RCHAR,  RCHAR,   4255,
  // [0x89D2,0x89D2] -> [  3892,  3892] # seg 1116
  // [0x89E3,0x89E3] -> [  8381,  8381] # seg 1118
  // [0x89F4,0x89F8] -v # seg 1120 at pos 20679
    5883,  RCHAR,  RCHAR,  RCHAR,   7921,
  // [0x8A00,0x8A3B] -v # seg 1122 at pos 20684
    6466,  RCHAR,   7415,   5660,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4145,  RCHAR,   6285,  RCHAR,   8546,  RCHAR,   8131,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8673,  RCHAR,  RCHAR,   8712,   8083,
    4543,  RCHAR,  RCHAR,   6710,  RCHAR,   6321,  RCHAR,   6087,
   RCHAR,  RCHAR,  RCHAR,   4074,  RCHAR,   4682,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5481,  RCHAR,  RCHAR,   5987,  RCHAR,  RCHAR,
   RCHAR,   8406,  RCHAR,  RCHAR,   6060,  RCHAR,   3877,  RCHAR,
   RCHAR,  RCHAR,   7677,   7560,
  // [0x8A50,0x8A79] -v # seg 1124 at pos 20744
    5814,  RCHAR,  RCHAR,  RCHAR,   7488,   8213,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7281,  RCHAR,  RCHAR,   5815,  RCHAR,
    6620,  RCHAR,   6192,   6644,  RCHAR,  RCHAR,   6246,  RCHAR,
   RCHAR,   6247,  RCHAR,  RCHAR,  RCHAR,   4411,   7343,  RCHAR,
    8741,   8558,   8382,   5884,  RCHAR,   5971,  RCHAR,  RCHAR,
   RCHAR,   7859,
  // [0x8A85,0x8B04] -v # seg 1126 at pos 20786
    7561,  RCHAR,   4232,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7641,
    7116,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5926,  RCHAR,
    8094,  RCHAR,  RCHAR,   6970,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6453,  RCHAR,   6019,   4146,  RCHAR,   5347,   6679,
    4181,   6088,  RCHAR,   8632,  RCHAR,   5988,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6142,  RCHAR,   4233,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5739,  RCHAR,  RCHAR,   7049,
   RCHAR,   7016,   7489,  RCHAR,  RCHAR,   7860,  RCHAR,   6193,
   RCHAR,  RCHAR,   4739,  RCHAR,  RCHAR,  RCHAR,   7876,  RCHAR,
    7258,  RCHAR,   7951,  RCHAR,  RCHAR,   4950,  RCHAR,  RCHAR,
   RCHAR,   5050,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6971,   7868,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6248,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7885,   8383,  RCHAR,  RCHAR,   7416,   3916,  RCHAR,
    6972,   7174,  RCHAR,  RCHAR,   8688,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6303,   8275,   7444,  RCHAR,   6467,  RCHAR,  RCHAR,
   RCHAR,   4582,  RCHAR,   5302,   6352,   6922,  RCHAR,   4880,
  // [0x8B0E,0x8B20] -v # seg 1128 at pos 20914
    5383,  RCHAR,   5402,  RCHAR,  RCHAR,  RCHAR,   8315,  RCHAR,
    6073,   5482,  RCHAR,   4078,   7097,   3974,  RCHAR,   5816,
   RCHAR,  RCHAR,   6777,
  // [0x8B28,0x8B39] -v # seg 1130 at pos 20933
    5303,  RCHAR,  RCHAR,   7304,   5104,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4359,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4462,
  // [0x8B41,0x8B41] -> [  8559,  8559] # seg 1132
  // [0x8B49,0x8B4F] -v # seg 1134 at pos 20951
    7610,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8697,   4544,
  // [0x8B58,0x8B5C] -v # seg 1136 at pos 20958
    6262,  RCHAR,   4740,  RCHAR,   5592,
  // [0x8B66,0x8B80] -v # seg 1138 at pos 20963
    4118,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5740,  RCHAR,
   RCHAR,   6512,   7050,  RCHAR,  RCHAR,  RCHAR,   4066,  RCHAR,
   RCHAR,   8521,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6645,
   RCHAR,  RCHAR,   4826,
  // [0x8B8A,0x8B9A] -v # seg 1140 at pos 20990
    5553,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6143,  RCHAR,
    7763,   6442,  RCHAR,  RCHAR,   7764,  RCHAR,  RCHAR,  RCHAR,
    7745,
  // [0x8C37,0x8C37] -> [  4194,  4194] # seg 1142
  // [0x8C3F,0x8C4C] -v # seg 1144 at pos 21007
    4147,  RCHAR,   8588,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4864,
   RCHAR,   4545,  RCHAR,   8276,  RCHAR,   6726,
  // [0x8C55,0x8C61] -v # seg 1146 at pos 21021
    6249,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4835,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5885,
  // [0x8C6A,0x8C6B] -v # seg 1148 at pos 21034
    8522,   6646,
  // [0x8C79,0x8C7A] -v # seg 1150 at pos 21036
    8268,   6250,
  // [0x8C82,0x8C82] -> [  7911,  7911] # seg 1152
  // [0x8C8A,0x8C8C] -v # seg 1154 at pos 21038
    5240,  RCHAR,   5304,
  // [0x8C9D,0x8D16] -v # seg 1156 at pos 21041
    8192,   7417,  RCHAR,   5661,   7252,   4223,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5757,   8560,   8175,   8100,   4256,   7802,
   RCHAR,  RCHAR,   7282,   6029,  RCHAR,  RCHAR,   7084,   4417,
   RCHAR,   8208,   5235,   4771,  RCHAR,  RCHAR,   5741,   7869,
    7083,  RCHAR,   5348,   8308,   5690,   5062,   7141,   8633,
   RCHAR,  RCHAR,   7175,   3878,  RCHAR,   7305,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7678,  RCHAR,   5758,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5063,  RCHAR,   5817,
   RCHAR,   5886,  RCHAR,   5502,  RCHAR,   8436,   5236,   7834,
   RCHAR,   5662,  RCHAR,  RCHAR,  RCHAR,   7698,  RCHAR,  RCHAR,
    4807,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5064,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5663,   4360,
    5890,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7643,
    7990,  RCHAR,   6998,   7611,  RCHAR,   7746,  RCHAR,  RCHAR,
    5996,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7235,  RCHAR,
   RCHAR,   6074,
  // [0x8D64,0x8D77] -v # seg 1158 at pos 21163
    7306,  RCHAR,   5818,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8416,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7562,  RCHAR,  RCHAR,   4432,
    5664,  RCHAR,  RCHAR,   4546,
  // [0x8D85,0x8D8A] -v # seg 1160 at pos 21183
    7912,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6899,
  // [0x8D99,0x8D99] -> [  7490,  7490] # seg 1162
  // [0x8DA3,0x8DA8] -v # seg 1164 at pos 21189
    8001,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7952,
  // [0x8DB3,0x8DBE] -v # seg 1166 at pos 21195
    7500,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5665,
   RCHAR,  RCHAR,  RCHAR,   7644,
  // [0x8DC6,0x8DCF] -v # seg 1168 at pos 21207
    8120,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5453,   7699,  RCHAR,
   RCHAR,   3879,
  // [0x8DDB,0x8DF3] -v # seg 1170 at pos 21217
    8168,  RCHAR,   4016,  RCHAR,  RCHAR,  RCHAR,   7307,  RCHAR,
    5972,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4234,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5037,  RCHAR,  RCHAR,  RCHAR,
    4808,
  // [0x8E0A,0x8E10] -v # seg 1172 at pos 21242
    6808,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4745,   7835,
  // [0x8E1E,0x8E1E] -> [  4017,  4017] # seg 1174
  // [0x8E2A,0x8E35] -v # seg 1176 at pos 21249
    7520,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6973,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7521,
  // [0x8E42,0x8E4A] -v # seg 1178 at pos 21261
    6974,  RCHAR,   7445,  RCHAR,  RCHAR,   4031,   4809,   7725,
    8482,
  // [0x8E59,0x8E60] -v # seg 1180 at pos 21270
    7971,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7308,   7819,
  // [0x8E74,0x8E76] -v # seg 1182 at pos 21278
    7972,  RCHAR,   4406,
  // [0x8E81,0x8E8D] -v # seg 1184 at pos 21281
    7491,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7283,  RCHAR,
   RCHAR,   7563,  RCHAR,  RCHAR,   6415,
  // [0x8EAA,0x8EAC] -v # seg 1186 at pos 21294
    5160,   6286,   4392,
  // [0x8EC0,0x8EC0] -> [  4361,  4361] # seg 1188
  // [0x8ECA,0x8ED2] -v # seg 1190 at pos 21297
    7726,   6353,   4412,   4381,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8410,
  // [0x8EDF,0x8EDF] -> [  6552,  6552] # seg 1192
  // [0x8EEB,0x8EEB] -> [  7679,  7679] # seg 1194
  // [0x8EF8,0x8F09] -v # seg 1196 at pos 21306
    7973,  RCHAR,  RCHAR,   3880,  RCHAR,  RCHAR,   6263,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4311,  RCHAR,   5038,  RCHAR,  RCHAR,
   RCHAR,   7253,
  // [0x8F12,0x8F4E] -v # seg 1198 at pos 21324
    7870,   5203,   5593,   4119,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4951,   8031,   8689,   5223,   7848,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4987,   5575,  RCHAR,   5503,
    5114,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7707,  RCHAR,  RCHAR,
   RCHAR,   7564,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6144,   5607,
   RCHAR,   5608,  RCHAR,  RCHAR,   7344,   6496,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   8332,   6892,  RCHAR,  RCHAR,  RCHAR,   7345,
   RCHAR,  RCHAR,  RCHAR,   7849,   4312,
  // [0x8F5D,0x8F62] -v # seg 1200 at pos 21385
    6497,  RCHAR,   4291,  RCHAR,  RCHAR,   4976,
  // [0x8F9B,0x8FB2] -v # seg 1202 at pos 21391
    6287,   4183,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4911,  RCHAR,  RCHAR,   8176,  RCHAR,   5554,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5819,  RCHAR,   5555,   7680,   6787,   4665,
  // [0x8FC2,0x8FC5] -v # seg 1204 at pos 21415
    6837,  RCHAR,  RCHAR,   6289,
  // [0x8FCE,0x8FD4] -v # seg 1206 at pos 21419
    6621,  RCHAR,  RCHAR,   4463,  RCHAR,  RCHAR,   5444,
  // [0x8FE6,0x9023] -v # seg 1208 at pos 21426
    3881,  RCHAR,  RCHAR,  RCHAR,   7309,   5419,  RCHAR,   7700,
   RCHAR,  RCHAR,   6200,  RCHAR,   4047,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5384,  RCHAR,   7310,  RCHAR,  RCHAR,  RCHAR,   7953,
   RCHAR,  RCHAR,   8143,   6089,   4262,   4810,  RCHAR,   8664,
    6514,  RCHAR,   8472,  RCHAR,  RCHAR,   8248,  RCHAR,   6061,
   RCHAR,   8149,   7974,   4362,  RCHAR,  RCHAR,   4811,   4120,
   RCHAR,   4865,  RCHAR,   7284,   8138,  RCHAR,  RCHAR,   5927,
    5014,   6075,   7492,   7587,   5626,   4988,
  // [0x902E,0x9099] -v # seg 1210 at pos 21488
    7886,  RCHAR,  RCHAR,   7565,   7681,  RCHAR,  RCHAR,   4433,
   RCHAR,  RCHAR,   7128,  RCHAR,  RCHAR,  RCHAR,   8297,  RCHAR,
    6976,  RCHAR,  RCHAR,   4870,   6145,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   6838,  RCHAR,  RCHAR,   6975,   6862,  RCHAR,   8205,
    4235,  RCHAR,   8309,   8611,  RCHAR,   4812,   4724,   6923,
   RCHAR,  RCHAR,  RCHAR,   6778,  RCHAR,  RCHAR,   6080,   4746,
    7887,  RCHAR,   6893,   6062,  RCHAR,   4067,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7311,  RCHAR,  RCHAR,  RCHAR,   7493,
    7727,   4871,  RCHAR,  RCHAR,   7645,  RCHAR,  RCHAR,   7588,
   RCHAR,   7836,   5973,  RCHAR,   6977,  RCHAR,   5076,   4019,
   RCHAR,   8284,   6780,   5237,   8384,   6146,   8582,  RCHAR,
   RCHAR,   7085,   5186,  RCHAR,   5556,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4891,  RCHAR,   7028,  RCHAR,  RCHAR,  RCHAR,   6700,
   RCHAR,  RCHAR,  RCHAR,   5224,
  // [0x90A2,0x90B8] -v # seg 1212 at pos 21596
    8473,   4576,  RCHAR,  RCHAR,   5483,  RCHAR,   7925,  RCHAR,
    5820,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3944,   8121,   4363,
   RCHAR,  RCHAR,  RCHAR,   6063,  RCHAR,  RCHAR,   7285,
  // [0x90C1,0x90C1] -> [  6851,  6851] # seg 1214
  // [0x90CA,0x90CA] -> [  4313,  4313] # seg 1216
  // [0x90DE,0x90ED] -v # seg 1218 at pos 21619
    4932,  RCHAR,  RCHAR,   4382,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5666,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4241,
  // [0x90F5,0x90F5] -> [  6839,  6839] # seg 1220
  // [0x90FD,0x9102] -v # seg 1222 at pos 21635
    4813,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6336,
  // [0x9112,0x9119] -v # seg 1224 at pos 21641
    7954,  RCHAR,  RCHAR,   8398,  RCHAR,  RCHAR,  RCHAR,   5742,
  // [0x9127,0x9132] -v # seg 1226 at pos 21649
    4881,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7418,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4718,
  // [0x9149,0x9152] -v # seg 1228 at pos 21661
    6978,   7419,   7955,   7187,   5504,   7566,  RCHAR,  RCHAR,
   RCHAR,   7567,
  // [0x9162,0x916C] -v # seg 1230 at pos 21671
    7913,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5277,
    4899,  RCHAR,   6147,
  // [0x9175,0x9178] -v # seg 1232 at pos 21682
    8650,  RCHAR,   8528,   5838,
  // [0x9187,0x9192] -v # seg 1234 at pos 21686
    6194,  RCHAR,   8002,  RCHAR,   7914,  RCHAR,   7446,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6020,
  // [0x919C,0x919C] -> [  7956,  7956] # seg 1236
  // [0x91AB,0x91B5] -v # seg 1238 at pos 21698
    7051,   7236,  RCHAR,   7915,   8483,  RCHAR,   5454,  RCHAR,
   RCHAR,   5023,   4004,
  // [0x91C0,0x91EA] -v # seg 1240 at pos 21709
    6443,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7797,
   RCHAR,   6979,  RCHAR,   5944,   5151,   7595,   6406,   4952,
    5152,   4560,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6097,
    7420,  RCHAR,  RCHAR,  RCHAR,   5667,   8049,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7494,  RCHAR,  RCHAR,  RCHAR,   7837,
   RCHAR,  RCHAR,   6840,
  // [0x91F5,0x91F5] -> [  7798,  7798] # seg 1242
  // [0x920D,0x921E] -v # seg 1244 at pos 21752
    4872,  RCHAR,  RCHAR,   4043,   8177,   5855,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7000,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4440,
  // [0x9234,0x9249] -v # seg 1246 at pos 21770
    5015,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6686,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7346,   3952,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4020,  RCHAR,  RCHAR,  RCHAR,   8437,
  // [0x9257,0x9266] -v # seg 1248 at pos 21792
    4079,  RCHAR,  RCHAR,  RCHAR,   6556,  RCHAR,  RCHAR,   6900,
   RCHAR,  RCHAR,  RCHAR,   5455,  RCHAR,   4364,   6201,   7421,
  // [0x9280,0x9285] -v # seg 1250 at pos 21808
    7017,  RCHAR,  RCHAR,   7935,  RCHAR,   4855,
  // [0x9291,0x929C] -v # seg 1252 at pos 21814
    5974,  RCHAR,   7347,  RCHAR,  RCHAR,   6148,  RCHAR,   5278,
   RCHAR,  RCHAR,  RCHAR,   8342,
  // [0x92B3,0x92B9] -v # seg 1254 at pos 21826
    6648,  RCHAR,  RCHAR,   4365,   6064,  RCHAR,   6149,
  // [0x92CC,0x92D2] -v # seg 1256 at pos 21833
    7422,  RCHAR,  RCHAR,   8454,  RCHAR,  RCHAR,   5627,
  // [0x92E4,0x92EA] -v # seg 1258 at pos 21840
    5928,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8249,
  // [0x92F8,0x92FC] -v # seg 1260 at pos 21847
    4021,  RCHAR,  RCHAR,  RCHAR,   3975,
  // [0x9304,0x9304] -> [  5047,  5047] # seg 1262
  // [0x9310,0x9310] -> [  7957,  7957] # seg 1264
  // [0x9318,0x932F] -v # seg 1266 at pos 21852
    7958,  RCHAR,   7259,  RCHAR,  RCHAR,  RCHAR,   6195,   4741,
    7423,   4547,   7348,  RCHAR,   4548,  RCHAR,   4479,  RCHAR,
    5328,  RCHAR,  RCHAR,   5945,  RCHAR,  RCHAR,   4184,   7732,
  // [0x9348,0x935B] -v # seg 1268 at pos 21876
    6623,  RCHAR,   4989,   4236,  RCHAR,   4814,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6337,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4719,
  // [0x936E,0x937E] -v # seg 1270 at pos 21896
    6980,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4032,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8050,  RCHAR,
    7522,
  // [0x938C,0x938C] -> [  4080,  4080] # seg 1272
  // [0x9394,0x939A] -v # seg 1274 at pos 21913
    6809,  RCHAR,   6095,  RCHAR,  RCHAR,  RCHAR,   7959,
  // [0x93A3,0x93B0] -v # seg 1276 at pos 21920
    8474,  RCHAR,  RCHAR,  RCHAR,   3996,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   8523,   7682,  RCHAR,  RCHAR,   7129,
  // [0x93C3,0x93C3] -> [  7501,  7501] # seg 1278
  // [0x93D1,0x93D1] -> [  7312,  7312] # seg 1280
  // [0x93DE,0x93E4] -v # seg 1282 at pos 21934
    6810,  RCHAR,  RCHAR,   4121,  RCHAR,  RCHAR,   5090,
  // [0x93F6,0x93F6] -> [  7708,  7708] # seg 1284
  // [0x9404,0x9404] -> [  8638,  8638] # seg 1286
  // [0x9418,0x9418] -> [  7523,  7523] # seg 1288
  // [0x9425,0x942B] -v # seg 1290 at pos 21941
    5975,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7349,
  // [0x9435,0x9438] -v # seg 1292 at pos 21948
    7850,  RCHAR,  RCHAR,   8084,
  // [0x9444,0x9444] -> [  7568,  7568] # seg 1294
  // [0x9451,0x9452] -> [  3945,  3946] # seg 1296
  // [0x945B,0x945B] -> [  4275,  4275] # seg 1298
  // [0x947D,0x947F] -v # seg 1300 at pos 21952
    7747,  RCHAR,   7733,
  // [0x9577,0x9577] -> [  7237,  7237] # seg 1302
  // [0x9580,0x9598] -v # seg 1304 at pos 21955
    5363,  RCHAR,  RCHAR,   5997,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   8222,  RCHAR,   3997,  RCHAR,  RCHAR,  RCHAR,   7001,
   RCHAR,   8327,   8328,   3917,   5399,  RCHAR,  RCHAR,  RCHAR,
    3953,
  // [0x95A3,0x95B1] -v # seg 1306 at pos 21980
    3893,   8349,   5527,  RCHAR,  RCHAR,   4434,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4966,  RCHAR,  RCHAR,  RCHAR,   6568,
  // [0x95BB,0x95BC] -v # seg 1308 at pos 21995
    6581,   6354,
  // [0x95C7,0x95CA] -v # seg 1310 at pos 21997
    6362,  RCHAR,  RCHAR,   8589,
  // [0x95D4,0x95E2] -v # seg 1312 at pos 22001
    8350,   4407,   8153,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4257,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7838,   5548,
  // [0x961C,0x9621] -v # seg 1314 at pos 22016
    5668,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7839,
  // [0x962A,0x9632] -v # seg 1316 at pos 22022
    8178,  RCHAR,  RCHAR,  RCHAR,   6727,  RCHAR,  RCHAR,  RCHAR,
    5484,
  // [0x963B,0x9650] -v # seg 1318 at pos 22031
    7495,  RCHAR,  RCHAR,  RCHAR,   6322,   8066,  RCHAR,   8285,
   RCHAR,   5669,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5091,   5241,   3976,  RCHAR,  RCHAR,   8329,
  // [0x965B,0x967D] -v # seg 1320 at pos 22053
    8223,   8351,   5998,   6222,   7820,  RCHAR,  RCHAR,   6895,
    7683,   7447,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5505,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7023,  RCHAR,  RCHAR,
    7684,  RCHAR,   5128,   4815,   8343,   5108,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6444,
  // [0x9685,0x9707] -v # seg 1322 at pos 22088
    6841,   5119,  RCHAR,  RCHAR,  RCHAR,   4772,   6150,  RCHAR,
    8612,   4148,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4057,
    6863,  RCHAR,  RCHAR,   6383,   4449,  RCHAR,   7448,   7238,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5161,  RCHAR,
   RCHAR,  RCHAR,   6151,   6152,  RCHAR,   8412,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7018,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5024,  RCHAR,  RCHAR,  RCHAR,   7821,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7188,   6347,  RCHAR,  RCHAR,   6870,
    6323,   7709,   4185,  RCHAR,   8032,  RCHAR,   7589,   7176,
    6701,   7286,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    7496,   6153,  RCHAR,  RCHAR,   6307,  RCHAR,   7960,   7201,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5153,   4592,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6842,   6843,   5989,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5364,   5691,  RCHAR,   6864,  RCHAR,  RCHAR,
   RCHAR,   5016,   5065,  RCHAR,   5420,  RCHAR,   7350,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6154,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   7424,   7685,
  // [0x9711,0x971E] -v # seg 1324 at pos 22219
    7368,  RCHAR,   6650,  RCHAR,  RCHAR,   5168,  RCHAR,  RCHAR,
    6625,  RCHAR,  RCHAR,   5887,  RCHAR,   8310,
  // [0x9727,0x9727] -> [  5349,  5349] # seg 1326
  // [0x9730,0x9748] -v # seg 1328 at pos 22233
    5839,  RCHAR,   5039,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5549,  RCHAR,  RCHAR,  RCHAR,   7449,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4977,  RCHAR,   6384,  RCHAR,  RCHAR,  RCHAR,
    5017,
  // [0x9751,0x977A] -v # seg 1330 at pos 22258
    7877,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7425,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7426,  RCHAR,   5743,  RCHAR,  RCHAR,
    5385,   5261,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    8417,  RCHAR,  RCHAR,  RCHAR,   7118,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8561,  RCHAR,  RCHAR,   7119,  RCHAR,
   RCHAR,   5212,
  // [0x978B,0x978F] -v # seg 1332 at pos 22300
    8484,  RCHAR,   6348,  RCHAR,   4224,
  // [0x97A0,0x97A0] -> [  4374,  4374] # seg 1334
  // [0x97A8,0x97AD] -v # seg 1336 at pos 22305
    3927,  RCHAR,  RCHAR,   4375,  RCHAR,   8206,
  // [0x97C6,0x97CB] -v # seg 1338 at pos 22311
    7840,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6924,
  // [0x97D3,0x97D3] -> [  8330,  8330] # seg 1340
  // [0x97DC,0x97DC] -> [  4816,  4816] # seg 1342
  // [0x97F3,0x9818] -v # seg 1344 at pos 22317
    7024,  RCHAR,  RCHAR,   6065,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    6865,  RCHAR,  RCHAR,  RCHAR,   8399,   8524,   8442,   7427,
    4122,  RCHAR,   8368,   6196,  RCHAR,   6155,  RCHAR,   6852,
   RCHAR,   6090,  RCHAR,  RCHAR,  RCHAR,   6651,   6728,   5445,
    4836,  RCHAR,  RCHAR,  RCHAR,   8169,   5018,
  // [0x982D,0x9830] -v # seg 1346 at pos 22355
    4866,  RCHAR,  RCHAR,   8455,
  // [0x9838,0x983B] -v # seg 1348 at pos 22359
    4123,   8144,  RCHAR,   5759,
  // [0x9846,0x986F] -v # seg 1350 at pos 22363
    4237,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7450,   6391,
    6338,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6349,  RCHAR,
   RCHAR,  RCHAR,   6896,  RCHAR,   7351,  RCHAR,  RCHAR,  RCHAR,
    5105,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8525,
   RCHAR,   4186,  RCHAR,  RCHAR,  RCHAR,   7352,  RCHAR,  RCHAR,
   RCHAR,   8438,
  // [0x98A8,0x98B1] -v # seg 1352 at pos 22405
    8277,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5856,
   RCHAR,   8122,
  // [0x98C4,0x98C7] -v # seg 1354 at pos 22415
    8270,  RCHAR,  RCHAR,   8269,
  // [0x98DB,0x98E2] -v # seg 1356 at pos 22419
    5744,   5523,  RCHAR,  RCHAR,   6264,  RCHAR,   6081,   4549,
  // [0x98ED,0x98F4] -v # seg 1358 at pos 22427
    8037,   7025,   5446,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7088,
  // [0x98FC,0x9920] -v # seg 1360 at pos 22435
    5821,   8250,   6265,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4314,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8400,   6446,  RCHAR,
    7089,  RCHAR,  RCHAR,  RCHAR,   7748,  RCHAR,  RCHAR,   6324,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   6499,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   7353,  RCHAR,   5576,
  // [0x9928,0x9928] -> [  4258,  4258] # seg 1362
  // [0x9945,0x9957] -v # seg 1364 at pos 22472
    5204,  RCHAR,  RCHAR,  RCHAR,   4464,  RCHAR,   4413,   7749,
    5976,  RCHAR,  RCHAR,  RCHAR,   4550,   6781,  RCHAR,   6702,
   RCHAR,  RCHAR,   8401,
  // [0x9996,0x999D] -v # seg 1366 at pos 22491
    6156,  RCHAR,  RCHAR,   8402,  RCHAR,  RCHAR,  RCHAR,   8295,
  // [0x99A5,0x99B9] -v # seg 1368 at pos 22499
    5609,  RCHAR,  RCHAR,   8475,  RCHAR,  RCHAR,  RCHAR,   5178,
    6454,   8278,  RCHAR,  RCHAR,   8067,  RCHAR,   8033,   6197,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   7130,
  // [0x99C1,0x99C1] -> [  5421,  5421] # seg 1370
  // [0x99D0,0x99DF] -v # seg 1372 at pos 22520
    7569,   4649,   4366,  RCHAR,  RCHAR,   3882,  RCHAR,  RCHAR,
   RCHAR,   5670,  RCHAR,  RCHAR,  RCHAR,   8068,  RCHAR,   5822,
  // [0x99ED,0x99F1] -v # seg 1374 at pos 22536
    8385,  RCHAR,  RCHAR,  RCHAR,   4900,
  // [0x99FF,0x9A0F] -v # seg 1376 at pos 22541
    7590,  RCHAR,   5763,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5577,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4551,
    4552,
  // [0x9A19,0x9A19] -> [  8207,  8207] # seg 1378
  // [0x9A2B,0x9A37] -v # seg 1380 at pos 22558
    4033,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4882,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   7961,   6066,
  // [0x9A40,0x9A45] -v # seg 1382 at pos 22571
    5242,  RCHAR,  RCHAR,   8271,  RCHAR,   4367,
  // [0x9A4D,0x9A4D] -> [  8651,  8651] # seg 1384
  // [0x9A55,0x9A6A] -v # seg 1386 at pos 22577
    4315,  RCHAR,   8413,  RCHAR,  RCHAR,   4124,   6515,  RCHAR,
   RCHAR,  RCHAR,   8003,  RCHAR,  RCHAR,   4967,  RCHAR,  RCHAR,
    4553,  RCHAR,  RCHAR,  RCHAR,   8583,   4968,
  // [0x9AA8,0x9AA8] -> [  4208,  4208] # seg 1388
  // [0x9AB8,0x9AB8] -> [  8386,  8386] # seg 1390
  // [0x9AD3,0x9AD8] -v # seg 1392 at pos 22599
    6157,   7888,  RCHAR,  RCHAR,  RCHAR,   4187,
  // [0x9AE5,0x9AE5] -> [  6582,  6582] # seg 1394
  // [0x9AEE,0x9AEE] -> [  5456,  5456] # seg 1396
  // [0x9B1A,0x9B1A] -> [  6158,  6158] # seg 1398
  // [0x9B27,0x9B31] -v # seg 1400 at pos 22605
    5077,  RCHAR,  RCHAR,   8150,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   6867,
  // [0x9B3C,0x9B45] -v # seg 1402 at pos 22616
    4418,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4287,   8534,   5457,
    5513,   5238,
  // [0x9B4F,0x9B5A] -v # seg 1404 at pos 22626
    6925,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5179,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   6455,
  // [0x9B6F,0x9B6F] -> [  5040,  5040] # seg 1406
  // [0x9B8E,0x9B91] -v # seg 1408 at pos 22638
    7369,  RCHAR,  RCHAR,   8251,
  // [0x9B9F,0x9B9F] -> [  6350,  6350] # seg 1410
  // [0x9BAB,0x9BAE] -v # seg 1412 at pos 22642
    4316,  RCHAR,  RCHAR,   5977,
  // [0x9BC9,0x9BC9] -> [  5154,  5154] # seg 1414
  // [0x9BD6,0x9BD6] -> [  7878,  7878] # seg 1416
  // [0x9BE4,0x9BE8] -v # seg 1418 at pos 22646
    4205,  RCHAR,  RCHAR,  RCHAR,   4125,
  // [0x9C0D,0x9C15] -v # seg 1420 at pos 22651
    7962,  RCHAR,  RCHAR,   6339,  RCHAR,   5610,  RCHAR,  RCHAR,
    8311,
  // [0x9C25,0x9C25] -> [  8584,  8584] # seg 1422
  // [0x9C32,0x9C32] -> [  6680,  6680] # seg 1424
  // [0x9C3B,0x9C3B] -> [  5205,  5205] # seg 1426
  // [0x9C47,0x9C49] -v # seg 1428 at pos 22660
    3977,  RCHAR,   5559,
  // [0x9C57,0x9C57] -> [  5162,  5162] # seg 1430
  // [0x9CE5,0x9CE9] -v # seg 1432 at pos 22663
    7497,  RCHAR,   5671,  RCHAR,   4368,
  // [0x9CF3,0x9CF6] -v # seg 1434 at pos 22668
    5628,   5279,  RCHAR,   6558,
  // [0x9D09,0x9D09] -> [  6325,  6325] # seg 1436
  // [0x9D1B,0x9D1B] -> [  6897,  6897] # seg 1438
  // [0x9D26,0x9D28] -v # seg 1440 at pos 22672
    6373,  RCHAR,   6366,
  // [0x9D3B,0x9D3B] -> [  8547,  8547] # seg 1442
  // [0x9D51,0x9D51] -> [  4068,  4068] # seg 1444
  // [0x9D5D,0x9D61] -v # seg 1446 at pos 22675
    6326,  RCHAR,  RCHAR,   4195,   5350,
  // [0x9D6C,0x9D72] -v # seg 1448 at pos 22680
    5702,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7189,
  // [0x9DA9,0x9DB4] -v # seg 1450 at pos 22687
    5311,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   6394,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   8316,
  // [0x9DC4,0x9DC4] -> [  4149,  4149] # seg 1452
  // [0x9DD7,0x9DD7] -> [  4369,  4369] # seg 1454
  // [0x9DF2,0x9DFA] -v # seg 1456 at pos 22699
    8004,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8698,   7032,
    5041,
  // [0x9E1A,0x9E1E] -v # seg 1458 at pos 22708
    6395,  RCHAR,  RCHAR,  RCHAR,   4909,
  // [0x9E75,0x9E7F] -v # seg 1460 at pos 22713
    5042,  RCHAR,  RCHAR,  RCHAR,   8344,  RCHAR,  RCHAR,  RCHAR,
    6583,  RCHAR,   5048,
  // [0x9E92,0x9EA5] -v # seg 1462 at pos 22724
    4554,   5049,  RCHAR,  RCHAR,  RCHAR,   4969,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5823,  RCHAR,   5163,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5243,
  // [0x9EB4,0x9EC3] -v # seg 1464 at pos 22744
    4376,   5262,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5180,
   RCHAR,  RCHAR,   8690,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   8613,
  // [0x9ECD,0x9EDE] -v # seg 1466 at pos 22760
    5929,   4970,  RCHAR,  RCHAR,   8704,  RCHAR,  RCHAR,   4044,
   RCHAR,  RCHAR,  RCHAR,   5352,  RCHAR,  RCHAR,   4773,   7980,
   RCHAR,   7370,
  // [0x9EE8,0x9EE8] -> [  4757,  4757] # seg 1468
  // [0x9EF4,0x9EF4] -> [  5386,  5386] # seg 1470
  // [0x9F07,0x9F13] -v # seg 1472 at pos 22778
    6681,   5560,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   7428,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4188,
  // [0x9F20,0x9F20] -> [  5930,  5930] # seg 1474
  // [0x9F3B,0x9F3B] -> [  5745,  5745] # seg 1476
  // [0x9F4A,0x9F52] -v # seg 1478 at pos 22791
    7451,   7254,  RCHAR,  RCHAR,   7255,  RCHAR,  RCHAR,  RCHAR,
    8034,
  // [0x9F5F,0x9F6C] -v # seg 1480 at pos 22800
    7287,  RCHAR,   5019,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5990,  RCHAR,  RCHAR,   7734,  RCHAR,   6456,
  // [0x9F77,0x9F77] -> [  6340,  6340] # seg 1482
  // [0x9F8D,0x9F9C] -v # seg 1484 at pos 22814
    5078,  RCHAR,  RCHAR,   5485,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    3947,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4370,
  // [0xF900,0xF938] -v # seg 1488 at pos 22830
    3995,   4001,   4018,   4182,   4207,   4242,   4414,   4419,
    4441,   4465,   4478,   4563,   4564,   4567,   4570,   4571,
    4572,   4573,   4574,   4575,   4577,   4578,   4579,   4580,
    4581,   4583,   4584,   4585,   4586,   4588,   4590,   4591,
    4593,   4597,   4601,   4603,   4604,   4605,   4607,   4608,
    4612,   4613,   4614,   4615,   4616,   4618,   4623,   4635,
    4639,   4640,   4641,   4643,   4644,   4645,   4646,   4647,
    4648,
  // [0xF939,0xF943] -> [  4650,  4660] # seg 1489
  // [0xF944,0xFA0B] -v # seg 1490 at pos 22887
    4662,   4663,   4667,   4668,   4670,   4671,   4673,   4674,
    4675,   4676,   4677,   4678,   4679,   4680,   4685,   4686,
    4687,   4688,   4689,   4690,   4692,   4693,   4863,   4885,
    4892,   4898,   4901,   5005,   5026,   5118,   5143,   5488,
    5519,   5550,   5644,   5692,   5723,   5825,   5827,   5846,
    5892,   5899,   6002,   6028,   6092,   6288,   6298,   6306,
    6405,   6408,   6409,   6416,   6418,   6419,   6427,   6437,
    6439,   6441,   6445,   6481,   6482,   6483,   6485,   6486,
    6489,   6492,   6498,   6500,   6501,   6502,   6504,   6508,
    6509,   6513,   6521,   6523,   6524,   6527,   6535,   6539,
    6542,   6545,   6548,   6550,   6553,   6554,   6555,   6557,
    6559,   6560,   6561,   6564,   6566,   6567,   6570,   6571,
    6572,   6574,   6580,   6585,   6588,   6589,   6591,   6592,
    6595,   6610,   6612,   6617,   6618,   6622,   6624,   6626,
    6627,   6630,   6642,   6647,   6649,   6666,   6744,   6745,
    6753,   6754,   6760,   6762,   6764,   6767,   6774,   6779,
    6811,   6854,   6894,   6930,   6945,   6948,   6953,   6955,
    6959,   6962,   6964,   6965,   6981,   6982,   6984,   6988,
    6989,   6993,   6994,   6999,   7002,   7003,   7004,   7005,
    7011,   7055,   7056,   7059,   7064,   7065,   7066,   7067,
    7070,   7073,   7075,   7081,   7082,   7086,   7087,   7090,
    7091,   7102,   7110,   7111,   7114,   7117,   7120,   7121,
    7136,   7137,   7139,   7144,   7145,   7146,   7221,   7296,
    7642,   7703,   7724,   7808,   7879,   8073,   8075,   8107,
    8123,   8134,   8236,   8257,   8366,   8367,   8435,   8562,
  // [0xFF01,0xFF3B] -> [   188,   246] # seg 1492
  // [0xFF3C,0xFF3C] -> [    11,    11] # seg 1493
  // [0xFF3D,0xFF5D] -> [   248,   280] # seg 1494
  // [0xFF5E,0xFF5E] -> [    99,    99] # seg 1495
  // [0xFFE0,0xFFE6] -v # seg 1497 at pos 23087
      42,     43,     93,    281,  RCHAR,     44,    247,
};

// Simplified Chinese GB18030-2000
const unsigned short CodePageGB18030[17420] = {
  // hot segments (indexes into segment table)
  2, 0, 35,
  // number of segments
  659,
  // segment table
       0,     94,    104,    110,    130,    150,    160,    162,
     172,    174,    186,    192,    281,    282,    365,    376,
     462,    470,    487,    502,    519,    555,    564,    571,
     597,    612,    619,    645,    658,    694,    731,    752,
     755,    831,    846,   1410,   8178,   8836,   8880,   8890,
    9034,   9043,   9077,   9090,   9106,   9117,   9154,   9163,
    9178,   9199,   9215,   9234,   9243,   9254,   9268,   9278,
    9287,   9301,   9330,   9400,   9409,   9486,   9496,   9527,
    9537,   9564,   9575,   9583,   9614,   9624,   9921,   9930,
   10013,  10025,  10073,  10088,  10099,  10110,  10123,  10132,
   10159,  10176,  10261,  10270,  10348,  10362,  10393,  10410,
   10440,  10458,  10465,  10476,  10479,  10493,  10568,  10581,
   10652,  10664,  10716,  10726,  10743,  10752,  10758,  10776,
   10783,  10797,  10847,  10870,  10882,  10908,  10919,  10934,
   10990,  10999,  11164,  11174,  11233,  11244,  11247,  11258,
   11265,  11278,  11300,  11303,  11328,  11341,  11348,  11361,
   11438,  11453,  11489,  11499,  11511,  11523,  11524,  11533,
   11575,  11590,  11850,  11869,  11877,  11912,  11931,  11946,
   11955,  11957,  11967,  11988,  12005,  12019,  12028,  12370,
   12380,  12389,  12398,  12454,  12479,  12487,  12495,  12500,
   12512,  12562,  12577,  12746,  12755,  12773,  12799,  12932,
   12942,  13010,  13020,  13030,  13039,  13055,  13065,  13076,
   13086,  13111,  13121,  13144,  13156,  13182,  13199,  13244,
   13254,  13295,  13307,  13311,  13321,  13322,  13332,  13344,
   13404,  13415,  13430,  13439,  13462,  13577,  13579,  13589,
   13606,  13618,  13626,  13628,  13642,  14059,  14070,  14072,
   14087,  14150,  14160,  14185,  14195,  14226,  14236,  14273,
   14286,  14295,  14306,  14330,  14341,  14342,  14354,  14387,
   14395,  14402,  14419,  14422,  14440,  14442,  14456,  14468,
   14496,  14509,  14522,  14535,  14557,  14568,  14577,  14588,
   14596,  14600,  14614,  14620,  14633,  14702,  14711,  14721,
   14726,  14736,  14747,  14757,  14769,  14791,  14801,  14864,
   14876,  14888,  14916,  15588,  15608,  15644,  15659,  15673,
   15684,  15693,  15724,  15734,  15738,  15752,  15757,  15769,
   15770,  15780,  15834,  15847,  15862,  15873,  15874,  15888,
   15967,  15983,  15990,  15999,  16023,  16042,  16045,  16058,
   16082,  16093,  16102,  16118,  16141,  16150,  16417,  16427,
   16436,  16439,  16449,  16493,  16504,  16556,  16568,  16582,
   16594,  16613,  16626,  16635,  16709,  16721,  16729,  16733,
   16743,  16793,  16807,  16829,  16842,  16852,  16857,  16872,
   16884,  16893,  16929,  16939,  16951,  16962,  17032,  17047,
   17059,  17069,  17074,  17098,  17135,  17146,  17157,  17167,
   17183,  17192,  17249,  17260,  17392,  17405,  17411,  17422,
   17459,  17465,  17476,  17551,  17565,  17586,  17597,  17659,
   17667,  17713,  17720,  17860,  17870,  17928,  17952,  17976,
   17986,  18148,  18162,  18168,  18181,  18250,  18263,  18365,
   18387,  18546,  18556,  18720,  18730,  18782,  18795,  18836,
   18847,  18849,  18861,  18876,  18885,  18895,  18904,  18915,
   18929,  18938,  18958,  18969,  19029,  19046,  19054,  19065,
   19069,  19085,  19086,  19100,  19103,  19119,  19385,  19395,
   19427,  19442,  19619,  19629,  19631,  19656,  19662,  19682,
   19689,  19747,  19772,  19784,  19790,  19844,  19853,  19901,
   19916,  19924,  20039,  20069,  20132,  20137,  20188,  20196,
   20205,  20271,  20403,  20417,  20426,  20439,  20449,  20452,
   20465,  20562,  20574,  20612,  20624,  20635,  20654,  20805,
   21004,  21024,  21031,  21042,  21050,  21059,  21122,  21134,
   21137,  21147,  21298,  21323,  21354,  21379,  21496,  21539,
   21575,  21633,  21644,  21747,  21791,  21816,  21848,  21952,
   22004,  22017,  22029,  22039,  22047,  22065,  22075,  22114,
   22125,  22139,  22158,  22171,  22180,  22228,  22277,  22284,
   22410,  22416,  22454,  22469,  22505,  22507,  22536,  22573,
   22586,  22598,  22609,  22611,  22806,  22864,  22873,  22894,
   22905,  22908,  22919,  22941,  23236,  23268,  23584,  23608,
   23618,  23632,  23641,  23648,  23661,  23697,  23706,  23708,
   23720,  23735,  23744,  23761,  23772,  23817,  23819,  23831,
   23940,  23976,  23990,  24021,  24029,  24049,  24066,  24073,
   24088,  24112,  24119,  24148,  24246,  24253,  24281,  24368,
   24383,  24484,  24485,  24498,  24681,  24690,  24745,  24759,
   24760,  31862,  31874,  31883,  31890,  32002,  32088,  32092,
   32104,  32114,  32176,  32180,  32202,  32204,  32314,  32346,
   32356,  32364,  32377,  32385,  32422,  32425,  32436,  32461,
   32543,  32876,  32886,  32986,  32990,  33003,  33006,  33016,
   33032,  33040,  33048,  33053,  33071,  33102,  33104,  33158,
   33159,  35269,  35276,  35286,  35301,  35315,  35329,  35622,
   35634,  35654,  35676,  35922,  35929,  36042,  36276,  36288,
   36290,  36324,  36333,  36337,  36450,  36493,  36791,  36902,
   36913,  37678,  37763,  37859,  37873,  38020,  38238,  38525,
   38638,  39523,  39787,  40258,  40374,  40378,  40421,  40669,
   41042,  41062,  41255,  41260,  41342,  41358,  41799,  41849,
   41856,  41876,  41879,  41901,  42604,  42643,  42754,  42902,
   42983,  57409,  57411,  57424,  57460,  57476,  57490,  61785,
   61861,  61888,  61969,  61978,  62004,  62018,  63048,  63056,
   63205,  63334,  63360,
  // compressed segments
   RCHAR, 0x2170, 0xE766, 0x2488, 0x2474, 0x2460,  RCHAR, 0x3220,
  0xE76E, 0x2160,  RCHAR, 0xFF05, 0xFFE3, 0x3041, 0xE772, 0x30A1,
  0xE77D, 0x0391,  RCHAR, 0x03B1,  RCHAR, 0xE797,  RCHAR, 0x0416,
  0xE7A0,  RCHAR, 0x0436, 0xE7AF,  RCHAR, 0x3105, 0xE7CD, 0xE7FE,
  0x2500, 0xE801, 0xE000,  RCHAR, 0xE234,  RCHAR, 0x4E74,  RCHAR,
  0x4FB6,  RCHAR, 0x4FFF,  RCHAR, 0x502F,  RCHAR, 0x506D,  RCHAR,
  0x508E,  RCHAR, 0x50BC,  RCHAR, 0x50DB,  RCHAR, 0x50FC,  RCHAR,
  0x5113, 0x5122,  RCHAR, 0x51D2,  RCHAR, 0x5273,  RCHAR, 0x52B4,
   RCHAR, 0x52E5, 0x52F1,  RCHAR, 0x532F,  RCHAR, 0x55A8,  RCHAR,
  0x5640,  RCHAR, 0x5694, 0x56A4,  RCHAR, 0x56BD, 0x56CB,  RCHAR,
  0x570B,  RCHAR, 0x57B9,  RCHAR, 0x5836,  RCHAR, 0x586D,  RCHAR,
  0x58AA,  RCHAR, 0x58C6, 0x58D2, 0x58D6,  RCHAR, 0x5966,  RCHAR,
  0x59ED,  RCHAR, 0x5A4B,  RCHAR, 0x5A6B,  RCHAR, 0x5A80, 0x5A93,
  0x5A9C,  RCHAR, 0x5AF2, 0x5B0A, 0x5B18,  RCHAR, 0x5B41,  RCHAR,
  0x5BD4,  RCHAR, 0x5CF1,  RCHAR, 0x5D4D,  RCHAR, 0x5D5E,  RCHAR,
  0x5D75, 0x5D83, 0x5D9A, 0x5D9E, 0x5DB8, 0x5DC6, 0x5DCE,  RCHAR,
  0x5E63,  RCHAR, 0x5EBF,  RCHAR, 0x5EDC, 0x5EE9, 0x5EEB,  RCHAR,
  0x5F41,  RCHAR, 0x612C, 0x6140,  RCHAR, 0x6178,  RCHAR, 0x619E,
  0x61AA, 0x61AD,  RCHAR, 0x61D5, 0x61E7, 0x61F6,  RCHAR, 0x646E,
   RCHAR, 0x6488,  RCHAR, 0x64E7, 0x6501, 0x650A, 0x6513, 0x6519,
   RCHAR, 0x6578,  RCHAR, 0x669E,  RCHAR, 0x66BF,  RCHAR, 0x67C5,
   RCHAR, 0x6856,  RCHAR, 0x6878,  RCHAR, 0x6898,  RCHAR, 0x68B6,
   RCHAR, 0x68E4,  RCHAR, 0x6913,  RCHAR, 0x6943,  RCHAR, 0x699D,
   RCHAR, 0x69E1, 0x69EE, 0x69F3, 0x69FE, 0x6A00, 0x6A0B,  RCHAR,
  0x6A66,  RCHAR, 0x6A85,  RCHAR, 0x6AAD, 0x6B25, 0x6B28,  RCHAR,
  0x6B4D, 0x6B5A, 0x6B68, 0x6B6B,  RCHAR, 0x6E60, 0x6E6C, 0x6E6F,
   RCHAR, 0x6EEA,  RCHAR, 0x6F16,  RCHAR, 0x6F4E,  RCHAR, 0x6F8F,
   RCHAR, 0x6FA8,  RCHAR, 0x6FD3, 0x6FDF, 0x6FE2, 0x6FF0, 0x7012,
  0x701C, 0x7024, 0x7036, 0x703A, 0x704D, 0x7050, 0x705F,  RCHAR,
  0x709E,  RCHAR, 0x70CB,  RCHAR, 0x70FE,  RCHAR, 0x711B, 0x7127,
  0x7132, 0x7137,  RCHAR, 0x714F,  RCHAR, 0x71BA, 0x71C4, 0x71CF,
  0x71D6,  RCHAR, 0x71EF, 0x71FA, 0x7207, 0x721E,  RCHAR, 0x7293,
  0x72A0,  RCHAR, 0xE4C6,  RCHAR, 0x2550, 0x2581,  RCHAR, 0xE7BC,
  0x3021,  RCHAR, 0xFE49, 0xFE54, 0xFE59,  RCHAR, 0x2FF0, 0x3007,
  0xE7F4,  RCHAR, 0x7340,  RCHAR, 0x7361, 0x736E, 0x7370,  RCHAR,
  0x73F3,  RCHAR, 0x7411,  RCHAR, 0x7442,  RCHAR, 0x7460,  RCHAR,
  0x7491,  RCHAR, 0x74AA, 0x74BB, 0x74D3,  RCHAR, 0x769A, 0x76A5,
   RCHAR, 0x76B5,  RCHAR, 0x770E,  RCHAR, 0x776D,  RCHAR, 0x7793,
   RCHAR, 0x77C0, 0x77CE,  RCHAR, 0x785E, 0x786F, 0x7878, 0x787D,
   RCHAR, 0x78DA,  RCHAR, 0x7906, 0x7914, 0x791F, 0x7925,  RCHAR,
  0x794A,  RCHAR, 0x7990, 0x799B, 0x79A8,  RCHAR, 0x7A24,  RCHAR,
  0x7A47, 0x7A52, 0x7A58,  RCHAR, 0x7AB4, 0x7AC0, 0x7ACC,  RCHAR,
  0x7AF0,  RCHAR, 0x7B63,  RCHAR, 0x7C2B, 0x7C39, 0x7C42, 0x7C4E,
  0x7C75, 0x7C7E,  RCHAR, 0x7CFC, 0x7D0B,  RCHAR, 0x7D30, 0x7D6F,
  0x7D78, 0x7DA7, 0x7DAF,  RCHAR, 0x7E48, 0x7E83,  RCHAR, 0x7F46,
   RCHAR, 0x805B, 0x806B, 0x8072,  RCHAR, 0x811F,  RCHAR, 0x81CD,
   RCHAR, 0x831D,  RCHAR, 0x8447,  RCHAR, 0x84A2,  RCHAR, 0x84F1,
  0x84FD, 0x8500,  RCHAR, 0x8522, 0x852D,  RCHAR, 0x854B,  RCHAR,
  0x8569,  RCHAR, 0x8590,  RCHAR, 0x85EA,  RCHAR, 0x8606, 0x8612,
  0x8617, 0x8628, 0x862A, 0x8639, 0x863D,  RCHAR, 0x87EF,  RCHAR,
  0x8823,  RCHAR, 0x8937, 0x8942, 0x8945, 0x8960, 0x8967,  RCHAR,
  0x8987,  RCHAR, 0x89F4, 0x8A01, 0x8A08, 0x8A3F, 0x8A49, 0x8A7A,
  0x8A8B, 0x8A94, 0x8B08, 0x8B27, 0x8B67, 0x8B6D,  RCHAR, 0x8C38,
   RCHAR, 0x8C99,  RCHAR, 0x8D78,  RCHAR, 0x8D95, 0x8DA0, 0x8DA4,
   RCHAR, 0x8E5A,  RCHAR, 0x8E9F,  RCHAR, 0x8EBB, 0x8ECF,  RCHAR,
  0x9105,  RCHAR, 0x9124,  RCHAR, 0x913A,  RCHAR, 0x91BB,  RCHAR,
  0x91D2, 0x91DD, 0x9275, 0x928F, 0x92AF, 0x92C9, 0x933F, 0x936B,
  0x9390, 0x93CB, 0x93D7, 0x943F, 0x946C,  RCHAR, 0x9580,  RCHAR,
  0x9678,  RCHAR, 0x969D, 0x96A8,  RCHAR, 0x96D6,  RCHAR, 0x971F,
   RCHAR, 0x973F,  RCHAR, 0x976A,  RCHAR, 0x97B5,  RCHAR, 0x97F7,
   RCHAR, 0x98A8,  RCHAR, 0x98E9, 0x990E, 0x9911, 0x992F, 0x9956,
   RCHAR, 0x999A, 0x99A6, 0x99A9,  RCHAR, 0x9AF0,  RCHAR, 0x9B14,
  0x9B20, 0x9B24,  RCHAR, 0x9B55,  RCHAR, 0x9CE3,  RCHAR, 0x9E74,
   RCHAR, 0x9E94,  RCHAR, 0x9EA7,  RCHAR, 0x9EF0,  RCHAR, 0x9EFF,
   RCHAR, 0x9F23,  RCHAR, 0x9F45, 0x9F52, 0x9F81, 0x9F8D,  RCHAR,
  0x0080,  RCHAR, 0x00B8, 0x00D8,  RCHAR, 0x0102, 0x0114, 0x011C,
  0x012C,  RCHAR, 0x014E, 0x016C,  RCHAR, 0x01DD, 0x01FA, 0x0252,
  0x0262, 0x02C8, 0x02CC, 0x02DA,  RCHAR, 0x03CA, 0x0402, 0x0450,
  0x0452,  RCHAR, 0x2027,  RCHAR, 0x203C, 0x20AD,  RCHAR, 0x210A,
  0x2117, 0x2122, 0x216C, 0x217A, 0x2194, 0x219A,  RCHAR, 0x223E,
   RCHAR, 0x2253,  RCHAR, 0x2270, 0x2296, 0x229A, 0x22A6, 0x22C0,
  0x2313, 0x246A, 0x249C, 0x254C, 0x2574, 0x2590, 0x2596, 0x25A2,
  0x25B4, 0x25BE,  RCHAR, 0x25D0, 0x25E6, 0x2607, 0x260A, 0x2641,
  0x2643,  RCHAR, 0x2E8D, 0x2E98,  RCHAR, 0x2EBC, 0x2ECB,  RCHAR,
  0x302A,  RCHAR, 0x312A, 0x322A, 0x3232, 0x32A4, 0x3390, 0x339F,
  0x33A2, 0x33C5,  RCHAR, 0x33D6, 0x3448, 0x3474, 0x359F, 0x360F,
  0x361B, 0x3919, 0x396F, 0x39D1, 0x39E0, 0x3A74, 0x3B4F, 0x3C6F,
  0x3CE1, 0x4057, 0x4160, 0x4338, 0x43AD, 0x43B2, 0x43DE, 0x44D7,
  0x464D, 0x4662, 0x4724, 0x472A, 0x477D, 0x478E, 0x4948,  RCHAR,
  0x4987, 0x499C, 0x49A0, 0x49B8, 0x4C78, 0x4CA4, 0x4D1A, 0x4DAF,
  0x9FA6,  RCHAR, 0xE7E7,  RCHAR, 0xE844, 0xE856, 0xE865, 0xF92D,
  0xF97A, 0xF996, 0xF9E8, 0xF9F2,  RCHAR, 0xFA2A,  RCHAR, 0xFE6C,
  0xFF5F, 0xFFE6,  RCHAR,
  // uncompressed segments
  0x0000,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x1ACE,  RCHAR,
   RCHAR,  RCHAR, 0x1AD0,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR, 0x1AD6,  RCHAR, 0x1AE5,  RCHAR, 0x1B09,  RCHAR,
   RCHAR, 0x1B10,  RCHAR,  RCHAR, 0x1B17,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR, 0x005E,  RCHAR, 0x1B3B,  RCHAR, 0x1B67,
   RCHAR, 0x1BF7,  RCHAR, 0x1C19,  RCHAR, 0x1C29,  RCHAR, 0x1C4E,
   RCHAR, 0x1C5D,  RCHAR, 0x1C6D,  RCHAR, 0x1C76,  RCHAR, 0x1C84,
   RCHAR,  RCHAR, 0x1C8D,  RCHAR, 0x1CD3,  RCHAR, 0x1D20,  RCHAR,
  0x1D3F,  RCHAR,  RCHAR, 0x1D5A,  RCHAR, 0x1D79,  RCHAR, 0x1EA2,
   RCHAR, 0x1EF5,  RCHAR,  RCHAR, 0x1F25,  RCHAR,  RCHAR, 0x1F30,
   RCHAR, 0x1F4B,  RCHAR, 0x1FA0,  RCHAR, 0x1FEE,  RCHAR, 0x200D,
   RCHAR, 0x202B,  RCHAR,  RCHAR,  RCHAR, 0x2032,  RCHAR, 0x207D,
   RCHAR, 0x20C4,  RCHAR, 0x20F8,  RCHAR, 0x2109,  RCHAR,  RCHAR,
   RCHAR, 0x210F,  RCHAR,  RCHAR,  RCHAR, 0x2141,  RCHAR, 0x214C,
   RCHAR, 0x2184,  RCHAR, 0x2229,  RCHAR, 0x2264,  RCHAR, 0x2267,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x226E,
   RCHAR, 0x22BB,  RCHAR, 0x22DF,  RCHAR,  RCHAR,  RCHAR, 0x22EB,
   RCHAR, 0x2315,  RCHAR,  RCHAR, 0x2419,  RCHAR, 0x243C,  RCHAR,
   RCHAR,  RCHAR, 0x244B,  RCHAR,  RCHAR,  RCHAR, 0x2460,  RCHAR,
  0x25B6,  RCHAR, 0x25BF,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  0x25F7,  RCHAR, 0x2629,  RCHAR, 0x26D2,  RCHAR, 0x26E4,  RCHAR,
  0x2769,  RCHAR, 0x27AD,  RCHAR, 0x27B7,  RCHAR, 0x27C7,  RCHAR,
  0x27D2,  RCHAR, 0x27EB,  RCHAR, 0x2802,  RCHAR, 0x281C,  RCHAR,
  0x2849,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2872,
   RCHAR, 0x28AE,  RCHAR, 0x28BD,  RCHAR,  RCHAR,  RCHAR, 0x28D4,
   RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x28E5,  RCHAR,  RCHAR,  RCHAR,
  0x2A86,  RCHAR, 0x2AC5,  RCHAR, 0x2ADE,  RCHAR, 0x2AFD,  RCHAR,
  0x2B22,  RCHAR, 0x2B2B,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2B43,
   RCHAR, 0x2B5F,  RCHAR, 0x2B6C,  RCHAR, 0x2B82,  RCHAR,  RCHAR,
   RCHAR,  RCHAR, 0x2B8B,  RCHAR, 0x2B91,  RCHAR,  RCHAR,  RCHAR,
   RCHAR, 0x2BD6,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2BE1,  RCHAR,
   RCHAR, 0x2C20,  RCHAR, 0x2C3C,  RCHAR,  RCHAR, 0x2C50,  RCHAR,
   RCHAR, 0x2C5E,  RCHAR,  RCHAR,  RCHAR, 0x2C7D,  RCHAR,  RCHAR,
   RCHAR, 0x2C82,  RCHAR, 0x2CB8,  RCHAR,  RCHAR,  RCHAR, 0x2CC7,
   RCHAR, 0x2D16,  RCHAR, 0x2D1D,  RCHAR, 0x2D35,  RCHAR, 0x2D38,
   RCHAR, 0x2D50,  RCHAR,  RCHAR,  RCHAR, 0x2D59,  RCHAR,  RCHAR,
  0x2E64,  RCHAR, 0x2E67,  RCHAR, 0x2E93,  RCHAR, 0x2EC7,  RCHAR,
  0x2ED5,  RCHAR,  RCHAR, 0x2EE8,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  0x2F32,  RCHAR, 0x2F64,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2F7A,
   RCHAR, 0x2F86,  RCHAR,  RCHAR,  RCHAR, 0x2FAA,  RCHAR, 0x2FF0,
   RCHAR,  RCHAR,  RCHAR, 0x2FFC,  RCHAR,  RCHAR,  RCHAR, 0x3021,
   RCHAR, 0x3031,  RCHAR, 0x306A,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR, 0x30EE,  RCHAR,  RCHAR, 0x3139,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR, 0x3144,  RCHAR,  RCHAR, 0x314E,  RCHAR,
  0x3166,  RCHAR,  RCHAR,  RCHAR, 0x3208,  RCHAR, 0x324D,  RCHAR,
  0x32B3,  RCHAR, 0x3352,  RCHAR, 0x33F6,  RCHAR, 0x342A,  RCHAR,
   RCHAR,  RCHAR, 0x3453,  RCHAR,  RCHAR, 0x3462,  RCHAR, 0x346B,
   RCHAR, 0x3479,  RCHAR, 0x348D,  RCHAR, 0x34C9,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x34D1,  RCHAR, 0x35DB,
   RCHAR, 0x35FB,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x36AC,
   RCHAR, 0x36B3,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x36CC,  RCHAR,
  0x36D4,  RCHAR, 0x3716,  RCHAR, 0x3724,  RCHAR,  RCHAR,  RCHAR,
  0x3731,  RCHAR, 0x3792,  RCHAR, 0x37B8,  RCHAR,  RCHAR, 0x37C3,
   RCHAR, 0x388A,  RCHAR, 0x3891,  RCHAR, 0x3899,  RCHAR, 0x38D8,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x38DB,  RCHAR, 0x38FB,
   RCHAR, 0x392F,  RCHAR,  RCHAR, 0x393B,  RCHAR, 0x394D,  RCHAR,
  0x3974,  RCHAR, 0x3982,  RCHAR, 0x398F,  RCHAR, 0x39BF,  RCHAR,
  0x39C6,  RCHAR, 0x39CC,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  0x39DB,  RCHAR,  RCHAR,  RCHAR, 0x39E7,  RCHAR, 0x3A21,  RCHAR,
   RCHAR,  RCHAR, 0x3A36,  RCHAR, 0x3A4C,  RCHAR, 0x3A6C,  RCHAR,
  0x3A84,  RCHAR, 0x3A92,  RCHAR, 0x3A99,  RCHAR, 0x3ABD,  RCHAR,
  0x3ABF,  RCHAR, 0x3ACE,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x3ADF,
   RCHAR, 0x3B4C,  RCHAR,  RCHAR, 0x3B5A,  RCHAR,  RCHAR,  RCHAR,
   RCHAR, 0x3B6E,  RCHAR,  RCHAR, 0x3B75,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x3B7C,  RCHAR,  RCHAR,  RCHAR,
   RCHAR, 0x3B85,  RCHAR, 0x3B91,  RCHAR,  RCHAR, 0x3B98,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x3B9C,  RCHAR,
  0x3BBC,  RCHAR, 0x3BC4,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR, 0x3BCC,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR, 0x3BD1,  RCHAR,  RCHAR, 0x3BD8,  RCHAR,  RCHAR, 0x3BE6,
   RCHAR, 0x3BF2,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR, 0x3C08,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x3C0C,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR, 0x3C13,  RCHAR, 0x3C15,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x3C39,  RCHAR, 0x3C47,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,
  // [     0,    93] -v # seg 0 at pos 0
  0x3000, 0x3001, 0x3002, 0x00B7, 0x02C9, 0x02C7, 0x00A8, 0x3003,
  0x3005, 0x2014, 0xFF5E, 0x2016, 0x2026, 0x2018, 0x2019, 0x201C,
  0x201D, 0x3014, 0x3015, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C,
  0x300D, 0x300E, 0x300F, 0x3016, 0x3017, 0x3010, 0x3011, 0x00B1,
  0x00D7, 0x00F7, 0x2236, 0x2227, 0x2228, 0x2211, 0x220F, 0x222A,
  0x2229, 0x2208, 0x2237, 0x221A, 0x22A5, 0x2225, 0x2220, 0x2312,
  0x2299, 0x222B, 0x222E, 0x2261, 0x224C, 0x2248, 0x223D, 0x221D,
  0x2260, 0x226E, 0x226F, 0x2264, 0x2265, 0x221E, 0x2235, 0x2234,
  0x2642, 0x2640, 0x00B0, 0x2032, 0x2033, 0x2103, 0xFF04, 0x00A4,
  0xFFE0, 0xFFE1, 0x2030, 0x00A7, 0x2116, 0x2606, 0x2605, 0x25CB,
  0x25CF, 0x25CE, 0x25C7, 0x25C6, 0x25A1, 0x25A0, 0x25B3, 0x25B2,
  0x203B, 0x2192, 0x2190, 0x2191, 0x2193, 0x3013,
  // [    94,   103] -> [0x2170,0x2179] # seg 1
  // [   104,   109] -> [0xE766,0xE76B] # seg 2
  // [   110,   129] -> [0x2488,0x249B] # seg 3
  // [   130,   149] -> [0x2474,0x2487] # seg 4
  // [   150,   159] -> [0x2460,0x2469] # seg 5
  // [   162,   171] -> [0x3220,0x3229] # seg 7
  // [   172,   173] -> [0xE76E,0xE76F] # seg 8
  // [   174,   185] -> [0x2160,0x216B] # seg 9
  // [   192,   280] -> [0xFF05,0xFF5D] # seg 11
  // [   281,   281] -> [0xFFE3,0xFFE3] # seg 12
  // [   282,   364] -> [0x3041,0x3093] # seg 13
  // [   376,   461] -> [0x30A1,0x30F6] # seg 15
  // [   462,   469] -> [0xE77D,0xE784] # seg 16
  // [   470,   486] -> [0x0391,0x03A1] # seg 17
  // [   502,   518] -> [0x03B1,0x03C1] # seg 19
  // [   752,   754] -> [0xE7FE,0xE800] # seg 31
  // [   831,   845] -> [0xE801,0xE80F] # seg 33
  // [  1410,  8177] -v # seg 35 at pos 94
  0x554A, 0x963F, 0x57C3, 0x6328, 0x54CE, 0x5509, 0x54C0, 0x7691,
  0x764C, 0x853C, 0x77EE, 0x827E, 0x788D, 0x7231, 0x9698, 0x978D,
  0x6C28, 0x5B89, 0x4FFA, 0x6309, 0x6697, 0x5CB8, 0x80FA, 0x6848,
  0x80AE, 0x6602, 0x76CE, 0x51F9, 0x6556, 0x71AC, 0x7FF1, 0x8884,
  0x50B2, 0x5965, 0x61CA, 0x6FB3, 0x82AD, 0x634C, 0x6252, 0x53ED,
  0x5427, 0x7B06, 0x516B, 0x75A4, 0x5DF4, 0x62D4, 0x8DCB, 0x9776,
  0x628A, 0x8019, 0x575D, 0x9738, 0x7F62, 0x7238, 0x767D, 0x67CF,
  0x767E, 0x6446, 0x4F70, 0x8D25, 0x62DC, 0x7A17, 0x6591, 0x73ED,
  0x642C, 0x6273, 0x822C, 0x9881, 0x677F, 0x7248, 0x626E, 0x62CC,
  0x4F34, 0x74E3, 0x534A, 0x529E, 0x7ECA, 0x90A6, 0x5E2E, 0x6886,
  0x699C, 0x8180, 0x7ED1, 0x68D2, 0x78C5, 0x868C, 0x9551, 0x508D,
  0x8C24, 0x82DE, 0x80DE, 0x5305, 0x8912, 0x5265, 0x8584, 0x96F9,
  0x4FDD, 0x5821, 0x9971, 0x5B9D, 0x62B1, 0x62A5, 0x66B4, 0x8C79,
  0x9C8D, 0x7206, 0x676F, 0x7891, 0x60B2, 0x5351, 0x5317, 0x8F88,
  0x80CC, 0x8D1D, 0x94A1, 0x500D, 0x72C8, 0x5907, 0x60EB, 0x7119,
  0x88AB, 0x5954, 0x82EF, 0x672C, 0x7B28, 0x5D29, 0x7EF7, 0x752D,
  0x6CF5, 0x8E66, 0x8FF8, 0x903C, 0x9F3B, 0x6BD4, 0x9119, 0x7B14,
  0x5F7C, 0x78A7, 0x84D6, 0x853D, 0x6BD5, 0x6BD9, 0x6BD6, 0x5E01,
  0x5E87, 0x75F9, 0x95ED, 0x655D, 0x5F0A, 0x5FC5, 0x8F9F, 0x58C1,
  0x81C2, 0x907F, 0x965B, 0x97AD, 0x8FB9, 0x7F16, 0x8D2C, 0x6241,
  0x4FBF, 0x53D8, 0x535E, 0x8FA8, 0x8FA9, 0x8FAB, 0x904D, 0x6807,
  0x5F6A, 0x8198, 0x8868, 0x9CD6, 0x618B, 0x522B, 0x762A, 0x5F6C,
  0x658C, 0x6FD2, 0x6EE8, 0x5BBE, 0x6448, 0x5175, 0x51B0, 0x67C4,
  0x4E19, 0x79C9, 0x997C, 0x70B3, 0x75C5, 0x5E76, 0x73BB, 0x83E0,
  0x64AD, 0x62E8, 0x94B5, 0x6CE2, 0x535A, 0x52C3, 0x640F, 0x94C2,
  0x7B94, 0x4F2F, 0x5E1B, 0x8236, 0x8116, 0x818A, 0x6E24, 0x6CCA,
  0x9A73, 0x6355, 0x535C, 0x54FA, 0x8865, 0x57E0, 0x4E0D, 0x5E03,
  0x6B65, 0x7C3F, 0x90E8, 0x6016, 0x64E6, 0x731C, 0x88C1, 0x6750,
  0x624D, 0x8D22, 0x776C, 0x8E29, 0x91C7, 0x5F69, 0x83DC, 0x8521,
  0x9910, 0x53C2, 0x8695, 0x6B8B, 0x60ED, 0x60E8, 0x707F, 0x82CD,
  0x8231, 0x4ED3, 0x6CA7, 0x85CF, 0x64CD, 0x7CD9, 0x69FD, 0x66F9,
  0x8349, 0x5395, 0x7B56, 0x4FA7, 0x518C, 0x6D4B, 0x5C42, 0x8E6D,
  0x63D2, 0x53C9, 0x832C, 0x8336, 0x67E5, 0x78B4, 0x643D, 0x5BDF,
  0x5C94, 0x5DEE, 0x8BE7, 0x62C6, 0x67F4, 0x8C7A, 0x6400, 0x63BA,
  0x8749, 0x998B, 0x8C17, 0x7F20, 0x94F2, 0x4EA7, 0x9610, 0x98A4,
  0x660C, 0x7316, 0x573A, 0x5C1D, 0x5E38, 0x957F, 0x507F, 0x80A0,
  0x5382, 0x655E, 0x7545, 0x5531, 0x5021, 0x8D85, 0x6284, 0x949E,
  0x671D, 0x5632, 0x6F6E, 0x5DE2, 0x5435, 0x7092, 0x8F66, 0x626F,
  0x64A4, 0x63A3, 0x5F7B, 0x6F88, 0x90F4, 0x81E3, 0x8FB0, 0x5C18,
  0x6668, 0x5FF1, 0x6C89, 0x9648, 0x8D81, 0x886C, 0x6491, 0x79F0,
  0x57CE, 0x6A59, 0x6210, 0x5448, 0x4E58, 0x7A0B, 0x60E9, 0x6F84,
  0x8BDA, 0x627F, 0x901E, 0x9A8B, 0x79E4, 0x5403, 0x75F4, 0x6301,
  0x5319, 0x6C60, 0x8FDF, 0x5F1B, 0x9A70, 0x803B, 0x9F7F, 0x4F88,
  0x5C3A, 0x8D64, 0x7FC5, 0x65A5, 0x70BD, 0x5145, 0x51B2, 0x866B,
  0x5D07, 0x5BA0, 0x62BD, 0x916C, 0x7574, 0x8E0C, 0x7A20, 0x6101,
  0x7B79, 0x4EC7, 0x7EF8, 0x7785, 0x4E11, 0x81ED, 0x521D, 0x51FA,
  0x6A71, 0x53A8, 0x8E87, 0x9504, 0x96CF, 0x6EC1, 0x9664, 0x695A,
  0x7840, 0x50A8, 0x77D7, 0x6410, 0x89E6, 0x5904, 0x63E3, 0x5DDD,
  0x7A7F, 0x693D, 0x4F20, 0x8239, 0x5598, 0x4E32, 0x75AE, 0x7A97,
  0x5E62, 0x5E8A, 0x95EF, 0x521B, 0x5439, 0x708A, 0x6376, 0x9524,
  0x5782, 0x6625, 0x693F, 0x9187, 0x5507, 0x6DF3, 0x7EAF, 0x8822,
  0x6233, 0x7EF0, 0x75B5, 0x8328, 0x78C1, 0x96CC, 0x8F9E, 0x6148,
  0x74F7, 0x8BCD, 0x6B64, 0x523A, 0x8D50, 0x6B21, 0x806A, 0x8471,
  0x56F1, 0x5306, 0x4ECE, 0x4E1B, 0x51D1, 0x7C97, 0x918B, 0x7C07,
  0x4FC3, 0x8E7F, 0x7BE1, 0x7A9C, 0x6467, 0x5D14, 0x50AC, 0x8106,
  0x7601, 0x7CB9, 0x6DEC, 0x7FE0, 0x6751, 0x5B58, 0x5BF8, 0x78CB,
  0x64AE, 0x6413, 0x63AA, 0x632B, 0x9519, 0x642D, 0x8FBE, 0x7B54,
  0x7629, 0x6253, 0x5927, 0x5446, 0x6B79, 0x50A3, 0x6234, 0x5E26,
  0x6B86, 0x4EE3, 0x8D37, 0x888B, 0x5F85, 0x902E, 0x6020, 0x803D,
  0x62C5, 0x4E39, 0x5355, 0x90F8, 0x63B8, 0x80C6, 0x65E6, 0x6C2E,
  0x4F46, 0x60EE, 0x6DE1, 0x8BDE, 0x5F39, 0x86CB, 0x5F53, 0x6321,
  0x515A, 0x8361, 0x6863, 0x5200, 0x6363, 0x8E48, 0x5012, 0x5C9B,
  0x7977, 0x5BFC, 0x5230, 0x7A3B, 0x60BC, 0x9053, 0x76D7, 0x5FB7,
  0x5F97, 0x7684, 0x8E6C, 0x706F, 0x767B, 0x7B49, 0x77AA, 0x51F3,
  0x9093, 0x5824, 0x4F4E, 0x6EF4, 0x8FEA, 0x654C, 0x7B1B, 0x72C4,
  0x6DA4, 0x7FDF, 0x5AE1, 0x62B5, 0x5E95, 0x5730, 0x8482, 0x7B2C,
  0x5E1D, 0x5F1F, 0x9012, 0x7F14, 0x98A0, 0x6382, 0x6EC7, 0x7898,
  0x70B9, 0x5178, 0x975B, 0x57AB, 0x7535, 0x4F43, 0x7538, 0x5E97,
  0x60E6, 0x5960, 0x6DC0, 0x6BBF, 0x7889, 0x53FC, 0x96D5, 0x51CB,
  0x5201, 0x6389, 0x540A, 0x9493, 0x8C03, 0x8DCC, 0x7239, 0x789F,
  0x8776, 0x8FED, 0x8C0D, 0x53E0, 0x4E01, 0x76EF, 0x53EE, 0x9489,
  0x9876, 0x9F0E, 0x952D, 0x5B9A, 0x8BA2, 0x4E22, 0x4E1C, 0x51AC,
  0x8463, 0x61C2, 0x52A8, 0x680B, 0x4F97, 0x606B, 0x51BB, 0x6D1E,
  0x515C, 0x6296, 0x6597, 0x9661, 0x8C46, 0x9017, 0x75D8, 0x90FD,
  0x7763, 0x6BD2, 0x728A, 0x72EC, 0x8BFB, 0x5835, 0x7779, 0x8D4C,
  0x675C, 0x9540, 0x809A, 0x5EA6, 0x6E21, 0x5992, 0x7AEF, 0x77ED,
  0x953B, 0x6BB5, 0x65AD, 0x7F0E, 0x5806, 0x5151, 0x961F, 0x5BF9,
  0x58A9, 0x5428, 0x8E72, 0x6566, 0x987F, 0x56E4, 0x949D, 0x76FE,
  0x9041, 0x6387, 0x54C6, 0x591A, 0x593A, 0x579B, 0x8EB2, 0x6735,
  0x8DFA, 0x8235, 0x5241, 0x60F0, 0x5815, 0x86FE, 0x5CE8, 0x9E45,
  0x4FC4, 0x989D, 0x8BB9, 0x5A25, 0x6076, 0x5384, 0x627C, 0x904F,
  0x9102, 0x997F, 0x6069, 0x800C, 0x513F, 0x8033, 0x5C14, 0x9975,
  0x6D31, 0x4E8C, 0x8D30, 0x53D1, 0x7F5A, 0x7B4F, 0x4F10, 0x4E4F,
  0x9600, 0x6CD5, 0x73D0, 0x85E9, 0x5E06, 0x756A, 0x7FFB, 0x6A0A,
  0x77FE, 0x9492, 0x7E41, 0x51E1, 0x70E6, 0x53CD, 0x8FD4, 0x8303,
  0x8D29, 0x72AF, 0x996D, 0x6CDB, 0x574A, 0x82B3, 0x65B9, 0x80AA,
  0x623F, 0x9632, 0x59A8, 0x4EFF, 0x8BBF, 0x7EBA, 0x653E, 0x83F2,
  0x975E, 0x5561, 0x98DE, 0x80A5, 0x532A, 0x8BFD, 0x5420, 0x80BA,
  0x5E9F, 0x6CB8, 0x8D39, 0x82AC, 0x915A, 0x5429, 0x6C1B, 0x5206,
  0x7EB7, 0x575F, 0x711A, 0x6C7E, 0x7C89, 0x594B, 0x4EFD, 0x5FFF,
  0x6124, 0x7CAA, 0x4E30, 0x5C01, 0x67AB, 0x8702, 0x5CF0, 0x950B,
  0x98CE, 0x75AF, 0x70FD, 0x9022, 0x51AF, 0x7F1D, 0x8BBD, 0x5949,
  0x51E4, 0x4F5B, 0x5426, 0x592B, 0x6577, 0x80A4, 0x5B75, 0x6276,
  0x62C2, 0x8F90, 0x5E45, 0x6C1F, 0x7B26, 0x4F0F, 0x4FD8, 0x670D,
  0x6D6E, 0x6DAA, 0x798F, 0x88B1, 0x5F17, 0x752B, 0x629A, 0x8F85,
  0x4FEF, 0x91DC, 0x65A7, 0x812F, 0x8151, 0x5E9C, 0x8150, 0x8D74,
  0x526F, 0x8986, 0x8D4B, 0x590D, 0x5085, 0x4ED8, 0x961C, 0x7236,
  0x8179, 0x8D1F, 0x5BCC, 0x8BA3, 0x9644, 0x5987, 0x7F1A, 0x5490,
  0x5676, 0x560E, 0x8BE5, 0x6539, 0x6982, 0x9499, 0x76D6, 0x6E89,
  0x5E72, 0x7518, 0x6746, 0x67D1, 0x7AFF, 0x809D, 0x8D76, 0x611F,
  0x79C6, 0x6562, 0x8D63, 0x5188, 0x521A, 0x94A2, 0x7F38, 0x809B,
  0x7EB2, 0x5C97, 0x6E2F, 0x6760, 0x7BD9, 0x768B, 0x9AD8, 0x818F,
  0x7F94, 0x7CD5, 0x641E, 0x9550, 0x7A3F, 0x544A, 0x54E5, 0x6B4C,
  0x6401, 0x6208, 0x9E3D, 0x80F3, 0x7599, 0x5272, 0x9769, 0x845B,
  0x683C, 0x86E4, 0x9601, 0x9694, 0x94EC, 0x4E2A, 0x5404, 0x7ED9,
  0x6839, 0x8DDF, 0x8015, 0x66F4, 0x5E9A, 0x7FB9, 0x57C2, 0x803F,
  0x6897, 0x5DE5, 0x653B, 0x529F, 0x606D, 0x9F9A, 0x4F9B, 0x8EAC,
  0x516C, 0x5BAB, 0x5F13, 0x5DE9, 0x6C5E, 0x62F1, 0x8D21, 0x5171,
  0x94A9, 0x52FE, 0x6C9F, 0x82DF, 0x72D7, 0x57A2, 0x6784, 0x8D2D,
  0x591F, 0x8F9C, 0x83C7, 0x5495, 0x7B8D, 0x4F30, 0x6CBD, 0x5B64,
  0x59D1, 0x9F13, 0x53E4, 0x86CA, 0x9AA8, 0x8C37, 0x80A1, 0x6545,
  0x987E, 0x56FA, 0x96C7, 0x522E, 0x74DC, 0x5250, 0x5BE1, 0x6302,
  0x8902, 0x4E56, 0x62D0, 0x602A, 0x68FA, 0x5173, 0x5B98, 0x51A0,
  0x89C2, 0x7BA1, 0x9986, 0x7F50, 0x60EF, 0x704C, 0x8D2F, 0x5149,
  0x5E7F, 0x901B, 0x7470, 0x89C4, 0x572D, 0x7845, 0x5F52, 0x9F9F,
  0x95FA, 0x8F68, 0x9B3C, 0x8BE1, 0x7678, 0x6842, 0x67DC, 0x8DEA,
  0x8D35, 0x523D, 0x8F8A, 0x6EDA, 0x68CD, 0x9505, 0x90ED, 0x56FD,
  0x679C, 0x88F9, 0x8FC7, 0x54C8, 0x9AB8, 0x5B69, 0x6D77, 0x6C26,
  0x4EA5, 0x5BB3, 0x9A87, 0x9163, 0x61A8, 0x90AF, 0x97E9, 0x542B,
  0x6DB5, 0x5BD2, 0x51FD, 0x558A, 0x7F55, 0x7FF0, 0x64BC, 0x634D,
  0x65F1, 0x61BE, 0x608D, 0x710A, 0x6C57, 0x6C49, 0x592F, 0x676D,
  0x822A, 0x58D5, 0x568E, 0x8C6A, 0x6BEB, 0x90DD, 0x597D, 0x8017,
  0x53F7, 0x6D69, 0x5475, 0x559D, 0x8377, 0x83CF, 0x6838, 0x79BE,
  0x548C, 0x4F55, 0x5408, 0x76D2, 0x8C89, 0x9602, 0x6CB3, 0x6DB8,
  0x8D6B, 0x8910, 0x9E64, 0x8D3A, 0x563F, 0x9ED1, 0x75D5, 0x5F88,
  0x72E0, 0x6068, 0x54FC, 0x4EA8, 0x6A2A, 0x8861, 0x6052, 0x8F70,
  0x54C4, 0x70D8, 0x8679, 0x9E3F, 0x6D2A, 0x5B8F, 0x5F18, 0x7EA2,
  0x5589, 0x4FAF, 0x7334, 0x543C, 0x539A, 0x5019, 0x540E, 0x547C,
  0x4E4E, 0x5FFD, 0x745A, 0x58F6, 0x846B, 0x80E1, 0x8774, 0x72D0,
  0x7CCA, 0x6E56, 0x5F27, 0x864E, 0x552C, 0x62A4, 0x4E92, 0x6CAA,
  0x6237, 0x82B1, 0x54D7, 0x534E, 0x733E, 0x6ED1, 0x753B, 0x5212,
  0x5316, 0x8BDD, 0x69D0, 0x5F8A, 0x6000, 0x6DEE, 0x574F, 0x6B22,
  0x73AF, 0x6853, 0x8FD8, 0x7F13, 0x6362, 0x60A3, 0x5524, 0x75EA,
  0x8C62, 0x7115, 0x6DA3, 0x5BA6, 0x5E7B, 0x8352, 0x614C, 0x9EC4,
  0x78FA, 0x8757, 0x7C27, 0x7687, 0x51F0, 0x60F6, 0x714C, 0x6643,
  0x5E4C, 0x604D, 0x8C0E, 0x7070, 0x6325, 0x8F89, 0x5FBD, 0x6062,
  0x86D4, 0x56DE, 0x6BC1, 0x6094, 0x6167, 0x5349, 0x60E0, 0x6666,
  0x8D3F, 0x79FD, 0x4F1A, 0x70E9, 0x6C47, 0x8BB3, 0x8BF2, 0x7ED8,
  0x8364, 0x660F, 0x5A5A, 0x9B42, 0x6D51, 0x6DF7, 0x8C41, 0x6D3B,
  0x4F19, 0x706B, 0x83B7, 0x6216, 0x60D1, 0x970D, 0x8D27, 0x7978,
  0x51FB, 0x573E, 0x57FA, 0x673A, 0x7578, 0x7A3D, 0x79EF, 0x7B95,
  0x808C, 0x9965, 0x8FF9, 0x6FC0, 0x8BA5, 0x9E21, 0x59EC, 0x7EE9,
  0x7F09, 0x5409, 0x6781, 0x68D8, 0x8F91, 0x7C4D, 0x96C6, 0x53CA,
  0x6025, 0x75BE, 0x6C72, 0x5373, 0x5AC9, 0x7EA7, 0x6324, 0x51E0,
  0x810A, 0x5DF1, 0x84DF, 0x6280, 0x5180, 0x5B63, 0x4F0E, 0x796D,
  0x5242, 0x60B8, 0x6D4E, 0x5BC4, 0x5BC2, 0x8BA1, 0x8BB0, 0x65E2,
  0x5FCC, 0x9645, 0x5993, 0x7EE7, 0x7EAA, 0x5609, 0x67B7, 0x5939,
  0x4F73, 0x5BB6, 0x52A0, 0x835A, 0x988A, 0x8D3E, 0x7532, 0x94BE,
  0x5047, 0x7A3C, 0x4EF7, 0x67B6, 0x9A7E, 0x5AC1, 0x6B7C, 0x76D1,
  0x575A, 0x5C16, 0x7B3A, 0x95F4, 0x714E, 0x517C, 0x80A9, 0x8270,
  0x5978, 0x7F04, 0x8327, 0x68C0, 0x67EC, 0x78B1, 0x7877, 0x62E3,
  0x6361, 0x7B80, 0x4FED, 0x526A, 0x51CF, 0x8350, 0x69DB, 0x9274,
  0x8DF5, 0x8D31, 0x89C1, 0x952E, 0x7BAD, 0x4EF6, 0x5065, 0x8230,
  0x5251, 0x996F, 0x6E10, 0x6E85, 0x6DA7, 0x5EFA, 0x50F5, 0x59DC,
  0x5C06, 0x6D46, 0x6C5F, 0x7586, 0x848B, 0x6868, 0x5956, 0x8BB2,
  0x5320, 0x9171, 0x964D, 0x8549, 0x6912, 0x7901, 0x7126, 0x80F6,
  0x4EA4, 0x90CA, 0x6D47, 0x9A84, 0x5A07, 0x56BC, 0x6405, 0x94F0,
  0x77EB, 0x4FA5, 0x811A, 0x72E1, 0x89D2, 0x997A, 0x7F34, 0x7EDE,
  0x527F, 0x6559, 0x9175, 0x8F7F, 0x8F83, 0x53EB, 0x7A96, 0x63ED,
  0x63A5, 0x7686, 0x79F8, 0x8857, 0x9636, 0x622A, 0x52AB, 0x8282,
  0x6854, 0x6770, 0x6377, 0x776B, 0x7AED, 0x6D01, 0x7ED3, 0x89E3,
  0x59D0, 0x6212, 0x85C9, 0x82A5, 0x754C, 0x501F, 0x4ECB, 0x75A5,
  0x8BEB, 0x5C4A, 0x5DFE, 0x7B4B, 0x65A4, 0x91D1, 0x4ECA, 0x6D25,
  0x895F, 0x7D27, 0x9526, 0x4EC5, 0x8C28, 0x8FDB, 0x9773, 0x664B,
  0x7981, 0x8FD1, 0x70EC, 0x6D78, 0x5C3D, 0x52B2, 0x8346, 0x5162,
  0x830E, 0x775B, 0x6676, 0x9CB8, 0x4EAC, 0x60CA, 0x7CBE, 0x7CB3,
  0x7ECF, 0x4E95, 0x8B66, 0x666F, 0x9888, 0x9759, 0x5883, 0x656C,
  0x955C, 0x5F84, 0x75C9, 0x9756, 0x7ADF, 0x7ADE, 0x51C0, 0x70AF,
  0x7A98, 0x63EA, 0x7A76, 0x7EA0, 0x7396, 0x97ED, 0x4E45, 0x7078,
  0x4E5D, 0x9152, 0x53A9, 0x6551, 0x65E7, 0x81FC, 0x8205, 0x548E,
  0x5C31, 0x759A, 0x97A0, 0x62D8, 0x72D9, 0x75BD, 0x5C45, 0x9A79,
  0x83CA, 0x5C40, 0x5480, 0x77E9, 0x4E3E, 0x6CAE, 0x805A, 0x62D2,
  0x636E, 0x5DE8, 0x5177, 0x8DDD, 0x8E1E, 0x952F, 0x4FF1, 0x53E5,
  0x60E7, 0x70AC, 0x5267, 0x6350, 0x9E43, 0x5A1F, 0x5026, 0x7737,
  0x5377, 0x7EE2, 0x6485, 0x652B, 0x6289, 0x6398, 0x5014, 0x7235,
  0x89C9, 0x51B3, 0x8BC0, 0x7EDD, 0x5747, 0x83CC, 0x94A7, 0x519B,
  0x541B, 0x5CFB, 0x4FCA, 0x7AE3, 0x6D5A, 0x90E1, 0x9A8F, 0x5580,
  0x5496, 0x5361, 0x54AF, 0x5F00, 0x63E9, 0x6977, 0x51EF, 0x6168,
  0x520A, 0x582A, 0x52D8, 0x574E, 0x780D, 0x770B, 0x5EB7, 0x6177,
  0x7CE0, 0x625B, 0x6297, 0x4EA2, 0x7095, 0x8003, 0x62F7, 0x70E4,
  0x9760, 0x5777, 0x82DB, 0x67EF, 0x68F5, 0x78D5, 0x9897, 0x79D1,
  0x58F3, 0x54B3, 0x53EF, 0x6E34, 0x514B, 0x523B, 0x5BA2, 0x8BFE,
  0x80AF, 0x5543, 0x57A6, 0x6073, 0x5751, 0x542D, 0x7A7A, 0x6050,
  0x5B54, 0x63A7, 0x62A0, 0x53E3, 0x6263, 0x5BC7, 0x67AF, 0x54ED,
  0x7A9F, 0x82E6, 0x9177, 0x5E93, 0x88E4, 0x5938, 0x57AE, 0x630E,
  0x8DE8, 0x80EF, 0x5757, 0x7B77, 0x4FA9, 0x5FEB, 0x5BBD, 0x6B3E,
  0x5321, 0x7B50, 0x72C2, 0x6846, 0x77FF, 0x7736, 0x65F7, 0x51B5,
  0x4E8F, 0x76D4, 0x5CBF, 0x7AA5, 0x8475, 0x594E, 0x9B41, 0x5080,
  0x9988, 0x6127, 0x6E83, 0x5764, 0x6606, 0x6346, 0x56F0, 0x62EC,
  0x6269, 0x5ED3, 0x9614, 0x5783, 0x62C9, 0x5587, 0x8721, 0x814A,
  0x8FA3, 0x5566, 0x83B1, 0x6765, 0x8D56, 0x84DD, 0x5A6A, 0x680F,
  0x62E6, 0x7BEE, 0x9611, 0x5170, 0x6F9C, 0x8C30, 0x63FD, 0x89C8,
  0x61D2, 0x7F06, 0x70C2, 0x6EE5, 0x7405, 0x6994, 0x72FC, 0x5ECA,
  0x90CE, 0x6717, 0x6D6A, 0x635E, 0x52B3, 0x7262, 0x8001, 0x4F6C,
  0x59E5, 0x916A, 0x70D9, 0x6D9D, 0x52D2, 0x4E50, 0x96F7, 0x956D,
  0x857E, 0x78CA, 0x7D2F, 0x5121, 0x5792, 0x64C2, 0x808B, 0x7C7B,
  0x6CEA, 0x68F1, 0x695E, 0x51B7, 0x5398, 0x68A8, 0x7281, 0x9ECE,
  0x7BF1, 0x72F8, 0x79BB, 0x6F13, 0x7406, 0x674E, 0x91CC, 0x9CA4,
  0x793C, 0x8389, 0x8354, 0x540F, 0x6817, 0x4E3D, 0x5389, 0x52B1,
  0x783E, 0x5386, 0x5229, 0x5088, 0x4F8B, 0x4FD0, 0x75E2, 0x7ACB,
  0x7C92, 0x6CA5, 0x96B6, 0x529B, 0x7483, 0x54E9, 0x4FE9, 0x8054,
  0x83B2, 0x8FDE, 0x9570, 0x5EC9, 0x601C, 0x6D9F, 0x5E18, 0x655B,
  0x8138, 0x94FE, 0x604B, 0x70BC, 0x7EC3, 0x7CAE, 0x51C9, 0x6881,
  0x7CB1, 0x826F, 0x4E24, 0x8F86, 0x91CF, 0x667E, 0x4EAE, 0x8C05,
  0x64A9, 0x804A, 0x50DA, 0x7597, 0x71CE, 0x5BE5, 0x8FBD, 0x6F66,
  0x4E86, 0x6482, 0x9563, 0x5ED6, 0x6599, 0x5217, 0x88C2, 0x70C8,
  0x52A3, 0x730E, 0x7433, 0x6797, 0x78F7, 0x9716, 0x4E34, 0x90BB,
  0x9CDE, 0x6DCB, 0x51DB, 0x8D41, 0x541D, 0x62CE, 0x73B2, 0x83F1,
  0x96F6, 0x9F84, 0x94C3, 0x4F36, 0x7F9A, 0x51CC, 0x7075, 0x9675,
  0x5CAD, 0x9886, 0x53E6, 0x4EE4, 0x6E9C, 0x7409, 0x69B4, 0x786B,
  0x998F, 0x7559, 0x5218, 0x7624, 0x6D41, 0x67F3, 0x516D, 0x9F99,
  0x804B, 0x5499, 0x7B3C, 0x7ABF, 0x9686, 0x5784, 0x62E2, 0x9647,
  0x697C, 0x5A04, 0x6402, 0x7BD3, 0x6F0F, 0x964B, 0x82A6, 0x5362,
  0x9885, 0x5E90, 0x7089, 0x63B3, 0x5364, 0x864F, 0x9C81, 0x9E93,
  0x788C, 0x9732, 0x8DEF, 0x8D42, 0x9E7F, 0x6F5E, 0x7984, 0x5F55,
  0x9646, 0x622E, 0x9A74, 0x5415, 0x94DD, 0x4FA3, 0x65C5, 0x5C65,
  0x5C61, 0x7F15, 0x8651, 0x6C2F, 0x5F8B, 0x7387, 0x6EE4, 0x7EFF,
  0x5CE6, 0x631B, 0x5B6A, 0x6EE6, 0x5375, 0x4E71, 0x63A0, 0x7565,
  0x62A1, 0x8F6E, 0x4F26, 0x4ED1, 0x6CA6, 0x7EB6, 0x8BBA, 0x841D,
  0x87BA, 0x7F57, 0x903B, 0x9523, 0x7BA9, 0x9AA1, 0x88F8, 0x843D,
  0x6D1B, 0x9A86, 0x7EDC, 0x5988, 0x9EBB, 0x739B, 0x7801, 0x8682,
  0x9A6C, 0x9A82, 0x561B, 0x5417, 0x57CB, 0x4E70, 0x9EA6, 0x5356,
  0x8FC8, 0x8109, 0x7792, 0x9992, 0x86EE, 0x6EE1, 0x8513, 0x66FC,
  0x6162, 0x6F2B, 0x8C29, 0x8292, 0x832B, 0x76F2, 0x6C13, 0x5FD9,
  0x83BD, 0x732B, 0x8305, 0x951A, 0x6BDB, 0x77DB, 0x94C6, 0x536F,
  0x8302, 0x5192, 0x5E3D, 0x8C8C, 0x8D38, 0x4E48, 0x73AB, 0x679A,
  0x6885, 0x9176, 0x9709, 0x7164, 0x6CA1, 0x7709, 0x5A92, 0x9541,
  0x6BCF, 0x7F8E, 0x6627, 0x5BD0, 0x59B9, 0x5A9A, 0x95E8, 0x95F7,
  0x4EEC, 0x840C, 0x8499, 0x6AAC, 0x76DF, 0x9530, 0x731B, 0x68A6,
  0x5B5F, 0x772F, 0x919A, 0x9761, 0x7CDC, 0x8FF7, 0x8C1C, 0x5F25,
  0x7C73, 0x79D8, 0x89C5, 0x6CCC, 0x871C, 0x5BC6, 0x5E42, 0x68C9,
  0x7720, 0x7EF5, 0x5195, 0x514D, 0x52C9, 0x5A29, 0x7F05, 0x9762,
  0x82D7, 0x63CF, 0x7784, 0x85D0, 0x79D2, 0x6E3A, 0x5E99, 0x5999,
  0x8511, 0x706D, 0x6C11, 0x62BF, 0x76BF, 0x654F, 0x60AF, 0x95FD,
  0x660E, 0x879F, 0x9E23, 0x94ED, 0x540D, 0x547D, 0x8C2C, 0x6478,
  0x6479, 0x8611, 0x6A21, 0x819C, 0x78E8, 0x6469, 0x9B54, 0x62B9,
  0x672B, 0x83AB, 0x58A8, 0x9ED8, 0x6CAB, 0x6F20, 0x5BDE, 0x964C,
  0x8C0B, 0x725F, 0x67D0, 0x62C7, 0x7261, 0x4EA9, 0x59C6, 0x6BCD,
  0x5893, 0x66AE, 0x5E55, 0x52DF, 0x6155, 0x6728, 0x76EE, 0x7766,
  0x7267, 0x7A46, 0x62FF, 0x54EA, 0x5450, 0x94A0, 0x90A3, 0x5A1C,
  0x7EB3, 0x6C16, 0x4E43, 0x5976, 0x8010, 0x5948, 0x5357, 0x7537,
  0x96BE, 0x56CA, 0x6320, 0x8111, 0x607C, 0x95F9, 0x6DD6, 0x5462,
  0x9981, 0x5185, 0x5AE9, 0x80FD, 0x59AE, 0x9713, 0x502A, 0x6CE5,
  0x5C3C, 0x62DF, 0x4F60, 0x533F, 0x817B, 0x9006, 0x6EBA, 0x852B,
  0x62C8, 0x5E74, 0x78BE, 0x64B5, 0x637B, 0x5FF5, 0x5A18, 0x917F,
  0x9E1F, 0x5C3F, 0x634F, 0x8042, 0x5B7D, 0x556E, 0x954A, 0x954D,
  0x6D85, 0x60A8, 0x67E0, 0x72DE, 0x51DD, 0x5B81, 0x62E7, 0x6CDE,
  0x725B, 0x626D, 0x94AE, 0x7EBD, 0x8113, 0x6D53, 0x519C, 0x5F04,
  0x5974, 0x52AA, 0x6012, 0x5973, 0x6696, 0x8650, 0x759F, 0x632A,
  0x61E6, 0x7CEF, 0x8BFA, 0x54E6, 0x6B27, 0x9E25, 0x6BB4, 0x85D5,
  0x5455, 0x5076, 0x6CA4, 0x556A, 0x8DB4, 0x722C, 0x5E15, 0x6015,
  0x7436, 0x62CD, 0x6392, 0x724C, 0x5F98, 0x6E43, 0x6D3E, 0x6500,
  0x6F58, 0x76D8, 0x78D0, 0x76FC, 0x7554, 0x5224, 0x53DB, 0x4E53,
  0x5E9E, 0x65C1, 0x802A, 0x80D6, 0x629B, 0x5486, 0x5228, 0x70AE,
  0x888D, 0x8DD1, 0x6CE1, 0x5478, 0x80DA, 0x57F9, 0x88F4, 0x8D54,
  0x966A, 0x914D, 0x4F69, 0x6C9B, 0x55B7, 0x76C6, 0x7830, 0x62A8,
  0x70F9, 0x6F8E, 0x5F6D, 0x84EC, 0x68DA, 0x787C, 0x7BF7, 0x81A8,
  0x670B, 0x9E4F, 0x6367, 0x78B0, 0x576F, 0x7812, 0x9739, 0x6279,
  0x62AB, 0x5288, 0x7435, 0x6BD7, 0x5564, 0x813E, 0x75B2, 0x76AE,
  0x5339, 0x75DE, 0x50FB, 0x5C41, 0x8B6C, 0x7BC7, 0x504F, 0x7247,
  0x9A97, 0x98D8, 0x6F02, 0x74E2, 0x7968, 0x6487, 0x77A5, 0x62FC,
  0x9891, 0x8D2B, 0x54C1, 0x8058, 0x4E52, 0x576A, 0x82F9, 0x840D,
  0x5E73, 0x51ED, 0x74F6, 0x8BC4, 0x5C4F, 0x5761, 0x6CFC, 0x9887,
  0x5A46, 0x7834, 0x9B44, 0x8FEB, 0x7C95, 0x5256, 0x6251, 0x94FA,
  0x4EC6, 0x8386, 0x8461, 0x83E9, 0x84B2, 0x57D4, 0x6734, 0x5703,
  0x666E, 0x6D66, 0x8C31, 0x66DD, 0x7011, 0x671F, 0x6B3A, 0x6816,
  0x621A, 0x59BB, 0x4E03, 0x51C4, 0x6F06, 0x67D2, 0x6C8F, 0x5176,
  0x68CB, 0x5947, 0x6B67, 0x7566, 0x5D0E, 0x8110, 0x9F50, 0x65D7,
  0x7948, 0x7941, 0x9A91, 0x8D77, 0x5C82, 0x4E5E, 0x4F01, 0x542F,
  0x5951, 0x780C, 0x5668, 0x6C14, 0x8FC4, 0x5F03, 0x6C7D, 0x6CE3,
  0x8BAB, 0x6390, 0x6070, 0x6D3D, 0x7275, 0x6266, 0x948E, 0x94C5,
  0x5343, 0x8FC1, 0x7B7E, 0x4EDF, 0x8C26, 0x4E7E, 0x9ED4, 0x94B1,
  0x94B3, 0x524D, 0x6F5C, 0x9063, 0x6D45, 0x8C34, 0x5811, 0x5D4C,
  0x6B20, 0x6B49, 0x67AA, 0x545B, 0x8154, 0x7F8C, 0x5899, 0x8537,
  0x5F3A, 0x62A2, 0x6A47, 0x9539, 0x6572, 0x6084, 0x6865, 0x77A7,
  0x4E54, 0x4FA8, 0x5DE7, 0x9798, 0x64AC, 0x7FD8, 0x5CED, 0x4FCF,
  0x7A8D, 0x5207, 0x8304, 0x4E14, 0x602F, 0x7A83, 0x94A6, 0x4FB5,
  0x4EB2, 0x79E6, 0x7434, 0x52E4, 0x82B9, 0x64D2, 0x79BD, 0x5BDD,
  0x6C81, 0x9752, 0x8F7B, 0x6C22, 0x503E, 0x537F, 0x6E05, 0x64CE,
  0x6674, 0x6C30, 0x60C5, 0x9877, 0x8BF7, 0x5E86, 0x743C, 0x7A77,
  0x79CB, 0x4E18, 0x90B1, 0x7403, 0x6C42, 0x56DA, 0x914B, 0x6CC5,
  0x8D8B, 0x533A, 0x86C6, 0x66F2, 0x8EAF, 0x5C48, 0x9A71, 0x6E20,
  0x53D6, 0x5A36, 0x9F8B, 0x8DA3, 0x53BB, 0x5708, 0x98A7, 0x6743,
  0x919B, 0x6CC9, 0x5168, 0x75CA, 0x62F3, 0x72AC, 0x5238, 0x529D,
  0x7F3A, 0x7094, 0x7638, 0x5374, 0x9E4A, 0x69B7, 0x786E, 0x96C0,
  0x88D9, 0x7FA4, 0x7136, 0x71C3, 0x5189, 0x67D3, 0x74E4, 0x58E4,
  0x6518, 0x56B7, 0x8BA9, 0x9976, 0x6270, 0x7ED5, 0x60F9, 0x70ED,
  0x58EC, 0x4EC1, 0x4EBA, 0x5FCD, 0x97E7, 0x4EFB, 0x8BA4, 0x5203,
  0x598A, 0x7EAB, 0x6254, 0x4ECD, 0x65E5, 0x620E, 0x8338, 0x84C9,
  0x8363, 0x878D, 0x7194, 0x6EB6, 0x5BB9, 0x7ED2, 0x5197, 0x63C9,
  0x67D4, 0x8089, 0x8339, 0x8815, 0x5112, 0x5B7A, 0x5982, 0x8FB1,
  0x4E73, 0x6C5D, 0x5165, 0x8925, 0x8F6F, 0x962E, 0x854A, 0x745E,
  0x9510, 0x95F0, 0x6DA6, 0x82E5, 0x5F31, 0x6492, 0x6D12, 0x8428,
  0x816E, 0x9CC3, 0x585E, 0x8D5B, 0x4E09, 0x53C1, 0x4F1E, 0x6563,
  0x6851, 0x55D3, 0x4E27, 0x6414, 0x9A9A, 0x626B, 0x5AC2, 0x745F,
  0x8272, 0x6DA9, 0x68EE, 0x50E7, 0x838E, 0x7802, 0x6740, 0x5239,
  0x6C99, 0x7EB1, 0x50BB, 0x5565, 0x715E, 0x7B5B, 0x6652, 0x73CA,
  0x82EB, 0x6749, 0x5C71, 0x5220, 0x717D, 0x886B, 0x95EA, 0x9655,
  0x64C5, 0x8D61, 0x81B3, 0x5584, 0x6C55, 0x6247, 0x7F2E, 0x5892,
  0x4F24, 0x5546, 0x8D4F, 0x664C, 0x4E0A, 0x5C1A, 0x88F3, 0x68A2,
  0x634E, 0x7A0D, 0x70E7, 0x828D, 0x52FA, 0x97F6, 0x5C11, 0x54E8,
  0x90B5, 0x7ECD, 0x5962, 0x8D4A, 0x86C7, 0x820C, 0x820D, 0x8D66,
  0x6444, 0x5C04, 0x6151, 0x6D89, 0x793E, 0x8BBE, 0x7837, 0x7533,
  0x547B, 0x4F38, 0x8EAB, 0x6DF1, 0x5A20, 0x7EC5, 0x795E, 0x6C88,
  0x5BA1, 0x5A76, 0x751A, 0x80BE, 0x614E, 0x6E17, 0x58F0, 0x751F,
  0x7525, 0x7272, 0x5347, 0x7EF3, 0x7701, 0x76DB, 0x5269, 0x80DC,
  0x5723, 0x5E08, 0x5931, 0x72EE, 0x65BD, 0x6E7F, 0x8BD7, 0x5C38,
  0x8671, 0x5341, 0x77F3, 0x62FE, 0x65F6, 0x4EC0, 0x98DF, 0x8680,
  0x5B9E, 0x8BC6, 0x53F2, 0x77E2, 0x4F7F, 0x5C4E, 0x9A76, 0x59CB,
  0x5F0F, 0x793A, 0x58EB, 0x4E16, 0x67FF, 0x4E8B, 0x62ED, 0x8A93,
  0x901D, 0x52BF, 0x662F, 0x55DC, 0x566C, 0x9002, 0x4ED5, 0x4F8D,
  0x91CA, 0x9970, 0x6C0F, 0x5E02, 0x6043, 0x5BA4, 0x89C6, 0x8BD5,
  0x6536, 0x624B, 0x9996, 0x5B88, 0x5BFF, 0x6388, 0x552E, 0x53D7,
  0x7626, 0x517D, 0x852C, 0x67A2, 0x68B3, 0x6B8A, 0x6292, 0x8F93,
  0x53D4, 0x8212, 0x6DD1, 0x758F, 0x4E66, 0x8D4E, 0x5B70, 0x719F,
  0x85AF, 0x6691, 0x66D9, 0x7F72, 0x8700, 0x9ECD, 0x9F20, 0x5C5E,
  0x672F, 0x8FF0, 0x6811, 0x675F, 0x620D, 0x7AD6, 0x5885, 0x5EB6,
  0x6570, 0x6F31, 0x6055, 0x5237, 0x800D, 0x6454, 0x8870, 0x7529,
  0x5E05, 0x6813, 0x62F4, 0x971C, 0x53CC, 0x723D, 0x8C01, 0x6C34,
  0x7761, 0x7A0E, 0x542E, 0x77AC, 0x987A, 0x821C, 0x8BF4, 0x7855,
  0x6714, 0x70C1, 0x65AF, 0x6495, 0x5636, 0x601D, 0x79C1, 0x53F8,
  0x4E1D, 0x6B7B, 0x8086, 0x5BFA, 0x55E3, 0x56DB, 0x4F3A, 0x4F3C,
  0x9972, 0x5DF3, 0x677E, 0x8038, 0x6002, 0x9882, 0x9001, 0x5B8B,
  0x8BBC, 0x8BF5, 0x641C, 0x8258, 0x64DE, 0x55FD, 0x82CF, 0x9165,
  0x4FD7, 0x7D20, 0x901F, 0x7C9F, 0x50F3, 0x5851, 0x6EAF, 0x5BBF,
  0x8BC9, 0x8083, 0x9178, 0x849C, 0x7B97, 0x867D, 0x968B, 0x968F,
  0x7EE5, 0x9AD3, 0x788E, 0x5C81, 0x7A57, 0x9042, 0x96A7, 0x795F,
  0x5B59, 0x635F, 0x7B0B, 0x84D1, 0x68AD, 0x5506, 0x7F29, 0x7410,
  0x7D22, 0x9501, 0x6240, 0x584C, 0x4ED6, 0x5B83, 0x5979, 0x5854,
  0x736D, 0x631E, 0x8E4B, 0x8E0F, 0x80CE, 0x82D4, 0x62AC, 0x53F0,
  0x6CF0, 0x915E, 0x592A, 0x6001, 0x6C70, 0x574D, 0x644A, 0x8D2A,
  0x762B, 0x6EE9, 0x575B, 0x6A80, 0x75F0, 0x6F6D, 0x8C2D, 0x8C08,
  0x5766, 0x6BEF, 0x8892, 0x78B3, 0x63A2, 0x53F9, 0x70AD, 0x6C64,
  0x5858, 0x642A, 0x5802, 0x68E0, 0x819B, 0x5510, 0x7CD6, 0x5018,
  0x8EBA, 0x6DCC, 0x8D9F, 0x70EB, 0x638F, 0x6D9B, 0x6ED4, 0x7EE6,
  0x8404, 0x6843, 0x9003, 0x6DD8, 0x9676, 0x8BA8, 0x5957, 0x7279,
  0x85E4, 0x817E, 0x75BC, 0x8A8A, 0x68AF, 0x5254, 0x8E22, 0x9511,
  0x63D0, 0x9898, 0x8E44, 0x557C, 0x4F53, 0x66FF, 0x568F, 0x60D5,
  0x6D95, 0x5243, 0x5C49, 0x5929, 0x6DFB, 0x586B, 0x7530, 0x751C,
  0x606C, 0x8214, 0x8146, 0x6311, 0x6761, 0x8FE2, 0x773A, 0x8DF3,
  0x8D34, 0x94C1, 0x5E16, 0x5385, 0x542C, 0x70C3, 0x6C40, 0x5EF7,
  0x505C, 0x4EAD, 0x5EAD, 0x633A, 0x8247, 0x901A, 0x6850, 0x916E,
  0x77B3, 0x540C, 0x94DC, 0x5F64, 0x7AE5, 0x6876, 0x6345, 0x7B52,
  0x7EDF, 0x75DB, 0x5077, 0x6295, 0x5934, 0x900F, 0x51F8, 0x79C3,
  0x7A81, 0x56FE, 0x5F92, 0x9014, 0x6D82, 0x5C60, 0x571F, 0x5410,
  0x5154, 0x6E4D, 0x56E2, 0x63A8, 0x9893, 0x817F, 0x8715, 0x892A,
  0x9000, 0x541E, 0x5C6F, 0x81C0, 0x62D6, 0x6258, 0x8131, 0x9E35,
  0x9640, 0x9A6E, 0x9A7C, 0x692D, 0x59A5, 0x62D3, 0x553E, 0x6316,
  0x54C7, 0x86D9, 0x6D3C, 0x5A03, 0x74E6, 0x889C, 0x6B6A, 0x5916,
  0x8C4C, 0x5F2F, 0x6E7E, 0x73A9, 0x987D, 0x4E38, 0x70F7, 0x5B8C,
  0x7897, 0x633D, 0x665A, 0x7696, 0x60CB, 0x5B9B, 0x5A49, 0x4E07,
  0x8155, 0x6C6A, 0x738B, 0x4EA1, 0x6789, 0x7F51, 0x5F80, 0x65FA,
  0x671B, 0x5FD8, 0x5984, 0x5A01, 0x5DCD, 0x5FAE, 0x5371, 0x97E6,
  0x8FDD, 0x6845, 0x56F4, 0x552F, 0x60DF, 0x4E3A, 0x6F4D, 0x7EF4,
  0x82C7, 0x840E, 0x59D4, 0x4F1F, 0x4F2A, 0x5C3E, 0x7EAC, 0x672A,
  0x851A, 0x5473, 0x754F, 0x80C3, 0x5582, 0x9B4F, 0x4F4D, 0x6E2D,
  0x8C13, 0x5C09, 0x6170, 0x536B, 0x761F, 0x6E29, 0x868A, 0x6587,
  0x95FB, 0x7EB9, 0x543B, 0x7A33, 0x7D0A, 0x95EE, 0x55E1, 0x7FC1,
  0x74EE, 0x631D, 0x8717, 0x6DA1, 0x7A9D, 0x6211, 0x65A1, 0x5367,
  0x63E1, 0x6C83, 0x5DEB, 0x545C, 0x94A8, 0x4E4C, 0x6C61, 0x8BEC,
  0x5C4B, 0x65E0, 0x829C, 0x68A7, 0x543E, 0x5434, 0x6BCB, 0x6B66,
  0x4E94, 0x6342, 0x5348, 0x821E, 0x4F0D, 0x4FAE, 0x575E, 0x620A,
  0x96FE, 0x6664, 0x7269, 0x52FF, 0x52A1, 0x609F, 0x8BEF, 0x6614,
  0x7199, 0x6790, 0x897F, 0x7852, 0x77FD, 0x6670, 0x563B, 0x5438,
  0x9521, 0x727A, 0x7A00, 0x606F, 0x5E0C, 0x6089, 0x819D, 0x5915,
  0x60DC, 0x7184, 0x70EF, 0x6EAA, 0x6C50, 0x7280, 0x6A84, 0x88AD,
  0x5E2D, 0x4E60, 0x5AB3, 0x559C, 0x94E3, 0x6D17, 0x7CFB, 0x9699,
  0x620F, 0x7EC6, 0x778E, 0x867E, 0x5323, 0x971E, 0x8F96, 0x6687,
  0x5CE1, 0x4FA0, 0x72ED, 0x4E0B, 0x53A6, 0x590F, 0x5413, 0x6380,
  0x9528, 0x5148, 0x4ED9, 0x9C9C, 0x7EA4, 0x54B8, 0x8D24, 0x8854,
  0x8237, 0x95F2, 0x6D8E, 0x5F26, 0x5ACC, 0x663E, 0x9669, 0x73B0,
  0x732E, 0x53BF, 0x817A, 0x9985, 0x7FA1, 0x5BAA, 0x9677, 0x9650,
  0x7EBF, 0x76F8, 0x53A2, 0x9576, 0x9999, 0x7BB1, 0x8944, 0x6E58,
  0x4E61, 0x7FD4, 0x7965, 0x8BE6, 0x60F3, 0x54CD, 0x4EAB, 0x9879,
  0x5DF7, 0x6A61, 0x50CF, 0x5411, 0x8C61, 0x8427, 0x785D, 0x9704,
  0x524A, 0x54EE, 0x56A3, 0x9500, 0x6D88, 0x5BB5, 0x6DC6, 0x6653,
  0x5C0F, 0x5B5D, 0x6821, 0x8096, 0x5578, 0x7B11, 0x6548, 0x6954,
  0x4E9B, 0x6B47, 0x874E, 0x978B, 0x534F, 0x631F, 0x643A, 0x90AA,
  0x659C, 0x80C1, 0x8C10, 0x5199, 0x68B0, 0x5378, 0x87F9, 0x61C8,
  0x6CC4, 0x6CFB, 0x8C22, 0x5C51, 0x85AA, 0x82AF, 0x950C, 0x6B23,
  0x8F9B, 0x65B0, 0x5FFB, 0x5FC3, 0x4FE1, 0x8845, 0x661F, 0x8165,
  0x7329, 0x60FA, 0x5174, 0x5211, 0x578B, 0x5F62, 0x90A2, 0x884C,
  0x9192, 0x5E78, 0x674F, 0x6027, 0x59D3, 0x5144, 0x51F6, 0x80F8,
  0x5308, 0x6C79, 0x96C4, 0x718A, 0x4F11, 0x4FEE, 0x7F9E, 0x673D,
  0x55C5, 0x9508, 0x79C0, 0x8896, 0x7EE3, 0x589F, 0x620C, 0x9700,
  0x865A, 0x5618, 0x987B, 0x5F90, 0x8BB8, 0x84C4, 0x9157, 0x53D9,
  0x65ED, 0x5E8F, 0x755C, 0x6064, 0x7D6E, 0x5A7F, 0x7EEA, 0x7EED,
  0x8F69, 0x55A7, 0x5BA3, 0x60AC, 0x65CB, 0x7384, 0x9009, 0x7663,
  0x7729, 0x7EDA, 0x9774, 0x859B, 0x5B66, 0x7A74, 0x96EA, 0x8840,
  0x52CB, 0x718F, 0x5FAA, 0x65EC, 0x8BE2, 0x5BFB, 0x9A6F, 0x5DE1,
  0x6B89, 0x6C5B, 0x8BAD, 0x8BAF, 0x900A, 0x8FC5, 0x538B, 0x62BC,
  0x9E26, 0x9E2D, 0x5440, 0x4E2B, 0x82BD, 0x7259, 0x869C, 0x5D16,
  0x8859, 0x6DAF, 0x96C5, 0x54D1, 0x4E9A, 0x8BB6, 0x7109, 0x54BD,
  0x9609, 0x70DF, 0x6DF9, 0x76D0, 0x4E25, 0x7814, 0x8712, 0x5CA9,
  0x5EF6, 0x8A00, 0x989C, 0x960E, 0x708E, 0x6CBF, 0x5944, 0x63A9,
  0x773C, 0x884D, 0x6F14, 0x8273, 0x5830, 0x71D5, 0x538C, 0x781A,
  0x96C1, 0x5501, 0x5F66, 0x7130, 0x5BB4, 0x8C1A, 0x9A8C, 0x6B83,
  0x592E, 0x9E2F, 0x79E7, 0x6768, 0x626C, 0x4F6F, 0x75A1, 0x7F8A,
  0x6D0B, 0x9633, 0x6C27, 0x4EF0, 0x75D2, 0x517B, 0x6837, 0x6F3E,
  0x9080, 0x8170, 0x5996, 0x7476, 0x6447, 0x5C27, 0x9065, 0x7A91,
  0x8C23, 0x59DA, 0x54AC, 0x8200, 0x836F, 0x8981, 0x8000, 0x6930,
  0x564E, 0x8036, 0x7237, 0x91CE, 0x51B6, 0x4E5F, 0x9875, 0x6396,
  0x4E1A, 0x53F6, 0x66F3, 0x814B, 0x591C, 0x6DB2, 0x4E00, 0x58F9,
  0x533B, 0x63D6, 0x94F1, 0x4F9D, 0x4F0A, 0x8863, 0x9890, 0x5937,
  0x9057, 0x79FB, 0x4EEA, 0x80F0, 0x7591, 0x6C82, 0x5B9C, 0x59E8,
  0x5F5D, 0x6905, 0x8681, 0x501A, 0x5DF2, 0x4E59, 0x77E3, 0x4EE5,
  0x827A, 0x6291, 0x6613, 0x9091, 0x5C79, 0x4EBF, 0x5F79, 0x81C6,
  0x9038, 0x8084, 0x75AB, 0x4EA6, 0x88D4, 0x610F, 0x6BC5, 0x5FC6,
  0x4E49, 0x76CA, 0x6EA2, 0x8BE3, 0x8BAE, 0x8C0A, 0x8BD1, 0x5F02,
  0x7FFC, 0x7FCC, 0x7ECE, 0x8335, 0x836B, 0x56E0, 0x6BB7, 0x97F3,
  0x9634, 0x59FB, 0x541F, 0x94F6, 0x6DEB, 0x5BC5, 0x996E, 0x5C39,
  0x5F15, 0x9690, 0x5370, 0x82F1, 0x6A31, 0x5A74, 0x9E70, 0x5E94,
  0x7F28, 0x83B9, 0x8424, 0x8425, 0x8367, 0x8747, 0x8FCE, 0x8D62,
  0x76C8, 0x5F71, 0x9896, 0x786C, 0x6620, 0x54DF, 0x62E5, 0x4F63,
  0x81C3, 0x75C8, 0x5EB8, 0x96CD, 0x8E0A, 0x86F9, 0x548F, 0x6CF3,
  0x6D8C, 0x6C38, 0x607F, 0x52C7, 0x7528, 0x5E7D, 0x4F18, 0x60A0,
  0x5FE7, 0x5C24, 0x7531, 0x90AE, 0x94C0, 0x72B9, 0x6CB9, 0x6E38,
  0x9149, 0x6709, 0x53CB, 0x53F3, 0x4F51, 0x91C9, 0x8BF1, 0x53C8,
  0x5E7C, 0x8FC2, 0x6DE4, 0x4E8E, 0x76C2, 0x6986, 0x865E, 0x611A,
  0x8206, 0x4F59, 0x4FDE, 0x903E, 0x9C7C, 0x6109, 0x6E1D, 0x6E14,
  0x9685, 0x4E88, 0x5A31, 0x96E8, 0x4E0E, 0x5C7F, 0x79B9, 0x5B87,
  0x8BED, 0x7FBD, 0x7389, 0x57DF, 0x828B, 0x90C1, 0x5401, 0x9047,
  0x55BB, 0x5CEA, 0x5FA1, 0x6108, 0x6B32, 0x72F1, 0x80B2, 0x8A89,
  0x6D74, 0x5BD3, 0x88D5, 0x9884, 0x8C6B, 0x9A6D, 0x9E33, 0x6E0A,
  0x51A4, 0x5143, 0x57A3, 0x8881, 0x539F, 0x63F4, 0x8F95, 0x56ED,
  0x5458, 0x5706, 0x733F, 0x6E90, 0x7F18, 0x8FDC, 0x82D1, 0x613F,
  0x6028, 0x9662, 0x66F0, 0x7EA6, 0x8D8A, 0x8DC3, 0x94A5, 0x5CB3,
  0x7CA4, 0x6708, 0x60A6, 0x9605, 0x8018, 0x4E91, 0x90E7, 0x5300,
  0x9668, 0x5141, 0x8FD0, 0x8574, 0x915D, 0x6655, 0x97F5, 0x5B55,
  0x531D, 0x7838, 0x6742, 0x683D, 0x54C9, 0x707E, 0x5BB0, 0x8F7D,
  0x518D, 0x5728, 0x54B1, 0x6512, 0x6682, 0x8D5E, 0x8D43, 0x810F,
  0x846C, 0x906D, 0x7CDF, 0x51FF, 0x85FB, 0x67A3, 0x65E9, 0x6FA1,
  0x86A4, 0x8E81, 0x566A, 0x9020, 0x7682, 0x7076, 0x71E5, 0x8D23,
  0x62E9, 0x5219, 0x6CFD, 0x8D3C, 0x600E, 0x589E, 0x618E, 0x66FE,
  0x8D60, 0x624E, 0x55B3, 0x6E23, 0x672D, 0x8F67, 0x94E1, 0x95F8,
  0x7728, 0x6805, 0x69A8, 0x548B, 0x4E4D, 0x70B8, 0x8BC8, 0x6458,
  0x658B, 0x5B85, 0x7A84, 0x503A, 0x5BE8, 0x77BB, 0x6BE1, 0x8A79,
  0x7C98, 0x6CBE, 0x76CF, 0x65A9, 0x8F97, 0x5D2D, 0x5C55, 0x8638,
  0x6808, 0x5360, 0x6218, 0x7AD9, 0x6E5B, 0x7EFD, 0x6A1F, 0x7AE0,
  0x5F70, 0x6F33, 0x5F20, 0x638C, 0x6DA8, 0x6756, 0x4E08, 0x5E10,
  0x8D26, 0x4ED7, 0x80C0, 0x7634, 0x969C, 0x62DB, 0x662D, 0x627E,
  0x6CBC, 0x8D75, 0x7167, 0x7F69, 0x5146, 0x8087, 0x53EC, 0x906E,
  0x6298, 0x54F2, 0x86F0, 0x8F99, 0x8005, 0x9517, 0x8517, 0x8FD9,
  0x6D59, 0x73CD, 0x659F, 0x771F, 0x7504, 0x7827, 0x81FB, 0x8D1E,
  0x9488, 0x4FA6, 0x6795, 0x75B9, 0x8BCA, 0x9707, 0x632F, 0x9547,
  0x9635, 0x84B8, 0x6323, 0x7741, 0x5F81, 0x72F0, 0x4E89, 0x6014,
  0x6574, 0x62EF, 0x6B63, 0x653F, 0x5E27, 0x75C7, 0x90D1, 0x8BC1,
  0x829D, 0x679D, 0x652F, 0x5431, 0x8718, 0x77E5, 0x80A2, 0x8102,
  0x6C41, 0x4E4B, 0x7EC7, 0x804C, 0x76F4, 0x690D, 0x6B96, 0x6267,
  0x503C, 0x4F84, 0x5740, 0x6307, 0x6B62, 0x8DBE, 0x53EA, 0x65E8,
  0x7EB8, 0x5FD7, 0x631A, 0x63B7, 0x81F3, 0x81F4, 0x7F6E, 0x5E1C,
  0x5CD9, 0x5236, 0x667A, 0x79E9, 0x7A1A, 0x8D28, 0x7099, 0x75D4,
  0x6EDE, 0x6CBB, 0x7A92, 0x4E2D, 0x76C5, 0x5FE0, 0x949F, 0x8877,
  0x7EC8, 0x79CD, 0x80BF, 0x91CD, 0x4EF2, 0x4F17, 0x821F, 0x5468,
  0x5DDE, 0x6D32, 0x8BCC, 0x7CA5, 0x8F74, 0x8098, 0x5E1A, 0x5492,
  0x76B1, 0x5B99, 0x663C, 0x9AA4, 0x73E0, 0x682A, 0x86DB, 0x6731,
  0x732A, 0x8BF8, 0x8BDB, 0x9010, 0x7AF9, 0x70DB, 0x716E, 0x62C4,
  0x77A9, 0x5631, 0x4E3B, 0x8457, 0x67F1, 0x52A9, 0x86C0, 0x8D2E,
  0x94F8, 0x7B51, 0x4F4F, 0x6CE8, 0x795D, 0x9A7B, 0x6293, 0x722A,
  0x62FD, 0x4E13, 0x7816, 0x8F6C, 0x64B0, 0x8D5A, 0x7BC6, 0x6869,
  0x5E84, 0x88C5, 0x5986, 0x649E, 0x58EE, 0x72B6, 0x690E, 0x9525,
  0x8FFD, 0x8D58, 0x5760, 0x7F00, 0x8C06, 0x51C6, 0x6349, 0x62D9,
  0x5353, 0x684C, 0x7422, 0x8301, 0x914C, 0x5544, 0x7740, 0x707C,
  0x6D4A, 0x5179, 0x54A8, 0x8D44, 0x59FF, 0x6ECB, 0x6DC4, 0x5B5C,
  0x7D2B, 0x4ED4, 0x7C7D, 0x6ED3, 0x5B50, 0x81EA, 0x6E0D, 0x5B57,
  0x9B03, 0x68D5, 0x8E2A, 0x5B97, 0x7EFC, 0x603B, 0x7EB5, 0x90B9,
  0x8D70, 0x594F, 0x63CD, 0x79DF, 0x8DB3, 0x5352, 0x65CF, 0x7956,
  0x8BC5, 0x963B, 0x7EC4, 0x94BB, 0x7E82, 0x5634, 0x9189, 0x6700,
  0x7F6A, 0x5C0A, 0x9075, 0x6628, 0x5DE6, 0x4F50, 0x67DE, 0x505A,
  0x4F5C, 0x5750, 0x5EA7, 0xE810, 0xE811, 0xE812, 0xE813, 0xE814,
  0x4E8D, 0x4E0C, 0x5140, 0x4E10, 0x5EFF, 0x5345, 0x4E15, 0x4E98,
  0x4E1E, 0x9B32, 0x5B6C, 0x5669, 0x4E28, 0x79BA, 0x4E3F, 0x5315,
  0x4E47, 0x592D, 0x723B, 0x536E, 0x6C10, 0x56DF, 0x80E4, 0x9997,
  0x6BD3, 0x777E, 0x9F17, 0x4E36, 0x4E9F, 0x9F10, 0x4E5C, 0x4E69,
  0x4E93, 0x8288, 0x5B5B, 0x556C, 0x560F, 0x4EC4, 0x538D, 0x539D,
  0x53A3, 0x53A5, 0x53AE, 0x9765, 0x8D5D, 0x531A, 0x53F5, 0x5326,
  0x532E, 0x533E, 0x8D5C, 0x5366, 0x5363, 0x5202, 0x5208, 0x520E,
  0x522D, 0x5233, 0x523F, 0x5240, 0x524C, 0x525E, 0x5261, 0x525C,
  0x84AF, 0x527D, 0x5282, 0x5281, 0x5290, 0x5293, 0x5182, 0x7F54,
  0x4EBB, 0x4EC3, 0x4EC9, 0x4EC2, 0x4EE8, 0x4EE1, 0x4EEB, 0x4EDE,
  0x4F1B, 0x4EF3, 0x4F22, 0x4F64, 0x4EF5, 0x4F25, 0x4F27, 0x4F09,
  0x4F2B, 0x4F5E, 0x4F67, 0x6538, 0x4F5A, 0x4F5D, 0x4F5F, 0x4F57,
  0x4F32, 0x4F3D, 0x4F76, 0x4F74, 0x4F91, 0x4F89, 0x4F83, 0x4F8F,
  0x4F7E, 0x4F7B, 0x4FAA, 0x4F7C, 0x4FAC, 0x4F94, 0x4FE6, 0x4FE8,
  0x4FEA, 0x4FC5, 0x4FDA, 0x4FE3, 0x4FDC, 0x4FD1, 0x4FDF, 0x4FF8,
  0x5029, 0x504C, 0x4FF3, 0x502C, 0x500F, 0x502E, 0x502D, 0x4FFE,
  0x501C, 0x500C, 0x5025, 0x5028, 0x507E, 0x5043, 0x5055, 0x5048,
  0x504E, 0x506C, 0x507B, 0x50A5, 0x50A7, 0x50A9, 0x50BA, 0x50D6,
  0x5106, 0x50ED, 0x50EC, 0x50E6, 0x50EE, 0x5107, 0x510B, 0x4EDD,
  0x6C3D, 0x4F58, 0x4F65, 0x4FCE, 0x9FA0, 0x6C46, 0x7C74, 0x516E,
  0x5DFD, 0x9EC9, 0x9998, 0x5181, 0x5914, 0x52F9, 0x530D, 0x8A07,
  0x5310, 0x51EB, 0x5919, 0x5155, 0x4EA0, 0x5156, 0x4EB3, 0x886E,
  0x88A4, 0x4EB5, 0x8114, 0x88D2, 0x7980, 0x5B34, 0x8803, 0x7FB8,
  0x51AB, 0x51B1, 0x51BD, 0x51BC, 0x51C7, 0x5196, 0x51A2, 0x51A5,
  0x8BA0, 0x8BA6, 0x8BA7, 0x8BAA, 0x8BB4, 0x8BB5, 0x8BB7, 0x8BC2,
  0x8BC3, 0x8BCB, 0x8BCF, 0x8BCE, 0x8BD2, 0x8BD3, 0x8BD4, 0x8BD6,
  0x8BD8, 0x8BD9, 0x8BDC, 0x8BDF, 0x8BE0, 0x8BE4, 0x8BE8, 0x8BE9,
  0x8BEE, 0x8BF0, 0x8BF3, 0x8BF6, 0x8BF9, 0x8BFC, 0x8BFF, 0x8C00,
  0x8C02, 0x8C04, 0x8C07, 0x8C0C, 0x8C0F, 0x8C11, 0x8C12, 0x8C14,
  0x8C15, 0x8C16, 0x8C19, 0x8C1B, 0x8C18, 0x8C1D, 0x8C1F, 0x8C20,
  0x8C21, 0x8C25, 0x8C27, 0x8C2A, 0x8C2B, 0x8C2E, 0x8C2F, 0x8C32,
  0x8C33, 0x8C35, 0x8C36, 0x5369, 0x537A, 0x961D, 0x9622, 0x9621,
  0x9631, 0x962A, 0x963D, 0x963C, 0x9642, 0x9649, 0x9654, 0x965F,
  0x9667, 0x966C, 0x9672, 0x9674, 0x9688, 0x968D, 0x9697, 0x96B0,
  0x9097, 0x909B, 0x909D, 0x9099, 0x90AC, 0x90A1, 0x90B4, 0x90B3,
  0x90B6, 0x90BA, 0x90B8, 0x90B0, 0x90CF, 0x90C5, 0x90BE, 0x90D0,
  0x90C4, 0x90C7, 0x90D3, 0x90E6, 0x90E2, 0x90DC, 0x90D7, 0x90DB,
  0x90EB, 0x90EF, 0x90FE, 0x9104, 0x9122, 0x911E, 0x9123, 0x9131,
  0x912F, 0x9139, 0x9143, 0x9146, 0x520D, 0x5942, 0x52A2, 0x52AC,
  0x52AD, 0x52BE, 0x54FF, 0x52D0, 0x52D6, 0x52F0, 0x53DF, 0x71EE,
  0x77CD, 0x5EF4, 0x51F5, 0x51FC, 0x9B2F, 0x53B6, 0x5F01, 0x755A,
  0x5DEF, 0x574C, 0x57A9, 0x57A1, 0x587E, 0x58BC, 0x58C5, 0x58D1,
  0x5729, 0x572C, 0x572A, 0x5733, 0x5739, 0x572E, 0x572F, 0x575C,
  0x573B, 0x5742, 0x5769, 0x5785, 0x576B, 0x5786, 0x577C, 0x577B,
  0x5768, 0x576D, 0x5776, 0x5773, 0x57AD, 0x57A4, 0x578C, 0x57B2,
  0x57CF, 0x57A7, 0x57B4, 0x5793, 0x57A0, 0x57D5, 0x57D8, 0x57DA,
  0x57D9, 0x57D2, 0x57B8, 0x57F4, 0x57EF, 0x57F8, 0x57E4, 0x57DD,
  0x580B, 0x580D, 0x57FD, 0x57ED, 0x5800, 0x581E, 0x5819, 0x5844,
  0x5820, 0x5865, 0x586C, 0x5881, 0x5889, 0x589A, 0x5880, 0x99A8,
  0x9F19, 0x61FF, 0x8279, 0x827D, 0x827F, 0x828F, 0x828A, 0x82A8,
  0x8284, 0x828E, 0x8291, 0x8297, 0x8299, 0x82AB, 0x82B8, 0x82BE,
  0x82B0, 0x82C8, 0x82CA, 0x82E3, 0x8298, 0x82B7, 0x82AE, 0x82CB,
  0x82CC, 0x82C1, 0x82A9, 0x82B4, 0x82A1, 0x82AA, 0x829F, 0x82C4,
  0x82CE, 0x82A4, 0x82E1, 0x8309, 0x82F7, 0x82E4, 0x830F, 0x8307,
  0x82DC, 0x82F4, 0x82D2, 0x82D8, 0x830C, 0x82FB, 0x82D3, 0x8311,
  0x831A, 0x8306, 0x8314, 0x8315, 0x82E0, 0x82D5, 0x831C, 0x8351,
  0x835B, 0x835C, 0x8308, 0x8392, 0x833C, 0x8334, 0x8331, 0x839B,
  0x835E, 0x832F, 0x834F, 0x8347, 0x8343, 0x835F, 0x8340, 0x8317,
  0x8360, 0x832D, 0x833A, 0x8333, 0x8366, 0x8365, 0x8368, 0x831B,
  0x8369, 0x836C, 0x836A, 0x836D, 0x836E, 0x83B0, 0x8378, 0x83B3,
  0x83B4, 0x83A0, 0x83AA, 0x8393, 0x839C, 0x8385, 0x837C, 0x83B6,
  0x83A9, 0x837D, 0x83B8, 0x837B, 0x8398, 0x839E, 0x83A8, 0x83BA,
  0x83BC, 0x83C1, 0x8401, 0x83E5, 0x83D8, 0x5807, 0x8418, 0x840B,
  0x83DD, 0x83FD, 0x83D6, 0x841C, 0x8438, 0x8411, 0x8406, 0x83D4,
  0x83DF, 0x840F, 0x8403, 0x83F8, 0x83F9, 0x83EA, 0x83C5, 0x83C0,
  0x8426, 0x83F0, 0x83E1, 0x845C, 0x8451, 0x845A, 0x8459, 0x8473,
  0x8487, 0x8488, 0x847A, 0x8489, 0x8478, 0x843C, 0x8446, 0x8469,
  0x8476, 0x848C, 0x848E, 0x8431, 0x846D, 0x84C1, 0x84CD, 0x84D0,
  0x84E6, 0x84BD, 0x84D3, 0x84CA, 0x84BF, 0x84BA, 0x84E0, 0x84A1,
  0x84B9, 0x84B4, 0x8497, 0x84E5, 0x84E3, 0x850C, 0x750D, 0x8538,
  0x84F0, 0x8539, 0x851F, 0x853A, 0x8556, 0x853B, 0x84FF, 0x84FC,
  0x8559, 0x8548, 0x8568, 0x8564, 0x855E, 0x857A, 0x77A2, 0x8543,
  0x8572, 0x857B, 0x85A4, 0x85A8, 0x8587, 0x858F, 0x8579, 0x85AE,
  0x859C, 0x8585, 0x85B9, 0x85B7, 0x85B0, 0x85D3, 0x85C1, 0x85DC,
  0x85FF, 0x8627, 0x8605, 0x8629, 0x8616, 0x863C, 0x5EFE, 0x5F08,
  0x593C, 0x5941, 0x8037, 0x5955, 0x595A, 0x5958, 0x530F, 0x5C22,
  0x5C25, 0x5C2C, 0x5C34, 0x624C, 0x626A, 0x629F, 0x62BB, 0x62CA,
  0x62DA, 0x62D7, 0x62EE, 0x6322, 0x62F6, 0x6339, 0x634B, 0x6343,
  0x63AD, 0x63F6, 0x6371, 0x637A, 0x638E, 0x63B4, 0x636D, 0x63AC,
  0x638A, 0x6369, 0x63AE, 0x63BC, 0x63F2, 0x63F8, 0x63E0, 0x63FF,
  0x63C4, 0x63DE, 0x63CE, 0x6452, 0x63C6, 0x63BE, 0x6445, 0x6441,
  0x640B, 0x641B, 0x6420, 0x640C, 0x6426, 0x6421, 0x645E, 0x6484,
  0x646D, 0x6496, 0x647A, 0x64B7, 0x64B8, 0x6499, 0x64BA, 0x64C0,
  0x64D0, 0x64D7, 0x64E4, 0x64E2, 0x6509, 0x6525, 0x652E, 0x5F0B,
  0x5FD2, 0x7519, 0x5F11, 0x535F, 0x53F1, 0x53FD, 0x53E9, 0x53E8,
  0x53FB, 0x5412, 0x5416, 0x5406, 0x544B, 0x5452, 0x5453, 0x5454,
  0x5456, 0x5443, 0x5421, 0x5457, 0x5459, 0x5423, 0x5432, 0x5482,
  0x5494, 0x5477, 0x5471, 0x5464, 0x549A, 0x549B, 0x5484, 0x5476,
  0x5466, 0x549D, 0x54D0, 0x54AD, 0x54C2, 0x54B4, 0x54D2, 0x54A7,
  0x54A6, 0x54D3, 0x54D4, 0x5472, 0x54A3, 0x54D5, 0x54BB, 0x54BF,
  0x54CC, 0x54D9, 0x54DA, 0x54DC, 0x54A9, 0x54AA, 0x54A4, 0x54DD,
  0x54CF, 0x54DE, 0x551B, 0x54E7, 0x5520, 0x54FD, 0x5514, 0x54F3,
  0x5522, 0x5523, 0x550F, 0x5511, 0x5527, 0x552A, 0x5567, 0x558F,
  0x55B5, 0x5549, 0x556D, 0x5541, 0x5555, 0x553F, 0x5550, 0x553C,
  0x5537, 0x5556, 0x5575, 0x5576, 0x5577, 0x5533, 0x5530, 0x555C,
  0x558B, 0x55D2, 0x5583, 0x55B1, 0x55B9, 0x5588, 0x5581, 0x559F,
  0x557E, 0x55D6, 0x5591, 0x557B, 0x55DF, 0x55BD, 0x55BE, 0x5594,
  0x5599, 0x55EA, 0x55F7, 0x55C9, 0x561F, 0x55D1, 0x55EB, 0x55EC,
  0x55D4, 0x55E6, 0x55DD, 0x55C4, 0x55EF, 0x55E5, 0x55F2, 0x55F3,
  0x55CC, 0x55CD, 0x55E8, 0x55F5, 0x55E4, 0x8F94, 0x561E, 0x5608,
  0x560C, 0x5601, 0x5624, 0x5623, 0x55FE, 0x5600, 0x5627, 0x562D,
  0x5658, 0x5639, 0x5657, 0x562C, 0x564D, 0x5662, 0x5659, 0x565C,
  0x564C, 0x5654, 0x5686, 0x5664, 0x5671, 0x566B, 0x567B, 0x567C,
  0x5685, 0x5693, 0x56AF, 0x56D4, 0x56D7, 0x56DD, 0x56E1, 0x56F5,
  0x56EB, 0x56F9, 0x56FF, 0x5704, 0x570A, 0x5709, 0x571C, 0x5E0F,
  0x5E19, 0x5E14, 0x5E11, 0x5E31, 0x5E3B, 0x5E3C, 0x5E37, 0x5E44,
  0x5E54, 0x5E5B, 0x5E5E, 0x5E61, 0x5C8C, 0x5C7A, 0x5C8D, 0x5C90,
  0x5C96, 0x5C88, 0x5C98, 0x5C99, 0x5C91, 0x5C9A, 0x5C9C, 0x5CB5,
  0x5CA2, 0x5CBD, 0x5CAC, 0x5CAB, 0x5CB1, 0x5CA3, 0x5CC1, 0x5CB7,
  0x5CC4, 0x5CD2, 0x5CE4, 0x5CCB, 0x5CE5, 0x5D02, 0x5D03, 0x5D27,
  0x5D26, 0x5D2E, 0x5D24, 0x5D1E, 0x5D06, 0x5D1B, 0x5D58, 0x5D3E,
  0x5D34, 0x5D3D, 0x5D6C, 0x5D5B, 0x5D6F, 0x5D5D, 0x5D6B, 0x5D4B,
  0x5D4A, 0x5D69, 0x5D74, 0x5D82, 0x5D99, 0x5D9D, 0x8C73, 0x5DB7,
  0x5DC5, 0x5F73, 0x5F77, 0x5F82, 0x5F87, 0x5F89, 0x5F8C, 0x5F95,
  0x5F99, 0x5F9C, 0x5FA8, 0x5FAD, 0x5FB5, 0x5FBC, 0x8862, 0x5F61,
  0x72AD, 0x72B0, 0x72B4, 0x72B7, 0x72B8, 0x72C3, 0x72C1, 0x72CE,
  0x72CD, 0x72D2, 0x72E8, 0x72EF, 0x72E9, 0x72F2, 0x72F4, 0x72F7,
  0x7301, 0x72F3, 0x7303, 0x72FA, 0x72FB, 0x7317, 0x7313, 0x7321,
  0x730A, 0x731E, 0x731D, 0x7315, 0x7322, 0x7339, 0x7325, 0x732C,
  0x7338, 0x7331, 0x7350, 0x734D, 0x7357, 0x7360, 0x736C, 0x736F,
  0x737E, 0x821B, 0x5925, 0x98E7, 0x5924, 0x5902, 0x9963, 0x9967,
  0x9968, 0x9969, 0x996A, 0x996B, 0x996C, 0x9974, 0x9977, 0x997D,
  0x9980, 0x9984, 0x9987, 0x998A, 0x998D, 0x9990, 0x9991, 0x9993,
  0x9994, 0x9995, 0x5E80, 0x5E91, 0x5E8B, 0x5E96, 0x5EA5, 0x5EA0,
  0x5EB9, 0x5EB5, 0x5EBE, 0x5EB3, 0x8D53, 0x5ED2, 0x5ED1, 0x5EDB,
  0x5EE8, 0x5EEA, 0x81BA, 0x5FC4, 0x5FC9, 0x5FD6, 0x5FCF, 0x6003,
  0x5FEE, 0x6004, 0x5FE1, 0x5FE4, 0x5FFE, 0x6005, 0x6006, 0x5FEA,
  0x5FED, 0x5FF8, 0x6019, 0x6035, 0x6026, 0x601B, 0x600F, 0x600D,
  0x6029, 0x602B, 0x600A, 0x603F, 0x6021, 0x6078, 0x6079, 0x607B,
  0x607A, 0x6042, 0x606A, 0x607D, 0x6096, 0x609A, 0x60AD, 0x609D,
  0x6083, 0x6092, 0x608C, 0x609B, 0x60EC, 0x60BB, 0x60B1, 0x60DD,
  0x60D8, 0x60C6, 0x60DA, 0x60B4, 0x6120, 0x6126, 0x6115, 0x6123,
  0x60F4, 0x6100, 0x610E, 0x612B, 0x614A, 0x6175, 0x61AC, 0x6194,
  0x61A7, 0x61B7, 0x61D4, 0x61F5, 0x5FDD, 0x96B3, 0x95E9, 0x95EB,
  0x95F1, 0x95F3, 0x95F5, 0x95F6, 0x95FC, 0x95FE, 0x9603, 0x9604,
  0x9606, 0x9608, 0x960A, 0x960B, 0x960C, 0x960D, 0x960F, 0x9612,
  0x9615, 0x9616, 0x9617, 0x9619, 0x961A, 0x4E2C, 0x723F, 0x6215,
  0x6C35, 0x6C54, 0x6C5C, 0x6C4A, 0x6CA3, 0x6C85, 0x6C90, 0x6C94,
  0x6C8C, 0x6C68, 0x6C69, 0x6C74, 0x6C76, 0x6C86, 0x6CA9, 0x6CD0,
  0x6CD4, 0x6CAD, 0x6CF7, 0x6CF8, 0x6CF1, 0x6CD7, 0x6CB2, 0x6CE0,
  0x6CD6, 0x6CFA, 0x6CEB, 0x6CEE, 0x6CB1, 0x6CD3, 0x6CEF, 0x6CFE,
  0x6D39, 0x6D27, 0x6D0C, 0x6D43, 0x6D48, 0x6D07, 0x6D04, 0x6D19,
  0x6D0E, 0x6D2B, 0x6D4D, 0x6D2E, 0x6D35, 0x6D1A, 0x6D4F, 0x6D52,
  0x6D54, 0x6D33, 0x6D91, 0x6D6F, 0x6D9E, 0x6DA0, 0x6D5E, 0x6D93,
  0x6D94, 0x6D5C, 0x6D60, 0x6D7C, 0x6D63, 0x6E1A, 0x6DC7, 0x6DC5,
  0x6DDE, 0x6E0E, 0x6DBF, 0x6DE0, 0x6E11, 0x6DE6, 0x6DDD, 0x6DD9,
  0x6E16, 0x6DAB, 0x6E0C, 0x6DAE, 0x6E2B, 0x6E6E, 0x6E4E, 0x6E6B,
  0x6EB2, 0x6E5F, 0x6E86, 0x6E53, 0x6E54, 0x6E32, 0x6E25, 0x6E44,
  0x6EDF, 0x6EB1, 0x6E98, 0x6EE0, 0x6F2D, 0x6EE2, 0x6EA5, 0x6EA7,
  0x6EBD, 0x6EBB, 0x6EB7, 0x6ED7, 0x6EB4, 0x6ECF, 0x6E8F, 0x6EC2,
  0x6E9F, 0x6F62, 0x6F46, 0x6F47, 0x6F24, 0x6F15, 0x6EF9, 0x6F2F,
  0x6F36, 0x6F4B, 0x6F74, 0x6F2A, 0x6F09, 0x6F29, 0x6F89, 0x6F8D,
  0x6F8C, 0x6F78, 0x6F72, 0x6F7C, 0x6F7A, 0x6FD1, 0x6FC9, 0x6FA7,
  0x6FB9, 0x6FB6, 0x6FC2, 0x6FE1, 0x6FEE, 0x6FDE, 0x6FE0, 0x6FEF,
  0x701A, 0x7023, 0x701B, 0x7039, 0x7035, 0x704F, 0x705E, 0x5B80,
  0x5B84, 0x5B95, 0x5B93, 0x5BA5, 0x5BB8, 0x752F, 0x9A9E, 0x6434,
  0x5BE4, 0x5BEE, 0x8930, 0x5BF0, 0x8E47, 0x8B07, 0x8FB6, 0x8FD3,
  0x8FD5, 0x8FE5, 0x8FEE, 0x8FE4, 0x8FE9, 0x8FE6, 0x8FF3, 0x8FE8,
  0x9005, 0x9004, 0x900B, 0x9026, 0x9011, 0x900D, 0x9016, 0x9021,
  0x9035, 0x9036, 0x902D, 0x902F, 0x9044, 0x9051, 0x9052, 0x9050,
  0x9068, 0x9058, 0x9062, 0x905B, 0x66B9, 0x9074, 0x907D, 0x9082,
  0x9088, 0x9083, 0x908B, 0x5F50, 0x5F57, 0x5F56, 0x5F58, 0x5C3B,
  0x54AB, 0x5C50, 0x5C59, 0x5B71, 0x5C63, 0x5C66, 0x7FBC, 0x5F2A,
  0x5F29, 0x5F2D, 0x8274, 0x5F3C, 0x9B3B, 0x5C6E, 0x5981, 0x5983,
  0x598D, 0x59A9, 0x59AA, 0x59A3, 0x5997, 0x59CA, 0x59AB, 0x599E,
  0x59A4, 0x59D2, 0x59B2, 0x59AF, 0x59D7, 0x59BE, 0x5A05, 0x5A06,
  0x59DD, 0x5A08, 0x59E3, 0x59D8, 0x59F9, 0x5A0C, 0x5A09, 0x5A32,
  0x5A34, 0x5A11, 0x5A23, 0x5A13, 0x5A40, 0x5A67, 0x5A4A, 0x5A55,
  0x5A3C, 0x5A62, 0x5A75, 0x80EC, 0x5AAA, 0x5A9B, 0x5A77, 0x5A7A,
  0x5ABE, 0x5AEB, 0x5AB2, 0x5AD2, 0x5AD4, 0x5AB8, 0x5AE0, 0x5AE3,
  0x5AF1, 0x5AD6, 0x5AE6, 0x5AD8, 0x5ADC, 0x5B09, 0x5B17, 0x5B16,
  0x5B32, 0x5B37, 0x5B40, 0x5C15, 0x5C1C, 0x5B5A, 0x5B65, 0x5B73,
  0x5B51, 0x5B53, 0x5B62, 0x9A75, 0x9A77, 0x9A78, 0x9A7A, 0x9A7F,
  0x9A7D, 0x9A80, 0x9A81, 0x9A85, 0x9A88, 0x9A8A, 0x9A90, 0x9A92,
  0x9A93, 0x9A96, 0x9A98, 0x9A9B, 0x9A9C, 0x9A9D, 0x9A9F, 0x9AA0,
  0x9AA2, 0x9AA3, 0x9AA5, 0x9AA7, 0x7E9F, 0x7EA1, 0x7EA3, 0x7EA5,
  0x7EA8, 0x7EA9, 0x7EAD, 0x7EB0, 0x7EBE, 0x7EC0, 0x7EC1, 0x7EC2,
  0x7EC9, 0x7ECB, 0x7ECC, 0x7ED0, 0x7ED4, 0x7ED7, 0x7EDB, 0x7EE0,
  0x7EE1, 0x7EE8, 0x7EEB, 0x7EEE, 0x7EEF, 0x7EF1, 0x7EF2, 0x7F0D,
  0x7EF6, 0x7EFA, 0x7EFB, 0x7EFE, 0x7F01, 0x7F02, 0x7F03, 0x7F07,
  0x7F08, 0x7F0B, 0x7F0C, 0x7F0F, 0x7F11, 0x7F12, 0x7F17, 0x7F19,
  0x7F1C, 0x7F1B, 0x7F1F, 0x7F21, 0x7F22, 0x7F23, 0x7F24, 0x7F25,
  0x7F26, 0x7F27, 0x7F2A, 0x7F2B, 0x7F2C, 0x7F2D, 0x7F2F, 0x7F30,
  0x7F31, 0x7F32, 0x7F33, 0x7F35, 0x5E7A, 0x757F, 0x5DDB, 0x753E,
  0x9095, 0x738E, 0x7391, 0x73AE, 0x73A2, 0x739F, 0x73CF, 0x73C2,
  0x73D1, 0x73B7, 0x73B3, 0x73C0, 0x73C9, 0x73C8, 0x73E5, 0x73D9,
  0x987C, 0x740A, 0x73E9, 0x73E7, 0x73DE, 0x73BA, 0x73F2, 0x740F,
  0x742A, 0x745B, 0x7426, 0x7425, 0x7428, 0x7430, 0x742E, 0x742C,
  0x741B, 0x741A, 0x7441, 0x745C, 0x7457, 0x7455, 0x7459, 0x7477,
  0x746D, 0x747E, 0x749C, 0x748E, 0x7480, 0x7481, 0x7487, 0x748B,
  0x749E, 0x74A8, 0x74A9, 0x7490, 0x74A7, 0x74D2, 0x74BA, 0x97EA,
  0x97EB, 0x97EC, 0x674C, 0x6753, 0x675E, 0x6748, 0x6769, 0x67A5,
  0x6787, 0x676A, 0x6773, 0x6798, 0x67A7, 0x6775, 0x67A8, 0x679E,
  0x67AD, 0x678B, 0x6777, 0x677C, 0x67F0, 0x6809, 0x67D8, 0x680A,
  0x67E9, 0x67B0, 0x680C, 0x67D9, 0x67B5, 0x67DA, 0x67B3, 0x67DD,
  0x6800, 0x67C3, 0x67B8, 0x67E2, 0x680E, 0x67C1, 0x67FD, 0x6832,
  0x6833, 0x6860, 0x6861, 0x684E, 0x6862, 0x6844, 0x6864, 0x6883,
  0x681D, 0x6855, 0x6866, 0x6841, 0x6867, 0x6840, 0x683E, 0x684A,
  0x6849, 0x6829, 0x68B5, 0x688F, 0x6874, 0x6877, 0x6893, 0x686B,
  0x68C2, 0x696E, 0x68FC, 0x691F, 0x6920, 0x68F9, 0x6924, 0x68F0,
  0x690B, 0x6901, 0x6957, 0x68E3, 0x6910, 0x6971, 0x6939, 0x6960,
  0x6942, 0x695D, 0x6984, 0x696B, 0x6980, 0x6998, 0x6978, 0x6934,
  0x69CC, 0x6987, 0x6988, 0x69CE, 0x6989, 0x6966, 0x6963, 0x6979,
  0x699B, 0x69A7, 0x69BB, 0x69AB, 0x69AD, 0x69D4, 0x69B1, 0x69C1,
  0x69CA, 0x69DF, 0x6995, 0x69E0, 0x698D, 0x69FF, 0x6A2F, 0x69ED,
  0x6A17, 0x6A18, 0x6A65, 0x69F2, 0x6A44, 0x6A3E, 0x6AA0, 0x6A50,
  0x6A5B, 0x6A35, 0x6A8E, 0x6A79, 0x6A3D, 0x6A28, 0x6A58, 0x6A7C,
  0x6A91, 0x6A90, 0x6AA9, 0x6A97, 0x6AAB, 0x7337, 0x7352, 0x6B81,
  0x6B82, 0x6B87, 0x6B84, 0x6B92, 0x6B93, 0x6B8D, 0x6B9A, 0x6B9B,
  0x6BA1, 0x6BAA, 0x8F6B, 0x8F6D, 0x8F71, 0x8F72, 0x8F73, 0x8F75,
  0x8F76, 0x8F78, 0x8F77, 0x8F79, 0x8F7A, 0x8F7C, 0x8F7E, 0x8F81,
  0x8F82, 0x8F84, 0x8F87, 0x8F8B, 0x8F8D, 0x8F8E, 0x8F8F, 0x8F98,
  0x8F9A, 0x8ECE, 0x620B, 0x6217, 0x621B, 0x621F, 0x6222, 0x6221,
  0x6225, 0x6224, 0x622C, 0x81E7, 0x74EF, 0x74F4, 0x74FF, 0x750F,
  0x7511, 0x7513, 0x6534, 0x65EE, 0x65EF, 0x65F0, 0x660A, 0x6619,
  0x6772, 0x6603, 0x6615, 0x6600, 0x7085, 0x66F7, 0x661D, 0x6634,
  0x6631, 0x6636, 0x6635, 0x8006, 0x665F, 0x6654, 0x6641, 0x664F,
  0x6656, 0x6661, 0x6657, 0x6677, 0x6684, 0x668C, 0x66A7, 0x669D,
  0x66BE, 0x66DB, 0x66DC, 0x66E6, 0x66E9, 0x8D32, 0x8D33, 0x8D36,
  0x8D3B, 0x8D3D, 0x8D40, 0x8D45, 0x8D46, 0x8D48, 0x8D49, 0x8D47,
  0x8D4D, 0x8D55, 0x8D59, 0x89C7, 0x89CA, 0x89CB, 0x89CC, 0x89CE,
  0x89CF, 0x89D0, 0x89D1, 0x726E, 0x729F, 0x725D, 0x7266, 0x726F,
  0x727E, 0x727F, 0x7284, 0x728B, 0x728D, 0x728F, 0x7292, 0x6308,
  0x6332, 0x63B0, 0x643F, 0x64D8, 0x8004, 0x6BEA, 0x6BF3, 0x6BFD,
  0x6BF5, 0x6BF9, 0x6C05, 0x6C07, 0x6C06, 0x6C0D, 0x6C15, 0x6C18,
  0x6C19, 0x6C1A, 0x6C21, 0x6C29, 0x6C24, 0x6C2A, 0x6C32, 0x6535,
  0x6555, 0x656B, 0x724D, 0x7252, 0x7256, 0x7230, 0x8662, 0x5216,
  0x809F, 0x809C, 0x8093, 0x80BC, 0x670A, 0x80BD, 0x80B1, 0x80AB,
  0x80AD, 0x80B4, 0x80B7, 0x80E7, 0x80E8, 0x80E9, 0x80EA, 0x80DB,
  0x80C2, 0x80C4, 0x80D9, 0x80CD, 0x80D7, 0x6710, 0x80DD, 0x80EB,
  0x80F1, 0x80F4, 0x80ED, 0x810D, 0x810E, 0x80F2, 0x80FC, 0x6715,
  0x8112, 0x8C5A, 0x8136, 0x811E, 0x812C, 0x8118, 0x8132, 0x8148,
  0x814C, 0x8153, 0x8174, 0x8159, 0x815A, 0x8171, 0x8160, 0x8169,
  0x817C, 0x817D, 0x816D, 0x8167, 0x584D, 0x5AB5, 0x8188, 0x8182,
  0x8191, 0x6ED5, 0x81A3, 0x81AA, 0x81CC, 0x6726, 0x81CA, 0x81BB,
  0x81C1, 0x81A6, 0x6B24, 0x6B37, 0x6B39, 0x6B43, 0x6B46, 0x6B59,
  0x98D1, 0x98D2, 0x98D3, 0x98D5, 0x98D9, 0x98DA, 0x6BB3, 0x5F40,
  0x6BC2, 0x89F3, 0x6590, 0x9F51, 0x6593, 0x65BC, 0x65C6, 0x65C4,
  0x65C3, 0x65CC, 0x65CE, 0x65D2, 0x65D6, 0x7080, 0x709C, 0x7096,
  0x709D, 0x70BB, 0x70C0, 0x70B7, 0x70AB, 0x70B1, 0x70E8, 0x70CA,
  0x7110, 0x7113, 0x7116, 0x712F, 0x7131, 0x7173, 0x715C, 0x7168,
  0x7145, 0x7172, 0x714A, 0x7178, 0x717A, 0x7198, 0x71B3, 0x71B5,
  0x71A8, 0x71A0, 0x71E0, 0x71D4, 0x71E7, 0x71F9, 0x721D, 0x7228,
  0x706C, 0x7118, 0x7166, 0x71B9, 0x623E, 0x623D, 0x6243, 0x6248,
  0x6249, 0x793B, 0x7940, 0x7946, 0x7949, 0x795B, 0x795C, 0x7953,
  0x795A, 0x7962, 0x7957, 0x7960, 0x796F, 0x7967, 0x797A, 0x7985,
  0x798A, 0x799A, 0x79A7, 0x79B3, 0x5FD1, 0x5FD0, 0x603C, 0x605D,
  0x605A, 0x6067, 0x6041, 0x6059, 0x6063, 0x60AB, 0x6106, 0x610D,
  0x615D, 0x61A9, 0x619D, 0x61CB, 0x61D1, 0x6206, 0x8080, 0x807F,
  0x6C93, 0x6CF6, 0x6DFC, 0x77F6, 0x77F8, 0x7800, 0x7809, 0x7817,
  0x7818, 0x7811, 0x65AB, 0x782D, 0x781C, 0x781D, 0x7839, 0x783A,
  0x783B, 0x781F, 0x783C, 0x7825, 0x782C, 0x7823, 0x7829, 0x784E,
  0x786D, 0x7856, 0x7857, 0x7826, 0x7850, 0x7847, 0x784C, 0x786A,
  0x789B, 0x7893, 0x789A, 0x7887, 0x789C, 0x78A1, 0x78A3, 0x78B2,
  0x78B9, 0x78A5, 0x78D4, 0x78D9, 0x78C9, 0x78EC, 0x78F2, 0x7905,
  0x78F4, 0x7913, 0x7924, 0x791E, 0x7934, 0x9F9B, 0x9EF9, 0x9EFB,
  0x9EFC, 0x76F1, 0x7704, 0x770D, 0x76F9, 0x7707, 0x7708, 0x771A,
  0x7722, 0x7719, 0x772D, 0x7726, 0x7735, 0x7738, 0x7750, 0x7751,
  0x7747, 0x7743, 0x775A, 0x7768, 0x7762, 0x7765, 0x777F, 0x778D,
  0x777D, 0x7780, 0x778C, 0x7791, 0x779F, 0x77A0, 0x77B0, 0x77B5,
  0x77BD, 0x753A, 0x7540, 0x754E, 0x754B, 0x7548, 0x755B, 0x7572,
  0x7579, 0x7583, 0x7F58, 0x7F61, 0x7F5F, 0x8A48, 0x7F68, 0x7F74,
  0x7F71, 0x7F79, 0x7F81, 0x7F7E, 0x76CD, 0x76E5, 0x8832, 0x9485,
  0x9486, 0x9487, 0x948B, 0x948A, 0x948C, 0x948D, 0x948F, 0x9490,
  0x9494, 0x9497, 0x9495, 0x949A, 0x949B, 0x949C, 0x94A3, 0x94A4,
  0x94AB, 0x94AA, 0x94AD, 0x94AC, 0x94AF, 0x94B0, 0x94B2, 0x94B4,
  0x94B6, 0x94B7, 0x94B8, 0x94B9, 0x94BA, 0x94BC, 0x94BD, 0x94BF,
  0x94C4, 0x94C8, 0x94C9, 0x94CA, 0x94CB, 0x94CC, 0x94CD, 0x94CE,
  0x94D0, 0x94D1, 0x94D2, 0x94D5, 0x94D6, 0x94D7, 0x94D9, 0x94D8,
  0x94DB, 0x94DE, 0x94DF, 0x94E0, 0x94E2, 0x94E4, 0x94E5, 0x94E7,
  0x94E8, 0x94EA, 0x94E9, 0x94EB, 0x94EE, 0x94EF, 0x94F3, 0x94F4,
  0x94F5, 0x94F7, 0x94F9, 0x94FC, 0x94FD, 0x94FF, 0x9503, 0x9502,
  0x9506, 0x9507, 0x9509, 0x950A, 0x950D, 0x950E, 0x950F, 0x9512,
  0x9513, 0x9514, 0x9515, 0x9516, 0x9518, 0x951B, 0x951D, 0x951E,
  0x951F, 0x9522, 0x952A, 0x952B, 0x9529, 0x952C, 0x9531, 0x9532,
  0x9534, 0x9536, 0x9537, 0x9538, 0x953C, 0x953E, 0x953F, 0x9542,
  0x9535, 0x9544, 0x9545, 0x9546, 0x9549, 0x954C, 0x954E, 0x954F,
  0x9552, 0x9553, 0x9554, 0x9556, 0x9557, 0x9558, 0x9559, 0x955B,
  0x955E, 0x955F, 0x955D, 0x9561, 0x9562, 0x9564, 0x9565, 0x9566,
  0x9567, 0x9568, 0x9569, 0x956A, 0x956B, 0x956C, 0x956F, 0x9571,
  0x9572, 0x9573, 0x953A, 0x77E7, 0x77EC, 0x96C9, 0x79D5, 0x79ED,
  0x79E3, 0x79EB, 0x7A06, 0x5D47, 0x7A03, 0x7A02, 0x7A1E, 0x7A14,
  0x7A39, 0x7A37, 0x7A51, 0x9ECF, 0x99A5, 0x7A70, 0x7688, 0x768E,
  0x7693, 0x7699, 0x76A4, 0x74DE, 0x74E0, 0x752C, 0x9E20, 0x9E22,
  0x9E28, 0x9E29, 0x9E2A, 0x9E2B, 0x9E2C, 0x9E32, 0x9E31, 0x9E36,
  0x9E38, 0x9E37, 0x9E39, 0x9E3A, 0x9E3E, 0x9E41, 0x9E42, 0x9E44,
  0x9E46, 0x9E47, 0x9E48, 0x9E49, 0x9E4B, 0x9E4C, 0x9E4E, 0x9E51,
  0x9E55, 0x9E57, 0x9E5A, 0x9E5B, 0x9E5C, 0x9E5E, 0x9E63, 0x9E66,
  0x9E67, 0x9E68, 0x9E69, 0x9E6A, 0x9E6B, 0x9E6C, 0x9E71, 0x9E6D,
  0x9E73, 0x7592, 0x7594, 0x7596, 0x75A0, 0x759D, 0x75AC, 0x75A3,
  0x75B3, 0x75B4, 0x75B8, 0x75C4, 0x75B1, 0x75B0, 0x75C3, 0x75C2,
  0x75D6, 0x75CD, 0x75E3, 0x75E8, 0x75E6, 0x75E4, 0x75EB, 0x75E7,
  0x7603, 0x75F1, 0x75FC, 0x75FF, 0x7610, 0x7600, 0x7605, 0x760C,
  0x7617, 0x760A, 0x7625, 0x7618, 0x7615, 0x7619, 0x761B, 0x763C,
  0x7622, 0x7620, 0x7640, 0x762D, 0x7630, 0x763F, 0x7635, 0x7643,
  0x763E, 0x7633, 0x764D, 0x765E, 0x7654, 0x765C, 0x7656, 0x766B,
  0x766F, 0x7FCA, 0x7AE6, 0x7A78, 0x7A79, 0x7A80, 0x7A86, 0x7A88,
  0x7A95, 0x7AA6, 0x7AA0, 0x7AAC, 0x7AA8, 0x7AAD, 0x7AB3, 0x8864,
  0x8869, 0x8872, 0x887D, 0x887F, 0x8882, 0x88A2, 0x88C6, 0x88B7,
  0x88BC, 0x88C9, 0x88E2, 0x88CE, 0x88E3, 0x88E5, 0x88F1, 0x891A,
  0x88FC, 0x88E8, 0x88FE, 0x88F0, 0x8921, 0x8919, 0x8913, 0x891B,
  0x890A, 0x8934, 0x892B, 0x8936, 0x8941, 0x8966, 0x897B, 0x758B,
  0x80E5, 0x76B2, 0x76B4, 0x77DC, 0x8012, 0x8014, 0x8016, 0x801C,
  0x8020, 0x8022, 0x8025, 0x8026, 0x8027, 0x8029, 0x8028, 0x8031,
  0x800B, 0x8035, 0x8043, 0x8046, 0x804D, 0x8052, 0x8069, 0x8071,
  0x8983, 0x9878, 0x9880, 0x9883, 0x9889, 0x988C, 0x988D, 0x988F,
  0x9894, 0x989A, 0x989B, 0x989E, 0x989F, 0x98A1, 0x98A2, 0x98A5,
  0x98A6, 0x864D, 0x8654, 0x866C, 0x866E, 0x867F, 0x867A, 0x867C,
  0x867B, 0x86A8, 0x868D, 0x868B, 0x86AC, 0x869D, 0x86A7, 0x86A3,
  0x86AA, 0x8693, 0x86A9, 0x86B6, 0x86C4, 0x86B5, 0x86CE, 0x86B0,
  0x86BA, 0x86B1, 0x86AF, 0x86C9, 0x86CF, 0x86B4, 0x86E9, 0x86F1,
  0x86F2, 0x86ED, 0x86F3, 0x86D0, 0x8713, 0x86DE, 0x86F4, 0x86DF,
  0x86D8, 0x86D1, 0x8703, 0x8707, 0x86F8, 0x8708, 0x870A, 0x870D,
  0x8709, 0x8723, 0x873B, 0x871E, 0x8725, 0x872E, 0x871A, 0x873E,
  0x8748, 0x8734, 0x8731, 0x8729, 0x8737, 0x873F, 0x8782, 0x8722,
  0x877D, 0x877E, 0x877B, 0x8760, 0x8770, 0x874C, 0x876E, 0x878B,
  0x8753, 0x8763, 0x877C, 0x8764, 0x8759, 0x8765, 0x8793, 0x87AF,
  0x87A8, 0x87D2, 0x87C6, 0x8788, 0x8785, 0x87AD, 0x8797, 0x8783,
  0x87AB, 0x87E5, 0x87AC, 0x87B5, 0x87B3, 0x87CB, 0x87D3, 0x87BD,
  0x87D1, 0x87C0, 0x87CA, 0x87DB, 0x87EA, 0x87E0, 0x87EE, 0x8816,
  0x8813, 0x87FE, 0x880A, 0x881B, 0x8821, 0x8839, 0x883C, 0x7F36,
  0x7F42, 0x7F44, 0x7F45, 0x8210, 0x7AFA, 0x7AFD, 0x7B08, 0x7B03,
  0x7B04, 0x7B15, 0x7B0A, 0x7B2B, 0x7B0F, 0x7B47, 0x7B38, 0x7B2A,
  0x7B19, 0x7B2E, 0x7B31, 0x7B20, 0x7B25, 0x7B24, 0x7B33, 0x7B3E,
  0x7B1E, 0x7B58, 0x7B5A, 0x7B45, 0x7B75, 0x7B4C, 0x7B5D, 0x7B60,
  0x7B6E, 0x7B7B, 0x7B62, 0x7B72, 0x7B71, 0x7B90, 0x7BA6, 0x7BA7,
  0x7BB8, 0x7BAC, 0x7B9D, 0x7BA8, 0x7B85, 0x7BAA, 0x7B9C, 0x7BA2,
  0x7BAB, 0x7BB4, 0x7BD1, 0x7BC1, 0x7BCC, 0x7BDD, 0x7BDA, 0x7BE5,
  0x7BE6, 0x7BEA, 0x7C0C, 0x7BFE, 0x7BFC, 0x7C0F, 0x7C16, 0x7C0B,
  0x7C1F, 0x7C2A, 0x7C26, 0x7C38, 0x7C41, 0x7C40, 0x81FE, 0x8201,
  0x8202, 0x8204, 0x81EC, 0x8844, 0x8221, 0x8222, 0x8223, 0x822D,
  0x822F, 0x8228, 0x822B, 0x8238, 0x823B, 0x8233, 0x8234, 0x823E,
  0x8244, 0x8249, 0x824B, 0x824F, 0x825A, 0x825F, 0x8268, 0x887E,
  0x8885, 0x8888, 0x88D8, 0x88DF, 0x895E, 0x7F9D, 0x7F9F, 0x7FA7,
  0x7FAF, 0x7FB0, 0x7FB2, 0x7C7C, 0x6549, 0x7C91, 0x7C9D, 0x7C9C,
  0x7C9E, 0x7CA2, 0x7CB2, 0x7CBC, 0x7CBD, 0x7CC1, 0x7CC7, 0x7CCC,
  0x7CCD, 0x7CC8, 0x7CC5, 0x7CD7, 0x7CE8, 0x826E, 0x66A8, 0x7FBF,
  0x7FCE, 0x7FD5, 0x7FE5, 0x7FE1, 0x7FE6, 0x7FE9, 0x7FEE, 0x7FF3,
  0x7CF8, 0x7D77, 0x7DA6, 0x7DAE, 0x7E47, 0x7E9B, 0x9EB8, 0x9EB4,
  0x8D73, 0x8D84, 0x8D94, 0x8D91, 0x8DB1, 0x8D67, 0x8D6D, 0x8C47,
  0x8C49, 0x914A, 0x9150, 0x914E, 0x914F, 0x9164, 0x9162, 0x9161,
  0x9170, 0x9169, 0x916F, 0x917D, 0x917E, 0x9172, 0x9174, 0x9179,
  0x918C, 0x9185, 0x9190, 0x918D, 0x9191, 0x91A2, 0x91A3, 0x91AA,
  0x91AD, 0x91AE, 0x91AF, 0x91B5, 0x91B4, 0x91BA, 0x8C55, 0x9E7E,
  0x8DB8, 0x8DEB, 0x8E05, 0x8E59, 0x8E69, 0x8DB5, 0x8DBF, 0x8DBC,
  0x8DBA, 0x8DC4, 0x8DD6, 0x8DD7, 0x8DDA, 0x8DDE, 0x8DCE, 0x8DCF,
  0x8DDB, 0x8DC6, 0x8DEC, 0x8DF7, 0x8DF8, 0x8DE3, 0x8DF9, 0x8DFB,
  0x8DE4, 0x8E09, 0x8DFD, 0x8E14, 0x8E1D, 0x8E1F, 0x8E2C, 0x8E2E,
  0x8E23, 0x8E2F, 0x8E3A, 0x8E40, 0x8E39, 0x8E35, 0x8E3D, 0x8E31,
  0x8E49, 0x8E41, 0x8E42, 0x8E51, 0x8E52, 0x8E4A, 0x8E70, 0x8E76,
  0x8E7C, 0x8E6F, 0x8E74, 0x8E85, 0x8E8F, 0x8E94, 0x8E90, 0x8E9C,
  0x8E9E, 0x8C78, 0x8C82, 0x8C8A, 0x8C85, 0x8C98, 0x8C94, 0x659B,
  0x89D6, 0x89DE, 0x89DA, 0x89DC, 0x89E5, 0x89EB, 0x89EF, 0x8A3E,
  0x8B26, 0x9753, 0x96E9, 0x96F3, 0x96EF, 0x9706, 0x9701, 0x9708,
  0x970F, 0x970E, 0x972A, 0x972D, 0x9730, 0x973E, 0x9F80, 0x9F83,
  0x9F85, 0x9F86, 0x9F87, 0x9F88, 0x9F89, 0x9F8A, 0x9F8C, 0x9EFE,
  0x9F0B, 0x9F0D, 0x96B9, 0x96BC, 0x96BD, 0x96CE, 0x96D2, 0x77BF,
  0x96E0, 0x928E, 0x92AE, 0x92C8, 0x933E, 0x936A, 0x93CA, 0x938F,
  0x943E, 0x946B, 0x9C7F, 0x9C82, 0x9C85, 0x9C86, 0x9C87, 0x9C88,
  0x7A23, 0x9C8B, 0x9C8E, 0x9C90, 0x9C91, 0x9C92, 0x9C94, 0x9C95,
  0x9C9A, 0x9C9B, 0x9C9E, 0x9C9F, 0x9CA0, 0x9CA1, 0x9CA2, 0x9CA3,
  0x9CA5, 0x9CA6, 0x9CA7, 0x9CA8, 0x9CA9, 0x9CAB, 0x9CAD, 0x9CAE,
  0x9CB0, 0x9CB1, 0x9CB2, 0x9CB3, 0x9CB4, 0x9CB5, 0x9CB6, 0x9CB7,
  0x9CBA, 0x9CBB, 0x9CBC, 0x9CBD, 0x9CC4, 0x9CC5, 0x9CC6, 0x9CC7,
  0x9CCA, 0x9CCB, 0x9CCC, 0x9CCD, 0x9CCE, 0x9CCF, 0x9CD0, 0x9CD3,
  0x9CD4, 0x9CD5, 0x9CD7, 0x9CD8, 0x9CD9, 0x9CDC, 0x9CDD, 0x9CDF,
  0x9CE2, 0x977C, 0x9785, 0x9791, 0x9792, 0x9794, 0x97AF, 0x97AB,
  0x97A3, 0x97B2, 0x97B4, 0x9AB1, 0x9AB0, 0x9AB7, 0x9E58, 0x9AB6,
  0x9ABA, 0x9ABC, 0x9AC1, 0x9AC0, 0x9AC5, 0x9AC2, 0x9ACB, 0x9ACC,
  0x9AD1, 0x9B45, 0x9B43, 0x9B47, 0x9B49, 0x9B48, 0x9B4D, 0x9B51,
  0x98E8, 0x990D, 0x992E, 0x9955, 0x9954, 0x9ADF, 0x9AE1, 0x9AE6,
  0x9AEF, 0x9AEB, 0x9AFB, 0x9AED, 0x9AF9, 0x9B08, 0x9B0F, 0x9B13,
  0x9B1F, 0x9B23, 0x9EBD, 0x9EBE, 0x7E3B, 0x9E82, 0x9E87, 0x9E88,
  0x9E8B, 0x9E92, 0x93D6, 0x9E9D, 0x9E9F, 0x9EDB, 0x9EDC, 0x9EDD,
  0x9EE0, 0x9EDF, 0x9EE2, 0x9EE9, 0x9EE7, 0x9EE5, 0x9EEA, 0x9EEF,
  0x9F22, 0x9F2C, 0x9F2F, 0x9F39, 0x9F37, 0x9F3D, 0x9F3E, 0x9F44,
  // [   160,   161] -v # seg 6 at pos 6862
  0x20AC, 0xE76D,
  // [   186,   191] -v # seg 10 at pos 6864
  0xE770, 0xE771, 0xFF01, 0xFF02, 0xFF03, 0xFFE5,
  // [   365,   375] -> [0xE772,0xE77C] # seg 14
  // [   487,   501] -v # seg 18 at pos 6870
  0x03A3, 0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9, 0xE785,
  0xE786, 0xE787, 0xE788, 0xE789, 0xE78A, 0xE78B, 0xE78C,
  // [   519,   554] -v # seg 20 at pos 6885
  0x03C3, 0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9, 0xE78D,
  0xE78E, 0xE78F, 0xE790, 0xE791, 0xE792, 0xE793, 0xFE35, 0xFE36,
  0xFE39, 0xFE3A, 0xFE3F, 0xFE40, 0xFE3D, 0xFE3E, 0xFE41, 0xFE42,
  0xFE43, 0xFE44, 0xE794, 0xE795, 0xFE3B, 0xFE3C, 0xFE37, 0xFE38,
  0xFE31, 0xE796, 0xFE33, 0xFE34,
  // [   555,   563] -> [0xE797,0xE79F] # seg 21
  // [   564,   570] -v # seg 22 at pos 6921
  0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401,
  // [   571,   596] -> [0x0416,0x042F] # seg 23
  // [   597,   611] -> [0xE7A0,0xE7AE] # seg 24
  // [   612,   618] -v # seg 25 at pos 6928
  0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451,
  // [   619,   644] -> [0x0436,0x044F] # seg 26
  // [   645,   657] -> [0xE7AF,0xE7BB] # seg 27
  // [   658,   693] -v # seg 28 at pos 6935
  0x0101, 0x00E1, 0x01CE, 0x00E0, 0x0113, 0x00E9, 0x011B, 0x00E8,
  0x012B, 0x00ED, 0x01D0, 0x00EC, 0x014D, 0x00F3, 0x01D2, 0x00F2,
  0x016B, 0x00FA, 0x01D4, 0x00F9, 0x01D6, 0x01D8, 0x01DA, 0x01DC,
  0x00FC, 0x00EA, 0x0251, 0xE7C7, 0x0144, 0x0148, 0x01F9, 0x0261,
  0xE7C9, 0xE7CA, 0xE7CB, 0xE7CC,
  // [   694,   730] -> [0x3105,0x3129] # seg 29
  // [   731,   751] -> [0xE7CD,0xE7E1] # seg 30
  // [   755,   830] -> [0x2500,0x254B] # seg 32
  // [   846,  1409] -> [0xE000,0xE233] # seg 34
  // [  8178,  8835] -> [0xE234,0xE4C5] # seg 36
  // [  8836,  8879] -v # seg 37 at pos 6971
  0x4E02, 0x4E04, 0x4E05, 0x4E06, 0x4E0F, 0x4E12, 0x4E17, 0x4E1F,
  0x4E20, 0x4E21, 0x4E23, 0x4E26, 0x4E29, 0x4E2E, 0x4E2F, 0x4E31,
  0x4E33, 0x4E35, 0x4E37, 0x4E3C, 0x4E40, 0x4E41, 0x4E42, 0x4E44,
  0x4E46, 0x4E4A, 0x4E51, 0x4E55, 0x4E57, 0x4E5A, 0x4E5B, 0x4E62,
  0x4E63, 0x4E64, 0x4E65, 0x4E67, 0x4E68, 0x4E6A, 0x4E6B, 0x4E6C,
  0x4E6D, 0x4E6E, 0x4E6F, 0x4E72,
  // [  8880,  8889] -> [0x4E74,0x4E7D] # seg 38
  // [  8890,  9033] -v # seg 39 at pos 7015
  0x4E7F, 0x4E80, 0x4E81, 0x4E82, 0x4E83, 0x4E84, 0x4E85, 0x4E87,
  0x4E8A, 0x4E90, 0x4E96, 0x4E97, 0x4E99, 0x4E9C, 0x4E9D, 0x4E9E,
  0x4EA3, 0x4EAA, 0x4EAF, 0x4EB0, 0x4EB1, 0x4EB4, 0x4EB6, 0x4EB7,
  0x4EB8, 0x4EB9, 0x4EBC, 0x4EBD, 0x4EBE, 0x4EC8, 0x4ECC, 0x4ECF,
  0x4ED0, 0x4ED2, 0x4EDA, 0x4EDB, 0x4EDC, 0x4EE0, 0x4EE2, 0x4EE6,
  0x4EE7, 0x4EE9, 0x4EED, 0x4EEE, 0x4EEF, 0x4EF1, 0x4EF4, 0x4EF8,
  0x4EF9, 0x4EFA, 0x4EFC, 0x4EFE, 0x4F00, 0x4F02, 0x4F03, 0x4F04,
  0x4F05, 0x4F06, 0x4F07, 0x4F08, 0x4F0B, 0x4F0C, 0x4F12, 0x4F13,
  0x4F14, 0x4F15, 0x4F16, 0x4F1C, 0x4F1D, 0x4F21, 0x4F23, 0x4F28,
  0x4F29, 0x4F2C, 0x4F2D, 0x4F2E, 0x4F31, 0x4F33, 0x4F35, 0x4F37,
  0x4F39, 0x4F3B, 0x4F3E, 0x4F3F, 0x4F40, 0x4F41, 0x4F42, 0x4F44,
  0x4F45, 0x4F47, 0x4F48, 0x4F49, 0x4F4A, 0x4F4B, 0x4F4C, 0x4F52,
  0x4F54, 0x4F56, 0x4F61, 0x4F62, 0x4F66, 0x4F68, 0x4F6A, 0x4F6B,
  0x4F6D, 0x4F6E, 0x4F71, 0x4F72, 0x4F75, 0x4F77, 0x4F78, 0x4F79,
  0x4F7A, 0x4F7D, 0x4F80, 0x4F81, 0x4F82, 0x4F85, 0x4F86, 0x4F87,
  0x4F8A, 0x4F8C, 0x4F8E, 0x4F90, 0x4F92, 0x4F93, 0x4F95, 0x4F96,
  0x4F98, 0x4F99, 0x4F9A, 0x4F9C, 0x4F9E, 0x4F9F, 0x4FA1, 0x4FA2,
  0x4FA4, 0x4FAB, 0x4FAD, 0x4FB0, 0x4FB1, 0x4FB2, 0x4FB3, 0x4FB4,
  // [  9034,  9042] -> [0x4FB6,0x4FBE] # seg 40
  // [  9043,  9076] -v # seg 41 at pos 7159
  0x4FC0, 0x4FC1, 0x4FC2, 0x4FC6, 0x4FC7, 0x4FC8, 0x4FC9, 0x4FCB,
  0x4FCC, 0x4FCD, 0x4FD2, 0x4FD3, 0x4FD4, 0x4FD5, 0x4FD6, 0x4FD9,
  0x4FDB, 0x4FE0, 0x4FE2, 0x4FE4, 0x4FE5, 0x4FE7, 0x4FEB, 0x4FEC,
  0x4FF0, 0x4FF2, 0x4FF4, 0x4FF5, 0x4FF6, 0x4FF7, 0x4FF9, 0x4FFB,
  0x4FFC, 0x4FFD,
  // [  9077,  9089] -> [0x4FFF,0x500B] # seg 42
  // [  9090,  9105] -v # seg 43 at pos 7193
  0x500E, 0x5010, 0x5011, 0x5013, 0x5015, 0x5016, 0x5017, 0x501B,
  0x501D, 0x501E, 0x5020, 0x5022, 0x5023, 0x5024, 0x5027, 0x502B,
  // [  9106,  9116] -> [0x502F,0x5039] # seg 44
  // [  9117,  9153] -v # seg 45 at pos 7209
  0x503B, 0x503D, 0x503F, 0x5040, 0x5041, 0x5042, 0x5044, 0x5045,
  0x5046, 0x5049, 0x504A, 0x504B, 0x504D, 0x5050, 0x5051, 0x5052,
  0x5053, 0x5054, 0x5056, 0x5057, 0x5058, 0x5059, 0x505B, 0x505D,
  0x505E, 0x505F, 0x5060, 0x5061, 0x5062, 0x5063, 0x5064, 0x5066,
  0x5067, 0x5068, 0x5069, 0x506A, 0x506B,
  // [  9154,  9162] -> [0x506D,0x5075] # seg 46
  // [  9163,  9177] -v # seg 47 at pos 7246
  0x5078, 0x5079, 0x507A, 0x507C, 0x507D, 0x5081, 0x5082, 0x5083,
  0x5084, 0x5086, 0x5087, 0x5089, 0x508A, 0x508B, 0x508C,
  // [  9178,  9198] -> [0x508E,0x50A2] # seg 48
  // [  9199,  9214] -v # seg 49 at pos 7261
  0x50A4, 0x50A6, 0x50AA, 0x50AB, 0x50AD, 0x50AE, 0x50AF, 0x50B0,
  0x50B1, 0x50B3, 0x50B4, 0x50B5, 0x50B6, 0x50B7, 0x50B8, 0x50B9,
  // [  9215,  9233] -> [0x50BC,0x50CE] # seg 50
  // [  9234,  9242] -v # seg 51 at pos 7277
  0x50D0, 0x50D1, 0x50D2, 0x50D3, 0x50D4, 0x50D5, 0x50D7, 0x50D8,
  0x50D9,
  // [  9243,  9253] -> [0x50DB,0x50E5] # seg 52
  // [  9254,  9267] -v # seg 53 at pos 7286
  0x50E8, 0x50E9, 0x50EA, 0x50EB, 0x50EF, 0x50F0, 0x50F1, 0x50F2,
  0x50F4, 0x50F6, 0x50F7, 0x50F8, 0x50F9, 0x50FA,
  // [  9268,  9277] -> [0x50FC,0x5105] # seg 54
  // [  9278,  9286] -v # seg 55 at pos 7300
  0x5108, 0x5109, 0x510A, 0x510C, 0x510D, 0x510E, 0x510F, 0x5110,
  0x5111,
  // [  9287,  9300] -> [0x5113,0x5120] # seg 56
  // [  9301,  9329] -> [0x5122,0x513E] # seg 57
  // [  9330,  9399] -v # seg 58 at pos 7309
  0x5142, 0x5147, 0x514A, 0x514C, 0x514E, 0x514F, 0x5150, 0x5152,
  0x5153, 0x5157, 0x5158, 0x5159, 0x515B, 0x515D, 0x515E, 0x515F,
  0x5160, 0x5161, 0x5163, 0x5164, 0x5166, 0x5167, 0x5169, 0x516A,
  0x516F, 0x5172, 0x517A, 0x517E, 0x517F, 0x5183, 0x5184, 0x5186,
  0x5187, 0x518A, 0x518B, 0x518E, 0x518F, 0x5190, 0x5191, 0x5193,
  0x5194, 0x5198, 0x519A, 0x519D, 0x519E, 0x519F, 0x51A1, 0x51A3,
  0x51A6, 0x51A7, 0x51A8, 0x51A9, 0x51AA, 0x51AD, 0x51AE, 0x51B4,
  0x51B8, 0x51B9, 0x51BA, 0x51BE, 0x51BF, 0x51C1, 0x51C2, 0x51C3,
  0x51C5, 0x51C8, 0x51CA, 0x51CD, 0x51CE, 0x51D0,
  // [  9400,  9408] -> [0x51D2,0x51DA] # seg 59
  // [  9409,  9485] -v # seg 60 at pos 7379
  0x51DC, 0x51DE, 0x51DF, 0x51E2, 0x51E3, 0x51E5, 0x51E6, 0x51E7,
  0x51E8, 0x51E9, 0x51EA, 0x51EC, 0x51EE, 0x51F1, 0x51F2, 0x51F4,
  0x51F7, 0x51FE, 0x5204, 0x5205, 0x5209, 0x520B, 0x520C, 0x520F,
  0x5210, 0x5213, 0x5214, 0x5215, 0x521C, 0x521E, 0x521F, 0x5221,
  0x5222, 0x5223, 0x5225, 0x5226, 0x5227, 0x522A, 0x522C, 0x522F,
  0x5231, 0x5232, 0x5234, 0x5235, 0x523C, 0x523E, 0x5244, 0x5245,
  0x5246, 0x5247, 0x5248, 0x5249, 0x524B, 0x524E, 0x524F, 0x5252,
  0x5253, 0x5255, 0x5257, 0x5258, 0x5259, 0x525A, 0x525B, 0x525D,
  0x525F, 0x5260, 0x5262, 0x5263, 0x5264, 0x5266, 0x5268, 0x526B,
  0x526C, 0x526D, 0x526E, 0x5270, 0x5271,
  // [  9486,  9495] -> [0x5273,0x527C] # seg 61
  // [  9496,  9526] -v # seg 62 at pos 7456
  0x527E, 0x5280, 0x5283, 0x5284, 0x5285, 0x5286, 0x5287, 0x5289,
  0x528A, 0x528B, 0x528C, 0x528D, 0x528E, 0x528F, 0x5291, 0x5292,
  0x5294, 0x5295, 0x5296, 0x5297, 0x5298, 0x5299, 0x529A, 0x529C,
  0x52A4, 0x52A5, 0x52A6, 0x52A7, 0x52AE, 0x52AF, 0x52B0,
  // [  9527,  9536] -> [0x52B4,0x52BD] # seg 63
  // [  9537,  9563] -v # seg 64 at pos 7487
  0x52C0, 0x52C1, 0x52C2, 0x52C4, 0x52C5, 0x52C6, 0x52C8, 0x52CA,
  0x52CC, 0x52CD, 0x52CE, 0x52CF, 0x52D1, 0x52D3, 0x52D4, 0x52D5,
  0x52D7, 0x52D9, 0x52DA, 0x52DB, 0x52DC, 0x52DD, 0x52DE, 0x52E0,
  0x52E1, 0x52E2, 0x52E3,
  // [  9564,  9574] -> [0x52E5,0x52EF] # seg 65
  // [  9575,  9582] -> [0x52F1,0x52F8] # seg 66
  // [  9583,  9613] -v # seg 67 at pos 7514
  0x52FB, 0x52FC, 0x52FD, 0x5301, 0x5302, 0x5303, 0x5304, 0x5307,
  0x5309, 0x530A, 0x530B, 0x530C, 0x530E, 0x5311, 0x5312, 0x5313,
  0x5314, 0x5318, 0x531B, 0x531C, 0x531E, 0x531F, 0x5322, 0x5324,
  0x5325, 0x5327, 0x5328, 0x5329, 0x532B, 0x532C, 0x532D,
  // [  9614,  9623] -> [0x532F,0x5338] # seg 68
  // [  9624,  9920] -v # seg 69 at pos 7545
  0x533C, 0x533D, 0x5340, 0x5342, 0x5344, 0x5346, 0x534B, 0x534C,
  0x534D, 0x5350, 0x5354, 0x5358, 0x5359, 0x535B, 0x535D, 0x5365,
  0x5368, 0x536A, 0x536C, 0x536D, 0x5372, 0x5376, 0x5379, 0x537B,
  0x537C, 0x537D, 0x537E, 0x5380, 0x5381, 0x5383, 0x5387, 0x5388,
  0x538A, 0x538E, 0x538F, 0x5390, 0x5391, 0x5392, 0x5393, 0x5394,
  0x5396, 0x5397, 0x5399, 0x539B, 0x539C, 0x539E, 0x53A0, 0x53A1,
  0x53A4, 0x53A7, 0x53AA, 0x53AB, 0x53AC, 0x53AD, 0x53AF, 0x53B0,
  0x53B1, 0x53B2, 0x53B3, 0x53B4, 0x53B5, 0x53B7, 0x53B8, 0x53B9,
  0x53BA, 0x53BC, 0x53BD, 0x53BE, 0x53C0, 0x53C3, 0x53C4, 0x53C5,
  0x53C6, 0x53C7, 0x53CE, 0x53CF, 0x53D0, 0x53D2, 0x53D3, 0x53D5,
  0x53DA, 0x53DC, 0x53DD, 0x53DE, 0x53E1, 0x53E2, 0x53E7, 0x53F4,
  0x53FA, 0x53FE, 0x53FF, 0x5400, 0x5402, 0x5405, 0x5407, 0x540B,
  0x5414, 0x5418, 0x5419, 0x541A, 0x541C, 0x5422, 0x5424, 0x5425,
  0x542A, 0x5430, 0x5433, 0x5436, 0x5437, 0x543A, 0x543D, 0x543F,
  0x5441, 0x5442, 0x5444, 0x5445, 0x5447, 0x5449, 0x544C, 0x544D,
  0x544E, 0x544F, 0x5451, 0x545A, 0x545D, 0x545E, 0x545F, 0x5460,
  0x5461, 0x5463, 0x5465, 0x5467, 0x5469, 0x546A, 0x546B, 0x546C,
  0x546D, 0x546E, 0x546F, 0x5470, 0x5474, 0x5479, 0x547A, 0x547E,
  0x547F, 0x5481, 0x5483, 0x5485, 0x5487, 0x5488, 0x5489, 0x548A,
  0x548D, 0x5491, 0x5493, 0x5497, 0x5498, 0x549C, 0x549E, 0x549F,
  0x54A0, 0x54A1, 0x54A2, 0x54A5, 0x54AE, 0x54B0, 0x54B2, 0x54B5,
  0x54B6, 0x54B7, 0x54B9, 0x54BA, 0x54BC, 0x54BE, 0x54C3, 0x54C5,
  0x54CA, 0x54CB, 0x54D6, 0x54D8, 0x54DB, 0x54E0, 0x54E1, 0x54E2,
  0x54E3, 0x54E4, 0x54EB, 0x54EC, 0x54EF, 0x54F0, 0x54F1, 0x54F4,
  0x54F5, 0x54F6, 0x54F7, 0x54F8, 0x54F9, 0x54FB, 0x54FE, 0x5500,
  0x5502, 0x5503, 0x5504, 0x5505, 0x5508, 0x550A, 0x550B, 0x550C,
  0x550D, 0x550E, 0x5512, 0x5513, 0x5515, 0x5516, 0x5517, 0x5518,
  0x5519, 0x551A, 0x551C, 0x551D, 0x551E, 0x551F, 0x5521, 0x5525,
  0x5526, 0x5528, 0x5529, 0x552B, 0x552D, 0x5532, 0x5534, 0x5535,
  0x5536, 0x5538, 0x5539, 0x553A, 0x553B, 0x553D, 0x5540, 0x5542,
  0x5545, 0x5547, 0x5548, 0x554B, 0x554C, 0x554D, 0x554E, 0x554F,
  0x5551, 0x5552, 0x5553, 0x5554, 0x5557, 0x5558, 0x5559, 0x555A,
  0x555B, 0x555D, 0x555E, 0x555F, 0x5560, 0x5562, 0x5563, 0x5568,
  0x5569, 0x556B, 0x556F, 0x5570, 0x5571, 0x5572, 0x5573, 0x5574,
  0x5579, 0x557A, 0x557D, 0x557F, 0x5585, 0x5586, 0x558C, 0x558D,
  0x558E, 0x5590, 0x5592, 0x5593, 0x5595, 0x5596, 0x5597, 0x559A,
  0x559B, 0x559E, 0x55A0, 0x55A1, 0x55A2, 0x55A3, 0x55A4, 0x55A5,
  0x55A6,
  // [  9921,  9929] -> [0x55A8,0x55B0] # seg 70
  // [  9930, 10012] -v # seg 71 at pos 7842
  0x55B2, 0x55B4, 0x55B6, 0x55B8, 0x55BA, 0x55BC, 0x55BF, 0x55C0,
  0x55C1, 0x55C2, 0x55C3, 0x55C6, 0x55C7, 0x55C8, 0x55CA, 0x55CB,
  0x55CE, 0x55CF, 0x55D0, 0x55D5, 0x55D7, 0x55D8, 0x55D9, 0x55DA,
  0x55DB, 0x55DE, 0x55E0, 0x55E2, 0x55E7, 0x55E9, 0x55ED, 0x55EE,
  0x55F0, 0x55F1, 0x55F4, 0x55F6, 0x55F8, 0x55F9, 0x55FA, 0x55FB,
  0x55FC, 0x55FF, 0x5602, 0x5603, 0x5604, 0x5605, 0x5606, 0x5607,
  0x560A, 0x560B, 0x560D, 0x5610, 0x5611, 0x5612, 0x5613, 0x5614,
  0x5615, 0x5616, 0x5617, 0x5619, 0x561A, 0x561C, 0x561D, 0x5620,
  0x5621, 0x5622, 0x5625, 0x5626, 0x5628, 0x5629, 0x562A, 0x562B,
  0x562E, 0x562F, 0x5630, 0x5633, 0x5635, 0x5637, 0x5638, 0x563A,
  0x563C, 0x563D, 0x563E,
  // [ 10013, 10024] -> [0x5640,0x564B] # seg 72
  // [ 10025, 10072] -v # seg 73 at pos 7925
  0x564F, 0x5650, 0x5651, 0x5652, 0x5653, 0x5655, 0x5656, 0x565A,
  0x565B, 0x565D, 0x565E, 0x565F, 0x5660, 0x5661, 0x5663, 0x5665,
  0x5666, 0x5667, 0x566D, 0x566E, 0x566F, 0x5670, 0x5672, 0x5673,
  0x5674, 0x5675, 0x5677, 0x5678, 0x5679, 0x567A, 0x567D, 0x567E,
  0x567F, 0x5680, 0x5681, 0x5682, 0x5683, 0x5684, 0x5687, 0x5688,
  0x5689, 0x568A, 0x568B, 0x568C, 0x568D, 0x5690, 0x5691, 0x5692,
  // [ 10073, 10087] -> [0x5694,0x56A2] # seg 74
  // [ 10088, 10098] -> [0x56A4,0x56AE] # seg 75
  // [ 10099, 10109] -v # seg 76 at pos 7973
  0x56B0, 0x56B1, 0x56B2, 0x56B3, 0x56B4, 0x56B5, 0x56B6, 0x56B8,
  0x56B9, 0x56BA, 0x56BB,
  // [ 10110, 10122] -> [0x56BD,0x56C9] # seg 77
  // [ 10123, 10131] -> [0x56CB,0x56D3] # seg 78
  // [ 10132, 10158] -v # seg 79 at pos 7984
  0x56D5, 0x56D6, 0x56D8, 0x56D9, 0x56DC, 0x56E3, 0x56E5, 0x56E6,
  0x56E7, 0x56E8, 0x56E9, 0x56EA, 0x56EC, 0x56EE, 0x56EF, 0x56F2,
  0x56F3, 0x56F6, 0x56F7, 0x56F8, 0x56FB, 0x56FC, 0x5700, 0x5701,
  0x5702, 0x5705, 0x5707,
  // [ 10159, 10175] -> [0x570B,0x571B] # seg 80
  // [ 10176, 10260] -v # seg 81 at pos 8011
  0x571D, 0x571E, 0x5720, 0x5721, 0x5722, 0x5724, 0x5725, 0x5726,
  0x5727, 0x572B, 0x5731, 0x5732, 0x5734, 0x5735, 0x5736, 0x5737,
  0x5738, 0x573C, 0x573D, 0x573F, 0x5741, 0x5743, 0x5744, 0x5745,
  0x5746, 0x5748, 0x5749, 0x574B, 0x5752, 0x5753, 0x5754, 0x5755,
  0x5756, 0x5758, 0x5759, 0x5762, 0x5763, 0x5765, 0x5767, 0x576C,
  0x576E, 0x5770, 0x5771, 0x5772, 0x5774, 0x5775, 0x5778, 0x5779,
  0x577A, 0x577D, 0x577E, 0x577F, 0x5780, 0x5781, 0x5787, 0x5788,
  0x5789, 0x578A, 0x578D, 0x578E, 0x578F, 0x5790, 0x5791, 0x5794,
  0x5795, 0x5796, 0x5797, 0x5798, 0x5799, 0x579A, 0x579C, 0x579D,
  0x579E, 0x579F, 0x57A5, 0x57A8, 0x57AA, 0x57AC, 0x57AF, 0x57B0,
  0x57B1, 0x57B3, 0x57B5, 0x57B6, 0x57B7,
  // [ 10261, 10269] -> [0x57B9,0x57C1] # seg 82
  // [ 10270, 10347] -v # seg 83 at pos 8096
  0x57C4, 0x57C5, 0x57C6, 0x57C7, 0x57C8, 0x57C9, 0x57CA, 0x57CC,
  0x57CD, 0x57D0, 0x57D1, 0x57D3, 0x57D6, 0x57D7, 0x57DB, 0x57DC,
  0x57DE, 0x57E1, 0x57E2, 0x57E3, 0x57E5, 0x57E6, 0x57E7, 0x57E8,
  0x57E9, 0x57EA, 0x57EB, 0x57EC, 0x57EE, 0x57F0, 0x57F1, 0x57F2,
  0x57F3, 0x57F5, 0x57F6, 0x57F7, 0x57FB, 0x57FC, 0x57FE, 0x57FF,
  0x5801, 0x5803, 0x5804, 0x5805, 0x5808, 0x5809, 0x580A, 0x580C,
  0x580E, 0x580F, 0x5810, 0x5812, 0x5813, 0x5814, 0x5816, 0x5817,
  0x5818, 0x581A, 0x581B, 0x581C, 0x581D, 0x581F, 0x5822, 0x5823,
  0x5825, 0x5826, 0x5827, 0x5828, 0x5829, 0x582B, 0x582C, 0x582D,
  0x582E, 0x582F, 0x5831, 0x5832, 0x5833, 0x5834,
  // [ 10348, 10361] -> [0x5836,0x5843] # seg 84
  // [ 10362, 10392] -v # seg 85 at pos 8174
  0x5845, 0x5846, 0x5847, 0x5848, 0x5849, 0x584A, 0x584B, 0x584E,
  0x584F, 0x5850, 0x5852, 0x5853, 0x5855, 0x5856, 0x5857, 0x5859,
  0x585A, 0x585B, 0x585C, 0x585D, 0x585F, 0x5860, 0x5861, 0x5862,
  0x5863, 0x5864, 0x5866, 0x5867, 0x5868, 0x5869, 0x586A,
  // [ 10393, 10409] -> [0x586D,0x587D] # seg 86
  // [ 10410, 10439] -v # seg 87 at pos 8205
  0x587F, 0x5882, 0x5884, 0x5886, 0x5887, 0x5888, 0x588A, 0x588B,
  0x588C, 0x588D, 0x588E, 0x588F, 0x5890, 0x5891, 0x5894, 0x5895,
  0x5896, 0x5897, 0x5898, 0x589B, 0x589C, 0x589D, 0x58A0, 0x58A1,
  0x58A2, 0x58A3, 0x58A4, 0x58A5, 0x58A6, 0x58A7,
  // [ 10440, 10457] -> [0x58AA,0x58BB] # seg 88
  // [ 10458, 10464] -v # seg 89 at pos 8235
  0x58BD, 0x58BE, 0x58BF, 0x58C0, 0x58C2, 0x58C3, 0x58C4,
  // [ 10465, 10475] -> [0x58C6,0x58D0] # seg 90
  // [ 10476, 10478] -> [0x58D2,0x58D4] # seg 91
  // [ 10479, 10492] -> [0x58D6,0x58E3] # seg 92
  // [ 10493, 10567] -v # seg 93 at pos 8242
  0x58E5, 0x58E6, 0x58E7, 0x58E8, 0x58E9, 0x58EA, 0x58ED, 0x58EF,
  0x58F1, 0x58F2, 0x58F4, 0x58F5, 0x58F7, 0x58F8, 0x58FA, 0x58FB,
  0x58FC, 0x58FD, 0x58FE, 0x58FF, 0x5900, 0x5901, 0x5903, 0x5905,
  0x5906, 0x5908, 0x5909, 0x590A, 0x590B, 0x590C, 0x590E, 0x5910,
  0x5911, 0x5912, 0x5913, 0x5917, 0x5918, 0x591B, 0x591D, 0x591E,
  0x5920, 0x5921, 0x5922, 0x5923, 0x5926, 0x5928, 0x592C, 0x5930,
  0x5932, 0x5933, 0x5935, 0x5936, 0x593B, 0x593D, 0x593E, 0x593F,
  0x5940, 0x5943, 0x5945, 0x5946, 0x594A, 0x594C, 0x594D, 0x5950,
  0x5952, 0x5953, 0x5959, 0x595B, 0x595C, 0x595D, 0x595E, 0x595F,
  0x5961, 0x5963, 0x5964,
  // [ 10568, 10580] -> [0x5966,0x5972] # seg 94
  // [ 10581, 10651] -v # seg 95 at pos 8317
  0x5975, 0x5977, 0x597A, 0x597B, 0x597C, 0x597E, 0x597F, 0x5980,
  0x5985, 0x5989, 0x598B, 0x598C, 0x598E, 0x598F, 0x5990, 0x5991,
  0x5994, 0x5995, 0x5998, 0x599A, 0x599B, 0x599C, 0x599D, 0x599F,
  0x59A0, 0x59A1, 0x59A2, 0x59A6, 0x59A7, 0x59AC, 0x59AD, 0x59B0,
  0x59B1, 0x59B3, 0x59B4, 0x59B5, 0x59B6, 0x59B7, 0x59B8, 0x59BA,
  0x59BC, 0x59BD, 0x59BF, 0x59C0, 0x59C1, 0x59C2, 0x59C3, 0x59C4,
  0x59C5, 0x59C7, 0x59C8, 0x59C9, 0x59CC, 0x59CD, 0x59CE, 0x59CF,
  0x59D5, 0x59D6, 0x59D9, 0x59DB, 0x59DE, 0x59DF, 0x59E0, 0x59E1,
  0x59E2, 0x59E4, 0x59E6, 0x59E7, 0x59E9, 0x59EA, 0x59EB,
  // [ 10652, 10663] -> [0x59ED,0x59F8] # seg 96
  // [ 10664, 10715] -v # seg 97 at pos 8388
  0x59FA, 0x59FC, 0x59FD, 0x59FE, 0x5A00, 0x5A02, 0x5A0A, 0x5A0B,
  0x5A0D, 0x5A0E, 0x5A0F, 0x5A10, 0x5A12, 0x5A14, 0x5A15, 0x5A16,
  0x5A17, 0x5A19, 0x5A1A, 0x5A1B, 0x5A1D, 0x5A1E, 0x5A21, 0x5A22,
  0x5A24, 0x5A26, 0x5A27, 0x5A28, 0x5A2A, 0x5A2B, 0x5A2C, 0x5A2D,
  0x5A2E, 0x5A2F, 0x5A30, 0x5A33, 0x5A35, 0x5A37, 0x5A38, 0x5A39,
  0x5A3A, 0x5A3B, 0x5A3D, 0x5A3E, 0x5A3F, 0x5A41, 0x5A42, 0x5A43,
  0x5A44, 0x5A45, 0x5A47, 0x5A48,
  // [ 10716, 10725] -> [0x5A4B,0x5A54] # seg 98
  // [ 10726, 10742] -v # seg 99 at pos 8440
  0x5A56, 0x5A57, 0x5A58, 0x5A59, 0x5A5B, 0x5A5C, 0x5A5D, 0x5A5E,
  0x5A5F, 0x5A60, 0x5A61, 0x5A63, 0x5A64, 0x5A65, 0x5A66, 0x5A68,
  0x5A69,
  // [ 10743, 10751] -> [0x5A6B,0x5A73] # seg 100
  // [ 10752, 10757] -v # seg 101 at pos 8457
  0x5A78, 0x5A79, 0x5A7B, 0x5A7C, 0x5A7D, 0x5A7E,
  // [ 10758, 10775] -> [0x5A80,0x5A91] # seg 102
  // [ 10776, 10782] -> [0x5A93,0x5A99] # seg 103
  // [ 10783, 10796] -> [0x5A9C,0x5AA9] # seg 104
  // [ 10797, 10846] -v # seg 105 at pos 8463
  0x5AAB, 0x5AAC, 0x5AAD, 0x5AAE, 0x5AAF, 0x5AB0, 0x5AB1, 0x5AB4,
  0x5AB6, 0x5AB7, 0x5AB9, 0x5ABA, 0x5ABB, 0x5ABC, 0x5ABD, 0x5ABF,
  0x5AC0, 0x5AC3, 0x5AC4, 0x5AC5, 0x5AC6, 0x5AC7, 0x5AC8, 0x5ACA,
  0x5ACB, 0x5ACD, 0x5ACE, 0x5ACF, 0x5AD0, 0x5AD1, 0x5AD3, 0x5AD5,
  0x5AD7, 0x5AD9, 0x5ADA, 0x5ADB, 0x5ADD, 0x5ADE, 0x5ADF, 0x5AE2,
  0x5AE4, 0x5AE5, 0x5AE7, 0x5AE8, 0x5AEA, 0x5AEC, 0x5AED, 0x5AEE,
  0x5AEF, 0x5AF0,
  // [ 10847, 10869] -> [0x5AF2,0x5B08] # seg 106
  // [ 10870, 10881] -> [0x5B0A,0x5B15] # seg 107
  // [ 10882, 10907] -> [0x5B18,0x5B31] # seg 108
  // [ 10908, 10918] -v # seg 109 at pos 8513
  0x5B33, 0x5B35, 0x5B36, 0x5B38, 0x5B39, 0x5B3A, 0x5B3B, 0x5B3C,
  0x5B3D, 0x5B3E, 0x5B3F,
  // [ 10919, 10933] -> [0x5B41,0x5B4F] # seg 110
  // [ 10934, 10989] -v # seg 111 at pos 8524
  0x5B52, 0x5B56, 0x5B5E, 0x5B60, 0x5B61, 0x5B67, 0x5B68, 0x5B6B,
  0x5B6D, 0x5B6E, 0x5B6F, 0x5B72, 0x5B74, 0x5B76, 0x5B77, 0x5B78,
  0x5B79, 0x5B7B, 0x5B7C, 0x5B7E, 0x5B7F, 0x5B82, 0x5B86, 0x5B8A,
  0x5B8D, 0x5B8E, 0x5B90, 0x5B91, 0x5B92, 0x5B94, 0x5B96, 0x5B9F,
  0x5BA7, 0x5BA8, 0x5BA9, 0x5BAC, 0x5BAD, 0x5BAE, 0x5BAF, 0x5BB1,
  0x5BB2, 0x5BB7, 0x5BBA, 0x5BBB, 0x5BBC, 0x5BC0, 0x5BC1, 0x5BC3,
  0x5BC8, 0x5BC9, 0x5BCA, 0x5BCB, 0x5BCD, 0x5BCE, 0x5BCF, 0x5BD1,
  // [ 10990, 10998] -> [0x5BD4,0x5BDC] # seg 112
  // [ 10999, 11163] -v # seg 113 at pos 8580
  0x5BE0, 0x5BE2, 0x5BE3, 0x5BE6, 0x5BE7, 0x5BE9, 0x5BEA, 0x5BEB,
  0x5BEC, 0x5BED, 0x5BEF, 0x5BF1, 0x5BF2, 0x5BF3, 0x5BF4, 0x5BF5,
  0x5BF6, 0x5BF7, 0x5BFD, 0x5BFE, 0x5C00, 0x5C02, 0x5C03, 0x5C05,
  0x5C07, 0x5C08, 0x5C0B, 0x5C0C, 0x5C0D, 0x5C0E, 0x5C10, 0x5C12,
  0x5C13, 0x5C17, 0x5C19, 0x5C1B, 0x5C1E, 0x5C1F, 0x5C20, 0x5C21,
  0x5C23, 0x5C26, 0x5C28, 0x5C29, 0x5C2A, 0x5C2B, 0x5C2D, 0x5C2E,
  0x5C2F, 0x5C30, 0x5C32, 0x5C33, 0x5C35, 0x5C36, 0x5C37, 0x5C43,
  0x5C44, 0x5C46, 0x5C47, 0x5C4C, 0x5C4D, 0x5C52, 0x5C53, 0x5C54,
  0x5C56, 0x5C57, 0x5C58, 0x5C5A, 0x5C5B, 0x5C5C, 0x5C5D, 0x5C5F,
  0x5C62, 0x5C64, 0x5C67, 0x5C68, 0x5C69, 0x5C6A, 0x5C6B, 0x5C6C,
  0x5C6D, 0x5C70, 0x5C72, 0x5C73, 0x5C74, 0x5C75, 0x5C76, 0x5C77,
  0x5C78, 0x5C7B, 0x5C7C, 0x5C7D, 0x5C7E, 0x5C80, 0x5C83, 0x5C84,
  0x5C85, 0x5C86, 0x5C87, 0x5C89, 0x5C8A, 0x5C8B, 0x5C8E, 0x5C8F,
  0x5C92, 0x5C93, 0x5C95, 0x5C9D, 0x5C9E, 0x5C9F, 0x5CA0, 0x5CA1,
  0x5CA4, 0x5CA5, 0x5CA6, 0x5CA7, 0x5CA8, 0x5CAA, 0x5CAE, 0x5CAF,
  0x5CB0, 0x5CB2, 0x5CB4, 0x5CB6, 0x5CB9, 0x5CBA, 0x5CBB, 0x5CBC,
  0x5CBE, 0x5CC0, 0x5CC2, 0x5CC3, 0x5CC5, 0x5CC6, 0x5CC7, 0x5CC8,
  0x5CC9, 0x5CCA, 0x5CCC, 0x5CCD, 0x5CCE, 0x5CCF, 0x5CD0, 0x5CD1,
  0x5CD3, 0x5CD4, 0x5CD5, 0x5CD6, 0x5CD7, 0x5CD8, 0x5CDA, 0x5CDB,
  0x5CDC, 0x5CDD, 0x5CDE, 0x5CDF, 0x5CE0, 0x5CE2, 0x5CE3, 0x5CE7,
  0x5CE9, 0x5CEB, 0x5CEC, 0x5CEE, 0x5CEF,
  // [ 11164, 11173] -> [0x5CF1,0x5CFA] # seg 114
  // [ 11174, 11232] -v # seg 115 at pos 8745
  0x5CFC, 0x5CFD, 0x5CFE, 0x5CFF, 0x5D00, 0x5D01, 0x5D04, 0x5D05,
  0x5D08, 0x5D09, 0x5D0A, 0x5D0B, 0x5D0C, 0x5D0D, 0x5D0F, 0x5D10,
  0x5D11, 0x5D12, 0x5D13, 0x5D15, 0x5D17, 0x5D18, 0x5D19, 0x5D1A,
  0x5D1C, 0x5D1D, 0x5D1F, 0x5D20, 0x5D21, 0x5D22, 0x5D23, 0x5D25,
  0x5D28, 0x5D2A, 0x5D2B, 0x5D2C, 0x5D2F, 0x5D30, 0x5D31, 0x5D32,
  0x5D33, 0x5D35, 0x5D36, 0x5D37, 0x5D38, 0x5D39, 0x5D3A, 0x5D3B,
  0x5D3C, 0x5D3F, 0x5D40, 0x5D41, 0x5D42, 0x5D43, 0x5D44, 0x5D45,
  0x5D46, 0x5D48, 0x5D49,
  // [ 11233, 11243] -> [0x5D4D,0x5D57] # seg 116
  // [ 11244, 11246] -v # seg 117 at pos 8804
  0x5D59, 0x5D5A, 0x5D5C,
  // [ 11247, 11257] -> [0x5D5E,0x5D68] # seg 118
  // [ 11258, 11264] -v # seg 119 at pos 8807
  0x5D6A, 0x5D6D, 0x5D6E, 0x5D70, 0x5D71, 0x5D72, 0x5D73,
  // [ 11265, 11277] -> [0x5D75,0x5D81] # seg 120
  // [ 11278, 11299] -> [0x5D83,0x5D98] # seg 121
  // [ 11300, 11302] -> [0x5D9A,0x5D9C] # seg 122
  // [ 11303, 11327] -> [0x5D9E,0x5DB6] # seg 123
  // [ 11328, 11340] -> [0x5DB8,0x5DC4] # seg 124
  // [ 11341, 11347] -> [0x5DC6,0x5DCC] # seg 125
  // [ 11348, 11360] -> [0x5DCE,0x5DDA] # seg 126
  // [ 11361, 11437] -v # seg 127 at pos 8814
  0x5DDC, 0x5DDF, 0x5DE0, 0x5DE3, 0x5DE4, 0x5DEA, 0x5DEC, 0x5DED,
  0x5DF0, 0x5DF5, 0x5DF6, 0x5DF8, 0x5DF9, 0x5DFA, 0x5DFB, 0x5DFC,
  0x5DFF, 0x5E00, 0x5E04, 0x5E07, 0x5E09, 0x5E0A, 0x5E0B, 0x5E0D,
  0x5E0E, 0x5E12, 0x5E13, 0x5E17, 0x5E1E, 0x5E1F, 0x5E20, 0x5E21,
  0x5E22, 0x5E23, 0x5E24, 0x5E25, 0x5E28, 0x5E29, 0x5E2A, 0x5E2B,
  0x5E2C, 0x5E2F, 0x5E30, 0x5E32, 0x5E33, 0x5E34, 0x5E35, 0x5E36,
  0x5E39, 0x5E3A, 0x5E3E, 0x5E3F, 0x5E40, 0x5E41, 0x5E43, 0x5E46,
  0x5E47, 0x5E48, 0x5E49, 0x5E4A, 0x5E4B, 0x5E4D, 0x5E4E, 0x5E4F,
  0x5E50, 0x5E51, 0x5E52, 0x5E53, 0x5E56, 0x5E57, 0x5E58, 0x5E59,
  0x5E5A, 0x5E5C, 0x5E5D, 0x5E5F, 0x5E60,
  // [ 11438, 11452] -> [0x5E63,0x5E71] # seg 128
  // [ 11453, 11488] -v # seg 129 at pos 8891
  0x5E75, 0x5E77, 0x5E79, 0x5E7E, 0x5E81, 0x5E82, 0x5E83, 0x5E85,
  0x5E88, 0x5E89, 0x5E8C, 0x5E8D, 0x5E8E, 0x5E92, 0x5E98, 0x5E9B,
  0x5E9D, 0x5EA1, 0x5EA2, 0x5EA3, 0x5EA4, 0x5EA8, 0x5EA9, 0x5EAA,
  0x5EAB, 0x5EAC, 0x5EAE, 0x5EAF, 0x5EB0, 0x5EB1, 0x5EB2, 0x5EB4,
  0x5EBA, 0x5EBB, 0x5EBC, 0x5EBD,
  // [ 11489, 11498] -> [0x5EBF,0x5EC8] # seg 130
  // [ 11499, 11510] -v # seg 131 at pos 8927
  0x5ECB, 0x5ECC, 0x5ECD, 0x5ECE, 0x5ECF, 0x5ED0, 0x5ED4, 0x5ED5,
  0x5ED7, 0x5ED8, 0x5ED9, 0x5EDA,
  // [ 11511, 11522] -> [0x5EDC,0x5EE7] # seg 132
  // [ 11523, 11523] -> [0x5EE9,0x5EE9] # seg 133
  // [ 11524, 11532] -> [0x5EEB,0x5EF3] # seg 134
  // [ 11533, 11574] -v # seg 135 at pos 8939
  0x5EF5, 0x5EF8, 0x5EF9, 0x5EFB, 0x5EFC, 0x5EFD, 0x5F05, 0x5F06,
  0x5F07, 0x5F09, 0x5F0C, 0x5F0D, 0x5F0E, 0x5F10, 0x5F12, 0x5F14,
  0x5F16, 0x5F19, 0x5F1A, 0x5F1C, 0x5F1D, 0x5F1E, 0x5F21, 0x5F22,
  0x5F23, 0x5F24, 0x5F28, 0x5F2B, 0x5F2C, 0x5F2E, 0x5F30, 0x5F32,
  0x5F33, 0x5F34, 0x5F35, 0x5F36, 0x5F37, 0x5F38, 0x5F3B, 0x5F3D,
  0x5F3E, 0x5F3F,
  // [ 11575, 11589] -> [0x5F41,0x5F4F] # seg 136
  // [ 11590, 11849] -v # seg 137 at pos 8981
  0x5F51, 0x5F54, 0x5F59, 0x5F5A, 0x5F5B, 0x5F5C, 0x5F5E, 0x5F5F,
  0x5F60, 0x5F63, 0x5F65, 0x5F67, 0x5F68, 0x5F6B, 0x5F6E, 0x5F6F,
  0x5F72, 0x5F74, 0x5F75, 0x5F76, 0x5F78, 0x5F7A, 0x5F7D, 0x5F7E,
  0x5F7F, 0x5F83, 0x5F86, 0x5F8D, 0x5F8E, 0x5F8F, 0x5F91, 0x5F93,
  0x5F94, 0x5F96, 0x5F9A, 0x5F9B, 0x5F9D, 0x5F9E, 0x5F9F, 0x5FA0,
  0x5FA2, 0x5FA3, 0x5FA4, 0x5FA5, 0x5FA6, 0x5FA7, 0x5FA9, 0x5FAB,
  0x5FAC, 0x5FAF, 0x5FB0, 0x5FB1, 0x5FB2, 0x5FB3, 0x5FB4, 0x5FB6,
  0x5FB8, 0x5FB9, 0x5FBA, 0x5FBB, 0x5FBE, 0x5FBF, 0x5FC0, 0x5FC1,
  0x5FC2, 0x5FC7, 0x5FC8, 0x5FCA, 0x5FCB, 0x5FCE, 0x5FD3, 0x5FD4,
  0x5FD5, 0x5FDA, 0x5FDB, 0x5FDC, 0x5FDE, 0x5FDF, 0x5FE2, 0x5FE3,
  0x5FE5, 0x5FE6, 0x5FE8, 0x5FE9, 0x5FEC, 0x5FEF, 0x5FF0, 0x5FF2,
  0x5FF3, 0x5FF4, 0x5FF6, 0x5FF7, 0x5FF9, 0x5FFA, 0x5FFC, 0x6007,
  0x6008, 0x6009, 0x600B, 0x600C, 0x6010, 0x6011, 0x6013, 0x6017,
  0x6018, 0x601A, 0x601E, 0x601F, 0x6022, 0x6023, 0x6024, 0x602C,
  0x602D, 0x602E, 0x6030, 0x6031, 0x6032, 0x6033, 0x6034, 0x6036,
  0x6037, 0x6038, 0x6039, 0x603A, 0x603D, 0x603E, 0x6040, 0x6044,
  0x6045, 0x6046, 0x6047, 0x6048, 0x6049, 0x604A, 0x604C, 0x604E,
  0x604F, 0x6051, 0x6053, 0x6054, 0x6056, 0x6057, 0x6058, 0x605B,
  0x605C, 0x605E, 0x605F, 0x6060, 0x6061, 0x6065, 0x6066, 0x606E,
  0x6071, 0x6072, 0x6074, 0x6075, 0x6077, 0x607E, 0x6080, 0x6081,
  0x6082, 0x6085, 0x6086, 0x6087, 0x6088, 0x608A, 0x608B, 0x608E,
  0x608F, 0x6090, 0x6091, 0x6093, 0x6095, 0x6097, 0x6098, 0x6099,
  0x609C, 0x609E, 0x60A1, 0x60A2, 0x60A4, 0x60A5, 0x60A7, 0x60A9,
  0x60AA, 0x60AE, 0x60B0, 0x60B3, 0x60B5, 0x60B6, 0x60B7, 0x60B9,
  0x60BA, 0x60BD, 0x60BE, 0x60BF, 0x60C0, 0x60C1, 0x60C2, 0x60C3,
  0x60C4, 0x60C7, 0x60C8, 0x60C9, 0x60CC, 0x60CD, 0x60CE, 0x60CF,
  0x60D0, 0x60D2, 0x60D3, 0x60D4, 0x60D6, 0x60D7, 0x60D9, 0x60DB,
  0x60DE, 0x60E1, 0x60E2, 0x60E3, 0x60E4, 0x60E5, 0x60EA, 0x60F1,
  0x60F2, 0x60F5, 0x60F7, 0x60F8, 0x60FB, 0x60FC, 0x60FD, 0x60FE,
  0x60FF, 0x6102, 0x6103, 0x6104, 0x6105, 0x6107, 0x610A, 0x610B,
  0x610C, 0x6110, 0x6111, 0x6112, 0x6113, 0x6114, 0x6116, 0x6117,
  0x6118, 0x6119, 0x611B, 0x611C, 0x611D, 0x611E, 0x6121, 0x6122,
  0x6125, 0x6128, 0x6129, 0x612A,
  // [ 11850, 11868] -> [0x612C,0x613E] # seg 138
  // [ 11869, 11876] -> [0x6140,0x6147] # seg 139
  // [ 11877, 11911] -v # seg 140 at pos 9241
  0x6149, 0x614B, 0x614D, 0x614F, 0x6150, 0x6152, 0x6153, 0x6154,
  0x6156, 0x6157, 0x6158, 0x6159, 0x615A, 0x615B, 0x615C, 0x615E,
  0x615F, 0x6160, 0x6161, 0x6163, 0x6164, 0x6165, 0x6166, 0x6169,
  0x616A, 0x616B, 0x616C, 0x616D, 0x616E, 0x616F, 0x6171, 0x6172,
  0x6173, 0x6174, 0x6176,
  // [ 11912, 11930] -> [0x6178,0x618A] # seg 141
  // [ 11931, 11945] -v # seg 142 at pos 9276
  0x618C, 0x618D, 0x618F, 0x6190, 0x6191, 0x6192, 0x6193, 0x6195,
  0x6196, 0x6197, 0x6198, 0x6199, 0x619A, 0x619B, 0x619C,
  // [ 11946, 11954] -> [0x619E,0x61A6] # seg 143
  // [ 11955, 11956] -> [0x61AA,0x61AB] # seg 144
  // [ 11957, 11966] -> [0x61AD,0x61B6] # seg 145
  // [ 11967, 11987] -v # seg 146 at pos 9291
  0x61B8, 0x61B9, 0x61BA, 0x61BB, 0x61BC, 0x61BD, 0x61BF, 0x61C0,
  0x61C1, 0x61C3, 0x61C4, 0x61C5, 0x61C6, 0x61C7, 0x61C9, 0x61CC,
  0x61CD, 0x61CE, 0x61CF, 0x61D0, 0x61D3,
  // [ 11988, 12004] -> [0x61D5,0x61E5] # seg 147
  // [ 12005, 12018] -> [0x61E7,0x61F4] # seg 148
  // [ 12019, 12027] -> [0x61F6,0x61FE] # seg 149
  // [ 12028, 12369] -v # seg 150 at pos 9312
  0x6200, 0x6201, 0x6202, 0x6203, 0x6204, 0x6205, 0x6207, 0x6209,
  0x6213, 0x6214, 0x6219, 0x621C, 0x621D, 0x621E, 0x6220, 0x6223,
  0x6226, 0x6227, 0x6228, 0x6229, 0x622B, 0x622D, 0x622F, 0x6230,
  0x6231, 0x6232, 0x6235, 0x6236, 0x6238, 0x6239, 0x623A, 0x623B,
  0x623C, 0x6242, 0x6244, 0x6245, 0x6246, 0x624A, 0x624F, 0x6250,
  0x6255, 0x6256, 0x6257, 0x6259, 0x625A, 0x625C, 0x625D, 0x625E,
  0x625F, 0x6260, 0x6261, 0x6262, 0x6264, 0x6265, 0x6268, 0x6271,
  0x6272, 0x6274, 0x6275, 0x6277, 0x6278, 0x627A, 0x627B, 0x627D,
  0x6281, 0x6282, 0x6283, 0x6285, 0x6286, 0x6287, 0x6288, 0x628B,
  0x628C, 0x628D, 0x628E, 0x628F, 0x6290, 0x6294, 0x6299, 0x629C,
  0x629D, 0x629E, 0x62A3, 0x62A6, 0x62A7, 0x62A9, 0x62AA, 0x62AD,
  0x62AE, 0x62AF, 0x62B0, 0x62B2, 0x62B3, 0x62B4, 0x62B6, 0x62B7,
  0x62B8, 0x62BA, 0x62BE, 0x62C0, 0x62C1, 0x62C3, 0x62CB, 0x62CF,
  0x62D1, 0x62D5, 0x62DD, 0x62DE, 0x62E0, 0x62E1, 0x62E4, 0x62EA,
  0x62EB, 0x62F0, 0x62F2, 0x62F5, 0x62F8, 0x62F9, 0x62FA, 0x62FB,
  0x6300, 0x6303, 0x6304, 0x6305, 0x6306, 0x630A, 0x630B, 0x630C,
  0x630D, 0x630F, 0x6310, 0x6312, 0x6313, 0x6314, 0x6315, 0x6317,
  0x6318, 0x6319, 0x631C, 0x6326, 0x6327, 0x6329, 0x632C, 0x632D,
  0x632E, 0x6330, 0x6331, 0x6333, 0x6334, 0x6335, 0x6336, 0x6337,
  0x6338, 0x633B, 0x633C, 0x633E, 0x633F, 0x6340, 0x6341, 0x6344,
  0x6347, 0x6348, 0x634A, 0x6351, 0x6352, 0x6353, 0x6354, 0x6356,
  0x6357, 0x6358, 0x6359, 0x635A, 0x635B, 0x635C, 0x635D, 0x6360,
  0x6364, 0x6365, 0x6366, 0x6368, 0x636A, 0x636B, 0x636C, 0x636F,
  0x6370, 0x6372, 0x6373, 0x6374, 0x6375, 0x6378, 0x6379, 0x637C,
  0x637D, 0x637E, 0x637F, 0x6381, 0x6383, 0x6384, 0x6385, 0x6386,
  0x638B, 0x638D, 0x6391, 0x6393, 0x6394, 0x6395, 0x6397, 0x6399,
  0x639A, 0x639B, 0x639C, 0x639D, 0x639E, 0x639F, 0x63A1, 0x63A4,
  0x63A6, 0x63AB, 0x63AF, 0x63B1, 0x63B2, 0x63B5, 0x63B6, 0x63B9,
  0x63BB, 0x63BD, 0x63BF, 0x63C0, 0x63C1, 0x63C2, 0x63C3, 0x63C5,
  0x63C7, 0x63C8, 0x63CA, 0x63CB, 0x63CC, 0x63D1, 0x63D3, 0x63D4,
  0x63D5, 0x63D7, 0x63D8, 0x63D9, 0x63DA, 0x63DB, 0x63DC, 0x63DD,
  0x63DF, 0x63E2, 0x63E4, 0x63E5, 0x63E6, 0x63E7, 0x63E8, 0x63EB,
  0x63EC, 0x63EE, 0x63EF, 0x63F0, 0x63F1, 0x63F3, 0x63F5, 0x63F7,
  0x63F9, 0x63FA, 0x63FB, 0x63FC, 0x63FE, 0x6403, 0x6404, 0x6406,
  0x6407, 0x6408, 0x6409, 0x640A, 0x640D, 0x640E, 0x6411, 0x6412,
  0x6415, 0x6416, 0x6417, 0x6418, 0x6419, 0x641A, 0x641D, 0x641F,
  0x6422, 0x6423, 0x6424, 0x6425, 0x6427, 0x6428, 0x6429, 0x642B,
  0x642E, 0x642F, 0x6430, 0x6431, 0x6432, 0x6433, 0x6435, 0x6436,
  0x6437, 0x6438, 0x6439, 0x643B, 0x643C, 0x643E, 0x6440, 0x6442,
  0x6443, 0x6449, 0x644B, 0x644C, 0x644D, 0x644E, 0x644F, 0x6450,
  0x6451, 0x6453, 0x6455, 0x6456, 0x6457, 0x6459, 0x645A, 0x645B,
  0x645C, 0x645D, 0x645F, 0x6460, 0x6461, 0x6462, 0x6463, 0x6464,
  0x6465, 0x6466, 0x6468, 0x646A, 0x646B, 0x646C,
  // [ 12370, 12379] -> [0x646E,0x6477] # seg 151
  // [ 12380, 12388] -v # seg 152 at pos 9654
  0x647B, 0x647C, 0x647D, 0x647E, 0x647F, 0x6480, 0x6481, 0x6483,
  0x6486,
  // [ 12389, 12397] -> [0x6488,0x6490] # seg 153
  // [ 12398, 12453] -v # seg 154 at pos 9663
  0x6493, 0x6494, 0x6497, 0x6498, 0x649A, 0x649B, 0x649C, 0x649D,
  0x649F, 0x64A0, 0x64A1, 0x64A2, 0x64A3, 0x64A5, 0x64A6, 0x64A7,
  0x64A8, 0x64AA, 0x64AB, 0x64AF, 0x64B1, 0x64B2, 0x64B3, 0x64B4,
  0x64B6, 0x64B9, 0x64BB, 0x64BD, 0x64BE, 0x64BF, 0x64C1, 0x64C3,
  0x64C4, 0x64C6, 0x64C7, 0x64C8, 0x64C9, 0x64CA, 0x64CB, 0x64CC,
  0x64CF, 0x64D1, 0x64D3, 0x64D4, 0x64D5, 0x64D6, 0x64D9, 0x64DA,
  0x64DB, 0x64DC, 0x64DD, 0x64DF, 0x64E0, 0x64E1, 0x64E3, 0x64E5,
  // [ 12454, 12478] -> [0x64E7,0x64FF] # seg 155
  // [ 12479, 12486] -> [0x6501,0x6508] # seg 156
  // [ 12487, 12494] -> [0x650A,0x6511] # seg 157
  // [ 12495, 12499] -> [0x6513,0x6517] # seg 158
  // [ 12500, 12511] -> [0x6519,0x6524] # seg 159
  // [ 12512, 12561] -v # seg 160 at pos 9719
  0x6526, 0x6527, 0x6528, 0x6529, 0x652A, 0x652C, 0x652D, 0x6530,
  0x6531, 0x6532, 0x6533, 0x6537, 0x653A, 0x653C, 0x653D, 0x6540,
  0x6541, 0x6542, 0x6543, 0x6544, 0x6546, 0x6547, 0x654A, 0x654B,
  0x654D, 0x654E, 0x6550, 0x6552, 0x6553, 0x6554, 0x6557, 0x6558,
  0x655A, 0x655C, 0x655F, 0x6560, 0x6561, 0x6564, 0x6565, 0x6567,
  0x6568, 0x6569, 0x656A, 0x656D, 0x656E, 0x656F, 0x6571, 0x6573,
  0x6575, 0x6576,
  // [ 12562, 12576] -> [0x6578,0x6586] # seg 161
  // [ 12577, 12745] -v # seg 162 at pos 9769
  0x6588, 0x6589, 0x658A, 0x658D, 0x658E, 0x658F, 0x6592, 0x6594,
  0x6595, 0x6596, 0x6598, 0x659A, 0x659D, 0x659E, 0x65A0, 0x65A2,
  0x65A3, 0x65A6, 0x65A8, 0x65AA, 0x65AC, 0x65AE, 0x65B1, 0x65B2,
  0x65B3, 0x65B4, 0x65B5, 0x65B6, 0x65B7, 0x65B8, 0x65BA, 0x65BB,
  0x65BE, 0x65BF, 0x65C0, 0x65C2, 0x65C7, 0x65C8, 0x65C9, 0x65CA,
  0x65CD, 0x65D0, 0x65D1, 0x65D3, 0x65D4, 0x65D5, 0x65D8, 0x65D9,
  0x65DA, 0x65DB, 0x65DC, 0x65DD, 0x65DE, 0x65DF, 0x65E1, 0x65E3,
  0x65E4, 0x65EA, 0x65EB, 0x65F2, 0x65F3, 0x65F4, 0x65F5, 0x65F8,
  0x65F9, 0x65FB, 0x65FC, 0x65FD, 0x65FE, 0x65FF, 0x6601, 0x6604,
  0x6605, 0x6607, 0x6608, 0x6609, 0x660B, 0x660D, 0x6610, 0x6611,
  0x6612, 0x6616, 0x6617, 0x6618, 0x661A, 0x661B, 0x661C, 0x661E,
  0x6621, 0x6622, 0x6623, 0x6624, 0x6626, 0x6629, 0x662A, 0x662B,
  0x662C, 0x662E, 0x6630, 0x6632, 0x6633, 0x6637, 0x6638, 0x6639,
  0x663A, 0x663B, 0x663D, 0x663F, 0x6640, 0x6642, 0x6644, 0x6645,
  0x6646, 0x6647, 0x6648, 0x6649, 0x664A, 0x664D, 0x664E, 0x6650,
  0x6651, 0x6658, 0x6659, 0x665B, 0x665C, 0x665D, 0x665E, 0x6660,
  0x6662, 0x6663, 0x6665, 0x6667, 0x6669, 0x666A, 0x666B, 0x666C,
  0x666D, 0x6671, 0x6672, 0x6673, 0x6675, 0x6678, 0x6679, 0x667B,
  0x667C, 0x667D, 0x667F, 0x6680, 0x6681, 0x6683, 0x6685, 0x6686,
  0x6688, 0x6689, 0x668A, 0x668B, 0x668D, 0x668E, 0x668F, 0x6690,
  0x6692, 0x6693, 0x6694, 0x6695, 0x6698, 0x6699, 0x669A, 0x669B,
  0x669C,
  // [ 12746, 12754] -> [0x669E,0x66A6] # seg 163
  // [ 12755, 12772] -v # seg 164 at pos 9938
  0x66A9, 0x66AA, 0x66AB, 0x66AC, 0x66AD, 0x66AF, 0x66B0, 0x66B1,
  0x66B2, 0x66B3, 0x66B5, 0x66B6, 0x66B7, 0x66B8, 0x66BA, 0x66BB,
  0x66BC, 0x66BD,
  // [ 12773, 12798] -> [0x66BF,0x66D8] # seg 165
  // [ 12799, 12931] -v # seg 166 at pos 9956
  0x66DA, 0x66DE, 0x66DF, 0x66E0, 0x66E1, 0x66E2, 0x66E3, 0x66E4,
  0x66E5, 0x66E7, 0x66E8, 0x66EA, 0x66EB, 0x66EC, 0x66ED, 0x66EE,
  0x66EF, 0x66F1, 0x66F5, 0x66F6, 0x66F8, 0x66FA, 0x66FB, 0x66FD,
  0x6701, 0x6702, 0x6703, 0x6704, 0x6705, 0x6706, 0x6707, 0x670C,
  0x670E, 0x670F, 0x6711, 0x6712, 0x6713, 0x6716, 0x6718, 0x6719,
  0x671A, 0x671C, 0x671E, 0x6720, 0x6721, 0x6722, 0x6723, 0x6724,
  0x6725, 0x6727, 0x6729, 0x672E, 0x6730, 0x6732, 0x6733, 0x6736,
  0x6737, 0x6738, 0x6739, 0x673B, 0x673C, 0x673E, 0x673F, 0x6741,
  0x6744, 0x6745, 0x6747, 0x674A, 0x674B, 0x674D, 0x6752, 0x6754,
  0x6755, 0x6757, 0x6758, 0x6759, 0x675A, 0x675B, 0x675D, 0x6762,
  0x6763, 0x6764, 0x6766, 0x6767, 0x676B, 0x676C, 0x676E, 0x6771,
  0x6774, 0x6776, 0x6778, 0x6779, 0x677A, 0x677B, 0x677D, 0x6780,
  0x6782, 0x6783, 0x6785, 0x6786, 0x6788, 0x678A, 0x678C, 0x678D,
  0x678E, 0x678F, 0x6791, 0x6792, 0x6793, 0x6794, 0x6796, 0x6799,
  0x679B, 0x679F, 0x67A0, 0x67A1, 0x67A4, 0x67A6, 0x67A9, 0x67AC,
  0x67AE, 0x67B1, 0x67B2, 0x67B4, 0x67B9, 0x67BA, 0x67BB, 0x67BC,
  0x67BD, 0x67BE, 0x67BF, 0x67C0, 0x67C2,
  // [ 12932, 12941] -> [0x67C5,0x67CE] # seg 167
  // [ 12942, 13009] -v # seg 168 at pos 10089
  0x67D5, 0x67D6, 0x67D7, 0x67DB, 0x67DF, 0x67E1, 0x67E3, 0x67E4,
  0x67E6, 0x67E7, 0x67E8, 0x67EA, 0x67EB, 0x67ED, 0x67EE, 0x67F2,
  0x67F5, 0x67F6, 0x67F7, 0x67F8, 0x67F9, 0x67FA, 0x67FB, 0x67FC,
  0x67FE, 0x6801, 0x6802, 0x6803, 0x6804, 0x6806, 0x680D, 0x6810,
  0x6812, 0x6814, 0x6815, 0x6818, 0x6819, 0x681A, 0x681B, 0x681C,
  0x681E, 0x681F, 0x6820, 0x6822, 0x6823, 0x6824, 0x6825, 0x6826,
  0x6827, 0x6828, 0x682B, 0x682C, 0x682D, 0x682E, 0x682F, 0x6830,
  0x6831, 0x6834, 0x6835, 0x6836, 0x683A, 0x683B, 0x683F, 0x6847,
  0x684B, 0x684D, 0x684F, 0x6852,
  // [ 13010, 13019] -> [0x6856,0x685F] # seg 169
  // [ 13020, 13029] -v # seg 170 at pos 10157
  0x686A, 0x686C, 0x686D, 0x686E, 0x686F, 0x6870, 0x6871, 0x6872,
  0x6873, 0x6875,
  // [ 13030, 13038] -> [0x6878,0x6880] # seg 171
  // [ 13039, 13054] -v # seg 172 at pos 10167
  0x6882, 0x6884, 0x6887, 0x6888, 0x6889, 0x688A, 0x688B, 0x688C,
  0x688D, 0x688E, 0x6890, 0x6891, 0x6892, 0x6894, 0x6895, 0x6896,
  // [ 13055, 13064] -> [0x6898,0x68A1] # seg 173
  // [ 13065, 13075] -v # seg 174 at pos 10183
  0x68A3, 0x68A4, 0x68A5, 0x68A9, 0x68AA, 0x68AB, 0x68AC, 0x68AE,
  0x68B1, 0x68B2, 0x68B4,
  // [ 13076, 13085] -> [0x68B6,0x68BF] # seg 175
  // [ 13086, 13110] -v # seg 176 at pos 10194
  0x68C1, 0x68C3, 0x68C4, 0x68C5, 0x68C6, 0x68C7, 0x68C8, 0x68CA,
  0x68CC, 0x68CE, 0x68CF, 0x68D0, 0x68D1, 0x68D3, 0x68D4, 0x68D6,
  0x68D7, 0x68D9, 0x68DB, 0x68DC, 0x68DD, 0x68DE, 0x68DF, 0x68E1,
  0x68E2,
  // [ 13111, 13120] -> [0x68E4,0x68ED] # seg 177
  // [ 13121, 13143] -v # seg 178 at pos 10219
  0x68EF, 0x68F2, 0x68F3, 0x68F4, 0x68F6, 0x68F7, 0x68F8, 0x68FB,
  0x68FD, 0x68FE, 0x68FF, 0x6900, 0x6902, 0x6903, 0x6904, 0x6906,
  0x6907, 0x6908, 0x6909, 0x690A, 0x690C, 0x690F, 0x6911,
  // [ 13144, 13155] -> [0x6913,0x691E] # seg 179
  // [ 13156, 13181] -v # seg 180 at pos 10242
  0x6921, 0x6922, 0x6923, 0x6925, 0x6926, 0x6927, 0x6928, 0x6929,
  0x692A, 0x692B, 0x692C, 0x692E, 0x692F, 0x6931, 0x6932, 0x6933,
  0x6935, 0x6936, 0x6937, 0x6938, 0x693A, 0x693B, 0x693C, 0x693E,
  0x6940, 0x6941,
  // [ 13182, 13198] -> [0x6943,0x6953] # seg 181
  // [ 13199, 13243] -v # seg 182 at pos 10268
  0x6955, 0x6956, 0x6958, 0x6959, 0x695B, 0x695C, 0x695F, 0x6961,
  0x6962, 0x6964, 0x6965, 0x6967, 0x6968, 0x6969, 0x696A, 0x696C,
  0x696D, 0x696F, 0x6970, 0x6972, 0x6973, 0x6974, 0x6975, 0x6976,
  0x697A, 0x697B, 0x697D, 0x697E, 0x697F, 0x6981, 0x6983, 0x6985,
  0x698A, 0x698B, 0x698C, 0x698E, 0x698F, 0x6990, 0x6991, 0x6992,
  0x6993, 0x6996, 0x6997, 0x6999, 0x699A,
  // [ 13244, 13253] -> [0x699D,0x69A6] # seg 183
  // [ 13254, 13294] -v # seg 184 at pos 10313
  0x69A9, 0x69AA, 0x69AC, 0x69AE, 0x69AF, 0x69B0, 0x69B2, 0x69B3,
  0x69B5, 0x69B6, 0x69B8, 0x69B9, 0x69BA, 0x69BC, 0x69BD, 0x69BE,
  0x69BF, 0x69C0, 0x69C2, 0x69C3, 0x69C4, 0x69C5, 0x69C6, 0x69C7,
  0x69C8, 0x69C9, 0x69CB, 0x69CD, 0x69CF, 0x69D1, 0x69D2, 0x69D3,
  0x69D5, 0x69D6, 0x69D7, 0x69D8, 0x69D9, 0x69DA, 0x69DC, 0x69DD,
  0x69DE,
  // [ 13295, 13306] -> [0x69E1,0x69EC] # seg 185
  // [ 13307, 13310] -> [0x69EE,0x69F1] # seg 186
  // [ 13311, 13320] -> [0x69F3,0x69FC] # seg 187
  // [ 13321, 13321] -> [0x69FE,0x69FE] # seg 188
  // [ 13322, 13331] -> [0x6A00,0x6A09] # seg 189
  // [ 13332, 13343] -> [0x6A0B,0x6A16] # seg 190
  // [ 13344, 13403] -v # seg 191 at pos 10354
  0x6A19, 0x6A1A, 0x6A1B, 0x6A1C, 0x6A1D, 0x6A1E, 0x6A20, 0x6A22,
  0x6A23, 0x6A24, 0x6A25, 0x6A26, 0x6A27, 0x6A29, 0x6A2B, 0x6A2C,
  0x6A2D, 0x6A2E, 0x6A30, 0x6A32, 0x6A33, 0x6A34, 0x6A36, 0x6A37,
  0x6A38, 0x6A39, 0x6A3A, 0x6A3B, 0x6A3C, 0x6A3F, 0x6A40, 0x6A41,
  0x6A42, 0x6A43, 0x6A45, 0x6A46, 0x6A48, 0x6A49, 0x6A4A, 0x6A4B,
  0x6A4C, 0x6A4D, 0x6A4E, 0x6A4F, 0x6A51, 0x6A52, 0x6A53, 0x6A54,
  0x6A55, 0x6A56, 0x6A57, 0x6A5A, 0x6A5C, 0x6A5D, 0x6A5E, 0x6A5F,
  0x6A60, 0x6A62, 0x6A63, 0x6A64,
  // [ 13404, 13414] -> [0x6A66,0x6A70] # seg 192
  // [ 13415, 13429] -v # seg 193 at pos 10414
  0x6A72, 0x6A73, 0x6A74, 0x6A75, 0x6A76, 0x6A77, 0x6A78, 0x6A7A,
  0x6A7B, 0x6A7D, 0x6A7E, 0x6A7F, 0x6A81, 0x6A82, 0x6A83,
  // [ 13430, 13438] -> [0x6A85,0x6A8D] # seg 194
  // [ 13439, 13461] -v # seg 195 at pos 10429
  0x6A8F, 0x6A92, 0x6A93, 0x6A94, 0x6A95, 0x6A96, 0x6A98, 0x6A99,
  0x6A9A, 0x6A9B, 0x6A9C, 0x6A9D, 0x6A9E, 0x6A9F, 0x6AA1, 0x6AA2,
  0x6AA3, 0x6AA4, 0x6AA5, 0x6AA6, 0x6AA7, 0x6AA8, 0x6AAA,
  // [ 13462, 13576] -> [0x6AAD,0x6B1F] # seg 196
  // [ 13577, 13578] -> [0x6B25,0x6B26] # seg 197
  // [ 13579, 13588] -> [0x6B28,0x6B31] # seg 198
  // [ 13589, 13605] -v # seg 199 at pos 10452
  0x6B33, 0x6B34, 0x6B35, 0x6B36, 0x6B38, 0x6B3B, 0x6B3C, 0x6B3D,
  0x6B3F, 0x6B40, 0x6B41, 0x6B42, 0x6B44, 0x6B45, 0x6B48, 0x6B4A,
  0x6B4B,
  // [ 13606, 13617] -> [0x6B4D,0x6B58] # seg 200
  // [ 13618, 13625] -> [0x6B5A,0x6B61] # seg 201
  // [ 13626, 13627] -> [0x6B68,0x6B69] # seg 202
  // [ 13628, 13641] -> [0x6B6B,0x6B78] # seg 203
  // [ 13642, 14058] -v # seg 204 at pos 10469
  0x6B7A, 0x6B7D, 0x6B7E, 0x6B7F, 0x6B80, 0x6B85, 0x6B88, 0x6B8C,
  0x6B8E, 0x6B8F, 0x6B90, 0x6B91, 0x6B94, 0x6B95, 0x6B97, 0x6B98,
  0x6B99, 0x6B9C, 0x6B9D, 0x6B9E, 0x6B9F, 0x6BA0, 0x6BA2, 0x6BA3,
  0x6BA4, 0x6BA5, 0x6BA6, 0x6BA7, 0x6BA8, 0x6BA9, 0x6BAB, 0x6BAC,
  0x6BAD, 0x6BAE, 0x6BAF, 0x6BB0, 0x6BB1, 0x6BB2, 0x6BB6, 0x6BB8,
  0x6BB9, 0x6BBA, 0x6BBB, 0x6BBC, 0x6BBD, 0x6BBE, 0x6BC0, 0x6BC3,
  0x6BC4, 0x6BC6, 0x6BC7, 0x6BC8, 0x6BC9, 0x6BCA, 0x6BCC, 0x6BCE,
  0x6BD0, 0x6BD1, 0x6BD8, 0x6BDA, 0x6BDC, 0x6BDD, 0x6BDE, 0x6BDF,
  0x6BE0, 0x6BE2, 0x6BE3, 0x6BE4, 0x6BE5, 0x6BE6, 0x6BE7, 0x6BE8,
  0x6BE9, 0x6BEC, 0x6BED, 0x6BEE, 0x6BF0, 0x6BF1, 0x6BF2, 0x6BF4,
  0x6BF6, 0x6BF7, 0x6BF8, 0x6BFA, 0x6BFB, 0x6BFC, 0x6BFE, 0x6BFF,
  0x6C00, 0x6C01, 0x6C02, 0x6C03, 0x6C04, 0x6C08, 0x6C09, 0x6C0A,
  0x6C0B, 0x6C0C, 0x6C0E, 0x6C12, 0x6C17, 0x6C1C, 0x6C1D, 0x6C1E,
  0x6C20, 0x6C23, 0x6C25, 0x6C2B, 0x6C2C, 0x6C2D, 0x6C31, 0x6C33,
  0x6C36, 0x6C37, 0x6C39, 0x6C3A, 0x6C3B, 0x6C3C, 0x6C3E, 0x6C3F,
  0x6C43, 0x6C44, 0x6C45, 0x6C48, 0x6C4B, 0x6C4C, 0x6C4D, 0x6C4E,
  0x6C4F, 0x6C51, 0x6C52, 0x6C53, 0x6C56, 0x6C58, 0x6C59, 0x6C5A,
  0x6C62, 0x6C63, 0x6C65, 0x6C66, 0x6C67, 0x6C6B, 0x6C6C, 0x6C6D,
  0x6C6E, 0x6C6F, 0x6C71, 0x6C73, 0x6C75, 0x6C77, 0x6C78, 0x6C7A,
  0x6C7B, 0x6C7C, 0x6C7F, 0x6C80, 0x6C84, 0x6C87, 0x6C8A, 0x6C8B,
  0x6C8D, 0x6C8E, 0x6C91, 0x6C92, 0x6C95, 0x6C96, 0x6C97, 0x6C98,
  0x6C9A, 0x6C9C, 0x6C9D, 0x6C9E, 0x6CA0, 0x6CA2, 0x6CA8, 0x6CAC,
  0x6CAF, 0x6CB0, 0x6CB4, 0x6CB5, 0x6CB6, 0x6CB7, 0x6CBA, 0x6CC0,
  0x6CC1, 0x6CC2, 0x6CC3, 0x6CC6, 0x6CC7, 0x6CC8, 0x6CCB, 0x6CCD,
  0x6CCE, 0x6CCF, 0x6CD1, 0x6CD2, 0x6CD8, 0x6CD9, 0x6CDA, 0x6CDC,
  0x6CDD, 0x6CDF, 0x6CE4, 0x6CE6, 0x6CE7, 0x6CE9, 0x6CEC, 0x6CED,
  0x6CF2, 0x6CF4, 0x6CF9, 0x6CFF, 0x6D00, 0x6D02, 0x6D03, 0x6D05,
  0x6D06, 0x6D08, 0x6D09, 0x6D0A, 0x6D0D, 0x6D0F, 0x6D10, 0x6D11,
  0x6D13, 0x6D14, 0x6D15, 0x6D16, 0x6D18, 0x6D1C, 0x6D1D, 0x6D1F,
  0x6D20, 0x6D21, 0x6D22, 0x6D23, 0x6D24, 0x6D26, 0x6D28, 0x6D29,
  0x6D2C, 0x6D2D, 0x6D2F, 0x6D30, 0x6D34, 0x6D36, 0x6D37, 0x6D38,
  0x6D3A, 0x6D3F, 0x6D40, 0x6D42, 0x6D44, 0x6D49, 0x6D4C, 0x6D50,
  0x6D55, 0x6D56, 0x6D57, 0x6D58, 0x6D5B, 0x6D5D, 0x6D5F, 0x6D61,
  0x6D62, 0x6D64, 0x6D65, 0x6D67, 0x6D68, 0x6D6B, 0x6D6C, 0x6D6D,
  0x6D70, 0x6D71, 0x6D72, 0x6D73, 0x6D75, 0x6D76, 0x6D79, 0x6D7A,
  0x6D7B, 0x6D7D, 0x6D7E, 0x6D7F, 0x6D80, 0x6D81, 0x6D83, 0x6D84,
  0x6D86, 0x6D87, 0x6D8A, 0x6D8B, 0x6D8D, 0x6D8F, 0x6D90, 0x6D92,
  0x6D96, 0x6D97, 0x6D98, 0x6D99, 0x6D9A, 0x6D9C, 0x6DA2, 0x6DA5,
  0x6DAC, 0x6DAD, 0x6DB0, 0x6DB1, 0x6DB3, 0x6DB4, 0x6DB6, 0x6DB7,
  0x6DB9, 0x6DBA, 0x6DBB, 0x6DBC, 0x6DBD, 0x6DBE, 0x6DC1, 0x6DC2,
  0x6DC3, 0x6DC8, 0x6DC9, 0x6DCA, 0x6DCD, 0x6DCE, 0x6DCF, 0x6DD0,
  0x6DD2, 0x6DD3, 0x6DD4, 0x6DD5, 0x6DD7, 0x6DDA, 0x6DDB, 0x6DDC,
  0x6DDF, 0x6DE2, 0x6DE3, 0x6DE5, 0x6DE7, 0x6DE8, 0x6DE9, 0x6DEA,
  0x6DED, 0x6DEF, 0x6DF0, 0x6DF2, 0x6DF4, 0x6DF5, 0x6DF6, 0x6DF8,
  0x6DFA, 0x6DFD, 0x6DFE, 0x6DFF, 0x6E00, 0x6E01, 0x6E02, 0x6E03,
  0x6E04, 0x6E06, 0x6E07, 0x6E08, 0x6E09, 0x6E0B, 0x6E0F, 0x6E12,
  0x6E13, 0x6E15, 0x6E18, 0x6E19, 0x6E1B, 0x6E1C, 0x6E1E, 0x6E1F,
  0x6E22, 0x6E26, 0x6E27, 0x6E28, 0x6E2A, 0x6E2C, 0x6E2E, 0x6E30,
  0x6E31, 0x6E33, 0x6E35, 0x6E36, 0x6E37, 0x6E39, 0x6E3B, 0x6E3C,
  0x6E3D, 0x6E3E, 0x6E3F, 0x6E40, 0x6E41, 0x6E42, 0x6E45, 0x6E46,
  0x6E47, 0x6E48, 0x6E49, 0x6E4A, 0x6E4B, 0x6E4C, 0x6E4F, 0x6E50,
  0x6E51, 0x6E52, 0x6E55, 0x6E57, 0x6E59, 0x6E5A, 0x6E5C, 0x6E5D,
  0x6E5E,
  // [ 14059, 14069] -> [0x6E60,0x6E6A] # seg 205
  // [ 14070, 14071] -> [0x6E6C,0x6E6D] # seg 206
  // [ 14072, 14086] -> [0x6E6F,0x6E7D] # seg 207
  // [ 14087, 14149] -v # seg 208 at pos 10886
  0x6E80, 0x6E81, 0x6E82, 0x6E84, 0x6E87, 0x6E88, 0x6E8A, 0x6E8B,
  0x6E8C, 0x6E8D, 0x6E8E, 0x6E91, 0x6E92, 0x6E93, 0x6E94, 0x6E95,
  0x6E96, 0x6E97, 0x6E99, 0x6E9A, 0x6E9B, 0x6E9D, 0x6E9E, 0x6EA0,
  0x6EA1, 0x6EA3, 0x6EA4, 0x6EA6, 0x6EA8, 0x6EA9, 0x6EAB, 0x6EAC,
  0x6EAD, 0x6EAE, 0x6EB0, 0x6EB3, 0x6EB5, 0x6EB8, 0x6EB9, 0x6EBC,
  0x6EBE, 0x6EBF, 0x6EC0, 0x6EC3, 0x6EC4, 0x6EC5, 0x6EC6, 0x6EC8,
  0x6EC9, 0x6ECA, 0x6ECC, 0x6ECD, 0x6ECE, 0x6ED0, 0x6ED2, 0x6ED6,
  0x6ED8, 0x6ED9, 0x6EDB, 0x6EDC, 0x6EDD, 0x6EE3, 0x6EE7,
  // [ 14150, 14159] -> [0x6EEA,0x6EF3] # seg 209
  // [ 14160, 14184] -v # seg 210 at pos 10949
  0x6EF5, 0x6EF6, 0x6EF7, 0x6EF8, 0x6EFA, 0x6EFB, 0x6EFC, 0x6EFD,
  0x6EFE, 0x6EFF, 0x6F00, 0x6F01, 0x6F03, 0x6F04, 0x6F05, 0x6F07,
  0x6F08, 0x6F0A, 0x6F0B, 0x6F0C, 0x6F0D, 0x6F0E, 0x6F10, 0x6F11,
  0x6F12,
  // [ 14185, 14194] -> [0x6F16,0x6F1F] # seg 211
  // [ 14195, 14225] -v # seg 212 at pos 10974
  0x6F21, 0x6F22, 0x6F23, 0x6F25, 0x6F26, 0x6F27, 0x6F28, 0x6F2C,
  0x6F2E, 0x6F30, 0x6F32, 0x6F34, 0x6F35, 0x6F37, 0x6F38, 0x6F39,
  0x6F3A, 0x6F3B, 0x6F3C, 0x6F3D, 0x6F3F, 0x6F40, 0x6F41, 0x6F42,
  0x6F43, 0x6F44, 0x6F45, 0x6F48, 0x6F49, 0x6F4A, 0x6F4C,
  // [ 14226, 14235] -> [0x6F4E,0x6F57] # seg 213
  // [ 14236, 14272] -v # seg 214 at pos 11005
  0x6F59, 0x6F5A, 0x6F5B, 0x6F5D, 0x6F5F, 0x6F60, 0x6F61, 0x6F63,
  0x6F64, 0x6F65, 0x6F67, 0x6F68, 0x6F69, 0x6F6A, 0x6F6B, 0x6F6C,
  0x6F6F, 0x6F70, 0x6F71, 0x6F73, 0x6F75, 0x6F76, 0x6F77, 0x6F79,
  0x6F7B, 0x6F7D, 0x6F7E, 0x6F7F, 0x6F80, 0x6F81, 0x6F82, 0x6F83,
  0x6F85, 0x6F86, 0x6F87, 0x6F8A, 0x6F8B,
  // [ 14273, 14285] -> [0x6F8F,0x6F9B] # seg 215
  // [ 14286, 14294] -v # seg 216 at pos 11042
  0x6F9D, 0x6F9E, 0x6F9F, 0x6FA0, 0x6FA2, 0x6FA3, 0x6FA4, 0x6FA5,
  0x6FA6,
  // [ 14295, 14305] -> [0x6FA8,0x6FB2] # seg 217
  // [ 14306, 14329] -v # seg 218 at pos 11051
  0x6FB4, 0x6FB5, 0x6FB7, 0x6FB8, 0x6FBA, 0x6FBB, 0x6FBC, 0x6FBD,
  0x6FBE, 0x6FBF, 0x6FC1, 0x6FC3, 0x6FC4, 0x6FC5, 0x6FC6, 0x6FC7,
  0x6FC8, 0x6FCA, 0x6FCB, 0x6FCC, 0x6FCD, 0x6FCE, 0x6FCF, 0x6FD0,
  // [ 14330, 14340] -> [0x6FD3,0x6FDD] # seg 219
  // [ 14341, 14341] -> [0x6FDF,0x6FDF] # seg 220
  // [ 14342, 14353] -> [0x6FE2,0x6FED] # seg 221
  // [ 14354, 14386] -> [0x6FF0,0x7010] # seg 222
  // [ 14387, 14394] -> [0x7012,0x7019] # seg 223
  // [ 14395, 14401] -> [0x701C,0x7022] # seg 224
  // [ 14402, 14418] -> [0x7024,0x7034] # seg 225
  // [ 14419, 14421] -> [0x7036,0x7038] # seg 226
  // [ 14422, 14439] -> [0x703A,0x704B] # seg 227
  // [ 14440, 14441] -> [0x704D,0x704E] # seg 228
  // [ 14442, 14455] -> [0x7050,0x705D] # seg 229
  // [ 14456, 14467] -> [0x705F,0x706A] # seg 230
  // [ 14468, 14495] -v # seg 231 at pos 11075
  0x706E, 0x7071, 0x7072, 0x7073, 0x7074, 0x7077, 0x7079, 0x707A,
  0x707B, 0x707D, 0x7081, 0x7082, 0x7083, 0x7084, 0x7086, 0x7087,
  0x7088, 0x708B, 0x708C, 0x708D, 0x708F, 0x7090, 0x7091, 0x7093,
  0x7097, 0x7098, 0x709A, 0x709B,
  // [ 14496, 14508] -> [0x709E,0x70AA] # seg 232
  // [ 14509, 14521] -v # seg 233 at pos 11103
  0x70B0, 0x70B2, 0x70B4, 0x70B5, 0x70B6, 0x70BA, 0x70BE, 0x70BF,
  0x70C4, 0x70C5, 0x70C6, 0x70C7, 0x70C9,
  // [ 14522, 14534] -> [0x70CB,0x70D7] # seg 234
  // [ 14535, 14556] -v # seg 235 at pos 11116
  0x70DA, 0x70DC, 0x70DD, 0x70DE, 0x70E0, 0x70E1, 0x70E2, 0x70E3,
  0x70E5, 0x70EA, 0x70EE, 0x70F0, 0x70F1, 0x70F2, 0x70F3, 0x70F4,
  0x70F5, 0x70F6, 0x70F8, 0x70FA, 0x70FB, 0x70FC,
  // [ 14557, 14567] -> [0x70FE,0x7108] # seg 236
  // [ 14568, 14576] -v # seg 237 at pos 11138
  0x710B, 0x710C, 0x710D, 0x710E, 0x710F, 0x7111, 0x7112, 0x7114,
  0x7117,
  // [ 14577, 14587] -> [0x711B,0x7125] # seg 238
  // [ 14588, 14595] -> [0x7127,0x712E] # seg 239
  // [ 14596, 14599] -> [0x7132,0x7135] # seg 240
  // [ 14600, 14613] -> [0x7137,0x7144] # seg 241
  // [ 14614, 14619] -v # seg 242 at pos 11147
  0x7146, 0x7147, 0x7148, 0x7149, 0x714B, 0x714D,
  // [ 14620, 14632] -> [0x714F,0x715B] # seg 243
  // [ 14633, 14701] -v # seg 244 at pos 11153
  0x715D, 0x715F, 0x7160, 0x7161, 0x7162, 0x7163, 0x7165, 0x7169,
  0x716A, 0x716B, 0x716C, 0x716D, 0x716F, 0x7170, 0x7171, 0x7174,
  0x7175, 0x7176, 0x7177, 0x7179, 0x717B, 0x717C, 0x717E, 0x717F,
  0x7180, 0x7181, 0x7182, 0x7183, 0x7185, 0x7186, 0x7187, 0x7188,
  0x7189, 0x718B, 0x718C, 0x718D, 0x718E, 0x7190, 0x7191, 0x7192,
  0x7193, 0x7195, 0x7196, 0x7197, 0x719A, 0x719B, 0x719C, 0x719D,
  0x719E, 0x71A1, 0x71A2, 0x71A3, 0x71A4, 0x71A5, 0x71A6, 0x71A7,
  0x71A9, 0x71AA, 0x71AB, 0x71AD, 0x71AE, 0x71AF, 0x71B0, 0x71B1,
  0x71B2, 0x71B4, 0x71B6, 0x71B7, 0x71B8,
  // [ 14702, 14710] -> [0x71BA,0x71C2] # seg 245
  // [ 14711, 14720] -> [0x71C4,0x71CD] # seg 246
  // [ 14721, 14725] -> [0x71CF,0x71D3] # seg 247
  // [ 14726, 14735] -> [0x71D6,0x71DF] # seg 248
  // [ 14736, 14746] -v # seg 249 at pos 11222
  0x71E1, 0x71E2, 0x71E3, 0x71E4, 0x71E6, 0x71E8, 0x71E9, 0x71EA,
  0x71EB, 0x71EC, 0x71ED,
  // [ 14747, 14756] -> [0x71EF,0x71F8] # seg 250
  // [ 14757, 14768] -> [0x71FA,0x7205] # seg 251
  // [ 14769, 14790] -> [0x7207,0x721C] # seg 252
  // [ 14791, 14800] -> [0x721E,0x7227] # seg 253
  // [ 14801, 14863] -v # seg 254 at pos 11233
  0x7229, 0x722B, 0x722D, 0x722E, 0x722F, 0x7232, 0x7233, 0x7234,
  0x723A, 0x723C, 0x723E, 0x7240, 0x7241, 0x7242, 0x7243, 0x7244,
  0x7245, 0x7246, 0x7249, 0x724A, 0x724B, 0x724E, 0x724F, 0x7250,
  0x7251, 0x7253, 0x7254, 0x7255, 0x7257, 0x7258, 0x725A, 0x725C,
  0x725E, 0x7260, 0x7263, 0x7264, 0x7265, 0x7268, 0x726A, 0x726B,
  0x726C, 0x726D, 0x7270, 0x7271, 0x7273, 0x7274, 0x7276, 0x7277,
  0x7278, 0x727B, 0x727C, 0x727D, 0x7282, 0x7283, 0x7285, 0x7286,
  0x7287, 0x7288, 0x7289, 0x728C, 0x728E, 0x7290, 0x7291,
  // [ 14864, 14875] -> [0x7293,0x729E] # seg 255
  // [ 14876, 14887] -> [0x72A0,0x72AB] # seg 256
  // [ 14888, 14915] -v # seg 257 at pos 11296
  0x72AE, 0x72B1, 0x72B2, 0x72B3, 0x72B5, 0x72BA, 0x72BB, 0x72BC,
  0x72BD, 0x72BE, 0x72BF, 0x72C0, 0x72C5, 0x72C6, 0x72C7, 0x72C9,
  0x72CA, 0x72CB, 0x72CC, 0x72CF, 0x72D1, 0x72D3, 0x72D4, 0x72D5,
  0x72D6, 0x72D8, 0x72DA, 0x72DB,
  // [ 14916, 15587] -> [0xE4C6,0xE765] # seg 258
  // [ 15588, 15607] -v # seg 259 at pos 11324
  0x02CA, 0x02CB, 0x02D9, 0x2013, 0x2015, 0x2025, 0x2035, 0x2105,
  0x2109, 0x2196, 0x2197, 0x2198, 0x2199, 0x2215, 0x221F, 0x2223,
  0x2252, 0x2266, 0x2267, 0x22BF,
  // [ 15608, 15643] -> [0x2550,0x2573] # seg 260
  // [ 15644, 15658] -> [0x2581,0x258F] # seg 261
  // [ 15659, 15672] -v # seg 262 at pos 11344
  0x2593, 0x2594, 0x2595, 0x25BC, 0x25BD, 0x25E2, 0x25E3, 0x25E4,
  0x25E5, 0x2609, 0x2295, 0x3012, 0x301D, 0x301E,
  // [ 15673, 15683] -> [0xE7BC,0xE7C6] # seg 263
  // [ 15684, 15692] -> [0x3021,0x3029] # seg 264
  // [ 15693, 15723] -v # seg 265 at pos 11358
  0x32A3, 0x338E, 0x338F, 0x339C, 0x339D, 0x339E, 0x33A1, 0x33C4,
  0x33CE, 0x33D1, 0x33D2, 0x33D5, 0xFE30, 0xFFE2, 0xFFE4, 0xE7E2,
  0x2121, 0x3231, 0xE7E3, 0x2010, 0xE7E4, 0xE7E5, 0xE7E6, 0x30FC,
  0x309B, 0x309C, 0x30FD, 0x30FE, 0x3006, 0x309D, 0x309E,
  // [ 15724, 15733] -> [0xFE49,0xFE52] # seg 266
  // [ 15734, 15737] -> [0xFE54,0xFE57] # seg 267
  // [ 15738, 15751] -> [0xFE59,0xFE66] # seg 268
  // [ 15752, 15756] -v # seg 269 at pos 11389
  0xFE68, 0xFE69, 0xFE6A, 0xFE6B, 0x303E,
  // [ 15757, 15768] -> [0x2FF0,0x2FFB] # seg 270
  // [ 15769, 15769] -> [0x3007,0x3007] # seg 271
  // [ 15770, 15779] -> [0xE7F4,0xE7FD] # seg 272
  // [ 15780, 15833] -v # seg 273 at pos 11394
  0x72DC, 0x72DD, 0x72DF, 0x72E2, 0x72E3, 0x72E4, 0x72E5, 0x72E6,
  0x72E7, 0x72EA, 0x72EB, 0x72F5, 0x72F6, 0x72F9, 0x72FD, 0x72FE,
  0x72FF, 0x7300, 0x7302, 0x7304, 0x7305, 0x7306, 0x7307, 0x7308,
  0x7309, 0x730B, 0x730C, 0x730D, 0x730F, 0x7310, 0x7311, 0x7312,
  0x7314, 0x7318, 0x7319, 0x731A, 0x731F, 0x7320, 0x7323, 0x7324,
  0x7326, 0x7327, 0x7328, 0x732D, 0x732F, 0x7330, 0x7332, 0x7333,
  0x7335, 0x7336, 0x733A, 0x733B, 0x733C, 0x733D,
  // [ 15834, 15846] -> [0x7340,0x734C] # seg 274
  // [ 15847, 15861] -v # seg 275 at pos 11448
  0x734E, 0x734F, 0x7351, 0x7353, 0x7354, 0x7355, 0x7356, 0x7358,
  0x7359, 0x735A, 0x735B, 0x735C, 0x735D, 0x735E, 0x735F,
  // [ 15862, 15872] -> [0x7361,0x736B] # seg 276
  // [ 15873, 15873] -> [0x736E,0x736E] # seg 277
  // [ 15874, 15887] -> [0x7370,0x737D] # seg 278
  // [ 15888, 15966] -v # seg 279 at pos 11463
  0x737F, 0x7380, 0x7381, 0x7382, 0x7383, 0x7385, 0x7386, 0x7388,
  0x738A, 0x738C, 0x738D, 0x738F, 0x7390, 0x7392, 0x7393, 0x7394,
  0x7395, 0x7397, 0x7398, 0x7399, 0x739A, 0x739C, 0x739D, 0x739E,
  0x73A0, 0x73A1, 0x73A3, 0x73A4, 0x73A5, 0x73A6, 0x73A7, 0x73A8,
  0x73AA, 0x73AC, 0x73AD, 0x73B1, 0x73B4, 0x73B5, 0x73B6, 0x73B8,
  0x73B9, 0x73BC, 0x73BD, 0x73BE, 0x73BF, 0x73C1, 0x73C3, 0x73C4,
  0x73C5, 0x73C6, 0x73C7, 0x73CB, 0x73CC, 0x73CE, 0x73D2, 0x73D3,
  0x73D4, 0x73D5, 0x73D6, 0x73D7, 0x73D8, 0x73DA, 0x73DB, 0x73DC,
  0x73DD, 0x73DF, 0x73E1, 0x73E2, 0x73E3, 0x73E4, 0x73E6, 0x73E8,
  0x73EA, 0x73EB, 0x73EC, 0x73EE, 0x73EF, 0x73F0, 0x73F1,
  // [ 15967, 15982] -> [0x73F3,0x7402] # seg 280
  // [ 15983, 15989] -v # seg 281 at pos 11542
  0x7404, 0x7407, 0x7408, 0x740B, 0x740C, 0x740D, 0x740E,
  // [ 15990, 15998] -> [0x7411,0x7419] # seg 282
  // [ 15999, 16022] -v # seg 283 at pos 11549
  0x741C, 0x741D, 0x741E, 0x741F, 0x7420, 0x7421, 0x7423, 0x7424,
  0x7427, 0x7429, 0x742B, 0x742D, 0x742F, 0x7431, 0x7432, 0x7437,
  0x7438, 0x7439, 0x743A, 0x743B, 0x743D, 0x743E, 0x743F, 0x7440,
  // [ 16023, 16041] -> [0x7442,0x7454] # seg 284
  // [ 16042, 16044] -v # seg 285 at pos 11573
  0x7456, 0x7458, 0x745D,
  // [ 16045, 16057] -> [0x7460,0x746C] # seg 286
  // [ 16058, 16081] -v # seg 287 at pos 11576
  0x746E, 0x746F, 0x7471, 0x7472, 0x7473, 0x7474, 0x7475, 0x7478,
  0x7479, 0x747A, 0x747B, 0x747C, 0x747D, 0x747F, 0x7482, 0x7484,
  0x7485, 0x7486, 0x7488, 0x7489, 0x748A, 0x748C, 0x748D, 0x748F,
  // [ 16082, 16092] -> [0x7491,0x749B] # seg 288
  // [ 16093, 16101] -v # seg 289 at pos 11600
  0x749D, 0x749F, 0x74A0, 0x74A1, 0x74A2, 0x74A3, 0x74A4, 0x74A5,
  0x74A6,
  // [ 16102, 16117] -> [0x74AA,0x74B9] # seg 290
  // [ 16118, 16140] -> [0x74BB,0x74D1] # seg 291
  // [ 16141, 16149] -> [0x74D3,0x74DB] # seg 292
  // [ 16150, 16416] -v # seg 293 at pos 11609
  0x74DD, 0x74DF, 0x74E1, 0x74E5, 0x74E7, 0x74E8, 0x74E9, 0x74EA,
  0x74EB, 0x74EC, 0x74ED, 0x74F0, 0x74F1, 0x74F2, 0x74F3, 0x74F5,
  0x74F8, 0x74F9, 0x74FA, 0x74FB, 0x74FC, 0x74FD, 0x74FE, 0x7500,
  0x7501, 0x7502, 0x7503, 0x7505, 0x7506, 0x7507, 0x7508, 0x7509,
  0x750A, 0x750B, 0x750C, 0x750E, 0x7510, 0x7512, 0x7514, 0x7515,
  0x7516, 0x7517, 0x751B, 0x751D, 0x751E, 0x7520, 0x7521, 0x7522,
  0x7523, 0x7524, 0x7526, 0x7527, 0x752A, 0x752E, 0x7534, 0x7536,
  0x7539, 0x753C, 0x753D, 0x753F, 0x7541, 0x7542, 0x7543, 0x7544,
  0x7546, 0x7547, 0x7549, 0x754A, 0x754D, 0x7550, 0x7551, 0x7552,
  0x7553, 0x7555, 0x7556, 0x7557, 0x7558, 0x755D, 0x755E, 0x755F,
  0x7560, 0x7561, 0x7562, 0x7563, 0x7564, 0x7567, 0x7568, 0x7569,
  0x756B, 0x756C, 0x756D, 0x756E, 0x756F, 0x7570, 0x7571, 0x7573,
  0x7575, 0x7576, 0x7577, 0x757A, 0x757B, 0x757C, 0x757D, 0x757E,
  0x7580, 0x7581, 0x7582, 0x7584, 0x7585, 0x7587, 0x7588, 0x7589,
  0x758A, 0x758C, 0x758D, 0x758E, 0x7590, 0x7593, 0x7595, 0x7598,
  0x759B, 0x759C, 0x759E, 0x75A2, 0x75A6, 0x75A7, 0x75A8, 0x75A9,
  0x75AA, 0x75AD, 0x75B6, 0x75B7, 0x75BA, 0x75BB, 0x75BF, 0x75C0,
  0x75C1, 0x75C6, 0x75CB, 0x75CC, 0x75CE, 0x75CF, 0x75D0, 0x75D1,
  0x75D3, 0x75D7, 0x75D9, 0x75DA, 0x75DC, 0x75DD, 0x75DF, 0x75E0,
  0x75E1, 0x75E5, 0x75E9, 0x75EC, 0x75ED, 0x75EE, 0x75EF, 0x75F2,
  0x75F3, 0x75F5, 0x75F6, 0x75F7, 0x75F8, 0x75FA, 0x75FB, 0x75FD,
  0x75FE, 0x7602, 0x7604, 0x7606, 0x7607, 0x7608, 0x7609, 0x760B,
  0x760D, 0x760E, 0x760F, 0x7611, 0x7612, 0x7613, 0x7614, 0x7616,
  0x761A, 0x761C, 0x761D, 0x761E, 0x7621, 0x7623, 0x7627, 0x7628,
  0x762C, 0x762E, 0x762F, 0x7631, 0x7632, 0x7636, 0x7637, 0x7639,
  0x763A, 0x763B, 0x763D, 0x7641, 0x7642, 0x7644, 0x7645, 0x7646,
  0x7647, 0x7648, 0x7649, 0x764A, 0x764B, 0x764E, 0x764F, 0x7650,
  0x7651, 0x7652, 0x7653, 0x7655, 0x7657, 0x7658, 0x7659, 0x765A,
  0x765B, 0x765D, 0x765F, 0x7660, 0x7661, 0x7662, 0x7664, 0x7665,
  0x7666, 0x7667, 0x7668, 0x7669, 0x766A, 0x766C, 0x766D, 0x766E,
  0x7670, 0x7671, 0x7672, 0x7673, 0x7674, 0x7675, 0x7676, 0x7677,
  0x7679, 0x767A, 0x767C, 0x767F, 0x7680, 0x7681, 0x7683, 0x7685,
  0x7689, 0x768A, 0x768C, 0x768D, 0x768F, 0x7690, 0x7692, 0x7694,
  0x7695, 0x7697, 0x7698,
  // [ 16417, 16426] -> [0x769A,0x76A3] # seg 294
  // [ 16427, 16435] -> [0x76A5,0x76AD] # seg 295
  // [ 16436, 16438] -v # seg 296 at pos 11876
  0x76AF, 0x76B0, 0x76B3,
  // [ 16439, 16448] -> [0x76B5,0x76BE] # seg 297
  // [ 16449, 16492] -v # seg 298 at pos 11879
  0x76C0, 0x76C1, 0x76C3, 0x76C4, 0x76C7, 0x76C9, 0x76CB, 0x76CC,
  0x76D3, 0x76D5, 0x76D9, 0x76DA, 0x76DC, 0x76DD, 0x76DE, 0x76E0,
  0x76E1, 0x76E2, 0x76E3, 0x76E4, 0x76E6, 0x76E7, 0x76E8, 0x76E9,
  0x76EA, 0x76EB, 0x76EC, 0x76ED, 0x76F0, 0x76F3, 0x76F5, 0x76F6,
  0x76F7, 0x76FA, 0x76FB, 0x76FD, 0x76FF, 0x7700, 0x7702, 0x7703,
  0x7705, 0x7706, 0x770A, 0x770C,
  // [ 16493, 16503] -> [0x770E,0x7718] # seg 299
  // [ 16504, 16555] -v # seg 300 at pos 11923
  0x771B, 0x771C, 0x771D, 0x771E, 0x7721, 0x7723, 0x7724, 0x7725,
  0x7727, 0x772A, 0x772B, 0x772C, 0x772E, 0x7730, 0x7731, 0x7732,
  0x7733, 0x7734, 0x7739, 0x773B, 0x773D, 0x773E, 0x773F, 0x7742,
  0x7744, 0x7745, 0x7746, 0x7748, 0x7749, 0x774A, 0x774B, 0x774C,
  0x774D, 0x774E, 0x774F, 0x7752, 0x7753, 0x7754, 0x7755, 0x7756,
  0x7757, 0x7758, 0x7759, 0x775C, 0x775D, 0x775E, 0x775F, 0x7760,
  0x7764, 0x7767, 0x7769, 0x776A,
  // [ 16556, 16567] -> [0x776D,0x7778] # seg 301
  // [ 16568, 16581] -v # seg 302 at pos 11975
  0x777A, 0x777B, 0x777C, 0x7781, 0x7782, 0x7783, 0x7786, 0x7787,
  0x7788, 0x7789, 0x778A, 0x778B, 0x778F, 0x7790,
  // [ 16582, 16593] -> [0x7793,0x779E] # seg 303
  // [ 16594, 16612] -v # seg 304 at pos 11989
  0x77A1, 0x77A3, 0x77A4, 0x77A6, 0x77A8, 0x77AB, 0x77AD, 0x77AE,
  0x77AF, 0x77B1, 0x77B2, 0x77B4, 0x77B6, 0x77B7, 0x77B8, 0x77B9,
  0x77BA, 0x77BC, 0x77BE,
  // [ 16613, 16625] -> [0x77C0,0x77CC] # seg 305
  // [ 16626, 16634] -> [0x77CE,0x77D6] # seg 306
  // [ 16635, 16708] -v # seg 307 at pos 12008
  0x77D8, 0x77D9, 0x77DA, 0x77DD, 0x77DE, 0x77DF, 0x77E0, 0x77E1,
  0x77E4, 0x77E6, 0x77E8, 0x77EA, 0x77EF, 0x77F0, 0x77F1, 0x77F2,
  0x77F4, 0x77F5, 0x77F7, 0x77F9, 0x77FA, 0x77FB, 0x77FC, 0x7803,
  0x7804, 0x7805, 0x7806, 0x7807, 0x7808, 0x780A, 0x780B, 0x780E,
  0x780F, 0x7810, 0x7813, 0x7815, 0x7819, 0x781B, 0x781E, 0x7820,
  0x7821, 0x7822, 0x7824, 0x7828, 0x782A, 0x782B, 0x782E, 0x782F,
  0x7831, 0x7832, 0x7833, 0x7835, 0x7836, 0x783D, 0x783F, 0x7841,
  0x7842, 0x7843, 0x7844, 0x7846, 0x7848, 0x7849, 0x784A, 0x784B,
  0x784D, 0x784F, 0x7851, 0x7853, 0x7854, 0x7858, 0x7859, 0x785A,
  0x785B, 0x785C,
  // [ 16709, 16720] -> [0x785E,0x7869] # seg 308
  // [ 16721, 16728] -> [0x786F,0x7876] # seg 309
  // [ 16729, 16732] -> [0x7878,0x787B] # seg 310
  // [ 16733, 16742] -> [0x787D,0x7886] # seg 311
  // [ 16743, 16792] -v # seg 312 at pos 12082
  0x7888, 0x788A, 0x788B, 0x788F, 0x7890, 0x7892, 0x7894, 0x7895,
  0x7896, 0x7899, 0x789D, 0x789E, 0x78A0, 0x78A2, 0x78A4, 0x78A6,
  0x78A8, 0x78A9, 0x78AA, 0x78AB, 0x78AC, 0x78AD, 0x78AE, 0x78AF,
  0x78B5, 0x78B6, 0x78B7, 0x78B8, 0x78BA, 0x78BB, 0x78BC, 0x78BD,
  0x78BF, 0x78C0, 0x78C2, 0x78C3, 0x78C4, 0x78C6, 0x78C7, 0x78C8,
  0x78CC, 0x78CD, 0x78CE, 0x78CF, 0x78D1, 0x78D2, 0x78D3, 0x78D6,
  0x78D7, 0x78D8,
  // [ 16793, 16806] -> [0x78DA,0x78E7] # seg 313
  // [ 16807, 16828] -v # seg 314 at pos 12132
  0x78E9, 0x78EA, 0x78EB, 0x78ED, 0x78EE, 0x78EF, 0x78F0, 0x78F1,
  0x78F3, 0x78F5, 0x78F6, 0x78F8, 0x78F9, 0x78FB, 0x78FC, 0x78FD,
  0x78FE, 0x78FF, 0x7900, 0x7902, 0x7903, 0x7904,
  // [ 16829, 16841] -> [0x7906,0x7912] # seg 315
  // [ 16842, 16851] -> [0x7914,0x791D] # seg 316
  // [ 16852, 16856] -> [0x791F,0x7923] # seg 317
  // [ 16857, 16871] -> [0x7925,0x7933] # seg 318
  // [ 16872, 16883] -v # seg 319 at pos 12154
  0x7935, 0x7936, 0x7937, 0x7938, 0x7939, 0x793D, 0x793F, 0x7942,
  0x7943, 0x7944, 0x7945, 0x7947,
  // [ 16884, 16892] -> [0x794A,0x7952] # seg 320
  // [ 16893, 16928] -v # seg 321 at pos 12166
  0x7954, 0x7955, 0x7958, 0x7959, 0x7961, 0x7963, 0x7964, 0x7966,
  0x7969, 0x796A, 0x796B, 0x796C, 0x796E, 0x7970, 0x7971, 0x7972,
  0x7973, 0x7974, 0x7975, 0x7976, 0x7979, 0x797B, 0x797C, 0x797D,
  0x797E, 0x797F, 0x7982, 0x7983, 0x7986, 0x7987, 0x7988, 0x7989,
  0x798B, 0x798C, 0x798D, 0x798E,
  // [ 16929, 16938] -> [0x7990,0x7999] # seg 322
  // [ 16939, 16950] -> [0x799B,0x79A6] # seg 323
  // [ 16951, 16961] -> [0x79A8,0x79B2] # seg 324
  // [ 16962, 17031] -v # seg 325 at pos 12202
  0x79B4, 0x79B5, 0x79B6, 0x79B7, 0x79B8, 0x79BC, 0x79BF, 0x79C2,
  0x79C4, 0x79C5, 0x79C7, 0x79C8, 0x79CA, 0x79CC, 0x79CE, 0x79CF,
  0x79D0, 0x79D3, 0x79D4, 0x79D6, 0x79D7, 0x79D9, 0x79DA, 0x79DB,
  0x79DC, 0x79DD, 0x79DE, 0x79E0, 0x79E1, 0x79E2, 0x79E5, 0x79E8,
  0x79EA, 0x79EC, 0x79EE, 0x79F1, 0x79F2, 0x79F3, 0x79F4, 0x79F5,
  0x79F6, 0x79F7, 0x79F9, 0x79FA, 0x79FC, 0x79FE, 0x79FF, 0x7A01,
  0x7A04, 0x7A05, 0x7A07, 0x7A08, 0x7A09, 0x7A0A, 0x7A0C, 0x7A0F,
  0x7A10, 0x7A11, 0x7A12, 0x7A13, 0x7A15, 0x7A16, 0x7A18, 0x7A19,
  0x7A1B, 0x7A1C, 0x7A1D, 0x7A1F, 0x7A21, 0x7A22,
  // [ 17032, 17046] -> [0x7A24,0x7A32] # seg 326
  // [ 17047, 17058] -v # seg 327 at pos 12272
  0x7A34, 0x7A35, 0x7A36, 0x7A38, 0x7A3A, 0x7A3E, 0x7A40, 0x7A41,
  0x7A42, 0x7A43, 0x7A44, 0x7A45,
  // [ 17059, 17068] -> [0x7A47,0x7A50] # seg 328
  // [ 17069, 17073] -> [0x7A52,0x7A56] # seg 329
  // [ 17074, 17097] -> [0x7A58,0x7A6F] # seg 330
  // [ 17098, 17134] -v # seg 331 at pos 12284
  0x7A71, 0x7A72, 0x7A73, 0x7A75, 0x7A7B, 0x7A7C, 0x7A7D, 0x7A7E,
  0x7A82, 0x7A85, 0x7A87, 0x7A89, 0x7A8A, 0x7A8B, 0x7A8C, 0x7A8E,
  0x7A8F, 0x7A90, 0x7A93, 0x7A94, 0x7A99, 0x7A9A, 0x7A9B, 0x7A9E,
  0x7AA1, 0x7AA2, 0x7AA3, 0x7AA4, 0x7AA7, 0x7AA9, 0x7AAA, 0x7AAB,
  0x7AAE, 0x7AAF, 0x7AB0, 0x7AB1, 0x7AB2,
  // [ 17135, 17145] -> [0x7AB4,0x7ABE] # seg 332
  // [ 17146, 17156] -> [0x7AC0,0x7ACA] # seg 333
  // [ 17157, 17166] -> [0x7ACC,0x7AD5] # seg 334
  // [ 17167, 17182] -v # seg 335 at pos 12321
  0x7AD7, 0x7AD8, 0x7ADA, 0x7ADB, 0x7ADC, 0x7ADD, 0x7AE1, 0x7AE2,
  0x7AE4, 0x7AE7, 0x7AE8, 0x7AE9, 0x7AEA, 0x7AEB, 0x7AEC, 0x7AEE,
  // [ 17183, 17191] -> [0x7AF0,0x7AF8] # seg 336
  // [ 17192, 17248] -v # seg 337 at pos 12337
  0x7AFB, 0x7AFC, 0x7AFE, 0x7B00, 0x7B01, 0x7B02, 0x7B05, 0x7B07,
  0x7B09, 0x7B0C, 0x7B0D, 0x7B0E, 0x7B10, 0x7B12, 0x7B13, 0x7B16,
  0x7B17, 0x7B18, 0x7B1A, 0x7B1C, 0x7B1D, 0x7B1F, 0x7B21, 0x7B22,
  0x7B23, 0x7B27, 0x7B29, 0x7B2D, 0x7B2F, 0x7B30, 0x7B32, 0x7B34,
  0x7B35, 0x7B36, 0x7B37, 0x7B39, 0x7B3B, 0x7B3D, 0x7B3F, 0x7B40,
  0x7B41, 0x7B42, 0x7B43, 0x7B44, 0x7B46, 0x7B48, 0x7B4A, 0x7B4D,
  0x7B4E, 0x7B53, 0x7B55, 0x7B57, 0x7B59, 0x7B5C, 0x7B5E, 0x7B5F,
  0x7B61,
  // [ 17249, 17259] -> [0x7B63,0x7B6D] # seg 338
  // [ 17260, 17391] -v # seg 339 at pos 12394
  0x7B6F, 0x7B70, 0x7B73, 0x7B74, 0x7B76, 0x7B78, 0x7B7A, 0x7B7C,
  0x7B7D, 0x7B7F, 0x7B81, 0x7B82, 0x7B83, 0x7B84, 0x7B86, 0x7B87,
  0x7B88, 0x7B89, 0x7B8A, 0x7B8B, 0x7B8C, 0x7B8E, 0x7B8F, 0x7B91,
  0x7B92, 0x7B93, 0x7B96, 0x7B98, 0x7B99, 0x7B9A, 0x7B9B, 0x7B9E,
  0x7B9F, 0x7BA0, 0x7BA3, 0x7BA4, 0x7BA5, 0x7BAE, 0x7BAF, 0x7BB0,
  0x7BB2, 0x7BB3, 0x7BB5, 0x7BB6, 0x7BB7, 0x7BB9, 0x7BBA, 0x7BBB,
  0x7BBC, 0x7BBD, 0x7BBE, 0x7BBF, 0x7BC0, 0x7BC2, 0x7BC3, 0x7BC4,
  0x7BC5, 0x7BC8, 0x7BC9, 0x7BCA, 0x7BCB, 0x7BCD, 0x7BCE, 0x7BCF,
  0x7BD0, 0x7BD2, 0x7BD4, 0x7BD5, 0x7BD6, 0x7BD7, 0x7BD8, 0x7BDB,
  0x7BDC, 0x7BDE, 0x7BDF, 0x7BE0, 0x7BE2, 0x7BE3, 0x7BE4, 0x7BE7,
  0x7BE8, 0x7BE9, 0x7BEB, 0x7BEC, 0x7BED, 0x7BEF, 0x7BF0, 0x7BF2,
  0x7BF3, 0x7BF4, 0x7BF5, 0x7BF6, 0x7BF8, 0x7BF9, 0x7BFA, 0x7BFB,
  0x7BFD, 0x7BFF, 0x7C00, 0x7C01, 0x7C02, 0x7C03, 0x7C04, 0x7C05,
  0x7C06, 0x7C08, 0x7C09, 0x7C0A, 0x7C0D, 0x7C0E, 0x7C10, 0x7C11,
  0x7C12, 0x7C13, 0x7C14, 0x7C15, 0x7C17, 0x7C18, 0x7C19, 0x7C1A,
  0x7C1B, 0x7C1C, 0x7C1D, 0x7C1E, 0x7C20, 0x7C21, 0x7C22, 0x7C23,
  0x7C24, 0x7C25, 0x7C28, 0x7C29,
  // [ 17392, 17404] -> [0x7C2B,0x7C37] # seg 340
  // [ 17405, 17410] -> [0x7C39,0x7C3E] # seg 341
  // [ 17411, 17421] -> [0x7C42,0x7C4C] # seg 342
  // [ 17422, 17458] -> [0x7C4E,0x7C72] # seg 343
  // [ 17459, 17464] -> [0x7C75,0x7C7A] # seg 344
  // [ 17465, 17475] -> [0x7C7E,0x7C88] # seg 345
  // [ 17476, 17550] -v # seg 346 at pos 12526
  0x7C8A, 0x7C8B, 0x7C8C, 0x7C8D, 0x7C8E, 0x7C8F, 0x7C90, 0x7C93,
  0x7C94, 0x7C96, 0x7C99, 0x7C9A, 0x7C9B, 0x7CA0, 0x7CA1, 0x7CA3,
  0x7CA6, 0x7CA7, 0x7CA8, 0x7CA9, 0x7CAB, 0x7CAC, 0x7CAD, 0x7CAF,
  0x7CB0, 0x7CB4, 0x7CB5, 0x7CB6, 0x7CB7, 0x7CB8, 0x7CBA, 0x7CBB,
  0x7CBF, 0x7CC0, 0x7CC2, 0x7CC3, 0x7CC4, 0x7CC6, 0x7CC9, 0x7CCB,
  0x7CCE, 0x7CCF, 0x7CD0, 0x7CD1, 0x7CD2, 0x7CD3, 0x7CD4, 0x7CD8,
  0x7CDA, 0x7CDB, 0x7CDD, 0x7CDE, 0x7CE1, 0x7CE2, 0x7CE3, 0x7CE4,
  0x7CE5, 0x7CE6, 0x7CE7, 0x7CE9, 0x7CEA, 0x7CEB, 0x7CEC, 0x7CED,
  0x7CEE, 0x7CF0, 0x7CF1, 0x7CF2, 0x7CF3, 0x7CF4, 0x7CF5, 0x7CF6,
  0x7CF7, 0x7CF9, 0x7CFA,
  // [ 17551, 17564] -> [0x7CFC,0x7D09] # seg 347
  // [ 17565, 17585] -> [0x7D0B,0x7D1F] # seg 348
  // [ 17586, 17596] -v # seg 349 at pos 12601
  0x7D21, 0x7D23, 0x7D24, 0x7D25, 0x7D26, 0x7D28, 0x7D29, 0x7D2A,
  0x7D2C, 0x7D2D, 0x7D2E,
  // [ 17597, 17658] -> [0x7D30,0x7D6D] # seg 350
  // [ 17659, 17666] -> [0x7D6F,0x7D76] # seg 351
  // [ 17667, 17712] -> [0x7D78,0x7DA5] # seg 352
  // [ 17713, 17719] -> [0x7DA7,0x7DAD] # seg 353
  // [ 17720, 17859] -> [0x7DAF,0x7E3A] # seg 354
  // [ 17860, 17869] -v # seg 355 at pos 12612
  0x7E3C, 0x7E3D, 0x7E3E, 0x7E3F, 0x7E40, 0x7E42, 0x7E43, 0x7E44,
  0x7E45, 0x7E46,
  // [ 17870, 17927] -> [0x7E48,0x7E81] # seg 356
  // [ 17928, 17951] -> [0x7E83,0x7E9A] # seg 357
  // [ 17952, 17975] -v # seg 358 at pos 12622
  0x7E9C, 0x7E9D, 0x7E9E, 0x7EAE, 0x7EB4, 0x7EBB, 0x7EBC, 0x7ED6,
  0x7EE4, 0x7EEC, 0x7EF9, 0x7F0A, 0x7F10, 0x7F1E, 0x7F37, 0x7F39,
  0x7F3B, 0x7F3C, 0x7F3D, 0x7F3E, 0x7F3F, 0x7F40, 0x7F41, 0x7F43,
  // [ 17976, 17985] -> [0x7F46,0x7F4F] # seg 359
  // [ 17986, 18147] -v # seg 360 at pos 12646
  0x7F52, 0x7F53, 0x7F56, 0x7F59, 0x7F5B, 0x7F5C, 0x7F5D, 0x7F5E,
  0x7F60, 0x7F63, 0x7F64, 0x7F65, 0x7F66, 0x7F67, 0x7F6B, 0x7F6C,
  0x7F6D, 0x7F6F, 0x7F70, 0x7F73, 0x7F75, 0x7F76, 0x7F77, 0x7F78,
  0x7F7A, 0x7F7B, 0x7F7C, 0x7F7D, 0x7F7F, 0x7F80, 0x7F82, 0x7F83,
  0x7F84, 0x7F85, 0x7F86, 0x7F87, 0x7F88, 0x7F89, 0x7F8B, 0x7F8D,
  0x7F8F, 0x7F90, 0x7F91, 0x7F92, 0x7F93, 0x7F95, 0x7F96, 0x7F97,
  0x7F98, 0x7F99, 0x7F9B, 0x7F9C, 0x7FA0, 0x7FA2, 0x7FA3, 0x7FA5,
  0x7FA6, 0x7FA8, 0x7FA9, 0x7FAA, 0x7FAB, 0x7FAC, 0x7FAD, 0x7FAE,
  0x7FB1, 0x7FB3, 0x7FB4, 0x7FB5, 0x7FB6, 0x7FB7, 0x7FBA, 0x7FBB,
  0x7FBE, 0x7FC0, 0x7FC2, 0x7FC3, 0x7FC4, 0x7FC6, 0x7FC7, 0x7FC8,
  0x7FC9, 0x7FCB, 0x7FCD, 0x7FCF, 0x7FD0, 0x7FD1, 0x7FD2, 0x7FD3,
  0x7FD6, 0x7FD7, 0x7FD9, 0x7FDA, 0x7FDB, 0x7FDC, 0x7FDD, 0x7FDE,
  0x7FE2, 0x7FE3, 0x7FE4, 0x7FE7, 0x7FE8, 0x7FEA, 0x7FEB, 0x7FEC,
  0x7FED, 0x7FEF, 0x7FF2, 0x7FF4, 0x7FF5, 0x7FF6, 0x7FF7, 0x7FF8,
  0x7FF9, 0x7FFA, 0x7FFD, 0x7FFE, 0x7FFF, 0x8002, 0x8007, 0x8008,
  0x8009, 0x800A, 0x800E, 0x800F, 0x8011, 0x8013, 0x801A, 0x801B,
  0x801D, 0x801E, 0x801F, 0x8021, 0x8023, 0x8024, 0x802B, 0x802C,
  0x802D, 0x802E, 0x802F, 0x8030, 0x8032, 0x8034, 0x8039, 0x803A,
  0x803C, 0x803E, 0x8040, 0x8041, 0x8044, 0x8045, 0x8047, 0x8048,
  0x8049, 0x804E, 0x804F, 0x8050, 0x8051, 0x8053, 0x8055, 0x8056,
  0x8057, 0x8059,
  // [ 18148, 18161] -> [0x805B,0x8068] # seg 361
  // [ 18162, 18167] -> [0x806B,0x8070] # seg 362
  // [ 18168, 18180] -> [0x8072,0x807E] # seg 363
  // [ 18181, 18249] -v # seg 364 at pos 12808
  0x8081, 0x8082, 0x8085, 0x8088, 0x808A, 0x808D, 0x808E, 0x808F,
  0x8090, 0x8091, 0x8092, 0x8094, 0x8095, 0x8097, 0x8099, 0x809E,
  0x80A3, 0x80A6, 0x80A7, 0x80A8, 0x80AC, 0x80B0, 0x80B3, 0x80B5,
  0x80B6, 0x80B8, 0x80B9, 0x80BB, 0x80C5, 0x80C7, 0x80C8, 0x80C9,
  0x80CA, 0x80CB, 0x80CF, 0x80D0, 0x80D1, 0x80D2, 0x80D3, 0x80D4,
  0x80D5, 0x80D8, 0x80DF, 0x80E0, 0x80E2, 0x80E3, 0x80E6, 0x80EE,
  0x80F5, 0x80F7, 0x80F9, 0x80FB, 0x80FE, 0x80FF, 0x8100, 0x8101,
  0x8103, 0x8104, 0x8105, 0x8107, 0x8108, 0x810B, 0x810C, 0x8115,
  0x8117, 0x8119, 0x811B, 0x811C, 0x811D,
  // [ 18250, 18262] -> [0x811F,0x812B] # seg 365
  // [ 18263, 18364] -v # seg 366 at pos 12877
  0x812D, 0x812E, 0x8130, 0x8133, 0x8134, 0x8135, 0x8137, 0x8139,
  0x813A, 0x813B, 0x813C, 0x813D, 0x813F, 0x8140, 0x8141, 0x8142,
  0x8143, 0x8144, 0x8145, 0x8147, 0x8149, 0x814D, 0x814E, 0x814F,
  0x8152, 0x8156, 0x8157, 0x8158, 0x815B, 0x815C, 0x815D, 0x815E,
  0x815F, 0x8161, 0x8162, 0x8163, 0x8164, 0x8166, 0x8168, 0x816A,
  0x816B, 0x816C, 0x816F, 0x8172, 0x8173, 0x8175, 0x8176, 0x8177,
  0x8178, 0x8181, 0x8183, 0x8184, 0x8185, 0x8186, 0x8187, 0x8189,
  0x818B, 0x818C, 0x818D, 0x818E, 0x8190, 0x8192, 0x8193, 0x8194,
  0x8195, 0x8196, 0x8197, 0x8199, 0x819A, 0x819E, 0x819F, 0x81A0,
  0x81A1, 0x81A2, 0x81A4, 0x81A5, 0x81A7, 0x81A9, 0x81AB, 0x81AC,
  0x81AD, 0x81AE, 0x81AF, 0x81B0, 0x81B1, 0x81B2, 0x81B4, 0x81B5,
  0x81B6, 0x81B7, 0x81B8, 0x81B9, 0x81BC, 0x81BD, 0x81BE, 0x81BF,
  0x81C4, 0x81C5, 0x81C7, 0x81C8, 0x81C9, 0x81CB,
  // [ 18365, 18386] -> [0x81CD,0x81E2] # seg 367
  // [ 18387, 18545] -v # seg 368 at pos 12979
  0x81E4, 0x81E5, 0x81E6, 0x81E8, 0x81E9, 0x81EB, 0x81EE, 0x81EF,
  0x81F0, 0x81F1, 0x81F2, 0x81F5, 0x81F6, 0x81F7, 0x81F8, 0x81F9,
  0x81FA, 0x81FD, 0x81FF, 0x8203, 0x8207, 0x8208, 0x8209, 0x820A,
  0x820B, 0x820E, 0x820F, 0x8211, 0x8213, 0x8215, 0x8216, 0x8217,
  0x8218, 0x8219, 0x821A, 0x821D, 0x8220, 0x8224, 0x8225, 0x8226,
  0x8227, 0x8229, 0x822E, 0x8232, 0x823A, 0x823C, 0x823D, 0x823F,
  0x8240, 0x8241, 0x8242, 0x8243, 0x8245, 0x8246, 0x8248, 0x824A,
  0x824C, 0x824D, 0x824E, 0x8250, 0x8251, 0x8252, 0x8253, 0x8254,
  0x8255, 0x8256, 0x8257, 0x8259, 0x825B, 0x825C, 0x825D, 0x825E,
  0x8260, 0x8261, 0x8262, 0x8263, 0x8264, 0x8265, 0x8266, 0x8267,
  0x8269, 0x826A, 0x826B, 0x826C, 0x826D, 0x8271, 0x8275, 0x8276,
  0x8277, 0x8278, 0x827B, 0x827C, 0x8280, 0x8281, 0x8283, 0x8285,
  0x8286, 0x8287, 0x8289, 0x828C, 0x8290, 0x8293, 0x8294, 0x8295,
  0x8296, 0x829A, 0x829B, 0x829E, 0x82A0, 0x82A2, 0x82A3, 0x82A7,
  0x82B2, 0x82B5, 0x82B6, 0x82BA, 0x82BB, 0x82BC, 0x82BF, 0x82C0,
  0x82C2, 0x82C3, 0x82C5, 0x82C6, 0x82C9, 0x82D0, 0x82D6, 0x82D9,
  0x82DA, 0x82DD, 0x82E2, 0x82E7, 0x82E8, 0x82E9, 0x82EA, 0x82EC,
  0x82ED, 0x82EE, 0x82F0, 0x82F2, 0x82F3, 0x82F5, 0x82F6, 0x82F8,
  0x82FA, 0x82FC, 0x82FD, 0x82FE, 0x82FF, 0x8300, 0x830A, 0x830B,
  0x830D, 0x8310, 0x8312, 0x8313, 0x8316, 0x8318, 0x8319,
  // [ 18546, 18555] -> [0x831D,0x8326] # seg 369
  // [ 18556, 18719] -v # seg 370 at pos 13138
  0x8329, 0x832A, 0x832E, 0x8330, 0x8332, 0x8337, 0x833B, 0x833D,
  0x833E, 0x833F, 0x8341, 0x8342, 0x8344, 0x8345, 0x8348, 0x834A,
  0x834B, 0x834C, 0x834D, 0x834E, 0x8353, 0x8355, 0x8356, 0x8357,
  0x8358, 0x8359, 0x835D, 0x8362, 0x8370, 0x8371, 0x8372, 0x8373,
  0x8374, 0x8375, 0x8376, 0x8379, 0x837A, 0x837E, 0x837F, 0x8380,
  0x8381, 0x8382, 0x8383, 0x8384, 0x8387, 0x8388, 0x838A, 0x838B,
  0x838C, 0x838D, 0x838F, 0x8390, 0x8391, 0x8394, 0x8395, 0x8396,
  0x8397, 0x8399, 0x839A, 0x839D, 0x839F, 0x83A1, 0x83A2, 0x83A3,
  0x83A4, 0x83A5, 0x83A6, 0x83A7, 0x83AC, 0x83AD, 0x83AE, 0x83AF,
  0x83B5, 0x83BB, 0x83BE, 0x83BF, 0x83C2, 0x83C3, 0x83C4, 0x83C6,
  0x83C8, 0x83C9, 0x83CB, 0x83CD, 0x83CE, 0x83D0, 0x83D1, 0x83D2,
  0x83D3, 0x83D5, 0x83D7, 0x83D9, 0x83DA, 0x83DB, 0x83DE, 0x83E2,
  0x83E3, 0x83E4, 0x83E6, 0x83E7, 0x83E8, 0x83EB, 0x83EC, 0x83ED,
  0x83EE, 0x83EF, 0x83F3, 0x83F4, 0x83F5, 0x83F6, 0x83F7, 0x83FA,
  0x83FB, 0x83FC, 0x83FE, 0x83FF, 0x8400, 0x8402, 0x8405, 0x8407,
  0x8408, 0x8409, 0x840A, 0x8410, 0x8412, 0x8413, 0x8414, 0x8415,
  0x8416, 0x8417, 0x8419, 0x841A, 0x841B, 0x841E, 0x841F, 0x8420,
  0x8421, 0x8422, 0x8423, 0x8429, 0x842A, 0x842B, 0x842C, 0x842D,
  0x842E, 0x842F, 0x8430, 0x8432, 0x8433, 0x8434, 0x8435, 0x8436,
  0x8437, 0x8439, 0x843A, 0x843B, 0x843E, 0x843F, 0x8440, 0x8441,
  0x8442, 0x8443, 0x8444, 0x8445,
  // [ 18720, 18729] -> [0x8447,0x8450] # seg 371
  // [ 18730, 18781] -v # seg 372 at pos 13302
  0x8452, 0x8453, 0x8454, 0x8455, 0x8456, 0x8458, 0x845D, 0x845E,
  0x845F, 0x8460, 0x8462, 0x8464, 0x8465, 0x8466, 0x8467, 0x8468,
  0x846A, 0x846E, 0x846F, 0x8470, 0x8472, 0x8474, 0x8477, 0x8479,
  0x847B, 0x847C, 0x847D, 0x847E, 0x847F, 0x8480, 0x8481, 0x8483,
  0x8484, 0x8485, 0x8486, 0x848A, 0x848D, 0x848F, 0x8490, 0x8491,
  0x8492, 0x8493, 0x8494, 0x8495, 0x8496, 0x8498, 0x849A, 0x849B,
  0x849D, 0x849E, 0x849F, 0x84A0,
  // [ 18782, 18794] -> [0x84A2,0x84AE] # seg 373
  // [ 18795, 18835] -v # seg 374 at pos 13354
  0x84B0, 0x84B1, 0x84B3, 0x84B5, 0x84B6, 0x84B7, 0x84BB, 0x84BC,
  0x84BE, 0x84C0, 0x84C2, 0x84C3, 0x84C5, 0x84C6, 0x84C7, 0x84C8,
  0x84CB, 0x84CC, 0x84CE, 0x84CF, 0x84D2, 0x84D4, 0x84D5, 0x84D7,
  0x84D8, 0x84D9, 0x84DA, 0x84DB, 0x84DC, 0x84DE, 0x84E1, 0x84E2,
  0x84E4, 0x84E7, 0x84E8, 0x84E9, 0x84EA, 0x84EB, 0x84ED, 0x84EE,
  0x84EF,
  // [ 18836, 18846] -> [0x84F1,0x84FB] # seg 375
  // [ 18847, 18848] -> [0x84FD,0x84FE] # seg 376
  // [ 18849, 18860] -> [0x8500,0x850B] # seg 377
  // [ 18861, 18875] -v # seg 378 at pos 13395
  0x850D, 0x850E, 0x850F, 0x8510, 0x8512, 0x8514, 0x8515, 0x8516,
  0x8518, 0x8519, 0x851B, 0x851C, 0x851D, 0x851E, 0x8520,
  // [ 18876, 18884] -> [0x8522,0x852A] # seg 379
  // [ 18885, 18894] -> [0x852D,0x8536] # seg 380
  // [ 18895, 18903] -v # seg 381 at pos 13410
  0x853E, 0x853F, 0x8540, 0x8541, 0x8542, 0x8544, 0x8545, 0x8546,
  0x8547,
  // [ 18904, 18914] -> [0x854B,0x8555] # seg 382
  // [ 18915, 18928] -v # seg 383 at pos 13419
  0x8557, 0x8558, 0x855A, 0x855B, 0x855C, 0x855D, 0x855F, 0x8560,
  0x8561, 0x8562, 0x8563, 0x8565, 0x8566, 0x8567,
  // [ 18929, 18937] -> [0x8569,0x8571] # seg 384
  // [ 18938, 18957] -v # seg 385 at pos 13433
  0x8573, 0x8575, 0x8576, 0x8577, 0x8578, 0x857C, 0x857D, 0x857F,
  0x8580, 0x8581, 0x8582, 0x8583, 0x8586, 0x8588, 0x8589, 0x858A,
  0x858B, 0x858C, 0x858D, 0x858E,
  // [ 18958, 18968] -> [0x8590,0x859A] # seg 386
  // [ 18969, 19028] -v # seg 387 at pos 13453
  0x859D, 0x859E, 0x859F, 0x85A0, 0x85A1, 0x85A2, 0x85A3, 0x85A5,
  0x85A6, 0x85A7, 0x85A9, 0x85AB, 0x85AC, 0x85AD, 0x85B1, 0x85B2,
  0x85B3, 0x85B4, 0x85B5, 0x85B6, 0x85B8, 0x85BA, 0x85BB, 0x85BC,
  0x85BD, 0x85BE, 0x85BF, 0x85C0, 0x85C2, 0x85C3, 0x85C4, 0x85C5,
  0x85C6, 0x85C7, 0x85C8, 0x85CA, 0x85CB, 0x85CC, 0x85CD, 0x85CE,
  0x85D1, 0x85D2, 0x85D4, 0x85D6, 0x85D7, 0x85D8, 0x85D9, 0x85DA,
  0x85DB, 0x85DD, 0x85DE, 0x85DF, 0x85E0, 0x85E1, 0x85E2, 0x85E3,
  0x85E5, 0x85E6, 0x85E7, 0x85E8,
  // [ 19029, 19045] -> [0x85EA,0x85FA] # seg 388
  // [ 19046, 19053] -v # seg 389 at pos 13513
  0x85FC, 0x85FD, 0x85FE, 0x8600, 0x8601, 0x8602, 0x8603, 0x8604,
  // [ 19054, 19064] -> [0x8606,0x8610] # seg 390
  // [ 19065, 19068] -> [0x8612,0x8615] # seg 391
  // [ 19069, 19084] -> [0x8617,0x8626] # seg 392
  // [ 19085, 19085] -> [0x8628,0x8628] # seg 393
  // [ 19086, 19099] -> [0x862A,0x8637] # seg 394
  // [ 19100, 19102] -> [0x8639,0x863B] # seg 395
  // [ 19103, 19118] -> [0x863D,0x864C] # seg 396
  // [ 19119, 19384] -v # seg 397 at pos 13521
  0x8652, 0x8653, 0x8655, 0x8656, 0x8657, 0x8658, 0x8659, 0x865B,
  0x865C, 0x865D, 0x865F, 0x8660, 0x8661, 0x8663, 0x8664, 0x8665,
  0x8666, 0x8667, 0x8668, 0x8669, 0x866A, 0x866D, 0x866F, 0x8670,
  0x8672, 0x8673, 0x8674, 0x8675, 0x8676, 0x8677, 0x8678, 0x8683,
  0x8684, 0x8685, 0x8686, 0x8687, 0x8688, 0x8689, 0x868E, 0x868F,
  0x8690, 0x8691, 0x8692, 0x8694, 0x8696, 0x8697, 0x8698, 0x8699,
  0x869A, 0x869B, 0x869E, 0x869F, 0x86A0, 0x86A1, 0x86A2, 0x86A5,
  0x86A6, 0x86AB, 0x86AD, 0x86AE, 0x86B2, 0x86B3, 0x86B7, 0x86B8,
  0x86B9, 0x86BB, 0x86BC, 0x86BD, 0x86BE, 0x86BF, 0x86C1, 0x86C2,
  0x86C3, 0x86C5, 0x86C8, 0x86CC, 0x86CD, 0x86D2, 0x86D3, 0x86D5,
  0x86D6, 0x86D7, 0x86DA, 0x86DC, 0x86DD, 0x86E0, 0x86E1, 0x86E2,
  0x86E3, 0x86E5, 0x86E6, 0x86E7, 0x86E8, 0x86EA, 0x86EB, 0x86EC,
  0x86EF, 0x86F5, 0x86F6, 0x86F7, 0x86FA, 0x86FB, 0x86FC, 0x86FD,
  0x86FF, 0x8701, 0x8704, 0x8705, 0x8706, 0x870B, 0x870C, 0x870E,
  0x870F, 0x8710, 0x8711, 0x8714, 0x8716, 0x8719, 0x871B, 0x871D,
  0x871F, 0x8720, 0x8724, 0x8726, 0x8727, 0x8728, 0x872A, 0x872B,
  0x872C, 0x872D, 0x872F, 0x8730, 0x8732, 0x8733, 0x8735, 0x8736,
  0x8738, 0x8739, 0x873A, 0x873C, 0x873D, 0x8740, 0x8741, 0x8742,
  0x8743, 0x8744, 0x8745, 0x8746, 0x874A, 0x874B, 0x874D, 0x874F,
  0x8750, 0x8751, 0x8752, 0x8754, 0x8755, 0x8756, 0x8758, 0x875A,
  0x875B, 0x875C, 0x875D, 0x875E, 0x875F, 0x8761, 0x8762, 0x8766,
  0x8767, 0x8768, 0x8769, 0x876A, 0x876B, 0x876C, 0x876D, 0x876F,
  0x8771, 0x8772, 0x8773, 0x8775, 0x8777, 0x8778, 0x8779, 0x877A,
  0x877F, 0x8780, 0x8781, 0x8784, 0x8786, 0x8787, 0x8789, 0x878A,
  0x878C, 0x878E, 0x878F, 0x8790, 0x8791, 0x8792, 0x8794, 0x8795,
  0x8796, 0x8798, 0x8799, 0x879A, 0x879B, 0x879C, 0x879D, 0x879E,
  0x87A0, 0x87A1, 0x87A2, 0x87A3, 0x87A4, 0x87A5, 0x87A6, 0x87A7,
  0x87A9, 0x87AA, 0x87AE, 0x87B0, 0x87B1, 0x87B2, 0x87B4, 0x87B6,
  0x87B7, 0x87B8, 0x87B9, 0x87BB, 0x87BC, 0x87BE, 0x87BF, 0x87C1,
  0x87C2, 0x87C3, 0x87C4, 0x87C5, 0x87C7, 0x87C8, 0x87C9, 0x87CC,
  0x87CD, 0x87CE, 0x87CF, 0x87D0, 0x87D4, 0x87D5, 0x87D6, 0x87D7,
  0x87D8, 0x87D9, 0x87DA, 0x87DC, 0x87DD, 0x87DE, 0x87DF, 0x87E1,
  0x87E2, 0x87E3, 0x87E4, 0x87E6, 0x87E7, 0x87E8, 0x87E9, 0x87EB,
  0x87EC, 0x87ED,
  // [ 19385, 19394] -> [0x87EF,0x87F8] # seg 398
  // [ 19395, 19426] -v # seg 399 at pos 13787
  0x87FA, 0x87FB, 0x87FC, 0x87FD, 0x87FF, 0x8800, 0x8801, 0x8802,
  0x8804, 0x8805, 0x8806, 0x8807, 0x8808, 0x8809, 0x880B, 0x880C,
  0x880D, 0x880E, 0x880F, 0x8810, 0x8811, 0x8812, 0x8814, 0x8817,
  0x8818, 0x8819, 0x881A, 0x881C, 0x881D, 0x881E, 0x881F, 0x8820,
  // [ 19427, 19441] -> [0x8823,0x8831] # seg 400
  // [ 19442, 19618] -v # seg 401 at pos 13819
  0x8833, 0x8834, 0x8835, 0x8836, 0x8837, 0x8838, 0x883A, 0x883B,
  0x883D, 0x883E, 0x883F, 0x8841, 0x8842, 0x8843, 0x8846, 0x8847,
  0x8848, 0x8849, 0x884A, 0x884B, 0x884E, 0x884F, 0x8850, 0x8851,
  0x8852, 0x8853, 0x8855, 0x8856, 0x8858, 0x885A, 0x885B, 0x885C,
  0x885D, 0x885E, 0x885F, 0x8860, 0x8866, 0x8867, 0x886A, 0x886D,
  0x886F, 0x8871, 0x8873, 0x8874, 0x8875, 0x8876, 0x8878, 0x8879,
  0x887A, 0x887B, 0x887C, 0x8880, 0x8883, 0x8886, 0x8887, 0x8889,
  0x888A, 0x888C, 0x888E, 0x888F, 0x8890, 0x8891, 0x8893, 0x8894,
  0x8895, 0x8897, 0x8898, 0x8899, 0x889A, 0x889B, 0x889D, 0x889E,
  0x889F, 0x88A0, 0x88A1, 0x88A3, 0x88A5, 0x88A6, 0x88A7, 0x88A8,
  0x88A9, 0x88AA, 0x88AC, 0x88AE, 0x88AF, 0x88B0, 0x88B2, 0x88B3,
  0x88B4, 0x88B5, 0x88B6, 0x88B8, 0x88B9, 0x88BA, 0x88BB, 0x88BD,
  0x88BE, 0x88BF, 0x88C0, 0x88C3, 0x88C4, 0x88C7, 0x88C8, 0x88CA,
  0x88CB, 0x88CC, 0x88CD, 0x88CF, 0x88D0, 0x88D1, 0x88D3, 0x88D6,
  0x88D7, 0x88DA, 0x88DB, 0x88DC, 0x88DD, 0x88DE, 0x88E0, 0x88E1,
  0x88E6, 0x88E7, 0x88E9, 0x88EA, 0x88EB, 0x88EC, 0x88ED, 0x88EE,
  0x88EF, 0x88F2, 0x88F5, 0x88F6, 0x88F7, 0x88FA, 0x88FB, 0x88FD,
  0x88FF, 0x8900, 0x8901, 0x8903, 0x8904, 0x8905, 0x8906, 0x8907,
  0x8908, 0x8909, 0x890B, 0x890C, 0x890D, 0x890E, 0x890F, 0x8911,
  0x8914, 0x8915, 0x8916, 0x8917, 0x8918, 0x891C, 0x891D, 0x891E,
  0x891F, 0x8920, 0x8922, 0x8923, 0x8924, 0x8926, 0x8927, 0x8928,
  0x8929, 0x892C, 0x892D, 0x892E, 0x892F, 0x8931, 0x8932, 0x8933,
  0x8935,
  // [ 19619, 19628] -> [0x8937,0x8940] # seg 402
  // [ 19629, 19630] -> [0x8942,0x8943] # seg 403
  // [ 19631, 19655] -> [0x8945,0x895D] # seg 404
  // [ 19656, 19661] -> [0x8960,0x8965] # seg 405
  // [ 19662, 19681] -> [0x8967,0x897A] # seg 406
  // [ 19682, 19688] -v # seg 407 at pos 13996
  0x897C, 0x897D, 0x897E, 0x8980, 0x8982, 0x8984, 0x8985,
  // [ 19689, 19746] -> [0x8987,0x89C0] # seg 408
  // [ 19747, 19771] -v # seg 409 at pos 14003
  0x89C3, 0x89CD, 0x89D3, 0x89D4, 0x89D5, 0x89D7, 0x89D8, 0x89D9,
  0x89DB, 0x89DD, 0x89DF, 0x89E0, 0x89E1, 0x89E2, 0x89E4, 0x89E7,
  0x89E8, 0x89E9, 0x89EA, 0x89EC, 0x89ED, 0x89EE, 0x89F0, 0x89F1,
  0x89F2,
  // [ 19772, 19783] -> [0x89F4,0x89FF] # seg 410
  // [ 19784, 19789] -> [0x8A01,0x8A06] # seg 411
  // [ 19790, 19843] -> [0x8A08,0x8A3D] # seg 412
  // [ 19844, 19852] -> [0x8A3F,0x8A47] # seg 413
  // [ 19853, 19900] -> [0x8A49,0x8A78] # seg 414
  // [ 19901, 19915] -> [0x8A7A,0x8A88] # seg 415
  // [ 19916, 19923] -> [0x8A8B,0x8A92] # seg 416
  // [ 19924, 20038] -> [0x8A94,0x8B06] # seg 417
  // [ 20039, 20068] -> [0x8B08,0x8B25] # seg 418
  // [ 20069, 20131] -> [0x8B27,0x8B65] # seg 419
  // [ 20132, 20136] -> [0x8B67,0x8B6B] # seg 420
  // [ 20137, 20187] -> [0x8B6D,0x8B9F] # seg 421
  // [ 20188, 20195] -v # seg 422 at pos 14028
  0x8BAC, 0x8BB1, 0x8BBB, 0x8BC7, 0x8BD0, 0x8BEA, 0x8C09, 0x8C1E,
  // [ 20196, 20204] -> [0x8C38,0x8C40] # seg 423
  // [ 20205, 20270] -v # seg 424 at pos 14036
  0x8C42, 0x8C43, 0x8C44, 0x8C45, 0x8C48, 0x8C4A, 0x8C4B, 0x8C4D,
  0x8C4E, 0x8C4F, 0x8C50, 0x8C51, 0x8C52, 0x8C53, 0x8C54, 0x8C56,
  0x8C57, 0x8C58, 0x8C59, 0x8C5B, 0x8C5C, 0x8C5D, 0x8C5E, 0x8C5F,
  0x8C60, 0x8C63, 0x8C64, 0x8C65, 0x8C66, 0x8C67, 0x8C68, 0x8C69,
  0x8C6C, 0x8C6D, 0x8C6E, 0x8C6F, 0x8C70, 0x8C71, 0x8C72, 0x8C74,
  0x8C75, 0x8C76, 0x8C77, 0x8C7B, 0x8C7C, 0x8C7D, 0x8C7E, 0x8C7F,
  0x8C80, 0x8C81, 0x8C83, 0x8C84, 0x8C86, 0x8C87, 0x8C88, 0x8C8B,
  0x8C8D, 0x8C8E, 0x8C8F, 0x8C90, 0x8C91, 0x8C92, 0x8C93, 0x8C95,
  0x8C96, 0x8C97,
  // [ 20271, 20402] -> [0x8C99,0x8D1C] # seg 425
  // [ 20403, 20416] -v # seg 426 at pos 14102
  0x8D20, 0x8D51, 0x8D52, 0x8D57, 0x8D5F, 0x8D65, 0x8D68, 0x8D69,
  0x8D6A, 0x8D6C, 0x8D6E, 0x8D6F, 0x8D71, 0x8D72,
  // [ 20417, 20425] -> [0x8D78,0x8D80] # seg 427
  // [ 20426, 20438] -v # seg 428 at pos 14116
  0x8D82, 0x8D83, 0x8D86, 0x8D87, 0x8D88, 0x8D89, 0x8D8C, 0x8D8D,
  0x8D8E, 0x8D8F, 0x8D90, 0x8D92, 0x8D93,
  // [ 20439, 20448] -> [0x8D95,0x8D9E] # seg 429
  // [ 20449, 20451] -> [0x8DA0,0x8DA2] # seg 430
  // [ 20452, 20464] -> [0x8DA4,0x8DB0] # seg 431
  // [ 20465, 20561] -v # seg 432 at pos 14129
  0x8DB2, 0x8DB6, 0x8DB7, 0x8DB9, 0x8DBB, 0x8DBD, 0x8DC0, 0x8DC1,
  0x8DC2, 0x8DC5, 0x8DC7, 0x8DC8, 0x8DC9, 0x8DCA, 0x8DCD, 0x8DD0,
  0x8DD2, 0x8DD3, 0x8DD4, 0x8DD5, 0x8DD8, 0x8DD9, 0x8DDC, 0x8DE0,
  0x8DE1, 0x8DE2, 0x8DE5, 0x8DE6, 0x8DE7, 0x8DE9, 0x8DED, 0x8DEE,
  0x8DF0, 0x8DF1, 0x8DF2, 0x8DF4, 0x8DF6, 0x8DFC, 0x8DFE, 0x8DFF,
  0x8E00, 0x8E01, 0x8E02, 0x8E03, 0x8E04, 0x8E06, 0x8E07, 0x8E08,
  0x8E0B, 0x8E0D, 0x8E0E, 0x8E10, 0x8E11, 0x8E12, 0x8E13, 0x8E15,
  0x8E16, 0x8E17, 0x8E18, 0x8E19, 0x8E1A, 0x8E1B, 0x8E1C, 0x8E20,
  0x8E21, 0x8E24, 0x8E25, 0x8E26, 0x8E27, 0x8E28, 0x8E2B, 0x8E2D,
  0x8E30, 0x8E32, 0x8E33, 0x8E34, 0x8E36, 0x8E37, 0x8E38, 0x8E3B,
  0x8E3C, 0x8E3E, 0x8E3F, 0x8E43, 0x8E45, 0x8E46, 0x8E4C, 0x8E4D,
  0x8E4E, 0x8E4F, 0x8E50, 0x8E53, 0x8E54, 0x8E55, 0x8E56, 0x8E57,
  0x8E58,
  // [ 20562, 20573] -> [0x8E5A,0x8E65] # seg 433
  // [ 20574, 20611] -v # seg 434 at pos 14226
  0x8E67, 0x8E68, 0x8E6A, 0x8E6B, 0x8E6E, 0x8E71, 0x8E73, 0x8E75,
  0x8E77, 0x8E78, 0x8E79, 0x8E7A, 0x8E7B, 0x8E7D, 0x8E7E, 0x8E80,
  0x8E82, 0x8E83, 0x8E84, 0x8E86, 0x8E88, 0x8E89, 0x8E8A, 0x8E8B,
  0x8E8C, 0x8E8D, 0x8E8E, 0x8E91, 0x8E92, 0x8E93, 0x8E95, 0x8E96,
  0x8E97, 0x8E98, 0x8E99, 0x8E9A, 0x8E9B, 0x8E9D,
  // [ 20612, 20623] -> [0x8E9F,0x8EAA] # seg 435
  // [ 20624, 20634] -v # seg 436 at pos 14264
  0x8EAD, 0x8EAE, 0x8EB0, 0x8EB1, 0x8EB3, 0x8EB4, 0x8EB5, 0x8EB6,
  0x8EB7, 0x8EB8, 0x8EB9,
  // [ 20635, 20653] -> [0x8EBB,0x8ECD] # seg 437
  // [ 20654, 20804] -> [0x8ECF,0x8F65] # seg 438
  // [ 20805, 21003] -v # seg 439 at pos 14275
  0x8F6A, 0x8F80, 0x8F8C, 0x8F92, 0x8F9D, 0x8FA0, 0x8FA1, 0x8FA2,
  0x8FA4, 0x8FA5, 0x8FA6, 0x8FA7, 0x8FAA, 0x8FAC, 0x8FAD, 0x8FAE,
  0x8FAF, 0x8FB2, 0x8FB3, 0x8FB4, 0x8FB5, 0x8FB7, 0x8FB8, 0x8FBA,
  0x8FBB, 0x8FBC, 0x8FBF, 0x8FC0, 0x8FC3, 0x8FC6, 0x8FC9, 0x8FCA,
  0x8FCB, 0x8FCC, 0x8FCD, 0x8FCF, 0x8FD2, 0x8FD6, 0x8FD7, 0x8FDA,
  0x8FE0, 0x8FE1, 0x8FE3, 0x8FE7, 0x8FEC, 0x8FEF, 0x8FF1, 0x8FF2,
  0x8FF4, 0x8FF5, 0x8FF6, 0x8FFA, 0x8FFB, 0x8FFC, 0x8FFE, 0x8FFF,
  0x9007, 0x9008, 0x900C, 0x900E, 0x9013, 0x9015, 0x9018, 0x9019,
  0x901C, 0x9023, 0x9024, 0x9025, 0x9027, 0x9028, 0x9029, 0x902A,
  0x902B, 0x902C, 0x9030, 0x9031, 0x9032, 0x9033, 0x9034, 0x9037,
  0x9039, 0x903A, 0x903D, 0x903F, 0x9040, 0x9043, 0x9045, 0x9046,
  0x9048, 0x9049, 0x904A, 0x904B, 0x904C, 0x904E, 0x9054, 0x9055,
  0x9056, 0x9059, 0x905A, 0x905C, 0x905D, 0x905E, 0x905F, 0x9060,
  0x9061, 0x9064, 0x9066, 0x9067, 0x9069, 0x906A, 0x906B, 0x906C,
  0x906F, 0x9070, 0x9071, 0x9072, 0x9073, 0x9076, 0x9077, 0x9078,
  0x9079, 0x907A, 0x907B, 0x907C, 0x907E, 0x9081, 0x9084, 0x9085,
  0x9086, 0x9087, 0x9089, 0x908A, 0x908C, 0x908D, 0x908E, 0x908F,
  0x9090, 0x9092, 0x9094, 0x9096, 0x9098, 0x909A, 0x909C, 0x909E,
  0x909F, 0x90A0, 0x90A4, 0x90A5, 0x90A7, 0x90A8, 0x90A9, 0x90AB,
  0x90AD, 0x90B2, 0x90B7, 0x90BC, 0x90BD, 0x90BF, 0x90C0, 0x90C2,
  0x90C3, 0x90C6, 0x90C8, 0x90C9, 0x90CB, 0x90CC, 0x90CD, 0x90D2,
  0x90D4, 0x90D5, 0x90D6, 0x90D8, 0x90D9, 0x90DA, 0x90DE, 0x90DF,
  0x90E0, 0x90E3, 0x90E4, 0x90E5, 0x90E9, 0x90EA, 0x90EC, 0x90EE,
  0x90F0, 0x90F1, 0x90F2, 0x90F3, 0x90F5, 0x90F6, 0x90F7, 0x90F9,
  0x90FA, 0x90FB, 0x90FC, 0x90FF, 0x9100, 0x9101, 0x9103,
  // [ 21004, 21023] -> [0x9105,0x9118] # seg 440
  // [ 21024, 21030] -v # seg 441 at pos 14474
  0x911A, 0x911B, 0x911C, 0x911D, 0x911F, 0x9120, 0x9121,
  // [ 21031, 21041] -> [0x9124,0x912E] # seg 442
  // [ 21042, 21049] -v # seg 443 at pos 14481
  0x9130, 0x9132, 0x9133, 0x9134, 0x9135, 0x9136, 0x9137, 0x9138,
  // [ 21050, 21058] -> [0x913A,0x9142] # seg 444
  // [ 21059, 21121] -v # seg 445 at pos 14489
  0x9144, 0x9145, 0x9147, 0x9148, 0x9151, 0x9153, 0x9154, 0x9155,
  0x9156, 0x9158, 0x9159, 0x915B, 0x915C, 0x915F, 0x9160, 0x9166,
  0x9167, 0x9168, 0x916B, 0x916D, 0x9173, 0x917A, 0x917B, 0x917C,
  0x9180, 0x9181, 0x9182, 0x9183, 0x9184, 0x9186, 0x9188, 0x918A,
  0x918E, 0x918F, 0x9193, 0x9194, 0x9195, 0x9196, 0x9197, 0x9198,
  0x9199, 0x919C, 0x919D, 0x919E, 0x919F, 0x91A0, 0x91A1, 0x91A4,
  0x91A5, 0x91A6, 0x91A7, 0x91A8, 0x91A9, 0x91AB, 0x91AC, 0x91B0,
  0x91B1, 0x91B2, 0x91B3, 0x91B6, 0x91B7, 0x91B8, 0x91B9,
  // [ 21122, 21133] -> [0x91BB,0x91C6] # seg 446
  // [ 21134, 21136] -v # seg 447 at pos 14552
  0x91C8, 0x91CB, 0x91D0,
  // [ 21137, 21146] -> [0x91D2,0x91DB] # seg 448
  // [ 21147, 21297] -> [0x91DD,0x9273] # seg 449
  // [ 21298, 21322] -> [0x9275,0x928D] # seg 450
  // [ 21323, 21353] -> [0x928F,0x92AD] # seg 451
  // [ 21354, 21378] -> [0x92AF,0x92C7] # seg 452
  // [ 21379, 21495] -> [0x92C9,0x933D] # seg 453
  // [ 21496, 21538] -> [0x933F,0x9369] # seg 454
  // [ 21539, 21574] -> [0x936B,0x938E] # seg 455
  // [ 21575, 21632] -> [0x9390,0x93C9] # seg 456
  // [ 21633, 21643] -> [0x93CB,0x93D5] # seg 457
  // [ 21644, 21746] -> [0x93D7,0x943D] # seg 458
  // [ 21747, 21790] -> [0x943F,0x946A] # seg 459
  // [ 21791, 21815] -> [0x946C,0x9484] # seg 460
  // [ 21816, 21847] -v # seg 461 at pos 14555
  0x9491, 0x9496, 0x9498, 0x94C7, 0x94CF, 0x94D3, 0x94D4, 0x94DA,
  0x94E6, 0x94FB, 0x951C, 0x9520, 0x9527, 0x9533, 0x953D, 0x9543,
  0x9548, 0x954B, 0x9555, 0x955A, 0x9560, 0x956E, 0x9574, 0x9575,
  0x9577, 0x9578, 0x9579, 0x957A, 0x957B, 0x957C, 0x957D, 0x957E,
  // [ 21848, 21951] -> [0x9580,0x95E7] # seg 462
  // [ 21952, 22003] -v # seg 463 at pos 14587
  0x95EC, 0x95FF, 0x9607, 0x9613, 0x9618, 0x961B, 0x961E, 0x9620,
  0x9623, 0x9624, 0x9625, 0x9626, 0x9627, 0x9628, 0x9629, 0x962B,
  0x962C, 0x962D, 0x962F, 0x9630, 0x9637, 0x9638, 0x9639, 0x963A,
  0x963E, 0x9641, 0x9643, 0x964A, 0x964E, 0x964F, 0x9651, 0x9652,
  0x9653, 0x9656, 0x9657, 0x9658, 0x9659, 0x965A, 0x965C, 0x965D,
  0x965E, 0x9660, 0x9663, 0x9665, 0x9666, 0x966B, 0x966D, 0x966E,
  0x966F, 0x9670, 0x9671, 0x9673,
  // [ 22004, 22016] -> [0x9678,0x9684] # seg 464
  // [ 22017, 22028] -v # seg 465 at pos 14639
  0x9687, 0x9689, 0x968A, 0x968C, 0x968E, 0x9691, 0x9692, 0x9693,
  0x9695, 0x9696, 0x969A, 0x969B,
  // [ 22029, 22038] -> [0x969D,0x96A6] # seg 466
  // [ 22039, 22046] -> [0x96A8,0x96AF] # seg 467
  // [ 22047, 22064] -v # seg 468 at pos 14651
  0x96B1, 0x96B2, 0x96B4, 0x96B5, 0x96B7, 0x96B8, 0x96BA, 0x96BB,
  0x96BF, 0x96C2, 0x96C3, 0x96C8, 0x96CA, 0x96CB, 0x96D0, 0x96D1,
  0x96D3, 0x96D4,
  // [ 22065, 22074] -> [0x96D6,0x96DF] # seg 469
  // [ 22075, 22113] -v # seg 470 at pos 14669
  0x96E1, 0x96E2, 0x96E3, 0x96E4, 0x96E5, 0x96E6, 0x96E7, 0x96EB,
  0x96EC, 0x96ED, 0x96EE, 0x96F0, 0x96F1, 0x96F2, 0x96F4, 0x96F5,
  0x96F8, 0x96FA, 0x96FB, 0x96FC, 0x96FD, 0x96FF, 0x9702, 0x9703,
  0x9705, 0x970A, 0x970B, 0x970C, 0x9710, 0x9711, 0x9712, 0x9714,
  0x9715, 0x9717, 0x9718, 0x9719, 0x971A, 0x971B, 0x971D,
  // [ 22114, 22124] -> [0x971F,0x9729] # seg 471
  // [ 22125, 22138] -v # seg 472 at pos 14708
  0x972B, 0x972C, 0x972E, 0x972F, 0x9731, 0x9733, 0x9734, 0x9735,
  0x9736, 0x9737, 0x973A, 0x973B, 0x973C, 0x973D,
  // [ 22139, 22157] -> [0x973F,0x9751] # seg 473
  // [ 22158, 22170] -v # seg 474 at pos 14722
  0x9754, 0x9755, 0x9757, 0x9758, 0x975A, 0x975C, 0x975D, 0x975F,
  0x9763, 0x9764, 0x9766, 0x9767, 0x9768,
  // [ 22171, 22179] -> [0x976A,0x9772] # seg 475
  // [ 22180, 22227] -v # seg 476 at pos 14735
  0x9775, 0x9777, 0x9778, 0x9779, 0x977A, 0x977B, 0x977D, 0x977E,
  0x977F, 0x9780, 0x9781, 0x9782, 0x9783, 0x9784, 0x9786, 0x9787,
  0x9788, 0x9789, 0x978A, 0x978C, 0x978E, 0x978F, 0x9790, 0x9793,
  0x9795, 0x9796, 0x9797, 0x9799, 0x979A, 0x979B, 0x979C, 0x979D,
  0x979E, 0x979F, 0x97A1, 0x97A2, 0x97A4, 0x97A5, 0x97A6, 0x97A7,
  0x97A8, 0x97A9, 0x97AA, 0x97AC, 0x97AE, 0x97B0, 0x97B1, 0x97B3,
  // [ 22228, 22276] -> [0x97B5,0x97E5] # seg 477
  // [ 22277, 22283] -v # seg 478 at pos 14783
  0x97E8, 0x97EE, 0x97EF, 0x97F0, 0x97F1, 0x97F2, 0x97F4,
  // [ 22284, 22409] -> [0x97F7,0x9874] # seg 479
  // [ 22410, 22415] -v # seg 480 at pos 14790
  0x988B, 0x988E, 0x9892, 0x9895, 0x9899, 0x98A3,
  // [ 22416, 22453] -> [0x98A8,0x98CD] # seg 481
  // [ 22454, 22468] -v # seg 482 at pos 14796
  0x98CF, 0x98D0, 0x98D4, 0x98D6, 0x98D7, 0x98DB, 0x98DC, 0x98DD,
  0x98E0, 0x98E1, 0x98E2, 0x98E3, 0x98E4, 0x98E5, 0x98E6,
  // [ 22469, 22504] -> [0x98E9,0x990C] # seg 483
  // [ 22505, 22506] -> [0x990E,0x990F] # seg 484
  // [ 22507, 22535] -> [0x9911,0x992D] # seg 485
  // [ 22536, 22572] -> [0x992F,0x9953] # seg 486
  // [ 22573, 22585] -> [0x9956,0x9962] # seg 487
  // [ 22586, 22597] -v # seg 488 at pos 14811
  0x9964, 0x9966, 0x9973, 0x9978, 0x9979, 0x997B, 0x997E, 0x9982,
  0x9983, 0x9989, 0x998C, 0x998E,
  // [ 22598, 22608] -> [0x999A,0x99A4] # seg 489
  // [ 22609, 22610] -> [0x99A6,0x99A7] # seg 490
  // [ 22611, 22805] -> [0x99A9,0x9A6B] # seg 491
  // [ 22806, 22863] -v # seg 492 at pos 14823
  0x9A72, 0x9A83, 0x9A89, 0x9A8D, 0x9A8E, 0x9A94, 0x9A95, 0x9A99,
  0x9AA6, 0x9AA9, 0x9AAA, 0x9AAB, 0x9AAC, 0x9AAD, 0x9AAE, 0x9AAF,
  0x9AB2, 0x9AB3, 0x9AB4, 0x9AB5, 0x9AB9, 0x9ABB, 0x9ABD, 0x9ABE,
  0x9ABF, 0x9AC3, 0x9AC4, 0x9AC6, 0x9AC7, 0x9AC8, 0x9AC9, 0x9ACA,
  0x9ACD, 0x9ACE, 0x9ACF, 0x9AD0, 0x9AD2, 0x9AD4, 0x9AD5, 0x9AD6,
  0x9AD7, 0x9AD9, 0x9ADA, 0x9ADB, 0x9ADC, 0x9ADD, 0x9ADE, 0x9AE0,
  0x9AE2, 0x9AE3, 0x9AE4, 0x9AE5, 0x9AE7, 0x9AE8, 0x9AE9, 0x9AEA,
  0x9AEC, 0x9AEE,
  // [ 22864, 22872] -> [0x9AF0,0x9AF8] # seg 493
  // [ 22873, 22893] -v # seg 494 at pos 14881
  0x9AFA, 0x9AFC, 0x9AFD, 0x9AFE, 0x9AFF, 0x9B00, 0x9B01, 0x9B02,
  0x9B04, 0x9B05, 0x9B06, 0x9B07, 0x9B09, 0x9B0A, 0x9B0B, 0x9B0C,
  0x9B0D, 0x9B0E, 0x9B10, 0x9B11, 0x9B12,
  // [ 22894, 22904] -> [0x9B14,0x9B1E] # seg 495
  // [ 22905, 22907] -> [0x9B20,0x9B22] # seg 496
  // [ 22908, 22918] -> [0x9B24,0x9B2E] # seg 497
  // [ 22919, 22940] -v # seg 498 at pos 14902
  0x9B30, 0x9B31, 0x9B33, 0x9B34, 0x9B35, 0x9B36, 0x9B37, 0x9B38,
  0x9B39, 0x9B3A, 0x9B3D, 0x9B3E, 0x9B3F, 0x9B40, 0x9B46, 0x9B4A,
  0x9B4B, 0x9B4C, 0x9B4E, 0x9B50, 0x9B52, 0x9B53,
  // [ 22941, 23235] -> [0x9B55,0x9C7B] # seg 499
  // [ 23236, 23267] -v # seg 500 at pos 14924
  0x9C7D, 0x9C7E, 0x9C80, 0x9C83, 0x9C84, 0x9C89, 0x9C8A, 0x9C8C,
  0x9C8F, 0x9C93, 0x9C96, 0x9C97, 0x9C98, 0x9C99, 0x9C9D, 0x9CAA,
  0x9CAC, 0x9CAF, 0x9CB9, 0x9CBE, 0x9CBF, 0x9CC0, 0x9CC1, 0x9CC2,
  0x9CC8, 0x9CC9, 0x9CD1, 0x9CD2, 0x9CDA, 0x9CDB, 0x9CE0, 0x9CE1,
  // [ 23268, 23583] -> [0x9CE3,0x9E1E] # seg 501
  // [ 23584, 23607] -v # seg 502 at pos 14956
  0x9E24, 0x9E27, 0x9E2E, 0x9E30, 0x9E34, 0x9E3B, 0x9E3C, 0x9E40,
  0x9E4D, 0x9E50, 0x9E52, 0x9E53, 0x9E54, 0x9E56, 0x9E59, 0x9E5D,
  0x9E5F, 0x9E60, 0x9E61, 0x9E62, 0x9E65, 0x9E6E, 0x9E6F, 0x9E72,
  // [ 23608, 23617] -> [0x9E74,0x9E7D] # seg 503
  // [ 23618, 23631] -v # seg 504 at pos 14980
  0x9E80, 0x9E81, 0x9E83, 0x9E84, 0x9E85, 0x9E86, 0x9E89, 0x9E8A,
  0x9E8C, 0x9E8D, 0x9E8E, 0x9E8F, 0x9E90, 0x9E91,
  // [ 23632, 23640] -> [0x9E94,0x9E9C] # seg 505
  // [ 23641, 23647] -v # seg 506 at pos 14994
  0x9E9E, 0x9EA0, 0x9EA1, 0x9EA2, 0x9EA3, 0x9EA4, 0x9EA5,
  // [ 23648, 23660] -> [0x9EA7,0x9EB3] # seg 507
  // [ 23661, 23696] -v # seg 508 at pos 15001
  0x9EB5, 0x9EB6, 0x9EB7, 0x9EB9, 0x9EBA, 0x9EBC, 0x9EBF, 0x9EC0,
  0x9EC1, 0x9EC2, 0x9EC3, 0x9EC5, 0x9EC6, 0x9EC7, 0x9EC8, 0x9ECA,
  0x9ECB, 0x9ECC, 0x9ED0, 0x9ED2, 0x9ED3, 0x9ED5, 0x9ED6, 0x9ED7,
  0x9ED9, 0x9EDA, 0x9EDE, 0x9EE1, 0x9EE3, 0x9EE4, 0x9EE6, 0x9EE8,
  0x9EEB, 0x9EEC, 0x9EED, 0x9EEE,
  // [ 23697, 23705] -> [0x9EF0,0x9EF8] # seg 509
  // [ 23706, 23707] -v # seg 510 at pos 15037
  0x9EFA, 0x9EFD,
  // [ 23708, 23719] -> [0x9EFF,0x9F0A] # seg 511
  // [ 23720, 23734] -v # seg 512 at pos 15039
  0x9F0C, 0x9F0F, 0x9F11, 0x9F12, 0x9F14, 0x9F15, 0x9F16, 0x9F18,
  0x9F1A, 0x9F1B, 0x9F1C, 0x9F1D, 0x9F1E, 0x9F1F, 0x9F21,
  // [ 23735, 23743] -> [0x9F23,0x9F2B] # seg 513
  // [ 23744, 23760] -v # seg 514 at pos 15054
  0x9F2D, 0x9F2E, 0x9F30, 0x9F31, 0x9F32, 0x9F33, 0x9F34, 0x9F35,
  0x9F36, 0x9F38, 0x9F3A, 0x9F3C, 0x9F3F, 0x9F40, 0x9F41, 0x9F42,
  0x9F43,
  // [ 23761, 23771] -> [0x9F45,0x9F4F] # seg 515
  // [ 23772, 23816] -> [0x9F52,0x9F7E] # seg 516
  // [ 23817, 23818] -> [0x9F81,0x9F82] # seg 517
  // [ 23819, 23830] -> [0x9F8D,0x9F98] # seg 518
  // [ 23831, 23939] -v # seg 519 at pos 15071
  0x9F9C, 0x9F9D, 0x9F9E, 0x9FA1, 0x9FA2, 0x9FA3, 0x9FA4, 0x9FA5,
  0xF92C, 0xF979, 0xF995, 0xF9E7, 0xF9F1, 0xFA0C, 0xFA0D, 0xFA0E,
  0xFA0F, 0xFA11, 0xFA13, 0xFA14, 0xFA18, 0xFA1F, 0xFA20, 0xFA21,
  0xFA23, 0xFA24, 0xFA27, 0xFA28, 0xFA29, 0x2E81, 0xE816, 0xE817,
  0xE818, 0x2E84, 0x3473, 0x3447, 0x2E88, 0x2E8B, 0xE81E, 0x359E,
  0x361A, 0x360E, 0x2E8C, 0x2E97, 0x396E, 0x3918, 0xE826, 0x39CF,
  0x39DF, 0x3A73, 0x39D0, 0xE82B, 0xE82C, 0x3B4E, 0x3C6E, 0x3CE0,
  0x2EA7, 0xE831, 0xE832, 0x2EAA, 0x4056, 0x415F, 0x2EAE, 0x4337,
  0x2EB3, 0x2EB6, 0x2EB7, 0xE83B, 0x43B1, 0x43AC, 0x2EBB, 0x43DD,
  0x44D6, 0x4661, 0x464C, 0xE843, 0x4723, 0x4729, 0x477C, 0x478D,
  0x2ECA, 0x4947, 0x497A, 0x497D, 0x4982, 0x4983, 0x4985, 0x4986,
  0x499F, 0x499B, 0x49B7, 0x49B6, 0xE854, 0xE855, 0x4CA3, 0x4C9F,
  0x4CA0, 0x4CA1, 0x4C77, 0x4CA2, 0x4D13, 0x4D14, 0x4D15, 0x4D16,
  0x4D17, 0x4D18, 0x4D19, 0x4DAE, 0xE864,
  // [ 23940, 23975] -> [0x0080,0x00A3] # seg 520
  // [ 23976, 23989] -v # seg 521 at pos 15180
  0x00A5, 0x00A6, 0x00A9, 0x00AA, 0x00AB, 0x00AC, 0x00AD, 0x00AE,
  0x00AF, 0x00B2, 0x00B3, 0x00B4, 0x00B5, 0x00B6,
  // [ 23990, 24020] -> [0x00B8,0x00D6] # seg 522
  // [ 24021, 24028] -> [0x00D8,0x00DF] # seg 523
  // [ 24029, 24048] -v # seg 524 at pos 15194
  0x00E2, 0x00E3, 0x00E4, 0x00E5, 0x00E6, 0x00E7, 0x00EB, 0x00EE,
  0x00EF, 0x00F0, 0x00F1, 0x00F4, 0x00F5, 0x00F6, 0x00F8, 0x00FB,
  0x00FD, 0x00FE, 0x00FF, 0x0100,
  // [ 24049, 24065] -> [0x0102,0x0112] # seg 525
  // [ 24066, 24072] -> [0x0114,0x011A] # seg 526
  // [ 24073, 24087] -> [0x011C,0x012A] # seg 527
  // [ 24088, 24111] -> [0x012C,0x0143] # seg 528
  // [ 24112, 24118] -v # seg 529 at pos 15214
  0x0145, 0x0146, 0x0147, 0x0149, 0x014A, 0x014B, 0x014C,
  // [ 24119, 24147] -> [0x014E,0x016A] # seg 530
  // [ 24148, 24245] -> [0x016C,0x01CD] # seg 531
  // [ 24246, 24252] -v # seg 532 at pos 15221
  0x01CF, 0x01D1, 0x01D3, 0x01D5, 0x01D7, 0x01D9, 0x01DB,
  // [ 24253, 24280] -> [0x01DD,0x01F8] # seg 533
  // [ 24281, 24367] -> [0x01FA,0x0250] # seg 534
  // [ 24368, 24382] -> [0x0252,0x0260] # seg 535
  // [ 24383, 24483] -> [0x0262,0x02C6] # seg 536
  // [ 24484, 24484] -> [0x02C8,0x02C8] # seg 537
  // [ 24485, 24497] -> [0x02CC,0x02D8] # seg 538
  // [ 24498, 24680] -> [0x02DA,0x0390] # seg 539
  // [ 24681, 24689] -v # seg 540 at pos 15228
  0x03A2, 0x03AA, 0x03AB, 0x03AC, 0x03AD, 0x03AE, 0x03AF, 0x03B0,
  0x03C2,
  // [ 24690, 24744] -> [0x03CA,0x0400] # seg 541
  // [ 24745, 24758] -> [0x0402,0x040F] # seg 542
  // [ 24759, 24759] -> [0x0450,0x0450] # seg 543
  // [ 24760, 31861] -> [0x0452,0x200F] # seg 544
  // [ 31862, 31873] -v # seg 545 at pos 15237
  0x2011, 0x2012, 0x2017, 0x201A, 0x201B, 0x201E, 0x201F, 0x2020,
  0x2021, 0x2022, 0x2023, 0x2024,
  // [ 31874, 31882] -> [0x2027,0x202F] # seg 546
  // [ 31883, 31889] -v # seg 547 at pos 15249
  0x2031, 0x2034, 0x2036, 0x2037, 0x2038, 0x2039, 0x203A,
  // [ 31890, 32001] -> [0x203C,0x20AB] # seg 548
  // [ 32002, 32087] -> [0x20AD,0x2102] # seg 549
  // [ 32088, 32091] -v # seg 550 at pos 15256
  0x2104, 0x2106, 0x2107, 0x2108,
  // [ 32092, 32103] -> [0x210A,0x2115] # seg 551
  // [ 32104, 32113] -> [0x2117,0x2120] # seg 552
  // [ 32114, 32175] -> [0x2122,0x215F] # seg 553
  // [ 32176, 32179] -> [0x216C,0x216F] # seg 554
  // [ 32180, 32201] -> [0x217A,0x218F] # seg 555
  // [ 32202, 32203] -> [0x2194,0x2195] # seg 556
  // [ 32204, 32313] -> [0x219A,0x2207] # seg 557
  // [ 32314, 32345] -v # seg 558 at pos 15260
  0x2209, 0x220A, 0x220B, 0x220C, 0x220D, 0x220E, 0x2210, 0x2212,
  0x2213, 0x2214, 0x2216, 0x2217, 0x2218, 0x2219, 0x221B, 0x221C,
  0x2221, 0x2222, 0x2224, 0x2226, 0x222C, 0x222D, 0x222F, 0x2230,
  0x2231, 0x2232, 0x2233, 0x2238, 0x2239, 0x223A, 0x223B, 0x223C,
  // [ 32346, 32355] -> [0x223E,0x2247] # seg 559
  // [ 32356, 32363] -v # seg 560 at pos 15292
  0x2249, 0x224A, 0x224B, 0x224D, 0x224E, 0x224F, 0x2250, 0x2251,
  // [ 32364, 32376] -> [0x2253,0x225F] # seg 561
  // [ 32377, 32384] -v # seg 562 at pos 15300
  0x2262, 0x2263, 0x2268, 0x2269, 0x226A, 0x226B, 0x226C, 0x226D,
  // [ 32385, 32421] -> [0x2270,0x2294] # seg 563
  // [ 32422, 32424] -> [0x2296,0x2298] # seg 564
  // [ 32425, 32435] -> [0x229A,0x22A4] # seg 565
  // [ 32436, 32460] -> [0x22A6,0x22BE] # seg 566
  // [ 32461, 32542] -> [0x22C0,0x2311] # seg 567
  // [ 32543, 32875] -> [0x2313,0x245F] # seg 568
  // [ 32876, 32885] -> [0x246A,0x2473] # seg 569
  // [ 32886, 32985] -> [0x249C,0x24FF] # seg 570
  // [ 32986, 32989] -> [0x254C,0x254F] # seg 571
  // [ 32990, 33002] -> [0x2574,0x2580] # seg 572
  // [ 33003, 33005] -> [0x2590,0x2592] # seg 573
  // [ 33006, 33015] -> [0x2596,0x259F] # seg 574
  // [ 33016, 33031] -> [0x25A2,0x25B1] # seg 575
  // [ 33032, 33039] -> [0x25B4,0x25BB] # seg 576
  // [ 33040, 33047] -> [0x25BE,0x25C5] # seg 577
  // [ 33048, 33052] -v # seg 578 at pos 15308
  0x25C8, 0x25C9, 0x25CA, 0x25CC, 0x25CD,
  // [ 33053, 33070] -> [0x25D0,0x25E1] # seg 579
  // [ 33071, 33101] -> [0x25E6,0x2604] # seg 580
  // [ 33102, 33103] -> [0x2607,0x2608] # seg 581
  // [ 33104, 33157] -> [0x260A,0x263F] # seg 582
  // [ 33158, 33158] -> [0x2641,0x2641] # seg 583
  // [ 33159, 35268] -> [0x2643,0x2E80] # seg 584
  // [ 35269, 35275] -v # seg 585 at pos 15313
  0x2E82, 0x2E83, 0x2E85, 0x2E86, 0x2E87, 0x2E89, 0x2E8A,
  // [ 35276, 35285] -> [0x2E8D,0x2E96] # seg 586
  // [ 35286, 35300] -> [0x2E98,0x2EA6] # seg 587
  // [ 35301, 35314] -v # seg 588 at pos 15320
  0x2EA8, 0x2EA9, 0x2EAB, 0x2EAC, 0x2EAD, 0x2EAF, 0x2EB0, 0x2EB1,
  0x2EB2, 0x2EB4, 0x2EB5, 0x2EB8, 0x2EB9, 0x2EBA,
  // [ 35315, 35328] -> [0x2EBC,0x2EC9] # seg 589
  // [ 35329, 35621] -> [0x2ECB,0x2FEF] # seg 590
  // [ 35622, 35633] -v # seg 591 at pos 15334
  0x2FFC, 0x2FFD, 0x2FFE, 0x2FFF, 0x3004, 0x3018, 0x3019, 0x301A,
  0x301B, 0x301C, 0x301F, 0x3020,
  // [ 35634, 35653] -> [0x302A,0x303D] # seg 592
  // [ 35654, 35675] -v # seg 593 at pos 15346
  0x303F, 0x3040, 0x3094, 0x3095, 0x3096, 0x3097, 0x3098, 0x3099,
  0x309A, 0x309F, 0x30A0, 0x30F7, 0x30F8, 0x30F9, 0x30FA, 0x30FB,
  0x30FF, 0x3100, 0x3101, 0x3102, 0x3103, 0x3104,
  // [ 35676, 35921] -> [0x312A,0x321F] # seg 594
  // [ 35922, 35928] -> [0x322A,0x3230] # seg 595
  // [ 35929, 36041] -> [0x3232,0x32A2] # seg 596
  // [ 36042, 36275] -> [0x32A4,0x338D] # seg 597
  // [ 36276, 36287] -> [0x3390,0x339B] # seg 598
  // [ 36288, 36289] -> [0x339F,0x33A0] # seg 599
  // [ 36290, 36323] -> [0x33A2,0x33C3] # seg 600
  // [ 36324, 36332] -> [0x33C5,0x33CD] # seg 601
  // [ 36333, 36336] -v # seg 602 at pos 15368
  0x33CF, 0x33D0, 0x33D3, 0x33D4,
  // [ 36337, 36449] -> [0x33D6,0x3446] # seg 603
  // [ 36450, 36492] -> [0x3448,0x3472] # seg 604
  // [ 36493, 36790] -> [0x3474,0x359D] # seg 605
  // [ 36791, 36901] -> [0x359F,0x360D] # seg 606
  // [ 36902, 36912] -> [0x360F,0x3619] # seg 607
  // [ 36913, 37677] -> [0x361B,0x3917] # seg 608
  // [ 37678, 37762] -> [0x3919,0x396D] # seg 609
  // [ 37763, 37858] -> [0x396F,0x39CE] # seg 610
  // [ 37859, 37872] -> [0x39D1,0x39DE] # seg 611
  // [ 37873, 38019] -> [0x39E0,0x3A72] # seg 612
  // [ 38020, 38237] -> [0x3A74,0x3B4D] # seg 613
  // [ 38238, 38524] -> [0x3B4F,0x3C6D] # seg 614
  // [ 38525, 38637] -> [0x3C6F,0x3CDF] # seg 615
  // [ 38638, 39522] -> [0x3CE1,0x4055] # seg 616
  // [ 39523, 39786] -> [0x4057,0x415E] # seg 617
  // [ 39787, 40257] -> [0x4160,0x4336] # seg 618
  // [ 40258, 40373] -> [0x4338,0x43AB] # seg 619
  // [ 40374, 40377] -> [0x43AD,0x43B0] # seg 620
  // [ 40378, 40420] -> [0x43B2,0x43DC] # seg 621
  // [ 40421, 40668] -> [0x43DE,0x44D5] # seg 622
  // [ 40669, 41041] -> [0x44D7,0x464B] # seg 623
  // [ 41042, 41061] -> [0x464D,0x4660] # seg 624
  // [ 41062, 41254] -> [0x4662,0x4722] # seg 625
  // [ 41255, 41259] -> [0x4724,0x4728] # seg 626
  // [ 41260, 41341] -> [0x472A,0x477B] # seg 627
  // [ 41342, 41357] -> [0x477D,0x478C] # seg 628
  // [ 41358, 41798] -> [0x478E,0x4946] # seg 629
  // [ 41799, 41848] -> [0x4948,0x4979] # seg 630
  // [ 41849, 41855] -v # seg 631 at pos 15372
  0x497B, 0x497C, 0x497E, 0x497F, 0x4980, 0x4981, 0x4984,
  // [ 41856, 41875] -> [0x4987,0x499A] # seg 632
  // [ 41876, 41878] -> [0x499C,0x499E] # seg 633
  // [ 41879, 41900] -> [0x49A0,0x49B5] # seg 634
  // [ 41901, 42603] -> [0x49B8,0x4C76] # seg 635
  // [ 42604, 42642] -> [0x4C78,0x4C9E] # seg 636
  // [ 42643, 42753] -> [0x4CA4,0x4D12] # seg 637
  // [ 42754, 42901] -> [0x4D1A,0x4DAD] # seg 638
  // [ 42902, 42982] -> [0x4DAF,0x4DFF] # seg 639
  // [ 42983, 57408] -> [0x9FA6,0xD7FF] # seg 640
  // [ 57409, 57410] -v # seg 641 at pos 15379
  0xE76C, 0xE7C8,
  // [ 57411, 57423] -> [0xE7E7,0xE7F3] # seg 642
  // [ 57424, 57459] -v # seg 643 at pos 15381
  0xE815, 0xE819, 0xE81A, 0xE81B, 0xE81C, 0xE81D, 0xE81F, 0xE820,
  0xE821, 0xE822, 0xE823, 0xE824, 0xE825, 0xE827, 0xE828, 0xE829,
  0xE82A, 0xE82D, 0xE82E, 0xE82F, 0xE830, 0xE833, 0xE834, 0xE835,
  0xE836, 0xE837, 0xE838, 0xE839, 0xE83A, 0xE83C, 0xE83D, 0xE83E,
  0xE83F, 0xE840, 0xE841, 0xE842,
  // [ 57460, 57475] -> [0xE844,0xE853] # seg 644
  // [ 57476, 57489] -> [0xE856,0xE863] # seg 645
  // [ 57490, 61784] -> [0xE865,0xF92B] # seg 646
  // [ 61785, 61860] -> [0xF92D,0xF978] # seg 647
  // [ 61861, 61887] -> [0xF97A,0xF994] # seg 648
  // [ 61888, 61968] -> [0xF996,0xF9E6] # seg 649
  // [ 61969, 61977] -> [0xF9E8,0xF9F0] # seg 650
  // [ 61978, 62003] -> [0xF9F2,0xFA0B] # seg 651
  // [ 62004, 62017] -v # seg 652 at pos 15417
  0xFA10, 0xFA12, 0xFA15, 0xFA16, 0xFA17, 0xFA19, 0xFA1A, 0xFA1B,
  0xFA1C, 0xFA1D, 0xFA1E, 0xFA22, 0xFA25, 0xFA26,
  // [ 62018, 63047] -> [0xFA2A,0xFE2F] # seg 653
  // [ 63048, 63055] -v # seg 654 at pos 15431
  0xFE32, 0xFE45, 0xFE46, 0xFE47, 0xFE48, 0xFE53, 0xFE58, 0xFE67,
  // [ 63056, 63204] -> [0xFE6C,0xFF00] # seg 655
  // [ 63205, 63333] -> [0xFF5F,0xFFDF] # seg 656
  // [ 63334, 63359] -> [0xFFE6,0xFFFF] # seg 657
};

// Reverse
const unsigned short CodePageGB18030_R[22354] = {
  // hot segments (indexes into segment table)
  2, 103, 191,
  // number of segments
  243,
  // segment table
  0x0000, 0x0080, 0x00A4, 0x00B8, 0x00D7, 0x0102, 0x0113, 0x011C,
  0x012B, 0x012C, 0x0144, 0x014E, 0x016B, 0x016C, 0x01CE, 0x01DD,
  0x01F9, 0x01FA, 0x0251, 0x0252, 0x0261, 0x0262, 0x02C7, 0x02CC,
  0x02D9, 0x02DA, 0x0391, 0x03A2, 0x03B1, 0x03C2, 0x03CA, 0x0401,
  0x0402, 0x0410, 0x0416, 0x0430, 0x0436, 0x0450, 0x0452, 0x2010,
  0x2027, 0x2030, 0x203C, 0x20AC, 0x20AD, 0x2103, 0x210A, 0x2116,
  0x2117, 0x2121, 0x2122, 0x2160, 0x216C, 0x2170, 0x217A, 0x2190,
  0x219A, 0x2208, 0x223E, 0x2248, 0x2253, 0x2260, 0x2270, 0x2295,
  0x229A, 0x22A5, 0x22A6, 0x22BF, 0x22C0, 0x2312, 0x2313, 0x2460,
  0x246A, 0x2474, 0x2488, 0x249C, 0x2500, 0x254C, 0x2550, 0x2574,
  0x2581, 0x2590, 0x2596, 0x25A0, 0x25A2, 0x25B2, 0x25D0, 0x25E2,
  0x25E6, 0x2605, 0x260A, 0x2640, 0x2643, 0x2E81, 0x2E8D, 0x2E97,
  0x2E98, 0x2EA7, 0x2EBC, 0x2ECA, 0x2ECB, 0x2FF0, 0x2FFC, 0x3000,
  0x3020, 0x3021, 0x302A, 0x303E, 0x3041, 0x3094, 0x30A1, 0x30F7,
  0x3105, 0x312A, 0x3220, 0x322A, 0x3232, 0x32A3, 0x32A4, 0x338E,
  0x3390, 0x339C, 0x33A2, 0x33C4, 0x33C5, 0x33CE, 0x33D6, 0x3447,
  0x3448, 0x3473, 0x3474, 0x359E, 0x359F, 0x360E, 0x360F, 0x361A,
  0x361B, 0x3918, 0x3919, 0x396E, 0x396F, 0x39CF, 0x39D1, 0x39DF,
  0x39E0, 0x3A73, 0x3A74, 0x3B4E, 0x3B4F, 0x3C6E, 0x3C6F, 0x3CE0,
  0x3CE1, 0x4056, 0x4057, 0x415F, 0x4160, 0x4337, 0x4338, 0x43AC,
  0x43B2, 0x43DD, 0x43DE, 0x44D6, 0x44D7, 0x464C, 0x464D, 0x4661,
  0x4662, 0x4723, 0x472A, 0x477C, 0x477D, 0x478D, 0x478E, 0x4947,
  0x4948, 0x497A, 0x4987, 0x499B, 0x49A0, 0x49B6, 0x49B8, 0x4C77,
  0x4C78, 0x4C9F, 0x4CA4, 0x4D13, 0x4D1A, 0x4DAE, 0x4DAF, 0x4E00,
  0xA000, 0xD800, 0xE000, 0xE234, 0xE4C6, 0xE766, 0xE772, 0xE77D,
  0xE785, 0xE78D, 0xE797, 0xE7A0, 0xE7AF, 0xE7BC, 0xE7C7, 0xE7CD,
  0xE7E2, 0xE7E7, 0xE7F4, 0xE7FE, 0xE801, 0xE810, 0xE844, 0xE854,
  0xE856, 0xE864, 0xE865, 0xF92C, 0xF92D, 0xF979, 0xF97A, 0xF995,
  0xF996, 0xF9E7, 0xF9E8, 0xF9F1, 0xF9F2, 0xFA0C, 0xFA2A, 0xFE30,
  0xFE49, 0xFE53, 0xFE59, 0xFE67, 0xFE6C, 0xFF01, 0xFF05, 0xFF5E,
  0xFF5F, 0xFFE0, 0xFFE6,
  // compressed segments
   RCHAR,  23940,  RCHAR,  23990,  RCHAR,  24049,  RCHAR,  24073,
     666,  24088,  RCHAR,  24119,    674,  24148,  RCHAR,  24253,
     688,  24281,    684,  24368,    689,  24383,  RCHAR,  24485,
   15590,  24498,    470,  RCHAR,    502,  RCHAR,  24690,    570,
   24745,    564,    571,    612,    619,  RCHAR,  24760,  RCHAR,
   31874,  RCHAR,  31890,    160,  32002,  RCHAR,  32092,     76,
   32104,  15709,  32114,    174,  32176,     94,  32180,  RCHAR,
   32204,  RCHAR,  32346,  RCHAR,  32364,  RCHAR,  32385,  RCHAR,
   32425,     44,  32436,  15607,  32461,     47,  32543,    150,
   32876,    130,    110,  32886,    755,  32986,  15608,  32990,
   15644,  RCHAR,  33006,  RCHAR,  33016,  RCHAR,  33053,  15664,
   33071,  RCHAR,  33104,  RCHAR,  33159,  RCHAR,  35276,  23874,
   35286,  RCHAR,  35315,  23911,  35329,  15757,  35622,  RCHAR,
   35633,  15684,  35634,  RCHAR,    282,  RCHAR,    376,  RCHAR,
     694,  35676,    162,  RCHAR,  35929,  15693,  36042,  15694,
   36276,  RCHAR,  36290,  15700,  36324,  RCHAR,  36337,  23866,
   36450,  23865,  36493,  23870,  36791,  23872,  36902,  23871,
   36913,  23876,  37678,  23875,  37763,  RCHAR,  37859,  23879,
   37873,  23880,  38020,  23884,  38238,  23885,  38525,  23886,
   38638,  23891,  39523,  23892,  39787,  23894,  40258,  RCHAR,
   40378,  23902,  40421,  23903,  40669,  23905,  41042,  23904,
   41062,  RCHAR,  41260,  23909,  41342,  23910,  41358,  23912,
   41799,  RCHAR,  41856,  RCHAR,  41879,  RCHAR,  41901,  23929,
   42604,  RCHAR,  42643,  23931,  42754,  23938,  42902,  RCHAR,
   43073,  RCHAR,    846,   8178,  14916,  RCHAR,    365,    462,
     494,  RCHAR,    555,    597,    645,  15673,  RCHAR,    731,
   RCHAR,  57411,  15770,    752,    831,  RCHAR,  57460,  23923,
   57476,  23939,  57490,  23839,  61785,  23840,  61861,  23841,
   61888,  23842,  61969,  23843,  61978,  RCHAR,  62018,  RCHAR,
   15724,  RCHAR,  15738,  RCHAR,  63056,  RCHAR,    192,     10,
   63205,  RCHAR,  63334,
  // uncompressed segments
   RCHAR,  RCHAR,  21024,  RCHAR,  21044,  RCHAR,  21087,  RCHAR,
   RCHAR,  RCHAR,  21096,  RCHAR,  RCHAR,  RCHAR,  21106,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21121,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  21126,  RCHAR,  21141,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21149,  RCHAR,  21151,
   RCHAR,  21174,  RCHAR,  RCHAR,  RCHAR,  21186,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21193,
   RCHAR,  21203,  RCHAR,  21257,  RCHAR,  21268,  RCHAR,  21284,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  21289,  RCHAR,  21295,  RCHAR,  21297,  RCHAR,  RCHAR,
   RCHAR,  21327,  RCHAR,  21332,  RCHAR,  21335,  RCHAR,  RCHAR,
   RCHAR,  21347,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,      0,
   RCHAR,  RCHAR,  RCHAR,  21368,  RCHAR,  21371,  RCHAR,  21384,
   RCHAR,  RCHAR,  RCHAR,  21398,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  21406,  RCHAR,  RCHAR,  RCHAR,  21412,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21420,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21422,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  21428,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  21435,  RCHAR,  21448,  RCHAR,  21453,  RCHAR,  RCHAR,
   RCHAR,  21455,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,     32,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21460,  RCHAR,  RCHAR,
   RCHAR,  21472,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21482,  RCHAR,
   21488,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21493,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21545,  RCHAR,  21575,
   RCHAR,  21600,  RCHAR,  21606,  RCHAR,  21611,  RCHAR,  RCHAR,
   RCHAR,  21615,  RCHAR,
  // [0x0080,0x00A3] -> [ 23940, 23975] # seg 1
  // [0x00B8,0x00D6] -> [ 23990, 24020] # seg 3
  // [0x0102,0x0112] -> [ 24049, 24065] # seg 5
  // [0x011C,0x012A] -> [ 24073, 24087] # seg 7
  // [0x012B,0x012B] -> [   666,   666] # seg 8
  // [0x014E,0x016A] -> [ 24119, 24147] # seg 11
  // [0x016B,0x016B] -> [   674,   674] # seg 12
  // [0x01DD,0x01F8] -> [ 24253, 24280] # seg 15
  // [0x01F9,0x01F9] -> [   688,   688] # seg 16
  // [0x0251,0x0251] -> [   684,   684] # seg 18
  // [0x0261,0x0261] -> [   689,   689] # seg 20
  // [0x02CC,0x02D8] -> [ 24485, 24497] # seg 23
  // [0x02D9,0x02D9] -> [ 15590, 15590] # seg 24
  // [0x0391,0x03A1] -> [   470,   486] # seg 26
  // [0x03B1,0x03C1] -> [   502,   518] # seg 28
  // [0x03CA,0x0400] -> [ 24690, 24744] # seg 30
  // [0x0402,0x040F] -> [ 24745, 24758] # seg 32
  // [0x0416,0x042F] -> [   571,   596] # seg 34
  // [0x0436,0x044F] -> [   619,   644] # seg 36
  // [0x0452,0x200F] -> [ 24760, 31861] # seg 38
  // [0x2027,0x202F] -> [ 31874, 31882] # seg 40
  // [0x203C,0x20AB] -> [ 31890, 32001] # seg 42
  // [0x20AD,0x2102] -> [ 32002, 32087] # seg 44
  // [0x210A,0x2115] -> [ 32092, 32103] # seg 46
  // [0x2117,0x2120] -> [ 32104, 32113] # seg 48
  // [0x2122,0x215F] -> [ 32114, 32175] # seg 50
  // [0x216C,0x216F] -> [ 32176, 32179] # seg 52
  // [0x217A,0x218F] -> [ 32180, 32201] # seg 54
  // [0x219A,0x2207] -> [ 32204, 32313] # seg 56
  // [0x223E,0x2247] -> [ 32346, 32355] # seg 58
  // [0x2253,0x225F] -> [ 32364, 32376] # seg 60
  // [0x2270,0x2294] -> [ 32385, 32421] # seg 62
  // [0x229A,0x22A4] -> [ 32425, 32435] # seg 64
  // [0x22A6,0x22BE] -> [ 32436, 32460] # seg 66
  // [0x22C0,0x2311] -> [ 32461, 32542] # seg 68
  // [0x2313,0x245F] -> [ 32543, 32875] # seg 70
  // [0x246A,0x2473] -> [ 32876, 32885] # seg 72
  // [0x2488,0x249B] -> [   110,   129] # seg 74
  // [0x2500,0x254B] -> [   755,   830] # seg 76
  // [0x2550,0x2573] -> [ 15608, 15643] # seg 78
  // [0x2581,0x258F] -> [ 15644, 15658] # seg 80
  // [0x2596,0x259F] -> [ 33006, 33015] # seg 82
  // [0x25A2,0x25B1] -> [ 33016, 33031] # seg 84
  // [0x25D0,0x25E1] -> [ 33053, 33070] # seg 86
  // [0x25E6,0x2604] -> [ 33071, 33101] # seg 88
  // [0x260A,0x263F] -> [ 33104, 33157] # seg 90
  // [0x2643,0x2E80] -> [ 33159, 35268] # seg 92
  // [0x2E8D,0x2E96] -> [ 35276, 35285] # seg 94
  // [0x2E98,0x2EA6] -> [ 35286, 35300] # seg 96
  // [0x2EBC,0x2EC9] -> [ 35315, 35328] # seg 98
  // [0x2ECB,0x2FEF] -> [ 35329, 35621] # seg 100
  // [0x2FFC,0x2FFF] -> [ 35622, 35625] # seg 102
  // [0x3000,0x301F] -v # seg 103 at pos 0
       0,      1,      2,      7,  35626,      8,  15721,  15769,
      19,     20,     21,     22,     23,     24,     25,     26,
      29,     30,  15670,     93,     17,     18,     27,     28,
   35627,  35628,  35629,  35630,  35631,  15671,  15672,  35632,
  // [0x3041,0x3093] -> [   282,   364] # seg 108
  // [0x30A1,0x30F6] -> [   376,   461] # seg 110
  // [0x3105,0x3129] -> [   694,   730] # seg 112
  // [0x312A,0x321F] -> [ 35676, 35921] # seg 113
  // [0x3232,0x32A2] -> [ 35929, 36041] # seg 116
  // [0x32A3,0x32A3] -> [ 15693, 15693] # seg 117
  // [0x338E,0x338F] -> [ 15694, 15695] # seg 119
  // [0x33A2,0x33C3] -> [ 36290, 36323] # seg 122
  // [0x33C4,0x33C4] -> [ 15700, 15700] # seg 123
  // [0x33D6,0x3446] -> [ 36337, 36449] # seg 126
  // [0x3447,0x3447] -> [ 23866, 23866] # seg 127
  // [0x3473,0x3473] -> [ 23865, 23865] # seg 129
  // [0x359E,0x359E] -> [ 23870, 23870] # seg 131
  // [0x360E,0x360E] -> [ 23872, 23872] # seg 133
  // [0x361A,0x361A] -> [ 23871, 23871] # seg 135
  // [0x3918,0x3918] -> [ 23876, 23876] # seg 137
  // [0x396E,0x396E] -> [ 23875, 23875] # seg 139
  // [0x39D1,0x39DE] -> [ 37859, 37872] # seg 142
  // [0x39DF,0x39DF] -> [ 23879, 23879] # seg 143
  // [0x3A73,0x3A73] -> [ 23880, 23880] # seg 145
  // [0x3B4E,0x3B4E] -> [ 23884, 23884] # seg 147
  // [0x3C6E,0x3C6E] -> [ 23885, 23885] # seg 149
  // [0x3CE0,0x3CE0] -> [ 23886, 23886] # seg 151
  // [0x4056,0x4056] -> [ 23891, 23891] # seg 153
  // [0x415F,0x415F] -> [ 23892, 23892] # seg 155
  // [0x4337,0x4337] -> [ 23894, 23894] # seg 157
  // [0x43B2,0x43DC] -> [ 40378, 40420] # seg 160
  // [0x43DD,0x43DD] -> [ 23902, 23902] # seg 161
  // [0x44D6,0x44D6] -> [ 23903, 23903] # seg 163
  // [0x464C,0x464C] -> [ 23905, 23905] # seg 165
  // [0x4661,0x4661] -> [ 23904, 23904] # seg 167
  // [0x472A,0x477B] -> [ 41260, 41341] # seg 170
  // [0x477C,0x477C] -> [ 23909, 23909] # seg 171
  // [0x478D,0x478D] -> [ 23910, 23910] # seg 173
  // [0x4947,0x4947] -> [ 23912, 23912] # seg 175
  // [0x4987,0x499A] -> [ 41856, 41875] # seg 178
  // [0x49A0,0x49B5] -> [ 41879, 41900] # seg 180
  // [0x49B8,0x4C76] -> [ 41901, 42603] # seg 182
  // [0x4C77,0x4C77] -> [ 23929, 23929] # seg 183
  // [0x4CA4,0x4D12] -> [ 42643, 42753] # seg 186
  // [0x4D13,0x4D19] -> [ 23931, 23937] # seg 187
  // [0x4DAE,0x4DAE] -> [ 23938, 23938] # seg 189
  // [0x4E00,0x9FFF] -v # seg 191 at pos 32
    4632,   1974,   8836,   3540,   8837,   8838,   8839,   4217,
    4928,   3758,   3806,   4357,   5171,   1624,   4774,   8840,
    5173,   1774,   8841,   5083,   3621,   5176,   3885,   8842,
    3651,   1594,   4626,   1837,   1984,   3978,   5178,   8843,
    8844,   8845,   1983,   8846,   3036,   4558,   8847,   3764,
    5182,   8848,   2247,   4541,   6263,   5029,   8849,   8850,
    2132,   8851,   1799,   8852,   3064,   8853,   5197,   8854,
    4207,   1883,   4239,   5068,   8855,   2999,   2782,   5184,
    8856,   8857,   8858,   3332,   8859,   2760,   8860,   5186,
    3215,   4674,   8861,   4995,   4287,   4894,   2434,   2073,
    2967,   8862,   3502,   3433,   3610,   8863,   2307,   8864,
    1734,   4655,   8865,   8866,   5200,   2762,   3559,   4623,
    4339,   4394,   8867,   8868,   8869,   8870,   3926,   8871,
    8872,   5201,   8873,   8874,   8875,   8876,   8877,   8878,
    3183,   3151,   8879,   3738,   8880,   8881,   8882,   8883,
    8884,   8885,   8886,   8887,   8888,   8889,   3583,   8890,
    8891,   8892,   8893,   8894,   8895,   8896,   3050,   8897,
    4771,   4976,   8898,   3887,   2067,   5170,   4757,   2906,
    8899,   4831,   2448,   5202,   4298,   2739,   8900,   8901,
    5177,   8902,   4550,   4426,   8903,   8904,   8905,   5198,
    5342,   4221,   2845,   8906,   2658,   2354,   4669,   1687,
    2413,   3311,   8907,   4400,   2734,   4139,   3040,   8908,
    8909,   8910,   3626,   5344,   8911,   5347,   8912,   8913,
    8914,   8915,   3708,   5242,   8916,   8917,   8918,   4663,
    3871,   3707,   5245,   5243,   5207,   2717,   3522,   1771,
    8919,   5244,   2712,   2704,   8920,   3717,   1836,   8921,
    8922,   3157,   8923,   1651,   5123,   3896,   4038,   4931,
    2183,   4364,   8924,   8925,   8926,   5321,   5249,   3581,
    8927,   5247,   8928,   1875,   3085,   4657,   8929,   8930,
    5246,   8931,   4644,   5248,   3234,   8932,   8933,   8934,
    4597,   8935,   5038,   5251,   8936,   5254,   2631,   2596,
    8937,   8938,   8939,   3711,   8940,   2128,   8941,   2101,
    8942,   3560,   8943,   8944,   8945,   8946,   8947,   8948,
    8949,   5257,   4638,   8950,   8951,   4302,   2568,   2159,
    2072,   4478,   8952,   8953,   8954,   8955,   8956,   5039,
    4736,   2522,   2508,   5250,   8957,   8958,   3760,   4245,
    1796,   8959,   5252,   8960,   3802,   5255,   3156,   5256,
    8961,   8962,   4246,   5258,   8963,   8964,   8965,   1611,
    2287,   8966,   5266,   8967,   1482,   8968,   3077,   8969,
    3835,   8970,   3984,   8971,   3985,   5267,   8972,   8973,
    8974,   8975,   8976,   1951,   8977,   8978,   1890,   8979,
    8980,   8981,   8982,   8983,   8984,   4256,   1924,   5076,
    5159,   4750,   8985,   4110,   8986,   2395,   8987,   5265,
    5323,   4763,   5262,   2147,   5162,   5263,   5259,   5264,
    3356,   8988,   8989,   4721,   5253,   5324,   8990,   5260,
    8991,   3452,   8992,   8993,   2961,   8994,   8995,   4591,
    1468,   8996,   8997,   2586,   5269,   8998,   5268,   8999,
    9000,   9001,   9002,   5275,   5277,   9003,   5274,   3878,
    9004,   9005,   9006,   5272,   5003,   9007,   9008,   9009,
    1753,   5271,   9010,   3006,   9011,   3897,   9012,   5273,
    9013,   5270,   9014,   9015,   5279,   9016,   9017,   1990,
    9018,   9019,   9020,   2264,   9021,   4637,   9022,   9023,
    4355,   9024,   9025,   3135,   9026,   2667,   4963,   1661,
    3611,   2894,   5276,   9027,   5278,   9028,   4303,   2427,
    9029,   9030,   9031,   9032,   9033,   3625,   9034,   9035,
    9036,   9037,   9038,   9039,   9040,   9041,   9042,   1570,
    9043,   9044,   9045,   1842,   2050,   5283,   9046,   9047,
    9048,   9049,   2820,   9050,   9051,   9052,   5325,   3617,
    3007,   5287,   9053,   9054,   9055,   9056,   9057,   4002,
    2160,   9058,   5284,   9059,   5286,   1506,   4764,   5288,
    9060,   4454,   9061,   5285,   9062,   9063,   5280,   9064,
    5281,   3016,   5282,   9065,   9066,   2620,   4479,   2170,
    9067,   2792,   9068,   5292,   9069,   9070,   9071,   9072,
    5289,   9073,   1428,   9074,   9075,   9076,   5297,   9077,
    9078,   9079,   9080,   9081,   9082,   9083,   9084,   9085,
    9086,   9087,   9088,   9089,   5299,   1525,   9090,   5294,
    9091,   9092,   1904,   9093,   2808,   9094,   9095,   9096,
    4081,   2431,   4653,   9097,   5298,   9098,   9099,   2703,
    9100,   1702,   9101,   9102,   9103,   5300,   2800,   9104,
    5301,   5290,   3352,   9105,   5293,   5296,   5295,   9106,
    9107,   9108,   9109,   9110,   9111,   9112,   9113,   9114,
    9115,   9116,   4901,   9117,   5002,   9118,   3638,   9119,
    9120,   9121,   9122,   5303,   9123,   9124,   9125,   2594,
    5305,   9126,   9127,   9128,   5291,   9129,   5306,   3488,
    9130,   9131,   9132,   9133,   9134,   5304,   9135,   9136,
    9137,   9138,   5161,   9139,   4138,   9140,   9141,   9142,
    9143,   9144,   9145,   9146,   9147,   2632,   9148,   9149,
    9150,   9151,   9152,   9153,   5307,   9154,   9155,   9156,
    9157,   9158,   9159,   9160,   9161,   9162,   3411,   4156,
    9163,   9164,   9165,   5308,   9166,   9167,   5302,   1696,
    2913,   9168,   9169,   9170,   9171,   2182,   9172,   9173,
    3005,   9174,   9175,   9176,   9177,   1497,   9178,   9179,
    9180,   9181,   9182,   9183,   9184,   9185,   9186,   9187,
    9188,   9189,   9190,   9191,   9192,   9193,   9194,   9195,
    9196,   9197,   9198,   1871,   9199,   5309,   9200,   5310,
    1787,   5311,   9201,   9202,   1848,   9203,   9204,   9205,
    9206,   9207,   1442,   9208,   9209,   9210,   9211,   9212,
    9213,   9214,   5312,   3780,   9215,   9216,   9217,   9218,
    9219,   9220,   9221,   9222,   9223,   9224,   9225,   9226,
    9227,   9228,   9229,   9230,   9231,   9232,   9233,   4404,
    9234,   9235,   9236,   9237,   9238,   9239,   5313,   9240,
    9241,   9242,   3044,   9243,   9244,   9245,   9246,   9247,
    9248,   9249,   9250,   9251,   9252,   9253,   5317,   3773,
    9254,   9255,   9256,   9257,   5316,   5315,   5318,   9258,
    9259,   9260,   9261,   4006,   9262,   2640,   9263,   9264,
    9265,   9266,   9267,   3484,   9268,   9269,   9270,   9271,
    9272,   9273,   9274,   9275,   9276,   9277,   5314,   5319,
    9278,   9279,   9280,   5320,   9281,   9282,   9283,   9284,
    9285,   9286,   3734,   9287,   9288,   9289,   9290,   9291,
    9292,   9293,   9294,   9295,   9296,   9297,   9298,   9299,
    9300,   2973,   9301,   9302,   9303,   9304,   9305,   9306,
    9307,   9308,   9309,   9310,   9311,   9312,   9313,   9314,
    9315,   9316,   9317,   9318,   9319,   9320,   9321,   9322,
    9323,   9324,   9325,   9326,   9327,   9328,   9329,   2062,
    5172,   4835,   9330,   4803,   4471,   1759,   4942,   9331,
    4363,   2321,   9332,   2862,   9333,   3261,   9334,   9335,
    9336,   2023,   9337,   9338,   4170,   5341,   5343,   9339,
    9340,   9341,   1898,   9342,   1994,   9343,   9344,   9345,
    9346,   9347,   2729,   9348,   9349,   3740,   9350,   9351,
    3676,   9352,   9353,   1452,   2266,   3096,   5329,   9354,
    2941,   2273,   9355,   2311,   4460,   1591,   3545,   2788,
    1947,   5115,   9356,   4599,   2607,   3915,   9357,   9358,
    2566,   5333,   5240,   9359,   9360,   3347,   9361,   9362,
    2213,   3694,   9363,   9364,   1662,   4850,   9365,   9366,
    9367,   9368,   3211,   9369,   9370,   3260,   5359,   3728,
    9371,   4437,   9372,   2817,   3392,   9373,   9374,   9375,
    2313,   9376,   5360,   9377,   4802,   5361,   9378,   9379,
    9380,   9381,   9382,   5354,   1985,   9383,   9384,   2142,
    1592,   5355,   1760,   2811,   9385,   2905,   4622,   2981,
    9386,   9387,   9388,   1992,   5357,   5356,   9389,   9390,
    2752,   9391,   9392,   9393,   3541,   9394,   5103,   5358,
    9395,   3032,   9396,   1961,   3079,   9397,   9398,   2622,
    9399,   1838,   9400,   9401,   9402,   9403,   9404,   9405,
    9406,   9407,   9408,   3068,   9409,   3382,   9410,   9411,
    2561,   2085,   9412,   9413,   2146,   9414,   9415,   9416,
    9417,   9418,   9419,   5339,   9420,   3507,   9421,   2832,
    2486,   9422,   9423,   1921,   9424,   5492,   4472,   9425,
    4160,   1437,   1777,   2530,   5493,   2364,   9426,   4861,
    1901,   1962,   5223,   3713,   9427,   9428,   2121,   3619,
    5224,   9429,   2834,   9430,   9431,   5478,   5225,   9432,
    9433,   4461,   2457,   9434,   9435,   9436,   6985,   3055,
    3092,   4875,   2214,   1805,   9437,   1776,   9438,   9439,
    3789,   9440,   9441,   9442,   3431,   9443,   9444,   9445,
    3440,   3004,   9446,   1583,   9447,   5226,   2301,   9448,
    1908,   9449,   9450,   5227,   9451,   9452,   5019,   3949,
    3680,   3777,   1829,   2863,   9453,   2339,   9454,   5228,
    5229,   2044,   2570,   4115,   9455,   9456,   9457,   9458,
    9459,   9460,   4410,   9461,   5230,   3587,   9462,   9463,
    2303,   2634,   9464,   9465,   4103,   9466,   3519,   9467,
    9468,   9469,   9470,   9471,   5233,   9472,   5231,   9473,
    9474,   5232,   9475,   9476,   9477,   1503,   9478,   2796,
    9479,   3856,   2621,   9480,   9481,   9482,   9483,   2178,
    9484,   9485,   2239,   9486,   9487,   9488,   9489,   9490,
    9491,   9492,   9493,   9494,   9495,   5235,   9496,   2674,
    9497,   5237,   5236,   9498,   9499,   9500,   9501,   9502,
    3475,   9503,   9504,   9505,   9506,   9507,   9508,   9509,
    5238,   9510,   9511,   5239,   9512,   9513,   9514,   9515,
    9516,   9517,   9518,   3013,   9519,   3681,   1485,   2261,
    2588,   4310,   5480,   3058,   9520,   9521,   9522,   9523,
    1988,   5071,   3395,   2688,   5481,   5482,   9524,   9525,
    9526,   3001,   2727,   2958,   9527,   9528,   9529,   9530,
    9531,   9532,   9533,   9534,   9535,   9536,   5483,   3891,
    9537,   9538,   9539,   1607,   9540,   9541,   9542,   4733,
    9543,   3262,   9544,   4522,   9545,   9546,   9547,   9548,
    5485,   9549,   2966,   9550,   9551,   9552,   5486,   9553,
    2836,   9554,   9555,   9556,   9557,   9558,   9559,   3317,
    9560,   9561,   9562,   9563,   3629,   9564,   9565,   9566,
    9567,   9568,   9569,   9570,   9571,   9572,   9573,   9574,
    5487,   9575,   9576,   9577,   9578,   9579,   9580,   9581,
    9582,   5335,   3814,   9583,   9584,   9585,   2275,   4309,
    4833,   9586,   9587,   9588,   9589,   1501,   1835,   9590,
    4474,   9591,   9592,   9593,   9594,   5336,   9595,   5776,
    5338,   9596,   9597,   9598,   9599,   5185,   2458,   1520,
    9600,   1746,   5215,   9601,   9602,   4842,   9603,   9604,
    2650,   2898,   9605,   4350,   9606,   9607,   5217,   9608,
    9609,   9610,   2110,   9611,   9612,   9613,   5218,   9614,
    9615,   9616,   9617,   9618,   9619,   9620,   9621,   9622,
    9623,   3482,   3659,   4634,   9624,   9625,   5219,   3357,
    9626,   3867,   9627,   3578,   9628,   5175,   9629,   3852,
    4300,   2503,   1484,   9630,   9631,   9632,   2453,   4430,
    9633,   1519,   5143,   5106,   9634,   1884,   3185,   3336,
    9635,   9636,   1606,   9637,   1620,   9638,   1572,   5845,
    4915,   2827,   3113,   5222,   3118,   9639,   5221,   4281,
    9640,   5421,   9641,   4261,   9642,   9643,   5189,   3209,
    4700,   4232,   9644,   2557,   3685,   3150,   9645,   2802,
    4439,   9646,   5422,   9647,   9648,   9649,   9650,   3639,
    9651,   9652,   1698,   9653,   2055,   4133,   3003,   9654,
    9655,   3000,   9656,   4536,   4576,   5208,   9657,   9658,
    9659,   9660,   9661,   9662,   9663,   1659,   9664,   9665,
    2982,   9666,   2430,   9667,   9668,   5209,   9669,   4806,
    9670,   9671,   4388,   5210,   9672,   5211,   4358,   9673,
    1779,   2764,   9674,   9675,   9676,   9677,   5212,   9678,
    9679,   9680,   9681,   9682,   9683,   9684,   5495,   9685,
    9686,   9687,   9688,   3670,   9689,   9690,   9691,   4379,
    9692,   3759,   1643,   9693,   9694,   9695,   9696,   9697,
    4753,   1667,   2553,   4748,   3958,   2087,   9698,   9699,
    9700,   2069,   9701,   9702,   3922,   9703,   3666,   3913,
    1571,   4497,   9704,   3432,   9705,   9706,   9707,   5488,
    1973,   9708,   9709,   2877,   2292,   2793,   3084,   9710,
    5849,   5848,   5008,   2679,   4944,   1449,   1976,   2860,
    4049,   5846,   3876,   4749,   9711,   5216,   4627,   2386,
    3977,   4071,   9712,   5850,   1959,   5847,   9713,   9714,
    9715,   4784,   9716,   1743,   2248,   9717,   5853,   9718,
    2396,   2547,   1964,   9719,   4147,   3286,   2432,   2997,
    4169,   4405,   5851,   4360,   9720,   3133,   5852,   3181,
    9721,   9722,   9723,   2818,   9724,   3070,   4179,   4692,
    2112,   5860,   9725,   5863,   9726,   9727,   2148,   1450,
    2027,   2119,   9728,   2361,   4134,   2871,   3964,   3561,
    9729,   4989,   5864,   9730,   4295,   1710,   9731,   9732,
    4321,   1806,   9733,   4268,   2429,   9734,   4294,   9735,
    4540,   9736,   9737,   5859,   9738,   9739,   1869,   9740,
    1733,   9741,   2231,   5854,   9742,   9743,   9744,   9745,
    3326,   9746,   5855,   5856,   5857,   3410,   5858,   5861,
    4810,   5862,   9747,   3597,   4285,   9748,   9749,   9750,
    9751,   9752,   3345,   9753,   5869,   9754,   5874,   9755,
    5041,   9756,   9757,   9758,   9759,   9760,   9761,   9762,
    9763,   5868,   5885,   4251,   9764,   2388,   5873,   5867,
    3445,   9765,   9766,   3834,   2433,   3287,   9767,   9768,
    2780,   9769,   5865,   9770,   5872,   9771,   3439,   9772,
    9773,   9774,   9775,   4893,   2394,   9776,   2769,   4728,
    2193,   9777,   5049,   9778,   5866,   2285,   2826,   9779,
    9780,   3099,   5870,   5871,   9781,   5875,   9782,   9783,
    9784,   9785,   9786,   5886,   5896,   9787,   5882,   5881,
    5116,   5894,   5895,   6466,   4612,   5877,   9788,   2828,
    9789,   4852,   9790,   2859,   5879,   9791,   9792,   9793,
    4367,   9794,   9795,   5888,   9796,   4553,   9797,   5889,
    1416,   3500,   5878,   9798,   2418,   9799,   2036,   4194,
    2349,   4846,   9800,   9801,   5890,   4399,   1414,   5898,
    5876,   4549,   5880,   5883,   5884,   5887,   9802,   2452,
    9803,   5891,   5892,   9804,   5893,   5897,   5899,   4719,
    9805,   9806,   9807,   9808,   9809,   2232,   3405,   5901,
    3817,   3015,   3325,   9810,   9811,   2881,   4411,   9812,
    9813,   9814,   4947,   5905,   9815,   9816,   9817,   9818,
    9819,   9820,   1621,   9821,   2412,   5903,   9822,   5484,
    9823,   4579,   9824,   9825,   9826,   9827,   4031,   1814,
    9828,   1415,   9829,   9830,   9831,   9832,   9833,   5908,
    4079,   5909,   9834,   9835,   5904,   9836,   9837,   9838,
    9839,   9840,   9841,   5900,   9842,   9843,   9844,   9845,
    5902,   9846,   5906,   5907,   2472,   9847,   9848,   5910,
    9849,   9850,   5911,   9851,   2446,   9852,   3912,   4237,
    5928,   1701,   9853,   5927,   9854,   9855,   9856,   5922,
    9857,   9858,   9859,   9860,   5921,   9861,   4192,   5919,
    9862,   5917,   9863,   2867,   5111,   9864,   3803,   9865,
    9866,   5915,   1410,   9867,   9868,   9869,   9870,   9871,
    5920,   9872,   9873,   9874,   9875,   5918,   5923,   9876,
    9877,   9878,   9879,   9880,   5929,   9881,   9882,   9883,
    9884,   2107,   9885,   9886,   3478,   3781,   2931,   5912,
    9887,   9888,   3413,   9889,   5205,   5916,   3375,   9890,
    9891,   9892,   9893,   9894,   9895,   5924,   5925,   5926,
    4422,   9896,   9897,   5941,   4109,   9898,   5938,   9899,
    2825,   5936,   4254,   5932,   3797,   9900,   9901,   2927,
    5935,   2426,   2365,   5930,   9902,   9903,   9904,   5913,
    9905,   5940,   9906,   9907,   5945,   9908,   9909,   9910,
    1798,   5946,   9911,   9912,   4341,   2389,   9913,   5937,
    9914,   9915,   9916,   9917,   9918,   9919,   9920,   4507,
    9921,   9922,   9923,   9924,   9925,   9926,   9927,   9928,
    9929,   5933,   9930,   4884,   9931,   5914,   9932,   3454,
    9933,   5934,   9934,   4786,   9935,   5943,   5944,   9936,
    9937,   9938,   9939,   9940,   5957,   4482,   9941,   9942,
    9943,   5949,   9944,   9945,   5962,   5963,   9946,   9947,
    9948,   5951,   5931,   3763,   5954,   9949,   5939,   9950,
    9951,   9952,   9953,   9954,   3893,   5956,   9955,   5942,
    9956,   4272,   9957,   3982,   5966,   5959,   5955,   9958,
    5964,   9959,   5947,   5952,   5953,   9960,   9961,   5958,
    9962,   9963,   5960,   5961,   9964,   5965,   9965,   5948,
    9966,   9967,   9968,   9969,   9970,   3999,   5974,   9971,
    5975,   5971,   9972,   9973,   9974,   9975,   9976,   9977,
    5969,   2583,   9978,   9979,   5970,   9980,   2195,   5206,
    9981,   9982,   9983,   9984,   9985,   9986,   9987,   9988,
    4491,   9989,   9990,   3180,   9991,   9992,   5968,   5950,
    9993,   9994,   9995,   5973,   5972,   9996,   9997,   5976,
    9998,   9999,  10000,  10001,   5981,   5977,  10002,  10003,
   10004,   5067,   1707,  10005,   5151,  10006,   3974,  10007,
   10008,   5979,  10009,   4320,  10010,  10011,  10012,   2406,
   10013,  10014,  10015,  10016,  10017,  10018,  10019,  10020,
   10021,  10022,  10023,  10024,   5986,   5982,   4618,  10025,
   10026,  10027,  10028,  10029,   5987,  10030,  10031,   5980,
    5978,   5984,  10032,  10033,   5985,  10034,  10035,  10036,
   10037,  10038,   5983,  10039,   5989,  10040,  10041,  10042,
    3564,   5181,   4868,   5991,   3894,  10043,  10044,  10045,
   10046,   5990,  10047,  10048,  10049,  10050,   2194,  10051,
   10052,  10053,  10054,   5992,   5993,  10055,  10056,  10057,
   10058,  10059,  10060,  10061,  10062,   5994,   5988,  10063,
   10064,  10065,  10066,  10067,  10068,  10069,   2380,   4112,
   10070,  10071,  10072,   5995,  10073,  10074,  10075,  10076,
   10077,  10078,  10079,  10080,  10081,  10082,  10083,  10084,
   10085,  10086,  10087,   4412,  10088,  10089,  10090,  10091,
   10092,  10093,  10094,  10095,  10096,  10097,  10098,   5996,
   10099,  10100,  10101,  10102,  10103,  10104,  10105,   3699,
   10106,  10107,  10108,  10109,   2663,  10110,  10111,  10112,
   10113,  10114,  10115,  10116,  10117,  10118,  10119,  10120,
   10121,  10122,   3339,  10123,  10124,  10125,  10126,  10127,
   10128,  10129,  10130,  10131,   5997,  10132,  10133,   5998,
   10134,  10135,   3655,   3983,  10136,   5999,   2499,   5191,
    4687,   6000,   4172,  10137,   2031,  10138,  10139,  10140,
   10141,  10142,  10143,   6002,  10144,   4809,  10145,  10146,
    2920,   1834,  10147,  10148,   4236,   6001,  10149,  10150,
   10151,   6003,   2299,  10152,  10153,   2345,   4163,   6004,
   10154,  10155,  10156,   3529,   6005,  10157,   4811,  10158,
    3671,   6007,   6006,  10159,  10160,  10161,  10162,  10163,
   10164,  10165,  10166,  10167,  10168,  10169,  10170,  10171,
   10172,  10173,  10174,  10175,   6008,  10176,  10177,   4168,
   10178,  10179,  10180,   3858,  10181,  10182,  10183,  10184,
    4851,   5506,   5508,  10185,   5507,   2326,   5511,   5512,
    1935,  10186,  10187,   5509,  10188,  10189,  10190,  10191,
   10192,   5510,   1692,   5514,  10193,  10194,   2531,  10195,
    5004,  10196,   5515,  10197,  10198,  10199,  10200,   2814,
   10201,  10202,   2094,  10203,   5499,   4055,   2837,   2464,
    5163,   2870,  10204,  10205,  10206,  10207,  10208,   2892,
   10209,  10210,   2602,   4060,   5513,   1460,   4304,   2123,
    5100,   3511,  10211,  10212,   2917,  10213,   4066,  10214,
    5522,   5516,   3503,   5518,  10215,   5523,  10216,   3470,
   10217,  10218,  10219,   5525,  10220,  10221,   5524,   2851,
   10222,  10223,  10224,   5521,   5520,  10225,  10226,  10227,
   10228,  10229,   1810,   2925,   3103,   5517,   5519,  10230,
   10231,  10232,  10233,   4462,   5528,  10234,  10235,  10236,
   10237,  10238,   2974,   5533,  10239,  10240,  10241,  10242,
   10243,  10244,  10245,   2039,  10246,  10247,  10248,  10249,
    5534,   5501,   2279,   4804,   5527,  10250,   2868,   5531,
   10251,   5500,  10252,   1949,  10253,   5526,   2888,  10254,
   10255,  10256,   5529,  10257,   5532,  10258,  10259,  10260,
    5540,  10261,  10262,  10263,  10264,  10265,  10266,  10267,
   10268,  10269,   2256,   1412,  10270,  10271,  10272,  10273,
   10274,  10275,  10276,   3182,  10277,  10278,   1730,   5530,
   10279,  10280,   5539,  10281,   3527,   5535,  10282,  10283,
    5536,   5538,   5537,  10284,  10285,   5545,  10286,   4781,
    1623,  10287,  10288,  10289,   5544,  10290,  10291,  10292,
   10293,  10294,  10295,  10296,  10297,   5549,  10298,   5542,
   10299,  10300,  10301,  10302,   5541,  10303,  10304,  10305,
    5543,   3447,   2532,  10306,  10307,   5548,  10308,  10309,
    5550,  10310,   4076,  10311,  10312,  10313,   2022,   5671,
   10314,  10315,  10316,   5546,  10317,   5547,  10318,  10319,
   10320,   3592,  10321,  10322,  10323,   2046,  10324,  10325,
   10326,   5552,  10327,  10328,  10329,  10330,   5551,  10331,
    5554,   1507,  10332,  10333,   1923,  10334,  10335,  10336,
   10337,  10338,   2835,  10339,  10340,  10341,  10342,  10343,
    4574,  10344,  10345,  10346,  10347,   2007,  10348,  10349,
   10350,  10351,  10352,  10353,  10354,  10355,  10356,  10357,
   10358,  10359,  10360,  10361,   5553,  10362,  10363,  10364,
   10365,  10366,  10367,  10368,   4037,   7038,  10369,  10370,
   10371,   4007,  10372,  10373,   4041,  10374,  10375,  10376,
    4074,  10377,  10378,  10379,  10380,  10381,   3756,  10382,
   10383,  10384,  10385,  10386,  10387,   5555,  10388,  10389,
   10390,  10391,  10392,   4119,   5556,  10393,  10394,  10395,
   10396,  10397,  10398,  10399,  10400,  10401,  10402,  10403,
   10404,  10405,  10406,  10407,  10408,  10409,   5502,  10410,
    5560,   5557,  10411,   2744,  10412,   3944,  10413,  10414,
   10415,   5558,  10416,  10417,  10418,  10419,  10420,  10421,
   10422,  10423,   3801,   3314,  10424,  10425,  10426,  10427,
   10428,   3600,   5559,  10429,  10430,  10431,   4879,   4487,
   10432,  10433,  10434,  10435,  10436,  10437,  10438,  10439,
    3300,   2026,  10440,  10441,  10442,  10443,  10444,  10445,
   10446,  10447,  10448,  10449,  10450,  10451,  10452,  10453,
   10454,  10455,  10456,  10457,   5503,  10458,  10459,  10460,
   10461,   1561,  10462,  10463,  10464,   5504,  10465,  10466,
   10467,  10468,  10469,  10470,  10471,  10472,  10473,  10474,
   10475,   5505,  10476,  10477,  10478,   2379,  10479,  10480,
   10481,  10482,  10483,  10484,  10485,  10486,  10487,  10488,
   10489,  10490,  10491,  10492,   3697,  10493,  10494,  10495,
   10496,  10497,  10498,   3884,   3706,  10499,   5094,  10500,
    3848,  10501,  10502,   2858,  10503,  10504,   2437,  10505,
   10506,   4633,  10507,  10508,  10509,  10510,  10511,  10512,
   10513,  10514,   6135,  10515,   1791,  10516,  10517,   1527,
   10518,  10519,  10520,  10521,  10522,   2181,  10523,   4359,
   10524,  10525,  10526,  10527,   5334,   4329,   4201,  10528,
   10529,   5340,   2037,  10530,   4630,  10531,  10532,   2282,
   10533,  10534,  10535,  10536,   6134,   6132,  10537,   1868,
   10538,   4117,   4052,   2149,  10539,   5187,   4586,   2376,
   10540,   3860,  10541,  10542,   4158,  10543,  10544,   4641,
    2887,   2585,   2038,  10545,   5770,  10546,  10547,  10548,
   10549,   5771,   5479,  10550,   4568,  10551,  10552,   3547,
    3335,   2145,  10553,   2127,  10554,  10555,   2911,   5139,
   10556,   3562,  10557,  10558,   1531,   5773,   2648,   4096,
    5775,  10559,   5774,  10560,  10561,  10562,  10563,  10564,
    1955,  10565,   3820,  10566,  10567,   1443,  10568,  10569,
   10570,  10571,  10572,  10573,  10574,  10575,  10576,  10577,
   10578,  10579,  10580,   3397,   3394,  10581,   3333,  10582,
    2610,   4040,  10583,  10584,  10585,   2384,  10586,  10587,
   10588,   6480,   3736,   6481,   4228,  10589,   5092,   2191,
    3173,  10590,   3714,  10591,  10592,   6482,  10593,  10594,
   10595,  10596,   2015,   2580,  10597,  10598,   4604,   6486,
   10599,   3273,  10600,  10601,  10602,  10603,   6489,  10604,
   10605,  10606,  10607,   6485,   6490,   4190,  10608,  10609,
    2100,   6483,   6484,   6488,  10610,  10611,   3350,   6493,
   10612,  10613,   6492,  10614,  10615,  10616,  10617,  10618,
   10619,   3230,  10620,   3539,  10621,  10622,   6495,  10623,
   10624,  10625,  10626,  10627,  10628,  10629,   3312,  10630,
   10631,  10632,   6487,   3881,  10633,  10634,  10635,  10636,
    2698,   2290,   6491,   4470,   4244,  10637,  10638,   6494,
    6501,  10639,   4611,  10640,   2641,   6498,  10641,  10642,
   10643,  10644,  10645,   6500,  10646,   2962,  10647,  10648,
    4649,  10649,  10650,  10651,   2544,  10652,  10653,  10654,
   10655,  10656,  10657,  10658,  10659,  10660,  10661,  10662,
   10663,   6502,  10664,   4691,  10665,  10666,  10667,   5118,
   10668,   4229,  10669,   4197,   3107,   6496,   6497,   2662,
    6499,   6504,  10670,  10671,   6503,  10672,  10673,  10674,
   10675,   6507,  10676,   6509,  10677,  10678,  10679,  10680,
    3368,  10681,  10682,  10683,   3329,  10684,  10685,   2799,
    3838,  10686,  10687,   6508,  10688,   2053,  10689,  10690,
   10691,   3263,  10692,  10693,  10694,  10695,  10696,  10697,
   10698,   4772,   6505,  10699,   6506,  10700,   3667,  10701,
   10702,  10703,  10704,  10705,   6514,  10706,  10707,  10708,
    6510,  10709,  10710,  10711,  10712,  10713,   3514,  10714,
   10715,   4216,   6512,  10716,  10717,  10718,  10719,  10720,
   10721,  10722,  10723,  10724,  10725,   6513,  10726,  10727,
   10728,  10729,   2516,  10730,  10731,  10732,  10733,  10734,
   10735,  10736,   6515,  10737,  10738,  10739,  10740,   6511,
   10741,  10742,   2936,  10743,  10744,  10745,  10746,  10747,
   10748,  10749,  10750,  10751,   4703,   6516,   3843,   6520,
   10752,  10753,   6521,  10754,  10755,  10756,  10757,   4503,
   10758,  10759,  10760,  10761,  10762,  10763,  10764,  10765,
   10766,  10767,  10768,  10769,  10770,  10771,  10772,  10773,
   10774,  10775,   3224,  10776,  10777,  10778,  10779,  10780,
   10781,  10782,   3231,   6519,  10783,  10784,  10785,  10786,
   10787,  10788,  10789,  10790,  10791,  10792,  10793,  10794,
   10795,  10796,   6518,  10797,  10798,  10799,  10800,  10801,
   10802,  10803,   6524,   4340,  10804,   7039,  10805,  10806,
    6527,  10807,  10808,  10809,  10810,  10811,   6522,  10812,
   10813,   2599,   3768,  10814,  10815,  10816,  10817,  10818,
   10819,   2558,  10820,  10821,   4374,  10822,  10823,  10824,
   10825,  10826,   6525,  10827,   6526,  10828,   6531,  10829,
    6533,  10830,  10831,  10832,   6534,  10833,  10834,  10835,
    6528,   1932,  10836,   6529,  10837,  10838,   6532,  10839,
   10840,   3348,  10841,   6523,  10842,  10843,  10844,  10845,
   10846,   6530,  10847,  10848,  10849,  10850,  10851,  10852,
   10853,  10854,  10855,  10856,  10857,  10858,  10859,  10860,
   10861,  10862,  10863,  10864,  10865,  10866,  10867,  10868,
   10869,   6535,  10870,  10871,  10872,  10873,  10874,  10875,
   10876,  10877,  10878,  10879,  10880,  10881,   6537,   6536,
   10882,  10883,  10884,  10885,  10886,  10887,  10888,  10889,
   10890,  10891,  10892,  10893,  10894,  10895,  10896,  10897,
   10898,  10899,  10900,  10901,  10902,  10903,  10904,  10905,
   10906,  10907,   6538,  10908,   5351,  10909,  10910,   6539,
   10911,  10912,  10913,  10914,  10915,  10916,  10917,  10918,
    6540,  10919,  10920,  10921,  10922,  10923,  10924,  10925,
   10926,  10927,  10928,  10929,  10930,  10931,  10932,  10933,
    5126,   6546,  10934,   6547,   2874,   4841,  10935,   5129,
    1855,   4026,   6543,   5204,   5121,   4419,  10936,   3242,
   10937,  10938,   6548,   2567,   2289,   6544,   4518,  10939,
   10940,   2351,   3148,  10941,   5180,  10942,  10943,  10944,
    3928,   6469,  10945,   6545,  10946,   2152,  10947,  10948,
   10949,  10950,   3735,  10951,  10952,   3374,  10953,  10954,
    6409,   3383,  10955,   4039,   6410,   4899,  10956,   4777,
    3909,   1427,  10957,   3993,   4209,  10958,  10959,   2423,
   10960,  10961,  10962,   6412,  10963,   6411,  10964,   5133,
    2312,   5051,   1981,   4215,   4648,   1509,   3874,  10965,
    1763,   3842,   2864,   4508,   3903,   6413,   2477,  10966,
   10967,  10968,   4383,   2267,  10969,  10970,  10971,  10972,
    4848,  10973,  10974,   2355,   4582,   4415,   2587,  10975,
    6414,   3726,  10976,  10977,  10978,   2896,   1589,   4009,
   10979,  10980,   2574,  10981,   2573,   4695,   3255,   2879,
   10982,  10983,  10984,  10985,   2188,  10986,  10987,  10988,
    3229,  10989,   2363,   4795,  10990,  10991,  10992,  10993,
   10994,  10995,  10996,  10997,  10998,   3633,   3304,   1673,
   10999,   2304,  11000,  11001,   6418,   3047,  11002,  11003,
    4902,  11004,  11005,  11006,  11007,  11008,   6419,  11009,
    6421,  11010,  11011,  11012,  11013,  11014,  11015,  11016,
    1856,   2025,   3981,   4527,   1907,  11017,  11018,   3910,
   11019,   2133,  11020,  11021,   3827,  11022,   2642,  11023,
   11024,   4259,   5155,  11025,  11026,  11027,  11028,   4418,
   11029,   3816,  11030,  11031,   2064,   6541,   2603,  11032,
    1721,  11033,   3807,  11034,   6542,   1693,  11035,  11036,
   11037,  11038,   5777,  11039,   4739,   5778,  11040,   4607,
   11041,  11042,  11043,  11044,   5779,  11045,  11046,  11047,
   11048,   2770,  11049,  11050,   5780,  11051,  11052,  11053,
    3865,   4697,   1754,   6465,   3354,   2726,   4247,   3371,
    2779,   3485,   1664,  11054,  11055,   2776,  11056,  11057,
    3663,   4116,   2707,   4290,  11058,  11059,   3879,   3510,
    6467,   4445,  11060,  11061,  11062,   4912,  11063,  11064,
   11065,   6468,  11066,  11067,  11068,  11069,   3937,  11070,
    4167,   3138,  11071,   6470,  11072,   3137,   6471,  11073,
   11074,  11075,  11076,  11077,  11078,  11079,   6479,   4180,
   11080,   3788,  11081,  11082,  11083,  11084,  11085,  11086,
   11087,   4662,   6023,  11088,  11089,  11090,  11091,   4775,
   11092,   4021,   3558,  11093,  11094,  11095,  11096,  11097,
    6027,  11098,  11099,  11100,   6022,   6024,  11101,  11102,
    6025,   6030,  11103,  11104,   1674,  11105,   6026,   2219,
    6028,   6029,   6031,   1905,   6032,  11106,  11107,  11108,
   11109,  11110,   6034,   6039,  11111,  11112,  11113,  11114,
   11115,   4561,  11116,   6037,   6036,   3082,  11117,  11118,
   11119,   6038,  11120,   4825,  11121,   6033,  11122,   6041,
    1431,  11123,  11124,  11125,  11126,   6035,  11127,   2908,
   11128,   6040,  11129,  11130,   6042,  11131,  11132,  11133,
   11134,  11135,  11136,   6045,  11137,  11138,  11139,  11140,
   11141,  11142,   6043,  11143,  11144,  11145,  11146,  11147,
   11148,   5018,  11149,  11150,  11151,  11152,  11153,  11154,
   11155,   4354,  11156,  11157,   6044,   6046,   3146,  11158,
    2048,  11159,   4787,  11160,  11161,   3616,  11162,  11163,
    2136,  11164,  11165,  11166,  11167,  11168,  11169,  11170,
   11171,  11172,  11173,   2819,  11174,  11175,  11176,  11177,
   11178,  11179,   6047,   6048,  11180,  11181,   6054,   1762,
   11182,  11183,  11184,  11185,  11186,  11187,   3550,  11188,
   11189,  11190,  11191,  11192,   1847,  11193,   4545,  11194,
   11195,  11196,  11197,   6055,  11198,  11199,   6053,  11200,
   11201,  11202,  11203,  11204,   6052,  11205,   6050,   6049,
   11206,   1535,  11207,  11208,  11209,   4911,   6051,  11210,
   11211,  11212,  11213,  11214,   6058,  11215,  11216,  11217,
   11218,  11219,  11220,  11221,  11222,   6059,   6057,  11223,
   11224,  11225,  11226,  11227,  11228,  11229,  11230,   7421,
   11231,  11232,   6066,   6065,   3593,  11233,  11234,  11235,
   11236,  11237,  11238,  11239,  11240,  11241,  11242,  11243,
    6056,  11244,  11245,   6061,  11246,   6063,  11247,  11248,
   11249,  11250,  11251,  11252,  11253,  11254,  11255,  11256,
   11257,   6067,  11258,   6064,   6060,  11259,  11260,   6062,
   11261,  11262,  11263,  11264,   6068,  11265,  11266,  11267,
   11268,  11269,  11270,  11271,  11272,  11273,  11274,  11275,
   11276,  11277,   6069,  11278,  11279,  11280,  11281,  11282,
   11283,  11284,  11285,  11286,  11287,  11288,  11289,  11290,
   11291,  11292,  11293,  11294,  11295,  11296,  11297,  11298,
   11299,   6070,  11300,  11301,  11302,   6071,  11303,  11304,
   11305,  11306,  11307,  11308,  11309,  11310,  11311,  11312,
   11313,  11314,  11315,  11316,  11317,  11318,  11319,  11320,
   11321,  11322,  11323,  11324,  11325,  11326,  11327,   6073,
   11328,  11329,  11330,  11331,  11332,  11333,  11334,  11335,
   11336,  11337,  11338,  11339,  11340,   6074,  11341,  11342,
   11343,  11344,  11345,  11346,  11347,   4230,  11348,  11349,
   11350,  11351,  11352,  11353,  11354,  11355,  11356,  11357,
   11358,  11359,  11360,   6640,  11361,   1793,   5042,  11362,
   11363,   4529,   1709,  11364,  11365,   2259,   5158,   3612,
    2787,   2269,  11366,   4284,  11367,  11368,   1675,   5498,
   11369,   2563,   4654,   3987,   1454,  11370,  11371,   4402,
   11372,  11373,  11374,  11375,  11376,   5330,   2708,  11377,
   11378,   1553,   3901,   1625,  11379,   3954,   2078,  11380,
    3859,  11381,  11382,  11383,   4326,  11384,  11385,   6009,
    4929,   6012,  11386,  11387,   6011,   3416,   4132,  11388,
    3024,   6010,   5048,   1612,   5017,   1938,  11389,  11390,
   11391,  11392,  11393,  11394,  11395,  11396,   1873,   4982,
   11397,  11398,  11399,  11400,  11401,   4338,   1488,  11402,
   11403,   6013,  11404,  11405,  11406,  11407,  11408,   6016,
    1694,  11409,  11410,   6014,   6015,   3212,  11411,  11412,
   11413,  11414,   3256,  11415,   6017,   2156,  11416,  11417,
   11418,  11419,  11420,  11421,   2490,  11422,  11423,  11424,
   11425,  11426,  11427,  11428,   6018,   3316,  11429,  11430,
   11431,  11432,  11433,   6019,  11434,  11435,   6020,  11436,
   11437,   6021,   1802,  11438,  11439,  11440,  11441,  11442,
   11443,  11444,  11445,  11446,  11447,  11448,  11449,  11450,
   11451,  11452,   2202,   3506,   3363,  11453,   1599,  11454,
    4467,  11455,   6638,   2478,   4754,   4735,  11456,   2322,
    6156,  11457,  11458,  11459,   5090,  11460,   3647,   1554,
   11461,  11462,   1803,   6158,  11463,  11464,  11465,   4499,
    3115,   6157,  11466,   2885,   4705,   1934,   6159,   1953,
   11467,   3272,   2254,  11468,   2175,  11469,   3434,   2114,
    6161,  11470,  11471,  11472,  11473,   6160,   2013,   5164,
   11474,  11475,  11476,  11477,  11478,   4140,  11479,  11480,
   11481,  11482,  11483,   6165,  11484,   6163,   3945,   2840,
    4724,   6162,  11485,  11486,  11487,  11488,   6164,  11489,
   11490,  11491,  11492,  11493,  11494,  11495,  11496,  11497,
   11498,   3021,   2953,  11499,  11500,  11501,  11502,  11503,
   11504,   6168,   6167,   2923,  11505,  11506,   3053,  11507,
   11508,  11509,  11510,   6169,  11511,  11512,  11513,  11514,
   11515,  11516,  11517,  11518,  11519,  11520,  11521,  11522,
    6170,  11523,   6171,  11524,  11525,  11526,  11527,  11528,
   11529,  11530,  11531,  11532,   5491,  11533,   4562,   4137,
   11534,  11535,   2639,  11536,  11537,  11538,   5768,   5174,
    2829,   5496,   4681,   3567,   3393,  11539,  11540,  11541,
    5769,  11542,   1558,   5841,  11543,  11544,  11545,   3882,
   11546,   5844,  11547,   2268,  11548,   4698,  11549,   2166,
    2424,  11550,  11551,   1749,  11552,  11553,  11554,   1939,
    4924,  11555,  11556,  11557,  11558,   3249,   4373,   2444,
   11559,   6474,   6473,  11560,  11561,   6475,  11562,   4203,
   11563,   3750,  11564,  11565,  11566,  11567,  11568,  11569,
   11570,   1894,   3602,  11571,   6477,  11572,  11573,  11574,
    7065,  11575,  11576,  11577,  11578,  11579,  11580,  11581,
   11582,  11583,  11584,  11585,  11586,  11587,  11588,  11589,
    6461,  11590,   2328,   1896,  11591,   3129,   6463,   6462,
    6464,  11592,  11593,  11594,  11595,   4650,  11596,  11597,
   11598,   6089,   4463,  11599,   4149,  11600,   4580,  11601,
   11602,   1639,   1578,  11603,   1585,   3460,  11604,  11605,
    4922,   4715,  11606,   6075,  11607,  11608,  11609,   6076,
   11610,   4664,  11611,   1716,   1546,  11612,  11613,  11614,
    4224,   4974,   6077,  11615,   2747,   1878,  11616,   6078,
    2409,   6079,   2461,   3142,   6080,  11617,  11618,  11619,
    4493,  11620,   4164,  11621,  11622,   6081,  11623,   1914,
    3422,   6082,  11624,  11625,   6083,  11626,  11627,  11628,
   11629,   4788,  11630,  11631,  11632,  11633,  11634,  11635,
    6084,  11636,   4524,  11637,  11638,   6085,   4231,  11639,
   11640,  11641,  11642,  11643,  11644,   6086,  11645,   1913,
   11646,  11647,  11648,  11649,   6087,   2496,  11650,  11651,
   11652,  11653,  11654,   4453,   6173,   1559,   4673,  11655,
   11656,   6174,  11657,  11658,   2578,   3709,  11659,   6176,
    7143,   7142,   5842,  11660,  11661,  11662,   6175,   5011,
    4227,   3201,  11663,  11664,  11665,   6238,  11666,  11667,
    5031,   6180,  11668,  11669,   6181,  11670,  11671,   4738,
   11672,  11673,   6185,   2895,  11674,   6186,   6178,  11675,
   11676,   1723,  11677,  11678,  11679,   3367,  11680,  11681,
    6187,  11682,  11683,   4452,  11684,   2435,   6182,   2129,
    2462,   4053,   3990,   6177,   6179,   6183,   6184,  11685,
   11686,  11687,   6196,  11688,  11689,   6193,   4878,   6192,
   11690,  11691,   3396,  11692,   4977,   3417,   1629,  11693,
   11694,   6188,  11695,   6191,   3022,   3975,  11696,  11697,
    1880,   6198,  11698,  11699,  11700,   2554,   6190,   4469,
    4818,   6194,   2309,   6195,  11701,  11702,  11703,   3622,
   11704,  11705,  11706,  11707,  11708,   6189,  11709,  11710,
   11711,  11712,  11713,   5135,   7144,  11714,  11715,   6197,
   11716,   7148,   6203,   3902,  11717,  11718,  11719,  11720,
   11721,  11722,  11723,   3028,  11724,   2491,  11725,  11726,
    2873,  11727,   2416,  11728,  11729,   3948,  11730,  11731,
   11732,   7149,   7146,  11733,  11734,   7145,  11735,  11736,
   11737,  11738,   2497,   7150,   4501,  11739,  11740,   7147,
    2411,   2060,   6204,   1991,   4122,   2262,  11741,   4325,
    3572,  11742,  11743,   2869,  11744,  11745,   2054,  11746,
    6199,   6200,   6202,   6201,   3342,   6205,  11747,   4732,
   11748,  11749,  11750,   6210,   3607,  11751,  11752,  11753,
   11754,   4327,  11755,  11756,   6212,   2372,  11757,  11758,
   11759,  11760,   6211,  11761,   2501,  11762,   6206,  11763,
   11764,  11765,   6207,   6213,  11766,   6209,  11767,   4311,
    4737,  11768,  11769,   2471,  11770,  11771,   4828,  11772,
    3379,  11773,  11774,   7151,   4509,   6208,  11775,   3280,
   11776,   6216,   1518,  11777,   6221,  11778,  11779,  11780,
    2571,  11781,  11782,   6215,   1910,  11783,  11784,  11785,
   11786,  11787,  11788,  11789,  11790,   3644,   6219,  11791,
   11792,  11793,   2735,   4214,  11794,  11795,  11796,  11797,
   11798,   2526,  11799,  11800,  11801,   4113,  11802,  11803,
    6218,  11804,   6220,  11805,   4330,   6217,  11806,   4238,
    2504,  11807,  11808,  11809,  11810,  11811,   1954,   2794,
    1647,   1736,  11812,   1528,   6214,   1646,   1891,   2318,
    2045,  11813,  11814,   4398,   6226,  11815,   2487,  11816,
   11817,   3704,   4459,  11818,  11819,  11820,  11821,  11822,
    6227,   1769,  11823,  11824,  11825,  11826,   7152,  11827,
    4789,   4767,  11828,  11829,  11830,   7153,   6228,   4671,
   11831,  11832,  11833,  11834,  11835,   6224,  11836,  11837,
   11838,  11839,   4761,  11840,  11841,  11842,  11843,   2209,
    6222,  11844,  11845,   6225,   2130,  11846,   6223,   2915,
   11847,  11848,  11849,   6229,  11850,  11851,  11852,  11853,
   11854,  11855,  11856,  11857,  11858,  11859,  11860,  11861,
   11862,  11863,  11864,  11865,  11866,  11867,  11868,   4817,
   11869,  11870,  11871,  11872,  11873,  11874,  11875,  11876,
    1825,  11877,   6230,  11878,   2480,  11879,   3846,  11880,
   11881,   3828,  11882,  11883,  11884,   3318,  11885,  11886,
   11887,  11888,  11889,  11890,  11891,   7154,  11892,  11893,
   11894,  11895,   3194,  11896,  11897,  11898,  11899,   2502,
    2833,  11900,  11901,  11902,  11903,  11904,  11905,  11906,
    4260,  11907,  11908,  11909,  11910,   6231,  11911,   2841,
   11912,  11913,  11914,  11915,  11916,  11917,  11918,  11919,
   11920,  11921,  11922,  11923,  11924,  11925,  11926,  11927,
   11928,  11929,  11930,   1582,  11931,  11932,   4880,  11933,
   11934,  11935,  11936,  11937,   6233,  11938,  11939,  11940,
   11941,  11942,  11943,  11944,  11945,   7156,  11946,  11947,
   11948,  11949,  11950,  11951,  11952,  11953,  11954,   6234,
    2358,   7155,  11955,  11956,   6232,  11957,  11958,  11959,
   11960,  11961,  11962,  11963,  11964,  11965,  11966,   6235,
   11967,  11968,  11969,  11970,  11971,  11972,   2371,  11973,
   11974,  11975,   1987,  11976,  11977,  11978,  11979,  11980,
    4441,  11981,   1444,   7157,  11982,  11983,  11984,  11985,
   11986,   7158,   2946,  11987,   6236,  11988,  11989,  11990,
   11991,  11992,  11993,  11994,  11995,  11996,  11997,  11998,
   11999,  12000,  12001,  12002,  12003,  12004,   3402,  12005,
   12006,  12007,  12008,  12009,  12010,  12011,  12012,  12013,
   12014,  12015,  12016,  12017,  12018,   6237,  12019,  12020,
   12021,  12022,  12023,  12024,  12025,  12026,  12027,   5563,
   12028,  12029,  12030,  12031,  12032,  12033,   7159,  12034,
    2235,  12035,   4305,   6868,   4488,   3942,   3719,   4346,
    1732,   4279,   2699,  12036,  12037,   6265,   2525,   6869,
    4916,  12038,   3538,   6870,  12039,  12040,  12041,   6871,
   12042,   6873,   6872,  12043,   6875,   6874,  12044,  12045,
   12046,  12047,   2687,  12048,   6876,  12049,   3131,  12050,
   12051,  12052,  12053,   1818,   1872,  12054,  12055,   2450,
   12056,  12057,  12058,  12059,  12060,   7119,   7118,   2098,
    4036,   1569,  12061,   7120,  12062,  12063,  12064,   3799,
    7121,   7122,  12065,   3907,   5781,   1634,   4883,  12066,
   12067,   3520,   1448,   1867,   3716,  12068,  12069,  12070,
    4183,  12071,  12072,   2843,  12073,  12074,  12075,  12076,
   12077,  12078,  12079,   2878,  12080,  12081,   3575,   5001,
   12082,   2922,   5782,   3767,   4590,   3387,   1480,   1713,
    3702,  12083,  12084,   1475,  12085,  12086,   2153,  12087,
   12088,   3473,  12089,  12090,   2056,  12091,   4937,   1739,
    2565,  12092,  12093,  12094,   1704,  12095,  12096,  12097,
   12098,   2806,   1458,  12099,  12100,  12101,  12102,  12103,
   12104,   4659,   3920,   5080,  12105,   4157,   1995,   2844,
    4946,  12106,   2168,   3438,  12107,  12108,  12109,   5783,
    2876,   3154,   3603,  12110,   2447,   1511,  12111,  12112,
    3457,  12113,  12114,   3474,   4048,  12115,  12116,  12117,
   12118,   1510,  12119,  12120,  12121,   1933,  12122,  12123,
   12124,   3297,  12125,   5784,   4537,   1764,  12126,   3277,
   12127,  12128,   2154,  12129,   5065,   1882,   1677,   3309,
    3362,   2926,   5785,  12130,   1481,   3419,   3071,  12131,
    2308,  12132,   2785,   4191,   1455,  12133,   4182,   5787,
    2773,   5105,   5786,   4935,   1470,  12134,  12135,   3355,
   12136,  12137,   3104,   2617,  12138,   4720,   2938,   3384,
    1603,   4874,  12139,  12140,   2921,   3888,   5788,   4979,
   12141,   2271,  12142,   3678,   3956,  12143,   5790,   2848,
   12144,  12145,  12146,  12147,   3497,   5082,   3869,   3324,
   12148,   1745,   2305,  12149,  12150,  12151,  12152,   5005,
    6953,   1429,  12153,  12154,  12155,  12156,   2889,  12157,
   12158,   4125,  12159,  12160,  12161,  12162,   4193,  12163,
   12164,  12165,   5012,   3147,  12166,   4275,   4043,   4431,
    3340,   1897,   5789,   4972,   2560,   2494,  12167,  12168,
    1413,  12169,   3401,   1861,  12170,  12171,  12172,   4968,
   12173,  12174,   6954,  12175,  12176,  12177,  12178,  12179,
   12180,   5791,   4141,  12181,  12182,   4211,  12183,  12184,
   12185,  12186,   4299,   5793,  12187,   4152,   2919,  12188,
   12189,   5104,  12190,   5792,   1447,   2369,   3810,   3372,
    2797,  12191,  12192,  12193,  12194,   1619,  12195,  12196,
   12197,  12198,  12199,  12200,  12201,  12202,   2957,   4027,
   12203,   2618,   2470,   1902,  12204,  12205,  12206,   3468,
   12207,   5803,  12208,  12209,  12210,   5800,   2786,  12211,
   12212,   5796,  12213,  12214,  12215,  12216,   1808,   2692,
   12217,  12218,   5797,   3366,  12219,  12220,  12221,  12222,
    4361,  12223,   1943,  12224,  12225,  12226,  12227,   2035,
    3911,   1963,   5802,  12228,   4925,  12229,   5798,   4086,
    3571,  12230,   3420,  12231,  12232,  12233,   4625,  12234,
    2807,  12235,  12236,  12237,  12238,  12239,  12240,  12241,
    3152,  12242,   4070,   1715,  12243,   2682,  12244,   2875,
    4173,   4569,   1860,  12245,   5801,   5794,   5804,  12246,
    6955,  12247,  12248,   3117,   5799,  12249,  12250,   5013,
    1886,  12251,   1681,  12252,   5805,  12253,   5815,  12254,
   12255,  12256,  12257,  12258,   5810,  12259,   5814,  12260,
   12261,   3729,  12262,  12263,  12264,   5140,   5812,   3267,
    4106,  12265,   1666,  12266,  12267,  12268,   4635,  12269,
   12270,  12271,  12272,  12273,  12274,  12275,   5811,  12276,
    5808,   4282,  12277,   1792,  12278,  12279,  12280,  12281,
   12282,   2830,   2755,  12283,  12284,   2681,  12285,  12286,
   12287,  12288,   5806,  12289,   4807,  12290,   5795,  12291,
    5807,  12292,  12293,  12294,  12295,   2944,  12296,   5809,
    1680,   2234,   3108,  12297,  12298,   2664,  12299,  12300,
   12301,  12302,  12303,   5818,   5821,  12304,  12305,   1608,
    1789,  12306,  12307,   1859,   3765,  12308,  12309,  12310,
   12311,  12312,  12313,   5819,   3996,  12314,   2228,  12315,
    5820,   5823,  12316,  12317,  12318,  12319,   5822,  12320,
   12321,  12322,   4075,  12323,   1474,   1863,  12324,  12325,
   12326,  12327,  12328,  12329,   6417,  12330,  12331,  12332,
   12333,  12334,   4432,  12335,  12336,   1672,  12337,   6956,
   12338,   5817,  12339,  12340,   3826,   5816,   1467,   4606,
    1590,  12341,   4056,  12342,  12343,  12344,  12345,  12346,
   12347,  12348,   5813,  12349,   3951,  12350,  12351,  12352,
    4897,  12353,  12354,  12355,  12356,  12357,   5824,  12358,
   12359,  12360,  12361,  12362,  12363,  12364,  12365,   1846,
   12366,   3295,  12367,  12368,  12369,   5826,  12370,  12371,
   12372,  12373,  12374,  12375,  12376,  12377,  12378,  12379,
    3289,   3290,   5828,  12380,  12381,  12382,  12383,  12384,
   12385,  12386,   3051,  12387,   5825,   2804,  12388,   3495,
   12389,  12390,  12391,  12392,  12393,  12394,  12395,  12396,
   12397,   1728,   3751,  12398,  12399,   3973,   5827,  12400,
   12401,   5831,  12402,  12403,  12404,  12405,   5093,  12406,
   12407,  12408,  12409,  12410,   1714,  12411,  12412,  12413,
   12414,   3042,  12415,  12416,   3614,   1602,   1858,  12417,
    5086,  12418,  12419,  12420,  12421,   3365,  12422,   5829,
    5830,  12423,   5832,  12424,   2368,  12425,  12426,  12427,
    5833,  12428,   2975,  12429,  12430,   3794,  12431,  12432,
   12433,  12434,  12435,  12436,  12437,   1654,   3641,  12438,
    5834,  12439,   3631,  12440,  12441,  12442,  12443,   5835,
    6957,  12444,  12445,  12446,  12447,  12448,   3998,  12449,
   12450,  12451,   5837,  12452,   5836,  12453,   1630,  12454,
   12455,  12456,  12457,  12458,  12459,  12460,  12461,  12462,
   12463,  12464,  12465,  12466,  12467,  12468,  12469,  12470,
   12471,  12472,  12473,  12474,  12475,  12476,  12477,  12478,
    3425,  12479,  12480,  12481,  12482,  12483,  12484,  12485,
   12486,   5838,  12487,  12488,  12489,  12490,  12491,  12492,
   12493,  12494,   4853,  12495,  12496,  12497,  12498,  12499,
    3698,  12500,  12501,  12502,  12503,  12504,  12505,  12506,
   12507,  12508,  12509,  12510,  12511,   5839,  12512,  12513,
   12514,  12515,  12516,   2805,  12517,  12518,   5840,   4988,
   12519,  12520,  12521,  12522,   6884,   6977,   3906,  12523,
    5261,   2197,  12524,   2260,  12525,  12526,   2104,   4981,
   12527,  12528,  12529,  12530,  12531,   2297,  12532,  12533,
    4424,   7846,  12534,  12535,   1927,  12536,  12537,   3279,
   12538,   2765,  12539,  12540,  12541,   6978,   1438,  12542,
   12543,   2675,  12544,   3025,  12545,   1557,   1699,  12546,
   12547,  12548,   2211,   3761,  12549,  12550,   2029,  12551,
   12552,  12553,  12554,   6979,   2745,  12555,  12556,  12557,
    3946,  12558,   3606,  12559,   4978,  12560,  12561,   2150,
   12562,  12563,  12564,  12565,  12566,  12567,  12568,  12569,
   12570,  12571,  12572,  12573,  12574,  12575,  12576,   4265,
   12577,  12578,  12579,   4898,   1586,  12580,  12581,  12582,
    7068,   1472,  12583,   7070,  12584,  12585,  12586,   1996,
   12587,   3054,  12588,   7985,   4434,  12589,  12590,   4956,
   12591,   4280,  12592,  12593,   2710,   1757,  12594,   2172,
   12595,   4909,  12596,   7172,  12597,   2020,  12598,   3972,
    4451,  12599,  12600,  12601,  12602,  12603,  12604,  12605,
   12606,   2096,  12607,  12608,   7071,   3862,  12609,  12610,
   12611,   3435,  12612,   7074,   7073,   3136,   7072,  12613,
   12614,  12615,  12616,   4510,   7075,  12617,   7076,   5144,
   12618,  12619,   7077,  12620,  12621,  12622,   7078,   3553,
   12623,  12624,  12625,  12626,  12627,  12628,  12629,  12630,
    4291,  12631,   2577,  12632,  12633,   3718,   1888,   2766,
    5009,   4864,  12634,  12635,   4525,   4498,   6885,   6886,
    6887,   2370,  12636,  12637,  12638,  12639,   3870,   2904,
   12640,  12641,   4225,  12642,  12643,  12644,  12645,  12646,
    6893,  12647,   1435,   6891,  12648,  12649,   2918,  12650,
   12651,  12652,   6888,  12653,   1690,  12654,   3282,   2515,
   12655,  12656,  12657,   4660,   4313,   6892,  12658,  12659,
   12660,   6889,  12661,  12662,  12663,   6896,  12664,   4456,
    4718,  12665,  12666,  12667,  12668,   1811,  12669,   3228,
    5157,  12670,  12671,  12672,  12673,   4936,  12674,   3892,
   12675,   6898,  12676,  12677,   6897,   6900,   6899,  12678,
   12679,  12680,  12681,  12682,   5052,  12683,   4375,  12684,
   12685,   6904,  12686,   2489,  12687,  12688,  12689,  12690,
   12691,  12692,  12693,   2721,   3805,  12694,  12695,   6905,
   12696,  12697,   3784,   4417,   6903,   4839,   6906,   6908,
   12698,  12699,   4212,  12700,  12701,  12702,  12703,   6902,
   12704,   6907,  12705,  12706,   4307,  12707,   2505,  12708,
    1722,  12709,  12710,  12711,  12712,  12713,   3530,   2741,
    4319,  12714,  12715,  12716,   3642,  12717,   2732,   6909,
   12718,  12719,   5020,  12720,  12721,  12722,   3039,  12723,
   12724,  12725,   4854,  12726,   6910,  12727,  12728,   4353,
   12729,  12730,  12731,  12732,   6911,  12733,  12734,  12735,
   12736,   3931,  12737,  12738,  12739,  12740,   3398,   1430,
   12741,  12742,  12743,  12744,  12745,   6913,  12746,  12747,
   12748,  12749,  12750,  12751,  12752,  12753,  12754,   6912,
    7864,  12755,  12756,  12757,  12758,  12759,   3315,  12760,
   12761,  12762,  12763,  12764,   1512,  12765,  12766,  12767,
   12768,   6454,  12769,  12770,  12771,  12772,   6914,  12773,
   12774,  12775,  12776,  12777,  12778,  12779,  12780,  12781,
   12782,  12783,  12784,  12785,  12786,  12787,  12788,  12789,
   12790,  12791,  12792,  12793,  12794,  12795,  12796,  12797,
   12798,   3932,  12799,   6915,   6916,   3533,  12800,  12801,
   12802,  12803,  12804,  12805,  12806,  12807,   6917,  12808,
   12809,   6918,  12810,  12811,  12812,  12813,  12814,  12815,
    4820,  12816,   3661,   4628,   2253,  12817,  12818,   6895,
   12819,   1657,  12820,  12821,   3193,  12822,   4881,   4111,
    5153,  12823,  12824,  12825,  12826,  12827,  12828,  12829,
    4827,   4747,   6990,   3466,  12830,   2161,  12831,  12832,
    7007,  12833,  12834,  12835,   3970,   7017,  12836,   2955,
   12837,  12838,  12839,   4226,  12840,   1706,  12841,   3535,
   12842,  12843,  12844,  12845,  12846,  12847,   7047,  12848,
    3319,  12849,   4249,   3298,   1533,   4886,  12850,   3938,
   12851,   5057,  12852,  12853,   3528,   2041,  12854,  12855,
   12856,  12857,   2533,  12858,  12859,   4481,  12860,  12861,
    3776,  12862,   4844,   3673,  12863,  12864,   2204,  12865,
    6703,   3787,  12866,  12867,   6700,  12868,   2991,   4468,
    1633,   1854,  12869,   6701,  12870,  12871,   4927,  12872,
   12873,  12874,  12875,  12876,   2010,  12877,   6702,   3941,
    2221,   4126,  12878,  12879,  12880,   2933,  12881,  12882,
    4589,   6704,   6707,  12883,  12884,   2377,  12885,   1516,
    2691,  12886,   6890,   6708,  12887,   6711,  12888,   6716,
   12889,  12890,  12891,  12892,   6717,  12893,   3988,   1478,
   12894,   2548,  12895,  12896,   2280,  12897,  12898,   6706,
   12899,   4222,  12900,   6715,  12901,  12902,  12903,  12904,
    4315,  12905,  12906,  12907,  12908,   4964,  12909,   3061,
    6709,  12910,   3217,  12911,   2346,   4987,   6713,  12912,
   12913,  12914,   3917,   4863,  12915,   6705,  12916,   6710,
    6712,  12917,   3596,   2134,  12918,   6714,  12919,   2880,
    6723,  12920,  12921,   6728,  12922,   6726,   2597,   2584,
    6732,  12923,  12924,  12925,  12926,  12927,  12928,  12929,
   12930,   6735,  12931,   6731,   1593,  12932,  12933,  12934,
   12935,  12936,  12937,  12938,  12939,  12940,  12941,   1465,
    3308,   2205,   3543,   3695,   3730,  12942,  12943,  12944,
    6720,   6725,   6727,  12945,   2336,   6729,   5160,  12946,
    3380,  12947,   6733,  12948,  12949,   1670,  12950,  12951,
   12952,   6722,  12953,  12954,   2614,  12955,  12956,   2853,
    6718,   5070,  12957,   3095,   1678,  12958,  12959,  12960,
   12961,  12962,  12963,  12964,  12965,   6736,  12966,   3886,
    6730,  12967,  12968,  12969,  12970,   4891,  12971,   1577,
    4914,   6719,   6721,   1989,   6724,  12972,   6734,   2937,
   12973,   3940,  12974,   3955,  12975,  12976,   3537,   2998,
   12977,  12978,  12979,  12980,  12981,   6746,  12982,  12983,
   12984,   4420,  12985,  12986,  12987,  12988,  12989,  12990,
   12991,   6755,   5055,  12992,  12993,  12994,  12995,  12996,
   12997,  12998,   6737,   6738,  12999,  13000,  13001,   4600,
    2392,   2250,  13002,  13003,   2242,   4845,   6752,  13004,
    6751,   6749,   2335,   4091,   6743,   4235,   2901,  13005,
    1433,   6754,   6753,  13006,   5107,  13007,   6741,  13008,
    4144,   3762,  13009,   2467,   2690,   6747,  13010,  13011,
   13012,  13013,  13014,  13015,  13016,  13017,  13018,  13019,
    6739,   6740,   6742,   1900,   6744,   3608,   6748,   6750,
    2647,   5089,  13020,   6761,  13021,  13022,  13023,  13024,
   13025,  13026,  13027,  13028,   6758,  13029,   4151,   6759,
   13030,  13031,  13032,  13033,  13034,  13035,  13036,  13037,
   13038,   3033,  13039,   6745,  13040,   3218,   1489,  13041,
   13042,  13043,  13044,  13045,  13046,  13047,  13048,   6757,
   13049,  13050,  13051,   6760,  13052,  13053,  13054,   2258,
   13055,  13056,  13057,  13058,  13059,  13060,  13061,  13062,
   13063,  13064,   3809,  13065,  13066,  13067,   3241,   4293,
    2983,  13068,  13069,  13070,  13071,   4030,  13072,   4102,
    4438,  13073,  13074,   3918,  13075,   6756,  13076,  13077,
   13078,  13079,  13080,  13081,  13082,  13083,  13084,  13085,
    2613,  13086,   6762,  13087,  13088,  13089,  13090,  13091,
   13092,   3257,  13093,   3546,  13094,   2342,  13095,  13096,
   13097,  13098,   1493,  13099,  13100,   5131,  13101,  13102,
    2549,  13103,   3462,  13104,  13105,  13106,  13107,  13108,
    4077,  13109,  13110,   6773,  13111,  13112,  13113,  13114,
   13115,  13116,  13117,  13118,  13119,  13120,   3772,  13121,
    6769,   2979,  13122,  13123,  13124,   2854,  13125,  13126,
   13127,   6767,   2310,  13128,   6764,  13129,  13130,  13131,
   13132,   6771,  13133,  13134,  13135,   4651,  13136,  13137,
   13138,  13139,  13140,   6770,  13141,   4999,   5096,  13142,
    6774,  13143,   2654,  13144,  13145,  13146,  13147,  13148,
   13149,  13150,  13151,  13152,  13153,  13154,  13155,   6765,
    6766,  13156,  13157,  13158,   6768,  13159,  13160,  13161,
   13162,  13163,  13164,  13165,  13166,   4189,  13167,  13168,
    4617,  13169,  13170,  13171,   6785,  13172,  13173,  13174,
   13175,   6776,  13176,  13177,  13178,   1795,  13179,   1812,
   13180,  13181,   6778,  13182,  13183,  13184,  13185,  13186,
   13187,  13188,  13189,  13190,  13191,  13192,  13193,  13194,
   13195,  13196,  13197,  13198,   4425,  13199,  13200,   6772,
   13201,  13202,   1785,  13203,  13204,   6779,   2980,  13205,
    6777,  13206,  13207,   6792,  13208,  13209,   6791,  13210,
   13211,  13212,  13213,   6781,  13214,  13215,   6763,  13216,
   13217,   6775,  13218,  13219,  13220,  13221,  13222,   2831,
    6784,   6793,  13223,  13224,   3106,  13225,  13226,  13227,
    6782,  13228,   2198,  13229,   6780,  13230,   4759,   6787,
    6788,   6790,  13231,  13232,  13233,   6806,  13234,  13235,
   13236,  13237,  13238,  13239,   2951,   6804,  13240,  13241,
    6783,  13242,  13243,   6794,   1490,  13244,  13245,  13246,
   13247,  13248,  13249,  13250,  13251,  13252,  13253,   6795,
    4892,  13254,  13255,   6797,  13256,   6798,  13257,  13258,
   13259,   6800,  13260,  13261,   3088,  13262,  13263,   3687,
   13264,  13265,  13266,   6796,  13267,  13268,  13269,  13270,
   13271,   6801,  13272,  13273,  13274,  13275,  13276,  13277,
   13278,  13279,   6802,  13280,   6786,  13281,   6789,  13282,
    2460,  13283,  13284,  13285,   6799,  13286,  13287,  13288,
   13289,  13290,  13291,   2624,  13292,  13293,  13294,   6803,
    6805,  13295,  13296,  13297,  13298,  13299,  13300,  13301,
   13302,  13303,  13304,  13305,  13306,   6809,  13307,  13308,
   13309,  13310,   6813,  13311,  13312,  13313,  13314,  13315,
   13316,  13317,  13318,  13319,  13320,   1656,  13321,   6807,
   13322,  13323,  13324,  13325,  13326,  13327,  13328,  13329,
   13330,  13331,   2081,  13332,  13333,  13334,  13335,  13336,
   13337,  13338,  13339,  13340,  13341,  13342,  13343,   6810,
    6811,  13344,  13345,  13346,  13347,  13348,  13349,   4920,
   13350,   3292,  13351,  13352,  13353,  13354,  13355,  13356,
    6823,  13357,   2414,  13358,  13359,  13360,  13361,   6808,
   13362,   4702,  13363,  13364,  13365,   6819,  13366,  13367,
   13368,  13369,  13370,  13371,  13372,   6822,   6815,  13373,
   13374,  13375,  13376,  13377,   6814,  13378,  13379,   3604,
   13380,  13381,  13382,  13383,  13384,  13385,  13386,  13387,
    6817,  13388,  13389,  13390,  13391,  13392,  13393,  13394,
    6824,   1731,  13395,   6818,  13396,  13397,  13398,  13399,
   13400,   4403,  13401,  13402,  13403,   6812,  13404,  13405,
   13406,  13407,  13408,  13409,  13410,  13411,  13412,  13413,
   13414,   1778,  13415,  13416,  13417,  13418,  13419,  13420,
   13421,   6821,  13422,  13423,   6825,  13424,  13425,  13426,
    4061,  13427,  13428,  13429,   4336,  13430,  13431,  13432,
   13433,  13434,  13435,  13436,  13437,  13438,   6820,  13439,
    6827,   6826,  13440,  13441,  13442,  13443,  13444,   6829,
   13445,  13446,  13447,  13448,  13449,  13450,  13451,  13452,
    6816,  13453,  13454,  13455,  13456,  13457,  13458,  13459,
   13460,   6828,  13461,   6830,   3237,  13462,  13463,  13464,
   13465,  13466,  13467,  13468,  13469,  13470,  13471,  13472,
   13473,  13474,  13475,  13476,  13477,  13478,  13479,  13480,
   13481,  13482,  13483,  13484,  13485,  13486,  13487,  13488,
   13489,  13490,  13491,  13492,  13493,  13494,  13495,  13496,
   13497,  13498,  13499,  13500,  13501,  13502,  13503,  13504,
   13505,  13506,  13507,  13508,  13509,  13510,  13511,  13512,
   13513,  13514,  13515,  13516,  13517,  13518,  13519,  13520,
   13521,  13522,  13523,  13524,  13525,  13526,  13527,  13528,
   13529,  13530,  13531,  13532,  13533,  13534,  13535,  13536,
   13537,  13538,  13539,  13540,  13541,  13542,  13543,  13544,
   13545,  13546,  13547,  13548,  13549,  13550,  13551,  13552,
   13553,  13554,  13555,  13556,  13557,  13558,  13559,  13560,
   13561,  13562,  13563,  13564,  13565,  13566,  13567,  13568,
   13569,  13570,  13571,  13572,  13573,  13574,  13575,  13576,
    3594,   1831,   2465,   4449,   7052,  13577,  13578,   3406,
   13579,  13580,  13581,  13582,  13583,  13584,  13585,  13586,
   13587,  13588,   4790,  13589,  13590,  13591,  13592,   7053,
   13593,   7054,   3536,  13594,  13595,  13596,   2897,  13597,
   13598,  13599,  13600,   7055,  13601,  13602,   7056,   4427,
   13603,   3595,  13604,  13605,   2233,  13606,  13607,  13608,
   13609,  13610,  13611,  13612,  13613,  13614,  13615,  13616,
   13617,   7057,  13618,  13619,  13620,  13621,  13622,  13623,
   13624,  13625,   5006,   4980,   1828,   1626,   4297,   3548,
   13626,  13627,   4200,  13628,  13629,  13630,  13631,  13632,
   13633,  13634,  13635,  13636,  13637,  13638,  13639,  13640,
   13641,   1870,  13642,   3979,   2600,  13643,  13644,  13645,
   13646,   6833,   6834,   4585,   6836,  13647,   1874,   6835,
   13648,   4530,   3919,   1645,  13649,   6839,  13650,  13651,
   13652,  13653,   6837,   6838,  13654,  13655,   5000,  13656,
   13657,  13658,   6840,   6841,  13659,  13660,  13661,  13662,
   13663,   6842,  13664,  13665,  13666,  13667,  13668,  13669,
   13670,  13671,   6843,  13672,  13673,  13674,  13675,  13676,
   13677,  13678,  13679,   7064,   3408,   2019,  13680,   4688,
   13681,  13682,  13683,  13684,  13685,  13686,  13687,   1957,
   13688,   2500,   7066,  13689,  13690,   4672,  13691,  13692,
   13693,  13694,  13695,   4296,  13696,   3313,  13697,   3226,
   13698,  13699,   2003,   5194,   1543,   1550,   1552,   3477,
   13700,   1551,  13701,   3206,  13702,  13703,  13704,  13705,
   13706,   4904,  13707,  13708,  13709,  13710,  13711,  13712,
   13713,  13714,   6959,   2382,  13715,  13716,  13717,   4067,
   13718,  13719,  13720,   6960,  13721,   6962,  13722,  13723,
   13724,   6963,  13725,  13726,  13727,   6961,  13728,  13729,
   13730,  13731,  13732,  13733,  13734,   6964,   6966,   6965,
   13735,  13736,  13737,  13738,  13739,   6967,  13740,   3900,
    5190,   3276,  13741,   3200,   3565,   6968,   3331,  13742,
    6969,   6970,   6971,   2120,  13743,  13744,  13745,   2157,
   13746,   6972,   3637,  13747,   6974,  13748,   2353,   4596,
    1426,   6973,   6975,  13749,  13750,  13751,   1889,   3141,
    3643,  13752,   6976,  13753,   3961,   6266,  13754,  13755,
    4731,  13756,  13757,  13758,  13759,   5322,  13760,  13761,
    4136,   4994,   3654,  13762,  13763,  13764,   5327,   2510,
   13765,   2375,   6269,  13766,  13767,  13768,  13769,  13770,
    4334,  13771,  13772,  13773,   6267,   3798,  13774,   2374,
   13775,  13776,  13777,   4531,   6268,   3739,   2270,   2644,
    1747,   4288,  13778,  13779,   4073,  13780,  13781,  13782,
    6275,   6276,   4219,  13783,  13784,  13785,  13786,  13787,
    4054,  13788,   2556,  13789,   6277,  13790,   6278,  13791,
   13792,   4475,  13793,  13794,  13795,   3568,   2125,  13796,
   13797,   3634,   4647,   4283,  13798,   6271,   6279,  13799,
    3841,   1724,  13800,  13801,   6274,  13802,  13803,   3544,
    6272,  13804,  13805,   7162,   6273,  13806,  13807,  13808,
   13809,   3778,  13810,   3453,  13811,  13812,  13813,   2276,
   13814,   3222,  13815,   6270,   3412,   3011,   3158,   1652,
   13816,   6280,   2449,   3302,  13817,   6283,   2783,  13818,
   13819,   6294,   6288,   2400,  13820,  13821,  13822,  13823,
    2115,   4744,  13824,   5027,   4938,   2288,   4907,   4567,
   13825,  13826,  13827,  13828,   4442,   3657,  13829,  13830,
   13831,   3675,   1617,  13832,   3253,  13833,  13834,  13835,
    6281,  13836,  13837,   6295,   6282,   2075,   6290,   6287,
   13838,  13839,  13840,   2093,  13841,  13842,   3385,  13843,
    6289,   3444,   1605,   3569,  13844,   3353,  13845,  13846,
    5077,  13847,   2978,   6292,  13848,  13849,   6293,   6296,
    4050,   6286,  13850,   4729,  13851,   1538,   7163,   6284,
    6285,  13852,   6291,   4443,   3512,   4876,   6297,  13853,
   13854,   2695,  13855,  13856,   6304,  13857,  13858,   6303,
   13859,  13860,  13861,   4594,   6300,  13862,   6306,  13863,
   13864,  13865,   3752,  13866,  13867,  13868,  13869,   4343,
   13870,   6305,   6311,   3170,  13871,  13872,   1993,  13873,
   13874,  13875,  13876,  13877,  13878,   2713,  13879,   6299,
   13880,  13881,   2422,   6307,  13882,  13883,   6309,  13884,
   13885,   2066,   5043,   6315,  13886,   6310,  13887,  13888,
   13889,   6298,  13890,   2521,   4196,   3573,   3424,  13891,
   13892,   3094,  13893,   6301,  13894,   3590,   2643,   2660,
    6302,  13895,   5114,   1663,  13896,   6308,   2572,   6312,
   13897,   2518,   6313,   3391,   6314,  13898,  13899,  13900,
   13901,   4954,   2822,  13902,   6323,  13903,   6320,  13904,
    6324,  13905,  13906,   6326,  13907,  13908,   3531,  13909,
   13910,   2387,   2956,  13911,  13912,  13913,   2162,   6317,
   13914,  13915,  13916,  13917,   4794,  13918,  13919,   2352,
    2725,  13920,  13921,  13922,   6325,  13923,  13924,  13925,
   13926,  13927,   4166,  13928,  13929,   3378,  13930,  13931,
    4414,   3829,  13932,  13933,   4730,  13934,   4372,  13935,
   13936,   6316,  13937,   6321,   6322,   4114,  13938,  13939,
   13940,  13941,  13942,   4087,  13943,   2965,   6318,   3023,
    6319,   4277,  13944,   2476,   1930,  13945,   3748,   2638,
    4926,   3771,   2163,   6339,  13946,  13947,   6341,   4547,
   13948,  13949,   4631,  13950,  13951,   2362,  13952,  13953,
    2401,  13954,  13955,  13956,  13957,  13958,  13959,   6332,
    1956,  13960,  13961,  13962,   5120,   6329,   4416,   6328,
   13963,  13964,  13965,   3067,   4083,  13966,  13967,  13968,
   13969,   3924,  13970,  13971,  13972,  13973,   3344,  13974,
    4093,   6337,  13975,  13976,  13977,   6336,   6330,  13978,
    6333,   1892,  13979,  13980,   4756,  13981,   6335,  13982,
   13983,  13984,  13985,   4694,   1852,  13986,   2463,  13987,
   13988,   3837,  13989,   1815,  13990,  13991,  13992,   2519,
   13993,   4556,  13994,   4118,   7164,  13995,  13996,  13997,
   13998,  13999,  14000,  14001,  14002,   3640,  14003,  14004,
   14005,  14006,   4801,  14007,   6340,   5128,   6331,  14008,
    2636,   6334,  14009,  14010,   4769,  14011,   6338,   3847,
   14012,  14013,   6327,  14014,  14015,   4768,  14016,  14017,
    3665,   2014,  14018,   4885,   1616,   6352,  14019,  14020,
   14021,   4263,  14022,   6342,  14023,   4257,  14024,   2220,
   14025,  14026,   6351,  14027,   2861,  14028,  14029,  14030,
    4745,  14031,   3271,  14032,  14033,  14034,  14035,  14036,
   14037,  14038,  14039,   3423,   6353,  14040,  14041,  14042,
   14043,  14044,  14045,  14046,  14047,   4171,   6344,  14048,
   14049,  14050,  14051,   6349,   6350,  14052,   2443,  14053,
    4393,  14054,  14055,   4918,  14056,  14057,  14058,   6347,
   14059,  14060,  14061,  14062,  14063,  14064,  14065,  14066,
   14067,  14068,  14069,   6345,  14070,  14071,   6343,  14072,
   14073,  14074,  14075,  14076,  14077,  14078,  14079,  14080,
   14081,  14082,  14083,  14084,  14085,  14086,   4204,   3863,
   14087,  14088,  14089,   2916,  14090,   2637,   6348,  14091,
   14092,   2201,  14093,  14094,  14095,  14096,  14097,   6368,
    4813,  14098,  14099,  14100,  14101,  14102,  14103,  14104,
    6356,  14105,  14106,  14107,   3086,  14108,  14109,   6370,
   14110,  14111,   4676,  14112,  14113,   6360,  14114,   6361,
   14115,  14116,   4333,  14117,  14118,  14119,  14120,   4008,
   14121,   6355,   6346,  14122,   6366,  14123,   3725,   6364,
   14124,  14125,   3360,   6363,  14126,   6362,  14127,  14128,
   14129,   1783,   6369,  14130,  14131,  14132,  14133,   1944,
   14134,  14135,  14136,   5119,  14137,  14138,  14139,   6367,
   14140,   2455,  14141,   5125,   4088,   7043,  14142,   6365,
   14143,  14144,   2341,  14145,  14146,  14147,   5026,   6354,
    6357,   3191,   6359,  14148,   3144,   2949,   3149,  14149,
    1588,   4059,  14150,  14151,  14152,  14153,  14154,  14155,
   14156,  14157,  14158,  14159,   1925,  14160,  14161,  14162,
   14163,   6376,  14164,  14165,  14166,  14167,  14168,  14169,
   14170,  14171,   3492,  14172,  14173,  14174,   3542,  14175,
   14176,   6382,  14177,  14178,  14179,  14180,  14181,   3110,
   14182,  14183,  14184,   2989,   4572,   6375,  14185,  14186,
   14187,  14188,  14189,  14190,  14191,  14192,  14193,  14194,
    3303,  14195,  14196,  14197,   6374,  14198,  14199,  14200,
   14201,   6383,   6381,   3195,  14202,   6358,  14203,   6377,
   14204,   3947,  14205,   4923,  14206,  14207,   6378,  14208,
   14209,  14210,  14211,  14212,  14213,  14214,   4601,  14215,
   14216,  14217,  14218,  14219,  14220,  14221,   6372,   6373,
   14222,  14223,  14224,   6379,  14225,   4240,  14226,  14227,
   14228,  14229,  14230,  14231,  14232,  14233,  14234,  14235,
    3426,  14236,  14237,  14238,   3588,  14239,   3127,  14240,
   14241,  14242,   6371,  14243,  14244,  14245,   3049,  14246,
   14247,  14248,  14249,  14250,  14251,   4063,   1708,  14252,
   14253,  14254,   6388,  14255,   6380,  14256,  14257,  14258,
    6387,  14259,   6390,  14260,   6389,  14261,  14262,  14263,
   14264,  14265,  14266,  14267,   1737,  14268,  14269,  14270,
    1717,   6384,  14271,  14272,   6386,   6385,   3459,  14273,
   14274,  14275,  14276,  14277,  14278,  14279,  14280,  14281,
   14282,  14283,  14284,  14285,   2942,  14286,  14287,  14288,
   14289,   4865,  14290,  14291,  14292,  14293,  14294,   6393,
   14295,  14296,  14297,  14298,  14299,  14300,  14301,  14302,
   14303,  14304,  14305,   1445,  14306,  14307,   6395,  14308,
   14309,   6394,  14310,  14311,  14312,  14313,  14314,  14315,
    2541,  14316,   6396,  14317,  14318,  14319,  14320,  14321,
   14322,   6392,  14323,  14324,  14325,  14326,  14327,  14328,
   14329,   6391,   1587,  14330,  14331,  14332,  14333,  14334,
   14335,  14336,  14337,  14338,  14339,  14340,   6399,  14341,
    6400,   6397,  14342,  14343,  14344,  14345,  14346,  14347,
   14348,  14349,  14350,  14351,  14352,  14353,   6398,   6401,
   14354,  14355,  14356,  14357,  14358,  14359,  14360,  14361,
   14362,  14363,  14364,  14365,  14366,  14367,  14368,  14369,
   14370,  14371,  14372,  14373,  14374,  14375,  14376,  14377,
   14378,  14379,  14380,  14381,  14382,  14383,  14384,  14385,
   14386,   3534,  14387,  14388,  14389,  14390,  14391,  14392,
   14393,  14394,   6402,   6404,  14395,  14396,  14397,  14398,
   14399,  14400,  14401,   6403,  14402,  14403,  14404,  14405,
   14406,  14407,  14408,  14409,  14410,  14411,  14412,  14413,
   14414,  14415,  14416,  14417,  14418,   6406,  14419,  14420,
   14421,   6405,  14422,  14423,  14424,  14425,  14426,  14427,
   14428,  14429,  14430,  14431,  14432,  14433,  14434,  14435,
   14436,  14437,  14438,  14439,   2319,  14440,  14441,   6407,
   14442,  14443,  14444,  14445,  14446,  14447,  14448,  14449,
   14450,  14451,  14452,  14453,  14454,  14455,   6408,  14456,
   14457,  14458,  14459,  14460,  14461,  14462,  14463,  14464,
   14465,  14466,  14467,   2523,   7114,   3275,  14468,   1917,
    2493,  14469,  14470,  14471,  14472,   3080,   4871,  14473,
    2761,  14474,  14475,  14476,   5113,  14477,   4847,   1648,
    7079,  14478,  14479,  14480,  14481,   6894,  14482,  14483,
   14484,   3116,   1807,  14485,  14486,  14487,   4566,  14488,
   14489,  14490,   1711,  14491,   3683,   2846,   7081,  14492,
   14493,   5024,  14494,  14495,   7080,   7082,  14496,  14497,
   14498,  14499,  14500,  14501,  14502,  14503,  14504,  14505,
   14506,  14507,  14508,   7086,   2795,   4072,   3441,   2753,
   14509,   7087,  14510,   1597,  14511,  14512,  14513,   7085,
    4895,   1946,  14514,   7083,   3029,   1758,  14515,  14516,
    7084,   3971,   2948,   4135,  14517,  14518,  14519,  14520,
    3057,  14521,   7089,  14522,  14523,  14524,  14525,  14526,
   14527,  14528,  14529,  14530,  14531,  14532,  14533,  14534,
    2419,   2964,  14535,   5063,  14536,  14537,  14538,   4555,
   14539,  14540,  14541,  14542,   2849,  14543,   2086,   3812,
    7088,   2509,  14544,   4085,   2724,   3705,  14545,   4332,
   14546,  14547,  14548,  14549,  14550,  14551,  14552,   4208,
   14553,   3458,  14554,  14555,  14556,   2140,  14557,  14558,
   14559,  14560,  14561,  14562,  14563,  14564,  14565,  14566,
   14567,   4552,   2373,  14568,  14569,  14570,  14571,  14572,
    7090,  14573,  14574,   7091,  14575,   2475,   7092,  14576,
    7115,   1529,   2124,  14577,  14578,  14579,  14580,  14581,
   14582,  14583,  14584,  14585,  14586,  14587,   2656,  14588,
   14589,  14590,  14591,  14592,  14593,  14594,  14595,   7093,
    4581,   7094,  14596,  14597,  14598,  14599,   3692,  14600,
   14601,  14602,  14603,  14604,  14605,  14606,  14607,  14608,
   14609,  14610,  14611,  14612,  14613,   7098,  14614,  14615,
   14616,  14617,   7100,  14618,   2488,  14619,   2606,  14620,
   14621,  14622,  14623,  14624,  14625,  14626,  14627,  14628,
   14629,  14630,  14631,  14632,   7096,  14633,   3782,  14634,
   14635,  14636,  14637,  14638,   3221,  14639,   7116,   4940,
    7097,  14640,  14641,  14642,  14643,  14644,   5064,  14645,
   14646,  14647,   7099,   7095,  14648,  14649,  14650,  14651,
    7101,  14652,   7102,  14653,  14654,   3790,  14655,  14656,
   14657,  14658,  14659,  14660,   4331,  14661,  14662,  14663,
   14664,  14665,   4477,  14666,  14667,  14668,  14669,   4523,
   14670,  14671,  14672,  14673,   3724,  14674,  14675,  14676,
    7103,   4314,  14677,  14678,  14679,  14680,  14681,   3929,
    7107,  14682,  14683,  14684,  14685,  14686,  14687,  14688,
    7106,  14689,  14690,  14691,   1439,  14692,  14693,  14694,
   14695,  14696,  14697,   7104,  14698,   7105,  14699,  14700,
   14701,   7117,  14702,  14703,  14704,  14705,  14706,  14707,
   14708,  14709,  14710,   3693,  14711,  14712,  14713,  14714,
   14715,  14716,  14717,  14718,  14719,  14720,   3046,  14721,
   14722,  14723,  14724,  14725,   7109,   4575,  14726,  14727,
   14728,  14729,  14730,  14731,  14732,  14733,  14734,  14735,
    7108,  14736,  14737,  14738,  14739,   4872,  14740,   7110,
   14741,  14742,  14743,  14744,  14745,  14746,   5489,  14747,
   14748,  14749,  14750,  14751,  14752,  14753,  14754,  14755,
   14756,   7111,  14757,  14758,  14759,  14760,  14761,  14762,
   14763,  14764,  14765,  14766,  14767,  14768,   1515,  14769,
   14770,  14771,  14772,  14773,  14774,  14775,  14776,  14777,
   14778,  14779,  14780,  14781,  14782,  14783,  14784,  14785,
   14786,  14787,  14788,  14789,  14790,   7112,  14791,  14792,
   14793,  14794,  14795,  14796,  14797,  14798,  14799,  14800,
    7113,  14801,   5081,  14802,   3415,  14803,  14804,  14805,
    6983,   1423,  14806,  14807,  14808,   2809,   2185,   4620,
    1463,   1968,  14809,   5188,  14810,   3959,  14811,   6264,
   14812,  14813,  14814,  14815,  14816,  14817,  14818,   3489,
    1479,  14819,  14820,  14821,   3421,   6980,  14822,  14823,
   14824,  14825,   6981,  14826,  14827,  14828,   6982,  14829,
   14830,   4543,  14831,   3386,  14832,   6943,  14833,   3307,
   14834,   3310,   2959,  14835,  14836,  14837,   6944,   3322,
   14838,   4308,  14839,  14840,  14841,  14842,   6941,   6945,
   14843,  14844,   3851,  14845,  14846,   3574,  14847,  14848,
   14849,   4097,   4323,  14850,  14851,  14852,   6946,   6947,
    4335,   2984,  14853,  14854,   6948,  14855,  14856,  14857,
   14858,  14859,   2004,   6949,  14860,   6950,  14861,   6951,
   14862,  14863,   6952,  14864,  14865,  14866,  14867,  14868,
   14869,  14870,  14871,  14872,  14873,  14874,  14875,   6942,
   14876,  14877,  14878,  14879,  14880,  14881,  14882,  14883,
   14884,  14885,  14886,  14887,   3679,   6090,  14888,   2091,
    6091,  14889,  14890,  14891,   6092,  14892,   5095,   6093,
    6094,   4743,  14893,  14894,  14895,  14896,  14897,  14898,
   14899,   6096,   2900,   6095,   1929,  14900,  14901,  14902,
    1526,  14903,  14904,  14905,  14906,   6098,   6097,  14907,
    2441,  14908,   6099,  14909,  14910,  14911,  14912,   2278,
   14913,   2774,  14914,  14915,  15780,  15781,   3381,  15782,
    2410,   2669,  15783,  15784,  15785,  15786,  15787,  15788,
    6100,   6102,  15789,  15790,   2005,   4356,   3861,   6101,
    4975,   4791,   6103,   6107,   6104,  15791,  15792,   6105,
    2987,  15793,   6109,   6110,   2952,  15794,  15795,  15796,
   15797,   6106,  15798,   6108,  15799,  15800,  15801,  15802,
   15803,  15804,   6114,  15805,  15806,  15807,   3059,  15808,
   15809,  15810,  15811,   6112,  15812,   6117,   1691,   6111,
   15813,  15814,  15815,   3240,   1631,   6116,   6115,  15816,
   15817,   6113,   6118,  15818,  15819,   6120,  15820,  15821,
   15822,   4458,   5058,   3203,   6121,  15823,   4378,  15824,
   15825,   6123,  15826,  15827,   2428,  15828,  15829,   6831,
    6122,   6119,  15830,  15831,  15832,  15833,   2454,   4812,
   15834,  15835,  15836,  15837,  15838,  15839,  15840,  15841,
   15842,  15843,  15844,  15845,  15846,   6125,  15847,  15848,
    6124,  15849,   6832,  15850,  15851,  15852,  15853,   6126,
   15854,  15855,  15856,  15857,  15858,  15859,  15860,  15861,
    6127,  15862,  15863,  15864,  15865,  15866,  15867,  15868,
   15869,  15870,  15871,  15872,   6128,   4042,  15873,   6129,
   15874,  15875,  15876,  15877,  15878,  15879,  15880,  15881,
   15882,  15883,  15884,  15885,  15886,  15887,   6130,  15888,
   15889,  15890,  15891,  15892,   4511,  15893,  15894,   3143,
   15895,   4780,  15896,   4220,  15897,  15898,   6643,  15899,
   15900,   6644,  15901,  15902,  15903,  15904,   2758,  15905,
   15906,  15907,  15908,   3175,  15909,  15910,  15911,   6647,
   15912,  15913,   6646,  15914,  15915,  15916,  15917,  15918,
   15919,   4205,  15920,   3216,  15921,  15922,   6645,   2466,
    4377,  15923,   3072,   6652,  15924,  15925,  15926,   6651,
   15927,  15928,   6663,   1600,  15929,  15930,  15931,  15932,
    6653,  15933,   6649,  15934,  15935,  15936,  15937,  15938,
    6655,   6654,   3785,  15939,  15940,   4955,  15941,   6648,
    2076,   6650,  15942,  15943,  15944,  15945,  15946,  15947,
   15948,   6657,  15949,  15950,  15951,  15952,   6662,  15953,
    5054,  15954,  15955,  15956,  15957,   6656,  15958,   6661,
   15959,   6660,  15960,  15961,  15962,   1473,  15963,  15964,
   15965,  15966,   6664,  15967,  15968,  15969,  15970,  15971,
   15972,  15973,  15974,  15975,  15976,  15977,  15978,  15979,
   15980,  15981,  15982,   3653,  15983,   2950,   2990,  15984,
   15985,   3087,   6659,  15986,  15987,  15988,  15989,   6665,
    4033,  15990,  15991,  15992,  15993,  15994,  15995,  15996,
   15997,  15998,   6675,   6674,  15999,  16000,  16001,  16002,
   16003,  16004,   5108,  16005,  16006,   6669,   6668,  16007,
    6670,  16008,   6666,  16009,   6673,  16010,   6672,  16011,
    6671,  16012,  16013,   3060,   3628,   3476,   3418,  16014,
   16015,  16016,  16017,  16018,   3648,  16019,  16020,  16021,
   16022,   6676,  16023,  16024,  16025,  16026,  16027,  16028,
   16029,  16030,  16031,  16032,  16033,  16034,  16035,  16036,
   16037,  16038,  16039,  16040,  16041,   6679,  16042,   6678,
   16043,   6680,   2436,   6667,   6677,  16044,   3745,   3769,
   16045,  16046,  16047,  16048,  16049,  16050,  16051,  16052,
   16053,  16054,  16055,  16056,  16057,   6682,  16058,  16059,
    2324,  16060,  16061,  16062,  16063,  16064,   4605,   6681,
   16065,  16066,  16067,  16068,  16069,  16070,   6683,  16071,
    6686,   6687,  16072,   3014,  16073,  16074,  16075,   6688,
   16076,  16077,  16078,   6689,  16079,  16080,   6685,  16081,
    6693,  16082,  16083,  16084,  16085,  16086,  16087,  16088,
   16089,  16090,  16091,  16092,   6684,  16093,   6690,  16094,
   16095,  16096,  16097,  16098,  16099,  16100,  16101,   6694,
    6691,   6692,  16102,  16103,  16104,  16105,  16106,  16107,
   16108,  16109,  16110,  16111,  16112,  16113,  16114,  16115,
   16116,  16117,   6696,  16118,  16119,  16120,  16121,  16122,
   16123,  16124,  16125,  16126,  16127,  16128,  16129,  16130,
   16131,  16132,  16133,  16134,  16135,  16136,  16137,  16138,
   16139,  16140,   6695,  16141,  16142,  16143,  16144,  16145,
   16146,  16147,  16148,  16149,   2302,  16150,   7437,  16151,
    7438,  16152,   3493,   1483,   3696,  16153,   4198,  16154,
   16155,  16156,  16157,  16158,  16159,  16160,   4274,   6878,
   16161,  16162,  16163,  16164,   6879,  16165,   3508,   1826,
   16166,  16167,  16168,  16169,  16170,  16171,  16172,   6880,
   16173,  16174,  16175,  16176,   4958,  16177,  16178,  16179,
   16180,  16181,  16182,  16183,  16184,   5728,  16185,   6881,
   16186,   6882,  16187,   6883,  16188,  16189,  16190,  16191,
    2203,   5843,   3844,  16192,   4121,  16193,  16194,   3849,
   16195,  16196,  16197,  16198,  16199,   3850,  16200,  16201,
    4734,   3953,  16202,   2167,   7439,   1537,  16203,   6415,
    4120,   4740,   2592,   3833,  16204,   1950,  16205,   3337,
    1952,  16206,   7251,   2456,  16207,  16208,   6641,  16209,
    7252,  16210,  16211,  16212,  16213,   1700,  16214,  16215,
    7255,  16216,  16217,   7254,   2702,  16218,   7253,   4252,
   16219,  16220,  16221,  16222,   3430,  16223,  16224,  16225,
   16226,   3091,   5497,   7256,   4500,  16227,  16228,  16229,
   16230,  16231,  16232,  16233,  16234,   3153,   3549,  16235,
   16236,  16237,   2079,  16238,  16239,  16240,  16241,  16242,
   16243,  16244,   7257,  16245,   1766,  16246,  16247,  16248,
    2534,   7258,  16249,  16250,  16251,  16252,  16253,   6639,
   16254,  16255,  16256,   7259,  16257,  16258,   2645,  16259,
   16260,  16261,  16262,   7585,  16263,  16264,  16265,   3925,
   16266,   4646,   7483,  16267,   7484,  16268,   7485,   3045,
   16269,   2238,   2771,  16270,  16271,   7487,  16272,   3400,
    7486,   4592,  16273,   7489,   1453,   2705,  16274,  16275,
   16276,  16277,  16278,   4668,   7488,  16279,   1800,   2139,
    7495,   7494,   3480,   7490,   7491,   1820,  16280,  16281,
    7492,   4965,  16282,  16283,   4100,   2775,   2555,  16284,
   16285,  16286,   7497,   7496,   7493,   1598,  16287,   4983,
    4723,   2748,   3677,  16288,  16289,   7499,  16290,  16291,
   16292,  16293,   4598,  16294,   5025,   2408,   7498,  16295,
    2000,  16296,  16297,   4155,  16298,  16299,   3483,  16300,
   16301,  16302,   3008,   7500,   7503,  16303,   7502,   7505,
    7501,  16304,   2473,   7504,  16305,  16306,  16307,  16308,
    4062,   7507,  16309,  16310,   1744,  16311,  16312,  16313,
   16314,   1555,  16315,  16316,   7508,  16317,  16318,   7509,
    7511,   1850,  16319,   7506,  16320,   7512,  16321,  16322,
   16323,  16324,   7515,  16325,   7513,  16326,  16327,  16328,
    7510,  16329,  16330,  16331,  16332,   7518,  16333,   7514,
    7517,   7519,  16334,   7520,  16335,  16336,  16337,   4262,
    7523,  16338,   7522,  16339,   3093,   7516,   3914,  16340,
   16341,   1866,   1584,   4058,  16342,   7525,  16343,  16344,
    7526,  16345,  16346,   7531,   4933,   7528,  16347,  16348,
    3684,  16349,  16350,  16351,   7521,  16352,   7530,   7527,
    7524,  16353,  16354,   7529,  16355,  16356,  16357,  16358,
   16359,  16360,  16361,  16362,   1418,   7532,  16363,  16364,
   16365,  16366,  16367,  16368,   7534,  16369,   7536,  16370,
   16371,  16372,  16373,  16374,   7535,  16375,   7533,  16376,
   16377,  16378,  16379,   4513,  16380,  16381,  16382,  16383,
   16384,  16385,  16386,   7537,  16387,  16388,  16389,   7538,
   16390,  16391,  16392,  16393,  16394,  16395,  16396,  16397,
    2334,  16398,  16399,   1918,  16400,   1464,   1466,  16401,
   16402,  16403,   4870,  16404,   1915,  16405,   2683,   2485,
    7432,  16406,  16407,   2223,  16408,  16409,   7433,  16410,
   16411,   1417,  16412,   7434,  16413,  16414,   4213,  16415,
   16416,   7435,  16417,  16418,  16419,  16420,  16421,  16422,
   16423,  16424,  16425,  16426,   7436,  16427,  16428,  16429,
   16430,  16431,  16432,  16433,  16434,  16435,   3481,  16436,
   16437,   5050,   7587,  16438,   7588,  16439,  16440,  16441,
   16442,  16443,  16444,  16445,  16446,  16447,  16448,   3278,
   16449,  16450,   4758,  16451,  16452,   5030,   3455,  16453,
    4714,  16454,   4675,  16455,  16456,   7270,   1436,   4908,
    4557,   2601,   2397,  16457,   2907,  16458,   2200,   1912,
    3427,  16459,  16460,   3855,  16461,  16462,  16463,   3238,
   16464,  16465,  16466,  16467,  16468,   7271,  16469,  16470,
   16471,  16472,  16473,  16474,  16475,  16476,   3320,   1975,
   16477,   7219,   3199,  16478,   4998,  16479,  16480,  16481,
    4387,   7222,  16482,  16483,   3429,  16484,   2033,  16485,
   16486,   3854,  16487,  16488,   7220,  16489,  16490,   7223,
    7224,   3223,  16491,   2839,  16492,   7221,  16493,  16494,
   16495,  16496,  16497,  16498,  16499,  16500,  16501,  16502,
   16503,   7227,   7225,  16504,  16505,  16506,  16507,   4957,
    3258,  16508,   7226,  16509,  16510,  16511,   7229,  16512,
    4890,   4514,  16513,  16514,  16515,   7228,  16516,   3243,
   16517,  16518,  16519,  16520,  16521,   7230,   2903,   2801,
    7231,  16522,   4128,  16523,   4570,  16524,  16525,  16526,
    5112,   4973,  16527,   7235,  16528,  16529,  16530,   7234,
   16531,  16532,  16533,  16534,  16535,  16536,  16537,  16538,
    7232,   7233,  16539,  16540,  16541,  16542,  16543,  16544,
   16545,  16546,   7236,   2731,  16547,  16548,  16549,  16550,
   16551,   3962,   7238,   2002,  16552,   7239,   3321,  16553,
    7237,  16554,  16555,   2693,   1636,  16556,  16557,  16558,
   16559,  16560,  16561,  16562,  16563,  16564,  16565,  16566,
   16567,   2008,  16568,  16569,  16570,   7242,   5195,   7240,
    7243,  16571,  16572,  16573,   3268,   1773,  16574,  16575,
   16576,  16577,  16578,  16579,   7244,   7241,   4348,  16580,
   16581,   7245,   3188,  16582,  16583,  16584,  16585,  16586,
   16587,  16588,  16589,  16590,  16591,  16592,  16593,   7246,
    7247,  16594,   5744,  16595,  16596,   3496,  16597,   3609,
   16598,   5066,   1920,  16599,   3965,  16600,  16601,  16602,
    7248,  16603,  16604,   4146,  16605,   7249,  16606,  16607,
   16608,  16609,  16610,   4903,  16611,   7250,  16612,   8025,
   16613,  16614,  16615,  16616,  16617,  16618,  16619,  16620,
   16621,  16622,  16623,  16624,  16625,   5490,  16626,  16627,
   16628,  16629,  16630,  16631,  16632,  16633,  16634,   1788,
   16635,  16636,  16637,   3207,   7589,  16638,  16639,  16640,
   16641,  16642,   3877,   4656,  16643,   4991,  16644,   7413,
   16645,   2781,  16646,   2666,   7414,   2017,   1420,  16647,
   16648,  16649,  16650,   3868,  16651,  16652,   7165,  16653,
    7166,  16654,  16655,  16656,  16657,   4318,   2082,   2902,
    7167,   3176,   3775,  16658,  16659,  16660,  16661,  16662,
   16663,   7168,  16664,  16665,   3563,   2838,  16666,  16667,
   16668,   7171,   3471,  16669,   4559,  16670,   5084,   7169,
    7170,  16671,   4577,  16672,   7174,   7175,  16673,   7179,
   16674,  16675,  16676,   7183,  16677,   7181,   7189,   4959,
   16678,   7184,  16679,  16680,   7182,   7173,  16681,  16682,
    3456,  16683,  16684,  16685,   3515,  16686,  16687,   3832,
    4843,   7176,   7177,   7178,   7180,  16688,   3002,  16689,
    1786,  16690,  16691,  16692,  16693,   2327,  16694,   7191,
   16695,  16696,  16697,  16698,   7192,  16699,   7185,  16700,
    7190,  16701,   4317,  16702,  16703,   3969,   7187,   7188,
   16704,  16705,  16706,  16707,  16708,   4408,  16709,  16710,
   16711,  16712,  16713,  16714,  16715,  16716,  16717,  16718,
   16719,  16720,   7193,   3089,   4717,   7186,   3688,  16721,
   16722,  16723,  16724,  16725,  16726,  16727,  16728,   2616,
   16729,  16730,  16731,  16732,   3463,  16733,  16734,  16735,
   16736,  16737,  16738,  16739,  16740,  16741,  16742,   7197,
   16743,   1958,  16744,  16745,   3122,   1422,   4020,  16746,
   16747,   1517,  16748,   7195,  16749,  16750,  16751,   4210,
    1945,  16752,   7196,   7194,   7198,  16753,  16754,   1969,
   16755,   7199,  16756,   7200,  16757,   7203,  16758,   1547,
   16759,  16760,  16761,  16762,  16763,  16764,  16765,  16766,
    3469,   2615,   7201,   4069,   1671,  16767,  16768,  16769,
   16770,   7202,  16771,  16772,  16773,  16774,   3364,  16775,
   16776,   1822,  16777,  16778,  16779,   1494,  16780,  16781,
   16782,   7206,   2971,   1857,  16783,  16784,  16785,  16786,
    3428,  16787,  16788,  16789,   7204,   2855,  16790,  16791,
   16792,   7205,  16793,  16794,  16795,  16796,  16797,  16798,
   16799,  16800,  16801,  16802,  16803,  16804,  16805,  16806,
    3294,  16807,  16808,  16809,   7207,  16810,  16811,  16812,
   16813,  16814,   7208,  16815,   7210,  16816,  16817,   3062,
   16818,  16819,   2482,  16820,  16821,  16822,  16823,  16824,
   16825,   2655,  16826,  16827,  16828,   7209,  16829,  16830,
   16831,  16832,  16833,  16834,  16835,  16836,  16837,  16838,
   16839,  16840,  16841,   7211,  16842,  16843,  16844,  16845,
   16846,  16847,  16848,  16849,  16850,  16851,   7213,  16852,
   16853,  16854,  16855,  16856,   7212,  16857,  16858,  16859,
   16860,  16861,  16862,  16863,  16864,  16865,  16866,  16867,
   16868,  16869,  16870,  16871,   7214,  16872,  16873,  16874,
   16875,  16876,   3883,   7123,   2994,  16877,   3830,  16878,
    7124,   3555,  16879,  16880,  16881,  16882,   7125,  16883,
    3554,   7126,  16884,  16885,  16886,  16887,  16888,  16889,
   16890,  16891,  16892,   7129,  16893,  16894,   5145,   7132,
   16895,  16896,   7130,   7127,   7128,   5078,   3840,   4025,
    7133,  16897,   7131,  16898,  16899,   4396,  16900,   7135,
    3494,  16901,  16902,  16903,  16904,   2569,  16905,   7134,
   16906,  16907,  16908,  16909,  16910,  16911,  16912,   1906,
    2529,  16913,   7136,  16914,  16915,  16916,  16917,  16918,
    5350,   2722,  16919,  16920,   3128,   7137,  16921,  16922,
   16923,  16924,   7138,  16925,  16926,  16927,  16928,   2164,
   16929,  16930,  16931,  16932,  16933,  16934,  16935,  16936,
   16937,  16938,   7139,  16939,  16940,  16941,  16942,  16943,
   16944,  16945,  16946,  16947,  16948,  16949,  16950,   7140,
   16951,  16952,  16953,  16954,  16955,  16956,  16957,  16958,
   16959,  16960,  16961,   7141,  16962,  16963,  16964,  16965,
   16966,   4776,   5183,   2988,  16967,   3632,   2393,  16968,
    4484,   3976,  16969,   4161,  16970,  16971,   2210,  16972,
   16973,   1595,  16974,   3650,  16975,   5035,  16976,  16977,
   16978,   2857,   3270,  16979,  16980,   7416,  16981,  16982,
    3251,  16983,  16984,  16985,  16986,  16987,  16988,   5141,
   16989,  16990,  16991,   7418,   1742,  16992,   3627,   4588,
   16993,   5021,  16994,   7419,  16995,   7417,  16996,   2536,
    1729,  16997,  16998,  16999,  17000,  17001,  17002,  17003,
    2684,  17004,  17005,   4643,  17006,   2507,  17007,  17008,
    4324,  17009,   7423,   7422,  17010,  17011,   7420,  17012,
   17013,  17014,  17015,   1735,  17016,   3811,   3963,  17017,
   17018,  17019,  17020,  17021,   7425,  17022,  17023,   1471,
   17024,  17025,   5022,  17026,  17027,  17028,   7424,  17029,
    1768,  17030,  17031,   8042,  17032,  17033,  17034,  17035,
   17036,  17037,  17038,  17039,  17040,  17041,  17042,  17043,
   17044,  17045,  17046,   4269,  17047,  17048,  17049,   7427,
   17050,   7426,  17051,   1909,   2595,   2535,  17052,   2230,
   17053,  17054,  17055,  17056,  17057,  17058,   3323,  17059,
   17060,  17061,  17062,  17063,  17064,  17065,  17066,  17067,
   17068,   7428,  17069,  17070,  17071,  17072,  17073,   4022,
   17074,  17075,  17076,  17077,  17078,  17079,  17080,  17081,
   17082,  17083,  17084,  17085,  17086,  17087,  17088,  17089,
   17090,  17091,  17092,  17093,  17094,  17095,  17096,  17097,
    7431,  17098,  17099,  17100,   4519,  17101,   2756,   3649,
    7541,   7542,   2872,  17102,  17103,  17104,  17105,   1794,
    7543,   4162,  17106,   3623,   4900,  17107,   7544,  17108,
    7545,  17109,  17110,  17111,  17112,   3618,  17113,  17114,
   17115,   4609,   5028,  17116,  17117,   7546,   2680,   1801,
    2754,  17118,  17119,  17120,   1845,   4278,  17121,   2882,
    7548,  17122,  17123,  17124,  17125,   2909,   7547,  17126,
    7550,  17127,  17128,  17129,   7549,   7551,  17130,  17131,
   17132,  17133,  17134,   7552,  17135,  17136,  17137,  17138,
   17139,  17140,  17141,  17142,  17143,  17144,  17145,   3101,
   17146,  17147,  17148,  17149,  17150,  17151,  17152,  17153,
   17154,  17155,  17156,   3009,  17157,  17158,  17159,  17160,
   17161,  17162,  17163,  17164,  17165,  17166,   3943,  17167,
   17168,   4917,  17169,  17170,  17171,  17172,   2751,   2750,
    4921,  17173,  17174,   2821,  17175,   4150,   7540,  17176,
   17177,  17178,  17179,  17180,  17181,   2694,  17182,   2016,
   17183,  17184,  17185,  17186,  17187,  17188,  17189,  17190,
   17191,   5062,   7742,  17192,  17193,   7743,  17194,   2206,
   17195,  17196,  17197,   7745,   7746,  17198,   1451,  17199,
    7744,  17200,   7748,   4028,  17201,  17202,  17203,   7750,
   17204,   4423,  17205,  17206,   1545,   7747,  17207,  17208,
   17209,   7754,  17210,   1928,  17211,  17212,   7762,  17213,
    7757,  17214,  17215,  17216,   7759,   7758,   2158,  17217,
    1534,  17218,   7753,   7749,   1937,  17219,   7755,  17220,
   17221,   7756,  17222,   7760,  17223,  17224,  17225,  17226,
    7752,  17227,   2604,  17228,   3100,  17229,   7761,  17230,
   17231,  17232,  17233,  17234,  17235,   7765,  17236,   7751,
   17237,   1919,  17238,   2709,   7767,  17239,  17240,   2071,
    2899,   5075,   4153,  17241,   1865,  17242,   1660,  17243,
    7763,  17244,   7764,   3783,  17245,   7768,  17246,  17247,
    7769,  17248,   7772,  17249,  17250,  17251,  17252,  17253,
   17254,  17255,  17256,  17257,  17258,  17259,   7770,  17260,
   17261,   7774,   7773,  17262,  17263,   7766,  17264,   2893,
   17265,   1770,  17266,   7771,  17267,  17268,   3580,  17269,
    2619,  17270,  17271,  17272,  17273,   7782,  17274,  17275,
   17276,  17277,  17278,  17279,  17280,   2286,  17281,  17282,
    7775,  17283,  17284,  17285,   1610,   2537,  17286,   4014,
   17287,  17288,  17289,  17290,   7784,   7780,  17291,  17292,
   17293,   2315,   7785,  17294,  17295,  17296,   7776,   7777,
    7781,   3166,   7783,   7786,   7779,   2630,  17297,  17298,
   17299,   4391,  17300,  17301,   7787,  17302,  17303,  17304,
    7778,  17305,  17306,  17307,  17308,  17309,  17310,  17311,
   17312,   7789,  17313,  17314,  17315,  17316,   5088,   3487,
   17317,  17318,  17319,  17320,   7790,  17321,  17322,  17323,
   17324,   7788,  17325,   3109,  17326,  17327,  17328,  17329,
   17330,   2222,   7792,  17331,  17332,   7791,  17333,  17334,
   17335,   1844,  17336,  17337,  17338,   7793,   7794,  17339,
   17340,  17341,   7795,  17342,  17343,  17344,   2939,  17345,
   17346,   2986,  17347,  17348,  17349,  17350,  17351,   3464,
   17352,  17353,  17354,  17355,   7798,  17356,   7797,  17357,
   17358,  17359,  17360,  17361,  17362,  17363,  17364,   1841,
   17365,  17366,  17367,   7801,   7796,  17368,  17369,   7799,
   17370,  17371,  17372,  17373,  17374,  17375,   7800,  17376,
   17377,  17378,  17379,  17380,  17381,  17382,  17383,   7802,
   17384,  17385,  17386,  17387,  17388,  17389,   7804,   2484,
   17390,  17391,   7803,  17392,  17393,  17394,  17395,  17396,
   17397,  17398,  17399,  17400,  17401,  17402,  17403,  17404,
    7805,  17405,  17406,  17407,  17408,  17409,  17410,   1627,
    7807,   7806,  17411,  17412,  17413,  17414,  17415,  17416,
   17417,  17418,  17419,  17420,  17421,   2551,  17422,  17423,
   17424,  17425,  17426,  17427,  17428,  17429,  17430,  17431,
   17432,  17433,  17434,  17435,  17436,  17437,  17438,  17439,
   17440,  17441,  17442,  17443,  17444,  17445,  17446,  17447,
   17448,  17449,  17450,  17451,  17452,  17453,  17454,  17455,
   17456,  17457,  17458,   3250,   5328,  17459,  17460,  17461,
   17462,  17463,  17464,   2977,   7845,   5124,  17465,  17466,
   17467,  17468,  17469,  17470,  17471,  17472,  17473,  17474,
   17475,   2126,  17476,  17477,  17478,  17479,  17480,  17481,
   17482,   7847,   3010,  17483,  17484,   3518,  17485,   1839,
    4906,  17486,  17487,  17488,   7849,   7848,   7850,   4005,
   17489,  17490,   7851,  17491,   4826,   5045,  17492,  17493,
   17494,  17495,   2131,  17496,  17497,  17498,   3031,  17499,
   17500,   3034,   7852,   2737,  17501,  17502,  17503,  17504,
   17505,   1851,  17506,  17507,   7853,   7854,   2736,  17508,
   17509,   7855,  17510,  17511,  17512,   7860,  17513,   7856,
    7859,  17514,   2442,  17515,   7857,   7858,  17516,  17517,
   17518,  17519,  17520,  17521,  17522,   2227,   4080,   7861,
   17523,   1655,  17524,  17525,   3246,  17526,  17527,   4860,
    2842,  17528,  17529,  17530,  17531,  17532,  17533,  17534,
    7862,  17535,  17536,  17537,  17538,  17539,  17540,   3403,
   17541,  17542,  17543,  17544,  17545,  17546,  17547,  17548,
    7874,  17549,  17550,   4344,  17551,  17552,  17553,  17554,
   17555,  17556,  17557,  17558,  17559,  17560,  17561,  17562,
   17563,  17564,   4270,  17565,  17566,  17567,  17568,  17569,
   17570,  17571,  17572,  17573,  17574,  17575,  17576,  17577,
   17578,  17579,  17580,  17581,  17582,  17583,  17584,  17585,
    4003,  17586,   4034,  17587,  17588,  17589,  17590,   2715,
   17591,  17592,  17593,   5122,  17594,  17595,  17596,   2972,
   17597,  17598,  17599,  17600,  17601,  17602,  17603,  17604,
   17605,  17606,  17607,  17608,  17609,  17610,  17611,  17612,
   17613,  17614,  17615,  17616,  17617,  17618,  17619,  17620,
   17621,  17622,  17623,  17624,  17625,  17626,  17627,  17628,
   17629,  17630,  17631,  17632,  17633,  17634,  17635,  17636,
   17637,  17638,  17639,  17640,  17641,  17642,  17643,  17644,
   17645,  17646,  17647,  17648,  17649,  17650,  17651,  17652,
   17653,  17654,  17655,  17656,  17657,  17658,   4502,  17659,
   17660,  17661,  17662,  17663,  17664,  17665,  17666,   7875,
   17667,  17668,  17669,  17670,  17671,  17672,  17673,  17674,
   17675,  17676,  17677,  17678,  17679,  17680,  17681,  17682,
   17683,  17684,  17685,  17686,  17687,  17688,  17689,  17690,
   17691,  17692,  17693,  17694,  17695,  17696,  17697,  17698,
   17699,  17700,  17701,  17702,  17703,  17704,  17705,  17706,
   17707,  17708,  17709,  17710,  17711,  17712,   7876,  17713,
   17714,  17715,  17716,  17717,  17718,  17719,   7877,  17720,
   17721,  17722,  17723,  17724,  17725,  17726,  17727,  17728,
   17729,  17730,  17731,  17732,  17733,  17734,  17735,  17736,
   17737,  17738,  17739,  17740,  17741,  17742,  17743,  17744,
   17745,  17746,  17747,  17748,  17749,  17750,  17751,  17752,
   17753,  17754,  17755,  17756,  17757,  17758,  17759,  17760,
   17761,  17762,  17763,  17764,  17765,  17766,  17767,  17768,
   17769,  17770,  17771,  17772,  17773,  17774,  17775,  17776,
   17777,  17778,  17779,  17780,  17781,  17782,  17783,  17784,
   17785,  17786,  17787,  17788,  17789,  17790,  17791,  17792,
   17793,  17794,  17795,  17796,  17797,  17798,  17799,  17800,
   17801,  17802,  17803,  17804,  17805,  17806,  17807,  17808,
   17809,  17810,  17811,  17812,  17813,  17814,  17815,  17816,
   17817,  17818,  17819,  17820,  17821,  17822,  17823,  17824,
   17825,  17826,  17827,  17828,  17829,  17830,  17831,  17832,
   17833,  17834,  17835,  17836,  17837,  17838,  17839,  17840,
   17841,  17842,  17843,  17844,  17845,  17846,  17847,  17848,
   17849,  17850,  17851,  17852,  17853,  17854,  17855,  17856,
   17857,  17858,  17859,   8150,  17860,  17861,  17862,  17863,
   17864,   2084,  17865,  17866,  17867,  17868,  17869,   7878,
   17870,  17871,  17872,  17873,  17874,  17875,  17876,  17877,
   17878,  17879,  17880,  17881,  17882,  17883,  17884,  17885,
   17886,  17887,  17888,  17889,  17890,  17891,  17892,  17893,
   17894,  17895,  17896,  17897,  17898,  17899,  17900,  17901,
   17902,  17903,  17904,  17905,  17906,  17907,  17908,  17909,
   17910,  17911,  17912,  17913,  17914,  17915,  17916,  17917,
   17918,  17919,  17920,  17921,  17922,  17923,  17924,  17925,
   17926,  17927,   5150,  17928,  17929,  17930,  17931,  17932,
   17933,  17934,  17935,  17936,  17937,  17938,  17939,  17940,
   17941,  17942,  17943,  17944,  17945,  17946,  17947,  17948,
   17949,  17950,  17951,   7879,  17952,  17953,  17954,   6574,
    2757,   6575,   2425,   6576,   4366,   6577,   4821,   2559,
    6578,   6579,   2582,   3715,   4248,   6580,  17955,   1816,
    6581,   3779,   2218,   3330,  17956,   5136,   3159,   2122,
    5010,   4267,   2103,  17957,  17958,   3389,   6582,   4386,
    6583,   6584,   6585,   3030,   5148,   3839,   4347,   4996,
    5034,   6586,   1486,   6587,   6588,   3819,   4684,   2738,
    6589,   1492,   3727,   2696,   6590,   3703,  17959,   6591,
    2513,   2249,   4515,   6592,   3172,   2813,   2673,   4154,
    6593,   6594,   2803,   4486,  17960,   4018,   4089,   2581,
    6595,   2545,   4504,   6596,  17961,   4505,   6597,   6598,
    1819,   6599,   6600,   3853,   4241,   3259,   6602,   1536,
    1772,  17962,   6603,   6604,   5134,   4919,   6605,   3145,
    5101,   6606,   6607,   6608,   2611,   3264,   2947,   6609,
    6610,   2546,  17963,   6611,   6612,   6601,   2021,   6613,
   17964,   6614,   6615,   2469,   1941,   3139,   1567,   6616,
    4814,   6617,   2192,   6619,   6618,   2143,  17965,   6620,
    1685,   6621,   6622,   6623,   6624,   6625,   6626,   6627,
    4706,   4032,   6628,   6629,   6630,   6631,   3800,   6632,
    6633,   6634,   6635,   6636,   2672,   6637,   7737,  17966,
    2216,  17967,   3682,  17968,  17969,  17970,  17971,  17972,
   17973,  17974,   7738,  17975,   7739,   7740,  17976,  17977,
   17978,  17979,  17980,  17981,  17982,  17983,  17984,  17985,
    2317,   4223,  17986,  17987,   5241,   2366,  17988,   3163,
    7260,  17989,   2070,  17990,  17991,  17992,  17993,   7262,
   17994,   7261,   1462,  17995,  17996,  17997,  17998,  17999,
    7264,   4941,   5154,  18000,  18001,  18002,   5016,  18003,
   18004,   7266,   3933,  18005,   7265,  18006,  18007,  18008,
   18009,   7267,  18010,  18011,  18012,  18013,   7269,  18014,
   18015,   7268,  18016,  18017,  18018,  18019,  18020,  18021,
   18022,  18023,   4593,  18024,   3599,  18025,   3227,  18026,
   18027,  18028,  18029,  18030,   2226,  18031,  18032,  18033,
   18034,  18035,   3078,  18036,  18037,   7839,   4480,   7840,
   18038,   4382,  18039,  18040,   3691,  18041,  18042,   7841,
   18043,  18044,  18045,  18046,  18047,  18048,  18049,   7842,
    7843,  18050,   7844,  18051,  18052,  18053,  18054,  18055,
    5353,   2255,  18056,  18057,   6472,   4779,  18058,   7865,
   18059,   4273,  18060,  18061,  18062,   1756,  18063,  18064,
   18065,  18066,   7539,  18067,   4683,  18068,   7866,  18069,
   18070,  18071,  18072,  18073,   4395,   7867,  18074,  18075,
    3615,  18076,  18077,  18078,  18079,  18080,  18081,   1931,
    1853,   7869,  18082,  18083,  18084,   7868,   7870,  18085,
   18086,   7871,  18087,  18088,  18089,  18090,   7872,  18091,
    2367,   1440,  18092,   7873,  18093,  18094,  18095,  18096,
   18097,  18098,  18099,   2080,   4682,  18100,  18101,  18102,
    4616,   2960,  18103,   2847,   6958,   4950,   6901,  18104,
   18105,  18106,  18107,   7602,   2061,   3950,  18108,  18109,
    3334,  18110,   7590,  18111,   7591,   2252,   7592,   2385,
    4830,   1459,  18112,  18113,   7593,  18114,  18115,  18116,
    7594,  18117,   7595,  18118,  18119,   7596,   7597,   7598,
    7600,   7599,   3436,  18120,  18121,  18122,  18123,  18124,
   18125,   7601,  18126,   2063,  18127,   7603,   4619,   5772,
    3989,  18128,  18129,   1751,  18130,   1881,  18131,   2257,
   18132,  18133,   3373,   7604,  18134,  18135,   7605,  18136,
   18137,  18138,   3043,   3098,   4997,   7606,  18139,  18140,
   18141,  18142,   7607,  18143,   3017,  18144,  18145,  18146,
    3501,  18147,   2784,  18148,  18149,  18150,  18151,  18152,
   18153,  18154,  18155,  18156,  18157,  18158,  18159,  18160,
   18161,   7608,   1832,  18162,  18163,  18164,  18165,  18166,
   18167,   7609,  18168,  18169,  18170,  18171,  18172,  18173,
   18174,  18175,  18176,  18177,  18178,  18179,  18180,   7161,
    7160,  18181,  18182,   4011,   4667,  18183,   3980,   4943,
   18184,   3731,  18185,   2976,   2538,  18186,  18187,  18188,
   18189,  18190,  18191,   6988,  18192,  18193,   4421,  18194,
    5047,  18195,   2012,   2217,   6987,   2207,  18196,   6986,
    1697,   2296,   4992,  18197,   2151,   2109,  18198,  18199,
   18200,   2608,   2097,   6993,  18201,   6994,   1434,   2866,
   18202,   6992,   4792,  18203,   6995,  18204,  18205,   6996,
   18206,  18207,   2113,  18208,   6989,   6991,   3845,   5036,
    4932,   4435,   7002,   4253,   7003,  18209,   1887,  18210,
   18211,  18212,  18213,  18214,   1522,   7005,   4046,  18215,
   18216,  18217,  18218,  18219,  18220,  18221,   3437,   7006,
   18222,   7004,   3446,   7001,   3857,   7008,   1500,  18223,
   18224,   2439,  18225,  18226,   5192,   7586,  18227,   6997,
    6998,   6999,   7000,   7009,   6517,   7012,  18228,   2891,
    4645,   7010,   7015,   2237,   7011,  18229,   2657,  18230,
    4473,  18231,   1432,  18232,   7016,   3349,  18233,  18234,
   18235,  18236,   4993,  18237,  18238,  18239,   1849,  18240,
   18241,   3187,   2562,  18242,  18243,   7013,   7014,   4857,
    3551,   3341,   7018,   3390,   5348,  18244,   1614,  18245,
    7023,  18246,   2668,  18247,  18248,  18249,   7021,  18250,
   18251,  18252,  18253,  18254,  18255,  18256,  18257,  18258,
   18259,  18260,  18261,  18262,   7022,  18263,  18264,   2173,
   18265,   4184,   7024,  18266,  18267,  18268,   7020,  18269,
    3026,  18270,  18271,  18272,  18273,  18274,   3479,  18275,
   18276,  18277,  18278,  18279,  18280,  18281,   4124,  18282,
    7025,  18283,   2929,   4629,   7026,  18284,  18285,  18286,
    2176,   2174,  18287,   7027,   3598,   4218,  18288,  18289,
   18290,   7029,   7030,  18291,  18292,  18293,  18294,  18295,
    7032,  18296,  18297,  18298,  18299,   4457,  18300,   7037,
   18301,   7033,  18302,  18303,  18304,   7036,   3754,  18305,
    4603,   7031,  18306,  18307,   7028,  18308,  18309,  18310,
   18311,   2186,   4380,   3358,   7034,   7035,   4099,   4175,
    1491,  18312,   7041,  18313,  18314,  18315,  18316,  18317,
    7040,  18318,   1615,  18319,  18320,  18321,  18322,   2225,
   18323,   7042,  18324,  18325,  18326,  18327,  18328,  18329,
    1579,  18330,  18331,   4078,   3293,   4328,  18332,  18333,
   18334,  18335,  18336,   7044,  18337,  18338,   7051,  18339,
    3465,  18340,   7045,  18341,  18342,  18343,  18344,  18345,
   18346,  18347,  18348,   3796,  18349,  18350,  18351,  18352,
   18353,  18354,   6172,   7049,  18355,  18356,  18357,  18358,
    4181,   7050,   1562,   4722,  18359,  18360,   4665,  18361,
   18362,  18363,   7048,  18364,   7046,  18365,  18366,  18367,
   18368,  18369,  18370,  18371,  18372,  18373,  18374,  18375,
   18376,  18377,  18378,  18379,  18380,  18381,  18382,  18383,
   18384,  18385,  18386,   1719,  18387,  18388,  18389,   6877,
   18390,  18391,   5127,  18392,   7812,   1775,  18393,  18394,
   18395,  18396,  18397,   5014,   5015,  18398,  18399,  18400,
   18401,  18402,  18403,   4960,   2767,  18404,   7808,  18405,
    4613,   7809,   7810,  18406,   7811,   2768,   4762,  18407,
   18408,  18409,  18410,  18411,   3823,   3824,  18412,  18413,
    7741,  18414,   3923,  18415,   4123,  18416,  18417,  18418,
   18419,  18420,  18421,   6131,   3967,  18422,   4301,   5040,
   18423,   7814,   7815,   7816,  18424,  18425,  18426,  18427,
    7819,  18428,   2378,   7820,   1476,   7817,  18429,   7818,
    2633,   1650,  18430,   7823,   7824,   2043,   1613,   4370,
    7821,   1797,  18431,   7822,  18432,  18433,   7825,  18434,
   18435,  18436,  18437,  18438,   7826,  18439,  18440,   4142,
   18441,   7827,  18442,   7828,  18443,  18444,  18445,   7829,
   18446,  18447,  18448,  18449,  18450,  18451,  18452,  18453,
    3997,  18454,   7830,  18455,  18456,  18457,  18458,   7831,
   18459,  18460,  18461,  18462,  18463,  18464,  18465,  18466,
    7832,  18467,  18468,  18469,  18470,  18471,   7863,   3035,
    2609,  18472,   3770,   4573,   6476,  18473,  18474,  18475,
   18476,   5564,   4658,  18477,  18478,   5565,   1421,   5566,
   18479,  18480,   2689,  18481,   5570,  18482,  18483,  18484,
    5203,  18485,   5568,   4782,  18486,   3813,   5571,   5567,
   18487,   5572,   3197,  18488,  18489,  18490,  18491,   5573,
    5582,   5574,  18492,  18493,   4292,   4986,  18494,   5592,
   18495,   5590,  18496,  18497,   5595,   2701,   3112,  18498,
    5569,   5588,   5591,   5575,   2117,   1446,   5584,   4447,
    5578,   2451,  18499,   2095,   5589,  18500,  18501,   5583,
    5576,   3630,  18502,  18503,  18504,   4542,   5577,  18505,
   18506,   5587,  18507,  18508,   5593,  18509,  18510,   4242,
    5579,  18511,   5580,   5585,   5586,   1649,   5594,   4000,
   18512,   4816,   5604,   5608,   4047,   5615,  18513,   3266,
    5605,  18514,  18515,   2852,   5602,  18516,   1499,   2277,
    5614,   5596,  18517,   5581,   5599,   3749,   2883,  18518,
   18519,  18520,  18521,   3786,  18522,  18523,  18524,   1532,
   18525,   4701,  18526,  18527,   5603,  18528,  18529,   5598,
   18530,   3504,  18531,   5607,  18532,  18533,  18534,  18535,
   18536,   5109,   3210,   2089,   3620,   3204,   5611,   5601,
    5620,   5597,  18537,  18538,   5606,  18539,   2730,   5600,
   18540,   5609,  18541,  18542,   5612,   5613,  18543,   5633,
   18544,  18545,   5610,   5641,   5616,  18546,  18547,  18548,
   18549,  18550,  18551,  18552,  18553,  18554,  18555,   2612,
    1821,  18556,  18557,   3198,   1668,   5635,  18558,   5627,
   18559,   5624,  18560,   5637,   5623,   4685,   1669,  18561,
    3720,   3732,   5636,  18562,   5622,  18563,  18564,  18565,
    5632,  18566,  18567,   5630,  18568,  18569,   2728,   5629,
   18570,   1658,  18571,  18572,  18573,  18574,  18575,   5628,
    2623,   5617,   2479,  18576,   2996,  18577,  18578,  18579,
   18580,  18581,   2589,   5618,   5619,  18582,   5626,   5631,
    5634,   1899,  18583,   3722,   2514,   5639,   5638,   4710,
    5640,   5642,   5644,   4686,   5643,   5645,   5646,   4614,
   18584,  18585,  18586,  18587,  18588,  18589,  18590,   2390,
    5648,  18591,  18592,   5661,   5656,   5659,  18593,  18594,
   18595,  18596,  18597,  18598,  18599,   5655,   3523,  18600,
   18601,   2995,  18602,  18603,  18604,  18605,   3774,  18606,
   18607,  18608,   5621,   5653,  18609,  18610,  18611,  18612,
    5662,  18613,  18614,   5625,   5654,  18615,   5663,  18616,
    5651,  18617,  18618,  18619,  18620,  18621,  18622,  18623,
    5664,   5658,   5652,   3299,  18624,  18625,  18626,  18627,
    5647,   2932,   3018,   5649,   5650,  18628,   5657,   2524,
    5660,   4707,   5665,  18629,   5666,   3202,  18630,  18631,
    5689,   5667,  18632,  18633,  18634,   5688,  18635,   2284,
   18636,  18637,   2778,  18638,   2815,  18639,  18640,   2391,
   18641,  18642,  18643,  18644,   5681,  18645,   5676,  18646,
    5670,  18647,  18648,  18649,   1640,   5674,  18650,   5682,
    1601,   5692,  18651,  18652,  18653,   5669,  18654,  18655,
   18656,   3525,   5687,  18657,  18658,  18659,  18660,  18661,
    5691,   3073,   2105,  18662,  18663,  18664,  18665,  18666,
    5685,   5686,  18667,  18668,  18669,   5675,  18670,  18671,
   18672,   5668,  18673,   5684,   4090,  18674,   5680,  18675,
   18676,  18677,  18678,   5673,   3235,   3505,   4243,   5683,
   18679,   5679,  18680,  18681,  18682,  18683,  18684,  18685,
    5672,  18686,  18687,  18688,   5677,   3161,  18689,  18690,
   18691,  18692,  18693,  18694,   4708,   4709,   5690,   4407,
    3753,  18695,  18696,  18697,  18698,  18699,  18700,  18701,
   18702,   5709,  18703,  18704,  18705,  18706,  18707,  18708,
    5678,  18709,  18710,  18711,   5703,   3169,  18712,  18713,
   18714,  18715,  18716,  18717,  18718,  18719,   5704,  18720,
   18721,  18722,  18723,  18724,  18725,  18726,  18727,  18728,
   18729,   5694,  18730,  18731,  18732,  18733,  18734,   5069,
   18735,   5696,   5695,   2241,   5693,  18736,  18737,  18738,
   18739,   3524,  18740,   1986,  18741,  18742,  18743,  18744,
   18745,   5705,  18746,   2438,   4858,   5710,  18747,  18748,
   18749,   1833,  18750,   5697,  18751,   2910,   5706,  18752,
    5702,  18753,   5700,  18754,  18755,  18756,  18757,  18758,
   18759,  18760,   1936,  18761,  18762,  18763,  18764,   5698,
    5699,   5701,  18765,   2646,   5707,  18766,   5708,  18767,
   18768,  18769,  18770,  18771,  18772,  18773,  18774,   5724,
   18775,   3236,  18776,  18777,   4013,  18778,  18779,  18780,
   18781,   5721,  18782,  18783,  18784,  18785,  18786,  18787,
   18788,  18789,  18790,  18791,  18792,  18793,  18794,   5234,
   18795,  18796,   3526,  18797,   5723,  18798,  18799,  18800,
    4971,   5722,   5719,  18801,  18802,   5715,  18803,   5718,
   18804,   5711,  18805,  18806,   4495,  18807,  18808,  18809,
   18810,   3721,   5717,  18811,  18812,   5712,  18813,  18814,
    5713,   4029,  18815,   5716,  18816,  18817,   1548,  18818,
   18819,  18820,  18821,  18822,  18823,   2935,  18824,   2564,
    5720,  18825,  18826,   5726,  18827,   5725,   5714,  18828,
   18829,  18830,  18831,  18832,   3461,  18833,  18834,  18835,
    5730,  18836,  18837,  18838,  18839,  18840,  18841,  18842,
   18843,  18844,  18845,  18846,   5737,  18847,  18848,   5736,
   18849,  18850,  18851,  18852,  18853,  18854,  18855,  18856,
   18857,  18858,  18859,  18860,   5727,  18861,  18862,  18863,
   18864,   3274,  18865,   3192,  18866,  18867,  18868,   4952,
   18869,  18870,   4250,  18871,  18872,  18873,  18874,   5732,
   18875,   1641,  18876,  18877,  18878,  18879,  18880,  18881,
   18882,  18883,  18884,   3361,   3916,  18885,  18886,  18887,
   18888,  18889,  18890,  18891,  18892,  18893,  18894,   3601,
    5729,   5731,   5733,   5735,   1419,   1549,  18895,  18896,
   18897,  18898,  18899,   5745,  18900,  18901,  18902,  18903,
    5739,   2653,   3744,  18904,  18905,  18906,  18907,  18908,
   18909,  18910,  18911,  18912,  18913,  18914,   5734,  18915,
   18916,   5738,  18917,  18918,  18919,  18920,   5742,  18921,
   18922,  18923,  18924,  18925,   5741,  18926,  18927,  18928,
    5740,  18929,  18930,  18931,  18932,  18933,  18934,  18935,
   18936,  18937,   5746,  18938,   4837,  18939,  18940,  18941,
   18942,   5752,   5743,   5747,  18943,  18944,   2970,  18945,
   18946,  18947,  18948,  18949,   1504,   5755,  18950,   5750,
   18951,  18952,  18953,  18954,  18955,  18956,  18957,   5751,
   18958,  18959,  18960,  18961,  18962,  18963,  18964,  18965,
   18966,  18967,  18968,   4517,   5754,  18969,  18970,  18971,
   18972,  18973,  18974,  18975,   5748,  18976,  18977,  18978,
    5749,  18979,   4446,  18980,  18981,  18982,   5753,   3930,
    5758,  18983,  18984,  18985,  18986,  18987,  18988,   5757,
   18989,   5756,  18990,  18991,  18992,  18993,  18994,  18995,
   18996,   5760,  18997,  18998,  18999,  19000,  19001,  19002,
   19003,   2700,  19004,  19005,  19006,  19007,  19008,   1653,
    3269,  19009,  19010,   5759,  19011,   3409,  19012,  19013,
   19014,  19015,  19016,  19017,   5761,  19018,  19019,  19020,
   19021,  19022,  19023,  19024,   4098,  19025,  19026,  19027,
   19028,   2077,  19029,  19030,  19031,  19032,  19033,  19034,
   19035,  19036,  19037,  19038,  19039,  19040,  19041,  19042,
   19043,  19044,  19045,   4862,  19046,  19047,  19048,   5762,
   19049,  19050,  19051,  19052,  19053,   5764,  19054,  19055,
   19056,  19057,  19058,  19059,  19060,  19061,  19062,  19063,
   19064,   3291,  19065,  19066,  19067,  19068,   5766,  19069,
   19070,  19071,  19072,  19073,  19074,  19075,  19076,  19077,
   19078,  19079,  19080,  19081,  19082,  19083,  19084,   5763,
   19085,   5765,  19086,  19087,  19088,  19089,  19090,  19091,
   19092,  19093,  19094,  19095,  19096,  19097,  19098,  19099,
    4913,  19100,  19101,  19102,   5767,  19103,  19104,  19105,
   19106,  19107,  19108,  19109,  19110,  19111,  19112,  19113,
   19114,  19115,  19116,  19117,  19118,   7627,   2445,   3119,
    3399,   3140,  19119,  19120,   7628,  19121,  19122,  19123,
   19124,  19125,   4490,  19126,  19127,  19128,   4760,  19129,
   19130,  19131,   6984,  19132,  19133,  19134,  19135,  19136,
   19137,  19138,  19139,   1761,   7629,  19140,   7630,  19141,
   19142,   3866,  19143,  19144,  19145,  19146,  19147,  19148,
   19149,   2420,   7632,   7634,   7633,   4015,   4349,   7631,
    3873,   4652,   3177,  19150,  19151,  19152,  19153,  19154,
   19155,  19156,   4264,   7637,   1495,   7636,  19157,  19158,
   19159,  19160,  19161,   7643,  19162,   1644,  19163,  19164,
   19165,  19166,  19167,  19168,   4544,   7639,  19169,  19170,
   19171,  19172,  19173,   7641,   4866,  19174,  19175,   7640,
    7635,   7644,   7642,  19176,   7638,  19177,  19178,   7652,
    7649,   7651,  19179,  19180,   7655,   7647,   7645,  19181,
   19182,  19183,   7650,  19184,  19185,  19186,  19187,  19188,
    5072,  19189,  19190,  19191,   7646,  19192,   3660,   3822,
   19193,   7653,   2293,   1895,  19194,  19195,   7648,   7654,
    7661,   7667,  19196,  19197,   2498,  19198,  19199,  19200,
    7666,   4195,  19201,   5056,  19202,  19203,   7663,   7665,
   19204,  19205,  19206,  19207,   2243,  19208,  19209,  19210,
   19211,   7656,  19212,  19213,  19214,   7659,   3190,  19215,
    4948,   7657,   7658,   7660,   7664,  19216,  19217,  19218,
    7670,   4727,  19219,  19220,  19221,  19222,   2047,  19223,
    3934,  19224,   2135,   7668,  19225,  19226,  19227,   7669,
    7671,   7674,   7672,  19228,  19229,   7673,  19230,  19231,
   19232,  19233,   4560,   7662,  19234,   4176,  19235,   4276,
    4990,  19236,   7680,  19237,   3254,  19238,   7677,  19239,
   19240,   2928,   7689,   7675,  19241,   7678,  19242,  19243,
   19244,   7685,  19245,  19246,  19247,  19248,   7679,  19249,
   19250,   7684,  19251,  19252,   7683,  19253,  19254,   7686,
   19255,  19256,  19257,   7676,  19258,  19259,   7681,   7687,
   19260,  19261,  19262,  19263,  19264,  19265,  19266,   4711,
    7682,   1682,  19267,  19268,   7695,  19269,   4428,  19270,
   19271,  19272,  19273,   7698,  19274,  19275,  19276,   2483,
   19277,   7702,  19278,  19279,  19280,  19281,  19282,  19283,
    7693,  19284,  19285,   7699,   7701,   7703,  19286,  19287,
   19288,  19289,  19290,  19291,  19292,  19293,   7696,  19294,
    7694,  19295,  19296,  19297,   2440,  19298,   1970,  19299,
   19300,  19301,  19302,   7692,   7700,   7690,   7691,  19303,
   19304,  19305,   7688,   7713,  19306,   7710,  19307,  19308,
    7709,  19309,  19310,   7697,  19311,   3723,  19312,  19313,
   19314,  19315,  19316,   7704,  19317,  19318,  19319,   7712,
   19320,  19321,  19322,  19323,  19324,  19325,  19326,   3283,
   19327,  19328,  19329,  19330,  19331,  19332,  19333,  19334,
    7706,  19335,  19336,   7714,   7716,   7711,  19337,   7705,
   19338,  19339,  19340,   7718,  19341,   7717,  19342,  19343,
   19344,  19345,   3162,  19346,  19347,   7721,  19348,  19349,
    7723,  19350,  19351,  19352,  19353,  19354,   7708,  19355,
   19356,  19357,   7724,   7719,  19358,  19359,  19360,  19361,
   19362,   7722,   7707,   7720,  19363,  19364,  19365,  19366,
   19367,  19368,  19369,   7725,  19370,  19371,  19372,  19373,
    7727,  19374,  19375,  19376,  19377,   7715,  19378,  19379,
   19380,  19381,   7726,  19382,  19383,  19384,   7728,  19385,
   19386,  19387,  19388,  19389,  19390,  19391,  19392,  19393,
   19394,   4440,  19395,  19396,  19397,  19398,   7731,  19399,
   19400,  19401,  19402,   5352,  19403,  19404,  19405,  19406,
   19407,  19408,   7732,  19409,  19410,  19411,  19412,  19413,
   19414,  19415,  19416,   7730,  19417,   3733,   7729,  19418,
   19419,  19420,  19421,   7733,  19422,  19423,  19424,  19425,
   19426,   7734,   1817,  19427,  19428,  19429,  19430,  19431,
   19432,  19433,  19434,  19435,  19436,  19437,  19438,  19439,
   19440,  19441,   7272,  19442,  19443,  19444,  19445,  19446,
   19447,   7735,  19448,  19449,   7736,  19450,  19451,  19452,
    4521,  19453,  19454,  19455,   7813,   4455,  19456,  19457,
   19458,  19459,  19460,  19461,   4465,   4571,  19462,  19463,
   19464,  19465,  19466,  19467,   4369,  19468,  19469,   2685,
   19470,   4546,  19471,  19472,  19473,  19474,  19475,  19476,
   19477,   2415,   6088,   4639,   7553,   1622,  19478,  19479,
    1580,   7554,  19480,   3791,   1727,  19481,   5345,  19482,
    3952,  19483,   7555,  19484,  19485,  19486,  19487,   5033,
   19488,  19489,  19490,  19491,  19492,   7556,   7833,   7557,
   19493,   4805,   7558,  19494,   1441,   7834,  19495,  19496,
    7835,  19497,  19498,   1877,  19499,   3442,  19500,  19501,
   19502,  19503,   4068,  19504,  19505,  19506,   4485,  19507,
   19508,  19509,  19510,  19511,   4199,  19512,  19513,  19514,
   19515,  19516,   7559,  19517,   5346,  19518,  19519,  19520,
   19521,  19522,  19523,   1530,  19524,   4337,  19525,  19526,
   19527,   2165,  19528,  19529,  19530,  19531,  19532,   7561,
   19533,  19534,  19535,  19536,   7562,  19537,  19538,  19539,
   19540,   1632,   3056,  19541,  19542,   5091,   7560,  19543,
   19544,   7563,  19545,  19546,  19547,  19548,   7565,  19549,
   19550,  19551,   5349,  19552,   4670,   4796,  19553,  19554,
    7836,   3690,  19555,  19556,  19557,  19558,  19559,   7837,
   19560,  19561,   7564,   7566,   2886,   7567,  19562,  19563,
    7571,  19564,  19565,  19566,  19567,  19568,  19569,  19570,
    7573,   7568,  19571,   3808,   3448,  19572,  19573,  19574,
    3168,   2347,  19575,  19576,   7570,  19577,   7572,  19578,
   19579,  19580,   2306,  19581,  19582,  19583,  19584,  19585,
   19586,  19587,   7578,  19588,  19589,  19590,  19591,  19592,
    2403,  19593,   1502,   7576,  19594,  19595,  19596,  19597,
   19598,   7575,   7569,   7577,  19599,  19600,  19601,  19602,
   19603,   7574,  19604,  19605,  19606,   3741,  19607,  19608,
   19609,  19610,   4177,   7580,  19611,  19612,  19613,  19614,
    6420,  19615,  19616,  19617,   7579,  19618,   7581,  19619,
   19620,  19621,  19622,  19623,  19624,  19625,  19626,  19627,
   19628,   7582,  19629,  19630,   4392,  19631,  19632,  19633,
   19634,  19635,  19636,  19637,  19638,  19639,  19640,  19641,
   19642,  19643,  19644,  19645,  19646,  19647,  19648,  19649,
   19650,  19651,  19652,  19653,  19654,  19655,   7838,   2714,
   19656,  19657,  19658,  19659,  19660,  19661,   7583,  19662,
   19663,  19664,  19665,  19666,  19667,  19668,  19669,  19670,
   19671,  19672,  19673,  19674,  19675,  19676,  19677,  19678,
   19679,  19680,  19681,   7584,  19682,  19683,  19684,   4316,
   19685,   4615,  19686,   7610,  19687,  19688,   2179,  19689,
   19690,  19691,  19692,  19693,  19694,  19695,  19696,  19697,
   19698,  19699,  19700,  19701,  19702,  19703,  19704,  19705,
   19706,  19707,  19708,  19709,  19710,  19711,  19712,  19713,
   19714,  19715,  19716,  19717,  19718,  19719,  19720,  19721,
   19722,  19723,  19724,  19725,  19726,  19727,  19728,  19729,
   19730,  19731,  19732,  19733,  19734,  19735,  19736,  19737,
   19738,  19739,  19740,  19741,  19742,  19743,  19744,  19745,
   19746,   2628,   2314,  19747,   2325,   3252,   3904,   6933,
    2945,   2810,   6934,   6935,   6936,  19748,   6937,   6938,
    6939,   6940,   2670,  19749,  19750,  19751,   7986,  19752,
   19753,  19754,   7988,  19755,   7989,  19756,   7987,  19757,
   19758,  19759,  19760,   2697,  19761,   7990,   1790,  19762,
   19763,  19764,  19765,   7991,  19766,  19767,  19768,   7992,
   19769,  19770,  19771,   7067,  19772,  19773,  19774,  19775,
   19776,  19777,  19778,  19779,  19780,  19781,  19782,  19783,
    4563,  19784,  19785,  19786,  19787,  19788,  19789,   5337,
   19790,  19791,  19792,  19793,  19794,  19795,  19796,  19797,
   19798,  19799,  19800,  19801,  19802,  19803,  19804,  19805,
   19806,  19807,  19808,  19809,  19810,  19811,  19812,  19813,
   19814,  19815,  19816,  19817,  19818,  19819,  19820,  19821,
   19822,  19823,  19824,  19825,  19826,  19827,  19828,  19829,
   19830,  19831,  19832,  19833,  19834,  19835,  19836,  19837,
   19838,  19839,  19840,  19841,  19842,  19843,   7993,  19844,
   19845,  19846,  19847,  19848,  19849,  19850,  19851,  19852,
    7263,  19853,  19854,  19855,  19856,  19857,  19858,  19859,
   19860,  19861,  19862,  19863,  19864,  19865,  19866,  19867,
   19868,  19869,  19870,  19871,  19872,  19873,  19874,  19875,
   19876,  19877,  19878,  19879,  19880,  19881,  19882,  19883,
   19884,  19885,  19886,  19887,  19888,  19889,  19890,  19891,
   19892,  19893,  19894,  19895,  19896,  19897,  19898,  19899,
   19900,   4905,  19901,  19902,  19903,  19904,  19905,  19906,
   19907,  19908,  19909,  19910,  19911,  19912,  19913,  19914,
   19915,   4793,   4101,  19916,  19917,  19918,  19919,  19920,
   19921,  19922,  19923,   3889,  19924,  19925,  19926,  19927,
   19928,  19929,  19930,  19931,  19932,  19933,  19934,  19935,
   19936,  19937,  19938,  19939,  19940,  19941,  19942,  19943,
   19944,  19945,  19946,  19947,  19948,  19949,  19950,  19951,
   19952,  19953,  19954,  19955,  19956,  19957,  19958,  19959,
   19960,  19961,  19962,  19963,  19964,  19965,  19966,  19967,
   19968,  19969,  19970,  19971,  19972,  19973,  19974,  19975,
   19976,  19977,  19978,  19979,  19980,  19981,  19982,  19983,
   19984,  19985,  19986,  19987,  19988,  19989,  19990,  19991,
   19992,  19993,  19994,  19995,  19996,  19997,  19998,  19999,
   20000,  20001,  20002,  20003,  20004,  20005,  20006,  20007,
   20008,  20009,  20010,  20011,  20012,  20013,  20014,  20015,
   20016,  20017,  20018,  20019,  20020,  20021,  20022,  20023,
   20024,  20025,  20026,  20027,  20028,  20029,  20030,  20031,
   20032,  20033,  20034,  20035,  20036,  20037,  20038,   6423,
   20039,  20040,  20041,  20042,  20043,  20044,  20045,  20046,
   20047,  20048,  20049,  20050,  20051,  20052,  20053,  20054,
   20055,  20056,  20057,  20058,  20059,  20060,  20061,  20062,
   20063,  20064,  20065,  20066,  20067,  20068,   7994,  20069,
   20070,  20071,  20072,  20073,  20074,  20075,  20076,  20077,
   20078,  20079,  20080,  20081,  20082,  20083,  20084,  20085,
   20086,  20087,  20088,  20089,  20090,  20091,  20092,  20093,
   20094,  20095,  20096,  20097,  20098,  20099,  20100,  20101,
   20102,  20103,  20104,  20105,  20106,  20107,  20108,  20109,
   20110,  20111,  20112,  20113,  20114,  20115,  20116,  20117,
   20118,  20119,  20120,  20121,  20122,  20123,  20124,  20125,
   20126,  20127,  20128,  20129,  20130,  20131,   2740,  20132,
   20133,  20134,  20135,  20136,   3486,  20137,  20138,  20139,
   20140,  20141,  20142,  20143,  20144,  20145,  20146,  20147,
   20148,  20149,  20150,  20151,  20152,  20153,  20154,  20155,
   20156,  20157,  20158,  20159,  20160,  20161,  20162,  20163,
   20164,  20165,  20166,  20167,  20168,  20169,  20170,  20171,
   20172,  20173,  20174,  20175,  20176,  20177,  20178,  20179,
   20180,  20181,  20182,  20183,  20184,  20185,  20186,  20187,
    5362,   2575,   1982,   2189,   3712,   2542,   5363,   5364,
    4095,   3700,   5365,   3570,  20188,   4532,   4678,   4533,
    2576,  20189,   2649,   2511,   5366,   5367,   4551,   5368,
    4494,   2052,   3160,  20190,   3994,   2144,   3831,   2102,
    2812,   4985,   5369,   5370,   3509,   5146,   3875,  20191,
    4896,   4010,   4966,   5371,   5044,   1827,   5373,   5372,
   20192,   4680,   5374,   5375,   5376,   3905,   5377,   3864,
    5378,   5379,   1738,   5060,   5380,   2459,   1893,   5381,
    5382,   2333,   4526,   4677,   5383,   2196,   4397,   1676,
    5384,   5385,  20193,   2706,   4289,   4778,   5386,   4312,
    5387,   4752,   2512,   5388,   3968,   3995,   5389,   3646,
    5059,   5390,   3404,   2006,   5391,   2111,   2865,   5392,
    5393,   3960,   5394,   1966,   5395,   3041,   5102,   5396,
    4065,  20194,   4679,   3306,   5397,   1972,   2492,   5398,
    4436,   5399,   5400,   4258,   5401,   5402,   5403,   1684,
    5406,   5404,   4583,   5405,   3248,   5407,  20195,   5408,
    5409,   5410,   4444,   4610,   1498,   5411,   3582,   5412,
    2718,   3196,   5413,   5414,   3288,   4064,   5415,   5416,
    2943,   3532,   5417,   5418,   3591,   5419,   5420,   2295,
   20196,  20197,  20198,  20199,  20200,  20201,  20202,  20203,
   20204,   2520,  20205,  20206,  20207,  20208,   1998,   7889,
   20209,   7890,  20210,  20211,   4202,  20212,  20213,  20214,
   20215,  20216,  20217,  20218,  20219,   7920,  20220,  20221,
   20222,  20223,   7019,  20224,  20225,  20226,  20227,  20228,
   20229,   4406,   2474,  20230,  20231,  20232,  20233,  20234,
   20235,  20236,   2381,   4798,  20237,  20238,  20239,  20240,
   20241,  20242,  20243,   6072,  20244,  20245,  20246,  20247,
    7979,   1513,   1679,  20248,  20249,  20250,  20251,  20252,
   20253,  20254,   7980,  20255,  20256,   7982,  20257,  20258,
   20259,   2398,   7981,  20260,   3213,  20261,  20262,  20263,
   20264,  20265,  20266,  20267,   7984,  20268,  20269,  20270,
    7983,  20271,  20272,  20273,  20274,  20275,  20276,  20277,
   20278,  20279,  20280,  20281,  20282,  20283,  20284,  20285,
   20286,  20287,  20288,  20289,  20290,  20291,  20292,  20293,
   20294,  20295,  20296,  20297,  20298,  20299,  20300,  20301,
   20302,  20303,  20304,  20305,  20306,  20307,  20308,  20309,
   20310,  20311,  20312,  20313,  20314,  20315,  20316,  20317,
   20318,  20319,  20320,  20321,  20322,  20323,  20324,  20325,
   20326,  20327,  20328,  20329,  20330,  20331,  20332,  20333,
   20334,  20335,  20336,  20337,  20338,  20339,  20340,  20341,
   20342,  20343,  20344,  20345,  20346,  20347,  20348,  20349,
   20350,  20351,  20352,  20353,  20354,  20355,  20356,  20357,
   20358,  20359,  20360,  20361,  20362,  20363,  20364,  20365,
   20366,  20367,  20368,  20369,  20370,  20371,  20372,  20373,
   20374,  20375,  20376,  20377,  20378,  20379,  20380,  20381,
   20382,  20383,  20384,  20385,  20386,  20387,  20388,  20389,
   20390,  20391,  20392,  20393,  20394,  20395,  20396,  20397,
   20398,  20399,  20400,  20401,  20402,   1523,   4961,   2187,
   20403,   2272,   1635,   4873,   4368,   1469,   4930,   2528,
    5023,   2090,   4057,   3499,   1568,   2281,   5073,   2320,
    2068,   2627,   6919,   6920,   4130,   2338,   6921,   1876,
    3214,   2116,   2405,   6922,   4877,   6923,   2591,   2506,
    6924,   3069,   3125,   4856,   5117,   6925,   6926,   6929,
    6927,   6928,   3821,   2180,   2009,   6930,   3927,   3804,
    1830,  20404,  20405,   6166,   3449,   6931,   2934,  20406,
    5099,   6932,   5087,   3757,   5220,   5214,   4855,  20407,
    4882,   3795,   4713,   2212,   1755,  20408,   3825,   7887,
   20409,  20410,  20411,   2402,  20412,   7888,  20413,  20414,
    5138,  20415,  20416,   7882,   2177,   4939,   2208,   3557,
   20417,  20418,  20419,  20420,  20421,  20422,  20423,  20424,
   20425,   1726,  20426,  20427,   7883,   1703,  20428,  20429,
   20430,  20431,   4822,   3658,  20432,  20433,  20434,  20435,
   20436,   7885,  20437,  20438,   7884,  20439,  20440,  20441,
   20442,  20443,  20444,  20445,  20446,  20447,  20448,   4084,
   20449,  20450,  20451,   3669,  20452,  20453,  20454,  20455,
   20456,  20457,  20458,  20459,  20460,  20461,  20462,  20463,
   20464,   7886,  20465,   5142,   3414,   7927,  20466,  20467,
    7922,  20468,   7930,  20469,   7929,  20470,   5007,   7928,
   20471,  20472,  20473,   4823,   7931,  20474,   7939,  20475,
   20476,  20477,  20478,   1456,   1967,  20479,   7936,   7937,
   20480,   3443,  20481,  20482,  20483,  20484,   7932,   7933,
   20485,  20486,   7934,   7938,  20487,   2789,   7935,   2251,
   20488,  20489,  20490,   7943,   7946,  20491,  20492,  20493,
    2890,  20494,   2337,   7923,   7940,  20495,  20496,   3124,
   20497,  20498,  20499,   4129,  20500,   2626,  20501,   7941,
    7942,   7944,   2042,   7945,  20502,   7948,  20503,  20504,
   20505,  20506,  20507,  20508,  20509,   7924,  20510,  20511,
   20512,   7947,   4726,  20513,   1767,  20514,  20515,   4045,
   20516,  20517,  20518,  20519,   7949,  20520,  20521,  20522,
   20523,  20524,  20525,  20526,  20527,   7950,   2790,   7951,
   20528,  20529,   4104,   7954,  20530,  20531,  20532,  20533,
   20534,   1637,   5132,  20535,   7952,  20536,   7953,   7955,
   20537,   7961,  20538,  20539,  20540,   7959,  20541,  20542,
   20543,   7958,   7956,  20544,  20545,   7960,  20546,  20547,
    7957,   7963,   7964,  20548,   4108,  20549,  20550,   6422,
    1903,   7962,   7967,   4044,  20551,  20552,  20553,  20554,
   20555,   7965,   7966,  20556,  20557,  20558,  20559,  20560,
   20561,   7925,  20562,  20563,  20564,  20565,  20566,  20567,
   20568,  20569,  20570,  20571,  20572,  20573,   1539,  20574,
   20575,   7926,  20576,  20577,   1916,   1665,  20578,   7971,
    7968,  20579,   2028,  20580,   7972,  20581,   7969,  20582,
   20583,  20584,  20585,  20586,   7970,  20587,  20588,   1843,
   20589,   4867,  20590,  20591,  20592,   7973,  20593,   1780,
   20594,  20595,  20596,  20597,  20598,  20599,  20600,   7974,
    7976,  20601,  20602,  20603,   7975,  20604,  20605,  20606,
   20607,  20608,  20609,  20610,   7977,  20611,   7978,  20612,
   20613,  20614,  20615,  20616,  20617,  20618,  20619,  20620,
   20621,  20622,  20623,   3836,   2265,  20624,  20625,   3662,
   20626,  20627,   2040,  20628,  20629,  20630,  20631,  20632,
   20633,  20634,   4082,  20635,  20636,  20637,  20638,  20639,
   20640,  20641,  20642,  20643,  20644,  20645,  20646,  20647,
   20648,  20649,  20650,  20651,  20652,  20653,   6867,  20654,
   20655,  20656,  20657,  20658,  20659,  20660,  20661,  20662,
   20663,  20664,  20665,  20666,  20667,  20668,  20669,  20670,
   20671,  20672,  20673,  20674,  20675,  20676,  20677,  20678,
   20679,  20680,  20681,  20682,  20683,  20684,  20685,  20686,
   20687,  20688,  20689,  20690,  20691,  20692,  20693,  20694,
   20695,  20696,  20697,  20698,  20699,  20700,  20701,  20702,
   20703,  20704,  20705,  20706,  20707,  20708,  20709,  20710,
   20711,  20712,  20713,  20714,  20715,  20716,  20717,  20718,
   20719,  20720,  20721,  20722,  20723,  20724,  20725,  20726,
   20727,  20728,  20729,  20730,  20731,  20732,  20733,  20734,
   20735,  20736,  20737,  20738,  20739,  20740,  20741,  20742,
   20743,  20744,  20745,  20746,  20747,  20748,  20749,  20750,
   20751,  20752,  20753,  20754,  20755,  20756,  20757,  20758,
   20759,  20760,  20761,  20762,  20763,  20764,  20765,  20766,
   20767,  20768,  20769,  20770,  20771,  20772,  20773,  20774,
   20775,  20776,  20777,  20778,  20779,  20780,  20781,  20782,
   20783,  20784,  20785,  20786,  20787,  20788,  20789,  20790,
   20791,  20792,  20793,  20794,  20795,  20796,  20797,  20798,
   20799,  20800,  20801,  20802,  20803,  20804,   1712,   4887,
    2331,   4506,  20805,   6844,   5085,   6845,   3155,   3742,
    2417,   6846,   6847,   6848,   5046,   6849,   6850,   6852,
    6851,   6853,   6854,   3636,   6855,   4849,   6856,   2677,
   20806,   6857,   6858,   2678,   6859,   2169,   3037,   6860,
    1521,   2495,   2340,   6861,  20807,   6862,   6863,   6864,
    2155,   2550,  20808,   3921,   5967,   4808,   4352,   4910,
    6865,   4949,   6866,   4450,   2283,  20809,   1824,   1560,
   20810,  20811,  20812,   2930,  20813,  20814,  20815,  20816,
    1573,   1574,  20817,   1575,  20818,  20819,  20820,  20821,
    1720,   3737,  20822,  20823,  20824,  20825,   6424,  20826,
   20827,   1566,  20828,  20829,  20830,   3048,   1864,  20831,
   20832,   3579,   4755,  20833,   3566,   4535,  20834,   2348,
    3186,  20835,  20836,  20837,  20838,  20839,   4712,  20840,
    4836,   2723,  20841,   6425,   2088,   6426,  20842,  20843,
    2468,   4953,  20844,   2719,   4815,   4234,   3019,   1748,
   20845,  20846,   4127,  20847,   6429,   6427,   6431,  20848,
    6433,   6430,   1926,   3517,  20849,   1971,   6428,  20850,
    3939,  20851,  20852,   6432,  20853,  20854,  20855,   3247,
    1540,   2540,  20856,  20857,  20858,   5098,  20859,  20860,
    4178,   3992,   3895,   4092,   6435,   6434,   3359,  20861,
   20862,   4512,   4534,   6436,  20863,   6439,  20864,   4159,
    5061,   6438,   1940,  20865,   4165,  20866,   6440,   1999,
   20867,  20868,   4143,   2323,  20869,   3890,   1740,   4004,
    4869,   6441,   2141,  20870,  20871,  20872,   6437,  20873,
   20874,  20875,  20876,  20877,  20878,   6444,   1879,   6445,
   20879,  20880,  20881,  20882,  20883,   6442,   6443,  20884,
    4666,  20885,  20886,   3164,   1541,  20887,   4765,  20888,
   20889,   2034,   4023,  20890,   6446,  20891,  20892,   4785,
   20893,  20894,  20895,  20896,  20897,   1576,  20898,   2057,
    6449,   6447,   6448,   1911,  20899,  20900,  20901,   4642,
    6451,  20902,  20903,   6453,  20904,  20905,  20906,  20907,
   20908,  20909,   6452,   3589,  20910,   4608,  20911,  20912,
    6450,  20913,  20914,  20915,  20916,   4859,   4945,  20917,
   20918,  20919,  20920,  20921,   6455,   5156,  20922,  20923,
   20924,  20925,  20926,  20927,  20928,   6456,  20929,   1563,
    4602,  20930,   6457,   6459,  20931,  20932,  20933,  20934,
    6458,  20935,  20936,   6460,  20937,  20938,  20939,  20940,
   20941,   4661,  20942,   1922,  20943,   6642,  20944,   5442,
   20945,   5445,  20946,   5443,  20947,   5444,  20948,  20949,
   20950,   5447,   4464,   3328,  20951,  20952,   1487,  20953,
   20954,  20955,   4433,  20956,   5446,  20957,   4741,   2359,
    5453,   3652,  20958,   5449,   5448,   3818,   5450,  20959,
    5452,   5137,   5451,   3065,  20960,  20961,   5456,  20962,
   20963,   4783,  20964,  20965,   5458,   5455,  20966,   5459,
   20967,  20968,   2659,  20969,  20970,  20971,   2954,   5454,
    5457,   4984,  20972,   5460,  20973,  20974,  20975,   5464,
   20976,  20977,  20978,   5465,   5463,   2383,  20979,  20980,
   20981,   2823,   5462,  20982,  20983,  20984,   5461,   4832,
    1628,  20985,  20986,   5466,  20987,   2344,  20988,   5467,
   20989,  20990,  20991,  20992,   1718,  20993,  20994,  20995,
    1885,  20996,  20997,  20998,  20999,   2001,   5468,  21000,
   21001,  21002,   2058,  21003,   5469,  21004,  21005,  21006,
   21007,  21008,  21009,  21010,  21011,  21012,  21013,  21014,
   21015,  21016,  21017,  21018,  21019,  21020,  21021,  21022,
   21023,   1544,  21024,  21025,  21026,  21027,   5471,  21028,
   21029,  21030,   5470,   5472,  21031,  21032,  21033,  21034,
   21035,  21036,  21037,  21038,  21039,  21040,  21041,   5474,
   21042,   5473,  21043,  21044,  21045,  21046,  21047,  21048,
   21049,   5475,  21050,  21051,  21052,  21053,  21054,  21055,
   21056,  21057,  21058,   5476,  21059,  21060,   5477,  21061,
   21062,   4746,   7891,   3656,   5110,   3451,   7893,   7894,
    7892,  21063,   2763,  21064,  21065,  21066,  21067,   4496,
   21068,  21069,   2118,  21070,  21071,   4838,   4051,  21072,
   21073,   7897,   7896,   2357,   7895,   4001,  21074,  21075,
   21076,   7899,   2963,  21077,   1765,  21078,   4145,   7900,
    7898,   2651,   7903,  21079,   7904,   2676,   3219,   2884,
    4012,   7905,  21080,  21081,  21082,   7901,   7902,   3369,
   21083,  21084,  21085,  21086,  21087,   7907,  21088,   1813,
   21089,   5152,  21090,   1840,   7906,   7909,  21091,  21092,
    7908,   7910,   4466,  21093,  21094,  21095,  21096,  21097,
   21098,  21099,   3244,   3674,  21100,  21101,  21102,  21103,
   21104,  21105,   7911,   7912,  21106,  21107,  21108,  21109,
   21110,  21111,   7913,  21112,  21113,   7914,   7915,   7916,
   21114,  21115,  21116,  21117,   7918,   7917,  21118,  21119,
   21120,  21121,   7919,  21122,  21123,  21124,  21125,  21126,
   21127,  21128,  21129,  21130,  21131,  21132,  21133,   1638,
   21134,   4751,   3898,  21135,   2992,   5037,   4621,   3038,
   21136,   2711,  21137,  21138,  21139,  21140,  21141,  21142,
   21143,  21144,  21145,  21146,   2171,  21147,  21148,  21149,
   21150,  21151,  21152,  21153,  21154,  21155,  21156,  21157,
   21158,  21159,  21160,  21161,  21162,  21163,  21164,  21165,
   21166,  21167,  21168,  21169,  21170,  21171,  21172,  21173,
   21174,  21175,  21176,  21177,  21178,  21179,  21180,  21181,
   21182,  21183,  21184,  21185,  21186,  21187,  21188,  21189,
   21190,  21191,  21192,  21193,  21194,  21195,  21196,  21197,
   21198,  21199,  21200,  21201,  21202,  21203,  21204,  21205,
   21206,  21207,  21208,  21209,  21210,  21211,  21212,  21213,
   21214,  21215,  21216,  21217,  21218,  21219,  21220,  21221,
   21222,  21223,  21224,  21225,  21226,  21227,  21228,  21229,
   21230,  21231,  21232,  21233,  21234,  21235,  21236,  21237,
   21238,  21239,  21240,  21241,  21242,  21243,  21244,  21245,
   21246,  21247,  21248,  21249,  21250,  21251,  21252,  21253,
   21254,  21255,  21256,  21257,  21258,  21259,  21260,  21261,
   21262,  21263,  21264,  21265,  21266,  21267,  21268,  21269,
   21270,  21271,  21272,  21273,  21274,  21275,  21276,  21277,
   21278,  21279,  21280,  21281,  21282,  21283,  21284,  21285,
   21286,  21287,  21288,  21289,  21290,  21291,  21292,  21293,
   21294,  21295,  21296,  21297,   2625,  21298,  21299,  21300,
   21301,  21302,  21303,  21304,  21305,  21306,  21307,  21308,
   21309,  21310,  21311,  21312,  21313,  21314,  21315,  21316,
   21317,  21318,  21319,  21320,  21321,  21322,   8027,  21323,
   21324,  21325,  21326,  21327,  21328,  21329,  21330,  21331,
   21332,  21333,  21334,  21335,  21336,  21337,  21338,  21339,
   21340,  21341,  21342,  21343,  21344,  21345,  21346,  21347,
   21348,  21349,  21350,  21351,  21352,  21353,   8028,  21354,
   21355,  21356,  21357,  21358,  21359,  21360,  21361,  21362,
   21363,  21364,  21365,  21366,  21367,  21368,  21369,  21370,
   21371,  21372,  21373,  21374,  21375,  21376,  21377,  21378,
    8029,  21379,  21380,  21381,  21382,  21383,  21384,  21385,
   21386,  21387,  21388,  21389,  21390,  21391,  21392,  21393,
   21394,  21395,  21396,  21397,  21398,  21399,  21400,  21401,
   21402,  21403,  21404,  21405,  21406,  21407,  21408,  21409,
   21410,  21411,  21412,  21413,  21414,  21415,  21416,  21417,
   21418,  21419,  21420,  21421,  21422,  21423,  21424,  21425,
   21426,  21427,  21428,  21429,  21430,  21431,  21432,  21433,
   21434,  21435,  21436,  21437,  21438,  21439,  21440,  21441,
   21442,  21443,  21444,  21445,  21446,  21447,  21448,  21449,
   21450,  21451,  21452,  21453,  21454,  21455,  21456,  21457,
   21458,  21459,  21460,  21461,  21462,  21463,  21464,  21465,
   21466,  21467,  21468,  21469,  21470,  21471,  21472,  21473,
   21474,  21475,  21476,  21477,  21478,  21479,  21480,  21481,
   21482,  21483,  21484,  21485,  21486,  21487,  21488,  21489,
   21490,  21491,  21492,  21493,  21494,  21495,   8030,  21496,
   21497,  21498,  21499,  21500,  21501,  21502,  21503,  21504,
   21505,  21506,  21507,  21508,  21509,  21510,  21511,  21512,
   21513,  21514,  21515,  21516,  21517,  21518,  21519,  21520,
   21521,  21522,  21523,  21524,  21525,  21526,  21527,  21528,
   21529,  21530,  21531,  21532,  21533,  21534,  21535,  21536,
   21537,  21538,   8031,  21539,  21540,  21541,  21542,  21543,
   21544,  21545,  21546,  21547,  21548,  21549,  21550,  21551,
   21552,  21553,  21554,  21555,  21556,  21557,  21558,  21559,
   21560,  21561,  21562,  21563,  21564,  21565,  21566,  21567,
   21568,  21569,  21570,  21571,  21572,  21573,  21574,   8033,
   21575,  21576,  21577,  21578,  21579,  21580,  21581,  21582,
   21583,  21584,  21585,  21586,  21587,  21588,  21589,  21590,
   21591,  21592,  21593,  21594,  21595,  21596,  21597,  21598,
   21599,  21600,  21601,  21602,  21603,  21604,  21605,  21606,
   21607,  21608,  21609,  21610,  21611,  21612,  21613,  21614,
   21615,  21616,  21617,  21618,  21619,  21620,  21621,  21622,
   21623,  21624,  21625,  21626,  21627,  21628,  21629,  21630,
   21631,  21632,   8032,  21633,  21634,  21635,  21636,  21637,
   21638,  21639,  21640,  21641,  21642,  21643,   8156,  21644,
   21645,  21646,  21647,  21648,  21649,  21650,  21651,  21652,
   21653,  21654,  21655,  21656,  21657,  21658,  21659,  21660,
   21661,  21662,  21663,  21664,  21665,  21666,  21667,  21668,
   21669,  21670,  21671,  21672,  21673,  21674,  21675,  21676,
   21677,  21678,  21679,  21680,  21681,  21682,  21683,  21684,
   21685,  21686,  21687,  21688,  21689,  21690,  21691,  21692,
   21693,  21694,  21695,  21696,  21697,  21698,  21699,  21700,
   21701,  21702,  21703,  21704,  21705,  21706,  21707,  21708,
   21709,  21710,  21711,  21712,  21713,  21714,  21715,  21716,
   21717,  21718,  21719,  21720,  21721,  21722,  21723,  21724,
   21725,  21726,  21727,  21728,  21729,  21730,  21731,  21732,
   21733,  21734,  21735,  21736,  21737,  21738,  21739,  21740,
   21741,  21742,  21743,  21744,  21745,  21746,   8034,  21747,
   21748,  21749,  21750,  21751,  21752,  21753,  21754,  21755,
   21756,  21757,  21758,  21759,  21760,  21761,  21762,  21763,
   21764,  21765,  21766,  21767,  21768,  21769,  21770,  21771,
   21772,  21773,  21774,  21775,  21776,  21777,  21778,  21779,
   21780,  21781,  21782,  21783,  21784,  21785,  21786,  21787,
   21788,  21789,  21790,   8035,  21791,  21792,  21793,  21794,
   21795,  21796,  21797,  21798,  21799,  21800,  21801,  21802,
   21803,  21804,  21805,  21806,  21807,  21808,  21809,  21810,
   21811,  21812,  21813,  21814,  21815,   7273,   7274,   7275,
    4962,   1977,   7277,   7276,   7278,   7279,   3576,   7280,
    7281,  21816,   2083,   1965,   7282,   7284,  21817,   7283,
   21818,   2199,   7285,   7286,   7287,   2032,   1705,   5032,
    3327,   1524,   2215,   7288,   7289,   4824,   3624,   2816,
    4286,   2274,   7291,   7290,   7293,   7292,   3388,   7294,
    7295,   3585,   7296,   3586,   7297,   1604,   7298,   7299,
    7300,   7301,   7302,   5149,   7303,   7304,   2593,   7305,
    4742,   4131,   1609,   3076,   7306,   3577,   3208,  21819,
    7307,   7308,   7309,   7310,   7311,   7312,   7313,  21820,
    7314,   7315,   7316,  21821,  21822,   7317,   7318,   7319,
    7321,   7320,  21823,   7322,   4148,   3134,   7323,   7324,
    7325,   4888,   7326,   4342,   7327,   7328,  21824,   7329,
    7330,   7332,   7331,   7333,   2246,   3285,   7334,   7335,
    2665,   4636,   1686,   7336,   7337,   7338,   4693,   7339,
    5074,   7340,   3521,  21825,   7341,   7342,   3027,   7343,
    4413,   4035,   7345,   7344,   1781,   2343,   7346,   7347,
    4483,   7348,   7349,   2137,   4448,   7350,   7351,   7352,
    3746,   4105,   7353,   7354,   7355,   7356,   7357,   4951,
    7358,   1862,   3205,   7359,  21826,   7360,   7361,   7362,
   21827,   4322,   7363,   3165,   1809,   5097,   2716,  21828,
    4362,   7366,   7364,   7365,   7367,   1980,   2629,   2791,
    3239,   7368,   7369,  21829,   7370,   7378,   7371,   7372,
    7373,   3605,   7412,   2018,   7374,  21830,   7375,   7376,
    2011,   3225,   7377,  21831,   7379,   7380,   7381,   4969,
   21832,   7382,   3376,  21833,   7383,   3377,   7384,   7385,
    2229,   1496,   7386,   7387,   7388,  21834,   7389,   7390,
    7391,   7392,  21835,   7393,   2746,   7396,   7394,   7395,
   21836,   7397,   7398,   3052,   7399,   7400,   7401,   7402,
    7403,   7404,   7405,   7406,   7407,   2969,  21837,   7408,
    3020,   7409,   7410,   7411,  21838,  21839,   4389,  21840,
   21841,  21842,  21843,  21844,  21845,  21846,  21847,   1695,
   21848,  21849,  21850,  21851,  21852,  21853,  21854,  21855,
   21856,  21857,  21858,  21859,  21860,  21861,  21862,  21863,
   21864,  21865,  21866,  21867,  21868,  21869,  21870,  21871,
   21872,  21873,  21874,  21875,  21876,  21877,  21878,  21879,
   21880,  21881,  21882,  21883,  21884,  21885,  21886,  21887,
   21888,  21889,  21890,  21891,  21892,  21893,  21894,  21895,
   21896,  21897,  21898,  21899,  21900,  21901,  21902,  21903,
   21904,  21905,  21906,  21907,  21908,  21909,  21910,  21911,
   21912,  21913,  21914,  21915,  21916,  21917,  21918,  21919,
   21920,  21921,  21922,  21923,  21924,  21925,  21926,  21927,
   21928,  21929,  21930,  21931,  21932,  21933,  21934,  21935,
   21936,  21937,  21938,  21939,  21940,  21941,  21942,  21943,
   21944,  21945,  21946,  21947,  21948,  21949,  21950,  21951,
    3232,   6240,   3792,   6241,  21952,   1556,   4271,   1804,
    3747,   6242,   4371,   6243,   2605,   6244,   6245,   3233,
    4889,   3343,   2330,   4266,   6246,   3281,   6247,  21953,
    2074,   2244,   2399,   6248,   6249,   4829,   6250,  21954,
    6251,   4554,   6252,   6253,   6254,   6255,   4565,   6256,
    1688,   2940,   6257,  21955,   2924,   6258,   6259,   6260,
   21956,   6261,   6262,  21957,   2184,   5423,  21958,   2024,
   21959,   5425,   5424,  21960,  21961,  21962,  21963,  21964,
   21965,  21966,   5427,  21967,  21968,  21969,   3743,  21970,
   21971,   5426,   2099,   4595,   4690,   4970,   2686,  21972,
   21973,  21974,  21975,   5147,   5429,   5428,  21976,   1411,
    4186,  21977,   5430,  21978,   2190,   2579,   3130,   3105,
    1725,   5431,  21979,   3111,   3305,   2652,  21980,  21981,
    4385,  21982,  21983,  21984,   5432,   3793,  21985,  21986,
   21987,  21988,  21989,   1564,  21990,  21991,  21992,   5433,
   21993,   1997,   4819,  21994,   1784,  21995,  21996,   5434,
    4834,   4376,   3450,  21997,   5435,  21998,  21999,  22000,
   22001,  22002,   5436,  22003,   5437,   3081,   4094,   4384,
   22004,  22005,  22006,  22007,  22008,  22009,  22010,  22011,
   22012,  22013,  22014,  22015,  22016,   4770,   3102,  22017,
    5438,  22018,  22019,   4016,  22020,   5439,  22021,   4017,
    4699,  22022,  22023,  22024,   2245,  22025,  22026,   5440,
    1424,   4345,  22027,  22028,   4934,  22029,  22030,  22031,
   22032,  22033,  22034,  22035,  22036,  22037,  22038,   4024,
   22039,  22040,  22041,  22042,  22043,  22044,  22045,  22046,
    5441,  22047,  22048,   6239,  22049,  22050,   3012,  22051,
   22052,   8020,  22053,  22054,   8021,   8022,   3338,  22055,
    3689,   4578,  22056,  22057,   4476,   4548,   2552,   2300,
   22058,   7415,  22059,  22060,   1823,   4725,   8023,   1782,
   22061,  22062,   8024,  22063,  22064,   1960,  22065,  22066,
   22067,  22068,  22069,  22070,  22071,  22072,  22073,  22074,
    8026,  22075,  22076,  22077,  22078,  22079,  22080,  22081,
    4773,   7996,   4520,  22082,  22083,  22084,  22085,   7998,
   22086,  22087,  22088,   7997,  22089,  22090,   3074,   2968,
   22091,   1505,  22092,  22093,  22094,  22095,   4306,  22096,
    4489,   8000,  22097,  22098,   4409,  22099,   7999,   4967,
    8001,   3220,  22100,  22101,  22102,   2527,   8003,   8002,
   22103,  22104,  22105,   3351,  22106,  22107,   3063,  22108,
   22109,  22110,  22111,  22112,   3957,  22113,   4351,  22114,
   22115,  22116,  22117,  22118,  22119,  22120,  22121,  22122,
   22123,  22124,   8004,  22125,  22126,   8005,  22127,  22128,
    8006,  22129,   3123,  22130,  22131,  22132,  22133,  22134,
    1461,   3472,  22135,  22136,  22137,  22138,   8007,  22139,
   22140,  22141,  22142,  22143,  22144,  22145,  22146,  22147,
   22148,  22149,  22150,  22151,  22152,  22153,  22154,  22155,
   22156,  22157,   3635,   7995,  22158,  22159,   2749,  22160,
   22161,   2743,  22162,   1948,  22163,  22164,   2106,  22165,
    2850,   3245,   3265,  22166,  22167,   5213,  22168,  22169,
   22170,   2240,  22171,  22172,  22173,  22174,  22175,  22176,
   22177,  22178,  22179,   2720,   4516,  22180,   1457,  22181,
   22182,  22183,  22184,  22185,   8099,  22186,  22187,  22188,
   22189,  22190,  22191,  22192,  22193,   8100,  22194,  22195,
   22196,  22197,  22198,   4429,  22199,   1425,  22200,  22201,
   22202,   8101,   8102,  22203,   8103,  22204,  22205,  22206,
    3613,  22207,  22208,  22209,  22210,  22211,  22212,  22213,
    2772,  22214,  22215,   8106,  22216,  22217,  22218,  22219,
   22220,  22221,  22222,   8105,  22223,   1565,  22224,   8104,
   22225,  22226,   8107,  22227,   8108,  22228,  22229,  22230,
   22231,  22232,  22233,  22234,  22235,  22236,  22237,  22238,
   22239,  22240,  22241,  22242,  22243,  22244,  22245,  22246,
   22247,  22248,  22249,  22250,  22251,  22252,  22253,  22254,
   22255,  22256,  22257,  22258,  22259,  22260,  22261,  22262,
   22263,  22264,  22265,  22266,  22267,  22268,  22269,  22270,
   22271,  22272,  22273,  22274,  22275,  22276,   4233,   3710,
   22277,   2360,   6697,   6698,   6699,   2759,  22278,  22279,
   22280,  22281,  22282,   4689,  22283,   4840,   3815,  22284,
   22285,  22286,  22287,  22288,  22289,  22290,  22291,  22292,
   22293,  22294,  22295,  22296,  22297,  22298,  22299,  22300,
   22301,  22302,  22303,  22304,  22305,  22306,  22307,  22308,
   22309,  22310,  22311,  22312,  22313,  22314,  22315,  22316,
   22317,  22318,  22319,  22320,  22321,  22322,  22323,  22324,
   22325,  22326,  22327,  22328,  22329,  22330,  22331,  22332,
   22333,  22334,  22335,  22336,  22337,  22338,  22339,  22340,
   22341,  22342,  22343,  22344,  22345,  22346,  22347,  22348,
   22349,  22350,  22351,  22352,  22353,  22354,  22355,  22356,
   22357,  22358,  22359,  22360,  22361,  22362,  22363,  22364,
   22365,  22366,  22367,  22368,  22369,  22370,  22371,  22372,
   22373,  22374,  22375,  22376,  22377,  22378,  22379,  22380,
   22381,  22382,  22383,  22384,  22385,  22386,  22387,  22388,
   22389,  22390,  22391,  22392,  22393,  22394,  22395,  22396,
   22397,  22398,  22399,  22400,  22401,  22402,  22403,  22404,
   22405,  22406,  22407,  22408,  22409,   4624,   1978,   3645,
    7611,   4401,   3966,   4492,   6658,   4206,   2298,   2030,
    7612,   1477,   3991,   7613,   4797,   3114,   3083,   3513,
    2742,   7614,   2590,  22410,   7615,   7616,  22411,   7617,
    4640,   3498,  22412,   4174,   7618,  22413,   4716,   2856,
    4107,  22414,   7619,   7620,   4564,   2051,   7621,   7622,
    1942,   7623,   7624,  22415,   1689,   7625,   7626,   3672,
   22416,  22417,  22418,  22419,  22420,  22421,  22422,  22423,
   22424,  22425,  22426,  22427,  22428,  22429,  22430,  22431,
   22432,  22433,  22434,  22435,  22436,  22437,  22438,  22439,
   22440,  22441,  22442,  22443,  22444,  22445,  22446,  22447,
   22448,  22449,  22450,  22451,  22452,  22453,   2138,  22454,
   22455,   7058,   7059,   7060,  22456,   7061,  22457,  22458,
    3491,   7062,   7063,  22459,  22460,  22461,   2108,   3872,
   22462,  22463,  22464,  22465,  22466,  22467,  22468,   6133,
    8130,  22469,  22470,  22471,  22472,  22473,  22474,  22475,
   22476,  22477,  22478,  22479,  22480,  22481,  22482,  22483,
   22484,  22485,  22486,  22487,  22488,  22489,  22490,  22491,
   22492,  22493,  22494,  22495,  22496,  22497,  22498,  22499,
   22500,  22501,  22502,  22503,  22504,   8131,  22505,  22506,
    1642,  22507,  22508,  22509,  22510,  22511,  22512,  22513,
   22514,  22515,  22516,  22517,  22518,  22519,  22520,  22521,
   22522,  22523,  22524,  22525,  22526,  22527,  22528,  22529,
   22530,  22531,  22532,  22533,  22534,  22535,   8132,  22536,
   22537,  22538,  22539,  22540,  22541,  22542,  22543,  22544,
   22545,  22546,  22547,  22548,  22549,  22550,  22551,  22552,
   22553,  22554,  22555,  22556,  22557,  22558,  22559,  22560,
   22561,  22562,  22563,  22564,  22565,  22566,  22567,  22568,
   22569,  22570,  22571,  22572,   8134,   8133,  22573,  22574,
   22575,  22576,  22577,  22578,  22579,  22580,  22581,  22582,
   22583,  22584,  22585,   6136,  22586,   2539,  22587,   6137,
    6138,   6139,   6140,   6141,   6142,   2092,   4696,   2635,
    3899,   1508,   3986,  22588,   6143,   2065,   3701,   6144,
   22589,  22590,   2671,  22591,   1596,   6145,  22592,   2059,
    6146,   3346,  22593,  22594,   6147,   4381,   2316,   6148,
    2914,  22595,   6149,   1683,  22596,   6150,  22597,   3090,
    6151,   6152,   3189,   6153,   6154,   6155,   3908,   5193,
    5332,   4390,  22598,  22599,  22600,  22601,  22602,  22603,
   22604,  22605,  22606,  22607,  22608,   7430,  22609,  22610,
    5561,  22611,  22612,  22613,  22614,  22615,  22616,  22617,
   22618,  22619,  22620,  22621,  22622,  22623,  22624,  22625,
   22626,  22627,  22628,  22629,  22630,  22631,  22632,  22633,
   22634,  22635,  22636,  22637,  22638,  22639,  22640,  22641,
   22642,  22643,  22644,  22645,  22646,  22647,  22648,  22649,
   22650,  22651,  22652,  22653,  22654,  22655,  22656,  22657,
   22658,  22659,  22660,  22661,  22662,  22663,  22664,  22665,
   22666,  22667,  22668,  22669,  22670,  22671,  22672,  22673,
   22674,  22675,  22676,  22677,  22678,  22679,  22680,  22681,
   22682,  22683,  22684,  22685,  22686,  22687,  22688,  22689,
   22690,  22691,  22692,  22693,  22694,  22695,  22696,  22697,
   22698,  22699,  22700,  22701,  22702,  22703,  22704,  22705,
   22706,  22707,  22708,  22709,  22710,  22711,  22712,  22713,
   22714,  22715,  22716,  22717,  22718,  22719,  22720,  22721,
   22722,  22723,  22724,  22725,  22726,  22727,  22728,  22729,
   22730,  22731,  22732,  22733,  22734,  22735,  22736,  22737,
   22738,  22739,  22740,  22741,  22742,  22743,  22744,  22745,
   22746,  22747,  22748,  22749,  22750,  22751,  22752,  22753,
   22754,  22755,  22756,  22757,  22758,  22759,  22760,  22761,
   22762,  22763,  22764,  22765,  22766,  22767,  22768,  22769,
   22770,  22771,  22772,  22773,  22774,  22775,  22776,  22777,
   22778,  22779,  22780,  22781,  22782,  22783,  22784,  22785,
   22786,  22787,  22788,  22789,  22790,  22791,  22792,  22793,
   22794,  22795,  22796,  22797,  22798,  22799,  22800,  22801,
   22802,  22803,  22804,  22805,   3178,   4799,   4187,   4528,
    1750,   3664,  22806,   1618,   3132,   6549,   3880,   6550,
    6551,   2777,   6552,   5079,   4188,   6554,   2598,   6553,
    6555,   6556,   3179,  22807,   2661,   6557,   3171,   2356,
    6558,  22808,   6559,   1741,   4584,  22809,  22810,   2824,
    6560,   3556,   6561,   6562,  22811,  22812,   6563,   3490,
    6564,  22813,   3766,   6565,   6566,   6567,   6416,   6568,
    6569,   3167,   6570,   6571,   5053,   6572,  22814,   6573,
    2294,  22815,  22816,  22817,  22818,  22819,  22820,  22821,
    8110,   8109,  22822,  22823,  22824,  22825,   8113,   8111,
    2350,  22826,   8114,  22827,   8115,  22828,  22829,  22830,
    8117,   8116,   8119,  22831,  22832,   8118,  22833,  22834,
   22835,  22836,  22837,   8120,   8121,  22838,  22839,  22840,
   22841,   8122,  22842,   4019,  22843,  22844,  22845,  22846,
    2224,  22847,  22848,  22849,  22850,  22851,  22852,   8135,
   22853,   8136,  22854,  22855,  22856,  22857,   8137,  22858,
   22859,  22860,  22861,   8139,  22862,   8141,  22863,   8138,
   22864,  22865,  22866,  22867,  22868,  22869,  22870,  22871,
   22872,   8142,  22873,   8140,  22874,  22875,  22876,  22877,
   22878,  22879,  22880,   5130,  22881,  22882,  22883,  22884,
    8143,  22885,  22886,  22887,  22888,  22889,  22890,   8144,
   22891,  22892,  22893,   8145,  22894,  22895,  22896,  22897,
   22898,  22899,  22900,  22901,  22902,  22903,  22904,   8146,
   22905,  22906,  22907,   8147,  22908,  22909,  22910,  22911,
   22912,  22913,  22914,  22915,  22916,  22917,  22918,   5494,
   22919,  22920,   5179,  22921,  22922,  22923,  22924,  22925,
   22926,  22927,  22928,   6478,   2332,  22929,  22930,  22931,
   22932,   2912,   2517,   8124,   3516,   8123,  22933,   8125,
    8127,   8126,  22934,  22935,  22936,   8128,  22937,   4255,
   22938,   8129,  22939,  22940,   3296,  22941,  22942,  22943,
   22944,  22945,  22946,  22947,  22948,  22949,  22950,  22951,
   22952,  22953,  22954,  22955,  22956,  22957,  22958,  22959,
   22960,  22961,  22962,  22963,  22964,  22965,  22966,  22967,
   22968,  22969,  22970,  22971,  22972,  22973,  22974,  22975,
   22976,  22977,  22978,  22979,  22980,  22981,  22982,  22983,
   22984,  22985,  22986,  22987,  22988,  22989,  22990,  22991,
   22992,  22993,  22994,  22995,  22996,  22997,  22998,  22999,
   23000,  23001,  23002,  23003,  23004,  23005,  23006,  23007,
   23008,  23009,  23010,  23011,  23012,  23013,  23014,  23015,
   23016,  23017,  23018,  23019,  23020,  23021,  23022,  23023,
   23024,  23025,  23026,  23027,  23028,  23029,  23030,  23031,
   23032,  23033,  23034,  23035,  23036,  23037,  23038,  23039,
   23040,  23041,  23042,  23043,  23044,  23045,  23046,  23047,
   23048,  23049,  23050,  23051,  23052,  23053,  23054,  23055,
   23056,  23057,  23058,  23059,  23060,  23061,  23062,  23063,
   23064,  23065,  23066,  23067,  23068,  23069,  23070,  23071,
   23072,  23073,  23074,  23075,  23076,  23077,  23078,  23079,
   23080,  23081,  23082,  23083,  23084,  23085,  23086,  23087,
   23088,  23089,  23090,  23091,  23092,  23093,  23094,  23095,
   23096,  23097,  23098,  23099,  23100,  23101,  23102,  23103,
   23104,  23105,  23106,  23107,  23108,  23109,  23110,  23111,
   23112,  23113,  23114,  23115,  23116,  23117,  23118,  23119,
   23120,  23121,  23122,  23123,  23124,  23125,  23126,  23127,
   23128,  23129,  23130,  23131,  23132,  23133,  23134,  23135,
   23136,  23137,  23138,  23139,  23140,  23141,  23142,  23143,
   23144,  23145,  23146,  23147,  23148,  23149,  23150,  23151,
   23152,  23153,  23154,  23155,  23156,  23157,  23158,  23159,
   23160,  23161,  23162,  23163,  23164,  23165,  23166,  23167,
   23168,  23169,  23170,  23171,  23172,  23173,  23174,  23175,
   23176,  23177,  23178,  23179,  23180,  23181,  23182,  23183,
   23184,  23185,  23186,  23187,  23188,  23189,  23190,  23191,
   23192,  23193,  23194,  23195,  23196,  23197,  23198,  23199,
   23200,  23201,  23202,  23203,  23204,  23205,  23206,  23207,
   23208,  23209,  23210,  23211,  23212,  23213,  23214,  23215,
   23216,  23217,  23218,  23219,  23220,  23221,  23222,  23223,
   23224,  23225,  23226,  23227,  23228,  23229,  23230,  23231,
   23232,  23233,  23234,  23235,   4766,  23236,  23237,   8036,
   23238,   3120,   8037,  23239,  23240,   8038,   8039,   8040,
    8041,  23241,  23242,   8043,  23243,   1514,   8044,  23244,
    8045,   8046,   8047,  23245,   8048,   8049,  23246,  23247,
   23248,  23249,   8050,   8051,   4365,  23250,   8052,   8053,
    8054,   8055,   8056,   8057,   2993,   8058,   8059,   8060,
    8061,   8062,  23251,   8063,  23252,   8064,   8065,  23253,
    8066,   8067,   8068,   8069,   8070,   8071,   8072,   8073,
    2733,  23254,   8074,   8075,   8076,   8077,  23255,  23256,
   23257,  23258,  23259,   3755,   8078,   8079,   8080,   8081,
   23260,  23261,   8082,   8083,   8084,   8085,   8086,   8087,
    8088,  23262,  23263,   8089,   8090,   8091,   1581,   8092,
    8093,   8094,  23264,  23265,   8095,   8096,   3066,   8097,
   23266,  23267,   8098,  23268,  23269,  23270,  23271,  23272,
   23273,  23274,  23275,  23276,  23277,  23278,  23279,  23280,
   23281,  23282,  23283,  23284,  23285,  23286,  23287,  23288,
   23289,  23290,  23291,  23292,  23293,  23294,  23295,  23296,
   23297,  23298,  23299,  23300,  23301,  23302,  23303,  23304,
   23305,  23306,  23307,  23308,  23309,  23310,  23311,  23312,
   23313,  23314,  23315,  23316,  23317,  23318,  23319,  23320,
   23321,  23322,  23323,  23324,  23325,  23326,  23327,  23328,
   23329,  23330,  23331,  23332,  23333,  23334,  23335,  23336,
   23337,  23338,  23339,  23340,  23341,  23342,  23343,  23344,
   23345,  23346,  23347,  23348,  23349,  23350,  23351,  23352,
   23353,  23354,  23355,  23356,  23357,  23358,  23359,  23360,
   23361,  23362,  23363,  23364,  23365,  23366,  23367,  23368,
   23369,  23370,  23371,  23372,  23373,  23374,  23375,  23376,
   23377,  23378,  23379,  23380,  23381,  23382,  23383,  23384,
   23385,  23386,  23387,  23388,  23389,  23390,  23391,  23392,
   23393,  23394,  23395,  23396,  23397,  23398,  23399,  23400,
   23401,  23402,  23403,  23404,  23405,  23406,  23407,  23408,
   23409,  23410,  23411,  23412,  23413,  23414,  23415,  23416,
   23417,  23418,  23419,  23420,  23421,  23422,  23423,  23424,
   23425,  23426,  23427,  23428,  23429,  23430,  23431,  23432,
   23433,  23434,  23435,  23436,  23437,  23438,  23439,  23440,
   23441,  23442,  23443,  23444,  23445,  23446,  23447,  23448,
   23449,  23450,  23451,  23452,  23453,  23454,  23455,  23456,
   23457,  23458,  23459,  23460,  23461,  23462,  23463,  23464,
   23465,  23466,  23467,  23468,  23469,  23470,  23471,  23472,
   23473,  23474,  23475,  23476,  23477,  23478,  23479,  23480,
   23481,  23482,  23483,  23484,  23485,  23486,  23487,  23488,
   23489,  23490,  23491,  23492,  23493,  23494,  23495,  23496,
   23497,  23498,  23499,  23500,  23501,  23502,  23503,  23504,
   23505,  23506,  23507,  23508,  23509,  23510,  23511,  23512,
   23513,  23514,  23515,  23516,  23517,  23518,  23519,  23520,
   23521,  23522,  23523,  23524,  23525,  23526,  23527,  23528,
   23529,  23530,  23531,  23532,  23533,  23534,  23535,  23536,
   23537,  23538,  23539,  23540,  23541,  23542,  23543,  23544,
   23545,  23546,  23547,  23548,  23549,  23550,  23551,  23552,
   23553,  23554,  23555,  23556,  23557,  23558,  23559,  23560,
   23561,  23562,  23563,  23564,  23565,  23566,  23567,  23568,
   23569,  23570,  23571,  23572,  23573,  23574,  23575,  23576,
   23577,  23578,  23579,  23580,  23581,  23582,  23583,   3370,
    7440,   2543,   7441,   3284,  23584,   3407,   4538,  23585,
    7442,   7443,   7444,   7445,   7446,   4539,  23586,   4587,
   23587,   7448,   7447,   4800,  23588,   4185,   7449,   7451,
    7450,   7452,   7453,  23589,  23590,   2236,   7454,   2421,
   23591,   7455,   7456,   2798,   7457,   2049,   7458,   7459,
    7460,   7461,   3686,   7462,   7463,  23592,   7464,   3467,
   23593,   7465,  23594,  23595,  23596,   7466,  23597,   7467,
    8112,  23598,   7468,   7469,   7470,  23599,   7471,  23600,
   23601,  23602,  23603,   7472,   2404,  23604,   7473,   7474,
    7475,   7476,   7477,   7478,   7479,   7481,  23605,  23606,
    4704,   7480,  23607,   7482,  23608,  23609,  23610,  23611,
   23612,  23613,  23614,  23615,  23616,  23617,   7921,   3126,
   23618,  23619,   8151,  23620,  23621,  23622,  23623,   8152,
    8153,  23624,  23625,   8154,  23626,  23627,  23628,  23629,
   23630,  23631,   8155,   3121,  23632,  23633,  23634,  23635,
   23636,  23637,  23638,  23639,  23640,   8157,  23641,   8158,
   23642,  23643,  23644,  23645,  23646,  23647,   3184,  23648,
   23649,  23650,  23651,  23652,  23653,  23654,  23655,  23656,
   23657,  23658,  23659,  23660,   7881,  23661,  23662,  23663,
    7880,  23664,  23665,   3174,  23666,   8148,   8149,  23667,
   23668,  23669,  23670,  23671,   2481,  23672,  23673,  23674,
   23675,   5331,  23676,  23677,  23678,   3935,   2985,   7429,
   23679,   2407,  23680,  23681,   3584,  23682,  23683,  23684,
    3301,  23685,  23686,   8159,   8160,   8161,  23687,   8163,
    8162,  23688,   8164,  23689,  23690,   8167,  23691,   8166,
   23692,   8165,   8168,  23693,  23694,  23695,  23696,   8169,
   23697,  23698,  23699,  23700,  23701,  23702,  23703,  23704,
   23705,   7216,  23706,   7217,   7218,  23707,   8017,  23708,
   23709,  23710,  23711,  23712,  23713,  23714,  23715,  23716,
   23717,  23718,  23719,   8018,  23720,   8019,   1979,  23721,
    5199,  23722,  23723,   2291,  23724,  23725,  23726,   5196,
   23727,   5562,  23728,  23729,  23730,  23731,  23732,  23733,
    3936,  23734,   8170,  23735,  23736,  23737,  23738,  23739,
   23740,  23741,  23742,  23743,   8171,  23744,  23745,   8172,
   23746,  23747,  23748,  23749,  23750,  23751,  23752,   8174,
   23753,   8173,  23754,   1542,  23755,   8175,   8176,  23756,
   23757,  23758,  23759,  23760,   8177,  23761,  23762,  23763,
   23764,  23765,  23766,  23767,  23768,  23769,  23770,  23771,
    3552,   7069,  23772,  23773,  23774,  23775,  23776,  23777,
   23778,  23779,  23780,  23781,  23782,  23783,  23784,  23785,
   23786,  23787,  23788,  23789,  23790,  23791,  23792,  23793,
   23794,  23795,  23796,  23797,  23798,  23799,  23800,  23801,
   23802,  23803,  23804,  23805,  23806,  23807,  23808,  23809,
   23810,  23811,  23812,  23813,  23814,  23815,  23816,   1752,
    8008,  23817,  23818,   8009,   3075,   8010,   8011,   8012,
    8013,   8014,   8015,   3668,   8016,  23819,  23820,  23821,
   23822,  23823,  23824,  23825,  23826,  23827,  23828,  23829,
   23830,   3097,   2263,   7215,  23831,  23832,  23833,   2329,
    5326,  23834,  23835,  23836,  23837,  23838,  42983,  42984,
   42985,  42986,  42987,  42988,  42989,  42990,  42991,  42992,
   42993,  42994,  42995,  42996,  42997,  42998,  42999,  43000,
   43001,  43002,  43003,  43004,  43005,  43006,  43007,  43008,
   43009,  43010,  43011,  43012,  43013,  43014,  43015,  43016,
   43017,  43018,  43019,  43020,  43021,  43022,  43023,  43024,
   43025,  43026,  43027,  43028,  43029,  43030,  43031,  43032,
   43033,  43034,  43035,  43036,  43037,  43038,  43039,  43040,
   43041,  43042,  43043,  43044,  43045,  43046,  43047,  43048,
   43049,  43050,  43051,  43052,  43053,  43054,  43055,  43056,
   43057,  43058,  43059,  43060,  43061,  43062,  43063,  43064,
   43065,  43066,  43067,  43068,  43069,  43070,  43071,  43072,
  // [0x00A4,0x00B7] -v # seg 2 at pos 21024
      71,  23976,  23977,     75,      6,  23978,  23979,  23980,
   23981,  23982,  23983,  23984,     66,     31,  23985,  23986,
   23987,  23988,  23989,      3,
  // [0x00D7,0x0101] -v # seg 4 at pos 21044
      32,  24021,  24022,  24023,  24024,  24025,  24026,  24027,
   24028,    661,    659,  24029,  24030,  24031,  24032,  24033,
   24034,    665,    663,    683,  24035,    669,    667,  24036,
   24037,  24038,  24039,    673,    671,  24040,  24041,  24042,
      33,  24043,    677,    675,  24044,    682,  24045,  24046,
   24047,  24048,    658,
  // [0x0113,0x011B] -v # seg 6 at pos 21087
     662,  24066,  24067,  24068,  24069,  24070,  24071,  24072,
     664,
  // [0x012C,0x0143] -> [ 24088, 24111] # seg 9
  // [0x0144,0x014D] -v # seg 10 at pos 21096
     686,  24112,  24113,  24114,    687,  24115,  24116,  24117,
   24118,    670,
  // [0x016C,0x01CD] -> [ 24148, 24245] # seg 13
  // [0x01CE,0x01DC] -v # seg 14 at pos 21106
     660,  24246,    668,  24247,    672,  24248,    676,  24249,
     678,  24250,    679,  24251,    680,  24252,    681,
  // [0x01FA,0x0250] -> [ 24281, 24367] # seg 17
  // [0x0252,0x0260] -> [ 24368, 24382] # seg 19
  // [0x0262,0x02C6] -> [ 24383, 24483] # seg 21
  // [0x02C7,0x02CB] -v # seg 22 at pos 21121
       5,  24484,      4,  15588,  15589,
  // [0x02DA,0x0390] -> [ 24498, 24680] # seg 25
  // [0x03A2,0x03B0] -v # seg 27 at pos 21126
   24681,    487,    488,    489,    490,    491,    492,    493,
   24682,  24683,  24684,  24685,  24686,  24687,  24688,
  // [0x03C2,0x03C9] -v # seg 29 at pos 21141
   24689,    519,    520,    521,    522,    523,    524,    525,
  // [0x0401,0x0401] -> [   570,   570] # seg 31
  // [0x0410,0x0415] -> [   564,   569] # seg 33
  // [0x0430,0x0435] -> [   612,   617] # seg 35
  // [0x0450,0x0451] -v # seg 37 at pos 21149
   24759,    618,
  // [0x2010,0x2026] -v # seg 39 at pos 21151
   15712,  31862,  31863,  15591,      9,  15592,     11,  31864,
      13,     14,  31865,  31866,     15,     16,  31867,  31868,
   31869,  31870,  31871,  31872,  31873,  15593,     12,
  // [0x2030,0x203B] -v # seg 41 at pos 21174
      74,  31883,     67,     68,  31884,  15594,  31885,  31886,
   31887,  31888,  31889,     88,
  // [0x20AC,0x20AC] -> [   160,   160] # seg 43
  // [0x2103,0x2109] -v # seg 45 at pos 21186
      69,  32088,  15595,  32089,  32090,  32091,  15596,
  // [0x2116,0x2116] -> [    76,    76] # seg 47
  // [0x2121,0x2121] -> [ 15709, 15709] # seg 49
  // [0x2160,0x216B] -> [   174,   185] # seg 51
  // [0x2170,0x2179] -> [    94,   103] # seg 53
  // [0x2190,0x2199] -v # seg 55 at pos 21193
      90,     91,     89,     92,  32202,  32203,  15597,  15598,
   15599,  15600,
  // [0x2208,0x223D] -v # seg 57 at pos 21203
      41,  32314,  32315,  32316,  32317,  32318,  32319,     38,
   32320,     37,  32321,  32322,  32323,  15601,  32324,  32325,
   32326,  32327,     43,  32328,  32329,     55,     61,  15602,
      46,  32330,  32331,  15603,  32332,     45,  32333,     35,
      36,     40,     39,     49,  32334,  32335,     50,  32336,
   32337,  32338,  32339,  32340,     63,     62,     34,     42,
   32341,  32342,  32343,  32344,  32345,     54,
  // [0x2248,0x2252] -v # seg 59 at pos 21257
      53,  32356,  32357,  32358,     52,  32359,  32360,  32361,
   32362,  32363,  15604,
  // [0x2260,0x226F] -v # seg 61 at pos 21268
      56,     51,  32377,  32378,     59,     60,  15605,  15606,
   32379,  32380,  32381,  32382,  32383,  32384,     57,     58,
  // [0x2295,0x2299] -v # seg 63 at pos 21284
   15669,  32422,  32423,  32424,     48,
  // [0x22A5,0x22A5] -> [    44,    44] # seg 65
  // [0x22BF,0x22BF] -> [ 15607, 15607] # seg 67
  // [0x2312,0x2312] -> [    47,    47] # seg 69
  // [0x2460,0x2469] -> [   150,   159] # seg 71
  // [0x2474,0x2487] -> [   130,   149] # seg 73
  // [0x249C,0x24FF] -> [ 32886, 32985] # seg 75
  // [0x254C,0x254F] -> [ 32986, 32989] # seg 77
  // [0x2574,0x2580] -> [ 32990, 33002] # seg 79
  // [0x2590,0x2595] -v # seg 81 at pos 21289
   33003,  33004,  33005,  15659,  15660,  15661,
  // [0x25A0,0x25A1] -v # seg 83 at pos 21295
      85,     84,
  // [0x25B2,0x25CF] -v # seg 85 at pos 21297
      87,     86,  33032,  33033,  33034,  33035,  33036,  33037,
   33038,  33039,  15662,  15663,  33040,  33041,  33042,  33043,
   33044,  33045,  33046,  33047,     83,     82,  33048,  33049,
   33050,     79,  33051,  33052,     81,     80,
  // [0x25E2,0x25E5] -> [ 15664, 15667] # seg 87
  // [0x2605,0x2609] -v # seg 89 at pos 21327
      78,     77,  33102,  33103,  15668,
  // [0x2640,0x2642] -v # seg 91 at pos 21332
      65,  33158,     64,
  // [0x2E81,0x2E8C] -v # seg 93 at pos 21335
   23860,  35269,  35270,  23864,  35271,  35272,  35273,  23867,
   35274,  35275,  23868,  23873,
  // [0x2E97,0x2E97] -> [ 23874, 23874] # seg 95
  // [0x2EA7,0x2EBB] -v # seg 97 at pos 21347
   23887,  35301,  35302,  23890,  35303,  35304,  35305,  23893,
   35306,  35307,  35308,  35309,  23895,  35310,  35311,  23896,
   23897,  35312,  35313,  35314,  23901,
  // [0x2ECA,0x2ECA] -> [ 23911, 23911] # seg 99
  // [0x2FF0,0x2FFB] -> [ 15757, 15768] # seg 101
  // [0x3020,0x3020] -> [ 35633, 35633] # seg 104
  // [0x3021,0x3029] -> [ 15684, 15692] # seg 105
  // [0x302A,0x303D] -> [ 35634, 35653] # seg 106
  // [0x303E,0x3040] -v # seg 107 at pos 21368
   15756,  35654,  35655,
  // [0x3094,0x30A0] -v # seg 109 at pos 21371
   35656,  35657,  35658,  35659,  35660,  35661,  35662,  15717,
   15718,  15722,  15723,  35663,  35664,
  // [0x30F7,0x3104] -v # seg 111 at pos 21384
   35665,  35666,  35667,  35668,  35669,  15716,  15719,  15720,
   35670,  35671,  35672,  35673,  35674,  35675,
  // [0x3220,0x3229] -> [   162,   171] # seg 114
  // [0x322A,0x3231] -v # seg 115 at pos 21398
   35922,  35923,  35924,  35925,  35926,  35927,  35928,  15710,
  // [0x32A4,0x338D] -> [ 36042, 36275] # seg 118
  // [0x3390,0x339B] -> [ 36276, 36287] # seg 120
  // [0x339C,0x33A1] -v # seg 121 at pos 21406
   15696,  15697,  15698,  36288,  36289,  15699,
  // [0x33C5,0x33CD] -> [ 36324, 36332] # seg 124
  // [0x33CE,0x33D5] -v # seg 125 at pos 21412
   15701,  36333,  36334,  15702,  15703,  36335,  36336,  15704,
  // [0x3448,0x3472] -> [ 36450, 36492] # seg 128
  // [0x3474,0x359D] -> [ 36493, 36790] # seg 130
  // [0x359F,0x360D] -> [ 36791, 36901] # seg 132
  // [0x360F,0x3619] -> [ 36902, 36912] # seg 134
  // [0x361B,0x3917] -> [ 36913, 37677] # seg 136
  // [0x3919,0x396D] -> [ 37678, 37762] # seg 138
  // [0x396F,0x39CE] -> [ 37763, 37858] # seg 140
  // [0x39CF,0x39D0] -v # seg 141 at pos 21420
   23878,  23881,
  // [0x39E0,0x3A72] -> [ 37873, 38019] # seg 144
  // [0x3A74,0x3B4D] -> [ 38020, 38237] # seg 146
  // [0x3B4F,0x3C6D] -> [ 38238, 38524] # seg 148
  // [0x3C6F,0x3CDF] -> [ 38525, 38637] # seg 150
  // [0x3CE1,0x4055] -> [ 38638, 39522] # seg 152
  // [0x4057,0x415E] -> [ 39523, 39786] # seg 154
  // [0x4160,0x4336] -> [ 39787, 40257] # seg 156
  // [0x4338,0x43AB] -> [ 40258, 40373] # seg 158
  // [0x43AC,0x43B1] -v # seg 159 at pos 21422
   23900,  40374,  40375,  40376,  40377,  23899,
  // [0x43DE,0x44D5] -> [ 40421, 40668] # seg 162
  // [0x44D7,0x464B] -> [ 40669, 41041] # seg 164
  // [0x464D,0x4660] -> [ 41042, 41061] # seg 166
  // [0x4662,0x4722] -> [ 41062, 41254] # seg 168
  // [0x4723,0x4729] -v # seg 169 at pos 21428
   23907,  41255,  41256,  41257,  41258,  41259,  23908,
  // [0x477D,0x478C] -> [ 41342, 41357] # seg 172
  // [0x478E,0x4946] -> [ 41358, 41798] # seg 174
  // [0x4948,0x4979] -> [ 41799, 41848] # seg 176
  // [0x497A,0x4986] -v # seg 177 at pos 21435
   23913,  41849,  41850,  23914,  41851,  41852,  41853,  41854,
   23915,  23916,  41855,  23917,  23918,
  // [0x499B,0x499F] -v # seg 179 at pos 21448
   23920,  41876,  41877,  41878,  23919,
  // [0x49B6,0x49B7] -v # seg 181 at pos 21453
   23922,  23921,
  // [0x4C78,0x4C9E] -> [ 42604, 42642] # seg 184
  // [0x4C9F,0x4CA3] -v # seg 185 at pos 21455
   23926,  23927,  23928,  23930,  23925,
  // [0x4D1A,0x4DAD] -> [ 42754, 42901] # seg 188
  // [0x4DAF,0x4DFF] -> [ 42902, 42982] # seg 190
  // [0xA000,0xD7FF] -> [ 43073, 57408] # seg 192
  // [0xE000,0xE233] -> [   846,  1409] # seg 194
  // [0xE234,0xE4C5] -> [  8178,  8835] # seg 195
  // [0xE4C6,0xE765] -> [ 14916, 15587] # seg 196
  // [0xE766,0xE771] -v # seg 197 at pos 21460
     104,    105,    106,    107,    108,    109,  57409,    161,
     172,    173,    186,    187,
  // [0xE772,0xE77C] -> [   365,   375] # seg 198
  // [0xE77D,0xE784] -> [   462,   469] # seg 199
  // [0xE785,0xE78C] -> [   494,   501] # seg 200
  // [0xE78D,0xE796] -v # seg 201 at pos 21472
     526,    527,    528,    529,    530,    531,    532,    545,
     546,    552,
  // [0xE797,0xE79F] -> [   555,   563] # seg 202
  // [0xE7A0,0xE7AE] -> [   597,   611] # seg 203
  // [0xE7AF,0xE7BB] -> [   645,   657] # seg 204
  // [0xE7BC,0xE7C6] -> [ 15673, 15683] # seg 205
  // [0xE7C7,0xE7CC] -v # seg 206 at pos 21482
     685,  57410,    690,    691,    692,    693,
  // [0xE7CD,0xE7E1] -> [   731,   751] # seg 207
  // [0xE7E2,0xE7E6] -v # seg 208 at pos 21488
   15708,  15711,  15713,  15714,  15715,
  // [0xE7E7,0xE7F3] -> [ 57411, 57423] # seg 209
  // [0xE7F4,0xE7FD] -> [ 15770, 15779] # seg 210
  // [0xE7FE,0xE800] -> [   752,   754] # seg 211
  // [0xE801,0xE80F] -> [   831,   845] # seg 212
  // [0xE810,0xE843] -v # seg 213 at pos 21493
    5165,   5166,   5167,   5168,   5169,  57424,  23861,  23862,
   23863,  57425,  57426,  57427,  57428,  57429,  23869,  57430,
   57431,  57432,  57433,  57434,  57435,  57436,  23877,  57437,
   57438,  57439,  57440,  23882,  23883,  57441,  57442,  57443,
   57444,  23888,  23889,  57445,  57446,  57447,  57448,  57449,
   57450,  57451,  57452,  23898,  57453,  57454,  57455,  57456,
   57457,  57458,  57459,  23906,
  // [0xE844,0xE853] -> [ 57460, 57475] # seg 214
  // [0xE854,0xE855] -> [ 23923, 23924] # seg 215
  // [0xE856,0xE863] -> [ 57476, 57489] # seg 216
  // [0xE864,0xE864] -> [ 23939, 23939] # seg 217
  // [0xE865,0xF92B] -> [ 57490, 61784] # seg 218
  // [0xF92C,0xF92C] -> [ 23839, 23839] # seg 219
  // [0xF92D,0xF978] -> [ 61785, 61860] # seg 220
  // [0xF979,0xF979] -> [ 23840, 23840] # seg 221
  // [0xF97A,0xF994] -> [ 61861, 61887] # seg 222
  // [0xF995,0xF995] -> [ 23841, 23841] # seg 223
  // [0xF996,0xF9E6] -> [ 61888, 61968] # seg 224
  // [0xF9E7,0xF9E7] -> [ 23842, 23842] # seg 225
  // [0xF9E8,0xF9F0] -> [ 61969, 61977] # seg 226
  // [0xF9F1,0xF9F1] -> [ 23843, 23843] # seg 227
  // [0xF9F2,0xFA0B] -> [ 61978, 62003] # seg 228
  // [0xFA0C,0xFA29] -v # seg 229 at pos 21545
   23844,  23845,  23846,  23847,  62004,  23848,  62005,  23849,
   23850,  62006,  62007,  62008,  23851,  62009,  62010,  62011,
   62012,  62013,  62014,  23852,  23853,  23854,  62015,  23855,
   23856,  62016,  62017,  23857,  23858,  23859,
  // [0xFA2A,0xFE2F] -> [ 62018, 63047] # seg 230
  // [0xFE30,0xFE48] -v # seg 231 at pos 21575
   15705,    551,  63048,    553,    554,    533,    534,    549,
     550,    535,    536,    547,    548,    539,    540,    537,
     538,    541,    542,    543,    544,  63049,  63050,  63051,
   63052,
  // [0xFE49,0xFE52] -> [ 15724, 15733] # seg 232
  // [0xFE53,0xFE58] -v # seg 233 at pos 21600
   63053,  15734,  15735,  15736,  15737,  63054,
  // [0xFE59,0xFE66] -> [ 15738, 15751] # seg 234
  // [0xFE67,0xFE6B] -v # seg 235 at pos 21606
   63055,  15752,  15753,  15754,  15755,
  // [0xFE6C,0xFF00] -> [ 63056, 63204] # seg 236
  // [0xFF01,0xFF04] -v # seg 237 at pos 21611
     188,    189,    190,     70,
  // [0xFF05,0xFF5D] -> [   192,   280] # seg 238
  // [0xFF5E,0xFF5E] -> [    10,    10] # seg 239
  // [0xFF5F,0xFFDF] -> [ 63205, 63333] # seg 240
  // [0xFFE0,0xFFE5] -v # seg 241 at pos 21615
      72,     73,  15706,    281,  15707,    191,
  // [0xFFE6,0xFFFF] -> [ 63334, 63359] # seg 242
};

// Compatibility overlay for GB2312
const unsigned short CodePageGB2312_R[41] = {
  // hot segments (indexes into segment table)
  0,
  // number of segments
  13,
  // segment table
  0x0000, 0x00A2, 0x00A4, 0x2015, 0x2016, 0x2225, 0x2226, 0x22EF,
  0x22F0, 0x301C, 0x301D, 0x30FB, 0x30FC,
  // compressed segments
   RCHAR,     72,  RCHAR,      9,  RCHAR,     11,  RCHAR,     12,
   RCHAR,     10,  RCHAR,      3,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [0x00A2,0x00A3] -> [    72,    73] # seg 1
  // [0x2015,0x2015] -> [     9,     9] # seg 3
  // [0x2225,0x2225] -> [    11,    11] # seg 5
  // [0x22EF,0x22EF] -> [    12,    12] # seg 7
  // [0x301C,0x301C] -> [    10,    10] # seg 9
  // [0x30FB,0x30FB] -> [     3,     3] # seg 11
};

// Compatibility overlay for GBK
const unsigned short CodePageGBK_R[75] = {
  // hot segments (indexes into segment table)
  0,
  // number of segments
  21,
  // segment table
  0x0000, 0x00A2, 0x00A4, 0x1E3F, 0x1E40, 0x2225, 0x2226, 0x22EF,
  0x22F0, 0x301C, 0x301D, 0x30FB, 0x30FC, 0x9FB4, 0x9FBC, 0xE7C7,
  0xE7C9, 0xE7E7, 0xE7F4, 0xE815, 0xE865,
  // compressed segments
   RCHAR,     72,  RCHAR,    685,  RCHAR,     11,  RCHAR,     12,
   RCHAR,     10,  RCHAR,      3,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  15756,  RCHAR,  23860,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,      0,  RCHAR,      8,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  // [0x00A2,0x00A3] -> [    72,    73] # seg 1
  // [0x1E3F,0x1E3F] -> [   685,   685] # seg 3
  // [0x2225,0x2225] -> [    11,    11] # seg 5
  // [0x22EF,0x22EF] -> [    12,    12] # seg 7
  // [0x301C,0x301C] -> [    10,    10] # seg 9
  // [0x30FB,0x30FB] -> [     3,     3] # seg 11
  // [0x9FB4,0x9FBB] -v # seg 13 at pos 0
   23869,  23877,  23882,  23883,  23889,  23906,  23923,  23939,
  // [0xE7C7,0xE7C8] -v # seg 15 at pos 8
     685,    688,
  // [0xE7E7,0xE7F3] -> [ 15756, 15768] # seg 17
  // [0xE815,0xE864] -> [ 23860, 23939] # seg 19
};

// Japanese JIS X 0208, plus CP932 compatibility
const unsigned short CodePageJISX0208[7939] = {
  // hot segments (indexes into segment table)
  2, 0, 9,
  // number of segments
  20,
  // segment table
       0,    690,   1128,   1148,   1158,   1159,   1182,   1190,
    1220,   1410,   7808,   8272,   8634,   8644,   8648,   8836,
   10716,  10726,  10736,  11104,
  // compressed segments
   RCHAR,  RCHAR, 0x2460, 0x2160,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2170,  RCHAR,  RCHAR, 0xE000,
  0x2170, 0x2160,  RCHAR,  RCHAR,
  // uncompressed segments
  0x0000,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x1BB0,  RCHAR, 0x1BC7,
   RCHAR, 0x02B2,  RCHAR, 0x1BE5,  RCHAR, 0x1D4F,  RCHAR,  RCHAR,
   RCHAR,  RCHAR, 0x1D53,  RCHAR,
  // [     0,   689] -v # seg 0 at pos 0
  0x3000, 0x3001, 0x3002, 0xFF0C, 0xFF0E, 0x30FB, 0xFF1A, 0xFF1B,
  0xFF1F, 0xFF01, 0x309B, 0x309C, 0x00B4, 0xFF40, 0x00A8, 0xFF3E,
  0xFFE3, 0xFF3F, 0x30FD, 0x30FE, 0x309D, 0x309E, 0x3003, 0x4EDD,
  0x3005, 0x3006, 0x3007, 0x30FC, 0x2015, 0x2010, 0xFF0F, 0xFF3C,
  0x301C, 0x2016, 0xFF5C, 0x2026, 0x2025, 0x2018, 0x2019, 0x201C,
  0x201D, 0xFF08, 0xFF09, 0x3014, 0x3015, 0xFF3B, 0xFF3D, 0xFF5B,
  0xFF5D, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D, 0x300E,
  0x300F, 0x3010, 0x3011, 0xFF0B, 0x2212, 0x00B1, 0x00D7, 0x00F7,
  0xFF1D, 0x2260, 0xFF1C, 0xFF1E, 0x2266, 0x2267, 0x221E, 0x2234,
  0x2642, 0x2640, 0x00B0, 0x2032, 0x2033, 0x2103, 0xFFE5, 0xFF04,
  0x00A2, 0x00A3, 0xFF05, 0xFF03, 0xFF06, 0xFF0A, 0xFF20, 0x00A7,
  0x2606, 0x2605, 0x25CB, 0x25CF, 0x25CE, 0x25C7, 0x25C6, 0x25A1,
  0x25A0, 0x25B3, 0x25B2, 0x25BD, 0x25BC, 0x203B, 0x3012, 0x2192,
  0x2190, 0x2191, 0x2193, 0x3013,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2208,
  0x220B, 0x2286, 0x2287, 0x2282, 0x2283, 0x222A, 0x2229,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x2227,
  0x2228, 0x00AC, 0x21D2, 0x21D4, 0x2200, 0x2203,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR, 0x2220, 0x22A5, 0x2312, 0x2202, 0x2207, 0x2261, 0x2252,
  0x226A, 0x226B, 0x221A, 0x223D, 0x221D, 0x2235, 0x222B, 0x222C,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x212B,
  0x2030, 0x266F, 0x266D, 0x266A, 0x2020, 0x2021, 0x00B6,  RCHAR,
   RCHAR,  RCHAR,  RCHAR, 0x25EF,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR, 0xFF10, 0xFF11, 0xFF12, 0xFF13, 0xFF14,
  0xFF15, 0xFF16, 0xFF17, 0xFF18, 0xFF19,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR, 0xFF21, 0xFF22, 0xFF23, 0xFF24,
  0xFF25, 0xFF26, 0xFF27, 0xFF28, 0xFF29, 0xFF2A, 0xFF2B, 0xFF2C,
  0xFF2D, 0xFF2E, 0xFF2F, 0xFF30, 0xFF31, 0xFF32, 0xFF33, 0xFF34,
  0xFF35, 0xFF36, 0xFF37, 0xFF38, 0xFF39, 0xFF3A,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR, 0xFF41, 0xFF42, 0xFF43, 0xFF44,
  0xFF45, 0xFF46, 0xFF47, 0xFF48, 0xFF49, 0xFF4A, 0xFF4B, 0xFF4C,
  0xFF4D, 0xFF4E, 0xFF4F, 0xFF50, 0xFF51, 0xFF52, 0xFF53, 0xFF54,
  0xFF55, 0xFF56, 0xFF57, 0xFF58, 0xFF59, 0xFF5A,  RCHAR,  RCHAR,
   RCHAR,  RCHAR, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046,
  0x3047, 0x3048, 0x3049, 0x304A, 0x304B, 0x304C, 0x304D, 0x304E,
  0x304F, 0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056,
  0x3057, 0x3058, 0x3059, 0x305A, 0x305B, 0x305C, 0x305D, 0x305E,
  0x305F, 0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066,
  0x3067, 0x3068, 0x3069, 0x306A, 0x306B, 0x306C, 0x306D, 0x306E,
  0x306F, 0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076,
  0x3077, 0x3078, 0x3079, 0x307A, 0x307B, 0x307C, 0x307D, 0x307E,
  0x307F, 0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086,
  0x3087, 0x3088, 0x3089, 0x308A, 0x308B, 0x308C, 0x308D, 0x308E,
  0x308F, 0x3090, 0x3091, 0x3092, 0x3093,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6, 0x30A7, 0x30A8,
  0x30A9, 0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE, 0x30AF, 0x30B0,
  0x30B1, 0x30B2, 0x30B3, 0x30B4, 0x30B5, 0x30B6, 0x30B7, 0x30B8,
  0x30B9, 0x30BA, 0x30BB, 0x30BC, 0x30BD, 0x30BE, 0x30BF, 0x30C0,
  0x30C1, 0x30C2, 0x30C3, 0x30C4, 0x30C5, 0x30C6, 0x30C7, 0x30C8,
  0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE, 0x30CF, 0x30D0,
  0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6, 0x30D7, 0x30D8,
  0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE, 0x30DF, 0x30E0,
  0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6, 0x30E7, 0x30E8,
  0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE, 0x30EF, 0x30F0,
  0x30F1, 0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x0391, 0x0392,
  0x0393, 0x0394, 0x0395, 0x0396, 0x0397, 0x0398, 0x0399, 0x039A,
  0x039B, 0x039C, 0x039D, 0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A3,
  0x03A4, 0x03A5, 0x03A6, 0x03A7, 0x03A8, 0x03A9,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x03B1, 0x03B2,
  0x03B3, 0x03B4, 0x03B5, 0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA,
  0x03BB, 0x03BC, 0x03BD, 0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C3,
  0x03C4, 0x03C5, 0x03C6, 0x03C7, 0x03C8, 0x03C9,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x0410, 0x0411, 0x0412, 0x0413,
  0x0414, 0x0415, 0x0401, 0x0416, 0x0417, 0x0418, 0x0419, 0x041A,
  0x041B, 0x041C, 0x041D, 0x041E, 0x041F, 0x0420, 0x0421, 0x0422,
  0x0423, 0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A,
  0x042B, 0x042C, 0x042D, 0x042E, 0x042F,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x0430, 0x0431, 0x0432, 0x0433,
  0x0434, 0x0435, 0x0451, 0x0436, 0x0437, 0x0438, 0x0439, 0x043A,
  0x043B, 0x043C, 0x043D, 0x043E, 0x043F, 0x0440, 0x0441, 0x0442,
  0x0443, 0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044A,
  0x044B, 0x044C, 0x044D, 0x044E, 0x044F,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR, 0x2500, 0x2502, 0x250C, 0x2510, 0x2518, 0x2514,
  0x251C, 0x252C, 0x2524, 0x2534, 0x253C, 0x2501, 0x2503, 0x250F,
  0x2513, 0x251B, 0x2517, 0x2523, 0x2533, 0x252B, 0x253B, 0x254B,
  0x2520, 0x252F, 0x2528, 0x2537, 0x253F, 0x251D, 0x2530, 0x2525,
  0x2538, 0x2542,
  // [  1128,  1147] -> [0x2460,0x2473] # seg 2
  // [  1148,  1157] -> [0x2160,0x2169] # seg 3
  // [  1410,  7807] -v # seg 9 at pos 690
  0x4E9C, 0x5516, 0x5A03, 0x963F, 0x54C0, 0x611B, 0x6328, 0x59F6,
  0x9022, 0x8475, 0x831C, 0x7A50, 0x60AA, 0x63E1, 0x6E25, 0x65ED,
  0x8466, 0x82A6, 0x9BF5, 0x6893, 0x5727, 0x65A1, 0x6271, 0x5B9B,
  0x59D0, 0x867B, 0x98F4, 0x7D62, 0x7DBE, 0x9B8E, 0x6216, 0x7C9F,
  0x88B7, 0x5B89, 0x5EB5, 0x6309, 0x6697, 0x6848, 0x95C7, 0x978D,
  0x674F, 0x4EE5, 0x4F0A, 0x4F4D, 0x4F9D, 0x5049, 0x56F2, 0x5937,
  0x59D4, 0x5A01, 0x5C09, 0x60DF, 0x610F, 0x6170, 0x6613, 0x6905,
  0x70BA, 0x754F, 0x7570, 0x79FB, 0x7DAD, 0x7DEF, 0x80C3, 0x840E,
  0x8863, 0x8B02, 0x9055, 0x907A, 0x533B, 0x4E95, 0x4EA5, 0x57DF,
  0x80B2, 0x90C1, 0x78EF, 0x4E00, 0x58F1, 0x6EA2, 0x9038, 0x7A32,
  0x8328, 0x828B, 0x9C2F, 0x5141, 0x5370, 0x54BD, 0x54E1, 0x56E0,
  0x59FB, 0x5F15, 0x98F2, 0x6DEB, 0x80E4, 0x852D, 0x9662, 0x9670,
  0x96A0, 0x97FB, 0x540B, 0x53F3, 0x5B87, 0x70CF, 0x7FBD, 0x8FC2,
  0x96E8, 0x536F, 0x9D5C, 0x7ABA, 0x4E11, 0x7893, 0x81FC, 0x6E26,
  0x5618, 0x5504, 0x6B1D, 0x851A, 0x9C3B, 0x59E5, 0x53A9, 0x6D66,
  0x74DC, 0x958F, 0x5642, 0x4E91, 0x904B, 0x96F2, 0x834F, 0x990C,
  0x53E1, 0x55B6, 0x5B30, 0x5F71, 0x6620, 0x66F3, 0x6804, 0x6C38,
  0x6CF3, 0x6D29, 0x745B, 0x76C8, 0x7A4E, 0x9834, 0x82F1, 0x885B,
  0x8A60, 0x92ED, 0x6DB2, 0x75AB, 0x76CA, 0x99C5, 0x60A6, 0x8B01,
  0x8D8A, 0x95B2, 0x698E, 0x53AD, 0x5186, 0x5712, 0x5830, 0x5944,
  0x5BB4, 0x5EF6, 0x6028, 0x63A9, 0x63F4, 0x6CBF, 0x6F14, 0x708E,
  0x7114, 0x7159, 0x71D5, 0x733F, 0x7E01, 0x8276, 0x82D1, 0x8597,
  0x9060, 0x925B, 0x9D1B, 0x5869, 0x65BC, 0x6C5A, 0x7525, 0x51F9,
  0x592E, 0x5965, 0x5F80, 0x5FDC, 0x62BC, 0x65FA, 0x6A2A, 0x6B27,
  0x6BB4, 0x738B, 0x7FC1, 0x8956, 0x9D2C, 0x9D0E, 0x9EC4, 0x5CA1,
  0x6C96, 0x837B, 0x5104, 0x5C4B, 0x61B6, 0x81C6, 0x6876, 0x7261,
  0x4E59, 0x4FFA, 0x5378, 0x6069, 0x6E29, 0x7A4F, 0x97F3, 0x4E0B,
  0x5316, 0x4EEE, 0x4F55, 0x4F3D, 0x4FA1, 0x4F73, 0x52A0, 0x53EF,
  0x5609, 0x590F, 0x5AC1, 0x5BB6, 0x5BE1, 0x79D1, 0x6687, 0x679C,
  0x67B6, 0x6B4C, 0x6CB3, 0x706B, 0x73C2, 0x798D, 0x79BE, 0x7A3C,
  0x7B87, 0x82B1, 0x82DB, 0x8304, 0x8377, 0x83EF, 0x83D3, 0x8766,
  0x8AB2, 0x5629, 0x8CA8, 0x8FE6, 0x904E, 0x971E, 0x868A, 0x4FC4,
  0x5CE8, 0x6211, 0x7259, 0x753B, 0x81E5, 0x82BD, 0x86FE, 0x8CC0,
  0x96C5, 0x9913, 0x99D5, 0x4ECB, 0x4F1A, 0x89E3, 0x56DE, 0x584A,
  0x58CA, 0x5EFB, 0x5FEB, 0x602A, 0x6094, 0x6062, 0x61D0, 0x6212,
  0x62D0, 0x6539, 0x9B41, 0x6666, 0x68B0, 0x6D77, 0x7070, 0x754C,
  0x7686, 0x7D75, 0x82A5, 0x87F9, 0x958B, 0x968E, 0x8C9D, 0x51F1,
  0x52BE, 0x5916, 0x54B3, 0x5BB3, 0x5D16, 0x6168, 0x6982, 0x6DAF,
  0x788D, 0x84CB, 0x8857, 0x8A72, 0x93A7, 0x9AB8, 0x6D6C, 0x99A8,
  0x86D9, 0x57A3, 0x67FF, 0x86CE, 0x920E, 0x5283, 0x5687, 0x5404,
  0x5ED3, 0x62E1, 0x64B9, 0x683C, 0x6838, 0x6BBB, 0x7372, 0x78BA,
  0x7A6B, 0x899A, 0x89D2, 0x8D6B, 0x8F03, 0x90ED, 0x95A3, 0x9694,
  0x9769, 0x5B66, 0x5CB3, 0x697D, 0x984D, 0x984E, 0x639B, 0x7B20,
  0x6A2B, 0x6A7F, 0x68B6, 0x9C0D, 0x6F5F, 0x5272, 0x559D, 0x6070,
  0x62EC, 0x6D3B, 0x6E07, 0x6ED1, 0x845B, 0x8910, 0x8F44, 0x4E14,
  0x9C39, 0x53F6, 0x691B, 0x6A3A, 0x9784, 0x682A, 0x515C, 0x7AC3,
  0x84B2, 0x91DC, 0x938C, 0x565B, 0x9D28, 0x6822, 0x8305, 0x8431,
  0x7CA5, 0x5208, 0x82C5, 0x74E6, 0x4E7E, 0x4F83, 0x51A0, 0x5BD2,
  0x520A, 0x52D8, 0x52E7, 0x5DFB, 0x559A, 0x582A, 0x59E6, 0x5B8C,
  0x5B98, 0x5BDB, 0x5E72, 0x5E79, 0x60A3, 0x611F, 0x6163, 0x61BE,
  0x63DB, 0x6562, 0x67D1, 0x6853, 0x68FA, 0x6B3E, 0x6B53, 0x6C57,
  0x6F22, 0x6F97, 0x6F45, 0x74B0, 0x7518, 0x76E3, 0x770B, 0x7AFF,
  0x7BA1, 0x7C21, 0x7DE9, 0x7F36, 0x7FF0, 0x809D, 0x8266, 0x839E,
  0x89B3, 0x8ACC, 0x8CAB, 0x9084, 0x9451, 0x9593, 0x9591, 0x95A2,
  0x9665, 0x97D3, 0x9928, 0x8218, 0x4E38, 0x542B, 0x5CB8, 0x5DCC,
  0x73A9, 0x764C, 0x773C, 0x5CA9, 0x7FEB, 0x8D0B, 0x96C1, 0x9811,
  0x9854, 0x9858, 0x4F01, 0x4F0E, 0x5371, 0x559C, 0x5668, 0x57FA,
  0x5947, 0x5B09, 0x5BC4, 0x5C90, 0x5E0C, 0x5E7E, 0x5FCC, 0x63EE,
  0x673A, 0x65D7, 0x65E2, 0x671F, 0x68CB, 0x68C4, 0x6A5F, 0x5E30,
  0x6BC5, 0x6C17, 0x6C7D, 0x757F, 0x7948, 0x5B63, 0x7A00, 0x7D00,
  0x5FBD, 0x898F, 0x8A18, 0x8CB4, 0x8D77, 0x8ECC, 0x8F1D, 0x98E2,
  0x9A0E, 0x9B3C, 0x4E80, 0x507D, 0x5100, 0x5993, 0x5B9C, 0x622F,
  0x6280, 0x64EC, 0x6B3A, 0x72A0, 0x7591, 0x7947, 0x7FA9, 0x87FB,
  0x8ABC, 0x8B70, 0x63AC, 0x83CA, 0x97A0, 0x5409, 0x5403, 0x55AB,
  0x6854, 0x6A58, 0x8A70, 0x7827, 0x6775, 0x9ECD, 0x5374, 0x5BA2,
  0x811A, 0x8650, 0x9006, 0x4E18, 0x4E45, 0x4EC7, 0x4F11, 0x53CA,
  0x5438, 0x5BAE, 0x5F13, 0x6025, 0x6551, 0x673D, 0x6C42, 0x6C72,
  0x6CE3, 0x7078, 0x7403, 0x7A76, 0x7AAE, 0x7B08, 0x7D1A, 0x7CFE,
  0x7D66, 0x65E7, 0x725B, 0x53BB, 0x5C45, 0x5DE8, 0x62D2, 0x62E0,
  0x6319, 0x6E20, 0x865A, 0x8A31, 0x8DDD, 0x92F8, 0x6F01, 0x79A6,
  0x9B5A, 0x4EA8, 0x4EAB, 0x4EAC, 0x4F9B, 0x4FA0, 0x50D1, 0x5147,
  0x7AF6, 0x5171, 0x51F6, 0x5354, 0x5321, 0x537F, 0x53EB, 0x55AC,
  0x5883, 0x5CE1, 0x5F37, 0x5F4A, 0x602F, 0x6050, 0x606D, 0x631F,
  0x6559, 0x6A4B, 0x6CC1, 0x72C2, 0x72ED, 0x77EF, 0x80F8, 0x8105,
  0x8208, 0x854E, 0x90F7, 0x93E1, 0x97FF, 0x9957, 0x9A5A, 0x4EF0,
  0x51DD, 0x5C2D, 0x6681, 0x696D, 0x5C40, 0x66F2, 0x6975, 0x7389,
  0x6850, 0x7C81, 0x50C5, 0x52E4, 0x5747, 0x5DFE, 0x9326, 0x65A4,
  0x6B23, 0x6B3D, 0x7434, 0x7981, 0x79BD, 0x7B4B, 0x7DCA, 0x82B9,
  0x83CC, 0x887F, 0x895F, 0x8B39, 0x8FD1, 0x91D1, 0x541F, 0x9280,
  0x4E5D, 0x5036, 0x53E5, 0x533A, 0x72D7, 0x7396, 0x77E9, 0x82E6,
  0x8EAF, 0x99C6, 0x99C8, 0x99D2, 0x5177, 0x611A, 0x865E, 0x55B0,
  0x7A7A, 0x5076, 0x5BD3, 0x9047, 0x9685, 0x4E32, 0x6ADB, 0x91E7,
  0x5C51, 0x5C48, 0x6398, 0x7A9F, 0x6C93, 0x9774, 0x8F61, 0x7AAA,
  0x718A, 0x9688, 0x7C82, 0x6817, 0x7E70, 0x6851, 0x936C, 0x52F2,
  0x541B, 0x85AB, 0x8A13, 0x7FA4, 0x8ECD, 0x90E1, 0x5366, 0x8888,
  0x7941, 0x4FC2, 0x50BE, 0x5211, 0x5144, 0x5553, 0x572D, 0x73EA,
  0x578B, 0x5951, 0x5F62, 0x5F84, 0x6075, 0x6176, 0x6167, 0x61A9,
  0x63B2, 0x643A, 0x656C, 0x666F, 0x6842, 0x6E13, 0x7566, 0x7A3D,
  0x7CFB, 0x7D4C, 0x7D99, 0x7E4B, 0x7F6B, 0x830E, 0x834A, 0x86CD,
  0x8A08, 0x8A63, 0x8B66, 0x8EFD, 0x981A, 0x9D8F, 0x82B8, 0x8FCE,
  0x9BE8, 0x5287, 0x621F, 0x6483, 0x6FC0, 0x9699, 0x6841, 0x5091,
  0x6B20, 0x6C7A, 0x6F54, 0x7A74, 0x7D50, 0x8840, 0x8A23, 0x6708,
  0x4EF6, 0x5039, 0x5026, 0x5065, 0x517C, 0x5238, 0x5263, 0x55A7,
  0x570F, 0x5805, 0x5ACC, 0x5EFA, 0x61B2, 0x61F8, 0x62F3, 0x6372,
  0x691C, 0x6A29, 0x727D, 0x72AC, 0x732E, 0x7814, 0x786F, 0x7D79,
  0x770C, 0x80A9, 0x898B, 0x8B19, 0x8CE2, 0x8ED2, 0x9063, 0x9375,
  0x967A, 0x9855, 0x9A13, 0x9E78, 0x5143, 0x539F, 0x53B3, 0x5E7B,
  0x5F26, 0x6E1B, 0x6E90, 0x7384, 0x73FE, 0x7D43, 0x8237, 0x8A00,
  0x8AFA, 0x9650, 0x4E4E, 0x500B, 0x53E4, 0x547C, 0x56FA, 0x59D1,
  0x5B64, 0x5DF1, 0x5EAB, 0x5F27, 0x6238, 0x6545, 0x67AF, 0x6E56,
  0x72D0, 0x7CCA, 0x88B4, 0x80A1, 0x80E1, 0x83F0, 0x864E, 0x8A87,
  0x8DE8, 0x9237, 0x96C7, 0x9867, 0x9F13, 0x4E94, 0x4E92, 0x4F0D,
  0x5348, 0x5449, 0x543E, 0x5A2F, 0x5F8C, 0x5FA1, 0x609F, 0x68A7,
  0x6A8E, 0x745A, 0x7881, 0x8A9E, 0x8AA4, 0x8B77, 0x9190, 0x4E5E,
  0x9BC9, 0x4EA4, 0x4F7C, 0x4FAF, 0x5019, 0x5016, 0x5149, 0x516C,
  0x529F, 0x52B9, 0x52FE, 0x539A, 0x53E3, 0x5411, 0x540E, 0x5589,
  0x5751, 0x57A2, 0x597D, 0x5B54, 0x5B5D, 0x5B8F, 0x5DE5, 0x5DE7,
  0x5DF7, 0x5E78, 0x5E83, 0x5E9A, 0x5EB7, 0x5F18, 0x6052, 0x614C,
  0x6297, 0x62D8, 0x63A7, 0x653B, 0x6602, 0x6643, 0x66F4, 0x676D,
  0x6821, 0x6897, 0x69CB, 0x6C5F, 0x6D2A, 0x6D69, 0x6E2F, 0x6E9D,
  0x7532, 0x7687, 0x786C, 0x7A3F, 0x7CE0, 0x7D05, 0x7D18, 0x7D5E,
  0x7DB1, 0x8015, 0x8003, 0x80AF, 0x80B1, 0x8154, 0x818F, 0x822A,
  0x8352, 0x884C, 0x8861, 0x8B1B, 0x8CA2, 0x8CFC, 0x90CA, 0x9175,
  0x9271, 0x783F, 0x92FC, 0x95A4, 0x964D, 0x9805, 0x9999, 0x9AD8,
  0x9D3B, 0x525B, 0x52AB, 0x53F7, 0x5408, 0x58D5, 0x62F7, 0x6FE0,
  0x8C6A, 0x8F5F, 0x9EB9, 0x514B, 0x523B, 0x544A, 0x56FD, 0x7A40,
  0x9177, 0x9D60, 0x9ED2, 0x7344, 0x6F09, 0x8170, 0x7511, 0x5FFD,
  0x60DA, 0x9AA8, 0x72DB, 0x8FBC, 0x6B64, 0x9803, 0x4ECA, 0x56F0,
  0x5764, 0x58BE, 0x5A5A, 0x6068, 0x61C7, 0x660F, 0x6606, 0x6839,
  0x68B1, 0x6DF7, 0x75D5, 0x7D3A, 0x826E, 0x9B42, 0x4E9B, 0x4F50,
  0x53C9, 0x5506, 0x5D6F, 0x5DE6, 0x5DEE, 0x67FB, 0x6C99, 0x7473,
  0x7802, 0x8A50, 0x9396, 0x88DF, 0x5750, 0x5EA7, 0x632B, 0x50B5,
  0x50AC, 0x518D, 0x6700, 0x54C9, 0x585E, 0x59BB, 0x5BB0, 0x5F69,
  0x624D, 0x63A1, 0x683D, 0x6B73, 0x6E08, 0x707D, 0x91C7, 0x7280,
  0x7815, 0x7826, 0x796D, 0x658E, 0x7D30, 0x83DC, 0x88C1, 0x8F09,
  0x969B, 0x5264, 0x5728, 0x6750, 0x7F6A, 0x8CA1, 0x51B4, 0x5742,
  0x962A, 0x583A, 0x698A, 0x80B4, 0x54B2, 0x5D0E, 0x57FC, 0x7895,
  0x9DFA, 0x4F5C, 0x524A, 0x548B, 0x643E, 0x6628, 0x6714, 0x67F5,
  0x7A84, 0x7B56, 0x7D22, 0x932F, 0x685C, 0x9BAD, 0x7B39, 0x5319,
  0x518A, 0x5237, 0x5BDF, 0x62F6, 0x64AE, 0x64E6, 0x672D, 0x6BBA,
  0x85A9, 0x96D1, 0x7690, 0x9BD6, 0x634C, 0x9306, 0x9BAB, 0x76BF,
  0x6652, 0x4E09, 0x5098, 0x53C2, 0x5C71, 0x60E8, 0x6492, 0x6563,
  0x685F, 0x71E6, 0x73CA, 0x7523, 0x7B97, 0x7E82, 0x8695, 0x8B83,
  0x8CDB, 0x9178, 0x9910, 0x65AC, 0x66AB, 0x6B8B, 0x4ED5, 0x4ED4,
  0x4F3A, 0x4F7F, 0x523A, 0x53F8, 0x53F2, 0x55E3, 0x56DB, 0x58EB,
  0x59CB, 0x59C9, 0x59FF, 0x5B50, 0x5C4D, 0x5E02, 0x5E2B, 0x5FD7,
  0x601D, 0x6307, 0x652F, 0x5B5C, 0x65AF, 0x65BD, 0x65E8, 0x679D,
  0x6B62, 0x6B7B, 0x6C0F, 0x7345, 0x7949, 0x79C1, 0x7CF8, 0x7D19,
  0x7D2B, 0x80A2, 0x8102, 0x81F3, 0x8996, 0x8A5E, 0x8A69, 0x8A66,
  0x8A8C, 0x8AEE, 0x8CC7, 0x8CDC, 0x96CC, 0x98FC, 0x6B6F, 0x4E8B,
  0x4F3C, 0x4F8D, 0x5150, 0x5B57, 0x5BFA, 0x6148, 0x6301, 0x6642,
  0x6B21, 0x6ECB, 0x6CBB, 0x723E, 0x74BD, 0x75D4, 0x78C1, 0x793A,
  0x800C, 0x8033, 0x81EA, 0x8494, 0x8F9E, 0x6C50, 0x9E7F, 0x5F0F,
  0x8B58, 0x9D2B, 0x7AFA, 0x8EF8, 0x5B8D, 0x96EB, 0x4E03, 0x53F1,
  0x57F7, 0x5931, 0x5AC9, 0x5BA4, 0x6089, 0x6E7F, 0x6F06, 0x75BE,
  0x8CEA, 0x5B9F, 0x8500, 0x7BE0, 0x5072, 0x67F4, 0x829D, 0x5C61,
  0x854A, 0x7E1E, 0x820E, 0x5199, 0x5C04, 0x6368, 0x8D66, 0x659C,
  0x716E, 0x793E, 0x7D17, 0x8005, 0x8B1D, 0x8ECA, 0x906E, 0x86C7,
  0x90AA, 0x501F, 0x52FA, 0x5C3A, 0x6753, 0x707C, 0x7235, 0x914C,
  0x91C8, 0x932B, 0x82E5, 0x5BC2, 0x5F31, 0x60F9, 0x4E3B, 0x53D6,
  0x5B88, 0x624B, 0x6731, 0x6B8A, 0x72E9, 0x73E0, 0x7A2E, 0x816B,
  0x8DA3, 0x9152, 0x9996, 0x5112, 0x53D7, 0x546A, 0x5BFF, 0x6388,
  0x6A39, 0x7DAC, 0x9700, 0x56DA, 0x53CE, 0x5468, 0x5B97, 0x5C31,
  0x5DDE, 0x4FEE, 0x6101, 0x62FE, 0x6D32, 0x79C0, 0x79CB, 0x7D42,
  0x7E4D, 0x7FD2, 0x81ED, 0x821F, 0x8490, 0x8846, 0x8972, 0x8B90,
  0x8E74, 0x8F2F, 0x9031, 0x914B, 0x916C, 0x96C6, 0x919C, 0x4EC0,
  0x4F4F, 0x5145, 0x5341, 0x5F93, 0x620E, 0x67D4, 0x6C41, 0x6E0B,
  0x7363, 0x7E26, 0x91CD, 0x9283, 0x53D4, 0x5919, 0x5BBF, 0x6DD1,
  0x795D, 0x7E2E, 0x7C9B, 0x587E, 0x719F, 0x51FA, 0x8853, 0x8FF0,
  0x4FCA, 0x5CFB, 0x6625, 0x77AC, 0x7AE3, 0x821C, 0x99FF, 0x51C6,
  0x5FAA, 0x65EC, 0x696F, 0x6B89, 0x6DF3, 0x6E96, 0x6F64, 0x76FE,
  0x7D14, 0x5DE1, 0x9075, 0x9187, 0x9806, 0x51E6, 0x521D, 0x6240,
  0x6691, 0x66D9, 0x6E1A, 0x5EB6, 0x7DD2, 0x7F72, 0x66F8, 0x85AF,
  0x85F7, 0x8AF8, 0x52A9, 0x53D9, 0x5973, 0x5E8F, 0x5F90, 0x6055,
  0x92E4, 0x9664, 0x50B7, 0x511F, 0x52DD, 0x5320, 0x5347, 0x53EC,
  0x54E8, 0x5546, 0x5531, 0x5617, 0x5968, 0x59BE, 0x5A3C, 0x5BB5,
  0x5C06, 0x5C0F, 0x5C11, 0x5C1A, 0x5E84, 0x5E8A, 0x5EE0, 0x5F70,
  0x627F, 0x6284, 0x62DB, 0x638C, 0x6377, 0x6607, 0x660C, 0x662D,
  0x6676, 0x677E, 0x68A2, 0x6A1F, 0x6A35, 0x6CBC, 0x6D88, 0x6E09,
  0x6E58, 0x713C, 0x7126, 0x7167, 0x75C7, 0x7701, 0x785D, 0x7901,
  0x7965, 0x79F0, 0x7AE0, 0x7B11, 0x7CA7, 0x7D39, 0x8096, 0x83D6,
  0x848B, 0x8549, 0x885D, 0x88F3, 0x8A1F, 0x8A3C, 0x8A54, 0x8A73,
  0x8C61, 0x8CDE, 0x91A4, 0x9266, 0x937E, 0x9418, 0x969C, 0x9798,
  0x4E0A, 0x4E08, 0x4E1E, 0x4E57, 0x5197, 0x5270, 0x57CE, 0x5834,
  0x58CC, 0x5B22, 0x5E38, 0x60C5, 0x64FE, 0x6761, 0x6756, 0x6D44,
  0x72B6, 0x7573, 0x7A63, 0x84B8, 0x8B72, 0x91B8, 0x9320, 0x5631,
  0x57F4, 0x98FE, 0x62ED, 0x690D, 0x6B96, 0x71ED, 0x7E54, 0x8077,
  0x8272, 0x89E6, 0x98DF, 0x8755, 0x8FB1, 0x5C3B, 0x4F38, 0x4FE1,
  0x4FB5, 0x5507, 0x5A20, 0x5BDD, 0x5BE9, 0x5FC3, 0x614E, 0x632F,
  0x65B0, 0x664B, 0x68EE, 0x699B, 0x6D78, 0x6DF1, 0x7533, 0x75B9,
  0x771F, 0x795E, 0x79E6, 0x7D33, 0x81E3, 0x82AF, 0x85AA, 0x89AA,
  0x8A3A, 0x8EAB, 0x8F9B, 0x9032, 0x91DD, 0x9707, 0x4EBA, 0x4EC1,
  0x5203, 0x5875, 0x58EC, 0x5C0B, 0x751A, 0x5C3D, 0x814E, 0x8A0A,
  0x8FC5, 0x9663, 0x976D, 0x7B25, 0x8ACF, 0x9808, 0x9162, 0x56F3,
  0x53A8, 0x9017, 0x5439, 0x5782, 0x5E25, 0x63A8, 0x6C34, 0x708A,
  0x7761, 0x7C8B, 0x7FE0, 0x8870, 0x9042, 0x9154, 0x9310, 0x9318,
  0x968F, 0x745E, 0x9AC4, 0x5D07, 0x5D69, 0x6570, 0x67A2, 0x8DA8,
  0x96DB, 0x636E, 0x6749, 0x6919, 0x83C5, 0x9817, 0x96C0, 0x88FE,
  0x6F84, 0x647A, 0x5BF8, 0x4E16, 0x702C, 0x755D, 0x662F, 0x51C4,
  0x5236, 0x52E2, 0x59D3, 0x5F81, 0x6027, 0x6210, 0x653F, 0x6574,
  0x661F, 0x6674, 0x68F2, 0x6816, 0x6B63, 0x6E05, 0x7272, 0x751F,
  0x76DB, 0x7CBE, 0x8056, 0x58F0, 0x88FD, 0x897F, 0x8AA0, 0x8A93,
  0x8ACB, 0x901D, 0x9192, 0x9752, 0x9759, 0x6589, 0x7A0E, 0x8106,
  0x96BB, 0x5E2D, 0x60DC, 0x621A, 0x65A5, 0x6614, 0x6790, 0x77F3,
  0x7A4D, 0x7C4D, 0x7E3E, 0x810A, 0x8CAC, 0x8D64, 0x8DE1, 0x8E5F,
  0x78A9, 0x5207, 0x62D9, 0x63A5, 0x6442, 0x6298, 0x8A2D, 0x7A83,
  0x7BC0, 0x8AAC, 0x96EA, 0x7D76, 0x820C, 0x8749, 0x4ED9, 0x5148,
  0x5343, 0x5360, 0x5BA3, 0x5C02, 0x5C16, 0x5DDD, 0x6226, 0x6247,
  0x64B0, 0x6813, 0x6834, 0x6CC9, 0x6D45, 0x6D17, 0x67D3, 0x6F5C,
  0x714E, 0x717D, 0x65CB, 0x7A7F, 0x7BAD, 0x7DDA, 0x7E4A, 0x7FA8,
  0x817A, 0x821B, 0x8239, 0x85A6, 0x8A6E, 0x8CCE, 0x8DF5, 0x9078,
  0x9077, 0x92AD, 0x9291, 0x9583, 0x9BAE, 0x524D, 0x5584, 0x6F38,
  0x7136, 0x5168, 0x7985, 0x7E55, 0x81B3, 0x7CCE, 0x564C, 0x5851,
  0x5CA8, 0x63AA, 0x66FE, 0x66FD, 0x695A, 0x72D9, 0x758F, 0x758E,
  0x790E, 0x7956, 0x79DF, 0x7C97, 0x7D20, 0x7D44, 0x8607, 0x8A34,
  0x963B, 0x9061, 0x9F20, 0x50E7, 0x5275, 0x53CC, 0x53E2, 0x5009,
  0x55AA, 0x58EE, 0x594F, 0x723D, 0x5B8B, 0x5C64, 0x531D, 0x60E3,
  0x60F3, 0x635C, 0x6383, 0x633F, 0x63BB, 0x64CD, 0x65E9, 0x66F9,
  0x5DE3, 0x69CD, 0x69FD, 0x6F15, 0x71E5, 0x4E89, 0x75E9, 0x76F8,
  0x7A93, 0x7CDF, 0x7DCF, 0x7D9C, 0x8061, 0x8349, 0x8358, 0x846C,
  0x84BC, 0x85FB, 0x88C5, 0x8D70, 0x9001, 0x906D, 0x9397, 0x971C,
  0x9A12, 0x50CF, 0x5897, 0x618E, 0x81D3, 0x8535, 0x8D08, 0x9020,
  0x4FC3, 0x5074, 0x5247, 0x5373, 0x606F, 0x6349, 0x675F, 0x6E2C,
  0x8DB3, 0x901F, 0x4FD7, 0x5C5E, 0x8CCA, 0x65CF, 0x7D9A, 0x5352,
  0x8896, 0x5176, 0x63C3, 0x5B58, 0x5B6B, 0x5C0A, 0x640D, 0x6751,
  0x905C, 0x4ED6, 0x591A, 0x592A, 0x6C70, 0x8A51, 0x553E, 0x5815,
  0x59A5, 0x60F0, 0x6253, 0x67C1, 0x8235, 0x6955, 0x9640, 0x99C4,
  0x9A28, 0x4F53, 0x5806, 0x5BFE, 0x8010, 0x5CB1, 0x5E2F, 0x5F85,
  0x6020, 0x614B, 0x6234, 0x66FF, 0x6CF0, 0x6EDE, 0x80CE, 0x817F,
  0x82D4, 0x888B, 0x8CB8, 0x9000, 0x902E, 0x968A, 0x9EDB, 0x9BDB,
  0x4EE3, 0x53F0, 0x5927, 0x7B2C, 0x918D, 0x984C, 0x9DF9, 0x6EDD,
  0x7027, 0x5353, 0x5544, 0x5B85, 0x6258, 0x629E, 0x62D3, 0x6CA2,
  0x6FEF, 0x7422, 0x8A17, 0x9438, 0x6FC1, 0x8AFE, 0x8338, 0x51E7,
  0x86F8, 0x53EA, 0x53E9, 0x4F46, 0x9054, 0x8FB0, 0x596A, 0x8131,
  0x5DFD, 0x7AEA, 0x8FBF, 0x68DA, 0x8C37, 0x72F8, 0x9C48, 0x6A3D,
  0x8AB0, 0x4E39, 0x5358, 0x5606, 0x5766, 0x62C5, 0x63A2, 0x65E6,
  0x6B4E, 0x6DE1, 0x6E5B, 0x70AD, 0x77ED, 0x7AEF, 0x7BAA, 0x7DBB,
  0x803D, 0x80C6, 0x86CB, 0x8A95, 0x935B, 0x56E3, 0x58C7, 0x5F3E,
  0x65AD, 0x6696, 0x6A80, 0x6BB5, 0x7537, 0x8AC7, 0x5024, 0x77E5,
  0x5730, 0x5F1B, 0x6065, 0x667A, 0x6C60, 0x75F4, 0x7A1A, 0x7F6E,
  0x81F4, 0x8718, 0x9045, 0x99B3, 0x7BC9, 0x755C, 0x7AF9, 0x7B51,
  0x84C4, 0x9010, 0x79E9, 0x7A92, 0x8336, 0x5AE1, 0x7740, 0x4E2D,
  0x4EF2, 0x5B99, 0x5FE0, 0x62BD, 0x663C, 0x67F1, 0x6CE8, 0x866B,
  0x8877, 0x8A3B, 0x914E, 0x92F3, 0x99D0, 0x6A17, 0x7026, 0x732A,
  0x82E7, 0x8457, 0x8CAF, 0x4E01, 0x5146, 0x51CB, 0x558B, 0x5BF5,
  0x5E16, 0x5E33, 0x5E81, 0x5F14, 0x5F35, 0x5F6B, 0x5FB4, 0x61F2,
  0x6311, 0x66A2, 0x671D, 0x6F6E, 0x7252, 0x753A, 0x773A, 0x8074,
  0x8139, 0x8178, 0x8776, 0x8ABF, 0x8ADC, 0x8D85, 0x8DF3, 0x929A,
  0x9577, 0x9802, 0x9CE5, 0x52C5, 0x6357, 0x76F4, 0x6715, 0x6C88,
  0x73CD, 0x8CC3, 0x93AE, 0x9673, 0x6D25, 0x589C, 0x690E, 0x69CC,
  0x8FFD, 0x939A, 0x75DB, 0x901A, 0x585A, 0x6802, 0x63B4, 0x69FB,
  0x4F43, 0x6F2C, 0x67D8, 0x8FBB, 0x8526, 0x7DB4, 0x9354, 0x693F,
  0x6F70, 0x576A, 0x58F7, 0x5B2C, 0x7D2C, 0x722A, 0x540A, 0x91E3,
  0x9DB4, 0x4EAD, 0x4F4E, 0x505C, 0x5075, 0x5243, 0x8C9E, 0x5448,
  0x5824, 0x5B9A, 0x5E1D, 0x5E95, 0x5EAD, 0x5EF7, 0x5F1F, 0x608C,
  0x62B5, 0x633A, 0x63D0, 0x68AF, 0x6C40, 0x7887, 0x798E, 0x7A0B,
  0x7DE0, 0x8247, 0x8A02, 0x8AE6, 0x8E44, 0x9013, 0x90B8, 0x912D,
  0x91D8, 0x9F0E, 0x6CE5, 0x6458, 0x64E2, 0x6575, 0x6EF4, 0x7684,
  0x7B1B, 0x9069, 0x93D1, 0x6EBA, 0x54F2, 0x5FB9, 0x64A4, 0x8F4D,
  0x8FED, 0x9244, 0x5178, 0x586B, 0x5929, 0x5C55, 0x5E97, 0x6DFB,
  0x7E8F, 0x751C, 0x8CBC, 0x8EE2, 0x985B, 0x70B9, 0x4F1D, 0x6BBF,
  0x6FB1, 0x7530, 0x96FB, 0x514E, 0x5410, 0x5835, 0x5857, 0x59AC,
  0x5C60, 0x5F92, 0x6597, 0x675C, 0x6E21, 0x767B, 0x83DF, 0x8CED,
  0x9014, 0x90FD, 0x934D, 0x7825, 0x783A, 0x52AA, 0x5EA6, 0x571F,
  0x5974, 0x6012, 0x5012, 0x515A, 0x51AC, 0x51CD, 0x5200, 0x5510,
  0x5854, 0x5858, 0x5957, 0x5B95, 0x5CF6, 0x5D8B, 0x60BC, 0x6295,
  0x642D, 0x6771, 0x6843, 0x68BC, 0x68DF, 0x76D7, 0x6DD8, 0x6E6F,
  0x6D9B, 0x706F, 0x71C8, 0x5F53, 0x75D8, 0x7977, 0x7B49, 0x7B54,
  0x7B52, 0x7CD6, 0x7D71, 0x5230, 0x8463, 0x8569, 0x85E4, 0x8A0E,
  0x8B04, 0x8C46, 0x8E0F, 0x9003, 0x900F, 0x9419, 0x9676, 0x982D,
  0x9A30, 0x95D8, 0x50CD, 0x52D5, 0x540C, 0x5802, 0x5C0E, 0x61A7,
  0x649E, 0x6D1E, 0x77B3, 0x7AE5, 0x80F4, 0x8404, 0x9053, 0x9285,
  0x5CE0, 0x9D07, 0x533F, 0x5F97, 0x5FB3, 0x6D9C, 0x7279, 0x7763,
  0x79BF, 0x7BE4, 0x6BD2, 0x72EC, 0x8AAD, 0x6803, 0x6A61, 0x51F8,
  0x7A81, 0x6934, 0x5C4A, 0x9CF6, 0x82EB, 0x5BC5, 0x9149, 0x701E,
  0x5678, 0x5C6F, 0x60C7, 0x6566, 0x6C8C, 0x8C5A, 0x9041, 0x9813,
  0x5451, 0x66C7, 0x920D, 0x5948, 0x90A3, 0x5185, 0x4E4D, 0x51EA,
  0x8599, 0x8B0E, 0x7058, 0x637A, 0x934B, 0x6962, 0x99B4, 0x7E04,
  0x7577, 0x5357, 0x6960, 0x8EDF, 0x96E3, 0x6C5D, 0x4E8C, 0x5C3C,
  0x5F10, 0x8FE9, 0x5302, 0x8CD1, 0x8089, 0x8679, 0x5EFF, 0x65E5,
  0x4E73, 0x5165, 0x5982, 0x5C3F, 0x97EE, 0x4EFB, 0x598A, 0x5FCD,
  0x8A8D, 0x6FE1, 0x79B0, 0x7962, 0x5BE7, 0x8471, 0x732B, 0x71B1,
  0x5E74, 0x5FF5, 0x637B, 0x649A, 0x71C3, 0x7C98, 0x4E43, 0x5EFC,
  0x4E4B, 0x57DC, 0x56A2, 0x60A9, 0x6FC3, 0x7D0D, 0x80FD, 0x8133,
  0x81BF, 0x8FB2, 0x8997, 0x86A4, 0x5DF4, 0x628A, 0x64AD, 0x8987,
  0x6777, 0x6CE2, 0x6D3E, 0x7436, 0x7834, 0x5A46, 0x7F75, 0x82AD,
  0x99AC, 0x4FF3, 0x5EC3, 0x62DD, 0x6392, 0x6557, 0x676F, 0x76C3,
  0x724C, 0x80CC, 0x80BA, 0x8F29, 0x914D, 0x500D, 0x57F9, 0x5A92,
  0x6885, 0x6973, 0x7164, 0x72FD, 0x8CB7, 0x58F2, 0x8CE0, 0x966A,
  0x9019, 0x877F, 0x79E4, 0x77E7, 0x8429, 0x4F2F, 0x5265, 0x535A,
  0x62CD, 0x67CF, 0x6CCA, 0x767D, 0x7B94, 0x7C95, 0x8236, 0x8584,
  0x8FEB, 0x66DD, 0x6F20, 0x7206, 0x7E1B, 0x83AB, 0x99C1, 0x9EA6,
  0x51FD, 0x7BB1, 0x7872, 0x7BB8, 0x8087, 0x7B48, 0x6AE8, 0x5E61,
  0x808C, 0x7551, 0x7560, 0x516B, 0x9262, 0x6E8C, 0x767A, 0x9197,
  0x9AEA, 0x4F10, 0x7F70, 0x629C, 0x7B4F, 0x95A5, 0x9CE9, 0x567A,
  0x5859, 0x86E4, 0x96BC, 0x4F34, 0x5224, 0x534A, 0x53CD, 0x53DB,
  0x5E06, 0x642C, 0x6591, 0x677F, 0x6C3E, 0x6C4E, 0x7248, 0x72AF,
  0x73ED, 0x7554, 0x7E41, 0x822C, 0x85E9, 0x8CA9, 0x7BC4, 0x91C6,
  0x7169, 0x9812, 0x98EF, 0x633D, 0x6669, 0x756A, 0x76E4, 0x78D0,
  0x8543, 0x86EE, 0x532A, 0x5351, 0x5426, 0x5983, 0x5E87, 0x5F7C,
  0x60B2, 0x6249, 0x6279, 0x62AB, 0x6590, 0x6BD4, 0x6CCC, 0x75B2,
  0x76AE, 0x7891, 0x79D8, 0x7DCB, 0x7F77, 0x80A5, 0x88AB, 0x8AB9,
  0x8CBB, 0x907F, 0x975E, 0x98DB, 0x6A0B, 0x7C38, 0x5099, 0x5C3E,
  0x5FAE, 0x6787, 0x6BD8, 0x7435, 0x7709, 0x7F8E, 0x9F3B, 0x67CA,
  0x7A17, 0x5339, 0x758B, 0x9AED, 0x5F66, 0x819D, 0x83F1, 0x8098,
  0x5F3C, 0x5FC5, 0x7562, 0x7B46, 0x903C, 0x6867, 0x59EB, 0x5A9B,
  0x7D10, 0x767E, 0x8B2C, 0x4FF5, 0x5F6A, 0x6A19, 0x6C37, 0x6F02,
  0x74E2, 0x7968, 0x8868, 0x8A55, 0x8C79, 0x5EDF, 0x63CF, 0x75C5,
  0x79D2, 0x82D7, 0x9328, 0x92F2, 0x849C, 0x86ED, 0x9C2D, 0x54C1,
  0x5F6C, 0x658C, 0x6D5C, 0x7015, 0x8CA7, 0x8CD3, 0x983B, 0x654F,
  0x74F6, 0x4E0D, 0x4ED8, 0x57E0, 0x592B, 0x5A66, 0x5BCC, 0x51A8,
  0x5E03, 0x5E9C, 0x6016, 0x6276, 0x6577, 0x65A7, 0x666E, 0x6D6E,
  0x7236, 0x7B26, 0x8150, 0x819A, 0x8299, 0x8B5C, 0x8CA0, 0x8CE6,
  0x8D74, 0x961C, 0x9644, 0x4FAE, 0x64AB, 0x6B66, 0x821E, 0x8461,
  0x856A, 0x90E8, 0x5C01, 0x6953, 0x98A8, 0x847A, 0x8557, 0x4F0F,
  0x526F, 0x5FA9, 0x5E45, 0x670D, 0x798F, 0x8179, 0x8907, 0x8986,
  0x6DF5, 0x5F17, 0x6255, 0x6CB8, 0x4ECF, 0x7269, 0x9B92, 0x5206,
  0x543B, 0x5674, 0x58B3, 0x61A4, 0x626E, 0x711A, 0x596E, 0x7C89,
  0x7CDE, 0x7D1B, 0x96F0, 0x6587, 0x805E, 0x4E19, 0x4F75, 0x5175,
  0x5840, 0x5E63, 0x5E73, 0x5F0A, 0x67C4, 0x4E26, 0x853D, 0x9589,
  0x965B, 0x7C73, 0x9801, 0x50FB, 0x58C1, 0x7656, 0x78A7, 0x5225,
  0x77A5, 0x8511, 0x7B86, 0x504F, 0x5909, 0x7247, 0x7BC7, 0x7DE8,
  0x8FBA, 0x8FD4, 0x904D, 0x4FBF, 0x52C9, 0x5A29, 0x5F01, 0x97AD,
  0x4FDD, 0x8217, 0x92EA, 0x5703, 0x6355, 0x6B69, 0x752B, 0x88DC,
  0x8F14, 0x7A42, 0x52DF, 0x5893, 0x6155, 0x620A, 0x66AE, 0x6BCD,
  0x7C3F, 0x83E9, 0x5023, 0x4FF8, 0x5305, 0x5446, 0x5831, 0x5949,
  0x5B9D, 0x5CF0, 0x5CEF, 0x5D29, 0x5E96, 0x62B1, 0x6367, 0x653E,
  0x65B9, 0x670B, 0x6CD5, 0x6CE1, 0x70F9, 0x7832, 0x7E2B, 0x80DE,
  0x82B3, 0x840C, 0x84EC, 0x8702, 0x8912, 0x8A2A, 0x8C4A, 0x90A6,
  0x92D2, 0x98FD, 0x9CF3, 0x9D6C, 0x4E4F, 0x4EA1, 0x508D, 0x5256,
  0x574A, 0x59A8, 0x5E3D, 0x5FD8, 0x5FD9, 0x623F, 0x66B4, 0x671B,
  0x67D0, 0x68D2, 0x5192, 0x7D21, 0x80AA, 0x81A8, 0x8B00, 0x8C8C,
  0x8CBF, 0x927E, 0x9632, 0x5420, 0x982C, 0x5317, 0x50D5, 0x535C,
  0x58A8, 0x64B2, 0x6734, 0x7267, 0x7766, 0x7A46, 0x91E6, 0x52C3,
  0x6CA1, 0x6B86, 0x5800, 0x5E4C, 0x5954, 0x672C, 0x7FFB, 0x51E1,
  0x76C6, 0x6469, 0x78E8, 0x9B54, 0x9EBB, 0x57CB, 0x59B9, 0x6627,
  0x679A, 0x6BCE, 0x54E9, 0x69D9, 0x5E55, 0x819C, 0x6795, 0x9BAA,
  0x67FE, 0x9C52, 0x685D, 0x4EA6, 0x4FE3, 0x53C8, 0x62B9, 0x672B,
  0x6CAB, 0x8FC4, 0x4FAD, 0x7E6D, 0x9EBF, 0x4E07, 0x6162, 0x6E80,
  0x6F2B, 0x8513, 0x5473, 0x672A, 0x9B45, 0x5DF3, 0x7B95, 0x5CAC,
  0x5BC6, 0x871C, 0x6E4A, 0x84D1, 0x7A14, 0x8108, 0x5999, 0x7C8D,
  0x6C11, 0x7720, 0x52D9, 0x5922, 0x7121, 0x725F, 0x77DB, 0x9727,
  0x9D61, 0x690B, 0x5A7F, 0x5A18, 0x51A5, 0x540D, 0x547D, 0x660E,
  0x76DF, 0x8FF7, 0x9298, 0x9CF4, 0x59EA, 0x725D, 0x6EC5, 0x514D,
  0x68C9, 0x7DBF, 0x7DEC, 0x9762, 0x9EBA, 0x6478, 0x6A21, 0x8302,
  0x5984, 0x5B5F, 0x6BDB, 0x731B, 0x76F2, 0x7DB2, 0x8017, 0x8499,
  0x5132, 0x6728, 0x9ED9, 0x76EE, 0x6762, 0x52FF, 0x9905, 0x5C24,
  0x623B, 0x7C7E, 0x8CB0, 0x554F, 0x60B6, 0x7D0B, 0x9580, 0x5301,
  0x4E5F, 0x51B6, 0x591C, 0x723A, 0x8036, 0x91CE, 0x5F25, 0x77E2,
  0x5384, 0x5F79, 0x7D04, 0x85AC, 0x8A33, 0x8E8D, 0x9756, 0x67F3,
  0x85AE, 0x9453, 0x6109, 0x6108, 0x6CB9, 0x7652, 0x8AED, 0x8F38,
  0x552F, 0x4F51, 0x512A, 0x52C7, 0x53CB, 0x5BA5, 0x5E7D, 0x60A0,
  0x6182, 0x63D6, 0x6709, 0x67DA, 0x6E67, 0x6D8C, 0x7336, 0x7337,
  0x7531, 0x7950, 0x88D5, 0x8A98, 0x904A, 0x9091, 0x90F5, 0x96C4,
  0x878D, 0x5915, 0x4E88, 0x4F59, 0x4E0E, 0x8A89, 0x8F3F, 0x9810,
  0x50AD, 0x5E7C, 0x5996, 0x5BB9, 0x5EB8, 0x63DA, 0x63FA, 0x64C1,
  0x66DC, 0x694A, 0x69D8, 0x6D0B, 0x6EB6, 0x7194, 0x7528, 0x7AAF,
  0x7F8A, 0x8000, 0x8449, 0x84C9, 0x8981, 0x8B21, 0x8E0A, 0x9065,
  0x967D, 0x990A, 0x617E, 0x6291, 0x6B32, 0x6C83, 0x6D74, 0x7FCC,
  0x7FFC, 0x6DC0, 0x7F85, 0x87BA, 0x88F8, 0x6765, 0x83B1, 0x983C,
  0x96F7, 0x6D1B, 0x7D61, 0x843D, 0x916A, 0x4E71, 0x5375, 0x5D50,
  0x6B04, 0x6FEB, 0x85CD, 0x862D, 0x89A7, 0x5229, 0x540F, 0x5C65,
  0x674E, 0x68A8, 0x7406, 0x7483, 0x75E2, 0x88CF, 0x88E1, 0x91CC,
  0x96E2, 0x9678, 0x5F8B, 0x7387, 0x7ACB, 0x844E, 0x63A0, 0x7565,
  0x5289, 0x6D41, 0x6E9C, 0x7409, 0x7559, 0x786B, 0x7C92, 0x9686,
  0x7ADC, 0x9F8D, 0x4FB6, 0x616E, 0x65C5, 0x865C, 0x4E86, 0x4EAE,
  0x50DA, 0x4E21, 0x51CC, 0x5BEE, 0x6599, 0x6881, 0x6DBC, 0x731F,
  0x7642, 0x77AD, 0x7A1C, 0x7CE7, 0x826F, 0x8AD2, 0x907C, 0x91CF,
  0x9675, 0x9818, 0x529B, 0x7DD1, 0x502B, 0x5398, 0x6797, 0x6DCB,
  0x71D0, 0x7433, 0x81E8, 0x8F2A, 0x96A3, 0x9C57, 0x9E9F, 0x7460,
  0x5841, 0x6D99, 0x7D2F, 0x985E, 0x4EE4, 0x4F36, 0x4F8B, 0x51B7,
  0x52B1, 0x5DBA, 0x601C, 0x73B2, 0x793C, 0x82D3, 0x9234, 0x96B7,
  0x96F6, 0x970A, 0x9E97, 0x9F62, 0x66A6, 0x6B74, 0x5217, 0x52A3,
  0x70C8, 0x88C2, 0x5EC9, 0x604B, 0x6190, 0x6F23, 0x7149, 0x7C3E,
  0x7DF4, 0x806F, 0x84EE, 0x9023, 0x932C, 0x5442, 0x9B6F, 0x6AD3,
  0x7089, 0x8CC2, 0x8DEF, 0x9732, 0x52B4, 0x5A41, 0x5ECA, 0x5F04,
  0x6717, 0x697C, 0x6994, 0x6D6A, 0x6F0F, 0x7262, 0x72FC, 0x7BED,
  0x8001, 0x807E, 0x874B, 0x90CE, 0x516D, 0x9E93, 0x7984, 0x808B,
  0x9332, 0x8AD6, 0x502D, 0x548C, 0x8A71, 0x6B6A, 0x8CC4, 0x8107,
  0x60D1, 0x67A0, 0x9DF2, 0x4E99, 0x4E98, 0x9C10, 0x8A6B, 0x85C1,
  0x8568, 0x6900, 0x6E7E, 0x7897, 0x8155,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  0x5F0C, 0x4E10, 0x4E15, 0x4E2A, 0x4E31, 0x4E36, 0x4E3C, 0x4E3F,
  0x4E42, 0x4E56, 0x4E58, 0x4E82, 0x4E85, 0x8C6B, 0x4E8A, 0x8212,
  0x5F0D, 0x4E8E, 0x4E9E, 0x4E9F, 0x4EA0, 0x4EA2, 0x4EB0, 0x4EB3,
  0x4EB6, 0x4ECE, 0x4ECD, 0x4EC4, 0x4EC6, 0x4EC2, 0x4ED7, 0x4EDE,
  0x4EED, 0x4EDF, 0x4EF7, 0x4F09, 0x4F5A, 0x4F30, 0x4F5B, 0x4F5D,
  0x4F57, 0x4F47, 0x4F76, 0x4F88, 0x4F8F, 0x4F98, 0x4F7B, 0x4F69,
  0x4F70, 0x4F91, 0x4F6F, 0x4F86, 0x4F96, 0x5118, 0x4FD4, 0x4FDF,
  0x4FCE, 0x4FD8, 0x4FDB, 0x4FD1, 0x4FDA, 0x4FD0, 0x4FE4, 0x4FE5,
  0x501A, 0x5028, 0x5014, 0x502A, 0x5025, 0x5005, 0x4F1C, 0x4FF6,
  0x5021, 0x5029, 0x502C, 0x4FFE, 0x4FEF, 0x5011, 0x5006, 0x5043,
  0x5047, 0x6703, 0x5055, 0x5050, 0x5048, 0x505A, 0x5056, 0x506C,
  0x5078, 0x5080, 0x509A, 0x5085, 0x50B4, 0x50B2, 0x50C9, 0x50CA,
  0x50B3, 0x50C2, 0x50D6, 0x50DE, 0x50E5, 0x50ED, 0x50E3, 0x50EE,
  0x50F9, 0x50F5, 0x5109, 0x5101, 0x5102, 0x5116, 0x5115, 0x5114,
  0x511A, 0x5121, 0x513A, 0x5137, 0x513C, 0x513B, 0x513F, 0x5140,
  0x5152, 0x514C, 0x5154, 0x5162, 0x7AF8, 0x5169, 0x516A, 0x516E,
  0x5180, 0x5182, 0x56D8, 0x518C, 0x5189, 0x518F, 0x5191, 0x5193,
  0x5195, 0x5196, 0x51A4, 0x51A6, 0x51A2, 0x51A9, 0x51AA, 0x51AB,
  0x51B3, 0x51B1, 0x51B2, 0x51B0, 0x51B5, 0x51BD, 0x51C5, 0x51C9,
  0x51DB, 0x51E0, 0x8655, 0x51E9, 0x51ED, 0x51F0, 0x51F5, 0x51FE,
  0x5204, 0x520B, 0x5214, 0x520E, 0x5227, 0x522A, 0x522E, 0x5233,
  0x5239, 0x524F, 0x5244, 0x524B, 0x524C, 0x525E, 0x5254, 0x526A,
  0x5274, 0x5269, 0x5273, 0x527F, 0x527D, 0x528D, 0x5294, 0x5292,
  0x5271, 0x5288, 0x5291, 0x8FA8, 0x8FA7, 0x52AC, 0x52AD, 0x52BC,
  0x52B5, 0x52C1, 0x52CD, 0x52D7, 0x52DE, 0x52E3, 0x52E6, 0x98ED,
  0x52E0, 0x52F3, 0x52F5, 0x52F8, 0x52F9, 0x5306, 0x5308, 0x7538,
  0x530D, 0x5310, 0x530F, 0x5315, 0x531A, 0x5323, 0x532F, 0x5331,
  0x5333, 0x5338, 0x5340, 0x5346, 0x5345, 0x4E17, 0x5349, 0x534D,
  0x51D6, 0x535E, 0x5369, 0x536E, 0x5918, 0x537B, 0x5377, 0x5382,
  0x5396, 0x53A0, 0x53A6, 0x53A5, 0x53AE, 0x53B0, 0x53B6, 0x53C3,
  0x7C12, 0x96D9, 0x53DF, 0x66FC, 0x71EE, 0x53EE, 0x53E8, 0x53ED,
  0x53FA, 0x5401, 0x543D, 0x5440, 0x542C, 0x542D, 0x543C, 0x542E,
  0x5436, 0x5429, 0x541D, 0x544E, 0x548F, 0x5475, 0x548E, 0x545F,
  0x5471, 0x5477, 0x5470, 0x5492, 0x547B, 0x5480, 0x5476, 0x5484,
  0x5490, 0x5486, 0x54C7, 0x54A2, 0x54B8, 0x54A5, 0x54AC, 0x54C4,
  0x54C8, 0x54A8, 0x54AB, 0x54C2, 0x54A4, 0x54BE, 0x54BC, 0x54D8,
  0x54E5, 0x54E6, 0x550F, 0x5514, 0x54FD, 0x54EE, 0x54ED, 0x54FA,
  0x54E2, 0x5539, 0x5540, 0x5563, 0x554C, 0x552E, 0x555C, 0x5545,
  0x5556, 0x5557, 0x5538, 0x5533, 0x555D, 0x5599, 0x5580, 0x54AF,
  0x558A, 0x559F, 0x557B, 0x557E, 0x5598, 0x559E, 0x55AE, 0x557C,
  0x5583, 0x55A9, 0x5587, 0x55A8, 0x55DA, 0x55C5, 0x55DF, 0x55C4,
  0x55DC, 0x55E4, 0x55D4, 0x5614, 0x55F7, 0x5616, 0x55FE, 0x55FD,
  0x561B, 0x55F9, 0x564E, 0x5650, 0x71DF, 0x5634, 0x5636, 0x5632,
  0x5638, 0x566B, 0x5664, 0x562F, 0x566C, 0x566A, 0x5686, 0x5680,
  0x568A, 0x56A0, 0x5694, 0x568F, 0x56A5, 0x56AE, 0x56B6, 0x56B4,
  0x56C2, 0x56BC, 0x56C1, 0x56C3, 0x56C0, 0x56C8, 0x56CE, 0x56D1,
  0x56D3, 0x56D7, 0x56EE, 0x56F9, 0x5700, 0x56FF, 0x5704, 0x5709,
  0x5708, 0x570B, 0x570D, 0x5713, 0x5718, 0x5716, 0x55C7, 0x571C,
  0x5726, 0x5737, 0x5738, 0x574E, 0x573B, 0x5740, 0x574F, 0x5769,
  0x57C0, 0x5788, 0x5761, 0x577F, 0x5789, 0x5793, 0x57A0, 0x57B3,
  0x57A4, 0x57AA, 0x57B0, 0x57C3, 0x57C6, 0x57D4, 0x57D2, 0x57D3,
  0x580A, 0x57D6, 0x57E3, 0x580B, 0x5819, 0x581D, 0x5872, 0x5821,
  0x5862, 0x584B, 0x5870, 0x6BC0, 0x5852, 0x583D, 0x5879, 0x5885,
  0x58B9, 0x589F, 0x58AB, 0x58BA, 0x58DE, 0x58BB, 0x58B8, 0x58AE,
  0x58C5, 0x58D3, 0x58D1, 0x58D7, 0x58D9, 0x58D8, 0x58E5, 0x58DC,
  0x58E4, 0x58DF, 0x58EF, 0x58FA, 0x58F9, 0x58FB, 0x58FC, 0x58FD,
  0x5902, 0x590A, 0x5910, 0x591B, 0x68A6, 0x5925, 0x592C, 0x592D,
  0x5932, 0x5938, 0x593E, 0x7AD2, 0x5955, 0x5950, 0x594E, 0x595A,
  0x5958, 0x5962, 0x5960, 0x5967, 0x596C, 0x5969, 0x5978, 0x5981,
  0x599D, 0x4F5E, 0x4FAB, 0x59A3, 0x59B2, 0x59C6, 0x59E8, 0x59DC,
  0x598D, 0x59D9, 0x59DA, 0x5A25, 0x5A1F, 0x5A11, 0x5A1C, 0x5A09,
  0x5A1A, 0x5A40, 0x5A6C, 0x5A49, 0x5A35, 0x5A36, 0x5A62, 0x5A6A,
  0x5A9A, 0x5ABC, 0x5ABE, 0x5ACB, 0x5AC2, 0x5ABD, 0x5AE3, 0x5AD7,
  0x5AE6, 0x5AE9, 0x5AD6, 0x5AFA, 0x5AFB, 0x5B0C, 0x5B0B, 0x5B16,
  0x5B32, 0x5AD0, 0x5B2A, 0x5B36, 0x5B3E, 0x5B43, 0x5B45, 0x5B40,
  0x5B51, 0x5B55, 0x5B5A, 0x5B5B, 0x5B65, 0x5B69, 0x5B70, 0x5B73,
  0x5B75, 0x5B78, 0x6588, 0x5B7A, 0x5B80, 0x5B83, 0x5BA6, 0x5BB8,
  0x5BC3, 0x5BC7, 0x5BC9, 0x5BD4, 0x5BD0, 0x5BE4, 0x5BE6, 0x5BE2,
  0x5BDE, 0x5BE5, 0x5BEB, 0x5BF0, 0x5BF6, 0x5BF3, 0x5C05, 0x5C07,
  0x5C08, 0x5C0D, 0x5C13, 0x5C20, 0x5C22, 0x5C28, 0x5C38, 0x5C39,
  0x5C41, 0x5C46, 0x5C4E, 0x5C53, 0x5C50, 0x5C4F, 0x5B71, 0x5C6C,
  0x5C6E, 0x4E62, 0x5C76, 0x5C79, 0x5C8C, 0x5C91, 0x5C94, 0x599B,
  0x5CAB, 0x5CBB, 0x5CB6, 0x5CBC, 0x5CB7, 0x5CC5, 0x5CBE, 0x5CC7,
  0x5CD9, 0x5CE9, 0x5CFD, 0x5CFA, 0x5CED, 0x5D8C, 0x5CEA, 0x5D0B,
  0x5D15, 0x5D17, 0x5D5C, 0x5D1F, 0x5D1B, 0x5D11, 0x5D14, 0x5D22,
  0x5D1A, 0x5D19, 0x5D18, 0x5D4C, 0x5D52, 0x5D4E, 0x5D4B, 0x5D6C,
  0x5D73, 0x5D76, 0x5D87, 0x5D84, 0x5D82, 0x5DA2, 0x5D9D, 0x5DAC,
  0x5DAE, 0x5DBD, 0x5D90, 0x5DB7, 0x5DBC, 0x5DC9, 0x5DCD, 0x5DD3,
  0x5DD2, 0x5DD6, 0x5DDB, 0x5DEB, 0x5DF2, 0x5DF5, 0x5E0B, 0x5E1A,
  0x5E19, 0x5E11, 0x5E1B, 0x5E36, 0x5E37, 0x5E44, 0x5E43, 0x5E40,
  0x5E4E, 0x5E57, 0x5E54, 0x5E5F, 0x5E62, 0x5E64, 0x5E47, 0x5E75,
  0x5E76, 0x5E7A, 0x9EBC, 0x5E7F, 0x5EA0, 0x5EC1, 0x5EC2, 0x5EC8,
  0x5ED0, 0x5ECF, 0x5ED6, 0x5EE3, 0x5EDD, 0x5EDA, 0x5EDB, 0x5EE2,
  0x5EE1, 0x5EE8, 0x5EE9, 0x5EEC, 0x5EF1, 0x5EF3, 0x5EF0, 0x5EF4,
  0x5EF8, 0x5EFE, 0x5F03, 0x5F09, 0x5F5D, 0x5F5C, 0x5F0B, 0x5F11,
  0x5F16, 0x5F29, 0x5F2D, 0x5F38, 0x5F41, 0x5F48, 0x5F4C, 0x5F4E,
  0x5F2F, 0x5F51, 0x5F56, 0x5F57, 0x5F59, 0x5F61, 0x5F6D, 0x5F73,
  0x5F77, 0x5F83, 0x5F82, 0x5F7F, 0x5F8A, 0x5F88, 0x5F91, 0x5F87,
  0x5F9E, 0x5F99, 0x5F98, 0x5FA0, 0x5FA8, 0x5FAD, 0x5FBC, 0x5FD6,
  0x5FFB, 0x5FE4, 0x5FF8, 0x5FF1, 0x5FDD, 0x60B3, 0x5FFF, 0x6021,
  0x6060, 0x6019, 0x6010, 0x6029, 0x600E, 0x6031, 0x601B, 0x6015,
  0x602B, 0x6026, 0x600F, 0x603A, 0x605A, 0x6041, 0x606A, 0x6077,
  0x605F, 0x604A, 0x6046, 0x604D, 0x6063, 0x6043, 0x6064, 0x6042,
  0x606C, 0x606B, 0x6059, 0x6081, 0x608D, 0x60E7, 0x6083, 0x609A,
  0x6084, 0x609B, 0x6096, 0x6097, 0x6092, 0x60A7, 0x608B, 0x60E1,
  0x60B8, 0x60E0, 0x60D3, 0x60B4, 0x5FF0, 0x60BD, 0x60C6, 0x60B5,
  0x60D8, 0x614D, 0x6115, 0x6106, 0x60F6, 0x60F7, 0x6100, 0x60F4,
  0x60FA, 0x6103, 0x6121, 0x60FB, 0x60F1, 0x610D, 0x610E, 0x6147,
  0x613E, 0x6128, 0x6127, 0x614A, 0x613F, 0x613C, 0x612C, 0x6134,
  0x613D, 0x6142, 0x6144, 0x6173, 0x6177, 0x6158, 0x6159, 0x615A,
  0x616B, 0x6174, 0x616F, 0x6165, 0x6171, 0x615F, 0x615D, 0x6153,
  0x6175, 0x6199, 0x6196, 0x6187, 0x61AC, 0x6194, 0x619A, 0x618A,
  0x6191, 0x61AB, 0x61AE, 0x61CC, 0x61CA, 0x61C9, 0x61F7, 0x61C8,
  0x61C3, 0x61C6, 0x61BA, 0x61CB, 0x7F79, 0x61CD, 0x61E6, 0x61E3,
  0x61F6, 0x61FA, 0x61F4, 0x61FF, 0x61FD, 0x61FC, 0x61FE, 0x6200,
  0x6208, 0x6209, 0x620D, 0x620C, 0x6214, 0x621B, 0x621E, 0x6221,
  0x622A, 0x622E, 0x6230, 0x6232, 0x6233, 0x6241, 0x624E, 0x625E,
  0x6263, 0x625B, 0x6260, 0x6268, 0x627C, 0x6282, 0x6289, 0x627E,
  0x6292, 0x6293, 0x6296, 0x62D4, 0x6283, 0x6294, 0x62D7, 0x62D1,
  0x62BB, 0x62CF, 0x62FF, 0x62C6, 0x64D4, 0x62C8, 0x62DC, 0x62CC,
  0x62CA, 0x62C2, 0x62C7, 0x629B, 0x62C9, 0x630C, 0x62EE, 0x62F1,
  0x6327, 0x6302, 0x6308, 0x62EF, 0x62F5, 0x6350, 0x633E, 0x634D,
  0x641C, 0x634F, 0x6396, 0x638E, 0x6380, 0x63AB, 0x6376, 0x63A3,
  0x638F, 0x6389, 0x639F, 0x63B5, 0x636B, 0x6369, 0x63BE, 0x63E9,
  0x63C0, 0x63C6, 0x63E3, 0x63C9, 0x63D2, 0x63F6, 0x63C4, 0x6416,
  0x6434, 0x6406, 0x6413, 0x6426, 0x6436, 0x651D, 0x6417, 0x6428,
  0x640F, 0x6467, 0x646F, 0x6476, 0x644E, 0x652A, 0x6495, 0x6493,
  0x64A5, 0x64A9, 0x6488, 0x64BC, 0x64DA, 0x64D2, 0x64C5, 0x64C7,
  0x64BB, 0x64D8, 0x64C2, 0x64F1, 0x64E7, 0x8209, 0x64E0, 0x64E1,
  0x62AC, 0x64E3, 0x64EF, 0x652C, 0x64F6, 0x64F4, 0x64F2, 0x64FA,
  0x6500, 0x64FD, 0x6518, 0x651C, 0x6505, 0x6524, 0x6523, 0x652B,
  0x6534, 0x6535, 0x6537, 0x6536, 0x6538, 0x754B, 0x6548, 0x6556,
  0x6555, 0x654D, 0x6558, 0x655E, 0x655D, 0x6572, 0x6578, 0x6582,
  0x6583, 0x8B8A, 0x659B, 0x659F, 0x65AB, 0x65B7, 0x65C3, 0x65C6,
  0x65C1, 0x65C4, 0x65CC, 0x65D2, 0x65DB, 0x65D9, 0x65E0, 0x65E1,
  0x65F1, 0x6772, 0x660A, 0x6603, 0x65FB, 0x6773, 0x6635, 0x6636,
  0x6634, 0x661C, 0x664F, 0x6644, 0x6649, 0x6641, 0x665E, 0x665D,
  0x6664, 0x6667, 0x6668, 0x665F, 0x6662, 0x6670, 0x6683, 0x6688,
  0x668E, 0x6689, 0x6684, 0x6698, 0x669D, 0x66C1, 0x66B9, 0x66C9,
  0x66BE, 0x66BC, 0x66C4, 0x66B8, 0x66D6, 0x66DA, 0x66E0, 0x663F,
  0x66E6, 0x66E9, 0x66F0, 0x66F5, 0x66F7, 0x670F, 0x6716, 0x671E,
  0x6726, 0x6727, 0x9738, 0x672E, 0x673F, 0x6736, 0x6741, 0x6738,
  0x6737, 0x6746, 0x675E, 0x6760, 0x6759, 0x6763, 0x6764, 0x6789,
  0x6770, 0x67A9, 0x677C, 0x676A, 0x678C, 0x678B, 0x67A6, 0x67A1,
  0x6785, 0x67B7, 0x67EF, 0x67B4, 0x67EC, 0x67B3, 0x67E9, 0x67B8,
  0x67E4, 0x67DE, 0x67DD, 0x67E2, 0x67EE, 0x67B9, 0x67CE, 0x67C6,
  0x67E7, 0x6A9C, 0x681E, 0x6846, 0x6829, 0x6840, 0x684D, 0x6832,
  0x684E, 0x68B3, 0x682B, 0x6859, 0x6863, 0x6877, 0x687F, 0x689F,
  0x688F, 0x68AD, 0x6894, 0x689D, 0x689B, 0x6883, 0x6AAE, 0x68B9,
  0x6874, 0x68B5, 0x68A0, 0x68BA, 0x690F, 0x688D, 0x687E, 0x6901,
  0x68CA, 0x6908, 0x68D8, 0x6922, 0x6926, 0x68E1, 0x690C, 0x68CD,
  0x68D4, 0x68E7, 0x68D5, 0x6936, 0x6912, 0x6904, 0x68D7, 0x68E3,
  0x6925, 0x68F9, 0x68E0, 0x68EF, 0x6928, 0x692A, 0x691A, 0x6923,
  0x6921, 0x68C6, 0x6979, 0x6977, 0x695C, 0x6978, 0x696B, 0x6954,
  0x697E, 0x696E, 0x6939, 0x6974, 0x693D, 0x6959, 0x6930, 0x6961,
  0x695E, 0x695D, 0x6981, 0x696A, 0x69B2, 0x69AE, 0x69D0, 0x69BF,
  0x69C1, 0x69D3, 0x69BE, 0x69CE, 0x5BE8, 0x69CA, 0x69DD, 0x69BB,
  0x69C3, 0x69A7, 0x6A2E, 0x6991, 0x69A0, 0x699C, 0x6995, 0x69B4,
  0x69DE, 0x69E8, 0x6A02, 0x6A1B, 0x69FF, 0x6B0A, 0x69F9, 0x69F2,
  0x69E7, 0x6A05, 0x69B1, 0x6A1E, 0x69ED, 0x6A14, 0x69EB, 0x6A0A,
  0x6A12, 0x6AC1, 0x6A23, 0x6A13, 0x6A44, 0x6A0C, 0x6A72, 0x6A36,
  0x6A78, 0x6A47, 0x6A62, 0x6A59, 0x6A66, 0x6A48, 0x6A38, 0x6A22,
  0x6A90, 0x6A8D, 0x6AA0, 0x6A84, 0x6AA2, 0x6AA3, 0x6A97, 0x8617,
  0x6ABB, 0x6AC3, 0x6AC2, 0x6AB8, 0x6AB3, 0x6AAC, 0x6ADE, 0x6AD1,
  0x6ADF, 0x6AAA, 0x6ADA, 0x6AEA, 0x6AFB, 0x6B05, 0x8616, 0x6AFA,
  0x6B12, 0x6B16, 0x9B31, 0x6B1F, 0x6B38, 0x6B37, 0x76DC, 0x6B39,
  0x98EE, 0x6B47, 0x6B43, 0x6B49, 0x6B50, 0x6B59, 0x6B54, 0x6B5B,
  0x6B5F, 0x6B61, 0x6B78, 0x6B79, 0x6B7F, 0x6B80, 0x6B84, 0x6B83,
  0x6B8D, 0x6B98, 0x6B95, 0x6B9E, 0x6BA4, 0x6BAA, 0x6BAB, 0x6BAF,
  0x6BB2, 0x6BB1, 0x6BB3, 0x6BB7, 0x6BBC, 0x6BC6, 0x6BCB, 0x6BD3,
  0x6BDF, 0x6BEC, 0x6BEB, 0x6BF3, 0x6BEF, 0x9EBE, 0x6C08, 0x6C13,
  0x6C14, 0x6C1B, 0x6C24, 0x6C23, 0x6C5E, 0x6C55, 0x6C62, 0x6C6A,
  0x6C82, 0x6C8D, 0x6C9A, 0x6C81, 0x6C9B, 0x6C7E, 0x6C68, 0x6C73,
  0x6C92, 0x6C90, 0x6CC4, 0x6CF1, 0x6CD3, 0x6CBD, 0x6CD7, 0x6CC5,
  0x6CDD, 0x6CAE, 0x6CB1, 0x6CBE, 0x6CBA, 0x6CDB, 0x6CEF, 0x6CD9,
  0x6CEA, 0x6D1F, 0x884D, 0x6D36, 0x6D2B, 0x6D3D, 0x6D38, 0x6D19,
  0x6D35, 0x6D33, 0x6D12, 0x6D0C, 0x6D63, 0x6D93, 0x6D64, 0x6D5A,
  0x6D79, 0x6D59, 0x6D8E, 0x6D95, 0x6FE4, 0x6D85, 0x6DF9, 0x6E15,
  0x6E0A, 0x6DB5, 0x6DC7, 0x6DE6, 0x6DB8, 0x6DC6, 0x6DEC, 0x6DDE,
  0x6DCC, 0x6DE8, 0x6DD2, 0x6DC5, 0x6DFA, 0x6DD9, 0x6DE4, 0x6DD5,
  0x6DEA, 0x6DEE, 0x6E2D, 0x6E6E, 0x6E2E, 0x6E19, 0x6E72, 0x6E5F,
  0x6E3E, 0x6E23, 0x6E6B, 0x6E2B, 0x6E76, 0x6E4D, 0x6E1F, 0x6E43,
  0x6E3A, 0x6E4E, 0x6E24, 0x6EFF, 0x6E1D, 0x6E38, 0x6E82, 0x6EAA,
  0x6E98, 0x6EC9, 0x6EB7, 0x6ED3, 0x6EBD, 0x6EAF, 0x6EC4, 0x6EB2,
  0x6ED4, 0x6ED5, 0x6E8F, 0x6EA5, 0x6EC2, 0x6E9F, 0x6F41, 0x6F11,
  0x704C, 0x6EEC, 0x6EF8, 0x6EFE, 0x6F3F, 0x6EF2, 0x6F31, 0x6EEF,
  0x6F32, 0x6ECC, 0x6F3E, 0x6F13, 0x6EF7, 0x6F86, 0x6F7A, 0x6F78,
  0x6F81, 0x6F80, 0x6F6F, 0x6F5B, 0x6FF3, 0x6F6D, 0x6F82, 0x6F7C,
  0x6F58, 0x6F8E, 0x6F91, 0x6FC2, 0x6F66, 0x6FB3, 0x6FA3, 0x6FA1,
  0x6FA4, 0x6FB9, 0x6FC6, 0x6FAA, 0x6FDF, 0x6FD5, 0x6FEC, 0x6FD4,
  0x6FD8, 0x6FF1, 0x6FEE, 0x6FDB, 0x7009, 0x700B, 0x6FFA, 0x7011,
  0x7001, 0x700F, 0x6FFE, 0x701B, 0x701A, 0x6F74, 0x701D, 0x7018,
  0x701F, 0x7030, 0x703E, 0x7032, 0x7051, 0x7063, 0x7099, 0x7092,
  0x70AF, 0x70F1, 0x70AC, 0x70B8, 0x70B3, 0x70AE, 0x70DF, 0x70CB,
  0x70DD, 0x70D9, 0x7109, 0x70FD, 0x711C, 0x7119, 0x7165, 0x7155,
  0x7188, 0x7166, 0x7162, 0x714C, 0x7156, 0x716C, 0x718F, 0x71FB,
  0x7184, 0x7195, 0x71A8, 0x71AC, 0x71D7, 0x71B9, 0x71BE, 0x71D2,
  0x71C9, 0x71D4, 0x71CE, 0x71E0, 0x71EC, 0x71E7, 0x71F5, 0x71FC,
  0x71F9, 0x71FF, 0x720D, 0x7210, 0x721B, 0x7228, 0x722D, 0x722C,
  0x7230, 0x7232, 0x723B, 0x723C, 0x723F, 0x7240, 0x7246, 0x724B,
  0x7258, 0x7274, 0x727E, 0x7282, 0x7281, 0x7287, 0x7292, 0x7296,
  0x72A2, 0x72A7, 0x72B9, 0x72B2, 0x72C3, 0x72C6, 0x72C4, 0x72CE,
  0x72D2, 0x72E2, 0x72E0, 0x72E1, 0x72F9, 0x72F7, 0x500F, 0x7317,
  0x730A, 0x731C, 0x7316, 0x731D, 0x7334, 0x732F, 0x7329, 0x7325,
  0x733E, 0x734E, 0x734F, 0x9ED8, 0x7357, 0x736A, 0x7368, 0x7370,
  0x7378, 0x7375, 0x737B, 0x737A, 0x73C8, 0x73B3, 0x73CE, 0x73BB,
  0x73C0, 0x73E5, 0x73EE, 0x73DE, 0x74A2, 0x7405, 0x746F, 0x7425,
  0x73F8, 0x7432, 0x743A, 0x7455, 0x743F, 0x745F, 0x7459, 0x7441,
  0x745C, 0x7469, 0x7470, 0x7463, 0x746A, 0x7476, 0x747E, 0x748B,
  0x749E, 0x74A7, 0x74CA, 0x74CF, 0x74D4, 0x73F1, 0x74E0, 0x74E3,
  0x74E7, 0x74E9, 0x74EE, 0x74F2, 0x74F0, 0x74F1, 0x74F8, 0x74F7,
  0x7504, 0x7503, 0x7505, 0x750C, 0x750E, 0x750D, 0x7515, 0x7513,
  0x751E, 0x7526, 0x752C, 0x753C, 0x7544, 0x754D, 0x754A, 0x7549,
  0x755B, 0x7546, 0x755A, 0x7569, 0x7564, 0x7567, 0x756B, 0x756D,
  0x7578, 0x7576, 0x7586, 0x7587, 0x7574, 0x758A, 0x7589, 0x7582,
  0x7594, 0x759A, 0x759D, 0x75A5, 0x75A3, 0x75C2, 0x75B3, 0x75C3,
  0x75B5, 0x75BD, 0x75B8, 0x75BC, 0x75B1, 0x75CD, 0x75CA, 0x75D2,
  0x75D9, 0x75E3, 0x75DE, 0x75FE, 0x75FF, 0x75FC, 0x7601, 0x75F0,
  0x75FA, 0x75F2, 0x75F3, 0x760B, 0x760D, 0x7609, 0x761F, 0x7627,
  0x7620, 0x7621, 0x7622, 0x7624, 0x7634, 0x7630, 0x763B, 0x7647,
  0x7648, 0x7646, 0x765C, 0x7658, 0x7661, 0x7662, 0x7668, 0x7669,
  0x766A, 0x7667, 0x766C, 0x7670, 0x7672, 0x7676, 0x7678, 0x767C,
  0x7680, 0x7683, 0x7688, 0x768B, 0x768E, 0x7696, 0x7693, 0x7699,
  0x769A, 0x76B0, 0x76B4, 0x76B8, 0x76B9, 0x76BA, 0x76C2, 0x76CD,
  0x76D6, 0x76D2, 0x76DE, 0x76E1, 0x76E5, 0x76E7, 0x76EA, 0x862F,
  0x76FB, 0x7708, 0x7707, 0x7704, 0x7729, 0x7724, 0x771E, 0x7725,
  0x7726, 0x771B, 0x7737, 0x7738, 0x7747, 0x775A, 0x7768, 0x776B,
  0x775B, 0x7765, 0x777F, 0x777E, 0x7779, 0x778E, 0x778B, 0x7791,
  0x77A0, 0x779E, 0x77B0, 0x77B6, 0x77B9, 0x77BF, 0x77BC, 0x77BD,
  0x77BB, 0x77C7, 0x77CD, 0x77D7, 0x77DA, 0x77DC, 0x77E3, 0x77EE,
  0x77FC, 0x780C, 0x7812, 0x7926, 0x7820, 0x792A, 0x7845, 0x788E,
  0x7874, 0x7886, 0x787C, 0x789A, 0x788C, 0x78A3, 0x78B5, 0x78AA,
  0x78AF, 0x78D1, 0x78C6, 0x78CB, 0x78D4, 0x78BE, 0x78BC, 0x78C5,
  0x78CA, 0x78EC, 0x78E7, 0x78DA, 0x78FD, 0x78F4, 0x7907, 0x7912,
  0x7911, 0x7919, 0x792C, 0x792B, 0x7940, 0x7960, 0x7957, 0x795F,
  0x795A, 0x7955, 0x7953, 0x797A, 0x797F, 0x798A, 0x799D, 0x79A7,
  0x9F4B, 0x79AA, 0x79AE, 0x79B3, 0x79B9, 0x79BA, 0x79C9, 0x79D5,
  0x79E7, 0x79EC, 0x79E1, 0x79E3, 0x7A08, 0x7A0D, 0x7A18, 0x7A19,
  0x7A20, 0x7A1F, 0x7980, 0x7A31, 0x7A3B, 0x7A3E, 0x7A37, 0x7A43,
  0x7A57, 0x7A49, 0x7A61, 0x7A62, 0x7A69, 0x9F9D, 0x7A70, 0x7A79,
  0x7A7D, 0x7A88, 0x7A97, 0x7A95, 0x7A98, 0x7A96, 0x7AA9, 0x7AC8,
  0x7AB0, 0x7AB6, 0x7AC5, 0x7AC4, 0x7ABF, 0x9083, 0x7AC7, 0x7ACA,
  0x7ACD, 0x7ACF, 0x7AD5, 0x7AD3, 0x7AD9, 0x7ADA, 0x7ADD, 0x7AE1,
  0x7AE2, 0x7AE6, 0x7AED, 0x7AF0, 0x7B02, 0x7B0F, 0x7B0A, 0x7B06,
  0x7B33, 0x7B18, 0x7B19, 0x7B1E, 0x7B35, 0x7B28, 0x7B36, 0x7B50,
  0x7B7A, 0x7B04, 0x7B4D, 0x7B0B, 0x7B4C, 0x7B45, 0x7B75, 0x7B65,
  0x7B74, 0x7B67, 0x7B70, 0x7B71, 0x7B6C, 0x7B6E, 0x7B9D, 0x7B98,
  0x7B9F, 0x7B8D, 0x7B9C, 0x7B9A, 0x7B8B, 0x7B92, 0x7B8F, 0x7B5D,
  0x7B99, 0x7BCB, 0x7BC1, 0x7BCC, 0x7BCF, 0x7BB4, 0x7BC6, 0x7BDD,
  0x7BE9, 0x7C11, 0x7C14, 0x7BE6, 0x7BE5, 0x7C60, 0x7C00, 0x7C07,
  0x7C13, 0x7BF3, 0x7BF7, 0x7C17, 0x7C0D, 0x7BF6, 0x7C23, 0x7C27,
  0x7C2A, 0x7C1F, 0x7C37, 0x7C2B, 0x7C3D, 0x7C4C, 0x7C43, 0x7C54,
  0x7C4F, 0x7C40, 0x7C50, 0x7C58, 0x7C5F, 0x7C64, 0x7C56, 0x7C65,
  0x7C6C, 0x7C75, 0x7C83, 0x7C90, 0x7CA4, 0x7CAD, 0x7CA2, 0x7CAB,
  0x7CA1, 0x7CA8, 0x7CB3, 0x7CB2, 0x7CB1, 0x7CAE, 0x7CB9, 0x7CBD,
  0x7CC0, 0x7CC5, 0x7CC2, 0x7CD8, 0x7CD2, 0x7CDC, 0x7CE2, 0x9B3B,
  0x7CEF, 0x7CF2, 0x7CF4, 0x7CF6, 0x7CFA, 0x7D06, 0x7D02, 0x7D1C,
  0x7D15, 0x7D0A, 0x7D45, 0x7D4B, 0x7D2E, 0x7D32, 0x7D3F, 0x7D35,
  0x7D46, 0x7D73, 0x7D56, 0x7D4E, 0x7D72, 0x7D68, 0x7D6E, 0x7D4F,
  0x7D63, 0x7D93, 0x7D89, 0x7D5B, 0x7D8F, 0x7D7D, 0x7D9B, 0x7DBA,
  0x7DAE, 0x7DA3, 0x7DB5, 0x7DC7, 0x7DBD, 0x7DAB, 0x7E3D, 0x7DA2,
  0x7DAF, 0x7DDC, 0x7DB8, 0x7D9F, 0x7DB0, 0x7DD8, 0x7DDD, 0x7DE4,
  0x7DDE, 0x7DFB, 0x7DF2, 0x7DE1, 0x7E05, 0x7E0A, 0x7E23, 0x7E21,
  0x7E12, 0x7E31, 0x7E1F, 0x7E09, 0x7E0B, 0x7E22, 0x7E46, 0x7E66,
  0x7E3B, 0x7E35, 0x7E39, 0x7E43, 0x7E37, 0x7E32, 0x7E3A, 0x7E67,
  0x7E5D, 0x7E56, 0x7E5E, 0x7E59, 0x7E5A, 0x7E79, 0x7E6A, 0x7E69,
  0x7E7C, 0x7E7B, 0x7E83, 0x7DD5, 0x7E7D, 0x8FAE, 0x7E7F, 0x7E88,
  0x7E89, 0x7E8C, 0x7E92, 0x7E90, 0x7E93, 0x7E94, 0x7E96, 0x7E8E,
  0x7E9B, 0x7E9C, 0x7F38, 0x7F3A, 0x7F45, 0x7F4C, 0x7F4D, 0x7F4E,
  0x7F50, 0x7F51, 0x7F55, 0x7F54, 0x7F58, 0x7F5F, 0x7F60, 0x7F68,
  0x7F69, 0x7F67, 0x7F78, 0x7F82, 0x7F86, 0x7F83, 0x7F88, 0x7F87,
  0x7F8C, 0x7F94, 0x7F9E, 0x7F9D, 0x7F9A, 0x7FA3, 0x7FAF, 0x7FB2,
  0x7FB9, 0x7FAE, 0x7FB6, 0x7FB8, 0x8B71, 0x7FC5, 0x7FC6, 0x7FCA,
  0x7FD5, 0x7FD4, 0x7FE1, 0x7FE6, 0x7FE9, 0x7FF3, 0x7FF9, 0x98DC,
  0x8006, 0x8004, 0x800B, 0x8012, 0x8018, 0x8019, 0x801C, 0x8021,
  0x8028, 0x803F, 0x803B, 0x804A, 0x8046, 0x8052, 0x8058, 0x805A,
  0x805F, 0x8062, 0x8068, 0x8073, 0x8072, 0x8070, 0x8076, 0x8079,
  0x807D, 0x807F, 0x8084, 0x8086, 0x8085, 0x809B, 0x8093, 0x809A,
  0x80AD, 0x5190, 0x80AC, 0x80DB, 0x80E5, 0x80D9, 0x80DD, 0x80C4,
  0x80DA, 0x80D6, 0x8109, 0x80EF, 0x80F1, 0x811B, 0x8129, 0x8123,
  0x812F, 0x814B, 0x968B, 0x8146, 0x813E, 0x8153, 0x8151, 0x80FC,
  0x8171, 0x816E, 0x8165, 0x8166, 0x8174, 0x8183, 0x8188, 0x818A,
  0x8180, 0x8182, 0x81A0, 0x8195, 0x81A4, 0x81A3, 0x815F, 0x8193,
  0x81A9, 0x81B0, 0x81B5, 0x81BE, 0x81B8, 0x81BD, 0x81C0, 0x81C2,
  0x81BA, 0x81C9, 0x81CD, 0x81D1, 0x81D9, 0x81D8, 0x81C8, 0x81DA,
  0x81DF, 0x81E0, 0x81E7, 0x81FA, 0x81FB, 0x81FE, 0x8201, 0x8202,
  0x8205, 0x8207, 0x820A, 0x820D, 0x8210, 0x8216, 0x8229, 0x822B,
  0x8238, 0x8233, 0x8240, 0x8259, 0x8258, 0x825D, 0x825A, 0x825F,
  0x8264, 0x8262, 0x8268, 0x826A, 0x826B, 0x822E, 0x8271, 0x8277,
  0x8278, 0x827E, 0x828D, 0x8292, 0x82AB, 0x829F, 0x82BB, 0x82AC,
  0x82E1, 0x82E3, 0x82DF, 0x82D2, 0x82F4, 0x82F3, 0x82FA, 0x8393,
  0x8303, 0x82FB, 0x82F9, 0x82DE, 0x8306, 0x82DC, 0x8309, 0x82D9,
  0x8335, 0x8334, 0x8316, 0x8332, 0x8331, 0x8340, 0x8339, 0x8350,
  0x8345, 0x832F, 0x832B, 0x8317, 0x8318, 0x8385, 0x839A, 0x83AA,
  0x839F, 0x83A2, 0x8396, 0x8323, 0x838E, 0x8387, 0x838A, 0x837C,
  0x83B5, 0x8373, 0x8375, 0x83A0, 0x8389, 0x83A8, 0x83F4, 0x8413,
  0x83EB, 0x83CE, 0x83FD, 0x8403, 0x83D8, 0x840B, 0x83C1, 0x83F7,
  0x8407, 0x83E0, 0x83F2, 0x840D, 0x8422, 0x8420, 0x83BD, 0x8438,
  0x8506, 0x83FB, 0x846D, 0x842A, 0x843C, 0x855A, 0x8484, 0x8477,
  0x846B, 0x84AD, 0x846E, 0x8482, 0x8469, 0x8446, 0x842C, 0x846F,
  0x8479, 0x8435, 0x84CA, 0x8462, 0x84B9, 0x84BF, 0x849F, 0x84D9,
  0x84CD, 0x84BB, 0x84DA, 0x84D0, 0x84C1, 0x84C6, 0x84D6, 0x84A1,
  0x8521, 0x84FF, 0x84F4, 0x8517, 0x8518, 0x852C, 0x851F, 0x8515,
  0x8514, 0x84FC, 0x8540, 0x8563, 0x8558, 0x8548, 0x8541, 0x8602,
  0x854B, 0x8555, 0x8580, 0x85A4, 0x8588, 0x8591, 0x858A, 0x85A8,
  0x856D, 0x8594, 0x859B, 0x85EA, 0x8587, 0x859C, 0x8577, 0x857E,
  0x8590, 0x85C9, 0x85BA, 0x85CF, 0x85B9, 0x85D0, 0x85D5, 0x85DD,
  0x85E5, 0x85DC, 0x85F9, 0x860A, 0x8613, 0x860B, 0x85FE, 0x85FA,
  0x8606, 0x8622, 0x861A, 0x8630, 0x863F, 0x864D, 0x4E55, 0x8654,
  0x865F, 0x8667, 0x8671, 0x8693, 0x86A3, 0x86A9, 0x86AA, 0x868B,
  0x868C, 0x86B6, 0x86AF, 0x86C4, 0x86C6, 0x86B0, 0x86C9, 0x8823,
  0x86AB, 0x86D4, 0x86DE, 0x86E9, 0x86EC, 0x86DF, 0x86DB, 0x86EF,
  0x8712, 0x8706, 0x8708, 0x8700, 0x8703, 0x86FB, 0x8711, 0x8709,
  0x870D, 0x86F9, 0x870A, 0x8734, 0x873F, 0x8737, 0x873B, 0x8725,
  0x8729, 0x871A, 0x8760, 0x875F, 0x8778, 0x874C, 0x874E, 0x8774,
  0x8757, 0x8768, 0x876E, 0x8759, 0x8753, 0x8763, 0x876A, 0x8805,
  0x87A2, 0x879F, 0x8782, 0x87AF, 0x87CB, 0x87BD, 0x87C0, 0x87D0,
  0x96D6, 0x87AB, 0x87C4, 0x87B3, 0x87C7, 0x87C6, 0x87BB, 0x87EF,
  0x87F2, 0x87E0, 0x880F, 0x880D, 0x87FE, 0x87F6, 0x87F7, 0x880E,
  0x87D2, 0x8811, 0x8816, 0x8815, 0x8822, 0x8821, 0x8831, 0x8836,
  0x8839, 0x8827, 0x883B, 0x8844, 0x8842, 0x8852, 0x8859, 0x885E,
  0x8862, 0x886B, 0x8881, 0x887E, 0x889E, 0x8875, 0x887D, 0x88B5,
  0x8872, 0x8882, 0x8897, 0x8892, 0x88AE, 0x8899, 0x88A2, 0x888D,
  0x88A4, 0x88B0, 0x88BF, 0x88B1, 0x88C3, 0x88C4, 0x88D4, 0x88D8,
  0x88D9, 0x88DD, 0x88F9, 0x8902, 0x88FC, 0x88F4, 0x88E8, 0x88F2,
  0x8904, 0x890C, 0x890A, 0x8913, 0x8943, 0x891E, 0x8925, 0x892A,
  0x892B, 0x8941, 0x8944, 0x893B, 0x8936, 0x8938, 0x894C, 0x891D,
  0x8960, 0x895E, 0x8966, 0x8964, 0x896D, 0x896A, 0x896F, 0x8974,
  0x8977, 0x897E, 0x8983, 0x8988, 0x898A, 0x8993, 0x8998, 0x89A1,
  0x89A9, 0x89A6, 0x89AC, 0x89AF, 0x89B2, 0x89BA, 0x89BD, 0x89BF,
  0x89C0, 0x89DA, 0x89DC, 0x89DD, 0x89E7, 0x89F4, 0x89F8, 0x8A03,
  0x8A16, 0x8A10, 0x8A0C, 0x8A1B, 0x8A1D, 0x8A25, 0x8A36, 0x8A41,
  0x8A5B, 0x8A52, 0x8A46, 0x8A48, 0x8A7C, 0x8A6D, 0x8A6C, 0x8A62,
  0x8A85, 0x8A82, 0x8A84, 0x8AA8, 0x8AA1, 0x8A91, 0x8AA5, 0x8AA6,
  0x8A9A, 0x8AA3, 0x8AC4, 0x8ACD, 0x8AC2, 0x8ADA, 0x8AEB, 0x8AF3,
  0x8AE7, 0x8AE4, 0x8AF1, 0x8B14, 0x8AE0, 0x8AE2, 0x8AF7, 0x8ADE,
  0x8ADB, 0x8B0C, 0x8B07, 0x8B1A, 0x8AE1, 0x8B16, 0x8B10, 0x8B17,
  0x8B20, 0x8B33, 0x97AB, 0x8B26, 0x8B2B, 0x8B3E, 0x8B28, 0x8B41,
  0x8B4C, 0x8B4F, 0x8B4E, 0x8B49, 0x8B56, 0x8B5B, 0x8B5A, 0x8B6B,
  0x8B5F, 0x8B6C, 0x8B6F, 0x8B74, 0x8B7D, 0x8B80, 0x8B8C, 0x8B8E,
  0x8B92, 0x8B93, 0x8B96, 0x8B99, 0x8B9A, 0x8C3A, 0x8C41, 0x8C3F,
  0x8C48, 0x8C4C, 0x8C4E, 0x8C50, 0x8C55, 0x8C62, 0x8C6C, 0x8C78,
  0x8C7A, 0x8C82, 0x8C89, 0x8C85, 0x8C8A, 0x8C8D, 0x8C8E, 0x8C94,
  0x8C7C, 0x8C98, 0x621D, 0x8CAD, 0x8CAA, 0x8CBD, 0x8CB2, 0x8CB3,
  0x8CAE, 0x8CB6, 0x8CC8, 0x8CC1, 0x8CE4, 0x8CE3, 0x8CDA, 0x8CFD,
  0x8CFA, 0x8CFB, 0x8D04, 0x8D05, 0x8D0A, 0x8D07, 0x8D0F, 0x8D0D,
  0x8D10, 0x9F4E, 0x8D13, 0x8CCD, 0x8D14, 0x8D16, 0x8D67, 0x8D6D,
  0x8D71, 0x8D73, 0x8D81, 0x8D99, 0x8DC2, 0x8DBE, 0x8DBA, 0x8DCF,
  0x8DDA, 0x8DD6, 0x8DCC, 0x8DDB, 0x8DCB, 0x8DEA, 0x8DEB, 0x8DDF,
  0x8DE3, 0x8DFC, 0x8E08, 0x8E09, 0x8DFF, 0x8E1D, 0x8E1E, 0x8E10,
  0x8E1F, 0x8E42, 0x8E35, 0x8E30, 0x8E34, 0x8E4A, 0x8E47, 0x8E49,
  0x8E4C, 0x8E50, 0x8E48, 0x8E59, 0x8E64, 0x8E60, 0x8E2A, 0x8E63,
  0x8E55, 0x8E76, 0x8E72, 0x8E7C, 0x8E81, 0x8E87, 0x8E85, 0x8E84,
  0x8E8B, 0x8E8A, 0x8E93, 0x8E91, 0x8E94, 0x8E99, 0x8EAA, 0x8EA1,
  0x8EAC, 0x8EB0, 0x8EC6, 0x8EB1, 0x8EBE, 0x8EC5, 0x8EC8, 0x8ECB,
  0x8EDB, 0x8EE3, 0x8EFC, 0x8EFB, 0x8EEB, 0x8EFE, 0x8F0A, 0x8F05,
  0x8F15, 0x8F12, 0x8F19, 0x8F13, 0x8F1C, 0x8F1F, 0x8F1B, 0x8F0C,
  0x8F26, 0x8F33, 0x8F3B, 0x8F39, 0x8F45, 0x8F42, 0x8F3E, 0x8F4C,
  0x8F49, 0x8F46, 0x8F4E, 0x8F57, 0x8F5C, 0x8F62, 0x8F63, 0x8F64,
  0x8F9C, 0x8F9F, 0x8FA3, 0x8FAD, 0x8FAF, 0x8FB7, 0x8FDA, 0x8FE5,
  0x8FE2, 0x8FEA, 0x8FEF, 0x9087, 0x8FF4, 0x9005, 0x8FF9, 0x8FFA,
  0x9011, 0x9015, 0x9021, 0x900D, 0x901E, 0x9016, 0x900B, 0x9027,
  0x9036, 0x9035, 0x9039, 0x8FF8, 0x904F, 0x9050, 0x9051, 0x9052,
  0x900E, 0x9049, 0x903E, 0x9056, 0x9058, 0x905E, 0x9068, 0x906F,
  0x9076, 0x96A8, 0x9072, 0x9082, 0x907D, 0x9081, 0x9080, 0x908A,
  0x9089, 0x908F, 0x90A8, 0x90AF, 0x90B1, 0x90B5, 0x90E2, 0x90E4,
  0x6248, 0x90DB, 0x9102, 0x9112, 0x9119, 0x9132, 0x9130, 0x914A,
  0x9156, 0x9158, 0x9163, 0x9165, 0x9169, 0x9173, 0x9172, 0x918B,
  0x9189, 0x9182, 0x91A2, 0x91AB, 0x91AF, 0x91AA, 0x91B5, 0x91B4,
  0x91BA, 0x91C0, 0x91C1, 0x91C9, 0x91CB, 0x91D0, 0x91D6, 0x91DF,
  0x91E1, 0x91DB, 0x91FC, 0x91F5, 0x91F6, 0x921E, 0x91FF, 0x9214,
  0x922C, 0x9215, 0x9211, 0x925E, 0x9257, 0x9245, 0x9249, 0x9264,
  0x9248, 0x9295, 0x923F, 0x924B, 0x9250, 0x929C, 0x9296, 0x9293,
  0x929B, 0x925A, 0x92CF, 0x92B9, 0x92B7, 0x92E9, 0x930F, 0x92FA,
  0x9344, 0x932E, 0x9319, 0x9322, 0x931A, 0x9323, 0x933A, 0x9335,
  0x933B, 0x935C, 0x9360, 0x937C, 0x936E, 0x9356, 0x93B0, 0x93AC,
  0x93AD, 0x9394, 0x93B9, 0x93D6, 0x93D7, 0x93E8, 0x93E5, 0x93D8,
  0x93C3, 0x93DD, 0x93D0, 0x93C8, 0x93E4, 0x941A, 0x9414, 0x9413,
  0x9403, 0x9407, 0x9410, 0x9436, 0x942B, 0x9435, 0x9421, 0x943A,
  0x9441, 0x9452, 0x9444, 0x945B, 0x9460, 0x9462, 0x945E, 0x946A,
  0x9229, 0x9470, 0x9475, 0x9477, 0x947D, 0x945A, 0x947C, 0x947E,
  0x9481, 0x947F, 0x9582, 0x9587, 0x958A, 0x9594, 0x9596, 0x9598,
  0x9599, 0x95A0, 0x95A8, 0x95A7, 0x95AD, 0x95BC, 0x95BB, 0x95B9,
  0x95BE, 0x95CA, 0x6FF6, 0x95C3, 0x95CD, 0x95CC, 0x95D5, 0x95D4,
  0x95D6, 0x95DC, 0x95E1, 0x95E5, 0x95E2, 0x9621, 0x9628, 0x962E,
  0x962F, 0x9642, 0x964C, 0x964F, 0x964B, 0x9677, 0x965C, 0x965E,
  0x965D, 0x965F, 0x9666, 0x9672, 0x966C, 0x968D, 0x9698, 0x9695,
  0x9697, 0x96AA, 0x96A7, 0x96B1, 0x96B2, 0x96B0, 0x96B4, 0x96B6,
  0x96B8, 0x96B9, 0x96CE, 0x96CB, 0x96C9, 0x96CD, 0x894D, 0x96DC,
  0x970D, 0x96D5, 0x96F9, 0x9704, 0x9706, 0x9708, 0x9713, 0x970E,
  0x9711, 0x970F, 0x9716, 0x9719, 0x9724, 0x972A, 0x9730, 0x9739,
  0x973D, 0x973E, 0x9744, 0x9746, 0x9748, 0x9742, 0x9749, 0x975C,
  0x9760, 0x9764, 0x9766, 0x9768, 0x52D2, 0x976B, 0x9771, 0x9779,
  0x9785, 0x977C, 0x9781, 0x977A, 0x9786, 0x978B, 0x978F, 0x9790,
  0x979C, 0x97A8, 0x97A6, 0x97A3, 0x97B3, 0x97B4, 0x97C3, 0x97C6,
  0x97C8, 0x97CB, 0x97DC, 0x97ED, 0x9F4F, 0x97F2, 0x7ADF, 0x97F6,
  0x97F5, 0x980F, 0x980C, 0x9838, 0x9824, 0x9821, 0x9837, 0x983D,
  0x9846, 0x984F, 0x984B, 0x986B, 0x986F, 0x9870, 0x9871, 0x9874,
  0x9873, 0x98AA, 0x98AF, 0x98B1, 0x98B6, 0x98C4, 0x98C3, 0x98C6,
  0x98E9, 0x98EB, 0x9903, 0x9909, 0x9912, 0x9914, 0x9918, 0x9921,
  0x991D, 0x991E, 0x9924, 0x9920, 0x992C, 0x992E, 0x993D, 0x993E,
  0x9942, 0x9949, 0x9945, 0x9950, 0x994B, 0x9951, 0x9952, 0x994C,
  0x9955, 0x9997, 0x9998, 0x99A5, 0x99AD, 0x99AE, 0x99BC, 0x99DF,
  0x99DB, 0x99DD, 0x99D8, 0x99D1, 0x99ED, 0x99EE, 0x99F1, 0x99F2,
  0x99FB, 0x99F8, 0x9A01, 0x9A0F, 0x9A05, 0x99E2, 0x9A19, 0x9A2B,
  0x9A37, 0x9A45, 0x9A42, 0x9A40, 0x9A43, 0x9A3E, 0x9A55, 0x9A4D,
  0x9A5B, 0x9A57, 0x9A5F, 0x9A62, 0x9A65, 0x9A64, 0x9A69, 0x9A6B,
  0x9A6A, 0x9AAD, 0x9AB0, 0x9ABC, 0x9AC0, 0x9ACF, 0x9AD1, 0x9AD3,
  0x9AD4, 0x9ADE, 0x9ADF, 0x9AE2, 0x9AE3, 0x9AE6, 0x9AEF, 0x9AEB,
  0x9AEE, 0x9AF4, 0x9AF1, 0x9AF7, 0x9AFB, 0x9B06, 0x9B18, 0x9B1A,
  0x9B1F, 0x9B22, 0x9B23, 0x9B25, 0x9B27, 0x9B28, 0x9B29, 0x9B2A,
  0x9B2E, 0x9B2F, 0x9B32, 0x9B44, 0x9B43, 0x9B4F, 0x9B4D, 0x9B4E,
  0x9B51, 0x9B58, 0x9B74, 0x9B93, 0x9B83, 0x9B91, 0x9B96, 0x9B97,
  0x9B9F, 0x9BA0, 0x9BA8, 0x9BB4, 0x9BC0, 0x9BCA, 0x9BB9, 0x9BC6,
  0x9BCF, 0x9BD1, 0x9BD2, 0x9BE3, 0x9BE2, 0x9BE4, 0x9BD4, 0x9BE1,
  0x9C3A, 0x9BF2, 0x9BF1, 0x9BF0, 0x9C15, 0x9C14, 0x9C09, 0x9C13,
  0x9C0C, 0x9C06, 0x9C08, 0x9C12, 0x9C0A, 0x9C04, 0x9C2E, 0x9C1B,
  0x9C25, 0x9C24, 0x9C21, 0x9C30, 0x9C47, 0x9C32, 0x9C46, 0x9C3E,
  0x9C5A, 0x9C60, 0x9C67, 0x9C76, 0x9C78, 0x9CE7, 0x9CEC, 0x9CF0,
  0x9D09, 0x9D08, 0x9CEB, 0x9D03, 0x9D06, 0x9D2A, 0x9D26, 0x9DAF,
  0x9D23, 0x9D1F, 0x9D44, 0x9D15, 0x9D12, 0x9D41, 0x9D3F, 0x9D3E,
  0x9D46, 0x9D48, 0x9D5D, 0x9D5E, 0x9D64, 0x9D51, 0x9D50, 0x9D59,
  0x9D72, 0x9D89, 0x9D87, 0x9DAB, 0x9D6F, 0x9D7A, 0x9D9A, 0x9DA4,
  0x9DA9, 0x9DB2, 0x9DC4, 0x9DC1, 0x9DBB, 0x9DB8, 0x9DBA, 0x9DC6,
  0x9DCF, 0x9DC2, 0x9DD9, 0x9DD3, 0x9DF8, 0x9DE6, 0x9DED, 0x9DEF,
  0x9DFD, 0x9E1A, 0x9E1B, 0x9E1E, 0x9E75, 0x9E79, 0x9E7D, 0x9E81,
  0x9E88, 0x9E8B, 0x9E8C, 0x9E92, 0x9E95, 0x9E91, 0x9E9D, 0x9EA5,
  0x9EA9, 0x9EB8, 0x9EAA, 0x9EAD, 0x9761, 0x9ECC, 0x9ECE, 0x9ECF,
  0x9ED0, 0x9ED4, 0x9EDC, 0x9EDE, 0x9EDD, 0x9EE0, 0x9EE5, 0x9EE8,
  0x9EEF, 0x9EF4, 0x9EF6, 0x9EF7, 0x9EF9, 0x9EFB, 0x9EFC, 0x9EFD,
  0x9F07, 0x9F08, 0x76B7, 0x9F15, 0x9F21, 0x9F2C, 0x9F3E, 0x9F4A,
  0x9F52, 0x9F54, 0x9F63, 0x9F5F, 0x9F60, 0x9F61, 0x9F66, 0x9F67,
  0x9F6C, 0x9F6A, 0x9F77, 0x9F72, 0x9F76, 0x9F95, 0x9F9C, 0x9FA0,
  0x582F, 0x69C7, 0x9059, 0x7464, 0x51DC, 0x7199,
  // [  1159,  1181] -v # seg 5 at pos 7088
  0x3349, 0x3314, 0x3322, 0x334D, 0x3318, 0x3327, 0x3303, 0x3336,
  0x3351, 0x3357, 0x330D, 0x3326, 0x3323, 0x332B, 0x334A, 0x333B,
  0x339C, 0x339D, 0x339E, 0x338E, 0x338F, 0x33C4, 0x33A1,
  // [  1190,  1219] -v # seg 7 at pos 7111
  0x337B, 0x301D, 0x301F, 0x2116, 0x33CD, 0x2121, 0x32A4, 0x32A5,
  0x32A6, 0x32A7, 0x32A8, 0x3231, 0x3232, 0x3239, 0x337E, 0x337D,
  0x337C, 0x2252, 0x2261, 0x222B, 0x222E, 0x2211, 0x221A, 0x22A5,
  0x2220, 0x221F, 0x22BF, 0x2235, 0x2229, 0x222A,
  // [  8272,  8633] -v # seg 11 at pos 7141
  0x7E8A, 0x891C, 0x9348, 0x9288, 0x84DC, 0x4FC9, 0x70BB, 0x6631,
  0x68C8, 0x92F9, 0x66FB, 0x5F45, 0x4E28, 0x4EE1, 0x4EFC, 0x4F00,
  0x4F03, 0x4F39, 0x4F56, 0x4F92, 0x4F8A, 0x4F9A, 0x4F94, 0x4FCD,
  0x5040, 0x5022, 0x4FFF, 0x501E, 0x5046, 0x5070, 0x5042, 0x5094,
  0x50F4, 0x50D8, 0x514A, 0x5164, 0x519D, 0x51BE, 0x51EC, 0x5215,
  0x529C, 0x52A6, 0x52C0, 0x52DB, 0x5300, 0x5307, 0x5324, 0x5372,
  0x5393, 0x53B2, 0x53DD, 0xFA0E, 0x549C, 0x548A, 0x54A9, 0x54FF,
  0x5586, 0x5759, 0x5765, 0x57AC, 0x57C8, 0x57C7, 0xFA0F, 0xFA10,
  0x589E, 0x58B2, 0x590B, 0x5953, 0x595B, 0x595D, 0x5963, 0x59A4,
  0x59BA, 0x5B56, 0x5BC0, 0x752F, 0x5BD8, 0x5BEC, 0x5C1E, 0x5CA6,
  0x5CBA, 0x5CF5, 0x5D27, 0x5D53, 0xFA11, 0x5D42, 0x5D6D, 0x5DB8,
  0x5DB9, 0x5DD0, 0x5F21, 0x5F34, 0x5F67, 0x5FB7, 0x5FDE, 0x605D,
  0x6085, 0x608A, 0x60DE, 0x60D5, 0x6120, 0x60F2, 0x6111, 0x6137,
  0x6130, 0x6198, 0x6213, 0x62A6, 0x63F5, 0x6460, 0x649D, 0x64CE,
  0x654E, 0x6600, 0x6615, 0x663B, 0x6609, 0x662E, 0x661E, 0x6624,
  0x6665, 0x6657, 0x6659, 0xFA12, 0x6673, 0x6699, 0x66A0, 0x66B2,
  0x66BF, 0x66FA, 0x670E, 0xF929, 0x6766, 0x67BB, 0x6852, 0x67C0,
  0x6801, 0x6844, 0x68CF, 0xFA13, 0x6968, 0xFA14, 0x6998, 0x69E2,
  0x6A30, 0x6A6B, 0x6A46, 0x6A73, 0x6A7E, 0x6AE2, 0x6AE4, 0x6BD6,
  0x6C3F, 0x6C5C, 0x6C86, 0x6C6F, 0x6CDA, 0x6D04, 0x6D87, 0x6D6F,
  0x6D96, 0x6DAC, 0x6DCF, 0x6DF8, 0x6DF2, 0x6DFC, 0x6E39, 0x6E5C,
  0x6E27, 0x6E3C, 0x6EBF, 0x6F88, 0x6FB5, 0x6FF5, 0x7005, 0x7007,
  0x7028, 0x7085, 0x70AB, 0x710F, 0x7104, 0x715C, 0x7146, 0x7147,
  0xFA15, 0x71C1, 0x71FE, 0x72B1, 0x72BE, 0x7324, 0xFA16, 0x7377,
  0x73BD, 0x73C9, 0x73D6, 0x73E3, 0x73D2, 0x7407, 0x73F5, 0x7426,
  0x742A, 0x7429, 0x742E, 0x7462, 0x7489, 0x749F, 0x7501, 0x756F,
  0x7682, 0x769C, 0x769E, 0x769B, 0x76A6, 0xFA17, 0x7746, 0x52AF,
  0x7821, 0x784E, 0x7864, 0x787A, 0x7930, 0xFA18, 0xFA19, 0xFA1A,
  0x7994, 0xFA1B, 0x799B, 0x7AD1, 0x7AE7, 0xFA1C, 0x7AEB, 0x7B9E,
  0xFA1D, 0x7D48, 0x7D5C, 0x7DB7, 0x7DA0, 0x7DD6, 0x7E52, 0x7F47,
  0x7FA1, 0xFA1E, 0x8301, 0x8362, 0x837F, 0x83C7, 0x83F6, 0x8448,
  0x84B4, 0x8553, 0x8559, 0x856B, 0xFA1F, 0x85B0, 0xFA20, 0xFA21,
  0x8807, 0x88F5, 0x8A12, 0x8A37, 0x8A79, 0x8AA7, 0x8ABE, 0x8ADF,
  0xFA22, 0x8AF6, 0x8B53, 0x8B7F, 0x8CF0, 0x8CF4, 0x8D12, 0x8D76,
  0xFA23, 0x8ECF, 0xFA24, 0xFA25, 0x9067, 0x90DE, 0xFA26, 0x9115,
  0x9127, 0x91DA, 0x91D7, 0x91DE, 0x91ED, 0x91EE, 0x91E4, 0x91E5,
  0x9206, 0x9210, 0x920A, 0x923A, 0x9240, 0x923C, 0x924E, 0x9259,
  0x9251, 0x9239, 0x9267, 0x92A7, 0x9277, 0x9278, 0x92E7, 0x92D7,
  0x92D9, 0x92D0, 0xFA27, 0x92D5, 0x92E0, 0x92D3, 0x9325, 0x9321,
  0x92FB, 0xFA28, 0x931E, 0x92FF, 0x931D, 0x9302, 0x9370, 0x9357,
  0x93A4, 0x93C6, 0x93DE, 0x93F8, 0x9431, 0x9445, 0x9448, 0x9592,
  0xF9DC, 0xFA29, 0x969D, 0x96AF, 0x9733, 0x973B, 0x9743, 0x974D,
  0x974F, 0x9751, 0x9755, 0x9857, 0x9865, 0xFA2A, 0xFA2B, 0x9927,
  0xFA2C, 0x999E, 0x9A4E, 0x9AD9, 0x9ADC, 0x9B75, 0x9B72, 0x9B8F,
  0x9BB1, 0x9BBB, 0x9C00, 0x9D70, 0x9D6B, 0xFA2D, 0x9E19, 0x9ED1,
   RCHAR,  RCHAR,
  // [  8634,  8643] -> [0x2170,0x2179] # seg 12
  // [  8644,  8647] -v # seg 13 at pos 7503
  0xFFE2, 0xFFE4, 0xFF07, 0xFF02,
  // [  8836, 10715] -> [0xE000,0xE757] # seg 15
  // [ 10716, 10725] -> [0x2170,0x2179] # seg 16
  // [ 10726, 10735] -> [0x2160,0x2169] # seg 17
  // [ 10736, 11103] -v # seg 18 at pos 7507
  0xFFE2, 0xFFE4, 0xFF07, 0xFF02, 0x3231, 0x2116, 0x2121, 0x2235,
  0x7E8A, 0x891C, 0x9348, 0x9288, 0x84DC, 0x4FC9, 0x70BB, 0x6631,
  0x68C8, 0x92F9, 0x66FB, 0x5F45, 0x4E28, 0x4EE1, 0x4EFC, 0x4F00,
  0x4F03, 0x4F39, 0x4F56, 0x4F92, 0x4F8A, 0x4F9A, 0x4F94, 0x4FCD,
  0x5040, 0x5022, 0x4FFF, 0x501E, 0x5046, 0x5070, 0x5042, 0x5094,
  0x50F4, 0x50D8, 0x514A, 0x5164, 0x519D, 0x51BE, 0x51EC, 0x5215,
  0x529C, 0x52A6, 0x52C0, 0x52DB, 0x5300, 0x5307, 0x5324, 0x5372,
  0x5393, 0x53B2, 0x53DD, 0xFA0E, 0x549C, 0x548A, 0x54A9, 0x54FF,
  0x5586, 0x5759, 0x5765, 0x57AC, 0x57C8, 0x57C7, 0xFA0F, 0xFA10,
  0x589E, 0x58B2, 0x590B, 0x5953, 0x595B, 0x595D, 0x5963, 0x59A4,
  0x59BA, 0x5B56, 0x5BC0, 0x752F, 0x5BD8, 0x5BEC, 0x5C1E, 0x5CA6,
  0x5CBA, 0x5CF5, 0x5D27, 0x5D53, 0xFA11, 0x5D42, 0x5D6D, 0x5DB8,
  0x5DB9, 0x5DD0, 0x5F21, 0x5F34, 0x5F67, 0x5FB7, 0x5FDE, 0x605D,
  0x6085, 0x608A, 0x60DE, 0x60D5, 0x6120, 0x60F2, 0x6111, 0x6137,
  0x6130, 0x6198, 0x6213, 0x62A6, 0x63F5, 0x6460, 0x649D, 0x64CE,
  0x654E, 0x6600, 0x6615, 0x663B, 0x6609, 0x662E, 0x661E, 0x6624,
  0x6665, 0x6657, 0x6659, 0xFA12, 0x6673, 0x6699, 0x66A0, 0x66B2,
  0x66BF, 0x66FA, 0x670E, 0xF929, 0x6766, 0x67BB, 0x6852, 0x67C0,
  0x6801, 0x6844, 0x68CF, 0xFA13, 0x6968, 0xFA14, 0x6998, 0x69E2,
  0x6A30, 0x6A6B, 0x6A46, 0x6A73, 0x6A7E, 0x6AE2, 0x6AE4, 0x6BD6,
  0x6C3F, 0x6C5C, 0x6C86, 0x6C6F, 0x6CDA, 0x6D04, 0x6D87, 0x6D6F,
  0x6D96, 0x6DAC, 0x6DCF, 0x6DF8, 0x6DF2, 0x6DFC, 0x6E39, 0x6E5C,
  0x6E27, 0x6E3C, 0x6EBF, 0x6F88, 0x6FB5, 0x6FF5, 0x7005, 0x7007,
  0x7028, 0x7085, 0x70AB, 0x710F, 0x7104, 0x715C, 0x7146, 0x7147,
  0xFA15, 0x71C1, 0x71FE, 0x72B1, 0x72BE, 0x7324, 0xFA16, 0x7377,
  0x73BD, 0x73C9, 0x73D6, 0x73E3, 0x73D2, 0x7407, 0x73F5, 0x7426,
  0x742A, 0x7429, 0x742E, 0x7462, 0x7489, 0x749F, 0x7501, 0x756F,
  0x7682, 0x769C, 0x769E, 0x769B, 0x76A6, 0xFA17, 0x7746, 0x52AF,
  0x7821, 0x784E, 0x7864, 0x787A, 0x7930, 0xFA18, 0xFA19, 0xFA1A,
  0x7994, 0xFA1B, 0x799B, 0x7AD1, 0x7AE7, 0xFA1C, 0x7AEB, 0x7B9E,
  0xFA1D, 0x7D48, 0x7D5C, 0x7DB7, 0x7DA0, 0x7DD6, 0x7E52, 0x7F47,
  0x7FA1, 0xFA1E, 0x8301, 0x8362, 0x837F, 0x83C7, 0x83F6, 0x8448,
  0x84B4, 0x8553, 0x8559, 0x856B, 0xFA1F, 0x85B0, 0xFA20, 0xFA21,
  0x8807, 0x88F5, 0x8A12, 0x8A37, 0x8A79, 0x8AA7, 0x8ABE, 0x8ADF,
  0xFA22, 0x8AF6, 0x8B53, 0x8B7F, 0x8CF0, 0x8CF4, 0x8D12, 0x8D76,
  0xFA23, 0x8ECF, 0xFA24, 0xFA25, 0x9067, 0x90DE, 0xFA26, 0x9115,
  0x9127, 0x91DA, 0x91D7, 0x91DE, 0x91ED, 0x91EE, 0x91E4, 0x91E5,
  0x9206, 0x9210, 0x920A, 0x923A, 0x9240, 0x923C, 0x924E, 0x9259,
  0x9251, 0x9239, 0x9267, 0x92A7, 0x9277, 0x9278, 0x92E7, 0x92D7,
  0x92D9, 0x92D0, 0xFA27, 0x92D5, 0x92E0, 0x92D3, 0x9325, 0x9321,
  0x92FB, 0xFA28, 0x931E, 0x92FF, 0x931D, 0x9302, 0x9370, 0x9357,
  0x93A4, 0x93C6, 0x93DE, 0x93F8, 0x9431, 0x9445, 0x9448, 0x9592,
  0xF9DC, 0xFA29, 0x969D, 0x96AF, 0x9733, 0x973B, 0x9743, 0x974D,
  0x974F, 0x9751, 0x9755, 0x9857, 0x9865, 0xFA2A, 0xFA2B, 0x9927,
  0xFA2C, 0x999E, 0x9A4E, 0x9AD9, 0x9ADC, 0x9B75, 0x9B72, 0x9B8F,
  0x9BB1, 0x9BBB, 0x9C00, 0x9D70, 0x9D6B, 0xFA2D, 0x9E19, 0x9ED1,
};

// Japanese JIS X 0212
const unsigned short CodePageJISX0212[6134] = {
  // hot segments (indexes into segment table)
  1, 23,
  // number of segments
  25,
  // segment table
       0,    108,    119,    127,    130,    168,    175,    534,
     562,    597,    608,    610,    645,    656,    658,    752,
     768,    784,    800,    846,    933,    940,   1027,   1410,
    7211,
  // compressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR, 0x0402, 0x040E,  RCHAR, 0x0452, 0x045E,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,
  // uncompressed segments
   RCHAR, 0x16A9,  RCHAR, 0x16B4,  RCHAR, 0x16B7,  RCHAR, 0x16BE,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR, 0x16DA,
   RCHAR, 0x16EA,  RCHAR, 0x16FA,  RCHAR, 0x1751,  RCHAR, 0x0000,
   RCHAR,
  // [   597,   607] -> [0x0402,0x040C] # seg 9
  // [   656,   657] -> [0x045E,0x045F] # seg 13
  // [  1410,  7210] -v # seg 23 at pos 0
  0x4E02, 0x4E04, 0x4E05, 0x4E0C, 0x4E12, 0x4E1F, 0x4E23, 0x4E24,
  0x4E28, 0x4E2B, 0x4E2E, 0x4E2F, 0x4E30, 0x4E35, 0x4E40, 0x4E41,
  0x4E44, 0x4E47, 0x4E51, 0x4E5A, 0x4E5C, 0x4E63, 0x4E68, 0x4E69,
  0x4E74, 0x4E75, 0x4E79, 0x4E7F, 0x4E8D, 0x4E96, 0x4E97, 0x4E9D,
  0x4EAF, 0x4EB9, 0x4EC3, 0x4ED0, 0x4EDA, 0x4EDB, 0x4EE0, 0x4EE1,
  0x4EE2, 0x4EE8, 0x4EEF, 0x4EF1, 0x4EF3, 0x4EF5, 0x4EFD, 0x4EFE,
  0x4EFF, 0x4F00, 0x4F02, 0x4F03, 0x4F08, 0x4F0B, 0x4F0C, 0x4F12,
  0x4F15, 0x4F16, 0x4F17, 0x4F19, 0x4F2E, 0x4F31, 0x4F60, 0x4F33,
  0x4F35, 0x4F37, 0x4F39, 0x4F3B, 0x4F3E, 0x4F40, 0x4F42, 0x4F48,
  0x4F49, 0x4F4B, 0x4F4C, 0x4F52, 0x4F54, 0x4F56, 0x4F58, 0x4F5F,
  0x4F63, 0x4F6A, 0x4F6C, 0x4F6E, 0x4F71, 0x4F77, 0x4F78, 0x4F79,
  0x4F7A, 0x4F7D, 0x4F7E, 0x4F81, 0x4F82, 0x4F84, 0x4F85, 0x4F89,
  0x4F8A, 0x4F8C, 0x4F8E, 0x4F90, 0x4F92, 0x4F93, 0x4F94, 0x4F97,
  0x4F99, 0x4F9A, 0x4F9E, 0x4F9F, 0x4FB2, 0x4FB7, 0x4FB9, 0x4FBB,
  0x4FBC, 0x4FBD, 0x4FBE, 0x4FC0, 0x4FC1, 0x4FC5, 0x4FC6, 0x4FC8,
  0x4FC9, 0x4FCB, 0x4FCC, 0x4FCD, 0x4FCF, 0x4FD2, 0x4FDC, 0x4FE0,
  0x4FE2, 0x4FF0, 0x4FF2, 0x4FFC, 0x4FFD, 0x4FFF, 0x5000, 0x5001,
  0x5004, 0x5007, 0x500A, 0x500C, 0x500E, 0x5010, 0x5013, 0x5017,
  0x5018, 0x501B, 0x501C, 0x501D, 0x501E, 0x5022, 0x5027, 0x502E,
  0x5030, 0x5032, 0x5033, 0x5035, 0x5040, 0x5041, 0x5042, 0x5045,
  0x5046, 0x504A, 0x504C, 0x504E, 0x5051, 0x5052, 0x5053, 0x5057,
  0x5059, 0x505F, 0x5060, 0x5062, 0x5063, 0x5066, 0x5067, 0x506A,
  0x506D, 0x5070, 0x5071, 0x503B, 0x5081, 0x5083, 0x5084, 0x5086,
  0x508A, 0x508E, 0x508F, 0x5090, 0x5092, 0x5093, 0x5094, 0x5096,
  0x509B, 0x509C, 0x509E, 0x509F, 0x50A0, 0x50A1, 0x50A2, 0x50AA,
  0x50AF, 0x50B0, 0x50B9, 0x50BA, 0x50BD, 0x50C0, 0x50C3, 0x50C4,
  0x50C7, 0x50CC, 0x50CE, 0x50D0, 0x50D3, 0x50D4, 0x50D8, 0x50DC,
  0x50DD, 0x50DF, 0x50E2, 0x50E4, 0x50E6, 0x50E8, 0x50E9, 0x50EF,
  0x50F1, 0x50F6, 0x50FA, 0x50FE, 0x5103, 0x5106, 0x5107, 0x5108,
  0x510B, 0x510C, 0x510D, 0x510E, 0x50F2, 0x5110, 0x5117, 0x5119,
  0x511B, 0x511C, 0x511D, 0x511E, 0x5123, 0x5127, 0x5128, 0x512C,
  0x512D, 0x512F, 0x5131, 0x5133, 0x5134, 0x5135, 0x5138, 0x5139,
  0x5142, 0x514A, 0x514F, 0x5153, 0x5155, 0x5157, 0x5158, 0x515F,
  0x5164, 0x5166, 0x517E, 0x5183, 0x5184, 0x518B, 0x518E, 0x5198,
  0x519D, 0x51A1, 0x51A3, 0x51AD, 0x51B8, 0x51BA, 0x51BC, 0x51BE,
  0x51BF, 0x51C2, 0x51C8, 0x51CF, 0x51D1, 0x51D2, 0x51D3, 0x51D5,
  0x51D8, 0x51DE, 0x51E2, 0x51E5, 0x51EE, 0x51F2, 0x51F3, 0x51F4,
  0x51F7, 0x5201, 0x5202, 0x5205, 0x5212, 0x5213, 0x5215, 0x5216,
  0x5218, 0x5222, 0x5228, 0x5231, 0x5232, 0x5235, 0x523C, 0x5245,
  0x5249, 0x5255, 0x5257, 0x5258, 0x525A, 0x525C, 0x525F, 0x5260,
  0x5261, 0x5266, 0x526E, 0x5277, 0x5278, 0x5279, 0x5280, 0x5282,
  0x5285, 0x528A, 0x528C, 0x5293, 0x5295, 0x5296, 0x5297, 0x5298,
  0x529A, 0x529C, 0x52A4, 0x52A5, 0x52A6, 0x52A7, 0x52AF, 0x52B0,
  0x52B6, 0x52B7, 0x52B8, 0x52BA, 0x52BB, 0x52BD, 0x52C0, 0x52C4,
  0x52C6, 0x52C8, 0x52CC, 0x52CF, 0x52D1, 0x52D4, 0x52D6, 0x52DB,
  0x52DC, 0x52E1, 0x52E5, 0x52E8, 0x52E9, 0x52EA, 0x52EC, 0x52F0,
  0x52F1, 0x52F4, 0x52F6, 0x52F7, 0x5300, 0x5303, 0x530A, 0x530B,
  0x530C, 0x5311, 0x5313, 0x5318, 0x531B, 0x531C, 0x531E, 0x531F,
  0x5325, 0x5327, 0x5328, 0x5329, 0x532B, 0x532C, 0x532D, 0x5330,
  0x5332, 0x5335, 0x533C, 0x533D, 0x533E, 0x5342, 0x534C, 0x534B,
  0x5359, 0x535B, 0x5361, 0x5363, 0x5365, 0x536C, 0x536D, 0x5372,
  0x5379, 0x537E, 0x5383, 0x5387, 0x5388, 0x538E, 0x5393, 0x5394,
  0x5399, 0x539D, 0x53A1, 0x53A4, 0x53AA, 0x53AB, 0x53AF, 0x53B2,
  0x53B4, 0x53B5, 0x53B7, 0x53B8, 0x53BA, 0x53BD, 0x53C0, 0x53C5,
  0x53CF, 0x53D2, 0x53D3, 0x53D5, 0x53DA, 0x53DD, 0x53DE, 0x53E0,
  0x53E6, 0x53E7, 0x53F5, 0x5402, 0x5413, 0x541A, 0x5421, 0x5427,
  0x5428, 0x542A, 0x542F, 0x5431, 0x5434, 0x5435, 0x5443, 0x5444,
  0x5447, 0x544D, 0x544F, 0x545E, 0x5462, 0x5464, 0x5466, 0x5467,
  0x5469, 0x546B, 0x546D, 0x546E, 0x5474, 0x547F, 0x5481, 0x5483,
  0x5485, 0x5488, 0x5489, 0x548D, 0x5491, 0x5495, 0x5496, 0x549C,
  0x549F, 0x54A1, 0x54A6, 0x54A7, 0x54A9, 0x54AA, 0x54AD, 0x54AE,
  0x54B1, 0x54B7, 0x54B9, 0x54BA, 0x54BB, 0x54BF, 0x54C6, 0x54CA,
  0x54CD, 0x54CE, 0x54E0, 0x54EA, 0x54EC, 0x54EF, 0x54F6, 0x54FC,
  0x54FE, 0x54FF, 0x5500, 0x5501, 0x5505, 0x5508, 0x5509, 0x550C,
  0x550D, 0x550E, 0x5515, 0x552A, 0x552B, 0x5532, 0x5535, 0x5536,
  0x553B, 0x553C, 0x553D, 0x5541, 0x5547, 0x5549, 0x554A, 0x554D,
  0x5550, 0x5551, 0x5558, 0x555A, 0x555B, 0x555E, 0x5560, 0x5561,
  0x5564, 0x5566, 0x557F, 0x5581, 0x5582, 0x5586, 0x5588, 0x558E,
  0x558F, 0x5591, 0x5592, 0x5593, 0x5594, 0x5597, 0x55A3, 0x55A4,
  0x55AD, 0x55B2, 0x55BF, 0x55C1, 0x55C3, 0x55C6, 0x55C9, 0x55CB,
  0x55CC, 0x55CE, 0x55D1, 0x55D2, 0x55D3, 0x55D7, 0x55D8, 0x55DB,
  0x55DE, 0x55E2, 0x55E9, 0x55F6, 0x55FF, 0x5605, 0x5608, 0x560A,
  0x560D, 0x560E, 0x560F, 0x5610, 0x5611, 0x5612, 0x5619, 0x562C,
  0x5630, 0x5633, 0x5635, 0x5637, 0x5639, 0x563B, 0x563C, 0x563D,
  0x563F, 0x5640, 0x5641, 0x5643, 0x5644, 0x5646, 0x5649, 0x564B,
  0x564D, 0x564F, 0x5654, 0x565E, 0x5660, 0x5661, 0x5662, 0x5663,
  0x5666, 0x5669, 0x566D, 0x566F, 0x5671, 0x5672, 0x5675, 0x5684,
  0x5685, 0x5688, 0x568B, 0x568C, 0x5695, 0x5699, 0x569A, 0x569D,
  0x569E, 0x569F, 0x56A6, 0x56A7, 0x56A8, 0x56A9, 0x56AB, 0x56AC,
  0x56AD, 0x56B1, 0x56B3, 0x56B7, 0x56BE, 0x56C5, 0x56C9, 0x56CA,
  0x56CB, 0x56CF, 0x56D0, 0x56CC, 0x56CD, 0x56D9, 0x56DC, 0x56DD,
  0x56DF, 0x56E1, 0x56E4, 0x56E5, 0x56E6, 0x56E7, 0x56E8, 0x56F1,
  0x56EB, 0x56ED, 0x56F6, 0x56F7, 0x5701, 0x5702, 0x5707, 0x570A,
  0x570C, 0x5711, 0x5715, 0x571A, 0x571B, 0x571D, 0x5720, 0x5722,
  0x5723, 0x5724, 0x5725, 0x5729, 0x572A, 0x572C, 0x572E, 0x572F,
  0x5733, 0x5734, 0x573D, 0x573E, 0x573F, 0x5745, 0x5746, 0x574C,
  0x574D, 0x5752, 0x5762, 0x5765, 0x5767, 0x5768, 0x576B, 0x576D,
  0x576E, 0x576F, 0x5770, 0x5771, 0x5773, 0x5774, 0x5775, 0x5777,
  0x5779, 0x577A, 0x577B, 0x577C, 0x577E, 0x5781, 0x5783, 0x578C,
  0x5794, 0x5797, 0x5799, 0x579A, 0x579C, 0x579D, 0x579E, 0x579F,
  0x57A1, 0x5795, 0x57A7, 0x57A8, 0x57A9, 0x57AC, 0x57B8, 0x57BD,
  0x57C7, 0x57C8, 0x57CC, 0x57CF, 0x57D5, 0x57DD, 0x57DE, 0x57E4,
  0x57E6, 0x57E7, 0x57E9, 0x57ED, 0x57F0, 0x57F5, 0x57F6, 0x57F8,
  0x57FD, 0x57FE, 0x57FF, 0x5803, 0x5804, 0x5808, 0x5809, 0x57E1,
  0x580C, 0x580D, 0x581B, 0x581E, 0x581F, 0x5820, 0x5826, 0x5827,
  0x582D, 0x5832, 0x5839, 0x583F, 0x5849, 0x584C, 0x584D, 0x584F,
  0x5850, 0x5855, 0x585F, 0x5861, 0x5864, 0x5867, 0x5868, 0x5878,
  0x587C, 0x587F, 0x5880, 0x5881, 0x5887, 0x5888, 0x5889, 0x588A,
  0x588C, 0x588D, 0x588F, 0x5890, 0x5894, 0x5896, 0x589D, 0x58A0,
  0x58A1, 0x58A2, 0x58A6, 0x58A9, 0x58B1, 0x58B2, 0x58C4, 0x58BC,
  0x58C2, 0x58C8, 0x58CD, 0x58CE, 0x58D0, 0x58D2, 0x58D4, 0x58D6,
  0x58DA, 0x58DD, 0x58E1, 0x58E2, 0x58E9, 0x58F3, 0x5905, 0x5906,
  0x590B, 0x590C, 0x5912, 0x5913, 0x5914, 0x8641, 0x591D, 0x5921,
  0x5923, 0x5924, 0x5928, 0x592F, 0x5930, 0x5933, 0x5935, 0x5936,
  0x593F, 0x5943, 0x5946, 0x5952, 0x5953, 0x5959, 0x595B, 0x595D,
  0x595E, 0x595F, 0x5961, 0x5963, 0x596B, 0x596D, 0x596F, 0x5972,
  0x5975, 0x5976, 0x5979, 0x597B, 0x597C, 0x598B, 0x598C, 0x598E,
  0x5992, 0x5995, 0x5997, 0x599F, 0x59A4, 0x59A7, 0x59AD, 0x59AE,
  0x59AF, 0x59B0, 0x59B3, 0x59B7, 0x59BA, 0x59BC, 0x59C1, 0x59C3,
  0x59C4, 0x59C8, 0x59CA, 0x59CD, 0x59D2, 0x59DD, 0x59DE, 0x59DF,
  0x59E3, 0x59E4, 0x59E7, 0x59EE, 0x59EF, 0x59F1, 0x59F2, 0x59F4,
  0x59F7, 0x5A00, 0x5A04, 0x5A0C, 0x5A0D, 0x5A0E, 0x5A12, 0x5A13,
  0x5A1E, 0x5A23, 0x5A24, 0x5A27, 0x5A28, 0x5A2A, 0x5A2D, 0x5A30,
  0x5A44, 0x5A45, 0x5A47, 0x5A48, 0x5A4C, 0x5A50, 0x5A55, 0x5A5E,
  0x5A63, 0x5A65, 0x5A67, 0x5A6D, 0x5A77, 0x5A7A, 0x5A7B, 0x5A7E,
  0x5A8B, 0x5A90, 0x5A93, 0x5A96, 0x5A99, 0x5A9C, 0x5A9E, 0x5A9F,
  0x5AA0, 0x5AA2, 0x5AA7, 0x5AAC, 0x5AB1, 0x5AB2, 0x5AB3, 0x5AB5,
  0x5AB8, 0x5ABA, 0x5ABB, 0x5ABF, 0x5AC4, 0x5AC6, 0x5AC8, 0x5ACF,
  0x5ADA, 0x5ADC, 0x5AE0, 0x5AE5, 0x5AEA, 0x5AEE, 0x5AF5, 0x5AF6,
  0x5AFD, 0x5B00, 0x5B01, 0x5B08, 0x5B17, 0x5B34, 0x5B19, 0x5B1B,
  0x5B1D, 0x5B21, 0x5B25, 0x5B2D, 0x5B38, 0x5B41, 0x5B4B, 0x5B4C,
  0x5B52, 0x5B56, 0x5B5E, 0x5B68, 0x5B6E, 0x5B6F, 0x5B7C, 0x5B7D,
  0x5B7E, 0x5B7F, 0x5B81, 0x5B84, 0x5B86, 0x5B8A, 0x5B8E, 0x5B90,
  0x5B91, 0x5B93, 0x5B94, 0x5B96, 0x5BA8, 0x5BA9, 0x5BAC, 0x5BAD,
  0x5BAF, 0x5BB1, 0x5BB2, 0x5BB7, 0x5BBA, 0x5BBC, 0x5BC0, 0x5BC1,
  0x5BCD, 0x5BCF, 0x5BD6, 0x5BD7, 0x5BD8, 0x5BD9, 0x5BDA, 0x5BE0,
  0x5BEF, 0x5BF1, 0x5BF4, 0x5BFD, 0x5C0C, 0x5C17, 0x5C1E, 0x5C1F,
  0x5C23, 0x5C26, 0x5C29, 0x5C2B, 0x5C2C, 0x5C2E, 0x5C30, 0x5C32,
  0x5C35, 0x5C36, 0x5C59, 0x5C5A, 0x5C5C, 0x5C62, 0x5C63, 0x5C67,
  0x5C68, 0x5C69, 0x5C6D, 0x5C70, 0x5C74, 0x5C75, 0x5C7A, 0x5C7B,
  0x5C7C, 0x5C7D, 0x5C87, 0x5C88, 0x5C8A, 0x5C8F, 0x5C92, 0x5C9D,
  0x5C9F, 0x5CA0, 0x5CA2, 0x5CA3, 0x5CA6, 0x5CAA, 0x5CB2, 0x5CB4,
  0x5CB5, 0x5CBA, 0x5CC9, 0x5CCB, 0x5CD2, 0x5CDD, 0x5CD7, 0x5CEE,
  0x5CF1, 0x5CF2, 0x5CF4, 0x5D01, 0x5D06, 0x5D0D, 0x5D12, 0x5D2B,
  0x5D23, 0x5D24, 0x5D26, 0x5D27, 0x5D31, 0x5D34, 0x5D39, 0x5D3D,
  0x5D3F, 0x5D42, 0x5D43, 0x5D46, 0x5D48, 0x5D55, 0x5D51, 0x5D59,
  0x5D4A, 0x5D5F, 0x5D60, 0x5D61, 0x5D62, 0x5D64, 0x5D6A, 0x5D6D,
  0x5D70, 0x5D79, 0x5D7A, 0x5D7E, 0x5D7F, 0x5D81, 0x5D83, 0x5D88,
  0x5D8A, 0x5D92, 0x5D93, 0x5D94, 0x5D95, 0x5D99, 0x5D9B, 0x5D9F,
  0x5DA0, 0x5DA7, 0x5DAB, 0x5DB0, 0x5DB4, 0x5DB8, 0x5DB9, 0x5DC3,
  0x5DC7, 0x5DCB, 0x5DD0, 0x5DCE, 0x5DD8, 0x5DD9, 0x5DE0, 0x5DE4,
  0x5DE9, 0x5DF8, 0x5DF9, 0x5E00, 0x5E07, 0x5E0D, 0x5E12, 0x5E14,
  0x5E15, 0x5E18, 0x5E1F, 0x5E20, 0x5E2E, 0x5E28, 0x5E32, 0x5E35,
  0x5E3E, 0x5E4B, 0x5E50, 0x5E49, 0x5E51, 0x5E56, 0x5E58, 0x5E5B,
  0x5E5C, 0x5E5E, 0x5E68, 0x5E6A, 0x5E6B, 0x5E6C, 0x5E6D, 0x5E6E,
  0x5E70, 0x5E80, 0x5E8B, 0x5E8E, 0x5EA2, 0x5EA4, 0x5EA5, 0x5EA8,
  0x5EAA, 0x5EAC, 0x5EB1, 0x5EB3, 0x5EBD, 0x5EBE, 0x5EBF, 0x5EC6,
  0x5ECC, 0x5ECB, 0x5ECE, 0x5ED1, 0x5ED2, 0x5ED4, 0x5ED5, 0x5EDC,
  0x5EDE, 0x5EE5, 0x5EEB, 0x5F02, 0x5F06, 0x5F07, 0x5F08, 0x5F0E,
  0x5F19, 0x5F1C, 0x5F1D, 0x5F21, 0x5F22, 0x5F23, 0x5F24, 0x5F28,
  0x5F2B, 0x5F2C, 0x5F2E, 0x5F30, 0x5F34, 0x5F36, 0x5F3B, 0x5F3D,
  0x5F3F, 0x5F40, 0x5F44, 0x5F45, 0x5F47, 0x5F4D, 0x5F50, 0x5F54,
  0x5F58, 0x5F5B, 0x5F60, 0x5F63, 0x5F64, 0x5F67, 0x5F6F, 0x5F72,
  0x5F74, 0x5F75, 0x5F78, 0x5F7A, 0x5F7D, 0x5F7E, 0x5F89, 0x5F8D,
  0x5F8F, 0x5F96, 0x5F9C, 0x5F9D, 0x5FA2, 0x5FA7, 0x5FAB, 0x5FA4,
  0x5FAC, 0x5FAF, 0x5FB0, 0x5FB1, 0x5FB8, 0x5FC4, 0x5FC7, 0x5FC8,
  0x5FC9, 0x5FCB, 0x5FD0, 0x5FD1, 0x5FD2, 0x5FD3, 0x5FD4, 0x5FDE,
  0x5FE1, 0x5FE2, 0x5FE8, 0x5FE9, 0x5FEA, 0x5FEC, 0x5FED, 0x5FEE,
  0x5FEF, 0x5FF2, 0x5FF3, 0x5FF6, 0x5FFA, 0x5FFC, 0x6007, 0x600A,
  0x600D, 0x6013, 0x6014, 0x6017, 0x6018, 0x601A, 0x601F, 0x6024,
  0x602D, 0x6033, 0x6035, 0x6040, 0x6047, 0x6048, 0x6049, 0x604C,
  0x6051, 0x6054, 0x6056, 0x6057, 0x605D, 0x6061, 0x6067, 0x6071,
  0x607E, 0x607F, 0x6082, 0x6086, 0x6088, 0x608A, 0x608E, 0x6091,
  0x6093, 0x6095, 0x6098, 0x609D, 0x609E, 0x60A2, 0x60A4, 0x60A5,
  0x60A8, 0x60B0, 0x60B1, 0x60B7, 0x60BB, 0x60BE, 0x60C2, 0x60C4,
  0x60C8, 0x60C9, 0x60CA, 0x60CB, 0x60CE, 0x60CF, 0x60D4, 0x60D5,
  0x60D9, 0x60DB, 0x60DD, 0x60DE, 0x60E2, 0x60E5, 0x60F2, 0x60F5,
  0x60F8, 0x60FC, 0x60FD, 0x6102, 0x6107, 0x610A, 0x610C, 0x6110,
  0x6111, 0x6112, 0x6113, 0x6114, 0x6116, 0x6117, 0x6119, 0x611C,
  0x611E, 0x6122, 0x612A, 0x612B, 0x6130, 0x6131, 0x6135, 0x6136,
  0x6137, 0x6139, 0x6141, 0x6145, 0x6146, 0x6149, 0x615E, 0x6160,
  0x616C, 0x6172, 0x6178, 0x617B, 0x617C, 0x617F, 0x6180, 0x6181,
  0x6183, 0x6184, 0x618B, 0x618D, 0x6192, 0x6193, 0x6197, 0x6198,
  0x619C, 0x619D, 0x619F, 0x61A0, 0x61A5, 0x61A8, 0x61AA, 0x61AD,
  0x61B8, 0x61B9, 0x61BC, 0x61C0, 0x61C1, 0x61C2, 0x61CE, 0x61CF,
  0x61D5, 0x61DC, 0x61DD, 0x61DE, 0x61DF, 0x61E1, 0x61E2, 0x61E7,
  0x61E9, 0x61E5, 0x61EC, 0x61ED, 0x61EF, 0x6201, 0x6203, 0x6204,
  0x6207, 0x6213, 0x6215, 0x621C, 0x6220, 0x6222, 0x6223, 0x6227,
  0x6229, 0x622B, 0x6239, 0x623D, 0x6242, 0x6243, 0x6244, 0x6246,
  0x624C, 0x6250, 0x6251, 0x6252, 0x6254, 0x6256, 0x625A, 0x625C,
  0x6264, 0x626D, 0x626F, 0x6273, 0x627A, 0x627D, 0x628D, 0x628E,
  0x628F, 0x6290, 0x62A6, 0x62A8, 0x62B3, 0x62B6, 0x62B7, 0x62BA,
  0x62BE, 0x62BF, 0x62C4, 0x62CE, 0x62D5, 0x62D6, 0x62DA, 0x62EA,
  0x62F2, 0x62F4, 0x62FC, 0x62FD, 0x6303, 0x6304, 0x630A, 0x630B,
  0x630D, 0x6310, 0x6313, 0x6316, 0x6318, 0x6329, 0x632A, 0x632D,
  0x6335, 0x6336, 0x6339, 0x633C, 0x6341, 0x6342, 0x6343, 0x6344,
  0x6346, 0x634A, 0x634B, 0x634E, 0x6352, 0x6353, 0x6354, 0x6358,
  0x635B, 0x6365, 0x6366, 0x636C, 0x636D, 0x6371, 0x6374, 0x6375,
  0x6378, 0x637C, 0x637D, 0x637F, 0x6382, 0x6384, 0x6387, 0x638A,
  0x6390, 0x6394, 0x6395, 0x6399, 0x639A, 0x639E, 0x63A4, 0x63A6,
  0x63AD, 0x63AE, 0x63AF, 0x63BD, 0x63C1, 0x63C5, 0x63C8, 0x63CE,
  0x63D1, 0x63D3, 0x63D4, 0x63D5, 0x63DC, 0x63E0, 0x63E5, 0x63EA,
  0x63EC, 0x63F2, 0x63F3, 0x63F5, 0x63F8, 0x63F9, 0x6409, 0x640A,
  0x6410, 0x6412, 0x6414, 0x6418, 0x641E, 0x6420, 0x6422, 0x6424,
  0x6425, 0x6429, 0x642A, 0x642F, 0x6430, 0x6435, 0x643D, 0x643F,
  0x644B, 0x644F, 0x6451, 0x6452, 0x6453, 0x6454, 0x645A, 0x645B,
  0x645C, 0x645D, 0x645F, 0x6460, 0x6461, 0x6463, 0x646D, 0x6473,
  0x6474, 0x647B, 0x647D, 0x6485, 0x6487, 0x648F, 0x6490, 0x6491,
  0x6498, 0x6499, 0x649B, 0x649D, 0x649F, 0x64A1, 0x64A3, 0x64A6,
  0x64A8, 0x64AC, 0x64B3, 0x64BD, 0x64BE, 0x64BF, 0x64C4, 0x64C9,
  0x64CA, 0x64CB, 0x64CC, 0x64CE, 0x64D0, 0x64D1, 0x64D5, 0x64D7,
  0x64E4, 0x64E5, 0x64E9, 0x64EA, 0x64ED, 0x64F0, 0x64F5, 0x64F7,
  0x64FB, 0x64FF, 0x6501, 0x6504, 0x6508, 0x6509, 0x650A, 0x650F,
  0x6513, 0x6514, 0x6516, 0x6519, 0x651B, 0x651E, 0x651F, 0x6522,
  0x6526, 0x6529, 0x652E, 0x6531, 0x653A, 0x653C, 0x653D, 0x6543,
  0x6547, 0x6549, 0x6550, 0x6552, 0x6554, 0x655F, 0x6560, 0x6567,
  0x656B, 0x657A, 0x657D, 0x6581, 0x6585, 0x658A, 0x6592, 0x6595,
  0x6598, 0x659D, 0x65A0, 0x65A3, 0x65A6, 0x65AE, 0x65B2, 0x65B3,
  0x65B4, 0x65BF, 0x65C2, 0x65C8, 0x65C9, 0x65CE, 0x65D0, 0x65D4,
  0x65D6, 0x65D8, 0x65DF, 0x65F0, 0x65F2, 0x65F4, 0x65F5, 0x65F9,
  0x65FE, 0x65FF, 0x6600, 0x6604, 0x6608, 0x6609, 0x660D, 0x6611,
  0x6612, 0x6615, 0x6616, 0x661D, 0x661E, 0x6621, 0x6622, 0x6623,
  0x6624, 0x6626, 0x6629, 0x662A, 0x662B, 0x662C, 0x662E, 0x6630,
  0x6631, 0x6633, 0x6639, 0x6637, 0x6640, 0x6645, 0x6646, 0x664A,
  0x664C, 0x6651, 0x664E, 0x6657, 0x6658, 0x6659, 0x665B, 0x665C,
  0x6660, 0x6661, 0x66FB, 0x666A, 0x666B, 0x666C, 0x667E, 0x6673,
  0x6675, 0x667F, 0x6677, 0x6678, 0x6679, 0x667B, 0x6680, 0x667C,
  0x668B, 0x668C, 0x668D, 0x6690, 0x6692, 0x6699, 0x669A, 0x669B,
  0x669C, 0x669F, 0x66A0, 0x66A4, 0x66AD, 0x66B1, 0x66B2, 0x66B5,
  0x66BB, 0x66BF, 0x66C0, 0x66C2, 0x66C3, 0x66C8, 0x66CC, 0x66CE,
  0x66CF, 0x66D4, 0x66DB, 0x66DF, 0x66E8, 0x66EB, 0x66EC, 0x66EE,
  0x66FA, 0x6705, 0x6707, 0x670E, 0x6713, 0x6719, 0x671C, 0x6720,
  0x6722, 0x6733, 0x673E, 0x6745, 0x6747, 0x6748, 0x674C, 0x6754,
  0x6755, 0x675D, 0x6766, 0x676C, 0x676E, 0x6774, 0x6776, 0x677B,
  0x6781, 0x6784, 0x678E, 0x678F, 0x6791, 0x6793, 0x6796, 0x6798,
  0x6799, 0x679B, 0x67B0, 0x67B1, 0x67B2, 0x67B5, 0x67BB, 0x67BC,
  0x67BD, 0x67F9, 0x67C0, 0x67C2, 0x67C3, 0x67C5, 0x67C8, 0x67C9,
  0x67D2, 0x67D7, 0x67D9, 0x67DC, 0x67E1, 0x67E6, 0x67F0, 0x67F2,
  0x67F6, 0x67F7, 0x6852, 0x6814, 0x6819, 0x681D, 0x681F, 0x6828,
  0x6827, 0x682C, 0x682D, 0x682F, 0x6830, 0x6831, 0x6833, 0x683B,
  0x683F, 0x6844, 0x6845, 0x684A, 0x684C, 0x6855, 0x6857, 0x6858,
  0x685B, 0x686B, 0x686E, 0x686F, 0x6870, 0x6871, 0x6872, 0x6875,
  0x6879, 0x687A, 0x687B, 0x687C, 0x6882, 0x6884, 0x6886, 0x6888,
  0x6896, 0x6898, 0x689A, 0x689C, 0x68A1, 0x68A3, 0x68A5, 0x68A9,
  0x68AA, 0x68AE, 0x68B2, 0x68BB, 0x68C5, 0x68C8, 0x68CC, 0x68CF,
  0x68D0, 0x68D1, 0x68D3, 0x68D6, 0x68D9, 0x68DC, 0x68DD, 0x68E5,
  0x68E8, 0x68EA, 0x68EB, 0x68EC, 0x68ED, 0x68F0, 0x68F1, 0x68F5,
  0x68F6, 0x68FB, 0x68FC, 0x68FD, 0x6906, 0x6909, 0x690A, 0x6910,
  0x6911, 0x6913, 0x6916, 0x6917, 0x6931, 0x6933, 0x6935, 0x6938,
  0x693B, 0x6942, 0x6945, 0x6949, 0x694E, 0x6957, 0x695B, 0x6963,
  0x6964, 0x6965, 0x6966, 0x6968, 0x6969, 0x696C, 0x6970, 0x6971,
  0x6972, 0x697A, 0x697B, 0x697F, 0x6980, 0x698D, 0x6992, 0x6996,
  0x6998, 0x69A1, 0x69A5, 0x69A6, 0x69A8, 0x69AB, 0x69AD, 0x69AF,
  0x69B7, 0x69B8, 0x69BA, 0x69BC, 0x69C5, 0x69C8, 0x69D1, 0x69D6,
  0x69D7, 0x69E2, 0x69E5, 0x69EE, 0x69EF, 0x69F1, 0x69F3, 0x69F5,
  0x69FE, 0x6A00, 0x6A01, 0x6A03, 0x6A0F, 0x6A11, 0x6A15, 0x6A1A,
  0x6A1D, 0x6A20, 0x6A24, 0x6A28, 0x6A30, 0x6A32, 0x6A34, 0x6A37,
  0x6A3B, 0x6A3E, 0x6A3F, 0x6A45, 0x6A46, 0x6A49, 0x6A4A, 0x6A4E,
  0x6A50, 0x6A51, 0x6A52, 0x6A55, 0x6A56, 0x6A5B, 0x6A64, 0x6A67,
  0x6A6A, 0x6A71, 0x6A73, 0x6A7E, 0x6A81, 0x6A83, 0x6A86, 0x6A87,
  0x6A89, 0x6A8B, 0x6A91, 0x6A9B, 0x6A9D, 0x6A9E, 0x6A9F, 0x6AA5,
  0x6AAB, 0x6AAF, 0x6AB0, 0x6AB1, 0x6AB4, 0x6ABD, 0x6ABE, 0x6ABF,
  0x6AC6, 0x6AC9, 0x6AC8, 0x6ACC, 0x6AD0, 0x6AD4, 0x6AD5, 0x6AD6,
  0x6ADC, 0x6ADD, 0x6AE4, 0x6AE7, 0x6AEC, 0x6AF0, 0x6AF1, 0x6AF2,
  0x6AFC, 0x6AFD, 0x6B02, 0x6B03, 0x6B06, 0x6B07, 0x6B09, 0x6B0F,
  0x6B10, 0x6B11, 0x6B17, 0x6B1B, 0x6B1E, 0x6B24, 0x6B28, 0x6B2B,
  0x6B2C, 0x6B2F, 0x6B35, 0x6B36, 0x6B3B, 0x6B3F, 0x6B46, 0x6B4A,
  0x6B4D, 0x6B52, 0x6B56, 0x6B58, 0x6B5D, 0x6B60, 0x6B67, 0x6B6B,
  0x6B6E, 0x6B70, 0x6B75, 0x6B7D, 0x6B7E, 0x6B82, 0x6B85, 0x6B97,
  0x6B9B, 0x6B9F, 0x6BA0, 0x6BA2, 0x6BA3, 0x6BA8, 0x6BA9, 0x6BAC,
  0x6BAD, 0x6BAE, 0x6BB0, 0x6BB8, 0x6BB9, 0x6BBD, 0x6BBE, 0x6BC3,
  0x6BC4, 0x6BC9, 0x6BCC, 0x6BD6, 0x6BDA, 0x6BE1, 0x6BE3, 0x6BE6,
  0x6BE7, 0x6BEE, 0x6BF1, 0x6BF7, 0x6BF9, 0x6BFF, 0x6C02, 0x6C04,
  0x6C05, 0x6C09, 0x6C0D, 0x6C0E, 0x6C10, 0x6C12, 0x6C19, 0x6C1F,
  0x6C26, 0x6C27, 0x6C28, 0x6C2C, 0x6C2E, 0x6C33, 0x6C35, 0x6C36,
  0x6C3A, 0x6C3B, 0x6C3F, 0x6C4A, 0x6C4B, 0x6C4D, 0x6C4F, 0x6C52,
  0x6C54, 0x6C59, 0x6C5B, 0x6C5C, 0x6C6B, 0x6C6D, 0x6C6F, 0x6C74,
  0x6C76, 0x6C78, 0x6C79, 0x6C7B, 0x6C85, 0x6C86, 0x6C87, 0x6C89,
  0x6C94, 0x6C95, 0x6C97, 0x6C98, 0x6C9C, 0x6C9F, 0x6CB0, 0x6CB2,
  0x6CB4, 0x6CC2, 0x6CC6, 0x6CCD, 0x6CCF, 0x6CD0, 0x6CD1, 0x6CD2,
  0x6CD4, 0x6CD6, 0x6CDA, 0x6CDC, 0x6CE0, 0x6CE7, 0x6CE9, 0x6CEB,
  0x6CEC, 0x6CEE, 0x6CF2, 0x6CF4, 0x6D04, 0x6D07, 0x6D0A, 0x6D0E,
  0x6D0F, 0x6D11, 0x6D13, 0x6D1A, 0x6D26, 0x6D27, 0x6D28, 0x6C67,
  0x6D2E, 0x6D2F, 0x6D31, 0x6D39, 0x6D3C, 0x6D3F, 0x6D57, 0x6D5E,
  0x6D5F, 0x6D61, 0x6D65, 0x6D67, 0x6D6F, 0x6D70, 0x6D7C, 0x6D82,
  0x6D87, 0x6D91, 0x6D92, 0x6D94, 0x6D96, 0x6D97, 0x6D98, 0x6DAA,
  0x6DAC, 0x6DB4, 0x6DB7, 0x6DB9, 0x6DBD, 0x6DBF, 0x6DC4, 0x6DC8,
  0x6DCA, 0x6DCE, 0x6DCF, 0x6DD6, 0x6DDB, 0x6DDD, 0x6DDF, 0x6DE0,
  0x6DE2, 0x6DE5, 0x6DE9, 0x6DEF, 0x6DF0, 0x6DF4, 0x6DF6, 0x6DFC,
  0x6E00, 0x6E04, 0x6E1E, 0x6E22, 0x6E27, 0x6E32, 0x6E36, 0x6E39,
  0x6E3B, 0x6E3C, 0x6E44, 0x6E45, 0x6E48, 0x6E49, 0x6E4B, 0x6E4F,
  0x6E51, 0x6E52, 0x6E53, 0x6E54, 0x6E57, 0x6E5C, 0x6E5D, 0x6E5E,
  0x6E62, 0x6E63, 0x6E68, 0x6E73, 0x6E7B, 0x6E7D, 0x6E8D, 0x6E93,
  0x6E99, 0x6EA0, 0x6EA7, 0x6EAD, 0x6EAE, 0x6EB1, 0x6EB3, 0x6EBB,
  0x6EBF, 0x6EC0, 0x6EC1, 0x6EC3, 0x6EC7, 0x6EC8, 0x6ECA, 0x6ECD,
  0x6ECE, 0x6ECF, 0x6EEB, 0x6EED, 0x6EEE, 0x6EF9, 0x6EFB, 0x6EFD,
  0x6F04, 0x6F08, 0x6F0A, 0x6F0C, 0x6F0D, 0x6F16, 0x6F18, 0x6F1A,
  0x6F1B, 0x6F26, 0x6F29, 0x6F2A, 0x6F2F, 0x6F30, 0x6F33, 0x6F36,
  0x6F3B, 0x6F3C, 0x6F2D, 0x6F4F, 0x6F51, 0x6F52, 0x6F53, 0x6F57,
  0x6F59, 0x6F5A, 0x6F5D, 0x6F5E, 0x6F61, 0x6F62, 0x6F68, 0x6F6C,
  0x6F7D, 0x6F7E, 0x6F83, 0x6F87, 0x6F88, 0x6F8B, 0x6F8C, 0x6F8D,
  0x6F90, 0x6F92, 0x6F93, 0x6F94, 0x6F96, 0x6F9A, 0x6F9F, 0x6FA0,
  0x6FA5, 0x6FA6, 0x6FA7, 0x6FA8, 0x6FAE, 0x6FAF, 0x6FB0, 0x6FB5,
  0x6FB6, 0x6FBC, 0x6FC5, 0x6FC7, 0x6FC8, 0x6FCA, 0x6FDA, 0x6FDE,
  0x6FE8, 0x6FE9, 0x6FF0, 0x6FF5, 0x6FF9, 0x6FFC, 0x6FFD, 0x7000,
  0x7005, 0x7006, 0x7007, 0x700D, 0x7017, 0x7020, 0x7023, 0x702F,
  0x7034, 0x7037, 0x7039, 0x703C, 0x7043, 0x7044, 0x7048, 0x7049,
  0x704A, 0x704B, 0x7054, 0x7055, 0x705D, 0x705E, 0x704E, 0x7064,
  0x7065, 0x706C, 0x706E, 0x7075, 0x7076, 0x707E, 0x7081, 0x7085,
  0x7086, 0x7094, 0x7095, 0x7096, 0x7097, 0x7098, 0x709B, 0x70A4,
  0x70AB, 0x70B0, 0x70B1, 0x70B4, 0x70B7, 0x70CA, 0x70D1, 0x70D3,
  0x70D4, 0x70D5, 0x70D6, 0x70D8, 0x70DC, 0x70E4, 0x70FA, 0x7103,
  0x7104, 0x7105, 0x7106, 0x7107, 0x710B, 0x710C, 0x710F, 0x711E,
  0x7120, 0x712B, 0x712D, 0x712F, 0x7130, 0x7131, 0x7138, 0x7141,
  0x7145, 0x7146, 0x7147, 0x714A, 0x714B, 0x7150, 0x7152, 0x7157,
  0x715A, 0x715C, 0x715E, 0x7160, 0x7168, 0x7179, 0x7180, 0x7185,
  0x7187, 0x718C, 0x7192, 0x719A, 0x719B, 0x71A0, 0x71A2, 0x71AF,
  0x71B0, 0x71B2, 0x71B3, 0x71BA, 0x71BF, 0x71C0, 0x71C1, 0x71C4,
  0x71CB, 0x71CC, 0x71D3, 0x71D6, 0x71D9, 0x71DA, 0x71DC, 0x71F8,
  0x71FE, 0x7200, 0x7207, 0x7208, 0x7209, 0x7213, 0x7217, 0x721A,
  0x721D, 0x721F, 0x7224, 0x722B, 0x722F, 0x7234, 0x7238, 0x7239,
  0x7241, 0x7242, 0x7243, 0x7245, 0x724E, 0x724F, 0x7250, 0x7253,
  0x7255, 0x7256, 0x725A, 0x725C, 0x725E, 0x7260, 0x7263, 0x7268,
  0x726B, 0x726E, 0x726F, 0x7271, 0x7277, 0x7278, 0x727B, 0x727C,
  0x727F, 0x7284, 0x7289, 0x728D, 0x728E, 0x7293, 0x729B, 0x72A8,
  0x72AD, 0x72AE, 0x72B1, 0x72B4, 0x72BE, 0x72C1, 0x72C7, 0x72C9,
  0x72CC, 0x72D5, 0x72D6, 0x72D8, 0x72DF, 0x72E5, 0x72F3, 0x72F4,
  0x72FA, 0x72FB, 0x72FE, 0x7302, 0x7304, 0x7305, 0x7307, 0x730B,
  0x730D, 0x7312, 0x7313, 0x7318, 0x7319, 0x731E, 0x7322, 0x7324,
  0x7327, 0x7328, 0x732C, 0x7331, 0x7332, 0x7335, 0x733A, 0x733B,
  0x733D, 0x7343, 0x734D, 0x7350, 0x7352, 0x7356, 0x7358, 0x735D,
  0x735E, 0x735F, 0x7360, 0x7366, 0x7367, 0x7369, 0x736B, 0x736C,
  0x736E, 0x736F, 0x7371, 0x7377, 0x7379, 0x737C, 0x7380, 0x7381,
  0x7383, 0x7385, 0x7386, 0x738E, 0x7390, 0x7393, 0x7395, 0x7397,
  0x7398, 0x739C, 0x739E, 0x739F, 0x73A0, 0x73A2, 0x73A5, 0x73A6,
  0x73AA, 0x73AB, 0x73AD, 0x73B5, 0x73B7, 0x73B9, 0x73BC, 0x73BD,
  0x73BF, 0x73C5, 0x73C6, 0x73C9, 0x73CB, 0x73CC, 0x73CF, 0x73D2,
  0x73D3, 0x73D6, 0x73D9, 0x73DD, 0x73E1, 0x73E3, 0x73E6, 0x73E7,
  0x73E9, 0x73F4, 0x73F5, 0x73F7, 0x73F9, 0x73FA, 0x73FB, 0x73FD,
  0x73FF, 0x7400, 0x7401, 0x7404, 0x7407, 0x740A, 0x7411, 0x741A,
  0x741B, 0x7424, 0x7426, 0x7428, 0x7429, 0x742A, 0x742B, 0x742C,
  0x742D, 0x742E, 0x742F, 0x7430, 0x7431, 0x7439, 0x7440, 0x7443,
  0x7444, 0x7446, 0x7447, 0x744B, 0x744D, 0x7451, 0x7452, 0x7457,
  0x745D, 0x7462, 0x7466, 0x7467, 0x7468, 0x746B, 0x746D, 0x746E,
  0x7471, 0x7472, 0x7480, 0x7481, 0x7485, 0x7486, 0x7487, 0x7489,
  0x748F, 0x7490, 0x7491, 0x7492, 0x7498, 0x7499, 0x749A, 0x749C,
  0x749F, 0x74A0, 0x74A1, 0x74A3, 0x74A6, 0x74A8, 0x74A9, 0x74AA,
  0x74AB, 0x74AE, 0x74AF, 0x74B1, 0x74B2, 0x74B5, 0x74B9, 0x74BB,
  0x74BF, 0x74C8, 0x74C9, 0x74CC, 0x74D0, 0x74D3, 0x74D8, 0x74DA,
  0x74DB, 0x74DE, 0x74DF, 0x74E4, 0x74E8, 0x74EA, 0x74EB, 0x74EF,
  0x74F4, 0x74FA, 0x74FB, 0x74FC, 0x74FF, 0x7506, 0x7512, 0x7516,
  0x7517, 0x7520, 0x7521, 0x7524, 0x7527, 0x7529, 0x752A, 0x752F,
  0x7536, 0x7539, 0x753D, 0x753E, 0x753F, 0x7540, 0x7543, 0x7547,
  0x7548, 0x754E, 0x7550, 0x7552, 0x7557, 0x755E, 0x755F, 0x7561,
  0x756F, 0x7571, 0x7579, 0x757A, 0x757B, 0x757C, 0x757D, 0x757E,
  0x7581, 0x7585, 0x7590, 0x7592, 0x7593, 0x7595, 0x7599, 0x759C,
  0x75A2, 0x75A4, 0x75B4, 0x75BA, 0x75BF, 0x75C0, 0x75C1, 0x75C4,
  0x75C6, 0x75CC, 0x75CE, 0x75CF, 0x75D7, 0x75DC, 0x75DF, 0x75E0,
  0x75E1, 0x75E4, 0x75E7, 0x75EC, 0x75EE, 0x75EF, 0x75F1, 0x75F9,
  0x7600, 0x7602, 0x7603, 0x7604, 0x7607, 0x7608, 0x760A, 0x760C,
  0x760F, 0x7612, 0x7613, 0x7615, 0x7616, 0x7619, 0x761B, 0x761C,
  0x761D, 0x761E, 0x7623, 0x7625, 0x7626, 0x7629, 0x762D, 0x7632,
  0x7633, 0x7635, 0x7638, 0x7639, 0x763A, 0x763C, 0x764A, 0x7640,
  0x7641, 0x7643, 0x7644, 0x7645, 0x7649, 0x764B, 0x7655, 0x7659,
  0x765F, 0x7664, 0x7665, 0x766D, 0x766E, 0x766F, 0x7671, 0x7674,
  0x7681, 0x7685, 0x768C, 0x768D, 0x7695, 0x769B, 0x769C, 0x769D,
  0x769F, 0x76A0, 0x76A2, 0x76A3, 0x76A4, 0x76A5, 0x76A6, 0x76A7,
  0x76A8, 0x76AA, 0x76AD, 0x76BD, 0x76C1, 0x76C5, 0x76C9, 0x76CB,
  0x76CC, 0x76CE, 0x76D4, 0x76D9, 0x76E0, 0x76E6, 0x76E8, 0x76EC,
  0x76F0, 0x76F1, 0x76F6, 0x76F9, 0x76FC, 0x7700, 0x7706, 0x770A,
  0x770E, 0x7712, 0x7714, 0x7715, 0x7717, 0x7719, 0x771A, 0x771C,
  0x7722, 0x7728, 0x772D, 0x772E, 0x772F, 0x7734, 0x7735, 0x7736,
  0x7739, 0x773D, 0x773E, 0x7742, 0x7745, 0x7746, 0x774A, 0x774D,
  0x774E, 0x774F, 0x7752, 0x7756, 0x7757, 0x775C, 0x775E, 0x775F,
  0x7760, 0x7762, 0x7764, 0x7767, 0x776A, 0x776C, 0x7770, 0x7772,
  0x7773, 0x7774, 0x777A, 0x777D, 0x7780, 0x7784, 0x778C, 0x778D,
  0x7794, 0x7795, 0x7796, 0x779A, 0x779F, 0x77A2, 0x77A7, 0x77AA,
  0x77AE, 0x77AF, 0x77B1, 0x77B5, 0x77BE, 0x77C3, 0x77C9, 0x77D1,
  0x77D2, 0x77D5, 0x77D9, 0x77DE, 0x77DF, 0x77E0, 0x77E4, 0x77E6,
  0x77EA, 0x77EC, 0x77F0, 0x77F1, 0x77F4, 0x77F8, 0x77FB, 0x7805,
  0x7806, 0x7809, 0x780D, 0x780E, 0x7811, 0x781D, 0x7821, 0x7822,
  0x7823, 0x782D, 0x782E, 0x7830, 0x7835, 0x7837, 0x7843, 0x7844,
  0x7847, 0x7848, 0x784C, 0x784E, 0x7852, 0x785C, 0x785E, 0x7860,
  0x7861, 0x7863, 0x7864, 0x7868, 0x786A, 0x786E, 0x787A, 0x787E,
  0x788A, 0x788F, 0x7894, 0x7898, 0x78A1, 0x789D, 0x789E, 0x789F,
  0x78A4, 0x78A8, 0x78AC, 0x78AD, 0x78B0, 0x78B1, 0x78B2, 0x78B3,
  0x78BB, 0x78BD, 0x78BF, 0x78C7, 0x78C8, 0x78C9, 0x78CC, 0x78CE,
  0x78D2, 0x78D3, 0x78D5, 0x78D6, 0x78E4, 0x78DB, 0x78DF, 0x78E0,
  0x78E1, 0x78E6, 0x78EA, 0x78F2, 0x78F3, 0x7900, 0x78F6, 0x78F7,
  0x78FA, 0x78FB, 0x78FF, 0x7906, 0x790C, 0x7910, 0x791A, 0x791C,
  0x791E, 0x791F, 0x7920, 0x7925, 0x7927, 0x7929, 0x792D, 0x7931,
  0x7934, 0x7935, 0x793B, 0x793D, 0x793F, 0x7944, 0x7945, 0x7946,
  0x794A, 0x794B, 0x794F, 0x7951, 0x7954, 0x7958, 0x795B, 0x795C,
  0x7967, 0x7969, 0x796B, 0x7972, 0x7979, 0x797B, 0x797C, 0x797E,
  0x798B, 0x798C, 0x7991, 0x7993, 0x7994, 0x7995, 0x7996, 0x7998,
  0x799B, 0x799C, 0x79A1, 0x79A8, 0x79A9, 0x79AB, 0x79AF, 0x79B1,
  0x79B4, 0x79B8, 0x79BB, 0x79C2, 0x79C4, 0x79C7, 0x79C8, 0x79CA,
  0x79CF, 0x79D4, 0x79D6, 0x79DA, 0x79DD, 0x79DE, 0x79E0, 0x79E2,
  0x79E5, 0x79EA, 0x79EB, 0x79ED, 0x79F1, 0x79F8, 0x79FC, 0x7A02,
  0x7A03, 0x7A07, 0x7A09, 0x7A0A, 0x7A0C, 0x7A11, 0x7A15, 0x7A1B,
  0x7A1E, 0x7A21, 0x7A27, 0x7A2B, 0x7A2D, 0x7A2F, 0x7A30, 0x7A34,
  0x7A35, 0x7A38, 0x7A39, 0x7A3A, 0x7A44, 0x7A45, 0x7A47, 0x7A48,
  0x7A4C, 0x7A55, 0x7A56, 0x7A59, 0x7A5C, 0x7A5D, 0x7A5F, 0x7A60,
  0x7A65, 0x7A67, 0x7A6A, 0x7A6D, 0x7A75, 0x7A78, 0x7A7E, 0x7A80,
  0x7A82, 0x7A85, 0x7A86, 0x7A8A, 0x7A8B, 0x7A90, 0x7A91, 0x7A94,
  0x7A9E, 0x7AA0, 0x7AA3, 0x7AAC, 0x7AB3, 0x7AB5, 0x7AB9, 0x7ABB,
  0x7ABC, 0x7AC6, 0x7AC9, 0x7ACC, 0x7ACE, 0x7AD1, 0x7ADB, 0x7AE8,
  0x7AE9, 0x7AEB, 0x7AEC, 0x7AF1, 0x7AF4, 0x7AFB, 0x7AFD, 0x7AFE,
  0x7B07, 0x7B14, 0x7B1F, 0x7B23, 0x7B27, 0x7B29, 0x7B2A, 0x7B2B,
  0x7B2D, 0x7B2E, 0x7B2F, 0x7B30, 0x7B31, 0x7B34, 0x7B3D, 0x7B3F,
  0x7B40, 0x7B41, 0x7B47, 0x7B4E, 0x7B55, 0x7B60, 0x7B64, 0x7B66,
  0x7B69, 0x7B6A, 0x7B6D, 0x7B6F, 0x7B72, 0x7B73, 0x7B77, 0x7B84,
  0x7B89, 0x7B8E, 0x7B90, 0x7B91, 0x7B96, 0x7B9B, 0x7B9E, 0x7BA0,
  0x7BA5, 0x7BAC, 0x7BAF, 0x7BB0, 0x7BB2, 0x7BB5, 0x7BB6, 0x7BBA,
  0x7BBB, 0x7BBC, 0x7BBD, 0x7BC2, 0x7BC5, 0x7BC8, 0x7BCA, 0x7BD4,
  0x7BD6, 0x7BD7, 0x7BD9, 0x7BDA, 0x7BDB, 0x7BE8, 0x7BEA, 0x7BF2,
  0x7BF4, 0x7BF5, 0x7BF8, 0x7BF9, 0x7BFA, 0x7BFC, 0x7BFE, 0x7C01,
  0x7C02, 0x7C03, 0x7C04, 0x7C06, 0x7C09, 0x7C0B, 0x7C0C, 0x7C0E,
  0x7C0F, 0x7C19, 0x7C1B, 0x7C20, 0x7C25, 0x7C26, 0x7C28, 0x7C2C,
  0x7C31, 0x7C33, 0x7C34, 0x7C36, 0x7C39, 0x7C3A, 0x7C46, 0x7C4A,
  0x7C55, 0x7C51, 0x7C52, 0x7C53, 0x7C59, 0x7C5A, 0x7C5B, 0x7C5C,
  0x7C5D, 0x7C5E, 0x7C61, 0x7C63, 0x7C67, 0x7C69, 0x7C6D, 0x7C6E,
  0x7C70, 0x7C72, 0x7C79, 0x7C7C, 0x7C7D, 0x7C86, 0x7C87, 0x7C8F,
  0x7C94, 0x7C9E, 0x7CA0, 0x7CA6, 0x7CB0, 0x7CB6, 0x7CB7, 0x7CBA,
  0x7CBB, 0x7CBC, 0x7CBF, 0x7CC4, 0x7CC7, 0x7CC8, 0x7CC9, 0x7CCD,
  0x7CCF, 0x7CD3, 0x7CD4, 0x7CD5, 0x7CD7, 0x7CD9, 0x7CDA, 0x7CDD,
  0x7CE6, 0x7CE9, 0x7CEB, 0x7CF5, 0x7D03, 0x7D07, 0x7D08, 0x7D09,
  0x7D0F, 0x7D11, 0x7D12, 0x7D13, 0x7D16, 0x7D1D, 0x7D1E, 0x7D23,
  0x7D26, 0x7D2A, 0x7D2D, 0x7D31, 0x7D3C, 0x7D3D, 0x7D3E, 0x7D40,
  0x7D41, 0x7D47, 0x7D48, 0x7D4D, 0x7D51, 0x7D53, 0x7D57, 0x7D59,
  0x7D5A, 0x7D5C, 0x7D5D, 0x7D65, 0x7D67, 0x7D6A, 0x7D70, 0x7D78,
  0x7D7A, 0x7D7B, 0x7D7F, 0x7D81, 0x7D82, 0x7D83, 0x7D85, 0x7D86,
  0x7D88, 0x7D8B, 0x7D8C, 0x7D8D, 0x7D91, 0x7D96, 0x7D97, 0x7D9D,
  0x7D9E, 0x7DA6, 0x7DA7, 0x7DAA, 0x7DB3, 0x7DB6, 0x7DB7, 0x7DB9,
  0x7DC2, 0x7DC3, 0x7DC4, 0x7DC5, 0x7DC6, 0x7DCC, 0x7DCD, 0x7DCE,
  0x7DD7, 0x7DD9, 0x7E00, 0x7DE2, 0x7DE5, 0x7DE6, 0x7DEA, 0x7DEB,
  0x7DED, 0x7DF1, 0x7DF5, 0x7DF6, 0x7DF9, 0x7DFA, 0x7E08, 0x7E10,
  0x7E11, 0x7E15, 0x7E17, 0x7E1C, 0x7E1D, 0x7E20, 0x7E27, 0x7E28,
  0x7E2C, 0x7E2D, 0x7E2F, 0x7E33, 0x7E36, 0x7E3F, 0x7E44, 0x7E45,
  0x7E47, 0x7E4E, 0x7E50, 0x7E52, 0x7E58, 0x7E5F, 0x7E61, 0x7E62,
  0x7E65, 0x7E6B, 0x7E6E, 0x7E6F, 0x7E73, 0x7E78, 0x7E7E, 0x7E81,
  0x7E86, 0x7E87, 0x7E8A, 0x7E8D, 0x7E91, 0x7E95, 0x7E98, 0x7E9A,
  0x7E9D, 0x7E9E, 0x7F3C, 0x7F3B, 0x7F3D, 0x7F3E, 0x7F3F, 0x7F43,
  0x7F44, 0x7F47, 0x7F4F, 0x7F52, 0x7F53, 0x7F5B, 0x7F5C, 0x7F5D,
  0x7F61, 0x7F63, 0x7F64, 0x7F65, 0x7F66, 0x7F6D, 0x7F71, 0x7F7D,
  0x7F7E, 0x7F7F, 0x7F80, 0x7F8B, 0x7F8D, 0x7F8F, 0x7F90, 0x7F91,
  0x7F96, 0x7F97, 0x7F9C, 0x7FA1, 0x7FA2, 0x7FA6, 0x7FAA, 0x7FAD,
  0x7FB4, 0x7FBC, 0x7FBF, 0x7FC0, 0x7FC3, 0x7FC8, 0x7FCE, 0x7FCF,
  0x7FDB, 0x7FDF, 0x7FE3, 0x7FE5, 0x7FE8, 0x7FEC, 0x7FEE, 0x7FEF,
  0x7FF2, 0x7FFA, 0x7FFD, 0x7FFE, 0x7FFF, 0x8007, 0x8008, 0x800A,
  0x800D, 0x800E, 0x800F, 0x8011, 0x8013, 0x8014, 0x8016, 0x801D,
  0x801E, 0x801F, 0x8020, 0x8024, 0x8026, 0x802C, 0x802E, 0x8030,
  0x8034, 0x8035, 0x8037, 0x8039, 0x803A, 0x803C, 0x803E, 0x8040,
  0x8044, 0x8060, 0x8064, 0x8066, 0x806D, 0x8071, 0x8075, 0x8081,
  0x8088, 0x808E, 0x809C, 0x809E, 0x80A6, 0x80A7, 0x80AB, 0x80B8,
  0x80B9, 0x80C8, 0x80CD, 0x80CF, 0x80D2, 0x80D4, 0x80D5, 0x80D7,
  0x80D8, 0x80E0, 0x80ED, 0x80EE, 0x80F0, 0x80F2, 0x80F3, 0x80F6,
  0x80F9, 0x80FA, 0x80FE, 0x8103, 0x810B, 0x8116, 0x8117, 0x8118,
  0x811C, 0x811E, 0x8120, 0x8124, 0x8127, 0x812C, 0x8130, 0x8135,
  0x813A, 0x813C, 0x8145, 0x8147, 0x814A, 0x814C, 0x8152, 0x8157,
  0x8160, 0x8161, 0x8167, 0x8168, 0x8169, 0x816D, 0x816F, 0x8177,
  0x8181, 0x8190, 0x8184, 0x8185, 0x8186, 0x818B, 0x818E, 0x8196,
  0x8198, 0x819B, 0x819E, 0x81A2, 0x81AE, 0x81B2, 0x81B4, 0x81BB,
  0x81CB, 0x81C3, 0x81C5, 0x81CA, 0x81CE, 0x81CF, 0x81D5, 0x81D7,
  0x81DB, 0x81DD, 0x81DE, 0x81E1, 0x81E4, 0x81EB, 0x81EC, 0x81F0,
  0x81F1, 0x81F2, 0x81F5, 0x81F6, 0x81F8, 0x81F9, 0x81FD, 0x81FF,
  0x8200, 0x8203, 0x820F, 0x8213, 0x8214, 0x8219, 0x821A, 0x821D,
  0x8221, 0x8222, 0x8228, 0x8232, 0x8234, 0x823A, 0x8243, 0x8244,
  0x8245, 0x8246, 0x824B, 0x824E, 0x824F, 0x8251, 0x8256, 0x825C,
  0x8260, 0x8263, 0x8267, 0x826D, 0x8274, 0x827B, 0x827D, 0x827F,
  0x8280, 0x8281, 0x8283, 0x8284, 0x8287, 0x8289, 0x828A, 0x828E,
  0x8291, 0x8294, 0x8296, 0x8298, 0x829A, 0x829B, 0x82A0, 0x82A1,
  0x82A3, 0x82A4, 0x82A7, 0x82A8, 0x82A9, 0x82AA, 0x82AE, 0x82B0,
  0x82B2, 0x82B4, 0x82B7, 0x82BA, 0x82BC, 0x82BE, 0x82BF, 0x82C6,
  0x82D0, 0x82D5, 0x82DA, 0x82E0, 0x82E2, 0x82E4, 0x82E8, 0x82EA,
  0x82ED, 0x82EF, 0x82F6, 0x82F7, 0x82FD, 0x82FE, 0x8300, 0x8301,
  0x8307, 0x8308, 0x830A, 0x830B, 0x8354, 0x831B, 0x831D, 0x831E,
  0x831F, 0x8321, 0x8322, 0x832C, 0x832D, 0x832E, 0x8330, 0x8333,
  0x8337, 0x833A, 0x833C, 0x833D, 0x8342, 0x8343, 0x8344, 0x8347,
  0x834D, 0x834E, 0x8351, 0x8355, 0x8356, 0x8357, 0x8370, 0x8378,
  0x837D, 0x837F, 0x8380, 0x8382, 0x8384, 0x8386, 0x838D, 0x8392,
  0x8394, 0x8395, 0x8398, 0x8399, 0x839B, 0x839C, 0x839D, 0x83A6,
  0x83A7, 0x83A9, 0x83AC, 0x83BE, 0x83BF, 0x83C0, 0x83C7, 0x83C9,
  0x83CF, 0x83D0, 0x83D1, 0x83D4, 0x83DD, 0x8353, 0x83E8, 0x83EA,
  0x83F6, 0x83F8, 0x83F9, 0x83FC, 0x8401, 0x8406, 0x840A, 0x840F,
  0x8411, 0x8415, 0x8419, 0x83AD, 0x842F, 0x8439, 0x8445, 0x8447,
  0x8448, 0x844A, 0x844D, 0x844F, 0x8451, 0x8452, 0x8456, 0x8458,
  0x8459, 0x845A, 0x845C, 0x8460, 0x8464, 0x8465, 0x8467, 0x846A,
  0x8470, 0x8473, 0x8474, 0x8476, 0x8478, 0x847C, 0x847D, 0x8481,
  0x8485, 0x8492, 0x8493, 0x8495, 0x849E, 0x84A6, 0x84A8, 0x84A9,
  0x84AA, 0x84AF, 0x84B1, 0x84B4, 0x84BA, 0x84BD, 0x84BE, 0x84C0,
  0x84C2, 0x84C7, 0x84C8, 0x84CC, 0x84CF, 0x84D3, 0x84DC, 0x84E7,
  0x84EA, 0x84EF, 0x84F0, 0x84F1, 0x84F2, 0x84F7, 0x8532, 0x84FA,
  0x84FB, 0x84FD, 0x8502, 0x8503, 0x8507, 0x850C, 0x850E, 0x8510,
  0x851C, 0x851E, 0x8522, 0x8523, 0x8524, 0x8525, 0x8527, 0x852A,
  0x852B, 0x852F, 0x8533, 0x8534, 0x8536, 0x853F, 0x8546, 0x854F,
  0x8550, 0x8551, 0x8552, 0x8553, 0x8556, 0x8559, 0x855C, 0x855D,
  0x855E, 0x855F, 0x8560, 0x8561, 0x8562, 0x8564, 0x856B, 0x856F,
  0x8579, 0x857A, 0x857B, 0x857D, 0x857F, 0x8581, 0x8585, 0x8586,
  0x8589, 0x858B, 0x858C, 0x858F, 0x8593, 0x8598, 0x859D, 0x859F,
  0x85A0, 0x85A2, 0x85A5, 0x85A7, 0x85B4, 0x85B6, 0x85B7, 0x85B8,
  0x85BC, 0x85BD, 0x85BE, 0x85BF, 0x85C2, 0x85C7, 0x85CA, 0x85CB,
  0x85CE, 0x85AD, 0x85D8, 0x85DA, 0x85DF, 0x85E0, 0x85E6, 0x85E8,
  0x85ED, 0x85F3, 0x85F6, 0x85FC, 0x85FF, 0x8600, 0x8604, 0x8605,
  0x860D, 0x860E, 0x8610, 0x8611, 0x8612, 0x8618, 0x8619, 0x861B,
  0x861E, 0x8621, 0x8627, 0x8629, 0x8636, 0x8638, 0x863A, 0x863C,
  0x863D, 0x8640, 0x8642, 0x8646, 0x8652, 0x8653, 0x8656, 0x8657,
  0x8658, 0x8659, 0x865D, 0x8660, 0x8661, 0x8662, 0x8663, 0x8664,
  0x8669, 0x866C, 0x866F, 0x8675, 0x8676, 0x8677, 0x867A, 0x868D,
  0x8691, 0x8696, 0x8698, 0x869A, 0x869C, 0x86A1, 0x86A6, 0x86A7,
  0x86A8, 0x86AD, 0x86B1, 0x86B3, 0x86B4, 0x86B5, 0x86B7, 0x86B8,
  0x86B9, 0x86BF, 0x86C0, 0x86C1, 0x86C3, 0x86C5, 0x86D1, 0x86D2,
  0x86D5, 0x86D7, 0x86DA, 0x86DC, 0x86E0, 0x86E3, 0x86E5, 0x86E7,
  0x8688, 0x86FA, 0x86FC, 0x86FD, 0x8704, 0x8705, 0x8707, 0x870B,
  0x870E, 0x870F, 0x8710, 0x8713, 0x8714, 0x8719, 0x871E, 0x871F,
  0x8721, 0x8723, 0x8728, 0x872E, 0x872F, 0x8731, 0x8732, 0x8739,
  0x873A, 0x873C, 0x873D, 0x873E, 0x8740, 0x8743, 0x8745, 0x874D,
  0x8758, 0x875D, 0x8761, 0x8764, 0x8765, 0x876F, 0x8771, 0x8772,
  0x877B, 0x8783, 0x8784, 0x8785, 0x8786, 0x8787, 0x8788, 0x8789,
  0x878B, 0x878C, 0x8790, 0x8793, 0x8795, 0x8797, 0x8798, 0x8799,
  0x879E, 0x87A0, 0x87A3, 0x87A7, 0x87AC, 0x87AD, 0x87AE, 0x87B1,
  0x87B5, 0x87BE, 0x87BF, 0x87C1, 0x87C8, 0x87C9, 0x87CA, 0x87CE,
  0x87D5, 0x87D6, 0x87D9, 0x87DA, 0x87DC, 0x87DF, 0x87E2, 0x87E3,
  0x87E4, 0x87EA, 0x87EB, 0x87ED, 0x87F1, 0x87F3, 0x87F8, 0x87FA,
  0x87FF, 0x8801, 0x8803, 0x8806, 0x8809, 0x880A, 0x880B, 0x8810,
  0x8819, 0x8812, 0x8813, 0x8814, 0x8818, 0x881A, 0x881B, 0x881C,
  0x881E, 0x881F, 0x8828, 0x882D, 0x882E, 0x8830, 0x8832, 0x8835,
  0x883A, 0x883C, 0x8841, 0x8843, 0x8845, 0x8848, 0x8849, 0x884A,
  0x884B, 0x884E, 0x8851, 0x8855, 0x8856, 0x8858, 0x885A, 0x885C,
  0x885F, 0x8860, 0x8864, 0x8869, 0x8871, 0x8879, 0x887B, 0x8880,
  0x8898, 0x889A, 0x889B, 0x889C, 0x889F, 0x88A0, 0x88A8, 0x88AA,
  0x88BA, 0x88BD, 0x88BE, 0x88C0, 0x88CA, 0x88CB, 0x88CC, 0x88CD,
  0x88CE, 0x88D1, 0x88D2, 0x88D3, 0x88DB, 0x88DE, 0x88E7, 0x88EF,
  0x88F0, 0x88F1, 0x88F5, 0x88F7, 0x8901, 0x8906, 0x890D, 0x890E,
  0x890F, 0x8915, 0x8916, 0x8918, 0x8919, 0x891A, 0x891C, 0x8920,
  0x8926, 0x8927, 0x8928, 0x8930, 0x8931, 0x8932, 0x8935, 0x8939,
  0x893A, 0x893E, 0x8940, 0x8942, 0x8945, 0x8946, 0x8949, 0x894F,
  0x8952, 0x8957, 0x895A, 0x895B, 0x895C, 0x8961, 0x8962, 0x8963,
  0x896B, 0x896E, 0x8970, 0x8973, 0x8975, 0x897A, 0x897B, 0x897C,
  0x897D, 0x8989, 0x898D, 0x8990, 0x8994, 0x8995, 0x899B, 0x899C,
  0x899F, 0x89A0, 0x89A5, 0x89B0, 0x89B4, 0x89B5, 0x89B6, 0x89B7,
  0x89BC, 0x89D4, 0x89D5, 0x89D6, 0x89D7, 0x89D8, 0x89E5, 0x89E9,
  0x89EB, 0x89ED, 0x89F1, 0x89F3, 0x89F6, 0x89F9, 0x89FD, 0x89FF,
  0x8A04, 0x8A05, 0x8A07, 0x8A0F, 0x8A11, 0x8A12, 0x8A14, 0x8A15,
  0x8A1E, 0x8A20, 0x8A22, 0x8A24, 0x8A26, 0x8A2B, 0x8A2C, 0x8A2F,
  0x8A35, 0x8A37, 0x8A3D, 0x8A3E, 0x8A40, 0x8A43, 0x8A45, 0x8A47,
  0x8A49, 0x8A4D, 0x8A4E, 0x8A53, 0x8A56, 0x8A57, 0x8A58, 0x8A5C,
  0x8A5D, 0x8A61, 0x8A65, 0x8A67, 0x8A75, 0x8A76, 0x8A77, 0x8A79,
  0x8A7A, 0x8A7B, 0x8A7E, 0x8A7F, 0x8A80, 0x8A83, 0x8A86, 0x8A8B,
  0x8A8F, 0x8A90, 0x8A92, 0x8A96, 0x8A97, 0x8A99, 0x8A9F, 0x8AA7,
  0x8AA9, 0x8AAE, 0x8AAF, 0x8AB3, 0x8AB6, 0x8AB7, 0x8ABB, 0x8ABE,
  0x8AC3, 0x8AC6, 0x8AC8, 0x8AC9, 0x8ACA, 0x8AD1, 0x8AD3, 0x8AD4,
  0x8AD5, 0x8AD7, 0x8ADD, 0x8ADF, 0x8AEC, 0x8AF0, 0x8AF4, 0x8AF5,
  0x8AF6, 0x8AFC, 0x8AFF, 0x8B05, 0x8B06, 0x8B0B, 0x8B11, 0x8B1C,
  0x8B1E, 0x8B1F, 0x8B0A, 0x8B2D, 0x8B30, 0x8B37, 0x8B3C, 0x8B42,
  0x8B43, 0x8B44, 0x8B45, 0x8B46, 0x8B48, 0x8B52, 0x8B53, 0x8B54,
  0x8B59, 0x8B4D, 0x8B5E, 0x8B63, 0x8B6D, 0x8B76, 0x8B78, 0x8B79,
  0x8B7C, 0x8B7E, 0x8B81, 0x8B84, 0x8B85, 0x8B8B, 0x8B8D, 0x8B8F,
  0x8B94, 0x8B95, 0x8B9C, 0x8B9E, 0x8B9F, 0x8C38, 0x8C39, 0x8C3D,
  0x8C3E, 0x8C45, 0x8C47, 0x8C49, 0x8C4B, 0x8C4F, 0x8C51, 0x8C53,
  0x8C54, 0x8C57, 0x8C58, 0x8C5B, 0x8C5D, 0x8C59, 0x8C63, 0x8C64,
  0x8C66, 0x8C68, 0x8C69, 0x8C6D, 0x8C73, 0x8C75, 0x8C76, 0x8C7B,
  0x8C7E, 0x8C86, 0x8C87, 0x8C8B, 0x8C90, 0x8C92, 0x8C93, 0x8C99,
  0x8C9B, 0x8C9C, 0x8CA4, 0x8CB9, 0x8CBA, 0x8CC5, 0x8CC6, 0x8CC9,
  0x8CCB, 0x8CCF, 0x8CD6, 0x8CD5, 0x8CD9, 0x8CDD, 0x8CE1, 0x8CE8,
  0x8CEC, 0x8CEF, 0x8CF0, 0x8CF2, 0x8CF5, 0x8CF7, 0x8CF8, 0x8CFE,
  0x8CFF, 0x8D01, 0x8D03, 0x8D09, 0x8D12, 0x8D17, 0x8D1B, 0x8D65,
  0x8D69, 0x8D6C, 0x8D6E, 0x8D7F, 0x8D82, 0x8D84, 0x8D88, 0x8D8D,
  0x8D90, 0x8D91, 0x8D95, 0x8D9E, 0x8D9F, 0x8DA0, 0x8DA6, 0x8DAB,
  0x8DAC, 0x8DAF, 0x8DB2, 0x8DB5, 0x8DB7, 0x8DB9, 0x8DBB, 0x8DC0,
  0x8DC5, 0x8DC6, 0x8DC7, 0x8DC8, 0x8DCA, 0x8DCE, 0x8DD1, 0x8DD4,
  0x8DD5, 0x8DD7, 0x8DD9, 0x8DE4, 0x8DE5, 0x8DE7, 0x8DEC, 0x8DF0,
  0x8DBC, 0x8DF1, 0x8DF2, 0x8DF4, 0x8DFD, 0x8E01, 0x8E04, 0x8E05,
  0x8E06, 0x8E0B, 0x8E11, 0x8E14, 0x8E16, 0x8E20, 0x8E21, 0x8E22,
  0x8E23, 0x8E26, 0x8E27, 0x8E31, 0x8E33, 0x8E36, 0x8E37, 0x8E38,
  0x8E39, 0x8E3D, 0x8E40, 0x8E41, 0x8E4B, 0x8E4D, 0x8E4E, 0x8E4F,
  0x8E54, 0x8E5B, 0x8E5C, 0x8E5D, 0x8E5E, 0x8E61, 0x8E62, 0x8E69,
  0x8E6C, 0x8E6D, 0x8E6F, 0x8E70, 0x8E71, 0x8E79, 0x8E7A, 0x8E7B,
  0x8E82, 0x8E83, 0x8E89, 0x8E90, 0x8E92, 0x8E95, 0x8E9A, 0x8E9B,
  0x8E9D, 0x8E9E, 0x8EA2, 0x8EA7, 0x8EA9, 0x8EAD, 0x8EAE, 0x8EB3,
  0x8EB5, 0x8EBA, 0x8EBB, 0x8EC0, 0x8EC1, 0x8EC3, 0x8EC4, 0x8EC7,
  0x8ECF, 0x8ED1, 0x8ED4, 0x8EDC, 0x8EE8, 0x8EEE, 0x8EF0, 0x8EF1,
  0x8EF7, 0x8EF9, 0x8EFA, 0x8EED, 0x8F00, 0x8F02, 0x8F07, 0x8F08,
  0x8F0F, 0x8F10, 0x8F16, 0x8F17, 0x8F18, 0x8F1E, 0x8F20, 0x8F21,
  0x8F23, 0x8F25, 0x8F27, 0x8F28, 0x8F2C, 0x8F2D, 0x8F2E, 0x8F34,
  0x8F35, 0x8F36, 0x8F37, 0x8F3A, 0x8F40, 0x8F41, 0x8F43, 0x8F47,
  0x8F4F, 0x8F51, 0x8F52, 0x8F53, 0x8F54, 0x8F55, 0x8F58, 0x8F5D,
  0x8F5E, 0x8F65, 0x8F9D, 0x8FA0, 0x8FA1, 0x8FA4, 0x8FA5, 0x8FA6,
  0x8FB5, 0x8FB6, 0x8FB8, 0x8FBE, 0x8FC0, 0x8FC1, 0x8FC6, 0x8FCA,
  0x8FCB, 0x8FCD, 0x8FD0, 0x8FD2, 0x8FD3, 0x8FD5, 0x8FE0, 0x8FE3,
  0x8FE4, 0x8FE8, 0x8FEE, 0x8FF1, 0x8FF5, 0x8FF6, 0x8FFB, 0x8FFE,
  0x9002, 0x9004, 0x9008, 0x900C, 0x9018, 0x901B, 0x9028, 0x9029,
  0x902F, 0x902A, 0x902C, 0x902D, 0x9033, 0x9034, 0x9037, 0x903F,
  0x9043, 0x9044, 0x904C, 0x905B, 0x905D, 0x9062, 0x9066, 0x9067,
  0x906C, 0x9070, 0x9074, 0x9079, 0x9085, 0x9088, 0x908B, 0x908C,
  0x908E, 0x9090, 0x9095, 0x9097, 0x9098, 0x9099, 0x909B, 0x90A0,
  0x90A1, 0x90A2, 0x90A5, 0x90B0, 0x90B2, 0x90B3, 0x90B4, 0x90B6,
  0x90BD, 0x90CC, 0x90BE, 0x90C3, 0x90C4, 0x90C5, 0x90C7, 0x90C8,
  0x90D5, 0x90D7, 0x90D8, 0x90D9, 0x90DC, 0x90DD, 0x90DF, 0x90E5,
  0x90D2, 0x90F6, 0x90EB, 0x90EF, 0x90F0, 0x90F4, 0x90FE, 0x90FF,
  0x9100, 0x9104, 0x9105, 0x9106, 0x9108, 0x910D, 0x9110, 0x9114,
  0x9116, 0x9117, 0x9118, 0x911A, 0x911C, 0x911E, 0x9120, 0x9125,
  0x9122, 0x9123, 0x9127, 0x9129, 0x912E, 0x912F, 0x9131, 0x9134,
  0x9136, 0x9137, 0x9139, 0x913A, 0x913C, 0x913D, 0x9143, 0x9147,
  0x9148, 0x914F, 0x9153, 0x9157, 0x9159, 0x915A, 0x915B, 0x9161,
  0x9164, 0x9167, 0x916D, 0x9174, 0x9179, 0x917A, 0x917B, 0x9181,
  0x9183, 0x9185, 0x9186, 0x918A, 0x918E, 0x9191, 0x9193, 0x9194,
  0x9195, 0x9198, 0x919E, 0x91A1, 0x91A6, 0x91A8, 0x91AC, 0x91AD,
  0x91AE, 0x91B0, 0x91B1, 0x91B2, 0x91B3, 0x91B6, 0x91BB, 0x91BC,
  0x91BD, 0x91BF, 0x91C2, 0x91C3, 0x91C5, 0x91D3, 0x91D4, 0x91D7,
  0x91D9, 0x91DA, 0x91DE, 0x91E4, 0x91E5, 0x91E9, 0x91EA, 0x91EC,
  0x91ED, 0x91EE, 0x91EF, 0x91F0, 0x91F1, 0x91F7, 0x91F9, 0x91FB,
  0x91FD, 0x9200, 0x9201, 0x9204, 0x9205, 0x9206, 0x9207, 0x9209,
  0x920A, 0x920C, 0x9210, 0x9212, 0x9213, 0x9216, 0x9218, 0x921C,
  0x921D, 0x9223, 0x9224, 0x9225, 0x9226, 0x9228, 0x922E, 0x922F,
  0x9230, 0x9233, 0x9235, 0x9236, 0x9238, 0x9239, 0x923A, 0x923C,
  0x923E, 0x9240, 0x9242, 0x9243, 0x9246, 0x9247, 0x924A, 0x924D,
  0x924E, 0x924F, 0x9251, 0x9258, 0x9259, 0x925C, 0x925D, 0x9260,
  0x9261, 0x9265, 0x9267, 0x9268, 0x9269, 0x926E, 0x926F, 0x9270,
  0x9275, 0x9276, 0x9277, 0x9278, 0x9279, 0x927B, 0x927C, 0x927D,
  0x927F, 0x9288, 0x9289, 0x928A, 0x928D, 0x928E, 0x9292, 0x9297,
  0x9299, 0x929F, 0x92A0, 0x92A4, 0x92A5, 0x92A7, 0x92A8, 0x92AB,
  0x92AF, 0x92B2, 0x92B6, 0x92B8, 0x92BA, 0x92BB, 0x92BC, 0x92BD,
  0x92BF, 0x92C0, 0x92C1, 0x92C2, 0x92C3, 0x92C5, 0x92C6, 0x92C7,
  0x92C8, 0x92CB, 0x92CC, 0x92CD, 0x92CE, 0x92D0, 0x92D3, 0x92D5,
  0x92D7, 0x92D8, 0x92D9, 0x92DC, 0x92DD, 0x92DF, 0x92E0, 0x92E1,
  0x92E3, 0x92E5, 0x92E7, 0x92E8, 0x92EC, 0x92EE, 0x92F0, 0x92F9,
  0x92FB, 0x92FF, 0x9300, 0x9302, 0x9308, 0x930D, 0x9311, 0x9314,
  0x9315, 0x931C, 0x931D, 0x931E, 0x931F, 0x9321, 0x9324, 0x9325,
  0x9327, 0x9329, 0x932A, 0x9333, 0x9334, 0x9336, 0x9337, 0x9347,
  0x9348, 0x9349, 0x9350, 0x9351, 0x9352, 0x9355, 0x9357, 0x9358,
  0x935A, 0x935E, 0x9364, 0x9365, 0x9367, 0x9369, 0x936A, 0x936D,
  0x936F, 0x9370, 0x9371, 0x9373, 0x9374, 0x9376, 0x937A, 0x937D,
  0x937F, 0x9380, 0x9381, 0x9382, 0x9388, 0x938A, 0x938B, 0x938D,
  0x938F, 0x9392, 0x9395, 0x9398, 0x939B, 0x939E, 0x93A1, 0x93A3,
  0x93A4, 0x93A6, 0x93A8, 0x93AB, 0x93B4, 0x93B5, 0x93B6, 0x93BA,
  0x93A9, 0x93C1, 0x93C4, 0x93C5, 0x93C6, 0x93C7, 0x93C9, 0x93CA,
  0x93CB, 0x93CC, 0x93CD, 0x93D3, 0x93D9, 0x93DC, 0x93DE, 0x93DF,
  0x93E2, 0x93E6, 0x93E7, 0x93F9, 0x93F7, 0x93F8, 0x93FA, 0x93FB,
  0x93FD, 0x9401, 0x9402, 0x9404, 0x9408, 0x9409, 0x940D, 0x940E,
  0x940F, 0x9415, 0x9416, 0x9417, 0x941F, 0x942E, 0x942F, 0x9431,
  0x9432, 0x9433, 0x9434, 0x943B, 0x943F, 0x943D, 0x9443, 0x9445,
  0x9448, 0x944A, 0x944C, 0x9455, 0x9459, 0x945C, 0x945F, 0x9461,
  0x9463, 0x9468, 0x946B, 0x946D, 0x946E, 0x946F, 0x9471, 0x9472,
  0x9484, 0x9483, 0x9578, 0x9579, 0x957E, 0x9584, 0x9588, 0x958C,
  0x958D, 0x958E, 0x959D, 0x959E, 0x959F, 0x95A1, 0x95A6, 0x95A9,
  0x95AB, 0x95AC, 0x95B4, 0x95B6, 0x95BA, 0x95BD, 0x95BF, 0x95C6,
  0x95C8, 0x95C9, 0x95CB, 0x95D0, 0x95D1, 0x95D2, 0x95D3, 0x95D9,
  0x95DA, 0x95DD, 0x95DE, 0x95DF, 0x95E0, 0x95E4, 0x95E6, 0x961D,
  0x961E, 0x9622, 0x9624, 0x9625, 0x9626, 0x962C, 0x9631, 0x9633,
  0x9637, 0x9638, 0x9639, 0x963A, 0x963C, 0x963D, 0x9641, 0x9652,
  0x9654, 0x9656, 0x9657, 0x9658, 0x9661, 0x966E, 0x9674, 0x967B,
  0x967C, 0x967E, 0x967F, 0x9681, 0x9682, 0x9683, 0x9684, 0x9689,
  0x9691, 0x9696, 0x969A, 0x969D, 0x969F, 0x96A4, 0x96A5, 0x96A6,
  0x96A9, 0x96AE, 0x96AF, 0x96B3, 0x96BA, 0x96CA, 0x96D2, 0x5DB2,
  0x96D8, 0x96DA, 0x96DD, 0x96DE, 0x96DF, 0x96E9, 0x96EF, 0x96F1,
  0x96FA, 0x9702, 0x9703, 0x9705, 0x9709, 0x971A, 0x971B, 0x971D,
  0x9721, 0x9722, 0x9723, 0x9728, 0x9731, 0x9733, 0x9741, 0x9743,
  0x974A, 0x974E, 0x974F, 0x9755, 0x9757, 0x9758, 0x975A, 0x975B,
  0x9763, 0x9767, 0x976A, 0x976E, 0x9773, 0x9776, 0x9777, 0x9778,
  0x977B, 0x977D, 0x977F, 0x9780, 0x9789, 0x9795, 0x9796, 0x9797,
  0x9799, 0x979A, 0x979E, 0x979F, 0x97A2, 0x97AC, 0x97AE, 0x97B1,
  0x97B2, 0x97B5, 0x97B6, 0x97B8, 0x97B9, 0x97BA, 0x97BC, 0x97BE,
  0x97BF, 0x97C1, 0x97C4, 0x97C5, 0x97C7, 0x97C9, 0x97CA, 0x97CC,
  0x97CD, 0x97CE, 0x97D0, 0x97D1, 0x97D4, 0x97D7, 0x97D8, 0x97D9,
  0x97DD, 0x97DE, 0x97E0, 0x97DB, 0x97E1, 0x97E4, 0x97EF, 0x97F1,
  0x97F4, 0x97F7, 0x97F8, 0x97FA, 0x9807, 0x980A, 0x9819, 0x980D,
  0x980E, 0x9814, 0x9816, 0x981C, 0x981E, 0x9820, 0x9823, 0x9826,
  0x982B, 0x982E, 0x982F, 0x9830, 0x9832, 0x9833, 0x9835, 0x9825,
  0x983E, 0x9844, 0x9847, 0x984A, 0x9851, 0x9852, 0x9853, 0x9856,
  0x9857, 0x9859, 0x985A, 0x9862, 0x9863, 0x9865, 0x9866, 0x986A,
  0x986C, 0x98AB, 0x98AD, 0x98AE, 0x98B0, 0x98B4, 0x98B7, 0x98B8,
  0x98BA, 0x98BB, 0x98BF, 0x98C2, 0x98C5, 0x98C8, 0x98CC, 0x98E1,
  0x98E3, 0x98E5, 0x98E6, 0x98E7, 0x98EA, 0x98F3, 0x98F6, 0x9902,
  0x9907, 0x9908, 0x9911, 0x9915, 0x9916, 0x9917, 0x991A, 0x991B,
  0x991C, 0x991F, 0x9922, 0x9926, 0x9927, 0x992B, 0x9931, 0x9932,
  0x9933, 0x9934, 0x9935, 0x9939, 0x993A, 0x993B, 0x993C, 0x9940,
  0x9941, 0x9946, 0x9947, 0x9948, 0x994D, 0x994E, 0x9954, 0x9958,
  0x9959, 0x995B, 0x995C, 0x995E, 0x995F, 0x9960, 0x999B, 0x999D,
  0x999F, 0x99A6, 0x99B0, 0x99B1, 0x99B2, 0x99B5, 0x99B9, 0x99BA,
  0x99BD, 0x99BF, 0x99C3, 0x99C9, 0x99D3, 0x99D4, 0x99D9, 0x99DA,
  0x99DC, 0x99DE, 0x99E7, 0x99EA, 0x99EB, 0x99EC, 0x99F0, 0x99F4,
  0x99F5, 0x99F9, 0x99FD, 0x99FE, 0x9A02, 0x9A03, 0x9A04, 0x9A0B,
  0x9A0C, 0x9A10, 0x9A11, 0x9A16, 0x9A1E, 0x9A20, 0x9A22, 0x9A23,
  0x9A24, 0x9A27, 0x9A2D, 0x9A2E, 0x9A33, 0x9A35, 0x9A36, 0x9A38,
  0x9A47, 0x9A41, 0x9A44, 0x9A4A, 0x9A4B, 0x9A4C, 0x9A4E, 0x9A51,
  0x9A54, 0x9A56, 0x9A5D, 0x9AAA, 0x9AAC, 0x9AAE, 0x9AAF, 0x9AB2,
  0x9AB4, 0x9AB5, 0x9AB6, 0x9AB9, 0x9ABB, 0x9ABE, 0x9ABF, 0x9AC1,
  0x9AC3, 0x9AC6, 0x9AC8, 0x9ACE, 0x9AD0, 0x9AD2, 0x9AD5, 0x9AD6,
  0x9AD7, 0x9ADB, 0x9ADC, 0x9AE0, 0x9AE4, 0x9AE5, 0x9AE7, 0x9AE9,
  0x9AEC, 0x9AF2, 0x9AF3, 0x9AF5, 0x9AF9, 0x9AFA, 0x9AFD, 0x9AFF,
  0x9B00, 0x9B01, 0x9B02, 0x9B03, 0x9B04, 0x9B05, 0x9B08, 0x9B09,
  0x9B0B, 0x9B0C, 0x9B0D, 0x9B0E, 0x9B10, 0x9B12, 0x9B16, 0x9B19,
  0x9B1B, 0x9B1C, 0x9B20, 0x9B26, 0x9B2B, 0x9B2D, 0x9B33, 0x9B34,
  0x9B35, 0x9B37, 0x9B39, 0x9B3A, 0x9B3D, 0x9B48, 0x9B4B, 0x9B4C,
  0x9B55, 0x9B56, 0x9B57, 0x9B5B, 0x9B5E, 0x9B61, 0x9B63, 0x9B65,
  0x9B66, 0x9B68, 0x9B6A, 0x9B6B, 0x9B6C, 0x9B6D, 0x9B6E, 0x9B73,
  0x9B75, 0x9B77, 0x9B78, 0x9B79, 0x9B7F, 0x9B80, 0x9B84, 0x9B85,
  0x9B86, 0x9B87, 0x9B89, 0x9B8A, 0x9B8B, 0x9B8D, 0x9B8F, 0x9B90,
  0x9B94, 0x9B9A, 0x9B9D, 0x9B9E, 0x9BA6, 0x9BA7, 0x9BA9, 0x9BAC,
  0x9BB0, 0x9BB1, 0x9BB2, 0x9BB7, 0x9BB8, 0x9BBB, 0x9BBC, 0x9BBE,
  0x9BBF, 0x9BC1, 0x9BC7, 0x9BC8, 0x9BCE, 0x9BD0, 0x9BD7, 0x9BD8,
  0x9BDD, 0x9BDF, 0x9BE5, 0x9BE7, 0x9BEA, 0x9BEB, 0x9BEF, 0x9BF3,
  0x9BF7, 0x9BF8, 0x9BF9, 0x9BFA, 0x9BFD, 0x9BFF, 0x9C00, 0x9C02,
  0x9C0B, 0x9C0F, 0x9C11, 0x9C16, 0x9C18, 0x9C19, 0x9C1A, 0x9C1C,
  0x9C1E, 0x9C22, 0x9C23, 0x9C26, 0x9C27, 0x9C28, 0x9C29, 0x9C2A,
  0x9C31, 0x9C35, 0x9C36, 0x9C37, 0x9C3D, 0x9C41, 0x9C43, 0x9C44,
  0x9C45, 0x9C49, 0x9C4A, 0x9C4E, 0x9C4F, 0x9C50, 0x9C53, 0x9C54,
  0x9C56, 0x9C58, 0x9C5B, 0x9C5D, 0x9C5E, 0x9C5F, 0x9C63, 0x9C69,
  0x9C6A, 0x9C5C, 0x9C6B, 0x9C68, 0x9C6E, 0x9C70, 0x9C72, 0x9C75,
  0x9C77, 0x9C7B, 0x9CE6, 0x9CF2, 0x9CF7, 0x9CF9, 0x9D0B, 0x9D02,
  0x9D11, 0x9D17, 0x9D18, 0x9D1C, 0x9D1D, 0x9D1E, 0x9D2F, 0x9D30,
  0x9D32, 0x9D33, 0x9D34, 0x9D3A, 0x9D3C, 0x9D45, 0x9D3D, 0x9D42,
  0x9D43, 0x9D47, 0x9D4A, 0x9D53, 0x9D54, 0x9D5F, 0x9D63, 0x9D62,
  0x9D65, 0x9D69, 0x9D6A, 0x9D6B, 0x9D70, 0x9D76, 0x9D77, 0x9D7B,
  0x9D7C, 0x9D7E, 0x9D83, 0x9D84, 0x9D86, 0x9D8A, 0x9D8D, 0x9D8E,
  0x9D92, 0x9D93, 0x9D95, 0x9D96, 0x9D97, 0x9D98, 0x9DA1, 0x9DAA,
  0x9DAC, 0x9DAE, 0x9DB1, 0x9DB5, 0x9DB9, 0x9DBC, 0x9DBF, 0x9DC3,
  0x9DC7, 0x9DC9, 0x9DCA, 0x9DD4, 0x9DD5, 0x9DD6, 0x9DD7, 0x9DDA,
  0x9DDE, 0x9DDF, 0x9DE0, 0x9DE5, 0x9DE7, 0x9DE9, 0x9DEB, 0x9DEE,
  0x9DF0, 0x9DF3, 0x9DF4, 0x9DFE, 0x9E0A, 0x9E02, 0x9E07, 0x9E0E,
  0x9E10, 0x9E11, 0x9E12, 0x9E15, 0x9E16, 0x9E19, 0x9E1C, 0x9E1D,
  0x9E7A, 0x9E7B, 0x9E7C, 0x9E80, 0x9E82, 0x9E83, 0x9E84, 0x9E85,
  0x9E87, 0x9E8E, 0x9E8F, 0x9E96, 0x9E98, 0x9E9B, 0x9E9E, 0x9EA4,
  0x9EA8, 0x9EAC, 0x9EAE, 0x9EAF, 0x9EB0, 0x9EB3, 0x9EB4, 0x9EB5,
  0x9EC6, 0x9EC8, 0x9ECB, 0x9ED5, 0x9EDF, 0x9EE4, 0x9EE7, 0x9EEC,
  0x9EED, 0x9EEE, 0x9EF0, 0x9EF1, 0x9EF2, 0x9EF5, 0x9EF8, 0x9EFF,
  0x9F02, 0x9F03, 0x9F09, 0x9F0F, 0x9F10, 0x9F11, 0x9F12, 0x9F14,
  0x9F16, 0x9F17, 0x9F19, 0x9F1A, 0x9F1B, 0x9F1F, 0x9F22, 0x9F26,
  0x9F2A, 0x9F2B, 0x9F2F, 0x9F31, 0x9F32, 0x9F34, 0x9F37, 0x9F39,
  0x9F3A, 0x9F3C, 0x9F3D, 0x9F3F, 0x9F41, 0x9F43, 0x9F44, 0x9F45,
  0x9F46, 0x9F47, 0x9F53, 0x9F55, 0x9F56, 0x9F57, 0x9F58, 0x9F5A,
  0x9F5D, 0x9F5E, 0x9F68, 0x9F69, 0x9F6D, 0x9F6E, 0x9F6F, 0x9F70,
  0x9F71, 0x9F73, 0x9F75, 0x9F7A, 0x9F7D, 0x9F8F, 0x9F90, 0x9F91,
  0x9F92, 0x9F94, 0x9F96, 0x9F97, 0x9F9E, 0x9FA1, 0x9FA2, 0x9FA3,
  0x9FA5,
  // [   108,   118] -v # seg 1 at pos 5801
  0x02D8, 0x02C7, 0x00B8, 0x02D9, 0x02DD, 0x00AF, 0x02DB, 0x02DA,
  0xFF5E, 0x0384, 0x0385,
  // [   127,   129] -v # seg 3 at pos 5812
  0x00A1, 0x00A6, 0x00BF,
  // [   168,   174] -v # seg 5 at pos 5815
  0x00BA, 0x00AA, 0x00A9, 0x00AE, 0x2122, 0x00A4, 0x2116,
  // [   534,   561] -v # seg 7 at pos 5822
  0x0386, 0x0388, 0x0389, 0x038A, 0x03AA,  RCHAR, 0x038C,  RCHAR,
  0x038E, 0x03AB,  RCHAR, 0x038F,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
  0x03AC, 0x03AD, 0x03AE, 0x03AF, 0x03CA, 0x0390, 0x03CC, 0x03C2,
  0x03CD, 0x03CB, 0x03B0, 0x03CE,
  // [   608,   609] -> [0x040E,0x040F] # seg 10
  // [   645,   655] -> [0x0452,0x045C] # seg 12
  // [   752,   767] -v # seg 15 at pos 5850
  0x00C6, 0x0110,  RCHAR, 0x0126,  RCHAR, 0x0132,  RCHAR, 0x0141,
  0x013F,  RCHAR, 0x014A, 0x00D8, 0x0152,  RCHAR, 0x0166, 0x00DE,
  // [   784,   799] -v # seg 17 at pos 5866
  0x00E6, 0x0111, 0x00F0, 0x0127, 0x0131, 0x0133, 0x0138, 0x0142,
  0x0140, 0x0149, 0x014B, 0x00F8, 0x0153, 0x00DF, 0x0167, 0x00FE,
  // [   846,   932] -v # seg 19 at pos 5882
  0x00C1, 0x00C0, 0x00C4, 0x00C2, 0x0102, 0x01CD, 0x0100, 0x0104,
  0x00C5, 0x00C3, 0x0106, 0x0108, 0x010C, 0x00C7, 0x010A, 0x010E,
  0x00C9, 0x00C8, 0x00CB, 0x00CA, 0x011A, 0x0116, 0x0112, 0x0118,
   RCHAR, 0x011C, 0x011E, 0x0122, 0x0120, 0x0124, 0x00CD, 0x00CC,
  0x00CF, 0x00CE, 0x01CF, 0x0130, 0x012A, 0x012E, 0x0128, 0x0134,
  0x0136, 0x0139, 0x013D, 0x013B, 0x0143, 0x0147, 0x0145, 0x00D1,
  0x00D3, 0x00D2, 0x00D6, 0x00D4, 0x01D1, 0x0150, 0x014C, 0x00D5,
  0x0154, 0x0158, 0x0156, 0x015A, 0x015C, 0x0160, 0x015E, 0x0164,
  0x0162, 0x00DA, 0x00D9, 0x00DC, 0x00DB, 0x016C, 0x01D3, 0x0170,
  0x016A, 0x0172, 0x016E, 0x0168, 0x01D7, 0x01DB, 0x01D9, 0x01D5,
  0x0174, 0x00DD, 0x0178, 0x0176, 0x0179, 0x017D, 0x017B,
  // [   940,  1026] -v # seg 21 at pos 5969
  0x00E1, 0x00E0, 0x00E4, 0x00E2, 0x0103, 0x01CE, 0x0101, 0x0105,
  0x00E5, 0x00E3, 0x0107, 0x0109, 0x010D, 0x00E7, 0x010B, 0x010F,
  0x00E9, 0x00E8, 0x00EB, 0x00EA, 0x011B, 0x0117, 0x0113, 0x0119,
  0x01F5, 0x011D, 0x011F,  RCHAR, 0x0121, 0x0125, 0x00ED, 0x00EC,
  0x00EF, 0x00EE, 0x01D0,  RCHAR, 0x012B, 0x012F, 0x0129, 0x0135,
  0x0137, 0x013A, 0x013E, 0x013C, 0x0144, 0x0148, 0x0146, 0x00F1,
  0x00F3, 0x00F2, 0x00F6, 0x00F4, 0x01D2, 0x0151, 0x014D, 0x00F5,
  0x0155, 0x0159, 0x0157, 0x015B, 0x015D, 0x0161, 0x015F, 0x0165,
  0x0163, 0x00FA, 0x00F9, 0x00FC, 0x00FB, 0x016D, 0x01D4, 0x0171,
  0x016B, 0x0173, 0x016F, 0x0169, 0x01D8, 0x01DC, 0x01DA, 0x01D6,
  0x0175, 0x00FD, 0x00FF, 0x0177, 0x017A, 0x017E, 0x017C,
};

// Reverse (values >= 8836 are JIS X 0212)
const unsigned short CodePageJISX_R[22085] = {
  // hot segments (indexes into segment table)
  2, 93, 95,
  // number of segments
  107,
  // segment table
  0x0000, 0x005C, 0x005D, 0x007E, 0x007F, 0x00A1, 0x017F, 0x01CD,
  0x01DD, 0x01F5, 0x01F6, 0x02C7, 0x02C8, 0x02D8, 0x02DE, 0x0384,
  0x0391, 0x03A2, 0x03A3, 0x03B1, 0x03C2, 0x03CF, 0x0401, 0x0402,
  0x040D, 0x040E, 0x0416, 0x0430, 0x0436, 0x0450, 0x0451, 0x0452,
  0x045D, 0x045E, 0x0460, 0x2010, 0x2027, 0x2030, 0x2034, 0x203B,
  0x203F, 0x2103, 0x2104, 0x2116, 0x2117, 0x2122, 0x2123, 0x212B,
  0x212C, 0x2190, 0x2194, 0x21D2, 0x21D5, 0x2200, 0x2213, 0x221A,
  0x222D, 0x2234, 0x2236, 0x223D, 0x223E, 0x2252, 0x2253, 0x2260,
  0x226C, 0x2282, 0x2288, 0x22A5, 0x22A6, 0x2312, 0x2313, 0x2500,
  0x2504, 0x250C, 0x2543, 0x254B, 0x254C, 0x25A0, 0x25A2, 0x25B2,
  0x25B4, 0x25BC, 0x25BE, 0x25C6, 0x25D0, 0x25EF, 0x25F0, 0x2605,
  0x2607, 0x2640, 0x2643, 0x266A, 0x2670, 0x3000, 0x3100, 0x4E00,
  0xA000, 0xFF01, 0xFF10, 0xFF1A, 0xFF21, 0xFF3B, 0xFF41, 0xFF5B,
  0xFF5F, 0xFFE0, 0xFFE6,
  // compressed segments
   RCHAR,     31,  RCHAR,   8952,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   9800,  RCHAR,   8945,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
     470,  RCHAR,  RCHAR,    502,  RCHAR,  RCHAR,    570,   9433,
   RCHAR,  RCHAR,    571,    612,    619,  RCHAR,    618,   9481,
   RCHAR,   9492,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,     77,  RCHAR,   9010,  RCHAR,   9008,  RCHAR,    175,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,    163,  RCHAR,    159,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,    154,  RCHAR,    155,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,    679,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,    187,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,    203,  RCHAR,    220,  RCHAR,    252,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,
  // uncompressed segments
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21248,  RCHAR,  21470,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21486,  RCHAR,  21492,
   RCHAR,  RCHAR,  21505,  RCHAR,  21519,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  21532,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  21540,  RCHAR,  21563,  RCHAR,  21567,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  21571,  RCHAR,  21575,  RCHAR,  21578,  RCHAR,  21597,
   RCHAR,  21616,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21618,
   RCHAR,  21630,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  21636,
   RCHAR,  21640,  RCHAR,  RCHAR,  RCHAR,  21695,  RCHAR,  21697,
   RCHAR,  21699,  RCHAR,  21701,  RCHAR,  RCHAR,  RCHAR,  21711,
   RCHAR,  21713,  RCHAR,  21716,  RCHAR,      0,  RCHAR,    256,
   RCHAR,  21722,  RCHAR,  21737,  RCHAR,  21744,  RCHAR,  21750,
   RCHAR,  21754,  RCHAR,
  // [0x005C,0x005C] -> [    31,    31] # seg 1
  // [0x007E,0x007E] -> [  8952,  8952] # seg 3
  // [0x0391,0x03A1] -> [   470,   486] # seg 16
  // [0x03B1,0x03C1] -> [   502,   518] # seg 19
  // [0x0401,0x0401] -> [   570,   570] # seg 22
  // [0x0416,0x042F] -> [   571,   596] # seg 26
  // [0x0436,0x044F] -> [   619,   644] # seg 28
  // [0x0451,0x0451] -> [   618,   618] # seg 30
  // [0x3000,0x30FF] -v # seg 93 at pos 0
       0,      1,      2,     22,  RCHAR,     24,     25,     26,
      49,     50,     51,     52,     53,     54,     55,     56,
      57,     58,    102,    107,     43,     44,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,     32,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,    282,    283,    284,    285,    286,    287,    288,
     289,    290,    291,    292,    293,    294,    295,    296,
     297,    298,    299,    300,    301,    302,    303,    304,
     305,    306,    307,    308,    309,    310,    311,    312,
     313,    314,    315,    316,    317,    318,    319,    320,
     321,    322,    323,    324,    325,    326,    327,    328,
     329,    330,    331,    332,    333,    334,    335,    336,
     337,    338,    339,    340,    341,    342,    343,    344,
     345,    346,    347,    348,    349,    350,    351,    352,
     353,    354,    355,    356,    357,    358,    359,    360,
     361,    362,    363,    364,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,     10,     11,     20,     21,  RCHAR,
   RCHAR,    376,    377,    378,    379,    380,    381,    382,
     383,    384,    385,    386,    387,    388,    389,    390,
     391,    392,    393,    394,    395,    396,    397,    398,
     399,    400,    401,    402,    403,    404,    405,    406,
     407,    408,    409,    410,    411,    412,    413,    414,
     415,    416,    417,    418,    419,    420,    421,    422,
     423,    424,    425,    426,    427,    428,    429,    430,
     431,    432,    433,    434,    435,    436,    437,    438,
     439,    440,    441,    442,    443,    444,    445,    446,
     447,    448,    449,    450,    451,    452,    453,    454,
     455,    456,    457,    458,    459,    460,    461,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,      5,     27,     18,     19,  RCHAR,
  // [0x4E00,0x9FFF] -v # seg 95 at pos 256
    1485,   3285,  10246,   2560,  10247,  10248,  RCHAR,   4039,
    2795,   2459,   2794,   1625,  10249,   3811,   4166,  RCHAR,
    4419,   1518,  10250,  RCHAR,   1769,   4420,   2917,   4639,
    1933,   3879,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   2796,  10251,
   RCHAR,   4259,  RCHAR,  10252,  10253,  RCHAR,   3887,  RCHAR,
   10254,  RCHAR,   4421,  10255,  RCHAR,   3265,  10256,  10257,
   10258,   4422,   2063,  RCHAR,  RCHAR,  10259,   4423,  RCHAR,
    1846,   3211,  RCHAR,   2608,   4424,  RCHAR,  RCHAR,   4425,
   10260,  10261,   4426,   3592,  10262,   1934,  RCHAR,  10263,
   RCHAR,  RCHAR,  RCHAR,   3594,  RCHAR,   3544,   2196,   3966,
   RCHAR,  10264,  RCHAR,  RCHAR,  RCHAR,   6808,   4427,   2797,
    4428,   1618,  10265,  RCHAR,  10266,   2042,   2241,   4114,
   RCHAR,  RCHAR,   4987,  10267,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   10268,  10269,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4215,  RCHAR,   3570,  10270,  10271,  RCHAR,  RCHAR,
   RCHAR,  10272,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   1790,  10273,
    1900,  RCHAR,   4429,  RCHAR,  RCHAR,   4430,   4256,  RCHAR,
    4164,   3079,   4432,   2529,   3560,  10274,   4435,  RCHAR,
   RCHAR,   1533,   2224,  RCHAR,   2223,   1479,  10275,  10276,
    4366,   4365,  RCHAR,   2368,   1410,  10277,   4436,   4437,
    4438,   3967,   4439,  RCHAR,   2243,   1480,   4029,  RCHAR,
    1971,  RCHAR,  RCHAR,   1972,   1973,   3355,   4257,  10278,
    4440,  RCHAR,  RCHAR,   4441,  RCHAR,  RCHAR,   4442,  RCHAR,
   RCHAR,  10279,   2864,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    2657,   2865,   4447,  10280,   4445,  RCHAR,   4446,   1935,
   RCHAR,  RCHAR,   2352,   1677,  RCHAR,   4444,   4443,   3862,
   10281,  RCHAR,  RCHAR,  RCHAR,   2481,   2480,   3131,   4448,
    3812,   2984,  10282,  10283,  RCHAR,     23,   4449,   4451,
   10284,  10285,  10286,   3170,   4294,   1451,  RCHAR,  RCHAR,
   10287,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4450,   1627,  10288,
    2009,  10289,   3266,  10290,  RCHAR,  10291,   2146,   4452,
   RCHAR,  RCHAR,  RCHAR,   3575,  RCHAR,  10292,  10293,  10294,
   10295,   1860,  10296,  10297,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   10298,   4453,   1452,  10299,  10300,   2225,   1861,   3849,
    3683,   1936,  10301,  RCHAR,  RCHAR,  10302,  10303,  10304,
   RCHAR,  10305,   1678,  RCHAR,   4488,   3416,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  10306,   3647,
    4455,  10307,  RCHAR,  10309,   3693,  10310,   4295,  10311,
    2832,  10312,   2482,  10313,   2530,   1629,  10314,  RCHAR,
   10315,  RCHAR,  10316,   3338,  RCHAR,  RCHAR,   3197,   4459,
   10317,  10318,  RCHAR,  10319,  10320,   1453,   3356,   2658,
    2369,   4139,  10321,   3147,  10322,   1628,  10323,   4458,
   10324,   4165,   4454,   4456,   2427,   4457,   4891,  10325,
   10308,  RCHAR,  RCHAR,  10326,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4465,  10327,  RCHAR,  10328,  RCHAR,  10329,   4468,
    4466,  10330,  RCHAR,   1631,  RCHAR,   3880,   4460,  10331,
   10332,  10333,  10334,   4464,   2244,  10335,  10336,   2483,
   RCHAR,  10337,  10338,   1791,  10339,  10340,   4469,  RCHAR,
    4461,  10341,  10342,   4296,  10343,   2531,  10344,   4462,
   10345,   4467,  10346,  10347,  10348,  RCHAR,   4470,  10349,
    4463,  10350,  10351,   1974,  RCHAR,   1454,  10352,  10353,
    1975,   1630,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4892,  RCHAR,   4036,   3837,   2245,
   RCHAR,  RCHAR,  10354,  RCHAR,  RCHAR,   2834,   4252,  10355,
   RCHAR,  10356,  RCHAR,  10357,  10358,  10359,  10360,   3909,
   10361,  10362,   2091,   3106,   1665,  10363,  10364,  RCHAR,
   10365,  10366,   2682,  10367,  10368,  10369,   4474,  10370,
    4479,   4477,  10371,  RCHAR,   4472,  RCHAR,  RCHAR,   3116,
    4475,  RCHAR,   4478,   4476,  10372,   3914,  RCHAR,   4473,
   10373,   2833,  10374,   4030,   4480,   4481,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   2635,   4494,
   10375,  RCHAR,  10376,   3619,  RCHAR,   3781,   4489,  RCHAR,
    3933,  RCHAR,   1619,  RCHAR,  10377,  10378,   4493,  10379,
   10380,  10381,  RCHAR,  RCHAR,  10382,   4487,   4496,  10383,
   RCHAR,   3057,  10384,   2197,  10385,   3631,  10386,   5960,
   10387,   4495,   3444,  10388,   4484,  RCHAR,   2247,  10389,
   10390,   2246,   4482,  10391,  10392,  10393,  10394,   2595,
   RCHAR,   4490,  10395,   3932,   3240,   4486,   2148,  10396,
    4483,   4491,   4485,   4278,   4492,   4356,  10397,  RCHAR,
   10398,  RCHAR,  10399,  10400,  RCHAR,  10401,   2043,  RCHAR,
   RCHAR,   2147,  RCHAR,  10425,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   10402,  10403,  10404,   4497,  RCHAR,  10405,  10406,   4498,
    4502,   1455,  10407,  RCHAR,  10408,  RCHAR,  10409,   3901,
    4501,  10410,  10411,  10412,  RCHAR,   4500,   4504,  10413,
   RCHAR,  10414,   4503,  RCHAR,   3357,  RCHAR,  RCHAR,  10415,
   10416,  RCHAR,  10417,  10418,  RCHAR,   2149,  10419,  10420,
   RCHAR,  RCHAR,  10421,  RCHAR,   4505,  10422,  RCHAR,  RCHAR,
   10423,  10424,   2574,  RCHAR,   3107,   3358,   2059,  RCHAR,
    4506,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   1901,  RCHAR,  RCHAR,
    4507,  10426,  RCHAR,  10427,  10428,   4509,  10429,  RCHAR,
   RCHAR,  RCHAR,  10430,  RCHAR,  RCHAR,   3968,  10431,  10432,
   10433,   2137,  10434,  10435,  10436,  RCHAR,  10437,  RCHAR,
    2460,   3752,   4508,  10438,  10439,  RCHAR,  10440,  10441,
   10442,  10443,  10444,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  10445,  RCHAR,   2386,   4170,  RCHAR,  10446,
   10447,  RCHAR,   4511,   4514,   4510,   2385,  RCHAR,   2724,
   RCHAR,  10448,  10449,  RCHAR,  RCHAR,  10450,   2092,  RCHAR,
   10451,  RCHAR,   4515,  10452,  10453,   2020,  RCHAR,  10454,
   RCHAR,   4512,   4513,  RCHAR,  10455,   3492,  10456,   3099,
   10457,   1976,  RCHAR,  10458,  10459,   3992,   4516,  RCHAR,
   10460,  RCHAR,   4258,  RCHAR,  10461,  10462,   4517,  10463,
   RCHAR,  RCHAR,  10464,   4520,  10465,   4518,  10466,   3053,
   10467,  10468,  RCHAR,  RCHAR,  RCHAR,   4519,   4521,  10469,
   RCHAR,  10470,  10482,  RCHAR,  RCHAR,   4523,  10471,  RCHAR,
   RCHAR,   4522,  10472,   3893,  RCHAR,  RCHAR,  10473,  RCHAR,
    1902,   4525,   4526,  10474,   1612,  RCHAR,  10475,  10476,
   10477,   4524,  RCHAR,  10478,  10479,  10480,  10481,  RCHAR,
   10483,  RCHAR,   2621,  RCHAR,   4529,   4528,   4527,  10484,
    4471,  10485,   4530,  10486,  10487,  10488,  10489,   2725,
   RCHAR,   4531,  RCHAR,  10490,  RCHAR,  RCHAR,  RCHAR,  10491,
   10492,  RCHAR,   4140,  RCHAR,  10493,  10494,  RCHAR,  10495,
   RCHAR,  10496,   4098,  10497,  10498,  10499,  RCHAR,   4533,
   10500,  10501,   4532,   4535,   4534,  RCHAR,  RCHAR,   4536,
    4537,   1493,  10502,   2182,   2094,   2659,   3286,   1977,
    2985,   2248,  10503,   2333,   4539,   4081,   3421,  10504,
    2532,  RCHAR,   4538,  10505,   4540,  10506,  RCHAR,  10507,
   10508,  RCHAR,   3445,  RCHAR,   1776,  RCHAR,  RCHAR,  10509,
   RCHAR,  RCHAR,   4541,  RCHAR,  10510,   3571,  10511,  RCHAR,
    3027,   4543,   4544,   3677,   2249,   4350,   4545,  RCHAR,
   RCHAR,   1979,  RCHAR,  RCHAR,  RCHAR,   3881,   3123,   2054,
    3404,  RCHAR,  RCHAR,  RCHAR,   2150,  RCHAR,  10512,  RCHAR,
    4546,  RCHAR,   4547,  10513,  10514,   3543,   1566,  RCHAR,
   RCHAR,   4550,   2442,  10515,   4549,   2387,  10516,   4551,
    6563,   4552,   3980,   4553,  RCHAR,   4554,   4555,   2798,
   10517,   2581,  RCHAR,  RCHAR,  RCHAR,  10518,  RCHAR,  RCHAR,
    1792,  10519,   4558,  10520,   4556,   4070,   4557,  RCHAR,
    3817,   4559,   4560,   4561,   3446,  10521,  RCHAR,  RCHAR,
    4565,   4563,   4564,   4562,   2416,   4566,   4115,   4297,
   10522,  RCHAR,  10523,  RCHAR,  10524,   4567,  10525,  10526,
   RCHAR,  RCHAR,  10527,  RCHAR,   2921,   4568,   2689,  RCHAR,
   10528,   4569,  RCHAR,   3287,   4260,   3447,  RCHAR,  10529,
   RCHAR,  10530,  10531,  10532,  RCHAR,  10533,   4642,  RCHAR,
   10534,  RCHAR,  RCHAR,   4570,   7806,   2010,  10535,  RCHAR,
    4571,   4009,  10536,  RCHAR,  RCHAR,  10537,   2703,   3193,
   RCHAR,   4573,   3545,  RCHAR,  RCHAR,   4574,  10538,  RCHAR,
    4575,   1705,  10539,  10540,  10541,   4576,   1980,  10542,
    3521,   1593,   2679,  RCHAR,  RCHAR,   3666,   4577,  RCHAR,
    3448,  10543,  10544,   2866,   4578,  10545,   3865,   2971,
    1787,  RCHAR,   1794,   4579,  RCHAR,  RCHAR,   4581,  RCHAR,
   RCHAR,   2093,  10546,  10547,   4580,  10548,  10549,   4312,
   10550,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   2704,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  10551,  RCHAR,   3694,   3897,  RCHAR,   4582,
   10552,   4223,   4583,  RCHAR,  RCHAR,  RCHAR,   4584,  RCHAR,
    3477,  10553,  10554,   4585,  RCHAR,  10555,   2922,   2443,
    2151,   4586,   2484,   2334,  10556,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   3359,   4588,  10557,  RCHAR,   3108,
   RCHAR,  10558,   2428,   4589,   4590,   3023,  RCHAR,   4587,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4592,  10559,   3969,  10560,
   10561,  RCHAR,  10562,   2323,  10563,   3648,   4591,  10564,
   10565,  10566,  RCHAR,   2152,   2411,   3648,  10567,  RCHAR,
   RCHAR,   4595,   4593,  RCHAR,  RCHAR,  RCHAR,  10568,   3850,
    2799,   4602,   1759,   4596,   4594,   3054,  RCHAR,  10569,
   10570,  10571,  RCHAR,  RCHAR,  RCHAR,   4598,  RCHAR,   4597,
   10572,  RCHAR,  10573,   1727,  RCHAR,  10574,  RCHAR,   2131,
    4603,   4242,  10575,  RCHAR,  10576,   4599,  RCHAR,  RCHAR,
   RCHAR,   4604,   4601,  10577,   4600,  10578,  10579,  10580,
   10581,  RCHAR,  10582,   4276,  10583,  RCHAR,  RCHAR,   2250,
    1632,  RCHAR,  RCHAR,   4313,  10584,  10585,  10586,  10587,
   RCHAR,   2716,   3439,   2324,   4607,   4608,  RCHAR,  10588,
   10589,   4298,  RCHAR,  RCHAR,   4334,   4610,  10590,  10591,
   10592,   2251,  10593,  10594,   4609,  10595,   1706,  RCHAR,
   10596,   4611,  RCHAR,   4001,  10597,   3317,  10598,   4141,
   10599,   3910,  RCHAR,  RCHAR,  10600,   4612,  RCHAR,  10601,
   RCHAR,  10602,   7478,  RCHAR,  10603,   3493,  10604,   4613,
    1795,   4060,  RCHAR,  10605,  10606,   2726,   4614,   3924,
    4618,  10607,   2923,   4615,   2021,  10608,   4616,   1796,
   10609,  10610,  10611,  RCHAR,  10612,  RCHAR,  RCHAR,  RCHAR,
   10613,  10614,   2081,   4619,  10615,   4620,  10616,  10617,
    4621,   4622,   2596,  RCHAR,  RCHAR,  RCHAR,   2252,   4103,
   10618,   4113,   3564,  10619,  RCHAR,   3934,   4623,  RCHAR,
    4624,  RCHAR,  10620,  10621,  10622,   4626,  RCHAR,   4628,
    4627,  10623,  RCHAR,  10624,  RCHAR,   4629,   1626,   3991,
   10625,   2441,   4630,  10626,  10627,   3064,  10628,  10629,
    2727,   1982,  RCHAR,   4631,  RCHAR,  10630,  RCHAR,  10631,
   10632,  10633,   3724,  10634,  10635,  10636,  RCHAR,   4632,
   10637,   4633,  10638,   4634,  RCHAR,  10639,  RCHAR,  RCHAR,
    4635,   3763,   2045,   1478,  10640,  10641,  10642,   3508,
    4636,   2660,  10643,   2986,  RCHAR,   4638,   4637,   2728,
    2226,   4640,   3695,  10645,  10644,   4641,  RCHAR,  RCHAR,
   RCHAR,   3725,   3121,   3179,   1981,  RCHAR,  RCHAR,   3555,
    3212,  10646,   3649,  10647,   3993,  RCHAR,   4643,  RCHAR,
    2987,  10648,  RCHAR,  10649,  RCHAR,  10650,   2088,  RCHAR,
   RCHAR,   4644,  RCHAR,  RCHAR,  10651,  10652,   4645,   1515,
    1494,   1862,  10653,   3109,   1928,   4216,  RCHAR,   4648,
    1620,  10654,  RCHAR,   4647,  RCHAR,  RCHAR,  10655,   1983,
   RCHAR,  RCHAR,   4649,  10656,   4122,  RCHAR,  RCHAR,  10657,
   10658,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  10659,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  10660,  10661,  RCHAR,   4650,  RCHAR,
    4279,  10662,   2253,  RCHAR,  RCHAR,  10663,  RCHAR,   2183,
    4651,  10664,  RCHAR,  RCHAR,  10665,   4653,   4652,  RCHAR,
    2882,   1528,  10666,  10667,  RCHAR,   1565,   4654,  10668,
    4655,  RCHAR,  10669,   2184,  10670,  10671,   4656,  10672,
   10673,  RCHAR,  10674,   1957,  RCHAR,  10675,  RCHAR,  RCHAR,
   10676,  RCHAR,   2461,   4657,  RCHAR,  10677,  RCHAR,  RCHAR,
    4031,   2370,   1937,   4142,   3055,   3696,   2630,  10678,
   RCHAR,  RCHAR,  10679,  10680,   2670,  10681,   2609,   2622,
   RCHAR,   2717,  10682,   3697,  RCHAR,  10683,  10684,   4660,
   10685,   1538,   3056,   2254,   2198,   2044,  10686,  10687,
    4664,   3196,   3195,   1984,   2729,   4665,   4663,   1633,
    3171,   2561,   2486,   1509,  RCHAR,  10688,   1771,   2325,
    2485,  RCHAR,   4666,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4667,  10689,   1920,   1729,  RCHAR,  RCHAR,  RCHAR,
    2326,   1919,   3352,   1508,   3494,   4071,   2256,   4224,
    3422,   2255,  RCHAR,  10690,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  10691,   2082,  RCHAR,   4676,  RCHAR,   2040,
    3989,  10692,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3726,  10693,
   10694,   4675,  10695,   1847,   4670,   4671,   4673,  10696,
   RCHAR,  10697,  RCHAR,  RCHAR,  10698,  10699,   4674,  RCHAR,
    1938,   2884,  RCHAR,   3866,   4672,   4668,   2228,  RCHAR,
    4669,  RCHAR,   4327,  10700,  10701,  RCHAR,   3935,  10702,
    3361,   2227,   2335,  RCHAR,  RCHAR,  10703,   4677,  10704,
   RCHAR,   3538,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  10705,   4681,
   RCHAR,  RCHAR,  10706,  RCHAR,  10707,  RCHAR,  10708,  10709,
    2631,  10710,   2623,  10711,  RCHAR,  10712,  10713,  RCHAR,
    4684,   4682,  RCHAR,   4044,  10714,   4679,   4688,   4683,
   RCHAR,  RCHAR,  RCHAR,   4686,   2199,   4072,  RCHAR,  10715,
    4687,  10716,  RCHAR,  10717,   4689,  10718,   4691,  RCHAR,
   10719,  10720,  RCHAR,   2429,   4357,  10721,   4680,   4678,
    4690,  10722,   4685,  RCHAR,  RCHAR,  10723,  10724,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  10725,  RCHAR,  RCHAR,  10726,
   RCHAR,  10727,   4693,  RCHAR,   4702,   4695,  10728,  10729,
    4699,  10730,  10731,   4700,   4696,  10732,  10733,   4729,
   RCHAR,  10734,   2422,   1708,  RCHAR,  RCHAR,  RCHAR,  10735,
    4694,  10736,  10737,  10738,   4704,   1495,   4703,  10739,
    1414,   3801,   4701,  RCHAR,   4697,  RCHAR,  10740,   4692,
    4698,   2389,  10741,  RCHAR,  RCHAR,  10742,  10743,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4705,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   10744,   1496,   4714,  RCHAR,  RCHAR,   4706,   4707,  RCHAR,
    2730,   4020,  10745,  RCHAR,  10746,   4712,   4711,  10747,
   RCHAR,  RCHAR,   3398,  RCHAR,  RCHAR,  RCHAR,  10748,  RCHAR,
   RCHAR,  RCHAR,   4713,  RCHAR,  10749,   4710,  10750,  10751,
   10752,  10753,  RCHAR,  RCHAR,   1523,  10754,   2371,   2835,
   10755,  10756,  RCHAR,  RCHAR,  10757,  10758,  10759,   4708,
    3449,  RCHAR,  RCHAR,  RCHAR,   4709,  10760,   1411,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  10761,  10762,  RCHAR,  RCHAR,   4719,   4138,
   RCHAR,   2732,  10763,   4725,  RCHAR,  10764,  10765,  RCHAR,
    4724,   4715,  RCHAR,  10766,  10767,  10768,   3136,  RCHAR,
    4716,  10769,  RCHAR,  RCHAR,   3180,   4721,   2731,  10770,
   RCHAR,  10771,  10772,  RCHAR,   4718,  10773,  RCHAR,   4109,
   10774,  10775,  RCHAR,   2095,  RCHAR,  RCHAR,   4722,   4723,
   10776,  RCHAR,  10777,  10778,   4720,   4726,  10779,  RCHAR,
   10780,  10781,  RCHAR,   4717,  10782,  RCHAR,  10783,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4732,   4737,  RCHAR,   4733,  10784,
    4728,  10785,  10786,   4738,   3024,  RCHAR,  10787,   4740,
   10788,   2257,   4730,   3288,  RCHAR,  RCHAR,  10789,  10790,
   RCHAR,  10791,  10792,  10793,  10794,  RCHAR,  RCHAR,  10795,
    4734,   4727,   1798,  RCHAR,   1863,   1760,   4735,   4731,
   RCHAR,  RCHAR,  RCHAR,  10796,  10797,  RCHAR,  RCHAR,   2153,
    4741,   4739,   3058,   1921,   1985,  10798,   4736,  RCHAR,
    2057,  RCHAR,  10799,  RCHAR,  RCHAR,  RCHAR,   1539,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  10800,
   RCHAR,  10801,  RCHAR,  10802,   4745,   4743,  10803,   4800,
   RCHAR,  10804,  RCHAR,  10805,  10806,  RCHAR,  10807,  RCHAR,
   RCHAR,  10808,  10809,  10810,   4748,  RCHAR,  RCHAR,  10811,
   10812,  RCHAR,   4742,  10813,   4746,  RCHAR,  10814,   4744,
   RCHAR,  RCHAR,  10815,   2487,   4747,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  10816,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  10817,   4750,
   RCHAR,   4755,  RCHAR,  RCHAR,  RCHAR,   4753,   4752,  10818,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  10819,   3213,  RCHAR,
   10820,   1634,  10821,  RCHAR,  RCHAR,  10822,  10823,  10824,
   10825,  10826,  10827,  RCHAR,   4749,  RCHAR,   4751,   2733,
    1522,  10828,  RCHAR,   4754,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   1659,  RCHAR,  RCHAR,  10829,  RCHAR,  RCHAR,   4765,
   10830,   2817,   4761,  10831,   4759,  10832,   4760,  10833,
    4762,  10834,  RCHAR,  10835,  10836,  10837,  RCHAR,  10838,
   10839,  10840,   1532,  10841,  10842,  RCHAR,  10843,  RCHAR,
   RCHAR,  10844,  RCHAR,  10845,   3032,  10846,   4756,  10847,
    4757,  RCHAR,  RCHAR,  RCHAR,  10848,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   1781,  RCHAR,  RCHAR,  10849,  RCHAR,
   10850,  10851,  10852,  10853,   4764,  RCHAR,  10854,  RCHAR,
    1864,  10855,   4767,   4763,   4766,  10856,  RCHAR,  10857,
   RCHAR,  10858,  10859,  RCHAR,   3867,  10860,  RCHAR,  RCHAR,
    3530,  RCHAR,   3689,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4769,  RCHAR,  RCHAR,  RCHAR,  10861,  10862,   4768,   1728,
   10863,  RCHAR,   4770,  10864,  10865,  RCHAR,  RCHAR,   4773,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4772,  10866,  RCHAR,  RCHAR,
   RCHAR,  10867,  10868,  RCHAR,  RCHAR,  10869,  10870,  10871,
    4771,  RCHAR,   3596,  RCHAR,  RCHAR,   4774,  10872,  10873,
   10874,  10875,  RCHAR,  10876,  10877,  10878,   4775,  RCHAR,
   RCHAR,  10879,  RCHAR,  10880,   4777,  RCHAR,   4776,  10881,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   4779,  RCHAR,  10882,  RCHAR,
    4782,   4780,   4778,   4781,  RCHAR,  10883,  RCHAR,  RCHAR,
    4783,  10884,  10885,  10886,  10889,  10890,   4784,  10887,
   10888,   4785,  RCHAR,   4786,  RCHAR,  RCHAR,  RCHAR,   4787,
    4548,  10891,   2629,   2488,  10892,  10893,   1680,  10894,
    1497,  10895,  RCHAR,   3231,  10896,  10897,  10898,  10899,
   10900,  RCHAR,  RCHAR,  10902,  RCHAR,  10903,   4788,  RCHAR,
    2353,  10901,   1456,   2881,  RCHAR,  RCHAR,  10904,  10905,
   RCHAR,   4789,   2200,  RCHAR,  RCHAR,   2336,  RCHAR,   4791,
    4790,  10906,  10907,   3917,   4792,  RCHAR,  RCHAR,  10908,
    4794,   4793,  10909,   4795,  10910,   4796,  RCHAR,   2154,
   RCHAR,  10911,   1567,   4797,  RCHAR,  10912,   4799,  RCHAR,
    4798,  RCHAR,  10913,  10914,   4801,  10915,  RCHAR,   3441,
   10916,  RCHAR,  10917,  10918,  10919,  10920,   4802,   1430,
    2412,  10921,  10922,  RCHAR,  10923,   2096,  10924,  10925,
    3242,  RCHAR,  RCHAR,  10926,  10927,  RCHAR,  RCHAR,   4803,
    4804,  RCHAR,  RCHAR,   4806,  RCHAR,  10928,  10929,  10930,
    4807,  RCHAR,   2417,  RCHAR,  RCHAR,  10931,  10932,   2022,
   RCHAR,  RCHAR,   3970,  RCHAR,  10933,  10934,   4805,   4808,
    2382,   2258,  10935,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4812,  10936,  RCHAR,   2354,  10937,   3214,  10938,
   10939,   4809,   3347,  10940,  RCHAR,  10941,  10942,  10943,
   10944,  10945,  RCHAR,  10946,  10947,  10948,  RCHAR,  10949,
   RCHAR,  10950,  10951,  10952,  10953,  RCHAR,  10954,   4813,
   RCHAR,  10955,   2885,  10956,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4811,   4814,  RCHAR,   2098,  10957,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4815,  10958,  10967,  RCHAR,  10959,
   RCHAR,  10960,  10961,  RCHAR,  10962,  10963,  10964,  10965,
    4816,  10966,   2259,   1723,   4818,  RCHAR,  RCHAR,  10968,
   10969,  10970,   4819,  RCHAR,  10971,  RCHAR,  RCHAR,  RCHAR,
    4820,  RCHAR,  RCHAR,   4817,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   10972,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  10973,  RCHAR,  RCHAR,
    4810,  RCHAR,  RCHAR,   4821,  RCHAR,  RCHAR,   4822,  10974,
   10975,  RCHAR,  RCHAR,   4015,  10976,  RCHAR,   2800,  10977,
   RCHAR,  RCHAR,   4824,   4825,   4823,  10978,   4827,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   3595,  10979,  10980,   1481,
    3813,  10997,  RCHAR,   4828,  10981,  RCHAR,  10982,  10983,
   RCHAR,  10984,  RCHAR,  RCHAR,  RCHAR,  10985,  RCHAR,  RCHAR,
   10986,  RCHAR,  RCHAR,  RCHAR,   2818,  10987,  10988,   2562,
   10989,   3632,   1865,  RCHAR,   2424,  10990,  10991,  10992,
    4004,  RCHAR,   3495,  10993,  10994,   2155,   3148,  RCHAR,
   10995,  10996,   4826,   4829,  10998,  10999,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3137,  RCHAR,  RCHAR,
   RCHAR,   4830,  RCHAR,  11000,  RCHAR,   4831,  11001,  11002,
   11003,   4833,  RCHAR,  RCHAR,   3362,  RCHAR,  11004,  11005,
   RCHAR,  RCHAR,   1799,  RCHAR,  RCHAR,  11006,  RCHAR,   7802,
    1568,   3936,  11007,  RCHAR,   2801,   3423,  RCHAR,  RCHAR,
   RCHAR,  11008,   2419,  RCHAR,  RCHAR,   4839,  RCHAR,  11009,
    3882,   4290,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  11010,   1681,   4835,  11011,  11012,  RCHAR,  11013,
   11014,   3033,   4838,  RCHAR,   3450,  11015,  RCHAR,   3424,
    3451,   3690,   3334,  RCHAR,  RCHAR,  RCHAR,   2390,  11016,
   RCHAR,  11017,   4834,  RCHAR,  11018,  RCHAR,  RCHAR,  11019,
   11020,   1589,  RCHAR,   3405,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4836,  RCHAR,   4832,  RCHAR,  RCHAR,   2867,  RCHAR,  RCHAR,
   11021,   4840,  RCHAR,  RCHAR,  11022,  RCHAR,   2677,  11023,
   11024,  11025,  RCHAR,   1986,  RCHAR,   4841,  RCHAR,  11026,
   11027,  11028,  11029,  RCHAR,  11030,  11031,  RCHAR,  11032,
   11033,  RCHAR,  RCHAR,   3925,  11034,  RCHAR,  11035,   3100,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   3327,  11036,  RCHAR,   4843,
   11037,  11038,  11039,  RCHAR,  RCHAR,  RCHAR,  11040,  RCHAR,
    3994,  11041,  RCHAR,   4844,  RCHAR,  RCHAR,   4849,  RCHAR,
   RCHAR,  11042,  11043,   3868,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4848,   4842,   4845,   4847,  11045,  RCHAR,   2355,  RCHAR,
   RCHAR,   3894,  11046,  RCHAR,  11044,   4850,  RCHAR,   3232,
   11047,  RCHAR,   1682,  RCHAR,   2802,  11048,  11049,  RCHAR,
   11050,   4852,  11051,   4851,  11052,   2327,  11053,   4853,
    4855,   4854,  11054,  RCHAR,   4857,  11055,   4846,   4859,
   RCHAR,  11056,  11057,  RCHAR,   4858,   4856,  RCHAR,  RCHAR,
   RCHAR,  11058,  RCHAR,   2489,   2868,  RCHAR,   3059,   4860,
    2941,   1486,   3639,  11059,  RCHAR,  RCHAR,  RCHAR,   3348,
   RCHAR,   4862,   4861,   4863,   4864,   4865,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4866,  RCHAR,  RCHAR,  11060,  11061,  RCHAR,
   RCHAR,   3902,   4867,  11062,  11063,  RCHAR,  RCHAR,   1635,
    4868,  RCHAR,  11064,  11065,  11066,   4163,   1707,  RCHAR,
    4646,   2671,   3132,   4869,   4116,  11068,  RCHAR,  RCHAR,
   RCHAR,  11069,   4061,  11070,  11071,   4871,  RCHAR,   3172,
   11072,   3406,   3133,   3814,   4872,   4873,   1594,  11073,
   11074,   2563,   4874,  11075,  RCHAR,  11076,  11077,   1457,
    4875,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4876,  11078,
   RCHAR,  RCHAR,  RCHAR,  11079,   1569,  RCHAR,  11080,   1866,
    3541,   3937,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4880,   3060,
    4879,   2099,  11081,  11082,   4006,   4878,  RCHAR,   3452,
    4882,  11083,   4881,  11084,  RCHAR,  11085,  11086,  11087,
    4884,  11088,   4883,  11089,  RCHAR,   1595,  RCHAR,   4885,
    2734,   4887,   3200,  11090,   4886,  11091,   3872,  11092,
   RCHAR,  RCHAR,  11093,   2718,   3442,  11094,  11095,  RCHAR,
    4888,  11096,  RCHAR,  11097,  11098,   2260,  RCHAR,  RCHAR,
   RCHAR,   4889,   3572,   3727,   4090,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   3576,  11099,  11100,   4898,  11101,  RCHAR,
   RCHAR,  RCHAR,  11102,   1903,  RCHAR,  11103,   4172,  11104,
   RCHAR,   4056,  RCHAR,   4993,  RCHAR,   4890,  RCHAR,  11105,
   RCHAR,  RCHAR,  RCHAR,   4893,  11106,   3138,  RCHAR,  11107,
    3971,  RCHAR,  RCHAR,  RCHAR,   3425,  11108,  11109,  11110,
   11111,  RCHAR,   4894,  11112,  RCHAR,  RCHAR,  RCHAR,  11113,
   RCHAR,   4016,  11114,   2391,  11115,  RCHAR,   2735,  RCHAR,
   RCHAR,  11116,  RCHAR,  11117,  11118,  RCHAR,   4895,  RCHAR,
   11119,   2491,  11120,   2490,  RCHAR,  11121,  RCHAR,  RCHAR,
    1434,   2201,  11122,   2924,   1458,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4899,   4900,  RCHAR,   4897,  11123,  11124,  11125,
   RCHAR,  RCHAR,  RCHAR,  11126,  11127,   1527,   1800,  11128,
    4896,  RCHAR,   4078,   3776,  RCHAR,  RCHAR,  11129,  11130,
   RCHAR,  11131,  11132,  RCHAR,  11133,  RCHAR,   1417,  11134,
   RCHAR,  RCHAR,  RCHAR,   1498,  RCHAR,  RCHAR,  RCHAR,   2492,
   11135,   1459,  RCHAR,   1412,  11136,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   4905,  RCHAR,  RCHAR,  11137,  11138,  11139,  RCHAR,
   RCHAR,   4903,  11140,  11141,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    4069,  RCHAR,   4906,  RCHAR,   4904,  RCHAR,  11142,   4902,
    2836,  RCHAR,  RCHAR,  11143,  11144,   4901,  RCHAR,  11145,
   11146,   3911,  11147,  RCHAR,  RCHAR,  11148,  RCHAR,   2229,
   11149,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4910,   4911,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   2736,  RCHAR,  RCHAR,  RCHAR,
    4907,   4335,  RCHAR,  RCHAR,  11150,  11151,   3615,  11152,
   11153,   4909,  RCHAR,  RCHAR,  11154,  RCHAR,  RCHAR,  RCHAR,
   11155,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11156,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   2356,  RCHAR,  RCHAR,  RCHAR,  11157,  RCHAR,
   RCHAR,  RCHAR,   4912,  11158,  RCHAR,  11159,   3815,  11160,
   RCHAR,  RCHAR,   4913,  RCHAR,   4908,  11161,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11162,
   RCHAR,  RCHAR,  11163,  11164,  RCHAR,  RCHAR,  11165,   4068,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  11166,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   11167,  RCHAR,   3633,  11168,  RCHAR,  RCHAR,  11169,  RCHAR,
   RCHAR,  11170,   4914,   3777,  11171,  RCHAR,  11172,  11173,
   11174,  RCHAR,  11175,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11176,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  11177,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  11178,  11179,  11180,  RCHAR,  11181,  RCHAR,  RCHAR,
   11182,  RCHAR,  11183,  11184,   4915,   4919,   4916,  11185,
   RCHAR,   1636,   4918,  RCHAR,  11186,  RCHAR,  11187,  RCHAR,
   11188,   2564,  RCHAR,   4917,   2156,  RCHAR,  RCHAR,  11189,
    4931,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4924,   4921,
   RCHAR,  RCHAR,  11190,  RCHAR,  11191,  RCHAR,  RCHAR,  RCHAR,
   11192,   3263,  RCHAR,   4920,  RCHAR,  11193,   4922,  RCHAR,
   RCHAR,   4923,  11194,  RCHAR,  RCHAR,  RCHAR,  11195,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11196,  11197,  RCHAR,
   RCHAR,  RCHAR,   4925,   4926,  RCHAR,  11198,  RCHAR,  RCHAR,
   11199,  11200,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   11201,   1867,  RCHAR,   4928,   4927,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4929,  11202,
   RCHAR,  11204,  RCHAR,  11205,  RCHAR,  11206,  RCHAR,  RCHAR,
   RCHAR,  11207,   2803,  RCHAR,  RCHAR,  11208,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   4932,  RCHAR,   3349,  11209,  RCHAR,  RCHAR,
    1540,  RCHAR,   4930,  RCHAR,  11203,  RCHAR,   4933,  RCHAR,
   11210,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4934,  RCHAR,
    4937,  11211,  RCHAR,   4935,  RCHAR,   4936,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  11212,  11213,  RCHAR,  RCHAR,  RCHAR,
    2493,   4938,  11214,  RCHAR,   2261,   4939,  11215,   2533,
    3125,  RCHAR,   4940,   4941,   2501,   2262,  11216,   4091,
   RCHAR,  RCHAR,  RCHAR,   1887,   2202,   4942,   1747,  RCHAR,
   11217,   4943,  RCHAR,   3126,  RCHAR,  RCHAR,  11218,  11219,
    4944,   4984,  RCHAR,   4945,  RCHAR,   4946,  RCHAR,  RCHAR,
    4947,  RCHAR,   4949,  RCHAR,  11220,  11221,  11222,  11223,
    4950,  11224,  RCHAR,   4951,  11225,   3181,  11226,   1510,
    2610,   1443,  11227,   3062,   1801,   2558,  11228,   2263,
   11229,  11230,  RCHAR,  11231,  11232,   3453,  11233,   2632,
    1802,   3267,   3363,   1433,   1904,   3938,  RCHAR,   2571,
   RCHAR,  RCHAR,   1929,   2988,   2565,   4143,   4952,  RCHAR,
   11234,  11235,  RCHAR,  RCHAR,  11236,  11237,   1939,  11238,
    2392,  11239,  11240,   1709,   1570,   2737,   1637,  11241,
    4953,   4173,  11242,  RCHAR,  11243,  RCHAR,  RCHAR,   2672,
   11244,  11245,   2605,   4954,   1868,   3527,   4050,   4955,
   RCHAR,   4956,  RCHAR,  RCHAR,   3816,  11246,  RCHAR,  11247,
    4958,  RCHAR,   1793,   2060,   4957,  RCHAR,  11248,  11249,
   11250,  11251,  11252,   1803,  RCHAR,   2837,   4962,   2444,
   11253,   1638,   4961,  RCHAR,   4959,   4963,   4960,   3582,
    5590,   2838,  RCHAR,   4964,  RCHAR,  RCHAR,   4261,  11254,
    4965,  11255,  RCHAR,   4967,  11256,   3289,   4966,  RCHAR,
    2916,  RCHAR,   2534,  RCHAR,  RCHAR,  11257,   3149,   2624,
   RCHAR,   3844,   2989,  RCHAR,   2582,   4968,   2738,   4969,
    4970,   1460,   3127,   2869,  11258,   4971,   3496,   2739,
   RCHAR,   2740,  RCHAR,   4972,  RCHAR,  RCHAR,   2990,  11259,
   RCHAR,  RCHAR,   2741,  RCHAR,  RCHAR,  RCHAR,  11260,  11261,
    4973,  RCHAR,   4974,  11262,   4105,  RCHAR,  11263,  RCHAR,
    4975,  11264,  RCHAR,  11265,  11266,   2011,  11267,  RCHAR,
   11268,   2633,  11269,  RCHAR,  RCHAR,  11270,  11271,  RCHAR,
    4976,   4977,   2597,   2831,   3561,   2871,   3753,   3573,
    2014,   4978,  RCHAR,  RCHAR,  RCHAR,   1958,   4979,  RCHAR,
    2067,  RCHAR,   3524,   1613,  RCHAR,   2494,   4980,   4983,
    4982,   2066,  RCHAR,   4981,  RCHAR,   3407,  RCHAR,  RCHAR,
   RCHAR,  11272,  11273,  RCHAR,  11274,  RCHAR,   3117,  RCHAR,
    3426,   2577,  11275,  11276,   3063,   4225,  RCHAR,  11277,
   11278,  11279,  RCHAR,  RCHAR,   4985,  11280,   4986,   3531,
   11281,   2462,  RCHAR,  RCHAR,  11282,  11283,   4988,  RCHAR,
   RCHAR,   4989,  11284,  11285,  11286,  11287,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11288,
   11289,  RCHAR,  11290,  RCHAR,   4990,  RCHAR,  RCHAR,  11291,
    1869,   4991,  11292,  RCHAR,   4992,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11293,  RCHAR,  11294,
   11295,   1609,  11296,  11297,  RCHAR,  RCHAR,  11298,  RCHAR,
    3034,   1853,  11299,   4994,   4049,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   3151,  11300,   1748,  11301,  11302,   4996,   4998,
    1848,  RCHAR,  11303,   4995,   4997,  RCHAR,   5000,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   4999,  RCHAR,   5001,
   RCHAR,  11304,  RCHAR,  11305,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  11306,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11308,
   RCHAR,   5002,  RCHAR,  RCHAR,  RCHAR,  11307,  RCHAR,  RCHAR,
    3506,   1987,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    1666,   5003,   5008,  RCHAR,  RCHAR,   5006,  11309,   3940,
    3939,  11310,  11311,  RCHAR,  11312,  RCHAR,   3454,  RCHAR,
   RCHAR,  RCHAR,   5005,   2683,  RCHAR,   5004,  RCHAR,  RCHAR,
   RCHAR,  11313,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11314,   2901,
   RCHAR,  RCHAR,  RCHAR,   5009,  RCHAR,  11315,   2423,  RCHAR,
   RCHAR,   5015,  11316,  RCHAR,   5016,   5010,   1710,   5011,
    5020,   5019,   5018,   5014,  RCHAR,  RCHAR,  RCHAR,   5013,
   RCHAR,  RCHAR,   5017,  11318,  11319,  RCHAR,  11320,  11321,
   RCHAR,   3941,  RCHAR,  11317,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  11322,  RCHAR,  RCHAR,  11323,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  11324,  RCHAR,  RCHAR,  RCHAR,  11325,  RCHAR,  11326,
   RCHAR,  RCHAR,  11327,  11328,  RCHAR,  RCHAR,  11329,  RCHAR,
   11330,  RCHAR,  11334,   5024,   5021,  RCHAR,   5023,  RCHAR,
    4217,  11332,   5022,  RCHAR,  RCHAR,  11331,  RCHAR,  RCHAR,
   RCHAR,  11333,  RCHAR,  RCHAR,   5012,  RCHAR,  RCHAR,  11335,
   11336,  11337,  11338,  RCHAR,  11339,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   2902,  11340,  RCHAR,   5025,  11341,  RCHAR,   2372,
   11342,  RCHAR,  RCHAR,   5026,  RCHAR,  RCHAR,   5027,  RCHAR,
   RCHAR,  11343,  11344,  RCHAR,  RCHAR,  RCHAR,  11345,  11346,
   RCHAR,  11347,   5030,  11348,   5029,  RCHAR,  RCHAR,   5028,
   11349,  RCHAR,  11350,   3455,   5007,  RCHAR,  RCHAR,  RCHAR,
    5036,  RCHAR,  11351,  11352,  11353,  11354,  RCHAR,  RCHAR,
   RCHAR,  11355,  RCHAR,  11356,  RCHAR,   5032,  RCHAR,  11357,
   11358,  RCHAR,   5031,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11359,
   RCHAR,  RCHAR,  RCHAR,  11360,   5033,  RCHAR,   5034,  RCHAR,
   11361,  RCHAR,  15405,  RCHAR,  11362,  RCHAR,  RCHAR,   5037,
   11363,  11364,   4299,  RCHAR,   5038,   5035,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  11365,  RCHAR,  RCHAR,  RCHAR,  11366,
   RCHAR,   5039,  RCHAR,  11367,   1849,   5040,  11369,  RCHAR,
   11368,  RCHAR,   5042,   5041,  RCHAR,  RCHAR,   5043,  RCHAR,
   11370,  11371,  RCHAR,   5044,  RCHAR,   2991,   2634,  RCHAR,
   11372,   2699,  RCHAR,   3074,  11373,   2264,   2373,   2265,
    1959,  11374,  RCHAR,   5045,  RCHAR,  RCHAR,   2374,  RCHAR,
   RCHAR,   2203,   5046,   4047,   3606,   5047,  RCHAR,   2266,
   11375,  11376,  RCHAR,   1797,  RCHAR,   3202,   2023,  RCHAR,
   11377,  RCHAR,   2495,   3818,  RCHAR,  RCHAR,   3698,  11378,
   RCHAR,  RCHAR,  RCHAR,   5048,   1870,  11379,  RCHAR,  RCHAR,
   RCHAR,   5051,  11380,  RCHAR,  11381,  11382,   3290,  RCHAR,
   11383,   5050,   5049,   5052,  RCHAR,   3364,  RCHAR,  11384,
   11385,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   2886,  RCHAR,  RCHAR,
   11387,  RCHAR,  RCHAR,   2496,  RCHAR,   2955,  11386,   3152,
    1881,  RCHAR,  11388,   3291,  RCHAR,  11389,   5053,   5054,
    2804,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3972,  11390,  RCHAR,
    5057,  RCHAR,  RCHAR,   5056,   5055,   3852,  RCHAR,   5064,
   RCHAR,  11393,  RCHAR,  11391,   4005,  RCHAR,   5058,  RCHAR,
   11392,  11394,  RCHAR,  RCHAR,   5060,   4022,  11395,   5059,
   11396,  RCHAR,  RCHAR,  11397,  11398,  RCHAR,  11399,   5061,
   RCHAR,   3673,   5062,   3883,   5063,  RCHAR,  RCHAR,  RCHAR,
   11400,  RCHAR,  11401,  11402,  11403,  11404,  11405,  RCHAR,
   11406,  RCHAR,   1804,   3884,   3586,   5065,   5066,  RCHAR,
    2267,   1805,   5067,   2185,   4171,   4144,   1871,   5069,
   11407,   3292,  RCHAR,   2268,   2742,  RCHAR,  RCHAR,   3728,
   RCHAR,  RCHAR,   2743,  11408,  RCHAR,  RCHAR,  11409,   2719,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   3365,   3942,   3408,
   RCHAR,  RCHAR,   2269,  RCHAR,   3819,  RCHAR,  RCHAR,  RCHAR,
    5070,  RCHAR,  11410,  RCHAR,  11411,  11412,   3440,   2383,
   11413,  RCHAR,  11414,   2204,  11415,   3366,  RCHAR,  RCHAR,
   RCHAR,  11416,  RCHAR,  11417,  RCHAR,   1444,   2709,   2270,
    4174,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11418,  11419,  11420,
   RCHAR,   5071,   5072,   3620,  RCHAR,  RCHAR,  11421,  RCHAR,
    5073,   4316,   4336,  11423,  11422,  RCHAR,  11424,   5075,
    5074,  11425,  11426,   1730,  11427,  11428,   5076,  RCHAR,
   RCHAR,  RCHAR,   5079,   5080,  11429,   5078,  11430,   3791,
    2744,   5082,   5081,   5077,  RCHAR,  11431,  RCHAR,  RCHAR,
    5083,   5084,  RCHAR,  11432,   5085,  RCHAR,  RCHAR,  RCHAR,
    5088,   5086,  RCHAR,   5087,   5089,  RCHAR,   1571,   3367,
    5090,  RCHAR,   2157,   1683,   3593,  RCHAR,   5091,   3568,
   RCHAR,   3912,  11433,   5092,   4337,  RCHAR,  11434,  11435,
   11436,   5093,   3885,   5096,   4418,   4434,  11437,   2553,
    3562,   5097,  RCHAR,   1940,   3293,   1499,   5098,   3859,
    2271,  11438,  RCHAR,   3243,  11439,  11440,  RCHAR,   3368,
   RCHAR,  11441,  11442,  11443,  11444,   4120,   2186,   2205,
   11445,   5099,  RCHAR,  11446,  11447,   5100,  11448,   5106,
   11449,   2606,  RCHAR,  RCHAR,  11450,   3294,  11451,   1988,
    5101,  RCHAR,  RCHAR,  11452,   3770,  11453,   3233,  11454,
   11455,   5102,  RCHAR,  RCHAR,  11456,  11457,  RCHAR,  11458,
    5103,  RCHAR,   1989,  RCHAR,   5104,  11459,   5105,  RCHAR,
   11460,   5107,  RCHAR,   3469,  11461,  RCHAR,   5108,   5109,
   11462,   5110,  RCHAR,  11463,   5095,   5094,  RCHAR,  RCHAR,
   11464,   5111,   2100,  11465,  11466,  RCHAR,   3766,  11467,
   RCHAR,   2393,   3782,   3295,   3802,   5112,  RCHAR,  11468,
    2745,   1541,  11469,   5113,  11470,  11471,  RCHAR,   5114,
   11472,   4123,  11473,  RCHAR,   3729,  11474,  11475,   5117,
    1596,   2925,   5116,   5115,   2101,   3153,  RCHAR,   5121,
    5119,  11476,   5118,   4236,   2230,  11477,  RCHAR,  11478,
    2720,   5120,   3427,   2661,  RCHAR,  RCHAR,  11479,   3509,
    5124,   5123,  RCHAR,  RCHAR,  11480,  11481,   5122,  RCHAR,
    5125,   2231,  11482,  RCHAR,  11485,  RCHAR,  RCHAR,  11483,
    5126,   3851,   2690,  11484,  11486,   5127,   3754,  11487,
   11488,  11489,  RCHAR,   3510,   3296,  RCHAR,  RCHAR,  RCHAR,
   11490,   3399,  RCHAR,  RCHAR,   5128,   1890,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   2839,  11491,   3771,  RCHAR,  11492,
   11493,  11494,  RCHAR,  11495,   1872,   3577,  RCHAR,  RCHAR,
   11496,  11497,  11498,  11499,  11500,  RCHAR,   5129,   2497,
    3973,   3974,  RCHAR,  RCHAR,   1597,   5134,  11501,  RCHAR,
    3268,  11502,  11503,  RCHAR,   5131,  RCHAR,  RCHAR,  RCHAR,
   11504,  11505,  11506,   1684,  11507,  11508,  11509,  11510,
    5182,   5133,  11511,  11512,  RCHAR,   3587,  11513,  RCHAR,
    5132,  RCHAR,  11514,   5130,  11515,   2345,  RCHAR,   5136,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11516,
   RCHAR,  RCHAR,  11517,  RCHAR,  RCHAR,  11518,   5142,   5148,
    5140,  RCHAR,   3443,  11519,  11520,   5145,   3820,  11521,
   11522,   5139,  11523,   5144,   4300,   2498,  RCHAR,  11524,
    3154,   5137,  RCHAR,  RCHAR,  11525,   1941,   5147,   2926,
    1572,   5141,   1685,   5146,  RCHAR,  11526,  RCHAR,   1990,
   RCHAR,   5143,  RCHAR,  11527,  RCHAR,  11528,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5149,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   11529,   5151,   5161,   5159,  RCHAR,  RCHAR,   5156,  11530,
   11531,  11532,   5155,   4317,  11533,   5157,  RCHAR,  RCHAR,
    1991,  11534,   2272,  RCHAR,  11535,   2721,  11536,  11537,
   RCHAR,   5164,   5150,  RCHAR,  RCHAR,  11538,  RCHAR,   5154,
    5138,  11539,   1687,   5158,   5160,   3244,  RCHAR,  11540,
    2357,   1621,   5152,   5163,   5162,   1992,  RCHAR,   3110,
    1761,  11541,  RCHAR,  RCHAR,  RCHAR,   2102,  RCHAR,   5153,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11542,  11543,
   RCHAR,   5165,  11544,   5168,   5170,  RCHAR,  11545,  RCHAR,
   11546,   2566,  11547,   5176,   3369,   5166,  11548,  RCHAR,
   RCHAR,  11549,   5174,  11550,   1686,  11551,   5172,   5173,
   11552,  RCHAR,   5169,   5171,  RCHAR,  11553,  11554,   2232,
    4145,  RCHAR,  11555,   1806,  11556,  11557,   1560,   5175,
   11558,   3597,   1422,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   11559,  11560,   3730,   5135,   5181,   5185,   4110,  11561,
    5178,  RCHAR,  RCHAR,  11562,   3456,   5183,  11563,  RCHAR,
   RCHAR,  RCHAR,  11564,  RCHAR,  11565,   2805,   5184,   3532,
   11566,  11567,  11568,  11569,  RCHAR,  RCHAR,  11570,  11571,
   RCHAR,   4362,  RCHAR,   5180,  11572,  11573,  RCHAR,  RCHAR,
    5186,  11574,   2346,  11575,   2956,  11576,  11577,   1461,
    5179,   5177,  11578,   3065,  RCHAR,  11579,  RCHAR,   5167,
    2463,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    3139,   5198,  11580,   3066,   5193,  11581,   5190,   5191,
   11582,   2607,   5194,   5197,  11583,  11584,  RCHAR,  RCHAR,
    5192,   2636,  11585,   5195,  RCHAR,  RCHAR,   5189,  11586,
    4133,   4132,  11587,  RCHAR,  11588,   5199,   5200,   1462,
   11589,  11590,  11591,  11592,  11593,   5188,  11594,  11595,
   RCHAR,  11596,   2055,   1415,  11597,  RCHAR,  11598,   1807,
   RCHAR,   5196,  11599,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5204,
    5203,  RCHAR,  11600,  11601,   5208,  RCHAR,  RCHAR,  RCHAR,
   11602,  11603,  RCHAR,  RCHAR,   5209,  11604,  11605,  11606,
   RCHAR,  11607,  RCHAR,  RCHAR,   5207,   5210,   5202,   5206,
   RCHAR,  11608,   5211,  RCHAR,   5212,  11609,  11610,   5201,
    2535,  11611,   5205,   3155,   2273,   5187,   2840,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   5225,  RCHAR,   3926,  RCHAR,  RCHAR,
    5215,   5216,   5217,  RCHAR,  RCHAR,   5224,  11612,   5223,
   11613,  RCHAR,   4040,   1808,  RCHAR,   5221,  RCHAR,   2104,
    1711,  RCHAR,  RCHAR,   5218,  11614,  RCHAR,   4253,   5220,
    1463,   5222,  11615,   5213,   5219,   5226,   2103,   5214,
   11616,  RCHAR,  RCHAR,  11617,  11618,  RCHAR,   4196,  11619,
   11620,  11621,   4146,  11622,  11623,  RCHAR,  RCHAR,   5229,
   RCHAR,  RCHAR,   5233,  11624,  RCHAR,  11625,   3101,  RCHAR,
    4318,   5234,  11626,  11627,   5231,  RCHAR,   5228,  11628,
   11629,   5227,   5232,  RCHAR,  11630,  11631,  RCHAR,  11632,
   11633,  RCHAR,  RCHAR,  RCHAR,   3869,  11634,  RCHAR,   3497,
   11635,   2105,  11636,   5235,   5230,  11637,   5236,  RCHAR,
   RCHAR,  RCHAR,   2158,  RCHAR,  RCHAR,  RCHAR,   1614,  RCHAR,
   11638,  11639,   5244,  RCHAR,  11640,  RCHAR,   1809,  RCHAR,
   11641,  11642,  11643,   5242,  RCHAR,  RCHAR,   5243,   2358,
    5241,   5239,   5238,   5245,   5237,   5247,  11644,  11645,
    1688,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11646,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  11647,  11648,  11649,  11650,
   RCHAR,  11651,  11652,   5249,  RCHAR,  11655,   5248,  11653,
   RCHAR,  11654,  RCHAR,  RCHAR,  11656,  11657,  RCHAR,  11658,
   RCHAR,  RCHAR,   3297,  RCHAR,   5252,  RCHAR,   5250,   5240,
    2159,  RCHAR,   5251,  RCHAR,   5255,   5254,   5256,   5253,
    5257,  11659,  RCHAR,  11660,  11661,  RCHAR,  RCHAR,  11662,
    5258,   5259,   3927,  RCHAR,   5261,   5260,   2662,  RCHAR,
    2927,   1667,   1689,  11663,   5262,  11664,   1440,  RCHAR,
   RCHAR,  RCHAR,   2957,   5263,  11665,   7084,   5264,   2132,
   11666,   5265,  11667,  11668,  RCHAR,  RCHAR,   2992,  11669,
   RCHAR,  11670,   5266,  11671,  RCHAR,  RCHAR,   5267,   1905,
    5268,  RCHAR,   5269,   5270,   3156,  RCHAR,  RCHAR,  RCHAR,
    2206,  11672,  RCHAR,   4106,  RCHAR,  11673,  RCHAR,   3975,
    2705,   5271,  11674,  11675,  11676,  RCHAR,  11677,   2993,
    7266,   3731,  RCHAR,   2611,  11678,   2394,   5272,  RCHAR,
   11679,  11680,  11681,   3140,  11682,   3860,  11683,  RCHAR,
    3182,  RCHAR,  11684,   5275,  11685,  RCHAR,   5273,  RCHAR,
    5276,  RCHAR,  RCHAR,   5274,  11686,  RCHAR,  RCHAR,  RCHAR,
    5277,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11687,   3870,  11688,
   RCHAR,   1432,  RCHAR,  11689,  RCHAR,  RCHAR,   3821,  RCHAR,
   RCHAR,   3732,  11690,  RCHAR,   5278,  11691,   5281,   2746,
    1906,  RCHAR,   5279,   5286,   2747,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5280,   3607,  RCHAR,  RCHAR,  11692,  11693,  11694,
   11695,   4197,   5282,   5283,   5287,   3457,   5284,   2274,
    2975,  RCHAR,  RCHAR,   5301,   3685,  RCHAR,   3183,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11696,  RCHAR,
   11697,  RCHAR,  RCHAR,   3733,   5370,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   3943,  RCHAR,  11698,  RCHAR,   3370,  11699,  11700,
   RCHAR,   4032,  11701,   5290,   1598,   3269,  11702,  11703,
   RCHAR,  RCHAR,   5299,  RCHAR,  11704,   3215,   5293,   5300,
    5295,   5302,   5298,  RCHAR,   5297,   3650,  11705,   5291,
    1690,   5289,   1960,   3184,   5285,  11706,  11707,   5288,
    2275,   2972,  11708,   2748,   5296,   3621,  RCHAR,  RCHAR,
    1961,   1731,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  11709,  RCHAR,   1762,   2820,   5304,   5309,
   RCHAR,   5305,  11710,   2160,  11711,   5310,   2445,   2328,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  11712,  11713,   2637,   5292,
   RCHAR,   2536,   5307,  11714,  11715,  RCHAR,  RCHAR,   2499,
    5308,   1445,  11716,  11717,   5303,  11718,  RCHAR,  RCHAR,
   11719,   3298,  RCHAR,  11720,  RCHAR,  RCHAR,  11721,  RCHAR,
   11722,   1962,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   1993,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5306,
    1416,  11723,  11724,   2384,  RCHAR,  11725,  RCHAR,   2841,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11726,  11727,  RCHAR,
   RCHAR,  11728,   3371,  RCHAR,  11729,   3717,   5312,   3069,
   RCHAR,  11730,  11731,  11732,  11733,  RCHAR,  11734,  RCHAR,
   RCHAR,   3111,  11735,  11736,   2454,   5313,  11737,   5315,
    5311,  RCHAR,  11738,  11739,  11740,   3918,  RCHAR,   3318,
   11741,  RCHAR,  RCHAR,  11742,   3067,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11743,  11744,   3944,
    2583,   5327,  RCHAR,   5326,  11745,  11746,   2907,  RCHAR,
   RCHAR,  11747,   2161,  RCHAR,  11748,  11749,   5320,   2750,
   11750,  RCHAR,   3549,   3588,  11751,  11752,  RCHAR,  11753,
    5318,  RCHAR,  11754,   3068,  11755,  RCHAR,  RCHAR,  11756,
    2625,   5323,  11757,  RCHAR,   2749,  RCHAR,   5317,   5322,
   11758,  RCHAR,   3622,  RCHAR,  11759,  11760,   5316,  RCHAR,
    2068,  11761,  11762,   1752,  RCHAR,  RCHAR,  11763,   5324,
    4240,   2395,   3216,   5321,  11764,   2973,  11765,   2276,
    2887,   1573,   3035,   5319,   1916,  11766,  11767,  11768,
   RCHAR,  RCHAR,   2106,  RCHAR,   3336,   5325,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   3070,  RCHAR,  11769,   5328,  RCHAR,
    5330,  11770,  RCHAR,   3124,   5336,  11771,   5331,  RCHAR,
   11772,   5333,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11773,   3792,
    3372,  11774,   5334,  11775,  11776,  11777,   4147,  RCHAR,
   RCHAR,  RCHAR,   4175,   1810,  11778,  RCHAR,  RCHAR,  RCHAR,
   11779,   1423,  RCHAR,   5332,  RCHAR,  11780,  RCHAR,  RCHAR,
   RCHAR,   5329,  11781,  RCHAR,  11782,  RCHAR,   1873,  RCHAR,
   RCHAR,  RCHAR,  11783,  11784,   1574,  11785,   5335,  RCHAR,
   11786,  11787,   4176,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5339,  RCHAR,
   RCHAR,  11788,  11789,  RCHAR,  RCHAR,   3128,  RCHAR,   5346,
   11790,  RCHAR,  11791,   5340,  11792,  RCHAR,   5337,   5344,
   11793,  RCHAR,  RCHAR,  RCHAR,   5314,  RCHAR,  11794,  RCHAR,
   11795,  RCHAR,  11796,  RCHAR,  11797,  11798,   5341,  RCHAR,
    5345,  11799,  11800,  RCHAR,   3699,   3458,  RCHAR,  11801,
   11802,  RCHAR,  RCHAR,  RCHAR,   5338,  11803,   5342,  RCHAR,
   RCHAR,  RCHAR,   2107,  RCHAR,  RCHAR,  11804,   2430,  11805,
   RCHAR,  RCHAR,   2974,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  11806,  RCHAR,  RCHAR,   5350,  11807,
   RCHAR,  11808,  11809,  11810,  11811,  RCHAR,  RCHAR,  RCHAR,
    3389,  RCHAR,  11812,  11813,  11814,  11815,  RCHAR,  11816,
   11817,  11818,  RCHAR,  11819,  RCHAR,  RCHAR,  RCHAR,   5347,
   RCHAR,   4011,  RCHAR,  RCHAR,  RCHAR,  11820,  RCHAR,   5348,
   RCHAR,  RCHAR,  RCHAR,  11821,  11822,  RCHAR,   5349,  RCHAR,
    4087,  RCHAR,   2915,  11823,  RCHAR,  11824,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   2133,  RCHAR,  11825,  RCHAR,  11826,
    5356,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11827,
   11828,  11829,   2464,   5353,  RCHAR,   5352,  RCHAR,  RCHAR,
   11830,  11831,   3589,  11832,  RCHAR,  11833,   3498,  11834,
   RCHAR,  11835,  RCHAR,  11836,   3400,   5354,  11837,  RCHAR,
   11838,   5355,  RCHAR,   3838,  11839,   3608,   2446,  RCHAR,
    2994,  RCHAR,   3995,  11840,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   1732,  RCHAR,   5362,   5357,  11841,  11842,  11843,
   RCHAR,   4177,   5364,  RCHAR,  11844,   5360,  RCHAR,   5361,
   RCHAR,  11845,  11846,  11847,  11848,   3071,  11849,  RCHAR,
   11850,  11851,   5359,  RCHAR,   5294,  11852,  RCHAR,  11853,
    5363,  RCHAR,   5358,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5368,   5369,   3390,   5371,  11854,  11855,   2447,   5366,
   RCHAR,  11856,  11857,  RCHAR,   1907,  11858,  RCHAR,   5372,
   11859,   5365,   5376,  RCHAR,   5375,  11860,   5374,  11861,
   RCHAR,  RCHAR,   5377,  11862,  RCHAR,   5379,   2806,  11863,
    5378,  11864,  RCHAR,  RCHAR,  11865,   5382,  RCHAR,  RCHAR,
   11866,  11867,  11868,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11869,
   RCHAR,  RCHAR,  RCHAR,  11870,  11871,  RCHAR,  11872,  RCHAR,
    5380,  11873,  RCHAR,  11874,   5381,   5343,  11875,  11876,
   RCHAR,  RCHAR,  11877,   5384,   5383,  RCHAR,  11878,  RCHAR,
   RCHAR,  11879,   5351,   5385,   5373,  RCHAR,  11880,   2500,
   RCHAR,  11881,  RCHAR,  RCHAR,   5386,   5387,   5389,   5388,
    5390,   1691,  11882,   2277,  11883,  11884,   3945,   2928,
   RCHAR,  RCHAR,  RCHAR,  11885,  RCHAR,   2207,  RCHAR,  11886,
    5392,  11887,  RCHAR,  RCHAR,  RCHAR,   5395,  RCHAR,   3809,
   11888,   1942,  11889,  RCHAR,  11890,   5394,   5393,   3623,
    5396,   1994,  RCHAR,  RCHAR,  RCHAR,   5398,   5397,  11891,
   11892,  RCHAR,   1811,   2465,  RCHAR,  RCHAR,   3533,  11893,
   RCHAR,  RCHAR,  RCHAR,  11894,   2108,  RCHAR,  RCHAR,  RCHAR,
    2903,  RCHAR,   5399,  RCHAR,   2929,   3391,  RCHAR,   3822,
    5400,  RCHAR,  11895,  RCHAR,  RCHAR,  11896,  RCHAR,  RCHAR,
   RCHAR,  11897,   5401,   5402,  RCHAR,  11898,  RCHAR,   3877,
    4948,   2951,  11899,  RCHAR,   3803,  RCHAR,   2405,  RCHAR,
    3734,   3700,  11900,  RCHAR,  RCHAR,  11901,  RCHAR,   3428,
   11902,   4262,  RCHAR,   5404,   2585,  11903,  RCHAR,   5405,
   11904,   1431,  RCHAR,  11905,   2025,   2958,  11906,   3823,
   RCHAR,  RCHAR,  RCHAR,   5406,   2477,   3234,  11907,   2502,
    2842,  RCHAR,  11908,  11909,  11910,  RCHAR,  RCHAR,   5407,
   RCHAR,   3946,  RCHAR,  RCHAR,   1590,   2503,  RCHAR,  11911,
   RCHAR,   5410,  11912,   5408,   5411,   4254,   5409,  RCHAR,
   11913,  11914,  RCHAR,   3004,   5412,  RCHAR,  11915,   3119,
   11916,  RCHAR,   5413,  RCHAR,  11917,  RCHAR,  11918,   1875,
   11919,   5415,  RCHAR,   5414,  RCHAR,  RCHAR,  RCHAR,  11920,
    5416,   5417,   1876,  RCHAR,  RCHAR,   3569,   3217,   1955,
    2504,   3072,  RCHAR,  RCHAR,   2691,   1425,  RCHAR,  RCHAR,
   11921,   5418,  11922,  RCHAR,  11923,  11924,  RCHAR,  RCHAR,
   RCHAR,  11925,   1599,   5422,  RCHAR,  RCHAR,  11926,  11927,
   11928,  RCHAR,   2278,   5421,  11929,  RCHAR,   2360,   2751,
   11930,  11931,   5420,  RCHAR,   2752,  11932,   4073,   2359,
   RCHAR,  11933,  11934,   1464,   2959,  11935,  11936,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5427,  11937,  11938,   2930,
    1542,  11939,  11940,  11941,  11942,   2684,  11943,   4017,
    2431,  11944,  11945,  11946,  11947,   2753,  11948,   2920,
   11949,  11950,  RCHAR,  11951,   5426,   5424,   5425,  11953,
   RCHAR,  11952,  RCHAR,  RCHAR,   3270,  RCHAR,  RCHAR,   5457,
   11954,   5431,   2537,   2279,   5429,  11955,  11956,  RCHAR,
   RCHAR,   5430,  11957,   2843,  11958,  RCHAR,  11960,   5428,
   RCHAR,  11959,   2458,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  11961,
   11962,  11963,  RCHAR,  11964,  11965,   5433,   5432,   5437,
   11966,  11967,   5438,  RCHAR,   5434,  RCHAR,   1693,   5435,
    5436,   3718,  11969,  11970,  11971,  RCHAR,   3824,   2109,
    5439,  RCHAR,  RCHAR,  11973,   2931,  11974,   2754,  11976,
   11977,  11978,   3245,  11979,  11981,  RCHAR,  11972,  11975,
   11980,   2012,  RCHAR,   5440,   5444,  RCHAR,  RCHAR,   1640,
    5441,   5443,  RCHAR,  11982,  11983,  11984,   5442,  RCHAR,
   11985,   2706,  11986,  RCHAR,  RCHAR,  RCHAR,   3235,   1446,
    5445,  11987,  11988,  11989,  11990,   5446,  RCHAR,  11991,
   11992,  RCHAR,   3299,  RCHAR,  11993,  RCHAR,   4310,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   2478,  RCHAR,  11994,   3928,  RCHAR,
   RCHAR,  11995,  11996,  RCHAR,   3976,  11997,  RCHAR,  RCHAR,
    5453,   5448,  RCHAR,  11998,   5451,  RCHAR,   5450,  11999,
   12000,   5447,  12001,  12002,   5452,  RCHAR,  RCHAR,   3539,
   12003,   5449,  RCHAR,  RCHAR,  12004,  RCHAR,  12005,  12006,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  12007,  RCHAR,   5454,  RCHAR,
   RCHAR,   2707,   5455,  12008,   4178,   3659,  RCHAR,  12009,
    5456,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5458,  RCHAR,
   12010,   5459,  RCHAR,  12011,  12012,  RCHAR,  12013,  RCHAR,
    5460,  RCHAR,   2015,   1543,   2280,   5461,  RCHAR,   5462,
    2712,   3073,  12014,  11968,   4661,   3037,   3036,   3157,
    2388,  RCHAR,  RCHAR,   4499,  RCHAR,  12015,  RCHAR,  12016,
    2145,   4148,  RCHAR,   3947,  RCHAR,   3853,  12017,   5463,
   RCHAR,  RCHAR,  RCHAR,  12018,   2432,   3320,   5464,   4338,
   RCHAR,  12019,  RCHAR,   3977,  12020,   3300,   5465,   1877,
   12021,  RCHAR,  12022,  RCHAR,  RCHAR,  RCHAR,   5466,   5467,
    4099,  RCHAR,   4045,   4033,   4007,   2448,   5469,  RCHAR,
   RCHAR,   2612,  RCHAR,  12023,   3996,  RCHAR,   5471,   5474,
    5473,  RCHAR,   1874,  RCHAR,  RCHAR,   1943,  12024,   5470,
   RCHAR,   5472,  RCHAR,  RCHAR,  RCHAR,  12025,   5475,  12026,
   12027,   2908,  RCHAR,  RCHAR,  12028,  RCHAR,   4226,   1450,
    2413,   3129,  RCHAR,   2598,  12029,  12030,   2808,  RCHAR,
   RCHAR,   5478,  RCHAR,  RCHAR,   3429,  12031,   5476,   3112,
    5477,   2807,   4102,   5479,   5480,   4207,  12032,  RCHAR,
   RCHAR,  RCHAR,   5485,  RCHAR,  12033,   2281,  12034,   3624,
    5482,   3459,   5419,   5423,  12035,   1926,  12036,   3610,
   RCHAR,  RCHAR,  RCHAR,  12037,   5484,  RCHAR,   2755,   3701,
   RCHAR,  12038,  RCHAR,  RCHAR,  12039,   5490,  RCHAR,   3755,
   RCHAR,   5481,  RCHAR,   5487,   5486,  RCHAR,  12040,  12041,
    2960,  12042,  RCHAR,  12043,  RCHAR,   4024,  12044,   4280,
   12045,  12046,   4018,  12047,   1641,   2505,  RCHAR,  RCHAR,
    4363,   5489,   2904,  RCHAR,  RCHAR,  RCHAR,   5488,  RCHAR,
   RCHAR,   5483,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   2208,
   12048,  12049,  12050,   5495,   5493,  12051,   1642,   5491,
    5497,   5503,  RCHAR,  12052,  12053,  12054,  RCHAR,  RCHAR,
   12056,   3141,  12057,  12058,   3886,  12059,   5505,  RCHAR,
   12060,  12061,   3761,  RCHAR,  RCHAR,  RCHAR,   5504,   3651,
    3978,   1812,  12062,   3000,   2663,  RCHAR,  RCHAR,  12063,
    3340,  12064,   4149,  RCHAR,  12065,   5500,   5499,  RCHAR,
   RCHAR,  12066,   5501,  RCHAR,   5498,  RCHAR,  12067,   5506,
   RCHAR,   5496,  RCHAR,  RCHAR,   5494,  RCHAR,   5502,   5492,
   12068,   3271,  12069,   4129,   2575,   2433,  12070,  12071,
   RCHAR,  12055,  RCHAR,   2375,  RCHAR,  RCHAR,   4026,   1724,
   RCHAR,  RCHAR,   3335,   3519,   1544,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   2995,  12073,  RCHAR,   2933,   2077,
   RCHAR,  12074,  RCHAR,  RCHAR,  RCHAR,  12075,   5508,  12076,
   RCHAR,   2282,   1783,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  12078,
   12077,   5510,   1775,   5516,  12079,  12080,  RCHAR,  12081,
   12082,  12083,   5513,  12084,   2996,  RCHAR,  RCHAR,  RCHAR,
    1734,   2361,  RCHAR,  12085,   1733,   2396,  RCHAR,  12086,
    5511,   2136,   2110,   3460,  12087,  12088,   5509,  RCHAR,
    1447,  RCHAR,  12089,  RCHAR,  12090,   5512,   5514,  RCHAR,
    2018,   2079,  12072,   1813,   1922,  12091,  RCHAR,  12092,
   12093,   5517,  RCHAR,  12094,   2438,   4028,  RCHAR,   2466,
   RCHAR,  RCHAR,  RCHAR,   5518,  RCHAR,  RCHAR,  RCHAR,   3775,
   RCHAR,  RCHAR,  RCHAR,  12095,  RCHAR,  RCHAR,  12096,  12097,
   12098,  12099,  12100,  RCHAR,   5530,  12101,   1616,   5519,
   RCHAR,  12102,  12103,  12104,  12105,  RCHAR,   5536,   5520,
   RCHAR,   4263,  12106,   5527,  12107,   3634,  12108,  RCHAR,
   12109,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5535,  RCHAR,   5522,
   RCHAR,  RCHAR,  RCHAR,   1429,   5524,  RCHAR,  12110,   2283,
   12111,  RCHAR,  12112,   5526,  12113,   5525,  RCHAR,   5521,
    5532,  12114,   2756,  12115,  RCHAR,  12116,   4870,   2233,
    4227,  12117,  12118,  RCHAR,  RCHAR,   5523,  12119,   3373,
    1694,   2362,  12120,   5515,  RCHAR,   5531,   1756,  RCHAR,
   RCHAR,   5529,   5533,  12121,   3461,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   1879,  12122,   5563,  RCHAR,
   12123,   4082,   5538,   1878,  12124,   5545,  RCHAR,  12125,
   12126,  12127,   3979,  12128,   5546,   5548,  12129,   5552,
    5540,  12130,   3205,  RCHAR,  12131,  12132,  RCHAR,   3462,
    5556,   5543,  RCHAR,   5553,  RCHAR,  12133,  RCHAR,   5547,
   12134,  RCHAR,  12135,  12136,  12137,  12138,   2844,   5557,
   12139,  12140,   2932,  RCHAR,  RCHAR,  12141,  12142,  RCHAR,
   RCHAR,   5555,   1814,  12143,  12144,  12145,  RCHAR,  RCHAR,
    4371,   5537,  RCHAR,  RCHAR,   5551,   1465,  12146,  RCHAR,
    5539,  12147,  12148,   4067,   5544,   2821,   3328,   5534,
   12149,  12150,   5550,  12151,  RCHAR,  RCHAR,  12152,  12153,
   RCHAR,   2909,   5560,   1772,   2162,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,   5562,   5541,   5561,  RCHAR,   5554,   5542,  RCHAR,
    5558,  RCHAR,   5559,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5576,  12154,  RCHAR,  12155,   3523,  12156,   5549,  RCHAR,
   12157,   5572,  RCHAR,  12158,  RCHAR,   5574,  RCHAR,   3345,
   RCHAR,  RCHAR,  12159,  RCHAR,  RCHAR,  12160,  RCHAR,  RCHAR,
   RCHAR,  12161,   4179,  RCHAR,  RCHAR,  RCHAR,  12162,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   3845,   5569,   3143,  RCHAR,  12163,
   RCHAR,   5575,   3038,  12164,   5566,   5579,   5578,  RCHAR,
    3556,   5577,   3551,  12165,  12166,  12167,  12168,  RCHAR,
   12169,  12170,   5581,   5568,  12171,   2013,   5571,   2692,
   12172,  12173,  12174,   3635,   5573,   2016,  RCHAR,   5565,
    5567,   5564,  12175,  12176,   4339,   1749,   5570,  12177,
   12178,   5580,   1712,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   2420,  RCHAR,  RCHAR,  12179,   1564,  RCHAR,
   RCHAR,   5597,  12180,  RCHAR,   4340,   5600,  12181,  RCHAR,
   12182,  RCHAR,  RCHAR,   2845,   5599,  RCHAR,  RCHAR,  RCHAR,
    5598,  12183,  RCHAR,  RCHAR,  RCHAR,  12184,  12185,   5595,
   12186,  RCHAR,  RCHAR,  12187,  RCHAR,  12188,   5583,  12189,
   RCHAR,   5612,   5582,  RCHAR,   5601,  RCHAR,  RCHAR,  12190,
   12191,  RCHAR,  12192,   5593,  12193,  RCHAR,   5588,   5585,
   RCHAR,   5586,  RCHAR,   5594,  RCHAR,  12194,  RCHAR,   7803,
   12195,  RCHAR,   5591,   2284,   3329,   3075,   5589,  RCHAR,
    5584,  12196,  RCHAR,   5587,  RCHAR,  RCHAR,  12197,  12198,
    4180,   4021,  RCHAR,  RCHAR,  RCHAR,   5592,   5602,  RCHAR,
   RCHAR,  RCHAR,  12199,  RCHAR,  RCHAR,  12200,  RCHAR,   5610,
    5603,  RCHAR,  RCHAR,   5616,  RCHAR,   5614,  12201,  12202,
   RCHAR,  12203,   5609,  12204,  RCHAR,  12205,  RCHAR,  RCHAR,
   RCHAR,   5608,  RCHAR,   3337,  RCHAR,   3076,  12206,   5606,
   12207,  12208,   5604,  12209,  RCHAR,   5611,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5617,   3750,   5623,  RCHAR,  RCHAR,  12210,
   RCHAR,  12211,   5618,   5621,   5615,  12212,  RCHAR,   3279,
   RCHAR,   3783,  12213,   5605,  RCHAR,  12214,   5613,   2757,
   12215,   4088,   5633,   5620,  12216,  RCHAR,  RCHAR,  RCHAR,
   12217,   2163,   1600,   1754,  RCHAR,  RCHAR,   5596,  RCHAR,
   12218,  RCHAR,  12219,  RCHAR,  12220,   2758,   5625,  12221,
    5632,   2626,   1773,  12222,  RCHAR,   3209,  12223,  12224,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,   5622,  12225,  12226,   5627,
    5631,  12227,  12228,   1995,  RCHAR,  RCHAR,  12229,  RCHAR,
   12230,  12231,  12232,  RCHAR,  RCHAR,  12233,  12234,  RCHAR,
    1923,   5629,  RCHAR,  12235,  RCHAR,  RCHAR,  RCHAR,   1880,
   RCHAR,   3520,   5628,  RCHAR,  12236,  RCHAR,   5630,  12237,
   RCHAR,  RCHAR,  12238,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  12239,   5624,  12240,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
    5626,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  12241,   1755,
    3236,  12242,  RCHAR,  12243,   5637,  RCHAR,  12244,  12245,
   RCHAR,  12246,  RCHAR,  12247,  RCHAR,   5635,   2234,  RCHAR,
    5634,  12248,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5640,
   RCHAR,  RCHAR,  RCHAR,  12249,   5507,  12250,  12251,  12252,
    5636,  RCHAR,   5638,   5639,  RCHAR,  12253,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5651,  12254,   5647,  RCHAR,   5528,  12255,
   12256,  12257,  RCHAR,   5646,  12258,  RCHAR,  RCHAR,  RCHAR,
    5645,  RCHAR,  RCHAR,   5642,  RCHAR,  12259,  12260,  12261,
   RCHAR,   5619,   5644,   5643,  RCHAR,  RCHAR,  12262,  RCHAR,
   12264,  12263,  RCHAR,  RCHAR,  12265,  RCHAR,  RCHAR,  RCHAR,
   12266,   5649,  RCHAR,   4329,  12267,  12268,  12269,  RCHAR,
   RCHAR,  RCHAR,   5652,   2064,  12270,  12271,   5648,   5650,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  12272,  RCHAR,  RCHAR,  12273,
    3672,  RCHAR,   5653,  RCHAR,  12274,  RCHAR,  RCHAR,  RCHAR,
   12275,  12276,  12277,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,   5657,   5654,  12278,  12279,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  12280,  12281,   4218,   5655,  12282,  12283,
   RCHAR,  12284,   5607,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  12285,
   12286,  12287,   5658,  RCHAR,  RCHAR,  RCHAR,   5659,  12288,
   RCHAR,  RCHAR,  RCHAR,  12289,  RCHAR,   1524,  12290,   5661,
    2138,   2538,  RCHAR,   2026,  12291,  RCHAR,  RCHAR,   1601,
   12292,  RCHAR,  RCHAR,  12293,  12294,  RCHAR,  RCHAR,  12295,
   RCHAR,  RCHAR,   4198,  RCHAR,  RCHAR,  12296,  12297,   5663,
    5662,   5665,   1908,  12298,  RCHAR,   2027,   1815,  12299,
   RCHAR,  RCHAR,  RCHAR,   5668,  RCHAR,  RCHAR,  12300,   5667,
   RCHAR,   5669,  12301,  RCHAR,   1643,  12302,   3218,  RCHAR,
    5670,  RCHAR,  12303,   1816,   5672,  RCHAR,  12304,  RCHAR,
   12305,   5671,  RCHAR,   5673,  RCHAR,  12306,  RCHAR,   5674,
   12307,   5675,   2506,   2934,   2350,  RCHAR,   3839,  12308,
   RCHAR,   3919,   4359,  12309,  RCHAR,  RCHAR,  12310,   2528,
   12311,  RCHAR,  RCHAR,   2397,   4311,  12312,  RCHAR,  RCHAR,
    5676,   5677,  RCHAR,   2507,  RCHAR,  12313,  12314,   5678,
    5679,  RCHAR,  12315,   5681,   5680,  12316,   4003,  RCHAR,
   RCHAR,   2693,   2613,   2479,  RCHAR,   5682,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,   5684,   2822,  12317,
    5683,  RCHAR,  RCHAR,  12318,  RCHAR,  RCHAR,   5685,  12319,
   12320,  RCHAR,  12321,  12322,   5686,  RCHAR,  RCHAR,  RCHAR,
   12323,  12324,   5687,   5688,  12325,  12326,  12327,   5689,
   12328,   5691,   5690,   5692,   1602,   3237,  RCHAR,   5693,
   12329,  12330,   2449,   1735,   5694,  12331,  12332,   3417,
    4837,  RCHAR,  RCHAR,  12333,  12334,   1882,   5695,  RCHAR,
   RCHAR,  12335,  RCHAR,   5696,  12336,   3929,   4019,  RCHAR,
   RCHAR,  RCHAR,   3516,   5697,   3735,  RCHAR,  12337,  RCHAR,
    3756,  RCHAR,  12338,   4092,  RCHAR,  RCHAR,  RCHAR,   5698,
   RCHAR,  12339,  RCHAR,  12340,  RCHAR,  RCHAR,  12341,  12342,
   RCHAR,  RCHAR,  RCHAR,   5700,   5699,  RCHAR,  12343,   5702,
   RCHAR,  12344,  RCHAR,   5701,  RCHAR,  RCHAR,  RCHAR,  12345,
   RCHAR,  12346,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  12347,
   RCHAR,  RCHAR,  12348,  RCHAR,  12349,  12350,  RCHAR,  RCHAR,
    5704,  12351,  RCHAR,  RCHAR,  RCHAR,  12352,  12353,   2508,
   12354,   4058,  12355,   5705,   5706,  RCHAR,  RCHAR,   1883,
   RCHAR,  12356,  RCHAR,   5707,  RCHAR,  RCHAR,  RCHAR,  12357,
   RCHAR,  RCHAR,  RCHAR,   5709,   5708,  RCHAR,  12358,  12359,
   12360,  RCHAR,  RCHAR,  RCHAR,  12361,  RCHAR,  12362,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  12363,   2888,  12364,  12365,   3784,
    1545,  RCHAR,  12366,  12367,  RCHAR,  RCHAR,   3702,  12368,
    3374,   2664,   1944,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  12369,  12370,  RCHAR,  12371,   3703,  12372,
    2551,  RCHAR,  12373,  RCHAR,  12374,   5711,  RCHAR,   1817,
   RCHAR,  12375,   1591,  12376,  12377,   3559,   5710,   2285,
    3246,  RCHAR,   5712,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  12429,
    5720,  RCHAR,   5713,  12378,  RCHAR,  12379,  RCHAR,  12380,
    3134,  RCHAR,   1945,   5721,  12381,  RCHAR,  12382,  RCHAR,
   12383,  12384,   2139,  12385,  RCHAR,   1884,   5719,  RCHAR,
   RCHAR,   5717,   5714,   4199,  RCHAR,  12386,  12387,  12388,
    3321,  12389,  RCHAR,  RCHAR,   3534,   5715,  RCHAR,  RCHAR,
    5723,  RCHAR,   5722,   2070,  12390,  12391,   1610,  12392,
   12393,   2376,   5716,   5718,  12394,  RCHAR,  RCHAR,  12395,
   RCHAR,   4002,   3185,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,   4034,  RCHAR,  RCHAR,   5731,  RCHAR,
   12396,   5732,  12397,   1644,  12398,  RCHAR,  RCHAR,  RCHAR,
    3861,   4134,   5734,   2540,   2759,   5727,   5733,   1575,
   RCHAR,   1996,  12399,  RCHAR,   5724,   5729,  12400,  RCHAR,
   RCHAR,   2997,   3652,  RCHAR,   3736,  12401,  RCHAR,  12402,
   12403,  12404,  12405,   5726,  12406,   3948,  12407,   5728,
   RCHAR,   5737,  12408,   5735,  12409,   5730,  RCHAR,  RCHAR,
   12410,   3949,   3611,   1946,  RCHAR,   3388,  RCHAR,  12411,
    3272,  12412,   5738,  12413,  12414,  RCHAR,  12415,   5736,
    3158,   5725,  12416,   1546,  12417,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,  RCHAR,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  12418,  RCHAR,  RCHAR,  12419,
   RCHAR,  RCHAR,  12420,   4181,   5749,  RCHAR,  12421,  12422,
   RCHAR,  12423,   5748,  12424,  RCHAR,  RCHAR,  RCHAR,   2999,
   RCHAR,   5745,  12425,   4211,  RCHAR,  RCHAR,   3499,   5739,
   RCHAR,  RCHAR,  RCHAR,  RCHAR,  