/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef MEDIAKEYPLUGIN_H
#define MEDIAKEYPLUGIN_H

#include <QThread>
#include <QtCore/QtGlobal>
#include "clib-syslog.h"
#include "plugin-interface.h"
#include "media-key-manager.h"

class MediakeyPlugin : public PluginInterface
{
public:
    ~MediakeyPlugin();
    static PluginInterface* getInstance();

    virtual void activate () override;
    virtual void deactivate () override;

private:
    MediakeyPlugin();
    MediakeyPlugin(MediakeyPlugin&)=delete;

private:
    MediaKeyManager *m_pMediakeyManager = nullptr;
    static PluginInterface*         mInstance;
};

extern "C" Q_DECL_EXPORT PluginInterface* createSettingsPlugin();

#endif // MEDIAKEYPLUGIN_H
