/*
 * Decompiled with CFR 0.152.
 */
package adql.query.constraint;

import adql.parser.feature.LanguageFeature;

public enum ComparisonOperator {
    EQUAL,
    NOT_EQUAL,
    LESS_THAN,
    LESS_OR_EQUAL,
    GREATER_THAN,
    GREATER_OR_EQUAL,
    LIKE,
    ILIKE,
    NOTLIKE,
    NOTILIKE;

    private final LanguageFeature FEATURE = this.name().endsWith("ILIKE") ? new LanguageFeature("ivo://ivoa.net/std/TAPRegExt#features-adql-string", "ILIKE", true, "Perform a case-insensitive comparison between its string operands.") : new LanguageFeature(null, this.name(), false);

    public final LanguageFeature getFeatureDescription() {
        return this.FEATURE;
    }

    public static ComparisonOperator getOperator(String str) throws UnsupportedOperationException {
        if (str.equalsIgnoreCase("=")) {
            return EQUAL;
        }
        if (str.equalsIgnoreCase("!=") || str.equalsIgnoreCase("<>")) {
            return NOT_EQUAL;
        }
        if (str.equalsIgnoreCase("<")) {
            return LESS_THAN;
        }
        if (str.equalsIgnoreCase("<=")) {
            return LESS_OR_EQUAL;
        }
        if (str.equalsIgnoreCase(">")) {
            return GREATER_THAN;
        }
        if (str.equalsIgnoreCase(">=")) {
            return GREATER_OR_EQUAL;
        }
        if (str.equalsIgnoreCase("LIKE")) {
            return LIKE;
        }
        if (str.equalsIgnoreCase("ILIKE")) {
            return ILIKE;
        }
        if (str.equalsIgnoreCase("NOT LIKE")) {
            return NOTLIKE;
        }
        if (str.equalsIgnoreCase("NOT ILIKE")) {
            return NOTILIKE;
        }
        throw new UnsupportedOperationException("Comparison operator unknown: \"" + str + "\" !");
    }

    public String toADQL() {
        switch (this) {
            case EQUAL: {
                return "=";
            }
            case NOT_EQUAL: {
                return "!=";
            }
            case LESS_THAN: {
                return "<";
            }
            case LESS_OR_EQUAL: {
                return "<=";
            }
            case GREATER_THAN: {
                return ">";
            }
            case GREATER_OR_EQUAL: {
                return ">=";
            }
            case LIKE: {
                return "LIKE";
            }
            case ILIKE: {
                return "ILIKE";
            }
            case NOTLIKE: {
                return "NOT LIKE";
            }
            case NOTILIKE: {
                return "NOT ILIKE";
            }
        }
        return "???";
    }

    public String toString() {
        return this.toADQL();
    }
}

