//  Copyright (c) 2016, Novartis Institutes for BioMedical Research Inc.
//  All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Novartis Institutes for BioMedical Research Inc.
//       nor the names of its contributors may be used to endorse or promote
//       products derived from this software without specific prior written
//       permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#include "StructChecker.h"

namespace RDKit {
namespace StructureCheck {

struct AugmentedAtom_t {
  const char *dummy;  // atomSymbol;
  const char *str;    // atomSymbol; shortName;
  int charge;
  RadicalType radical;
  AATopology topology;
};

static const AugmentedAtom_t DefaultGoodAtoms[] = {
    {"Li,Na,K,Rb,Cs,Fr,Tl", "Li,Na,K,Rb,Cs,Fr,Tl+1", 0, RT_NONE, TP_NONE},
    {"Be,Mg,Ca,Sr,Ba,Ra,Sn,Pb", "Be,Mg,Ca,Sr,Ba,Ra,Sn,Pb+2", 1, RT_NONE,
     TP_NONE},
    {"Al,Ga,In,Tl,Sb,Bi,Fe", "Al,Ga,In,Tl,Sb,Bi,Fe+3", 2, RT_NONE, TP_NONE},
    {"B,Si,Ge,N,O,S,F,Cl,Br,I", "B,Si,Ge,N,O,S,F,Cl,Br,I", 0, RT_NONE, TP_NONE},
    {"Cu,Ag,Au,Zn,Cd,Hg", "Cu,Ag,Au,Zn,Cd,Hg", 0, RT_NONE, TP_NONE},
    {"Cu,Ag,Au,Fe,Ru", "Cu,Ag,Au,Fe,Ru+1", 0, RT_NONE, TP_NONE},
    {"Cu,Zn,Cd,Hg,Fe", "Cu,Zn,Cd,Hg,Fe+2", 1, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,Mn,Re",
     "Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,Mn,Re", 0, RT_NONE,
     TP_NONE},
    {"Au,Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu",
     "Au,Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu+3", 2, RT_NONE,
     TP_NONE},
    {"B", "B-1", 0, RT_NONE, TP_NONE},
    {"Ar,He,C,P,Sb", "Ar,He,C,P,Sb", 0, RT_NONE, TP_NONE},
    {"B", "B(-C,N)", 0, RT_NONE, TP_NONE},
    {"C", "C(-B,C,Si,Ge,Sn,Pb,N,P,As,O,S,Se,Te,F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"C", "C(-N,O,P,S,I+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-B,C-1)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C,N,P,O,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N+1)", 0, RT_NONE, TP_NONE},
    {"C,N", "C,N(#C,N)", 0, RT_NONE, TP_NONE},
    {"C,B,F,Cl,Br,I", "C,B,F,Cl,Br,I(-C.)", 0, RT_NONE, TP_NONE},
    {"C,B", "C,B-1(-N+1)", 0, RT_NONE, TP_NONE},
    {"C", "C-1(#N+1)", 0, RT_NONE, TP_NONE},
    {"C", "C.(-C.)", 0, DOUBLET, TP_NONE},
    {"H,D,T", "H,D,T(-C,Si,Ge,Sn,N,P,O,S,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C,F,Cl,Br,I", "C,F,Cl,Br,I(-B,P,As,Sb-1)", 0, RT_NONE, TP_NONE},
    {"Cl,Br,I", "Cl,Br,I(-Zn,Cd,Hg-1)", 0, RT_NONE, TP_NONE},
    {"F,Cl,Br,I", "F,Cl,Br,I(-T,D,H)", 0, RT_NONE, TP_NONE},
    {"F,Cl,Br,I", "F,Cl,Br,I(-N+1)", 0, RT_NONE, TP_NONE},
    {"F,Cl,Br,I", "F,Cl,Br,I(-Sn,Nb,V-1)", 0, RT_NONE, TP_NONE},
    {"N,O,S,F,Cl,Br,I",
     "N,O,S,F,Cl,Br,I(-C,Si,Ge,Sn,Pb,T,D,H,N,P,As,Sb,Bi,O,S,Se,Te,Po)", 0,
     RT_NONE, TP_NONE},
    {"N,O,F,Cl,Br,I", "N,O,F,Cl,Br,I(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"N,O,S,Br,Cl,I", "N,O,S,Br,Cl,I(-N+1)", 0, RT_NONE, TP_NONE},
    {"C,O", "C,O(-B,Si-1)", 0, RT_NONE, TP_NONE},
    {"N", "N(-S+1)", 0, RT_NONE, TP_NONE},
    {"N,O", "N,O(=B,C,Si,Sn,Ge,N,P,As,Sb,S,Se,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"N,O,S", "N,O,S(=N,S,I+1)", 0, RT_NONE, TP_NONE},
    {"N", "N(#N+1)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(#C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=N-1)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-Pd,Pt)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=N+1)", 0, RT_NONE, TP_NONE},
    {"N", "N-1(=N+1)", 0, RT_NONE, TP_NONE},
    {"B", "B-1(-P+1)", 0, RT_NONE, TP_NONE},
    {"O,S", "O,S-1(-C,N,P,S)", 0, RT_NONE, TP_NONE},
    {"N,O,S", "N,O,S-1(-N+1)", 0, RT_NONE, TP_NONE},
    {"O", "O.(-C,N)", 0, DOUBLET, TP_NONE},
    {"O", "O.(-N+1)", 0, DOUBLET, TP_NONE},
    {"P", "P(-C,Si,Ge,Sn)", 0, RT_NONE, TP_NONE},
    {"S,Se", "S,Se(-C,Si,Ge,Sn,N,P,S)", 0, RT_NONE, TP_NONE},
    {"S,Se,Cl,Br,I", "S,Se,Cl,Br,I(-P+1)", 0, RT_NONE, TP_NONE},
    {"S", "S(=C,Sn,N,P,As,Sb,O,S)", 0, RT_NONE, TP_NONE},
    {"Se", "Se(=C,P,S)", 0, RT_NONE, TP_NONE},
    {"Si", "Si(-C)", 0, RT_NONE, TP_NONE},
    {"Li,Na,K,Cs,Rb,Fr,Cu,Ag", "Li,Na,K,Cs,Rb,Fr,Cu,Ag(-C)", 0, RT_NONE,
     TP_NONE},
    {"Zn,Cd,Hg", "Zn,Cd,Hg(=O)", 0, RT_NONE, TP_NONE},
    {"Al", "Al(#P)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Li,Na,K,Rb,Cs,Be,Mg,Ca,Sr,Ba,Al,Ga,In,Tl,Sb,Bi)", 0, RT_NONE,
     TP_NONE},
    {"C",
     "C(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,"
     "Mn,Re)",
     0, RT_NONE, TP_NONE},
    {"N,O,S,F,Cl,Br,I",
     "N,O,S,F,Cl,Br,I(-Be,Mg,Ca,Sr,Ba,B,Al,Ga,In,Tl,Cu,Ag,Au,Zn,Cd,Hg)", 0,
     RT_NONE, TP_NONE},
    {"N,O,S,F,Cl,Br,I",
     "N,O,S,F,Cl,Br,I(-Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,Mn,"
     "Re)",
     0, RT_NONE, TP_NONE},
    {"N,O,S,F,Cl,Br,I",
     "N,O,S,F,Cl,Br,I(-Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu)", 0,
     RT_NONE, TP_NONE},
    {"P", "P(#Al)", 0, RT_NONE, TP_NONE},
    {"C,N,O,S,F,Cl,Br,I", "C,N,O,S,F,Cl,Br,I(-Cu,Ag,Au,Mn,Ru,Al-1)", 0, RT_NONE,
     TP_NONE},
    {"C,O,F,Cl,Br,I", "C,O,F,Cl,Br,I(-Fe,Co,Ni,Mn,Ru,Al-2)", 0, RT_NONE,
     TP_NONE},
    {"O",
     "O(=Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Zn,Cd,Hg,Sc,Ti,V,Cr,Mn,Y,Zr,Nb,Mo,La,Hf,Ta,"
     "W,Re)",
     0, RT_NONE, TP_NONE},
    {"C", "C(=Ru-2)", 0, RT_NONE, TP_NONE},
    {"O,Cl", "O,Cl(-Co,Mn,Ru-3)", 0, RT_NONE, TP_NONE},
    {"O,Cl", "O,Cl(-Pd-1)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-Co-3)", 0, RT_NONE, TP_NONE},
    {"N,O",
     "N,O(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Ala",
     "Ala(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Arg",
     "Arg(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Asn",
     "Asn(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Asp",
     "Asp(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Cys",
     "Cys(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Gln",
     "Gln(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Glu",
     "Glu(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Gly",
     "Gly(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"His",
     "His(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Ile",
     "Ile(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Leu",
     "Leu(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Lys",
     "Lys(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Met",
     "Met(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Phe",
     "Phe(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Pro",
     "Pro(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Ser",
     "Ser(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Thr",
     "Thr(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Trp",
     "Trp(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Tyr",
     "Tyr(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Val",
     "Val(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Ba,Ca,Mg,Pb", "Ba,Ca,Mg,Pb(=O)", 0, RT_NONE, TP_NONE},
    {"F,Cl,Br,I", "F,Cl,Br,I(-H)", 0, RT_NONE, TP_NONE},
    {"H", "H(-N,O,S,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"O", "O(=O,Ba,Ca,Mg,Al,Bi,Pb)", 0, RT_NONE, TP_NONE},
    {"O", "O(=N.)", 0, RT_NONE, TP_NONE},
    {"S", "S(=Mo)", 0, RT_NONE, TP_NONE},
    {"C", "C-1(#O+1)", 0, RT_NONE, TP_NONE},
    {"H", "H(-Al)", 0, RT_NONE, TP_NONE},
    {"H", "H(-Fe+1)", 0, RT_NONE, TP_NONE},
    {"H", "H(-N+1)", 0, RT_NONE, TP_NONE},
    {"Hyd", "Hyd(-Hyd)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(#C-1)", 0, RT_NONE, TP_NONE},
    {"R", "R(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"X", "X(-N)", 0, RT_NONE, TP_NONE},
    {"B", "B(-C,N)(-C,N,P,O,S)", 0, RT_NONE, TP_NONE},
    {"B", "B(-N+1)(-C,N)", 0, RT_NONE, TP_NONE},
    {"B", "B-1(-N+1)(-C)", 0, RT_NONE, TP_NONE},
    {"B", "B(=O)(-O)", 0, RT_NONE, TP_NONE},
    {"C", "C(-B,C,Si)(-B,C,Si,Ge,Sn,Pb,N,P,O,S,Se,Te,F,Cl,Br,I,D,T)", 0,
     RT_NONE, TP_NONE},
    {"C", "C(-N,P,O,S,Se,Te,F,Cl,Br,I)(-N,P,O,S,Se,Te,F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"C", "C(-C,Si,P,S)(-B-1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-P+1)(-B-1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-N,P,O,S,I+1)(-B,C,Si,N,O,P,S,Se,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(-N,P+1)(-N,P+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Sn,Pb)(-Sn,Pb,N,P,O,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C,N)(-B,F,Cl,Br,I,H,D,T)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C,N,P,O,S)(-C,Si,Ge,Sn,N,P,O,S,Se)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C,N)(-N,P,S,Se+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C)(-C+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C)(-C-1)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C,N,O,S)(=C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O+1)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N,S+1)(-C,N,P,O,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N+1)(-N+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N+1)(=N)", 0, RT_NONE, TP_NONE},
    {"C", "C(=P)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(=Ru-2)(-N,O,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(=Ru-3)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(#C,N,S)(-H,D,T,B,C,Si,Ge,Sn,N,P,O,S,Se,F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"C", "C(#C)(-C+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(#N)(-N+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(#N)(-N,B-1)", 0, RT_NONE, TP_NONE},
    {"C", "C(#N+1)(-C,N,P)", 0, RT_NONE, TP_NONE},
    {"C,N", "C,N(-C.)(-C,Si,O)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C.)(=C,O)", 0, RT_NONE, TP_NONE},
    {"C", "C.(-C.)(-C)", 0, DOUBLET, TP_NONE},
    {"C", "C.(-C.)(-C.)", 0, DOUBLET, TP_NONE},
    {"I", "I(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"I", "I(-I,Cl)(-I,Cl)", 0, RT_NONE, TP_NONE},
    {"I", "I(=C,O)(-C)", 0, RT_NONE, TP_NONE},
    {"I", "I+1(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C,Si,N,P,O,S)(-B,C,Si,Ge,Sn,Pb,N,P,O,S,F,Cl,Br,I,H,D,T)", 0,
     RT_NONE, TP_NONE},
    {"N", "N(-N,P,S+1)(-C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"N", "N(=C,N)(-B,C,Si,Sn,N,P,O,S,Se,F,Cl,Br,I,H,D,T)", 0, RT_NONE,
     TP_NONE},
    {"N", "N(=C,N,O)(-N+1)", 0, RT_NONE, TP_NONE},
    {"N", "N(=C)(-S+1)", 0, RT_NONE, TP_NONE},
    {"N", "N(=C,N)(-B-1)", 0, RT_NONE, TP_NONE},
    {"N", "N(=N,S+1)(-C,Si,Sn,N,P,O,S)", 0, RT_NONE, TP_NONE},
    {"N", "N(=N-1)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N(=O)(-C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"N", "N(=P,S,Se)(-C,Si,N,P,S)", 0, RT_NONE, TP_NONE},
    {"N", "N(=S)(-Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"N", "N(=O,S,P)(-N,P,S+1)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C)(-B)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=N,P,S)(=N,P,S)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C,N)(=N-1)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(#C,N)(-O,S-1)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(#C-1)(-C,N)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(#N)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N-1(-N+1)(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"N", "N-1(-N+1)(-N+1)", 0, RT_NONE, TP_NONE},
    {"N", "N.(-C)(-N)", 0, DOUBLET, TP_NONE},
    {"O", "O(-B,Al,Ga,In,Tl)(-B,C,Si,Sn,N,P,S)", 0, RT_NONE, TP_NONE},
    {"O",
     "O(-C,Si,Ge,Sn,Pb,N,P,As,S,Se,T,D,H)(-C,Si,Ge,Sn,Pb,N,P,As,Sb,O,S,Se,Cl,"
     "Br,I)",
     0, RT_NONE, TP_NONE},
    {"O", "O(-N,P,S+1)(-C,Si,N,S)", 0, RT_NONE, TP_NONE},
    {"O", "O(-I+1)(-C)", 0, RT_NONE, TP_NONE},
    {"C,O", "C,O(-B,Si-1)(-C)", 0, RT_NONE, TP_NONE},
    {"O", "O(-B-1)(-N+1)", 0, RT_NONE, TP_NONE},
    {"O", "O(-N-1)(-C)", 0, RT_NONE, TP_NONE},
    {"O", "O(-C.)(-C)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(=C)(-C)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(=C)(-Ru-2)", 0, RT_NONE, TP_NONE},
    {"P", "P(-C,N,O)(-C,N,P,O)", 0, RT_NONE, TP_NONE},
    {"P", "P(=C,N,O,S)(-C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"S", "S(-C,N,P,O,S)(-B,C,O,S,Se,N,P,As,Sb,F,Cl,Br,I,T,D,H)", 0, RT_NONE,
     TP_NONE},
    {"S", "S(-C)(-Si,Ge,Sn,Pb)", 0, RT_NONE, TP_NONE},
    {"S", "S(-N,P,S+1)(-C,N)", 0, RT_NONE, TP_NONE},
    {"S", "S(-Sn)(-P,Sn)", 0, RT_NONE, TP_NONE},
    {"S", "S(=C,N)(=C,N,O)", 0, RT_NONE, TP_NONE},
    {"S", "S(=N)(=S+1)", 0, RT_NONE, TP_NONE},
    {"S", "S(#C)(-N)", 0, RT_NONE, TP_NONE},
    {"S,Se", "S,Se+1(=C,N,P,S)(-C,N,S)", 0, RT_NONE, TP_NONE},
    {"S", "S(-C.)(-C)", 0, RT_NONE, TP_NONE},
    {"Se,Te", "Se,Te(-C,N)(-C,N,O,S,Se,Te,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"Se", "Se(=N)(=N)", 0, RT_NONE, TP_NONE},
    {"Se", "Se(=N+1)(=N)", 0, RT_NONE, TP_NONE},
    {"Si", "Si(-C,Si,O,F,Cl,Br,I)(-C,O,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"As", "As(=O,S,N,P,As)(-C)", 0, RT_NONE, TP_NONE},
    {"Be,Mg,Ca,Sr,Ba", "Be,Mg,Ca,Sr,Ba(-C)(-C,N,P,O,S,F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"Sb", "Sb(=O)(-C)", 0, RT_NONE, TP_NONE},
    {"Ge,Sn,Pb", "Ge,Sn,Pb(-C,N,O,S,F,Cl,Br,I)(-C,Sn,N,O,S,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"Au", "Au(-P+1)(-O,S,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"Be,Mg,Ca,Sr,Ba", "Be,Mg,Ca,Sr,Ba(-N,O)(-N,O)", 0, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,Mn,Re",
     "Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,Mn,Re(-C,N,P,O,S,F,"
     "Cl,Br,I)(-C,N,P,O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Cu,Ag,Au,Zn,Cd,Hg",
     "Cu,Ag,Au,Zn,Cd,Hg(-C,N,P,O,S,F,Cl,Br,I)(-C,N,P,O,S,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"Cu,Ag,Au,Zn,Cd,Hg", "Cu,Ag,Au,Zn,Cd,Hg-1(-P,As+1)(-C,N,P,O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Zn,Cd,Hg,Cr", "Zn,Cd,Hg,Cr(-N+1)(-C,O,S)", 0, RT_NONE, TP_NONE},
    {"Ti", "Ti(-O+1)(-O)", 0, RT_NONE, TP_NONE},
    {"Hg", "Hg(-C.)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"Au", "Au-1(-C)(-S)", 0, RT_NONE, TP_NONE},
    {"Au", "Au-1(-C)(-N+1)", 0, RT_NONE, TP_NONE},
    {"Au", "Au-1(-N,S+1)(-P+1)", 0, RT_NONE, TP_NONE},
    {"Pd", "Pd-1(-Cl)(-P+1)", 0, RT_NONE, TP_NONE},
    {"Pd", "Pd-1(-Cl+1)(-Cl+1)", 0, RT_NONE, TP_NONE},
    {"Ti", "Ti-1(-O)(-O+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Li,Na,K,Rb,Cs,Be,Mg,Ca,Sr,Ba,Al,Ga,In,Tl,Sb,Bi)(-C)", 0, RT_NONE,
     TP_NONE},
    {"C",
     "C(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,"
     "Mn,Re)(-C)",
     0, RT_NONE, TP_NONE},
    {"C", "C(-Hg)(-Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Hg,Mg)(=C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Li,Na,K,Rb,Cs)(#C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Cu,Ag,Au,Zn,Cd,Hg)(#C,N)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,Mn,Re)(#N)",
     0, RT_NONE, TP_NONE},
    {"C", "C(-Au-1)(-P+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Fe-2)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Fe-2)(#O+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Fe,Cr-3)(#O+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Pd,Pt-2)(#N)", 0, RT_NONE, TP_NONE},
    {"C", "C(=Ru-2)(-C)", 0, RT_NONE, TP_NONE},
    {"N,O,S", "N,O,S(-Be,Mg,Ca,Sr,Ba,Al,Ga,In,Tl,Sb,Bi)(-C,Si,N)", 0, RT_NONE,
     TP_NONE},
    {"N,O,S",
     "N,O,S(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,"
     "Mo,W,Mn,Re)(-C,Si,N)",
     0, RT_NONE, TP_NONE},
    {"N", "N(-Be,Mg,Ca,Sr,Ba,Al,Ga,In,Tl,As,Sb,Bi)(=C)", 0, RT_NONE, TP_NONE},
    {"N",
     "N(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,"
     "Mn,Re)(=O)",
     0, RT_NONE, TP_NONE},
    {"N,O,S", "N,O,S(-Cu,Fe,Co,Ni,Cr,Mn,Ti-1)(-C,Si,N)", 0, RT_NONE, TP_NONE},
    {"N,O,S", "N,O,S(-Fe,Co,Ni,Mn-2)(-C,Si,N)", 0, RT_NONE, TP_NONE},
    {"N,O,S", "N,O,S(-Mn-3)(-C,Si,N)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Cu,Ag,Au,Zn,Cd,Hg)(-N,P,S,B,Al,Ga,In,Tl)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Hg)(-N+1)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Mn)(-Cl)", 0, RT_NONE, TP_NONE},
    {"O", "O(-V)(-O)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu)(-C)", 0,
     RT_NONE, TP_NONE},
    {"O,S",
     "O,S(-Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,Mn,Re)(-N,P,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,Mn,"
     "Re)",
     0, RT_NONE, TP_NONE},
    {"S", "S(-Au-1)(-C)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Zr,Cr,V,Zn,Al-2)(-C)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Cr-3)(-C)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Co-2)(-N+1)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Fe,V-3)(-Fe,V-3)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Fe,Co,Ni,V,Nb,Ta-3)(-C)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Fe,Co,Ni,V,Nb,Ta-3)(=C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-Cu,Zn,Cd,Ni,Pd,Pt)(-C)", 0, RT_NONE, TP_NONE},
    {"O,S",
     "O,S+1(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt,Sc,Y,La,Ti,Zr,Hf,V,"
     "Nb,Ta,Cr,Mo,W,Mn,Tc,Re)(=C)",
     0, RT_NONE, TP_NONE},
    {"N", "N+1(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt)(#C)", 0, RT_NONE,
     TP_NONE},
    {"N", "N+1(-Mn-1)(-C,N)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(-Ti-1)(=C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-Ni,Mn-2)(-C,N)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(-Mn,V-2)(=C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-Ru-2)(#C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-Co-3)(-C)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(-Fe,Co,Ni,V,Nb,Ta-3)(=C)", 0, RT_NONE, TP_NONE},
    {"C,Cl", "C,Cl+1(-Al,Ru-1)(-Ru-1)", 0, RT_NONE, TP_NONE},
    {"Cl", "Cl+1(-Rh-3)(-Rh-3)", 0, RT_NONE, TP_NONE},
    {"Cl", "Cl+1(-Pd-1)(-Pd-1)", 0, RT_NONE, TP_NONE},
    {"S", "S(-Cys)(-S)", 0, RT_NONE, TP_NONE},
    {"N,O,S",
     "N,O,S(-C)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,"
     "Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,Trp,"
     "Tyr,Val",
     "Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,Trp,"
     "Tyr,Val(-C)(-N,O,S)",
     0, RT_NONE, TP_NONE},
    {"Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,Trp,"
     "Tyr,Val",
     "Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,Trp,"
     "Tyr,Val(-C,N,O,S)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,"
     "Phe,Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Ala",
     "Ala(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Arg",
     "Arg(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Asn",
     "Asn(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Asp",
     "Asp(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Cys",
     "Cys(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Gln",
     "Gln(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Glu",
     "Glu(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Gly",
     "Gly(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"His",
     "His(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Ile",
     "Ile(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Leu",
     "Leu(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Lys",
     "Lys(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Met",
     "Met(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Phe",
     "Phe(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Pro",
     "Pro(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Ser",
     "Ser(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Thr",
     "Thr(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Trp",
     "Trp(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Tyr",
     "Tyr(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Val",
     "Val(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,Ser,Thr,"
     "Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,"
     "Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Al,Bi,Sb", "Al,Bi,Sb(=O)(-O)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O)(-H)", 0, RT_NONE, TP_NONE},
    {"Cl", "Cl(=O)(-O)", 0, RT_NONE, TP_NONE},
    {"Cr,Fe", "Cr,Fe(=O)(-O)", 0, RT_NONE, TP_NONE},
    {"Mn,Mo", "Mn,Mo(=O,S)(=O,S)", 0, RT_NONE, TP_NONE},
    {"N", "N.(=O)(=O)", 0, DOUBLET, TP_NONE},
    {"O", "O(-Al,Bi,Sb)(-Al,Bi,Sb)", 0, RT_NONE, TP_NONE},
    {"O", "O(-C,B)(-O,H)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Cr,Mn,Fe,Co)(-S)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Fe)(-Fe,V)", 0, RT_NONE, TP_NONE},
    {"O", "O(-O,S,H)(-H)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Zn)(-N+1)", 0, RT_NONE, TP_NONE},
    {"S", "S(-Cl)(-Cl)", 0, RT_NONE, TP_NONE},
    {"S", "S(-H)(-H)", 0, RT_NONE, TP_NONE},
    {"S,Si", "S,Si(=O)(=O)", 0, RT_NONE, TP_NONE},
    {"Ti,Zr", "Ti,Zr(=O)(=O)", 0, RT_NONE, TP_NONE},
    {"Al", "Al+1(-N)(-N)", 0, RT_NONE, TP_NONE},
    {"O", "O(-N+1)(-H)", 0, RT_NONE, TP_NONE},
    {"O", "O(-Al-1)(-C)", 0, RT_NONE, TP_NONE},
    {"Fe", "Fe+1(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"Mn", "Mn+2(-N)(-N)", 1, RT_NONE, TP_NONE},
    {"C,N,O", "C,N,O(-C)(-R,X)", 0, RT_NONE, TP_NONE},
    {"B", "B(-C,N,O,S,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"B", "B(-N+1)(-C,N)(-N,O,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"B", "B(-N+1)(-F,Cl,Br,I)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"B", "B-1(-N+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-B)(-B,C,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C,N,P,O,S,Se,F,Cl,Br,I)(-C,N,P,O,S,F,Cl,Br,I)(-C,F,Cl,Br,I,D,T)",
     0, RT_NONE, TP_NONE},
    {"C",
     "C(-C,Si,Ge,Sn,Pb,N,P,O,S,Se)(-C,Si,Ge,Sn,Pb,N,P,O,S)(-Si,Ge,Sn,Pb,N,P,O,"
     "S)",
     0, RT_NONE, TP_NONE},
    {"C", "C(-C)(-Si)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C)(-C)(-B-1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-N,P,S+1)(-C,N,O,S,F,Cl,Br,I)(-C,N,P,O,S,F,Br,Cl,I,D,T)", 0,
     RT_NONE, TP_NONE},
    {"C", "C(-C+1)(=C)(-C,N)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-I+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-N+1)(-N+1)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "@C(=C)(-O)(-O-1)", 0, RT_NONE, RING},
    {"C", "C(=C)(-B)(-B,C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"C",
     "C(=C)(-C,Si,Ge,Sn,Pb)(-C,Si,Ge,Sn,Pb,O,S,Se,Te,N,P,As,F,Cl,Br,I,D,T)", 0,
     RT_NONE, TP_NONE},
    {"C", "C(=C)(-O,S,Se,Te,N,P,F,Cl,Br,I)(-O,S,Se,Te,N,P,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"C", "C(=C)(-N,P,As,S,I+1)(-C,N,P,O,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C)(-N+1)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C)(-N+1)(-N+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C)(-O+1)(-C,N)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C,N)(-B,C,Sn-1)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(=I)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N,P)(-C,N,P,O,S,F,Cl,Br,I)(-B,C,N,P,O,S,Se,Te,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"C", "C(=N,P)(-C,N,P,S)(-Si,Ge,Sn,H,D,T)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O,S,Se)(-C,N,P,O,S,Se,F,Cl,Br,I)(-C,N,P,O,S,Se,Cl,Br,I,D,T)", 0,
     RT_NONE, TP_NONE},
    {"C", "C(=O)(-B,Cl,Br)(-N,O,Cl,Br)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O)(-Si,Ge,Sn)(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N)(-N+1)(-C,N,P,O,S,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N)(-O,S,I+1)(-C,N)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N,P)(-P,S+1)(-N,P,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O,S)(-N,P+1)(-C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O)(-N+1)(-O,S-1)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N+1)(-O,S,Se,Te)(-S,Se,Te,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N+1)(-C,N)(-C,N,P,O,S,Se,Te,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(=N+1)(-N+1)(-C,N)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O,S+1)(-C)(-C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(=S+1)(-N)(-N)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O,S,Se+1)(-S)(-S)", 0, RT_NONE, TP_NONE},
    {"B,C,Si", "B,C,Si(-C.)(-C,F,Cl,Br,I)(-C,N,P,O,F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"C", "C(-C.)(=C,O,N)(-C,N,P,O,S)", 0, RT_NONE, TP_NONE},
    {"C", "C(-N,O.)(=C,N)(-C,N)", 0, RT_NONE, TP_NONE},
    {"C", "C(-N+1.)(=C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C+1(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C-1(-I,N+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C-1(-S+1)(-S)(-S)", 0, RT_NONE, TP_NONE},
    {"C", "C.(-C.)(-C.)(-C,Si,Sn,N,P,O,S,B,F,Cl,Br,I)", 0, DOUBLET, TP_NONE},
    {"C", "C.(-C.)(-C.)(-B-1)", 0, DOUBLET, TP_NONE},
    {"I", "I(-C)(-C,O,S,F,Cl)(-O,S,F,Cl)", 0, RT_NONE, TP_NONE},
    {"I", "I(=O)(=O)(-C)", 0, RT_NONE, TP_NONE},
    {"I", "I+1(=O)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"Cl,Br,I", "Cl,Br,I(=O)(=O)(-O)", 0, RT_NONE, TP_NONE},
    {"N", "N(-B)(-B,C,N)(-C,S)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C,N,P,O,S)(-C,N,P,O,S,Se,T,D,H)(-C,N,P,O,S,Se,T,D,H)", 0, RT_NONE,
     TP_NONE},
    {"N", "N(-C,S)(-C,N,O,S,F,Cl,Br,I)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C,Si,N)(-Si,Sn)(-C,Si,N,P,O,S)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C)(-C)(-B-1)", 0, RT_NONE, TP_NONE},
    {"N", "N(-N,P,S+1)(-C,N)(-C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"N", "N(-N,O.)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C)(-C,Si,Ge,Sn,N,O,S)(-C,Si,N,O,S)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C)(-C)(-B,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C)(-C,N,S,B-1)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C,O)(-O-1)(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C,O)(-O-1)(-N+1)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C,O)(-O-1)(-N-1)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C)(-Ru-2)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C)(-Ru-3)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-O.)(=C)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=N)(-C,Si)(-C,Si,N,O,S)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=N,O)(-N,O-1)(-C,N,S)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=O,S,Se)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=N+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=N+1)(-O-1)(-C,S)", 0, RT_NONE, TP_NONE},
    {"N", "N+1.(-C)(-C)(-C)", 0, DOUBLET, TP_NONE},
    {"O", "O+1(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"P", "P(-Cl)(-Cl)(-Cl)", 0, RT_NONE, TP_NONE},
    {"P",
     "P(-C,Si,N,O,S)(-C,Si,N,P,O,S,F,Cl,Br,I,T,D,H)(-C,Si,N,P,O,S,F,Cl,Br,I,T,"
     "D,H)",
     0, RT_NONE, TP_NONE},
    {"P", "P(=N,O,S)(-C,N,O)(-C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"P", "P(-C.)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"S", "S(=C)(-C,N,O,S)(-C,N,O,S,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"S", "S(=C,O)(=O)(=O)", 0, RT_NONE, TP_NONE},
    {"S", "S(=C)(-N+1)(-C)", 0, RT_NONE, TP_NONE},
    {"S", "S(=N,O)(-C,N,O,S,F,Cl,Br,I)(-C,N,P,O,S,F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"S", "S(=P)(-C,O)(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"S", "S(=S)(-C,N)(-C,N,P)", 0, RT_NONE, TP_NONE},
    {"S", "S(=N+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"S", "S(-C.)(=N)(-N)", 0, RT_NONE, TP_NONE},
    {"S", "S+1(-C)(-C)(-C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"S", "S+1(-S+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"Se,Te", "Se,Te(=O)(-C)(-C,O)", 0, RT_NONE, TP_NONE},
    {"Si",
     "Si(-C,Si,N,O,S,F,Cl,Br,I)(-C,Si,N,O,S,F,Cl,Br,I)(-C,Si,N,O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Al,Ga,In,Tl",
     "Al,Ga,In,Tl(-C,N,O,S)(-C,N,O,S,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"As,Sb,Bi", "As,Sb,Bi(-C,O,S)(-C,O,S,F,Cl,Br,I)(-C,O,S,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"Ge,Sn", "Ge,Sn(=O,S)(-C,N)(-C,N,O,S)", 0, RT_NONE, TP_NONE},
    {"Sn", "Sn(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"Au", "Au(-O,S)(-O,S,F,Cl,Br,I)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"Cu,Zn,Cd,Ni", "Cu,Zn,Cd,Ni(-N+1)(-N)(-O)", 0, RT_NONE, TP_NONE},
    {"Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu",
     "Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu(-N,O,F,Cl,Br,I)(-N,O,F,"
     "Cl,Br,I)(-O,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,Mn,Cr,Mo,W,Ru",
     "Fe,Co,Ni,Mn,Cr,Mo,W,Ru(-N,O,S,F,Cl,Br,I)(-N,O,S,F,Cl,Br,I)(-N,O,S,F,Cl,"
     "Br,I)",
     0, RT_NONE, TP_NONE},
    {"Ti", "Ti(-C,F,Cl,Br,I)(-N,O)(-N,O)", 0, RT_NONE, TP_NONE},
    {"Zr", "Zr(-C)(-C)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,Cr,Mo,W,Cu", "Fe,Co,Ni,Cr,Mo,W,Cu(-N+1)(-N,O)(-N,O)", 0, RT_NONE,
     TP_NONE},
    {"Fe,Co,Ni,Cr,Mo,W,Cu", "Fe,Co,Ni,Cr,Mo,W,Cu(-N+1)(-N+1)(-N,O)", 0, RT_NONE,
     TP_NONE},
    {"Fe,V,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu",
     "Fe,V,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu(-N+1)(-N+1)(-N+1)", 0,
     RT_NONE, TP_NONE},
    {"Ti", "Ti(=O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"V", "V(=O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"V", "V(=O)(=O)(-O)", 0, RT_NONE, TP_NONE},
    {"Zn,Cd,Hg", "Zn,Cd,Hg-1(-Cl,Br,I)(-Cl,Br,I)(-Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"Co,Cr,Cu", "Co,Cr,Cu-1(-N+1)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"Ru", "Ru-1(-P+1)(-F,Cl,Br,I)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"Ru", "Ru-1(-C,P,Cl,Br,I+1)(-O,Cl,Br,I+1)(-F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"Mn", "Mn-1(-N+1)(-N+1)(-O)", 0, RT_NONE, TP_NONE},
    {"Cu", "Cu-1(-N+1)(-N+1)(-N+1)", 0, RT_NONE, TP_NONE},
    {"Fe", "Fe-2(-C,F,Cl,Br,I)(-C)(-C)", 1, RT_NONE, TP_NONE},
    {"Mn", "Mn-2(-N+1)(-N+1)(-O)", 1, RT_NONE, TP_NONE},
    {"Ru", "Ru-2(-N+1)(-N+1)(-N+1)", 1, RT_NONE, TP_NONE},
    {"Fe,Cr", "Fe,Cr-3(-C)(-C)(-C)", 2, RT_NONE, TP_NONE},
    {"Cr", "Cr-3(-P+1)(-C)(-C)", 2, RT_NONE, TP_NONE},
    {"Au", "Au-3(-P+1)(-S+1)(-S+1)", 2, RT_NONE, TP_NONE},
    {"C", "C(-C)(-C)(-Li,Na,K,Rb,Cs,Be,Mg,Ca,Sr,Ba,Al,Ga,In,Tl,As,Sb,Bi)", 0,
     RT_NONE, TP_NONE},
    {"C",
     "C(-C)(-C)(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt,Ti,Zr,Hf,V,Nb,Ta,"
     "Cr,Mo,W,Mn,Re)",
     0, RT_NONE, TP_NONE},
    {"C", "C(-S)(-S)(-Li,Na,K,Rb,Cs)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C,N)(-C)(-Li,Na,K,Rb,Cs,Be,Mg,Ca,Sr,Ba,Al,Ga,In,Tl,Sb,Bi)", 0,
     RT_NONE, TP_NONE},
    {"C",
     "C(=C,N)(-C,O)(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt,Ti,Zr,Hf,V,"
     "Nb,Ta,Cr,Mo,W,Mn,Re)",
     0, RT_NONE, TP_NONE},
    {"C", "C(=C,O)(-O,S)(-Cu,Ag,Au,Zn,Cd,Hg,Ti)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C)(-C,N,S)(-Be,Mg,Ca,Sr,Ba,Al,Ga,In,Tl,Ge,Sn,Pb,Sb,Bi)", 0,
     RT_NONE, TP_NONE},
    {"N",
     "N(-C,Si)(-C,N,Si)(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt,Ti,Zr,Hf,"
     "V,Nb,Ta,Cr,Mo,W,Mn,Re)",
     0, RT_NONE, TP_NONE},
    {"N", "N(-C)(-C,N)(-Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu)", 0,
     RT_NONE, TP_NONE},
    {"N", "N(-C)(-C,N)(-Cu,Cr,Co-1)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C)(-C)(-Fe-2)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O)(-C)(-Fe-2)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C)(-C,N)(-Cu,Zn,Fe,Co,Ni,Cr-2)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C)(-N+1)(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt)", 0,
     RT_NONE, TP_NONE},
    {"N", "N+1(-C)(-C)(-Zr,Mn,Co-2)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-C)(-C)(-Co,Mn-3)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C,N)(-C,N,O)(-Al,Ge,Cu,Ag,Au,Zn,Cd,Hg)", 0, RT_NONE, TP_NONE},
    {"N",
     "N+1(=C,N)(-C,N,O)(-Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Sc,Ti,V,Cr,Mn,Y,Zr,Nb,Mo,"
     "La,Hf,Ta,W,Re)",
     0, RT_NONE, TP_NONE},
    {"N",
     "N+1(=C,N)(-C,N,O)(-Mn,Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu)",
     0, RT_NONE, TP_NONE},
    {"N",
     "N+1(=C,N)(-C,N,O)(-Mn,Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu-"
     "3)",
     0, RT_NONE, TP_NONE},
    {"N", "N+1(=C,N)(-C)(-Cr,Co,Mn-3)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C,N)(-C,N,O)(-Cu,Zn,Cd,Fe,Co,Ni,Mn,Cr,Al-2)", 0, RT_NONE,
     TP_NONE},
    {"N", "N+1(=C,N)(-C,N)(-Cu,Au,Fe,Co,Cr,Mn,Al-1)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C)(-N+1)(-Cu,Zn,Cd,Ni)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(=C)(-O-1)(-Cu,Zn,Cd,Ni-2)", 0, RT_NONE, TP_NONE},
    {"N",
     "N+1(=C,N+1)(-C)(-Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Sc,Ti,V,Cr,Mn,Y,Zr,Nb,Mo,La,"
     "Hf,Ta,W,Re,Cu,Ag,Au,Zn,Cd,Hg)",
     0, RT_NONE, TP_NONE},
    {"O,S", "O,S+1(-C)(-C)(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt)", 0,
     RT_NONE, TP_NONE},
    {"O", "O+1(-C)(-C)(-Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,Mn,Re)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(-C)(-C)(-Ru-1)", 0, RT_NONE, TP_NONE},
    {"S", "S+1(-Au-1)(-Au-3)(-C)", 0, RT_NONE, TP_NONE},
    {"P", "P(-Zn)(-Zn)(-Zn)", 0, RT_NONE, TP_NONE},
    {"C", "C.(-C.)(-C.)(-Hg)", 0, DOUBLET, TP_NONE},
    {"C",
     "C(=O)(-C,O)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,"
     "Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Cys",
     "Cys(-S)(-C,O,Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,Met,Phe,Pro,"
     "Ser,Thr,Trp,Tyr,Val)(-Ala,Arg,Asn,Asp,Cys,Gln,Glu,Gly,His,Ile,Leu,Lys,"
     "Met,Phe,Pro,Ser,Thr,Trp,Tyr,Val)",
     0, RT_NONE, TP_NONE},
    {"Al", "Al(-C)(-C)(-H)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C)(-C)(-Fe+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C)(-C)(-Fe+1)", 0, RT_NONE, TP_NONE},
    {"C", "C(=C,O)(-C,N,O,H)(-H)", 0, RT_NONE, TP_NONE},
    {"Cr,Fe", "Cr,Fe(-F,Cl)(-F,Cl)(-F,Cl,O)", 0, RT_NONE, TP_NONE},
    {"Fe", "Fe+1(-C)(-C)(-H)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C,O,H)(-H)(-H)", 0, RT_NONE, TP_NONE},
    {"Si", "Si(=O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"P", "P(=O)(=O)(-O)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C)(-C)(-Al+1)", 0, RT_NONE, TP_NONE},
    {"N", "N(-C)(-C)(-Mn+2)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C)(-C)(-R)", 0, RT_NONE, TP_NONE},
    {"C", "C(=O)(-C)(-R)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-O-1)(-C)(-N)", 0, RT_NONE, TP_NONE},
    {"B",
     "B-1(-C,N,O,F,Cl,Br,I)(-C,N,O,F,Cl,Br,I)(-C,N,O,F,Cl,Br,I)(-C,N,O,F,Cl,Br,"
     "I)",
     0, RT_NONE, TP_NONE},
    {"B", "B-1(-N+1)(-C,N,O)(-C,F,Cl,Br,I)(-C,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"B", "B-1(-C.)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-B)(-C)(-C)(-C,S)", 0, RT_NONE, TP_NONE},
    {"C",
     "C(-H,D,T)(-C,D,T,Cl,Br)(-C,D,T,N,P,O,S,Se,F,Cl,Br,I)(-B,C,D,T,N,P,O,S,Se,"
     "Te,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"C", "C(-H,D,T)(-N,P+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C,N,O,S)(-C,N,P,O,S)(-C,N,P,O,S,Se)(-C,N,P,O,S,Se,Te)", 0,
     RT_NONE, TP_NONE},
    {"C",
     "C(-F,Cl,Br,I)(-C,O,S,F,Cl,Br,I)(-C,N,P,O,S,F,Cl,Br,I)(-C,N,P,O,S,Se,F,Cl,"
     "Br,I)",
     0, RT_NONE, TP_NONE},
    {"C",
     "C(-Si,Ge,Sn)(-C,Si,Ge,Sn,F,Cl,Br,I)(-C,S,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"C", "C(-N,P,S,I+1)(-C,O,S)(-C,O,S)(-C,N,O,S,F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"C", "C(-N,P+1)(-F,Cl,Br,I)(-F,Cl,Br,I)(-C,O,S,F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"C", "C(-N+1)(-N+1)(-C)(-C,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(-N+1)(-N+1)(-N+1)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-N,P+1)(-B-1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-B,C-1)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C,Si,Sn", "C,Si,Sn(-C.)(-C,F,Cl,Br,I)(-C,F,Cl,Br,I)(-C,O,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"C", "C(-C.)(-C.)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"Cl,Br,I", "Cl,Br,I(=O)(-C,O)(-C,O)(-C,O)", 0, RT_NONE, TP_NONE},
    {"Cl,Br,I", "Cl,Br,I(=O)(=O)(=O)(-O)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-C)(-C)(-C)(-C,Sn,B,N,P,O,S,F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-C,Si,B-1)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-N,O,S-1)(-C)(-C,N)(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"P", "P(-C)(-C)(-C)(-N,O)", 0, RT_NONE, TP_NONE},
    {"P", "P(-C)(-N,O)(-N,O)(-N,O)", 0, RT_NONE, TP_NONE},
    {"P", "P(-N,O)(-N,O)(-N,O)(-N,O)", 0, RT_NONE, TP_NONE},
    {"P", "P(=C)(-C,N,O)(-C,N,O)(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"P", "P(=O)(-H)(-C,N,O)(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"P",
     "P(=O,S,N,Se)(-C,Si,N,P,O,S,Se,F,Cl,Br,I)(-C,N,P,O,S,Se,F,Cl,Br,I)(-C,N,P,"
     "O,S,Se,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"P", "P(=O)(-N+1)(-O)(-S)", 0, RT_NONE, TP_NONE},
    {"P", "P(=N,S+1)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"P", "P(-C.)(=O)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"P", "P+1(-C,N)(-C,N,O,S,Se)(-C,N,O,S,Se)(-C,N,O,S,Se,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"P", "P+1(-B-1)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"P", "P+1(-Ru-3)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"S", "S(-C)(-C,O)(-C,N,O,Cl,Br,I)(-C,O,P,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"S", "S(-N)(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"S,Se", "S,Se(=C,N,O)(=N,O)(-C,N,O,S,F,Cl,Br,I)(-C,Sn,N,P,O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"S", "S(=O)(=O)(-N+1)(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"S", "S(-C.)(=O)(=O)(-C)", 0, RT_NONE, TP_NONE},
    {"S", "S+1(=O)(-C)(-C,O)(-C,N,O)", 0, RT_NONE, TP_NONE},
    {"S", "S+1(=N)(-C)(-C)(-N)", 0, RT_NONE, TP_NONE},
    {"Se,Te", "Se,Te(-C)(-C,Cl,Br,I)(-Cl,Br,I)(-Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"Si",
     "Si(-C,N,O,S)(-C,N,O,S,Cl,Br,I)(-C,N,P,O,S,Cl,Br,I)(-C,N,P,O,S,F,Cl,Br,I,"
     "H,D,T)",
     0, RT_NONE, TP_NONE},
    {"Si", "Si(-Si)(-C,Si)(-C,Si)(-C,Si,O,F,Cl,Br,I,H,D,T)", 0, RT_NONE,
     TP_NONE},
    {"Si", "Si(-C,F,Cl,Br,I)(-C,F,Cl,Br,I)(-C,F,Cl,Br,I)(-C,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"Si", "Si(-N+1)(-N+1)(-N)(-N)", 0, RT_NONE, TP_NONE},
    {"Si,Sn", "Si,Sn(-N+1)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"Ge", "Ge(-C,O)(-C,O)(-C,O,S,Cl,Br,I)(-C,O,S,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"Sn",
     "Sn(-C,Sn)(-C,N,O,S,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I,D,"
     "T)",
     0, RT_NONE, TP_NONE},
    {"Sn", "Sn(-O,S,F,Cl,Br,I)(-O,S,F,Cl,Br,I)(-O,S,F,Cl,Br,I)(-O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Pb", "Pb(-C)(-C,N,O,S,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"As,Sb", "As,Sb(=O,S)(-C,O)(-C,O)(-C,O)", 0, RT_NONE, TP_NONE},
    {"Al,Ge,Sn", "Al,Ge,Sn(-N+1)(-N+1)(-N,O)(-N,O)", 0, RT_NONE, TP_NONE},
    {"Al", "Al-1(-C+1)(-Cl,Br,I+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"Al", "Al-1(-N+1)(-N+1)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"Hg", "Hg(-N)(-N)(-S)(-S)", 0, RT_NONE, TP_NONE},
    {"Cu,Ag,Au,Zn,Cd,Hg", "Cu,Ag,Au,Zn,Cd,Hg(-N,O+1)(-N,O)(-N,O)(-N,O)", 0,
     RT_NONE, TP_NONE},
    {"Cu,Ag,Au,Zn,Cd,Hg",
     "Cu,Ag,Au,Zn,Cd,Hg(-N,P,O+1)(-N,P,O+1)(-N,O,F,Cl,Br,I)(-N,O,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"Fe,Co,Ni",
     "Fe,Co,Ni(-N,P,O,S+1)(-N,P,O,S+1)(-C,N,O,S,F,Cl,Br,I)(-C,N,O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Cr,Mn,Mo,W,Re",
     "Cr,Mn,Mo,W,Re(-N,P,O,S+1)(-N,P,O,S+1)(-N,O,S,F,Cl,Br,I)(-N,O,S,F,Cl,Br,"
     "I)",
     0, RT_NONE, TP_NONE},
    {"Ru,Rh,Pd,Os,Ir,Pt",
     "Ru,Rh,Pd,Os,Ir,Pt(-N,P,O,S+1)(-N,P,O,S+1)(-C,N,O,S,F,Cl,Br,I)(-C,N,O,S,F,"
     "Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Ru,Rh,Pd,Os,Ir,Pt",
     "Ru,Rh,Pd,Os,Ir,Pt(-N,P,O,S+1)(-N,P,O,S+1)(-N,P,O,S+1)(-N,P,O,S+1)", 0,
     RT_NONE, TP_NONE},
    {"Cu", "Cu-1(-N+1)(-N)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"Ru,Rh,Pd,Os,Ir,Pt",
     "Ru,Rh,Pd,Os,Ir,Pt-2(-C,N)(-C,N)(-C,N,O,F,Cl,Br,I)(-C,N,O,F,Cl,Br,I)", 1,
     RT_NONE, TP_NONE},
    {"Cu,Zn,Cd,Fe,Co,Ni,Mn,Ru",
     "Cu,Zn,Cd,Fe,Co,Ni,Mn,Ru-2(-N+1)(-N+1)(-N,O,F,Cl,Br,I)(-N,O,F,Cl,Br,I)", 1,
     RT_NONE, TP_NONE},
    {"Co", "Co-2(-N+1)(-N+1)(-N+1)(-F)", 1, RT_NONE, TP_NONE},
    {"Cu,Zn,Cd,Ni", "Cu,Zn,Cd,Ni-2(-N+1)(-N+1)(-N+1)(-N+1)", 1, RT_NONE,
     TP_NONE},
    {"Rh", "Rh-3(-Cl+1)(-Cl+1)(-P+1)(-P+1)", 2, RT_NONE, TP_NONE},
    {"Mn,Re", "Mn,Re(=O)(=O)(=O)(-O)", 0, RT_NONE, TP_NONE},
    {"Cr,Mo,W", "Cr,Mo,W(=O,S)(=O,S)(-O,S)(-O,S)", 0, RT_NONE, TP_NONE},
    {"Ni", "Ni(-C,S)(-C,S)(-C,S)(-C,S)", 0, RT_NONE, TP_NONE},
    {"Ni", "Ni-1(-S)(-S)(-S)(-S)", 0, RT_NONE, TP_NONE},
    {"Mn", "Mn-1(-N+1)(-O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"Ti", "Ti(-C,N,O,Cl)(-C,N,O,Cl)(-C,N,O,Cl)(-C,N,O,Cl)", 0, RT_NONE,
     TP_NONE},
    {"V", "V(=O)(-C,O,S)(-C,O,S)(-C,O,S)", 0, RT_NONE, TP_NONE},
    {"Zr", "Zr(-C,O,S)(-C,O,S,F,Cl,Br,I)(-N,O,S,F,Cl,Br,I)(-N,O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"C", "C(-Zn)(-C)(-C,F,Cl,Br,I)(-F,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Li,Na,K,Rb,Cs,Be,Mg,Ca,Sr,Ba,Al,Ga,In,Tl,Sb,Bi)(-C)(-C)(-C)", 0,
     RT_NONE, TP_NONE},
    {"C",
     "C(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Ru,Os,Co,Rh,Ir,Ni,Pd,Pt,Ti,Zr,Hf,V,Nb,Ta,Cr,Mo,W,"
     "Mn,Re)(-C)(-C)(-C)",
     0, RT_NONE, TP_NONE},
    {"C", "C(-Li,Na,K,Rb,Cs)(-N+1)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"P", "P(-Zn)(=O)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"C", "C(-Fe-2)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"N,P,As",
     "N,P,As+1(-Cu,Ag,Au,Zn,Cd,Hg,Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt,Ti,Zr,Hf,V,Nb,Ta,"
     "Cr,Mo,W,Mn,Tc,Re)(-C)(-C)(-C)",
     0, RT_NONE, TP_NONE},
    {"N,P,As", "N,P,As+1(-Cu,Ag,Au,Zn,Cd,Hg-1)(-C)(-C)(-C)", 0, RT_NONE,
     TP_NONE},
    {"P", "P+1(-Ru-1)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"P", "P+1(-Pd-1)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"P", "P+1(-Ru-2)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"N,P", "N,P+1(-Au,Fe,Co,V,Mn,Cr-3)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"P", "P+1(-Cr,Rh-3)(-O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C,Br,H)(-H)(-H)(-H)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C,N)(-C,N,O,F,Cl,Br)(-H)(-H)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C,O,Cl)(-C,F,Cl)(-F,Cl)(-H)", 0, RT_NONE, TP_NONE},
    {"C", "C(-C)(-H)(-H)(-N+1)", 0, RT_NONE, TP_NONE},
    {"Co,Cu,Fe,Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu",
     "Co,Cu,Fe,Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu(-N,O)(-N,O)(-"
     "N,O)(-N,O)",
     0, RT_NONE, TP_NONE},
    {"Co,Cr", "Co,Cr-1(-O)(-O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"Ni", "Ni(-N)(-N)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"P", "P(=O)(-H)(-H)(-O)", 0, RT_NONE, TP_NONE},
    {"Zn", "Zn(-O)(-O)(-S)(-S)", 0, RT_NONE, TP_NONE},
    {"Al", "Al-1(-O)(-O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"Al", "Al(-N+1)(-N+1)(-N)(-N)(-Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"As", "As(-C)(-C)(-C)(-C,O)(-C,O,Cl,Br,I)", 0, RT_NONE, TP_NONE},
    {"Bi", "Bi(-C)(-C)(-C)(-Cl)(-Cl)", 0, RT_NONE, TP_NONE},
    {"I", "I(-C)(-O)(-O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"P", "P(-C,N,O)(-C,N,O)(-C,N,O,F,Cl,Br,I)(-C,O,F,Cl,Br,I)(-O,S,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Sb", "Sb(-C)(-C)(-C)(-C,O,S,F,Cl,Br,I)(-C,O,S,F,Cl,Br,I)", 0, RT_NONE,
     TP_NONE},
    {"Si", "Si-1(-N+1)(-C)(-O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"Sn", "Sn-1(-C)(-C)(-C)(-Br)(-Cl)", 0, RT_NONE, TP_NONE},
    {"Cu,Zn,Cd,Ni", "Cu,Zn,Cd,Ni(-S+1)(-N+1)(-N+1)(-O)(-O)", 0, RT_NONE,
     TP_NONE},
    {"Fe,Cr,Mn", "Fe,Cr,Mn(-N,P,O+1)(-N,P,O+1)(-N,O)(-N,O)(-N,O,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"Co,Mn,Al", "Co,Mn,Al-2(-N,P,O+1)(-N,P,O+1)(-N,O)(-N,O)(-N,O,F,Cl,Br,I)",
     1, RT_NONE, TP_NONE},
    {"Co,Mn", "Co,Mn-3(-N,P,O+1)(-N,P,O+1)(-N,P+1)(-N,O)(-N,O,F,Cl,Br,I)", 2,
     RT_NONE, TP_NONE},
    {"P,Sb", "P,Sb(-Cl)(-Cl)(-Cl)(-Cl)(-Cl)", 0, RT_NONE, TP_NONE},
    {"V", "V(-O)(-O)(-O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"V", "V(=O)(-N,O+1)(-N,O+1)(-N,O)(-N,O)", 0, RT_NONE, TP_NONE},
    {"V", "V-2(=O)(-N,O+1)(-N,O+1)(-N,O)(-N,O)", 1, RT_NONE, TP_NONE},
    {"Ru", "Ru-2(=C)(-N,P,O+1)(-N,P,O+1)(-F,Cl,Br,I)(-F,Cl,Br,I)", 1, RT_NONE,
     TP_NONE},
    {"Ru", "Ru-3(-P+1)(-P+1)(-P+1)(-Cl)(-Cl)", 2, RT_NONE, TP_NONE},
    {"Al", "Al(-N+1)(-N+1)(-N+1)(-O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"Ge,Sn",
     "Ge,Sn(-N,O+1)(-N,O+1)(-N,O)(-N,O)(-N,O,S,F,Cl,Br,I)(-N,O,S,F,Cl,Br,I)", 0,
     RT_NONE, TP_NONE},
    {"P", "P(-N)(-O)(-O)(-O)(-O)(-O)", 0, RT_NONE, TP_NONE},
    {"S", "S(-C)(-F)(-F)(-F)(-F)(-F)", 0, RT_NONE, TP_NONE},
    {"Si", "Si(-F)(-F)(-F)(-F)(-F)(-F)", 0, RT_NONE, TP_NONE},
    {"P,As,Sb",
     "P,As,Sb-1(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,"
     "Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Nb,V",
     "Nb,V-1(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,"
     "Br,I)",
     0, RT_NONE, TP_NONE},
    {"Ti", "Ti(-C)(-C)(-C)(-C)(-C)(-C)", 0, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt",
     "Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,"
     "I)(-F,Cl,Br,I)(-F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,Cr,Mn,Mo,W",
     "Fe,Co,Ni,Cr,Mn,Mo,W(-N,O+1)(-N,O+1)(-C,N,O)(-C,N,O)(-C,N,O,F,Cl,Br,I)(-C,"
     "N,O,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,Cr,Mn,Mo,W",
     "Fe,Co,Ni,Cr,Mn,Mo,W(-N,O+1)(-N,O+1)(-N,O+1)(-N,O)(-C,N,O,F,Cl,Br,I)(-C,N,"
     "O,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,Cr,Mn,Mo,W",
     "Fe,Co,Ni,Cr,Mn,Mo,W(-N,O+1)(-N,O+1)(-N,O+1)(-N,O+1)(-C,N,O,F,Cl,Br,I)(-C,"
     "N,O,F,Cl,Br,I)",
     0, RT_NONE, TP_NONE},
    {"Ru,Rh,Pd,Os,Ir,Pt",
     "Ru,Rh,Pd,Os,Ir,Pt(-N,O+1)(-N,O+1)(-N,O+1)(-N,O+1)(-F,Cl,Br,I)(-F,Cl,Br,"
     "I)",
     0, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,Cr,Mn,Mo,W,Ru,Rh,Pd,Os,Ir,Pt",
     "Fe,Co,Ni,Cr,Mn,Mo,W,Ru,Rh,Pd,Os,Ir,Pt(-N,O+1)(-N,O+1)(-N,O+1)(-N,O+1)(-N,"
     "O+1)(-N,O+1)",
     0, RT_NONE, TP_NONE},
    {"Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu",
     "Sc,Y,La,Ce,Pr,Nd,Pm,Sm,Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu-3(-N,O+1)(-N,O+1)(-N,O+"
     "1)(-N,O+1)(-N,O+1)(-N,O+1)",
     2, RT_NONE, TP_NONE},
    {"Fe,Co,Cr", "Fe,Co,Cr-1(-N+1)(-N+1)(-N,O)(-N,O)(-O)(-O)", 0, RT_NONE,
     TP_NONE},
    {"Fe,Co,Ni,Cr,Zr",
     "Fe,Co,Ni,Cr,Zr-2(-N,O+1)(-N,O+1)(-C,N,O)(-C,N,O)(-C,N,O,F,Cl,Br,I)(-C,N,"
     "O,F,Cl,Br,I)",
     1, RT_NONE, TP_NONE},
    {"Co", "Co-2(-N+1)(-N+1)(-N+1)(-Cl)(-Cl)(-Cl)", 1, RT_NONE, TP_NONE},
    {"Cr,Mn", "Cr,Mn-3(-N+1)(-N+1)(-N+1)(-O)(-O)(-O)", 2, RT_NONE, TP_NONE},
    {"Fe", "Fe-3(-N+1)(-N+1)(-N,O)(-N,O)(-O)(-O)", 2, RT_NONE, TP_NONE},
    {"Fe,Co,Ni,V,Nb,Ta",
     "Fe,Co,Ni,V,Nb,Ta-3(-N,O+1)(-N,O+1)(-N,O+1)(-N,O+1)(-O,Cl)(-O,Cl)", 2,
     RT_NONE, TP_NONE},
    {"Ru", "Ru-3(=C)(-N+1)(-N+1)(-P+1)(-Cl)(-Cl)", 2, RT_NONE, TP_NONE},
    {"Co", "Co-3(-N+1)(-N+1)(-N+1)(-N+1)(-N+1)(-Cl)", 2, RT_NONE, TP_NONE},
    {"Co", "Co-3(-N+1)(-N+1)(-N+1)(-N+1)(-N+1)(-N+1)", 2, RT_NONE, TP_NONE},
    {"Zr", "Zr(-N+1)(-N+1)(-N+1)(-N,O)(-N,O)(-N,O)(-O)", 0, RT_NONE, TP_NONE},
    {"Zr", "Zr(-N+1)(-N+1)(-N+1)(-N+1)(-N,O)(-N,O)(-N,O)(-N,O)", 0, RT_NONE,
     TP_NONE}};

static const AugmentedAtom_t DefaultAcidicAtoms[] = {
    {"C", "C", 0, RT_NONE, TP_NONE},
    {"C", "C(-A)", 0, RT_NONE, TP_NONE},
    {"C", "C(-A)(-A)", 0, RT_NONE, TP_NONE},
    {"C", "C(=A)", 0, RT_NONE, TP_NONE},
    {"C", "C(-A)(-A)(-A)", 0, RT_NONE, TP_NONE},
    {"C", "C(=A)(-A)", 0, RT_NONE, TP_NONE},
    {"C", "C(#A)", 0, RT_NONE, TP_NONE},
    {"N", "N", 0, RT_NONE, TP_NONE},
    {"N", "N(-A)", 0, RT_NONE, TP_NONE},
    {"N", "N(=A)", 0, RT_NONE, TP_NONE},
    {"N", "N(-A)(-A)", 0, RT_NONE, TP_NONE},
    {"N", "N+1", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-A)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-A)(-A)", 0, RT_NONE, TP_NONE},
    {"N", "N+1(-A)(-A)(-A)", 0, RT_NONE, TP_NONE},
    {"N", "N-1(-A)", 0, RT_NONE, TP_NONE},
    {"P", "P", 0, RT_NONE, TP_NONE},
    {"P", "P(-A)", 0, RT_NONE, TP_NONE},
    {"P", "P(-A)(-A)", 0, RT_NONE, TP_NONE},
    {"P", "P(=A)(-A)", 0, RT_NONE, TP_NONE},
    {"P", "P+1", 0, RT_NONE, TP_NONE},
    {"P", "P+1(-A)", 0, RT_NONE, TP_NONE},
    {"P", "P+1(-A)(-A)", 0, RT_NONE, TP_NONE},
    {"O", "O", 0, RT_NONE, TP_NONE},
    {"O", "O(-A)", 0, RT_NONE, TP_NONE},
    {"O", "O+1", 0, RT_NONE, TP_NONE},
    {"O", "O+1(-A)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(-A)(-A)", 0, RT_NONE, TP_NONE},
    {"O", "O+1(=A)", 0, RT_NONE, TP_NONE},
    {"S", "S", 0, RT_NONE, TP_NONE},
    {"S", "S+1", 0, RT_NONE, TP_NONE},
    {"S", "S(-A)", 0, RT_NONE, TP_NONE},
    {"S", "S+1(-A)", 0, RT_NONE, TP_NONE},
    {"Se", "Se", 0, RT_NONE, TP_NONE},
    {"Se", "Se(-A)", 0, RT_NONE, TP_NONE},
    {"Te", "Te", 0, RT_NONE, TP_NONE},
    {"Te", "Te(-A)", 0, RT_NONE, TP_NONE},
    {"F", "F", 0, RT_NONE, TP_NONE},
    {"Cl", "Cl", 0, RT_NONE, TP_NONE},
    {"Br", "Br", 0, RT_NONE, TP_NONE},
    {"I", "I", 0, RT_NONE, TP_NONE}};

struct AugmentedAtomTransforms_t {
  const char *from;
  const char *to;
  const char *label;
};

static const AugmentedAtomTransforms_t DefaultAugmentedAtomTransforms[] = {
    {/*A000*/ "Li,Na,K,Rb,Cs,Fr", "Li,Na,K,Rb,Cs,Fr+1", "SAF metal"},
    {/*A010*/ "Be,Mg,Ca,Sr,Ba,Ra", "Be,Mg,Ca,Sr,Ba,Ra+2", "SAF metal"},
    {/*A020*/ "Al,Ga,In,Tl", "Al,Ga,In,Tl+3", "SAF metal"},
    {/*A030*/ "Sb,Bi", "Sb,Bi+3", "SAF metal"},
    {/*A040*/ "Sn,Pb", "Sn,Pb+2", "SAF metal"},
    {/*A080*/ "Sc,Y,La,Ce,Pr,Nd,Pm,Sm", "Sc,Y,La,Ce,Pr,Nd,Pm,Sm+3",
     "SAF metal"},
    {/*A090*/ "Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu", "Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu+3",
     "SAF metal"},
    {/*A100*/ "N,O,S,F,Cl,Br,I-1", "N,O,S,F,Cl,Br,I", "SAF anion"},
    {/*A110*/ "N+1", "N", "SAF ammonium"},
    {/*A201*/ "Li,Na,K(-N,O,S,Se,F,Cl,Br,I)", "Li,Na,K+1(?N,O,S,Se,F,Cl,Br,I)",
     "SAF"},
    {/*A211*/ "Cs,Rb(-N,O,S,Se,F,Cl,Br,I)", "Cs,Rb+1(?N,O,S,Se,F,Cl,Br,I)",
     "SAF"},
    {/*A302*/ "Be,Mg,Ca(-F,Cl,Br,I)(-F,Cl,Br,I)",
     "Be,Mg,Ca+2(?F,Cl,Br,I)(?F,Cl,Br,I)", ""},
    {/*A312*/ "Sr,Ba(-F,Cl,Br,I)(-F,Cl,Br,I)",
     "Sr,Ba+2(?F,Cl,Br,I)(?F,Cl,Br,I)", ""},
    {/*A322*/ "Pb(-F,Cl,Br,I)(-F,Cl,Br,I)", "Pb+2(?F,Cl,Br,I)(?F,Cl,Br,I)",
     "SAF"},
    {/*A403*/ "Al,Ga(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)",
     "Al,Ga+3(?F,Cl,Br,I)(?F,Cl,Br,I)(?F,Cl,Br,I)", ""},
    {/*A413*/ "In,Tl(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)",
     "In,Tl+3(?F,Cl,Br,I)(?F,Cl,Br,I)(?F,Cl,Br,I)", ""},
    {/*A701*/ "Cu,Ag,Au,Hg(-N,O,S,Cl,Br,I)", "Cu,Ag,Au,Hg+1(?N,O,S,Cl,Br,I)",
     "SAF"},
    {/*A702*/ "Zn(-N+1)(-N+1)", "Zn+2(?N)(?N)", "SAF"},
    {/*A703*/ "Au(-F,Cl,Br,I)(-F,Cl,Br,I)(-F,Cl,Br,I)",
     "Au+3(?F,Cl,Br,I)(?F,Cl,Br,I)(?F,Cl,Br,I)", ""},
    {/*A803*/ "Sc,Y,La,Ce,Pr,Nd,Pm,Sm(-O)(-O)(-O)",
     "Sc,Y,La,Ce,Pr,Nd,Pm,Sm+3(?O)(?O)(?O)", ""},
    {/*A813*/ "Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu(-O)(-O)(-O)",
     "Eu,Gd,Tb,Dy,Ho,Er,Tm,Yb,Lu+3(?O)(?O)(?O)", ""},
    {/*AA04*/ "N(=C)(-C)(-C)(-F,Cl,Br,I)", "N+1(=C)(-C)(-C)(?F,Cl,Br,I)", ""},
    {/*AA05*/ "N(-C)(-C)(-C)(-C)(-F,Cl,Br,I)",
     "N+1(-C)(-C)(-C)(-C)(?F,Cl,Br,I)", ""},
    {/*AX02*/ "O+1(=C)(-B-1)", "O(=C)(?B)", "bor addukt"},
    {/*B101*/ "N+1(-C,N,O)", "N(-C,N,O)", "onium"},
    {/*B112*/ "N(-C+1)(-C,N)", "N(=C)(-C,N)", "onium"},
    {/*B121*/ "N(-C+1)", "N(=C)", "onium"},
    {/*B131*/ "N+1(=C,N)", "N(=C,N)", "onium"},
    {/*B302*/ "N+1(-C)(-C,N)", "N(-C)(-C,N)", "onium"},
    {/*B312*/ "N+1(=C)(-C,N)", "N(=C)(-C,N)", "onium"},
    {/*b322*/ "N+1(=C)(-B-1)", "N(=C)(-B-1)", "MAAG N4B"},
    {/*B503*/ "N+1(-C)(-C,N)(-C,N)", "N(-C)(-C,N)(-C,N)", "onium"},
    {/*C002*/ "I+1(-C,O-1)(-C)", "I(=C,O)(-C)", "ylid pos."},
    {/*C012*/ "N+1(-O-1)(-N)", "N(=O)(-N)", "ylid pos."},
    {/*C103*/ "S+1(-C,O-1)(-C)(-C)", "S(=C,O)(-C)(-C)", "ylid pos."},
    {/*C204*/ "P+1(-C-1)(-C)(-C)(-C)", "P(=C)(-C)(-C)(-C)", "ylid pos."},
    {/*C214*/ "P+1(-O-1)(-N)(-N)(-N)", "P(=O)(-N)(-N)(-N)", "ylid pos."},
    {/*C224*/ "S+1(=O)(-C-1)(-C)(-C)", "S(=O)(=C)(-C)(-C)", "ylid pos."},
    {/*C301*/ "O-1(-P,S,I+1)", "O(=P,S,I)", "ylid neg."},
    {/*C402*/ "C-1(-P,S+1)(-C)", "C(=P,S)(-C)", "ylid neg."},
    {/*C503*/ "C-1(-S+1)(-C)(-C)", "C(=S)(-C)(-C)", "ylid neg."},
    {/*C513*/ "S-1(-C+1)(-C)(-C)", "S(=C)(-C)(-C)", "ylid neg."},
    {/*C601*/ "O(-I+1)", "O(=I)", "ylid spez."},
    {/*C702*/ "S(-C+1)(-C)", "S+1(=C)(-C)", "ylid spez."},
    {/*C803*/ "S(=O)(=O)(-C,N,O,F,Cl,Br,I)", "S(=O)(-O)(-C,N,O,F,Cl,Br,I)",
     "R-SO-OH,O-SO-OH"},
    {/*C804*/ "P,As,Sb(~O)(~O)(~O)(~O)", "P,As,Sb(=O)(-O)(-O)(-O)",
     "phosphate"},
    {/*C901*/ "N+1(=N-1)", "N-1(=N+1)", "diazo"},
    {/*D004*/ "B(-O)(-O)(-O)(-O)", "B-1(-O)(-O)(-O)(-O)", "complex ion"},
    {/*D104*/ "B+3(-O-1)(-O-1)(-O-1)(-O-1)", "B-1(-O)(-O)(-O)(-O)",
     "complex ion"},
    {/*D306*/ "Si.(-F-1)(-F-1)(-F-1)(-F-1)(-F-1)(-F-1)",
     "Si(-F)(-F)(-F)(-F)(-F)(-F)", ""},
    {/*D402*/ "Au(=P)(-O,S,F,Cl,Br,I)", "Au(-P+1)(-O,S,F,Cl,Br,I)",
     "coord.comp"},
    {/*D414*/ "Fe,Co,Ni(=P)(=P)(-F,Cl,Br,I)(-F,Cl,Br,I)",
     "Fe,Co,Ni(-P+1)(-P+1)(-F,Cl,Br,I)(-F,Cl,Br,I)", "coord.comp"},
    {/*D424*/ "Hg+2(-N)(-N)(-S-1)(-S-1)", "Hg(-N)(-N)(-S)(-S)", "coord.comp"},
    {/*D504*/ "P(=Cu,Ag,Au,Zn,Cd,Hg)(-C)(-C)(-C)",
     "P+1(-Cu,Ag,Au,Zn,Cd,Hg)(-C)(-C)(-C)", "coord.comp"},
    {/*D514*/ "P(=Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt)(-C)(-C)(-C)",
     "P+1(-Fe,Co,Ni,Ru,Rh,Pd,Os,Ir,Pt)(-C)(-C)(-C)", "coord.comp"},
    {/*D522*/ "O(=C)(-Sc,Ti,V,Cr,Mn,Fe,Co,Ni,Cu,Zn)",
     "O+1(=C)(-Sc,Ti,V,Cr,Mn,Fe,Co,Ni,Cu,Zn)", "coord.comp"},
    {/*D523*/ "N(=C,N)(-Al,Ge,V,Cr,Mn,Fe,Co,Ni,Cu,Zn)(-C,N,O)",
     "N+1(=C,N)(-Al,Ge,V,Cr,Mn,Fe,Co,Ni,Cu,Zn)(-C,N,O)", "coord.comp"},
    {/*D533*/ "O(-C)(-C)(-Cr,Mn,Fe,Co,Ni,Cu,Zn)",
     "O+1(-C)(-C)(-Cr,Mn,Fe,Co,Ni,Cu,Zn)", "coord.comp"},
    {/*E003*/ "N(=C)(=C)(-C)", "N+1(=C)(-C-1)(-C)", "quart. N"},
    {/*E013*/ "N(=C)(=N,O)(-C,N,O)", "N+1(=C)(-N,O-1)(-C,N,O)", "quart. N"},
    {/*E023*/ "N(=N)(=N,O)(-C)", "N+1(=N)(-N,O-1)(-C)", "quart. N"},
    {/*E033*/ "N(=O)(=O)(-C,N,O)", "N+1(=O)(-O-1)(-C,N,O)", "quart. N"},
    {/*E104*/ "N(=C,O,S)(-C)(-C,N)(-C,N,O)", "N+1(-C,O,S-1)(-C)(-C,N)(-C,N,O)",
     "quart. N"},
    {/*E203*/ "N(=C,O)(=O)(-O-1)", "N+1(=C,O)(-O-1)(-O)", "quart. N spez."},
    {/*E302*/ "N(#C)(=O,S)", "N+1(#C)(-O,S-1)", "quart. N"},
    {/*E402*/ "N(#N)(=C)", "N+1(=N-1)(=C)", "quart. N"},
    {/*E502*/ "N+1(#N)(-C,N-1)", "N+1(=N-1)(=C,N)", "quart. N"},
    {/*E601*/ "N(#N)", "N-1(=N+1)", "quart. N allg."},
    {/*F001*/ "C-1(#N)", "C(#N)", "prot."},
    {/*F002*/ "C(#N)(-C,O,S-1)", "C(#N)(-C,O,S)", "prot."},
    {/*F011*/ "C(-N,P,O,S-1)", "C(-N,P,O,S)", "prot."},
    {/*F012*/ "C(-C,N,O)(-N,P,O,S-1)", "C(-C,N,O)(-N,P,O,S)", "prot."},
    {/*F022*/ "C(=C)(-N,O-1)", "C(-C)(=N,O)", "prot. enol"},
    {/*F032*/ "C(=C)(=N-1)", "C(-C)(#N)", "prot. spez."},
    {/*F042*/ "C(=O,S)(-O,S-1)", "C(=O,S)(-O,S)", "prot."},
    {/*F052*/ "N+1(=N-1)(=N-1)", "N+1(=N-1)(=N)", "MAAG N3"},
    {/*F113*/ "C(-C)(-N,O,S-1)(-C,N,O)", "C(-C)(-N,O,S)(-C,N,O)", "prot."},
    {/*F123*/ "C(-C)(-O-1)(-N+1)", "C(-C)(-O)(-N+1)", "prot."},
    {/*F203*/ "C(=C)(-N-1)(-C,N)", "C(=C)(-N)(-C,N)", "prot."},
    {/*F213*/ "C(=C)(-O,S-1)(-C)", "C(=C)(-O,S)(-C)", "prot. enol C"},
    {/*F223*/ "C(=C)(-O-1)(-N,O,S)", "C(-C)(=O)(-N,O,S)", "prot. enol Het."},
    {/*F233*/ "C(=C)(-S-1)(-N,S)", "C(-C)(=S)(-N,S)", "prot. enol"},
    {/*F243*/ "C(=C)(-O-1)(-N+1)", "C(-C)(=O)(-N+1)", "prot. enol"},
    {/*F303*/ "C(=N)(-C,N,O,S-1)(-C,N,O,S)", "C(=N)(-C,N,O,S)(-C,N,O,S)",
     "prot."},
    {/*F313*/ "C(=N)(-N-1)(-C,N)", "C(=N)(-N)(-C,N)", "prot."},
    {/*F323*/ "C(=N)(-N,O,S-1)(-N,P+1)", "C(=N)(-N,O,S)(-N,P+1)", "prot."},
    {/*F333*/ "C(=N+1)(-O,S-1)(-C,N)", "C(=N+1)(-O,S)(-C,N)", "prot."},
    {/*F343*/ "C(=N+1)(-N-1)(-S)", "C(=N+1)(-N)(-S)", "prot."},
    {/*F403*/ "C(=O)(-C,N,P,O,S-1)(-C,N,P,O,S)",
     "C(=O)(-C,N,P,O,S)(-C,N,P,O,S)", "prot."},
    {/*F413*/ "C(=S)(-C,N,O,S-1)(-N,P,O,S)", "C(=S)(-C,N,O,S)(-N,P,O,S)",
     "prot."},
    {/*F423*/ "C(=O)(-O,S-1)(-N+1)", "C(=O)(-O,S)(-N+1)", "prot."},
    {/*F503*/ "N(-N,O-1)(-C)(-C)", "N(-N,O)(-C)(-C)", "prot."},
    {/*F513*/ "N+1(-O-1)(-C)(-C)", "N(-O)(-C)(-C)", "prot."},
    {/*F523*/ "N+1(=C,O)(-O-1)(-O-1)", "N+1(=C,O)(-O-1)(-O)", "prot."},
    {/*F603*/ "P(=O)(-O-1)(-C,O)", "P(=O)(-O)(-C,O)", "prot."},
    {/*F703*/ "S,Se(=O)(-O-1)(-C,O)", "S,Se(=O)(-O)(-C,O)", "prot."},
    {/*F804*/ "C(-C)(-O-1)(-N)(-O)", "C(-C)(-O)(-N)(-O)", "prot."},
    {/*F904*/ "P,As(=O)(-O,S-1)(-C,N,O,S)(-C,N,O,S)",
     "P,As(=O)(-O,S)(-C,N,O,S)(-C,N,O,S)", ""},
    {/*F914*/ "P(=S)(-O,S-1)(-C,N,O,S)(-C,N,O,S)",
     "P(=S)(-O,S)(-C,N,O,S)(-C,N,O,S)", ""},
    {/*FA04*/ "S(=N)(=O)(-N,O-1)(-C,N,O,S)", "S(=N)(=O)(-N,O)(-C,N,O,S)",
     "prot."},
    {/*FA14*/ "S(=O)(=O)(-N,O-1)(-C,N,O,S)", "S(=O)(=O)(-N,O)(-C,N,O,S)",
     "prot."},
    {/*FA24*/ "S(=O)(=O)(-N,O-1)(-N+1)", "S(=O)(=O)(-N,O)(-N+1)", "prot."},
    {/*G003*/ "C(=N,O)(-N,P,O,S-1)(-N,P,O,S-1)", "C(=N,O)(-N,P,O,S)(-N,P,O,S)",
     "prot.2x"},
    {/*G104*/ "P,As(=O)(-C,N,O)(-O-1)(-O-1)", "P,As(=O)(-C,N,O)(-O)(-O)",
     "prot.2x"},
    {/*G204*/ "S(=O)(=O)(-O-1)(-O-1)", "S(=O)(=O)(-O)(-O)", "prot. 2x"},
    {/*H003*/ "V(=O)(=O)(-O-1)", "V(=O)(=O)(-O)", "prot. trans.met."},
    {/*I001*/ "O-1(-B,N,P,As,O,Se,Cl,I)", "O(-B,N,P,As,O,Se,Cl,I)",
     "prot. allg."},
    {/*I011*/ "S-1(-S)", "S(-S)", "prot. allg."},
    {/*I021*/ "O-1(-V)", "O(-V)", "prot. allg."},
    {/*I101*/ "N-1(=C,N)", "N(=C,N)", "prot. allg."},
    {/*I202*/ "C-1(-C)(-C,N)", "C(-C)(-C,N)", "prot. allg."},
    {/*I212*/ "N-1(-C,N)(-C,N,S)", "N(-C,N)(-C,N,S)", "prot. allg."},
    {/*I303*/ "C-1(-C)(-C)(-C,N)", "C(-C)(-C)(-C,N)", "prot. allg."},
    {/*K002*/ "S(-C+1)(-S)", "S(-C)(=S+1)", "MAAG special"},
    {/*K006*/ "Si-2(-F)(-F)(-F)(-F)(-F)(-F)", "Si(-F)(-F)(-F)(-F)(-F)(-F)",
     "MAAG special"},
    {/*L000*/ "P,Sb-3", "P,Sb", ""},
    {/*L000*/ "S-2", "S", ""},
    {/*L100*/ "Ca+1(-O)", "Ca+2(?O)", ""},
    {/*L100*/ "O-1(-O-1)", "O(=O)", ""},
    {/*L200*/ "C(#N)(-Na)", "C(#N)(?Na+1)", ""},
    {/*L200*/ "Ca(-O)(-S,Cl)", "Ca+2(?O)(?S,Cl)", ""},
    {/*L200*/ "O(=C)(-Cr)", "O+1(=C)(-Cr)", ""},
    {/*L300*/ "N(=O)(=O)(-N+1)", "N+1(=O)(-O-1)(-N+1)", ""},
    {/*L300*/ "N(=C)(-C)(-Co,Ni,Cu)", "N+1(=C)(-C)(-Co,Ni,Cu)", ""},
    {/*L400*/ "Al(-O)(-O)(-O)(-O)", "Al-1(-O)(-O)(-O)(-O)", ""},
    {/*L200*/ "Ca,Ba,Mg(-O)(-O)", "Ca,Ba,Mg+2(?O)(?O)", ""},
    {/*L100*/ "C+2(=O)", "C-1(#O+1)", ""},
    {/*L400*/ "N+1(-H)(-H)(-H)(-O)", "N(-H)(-H)(-H)(?O)", ""},
    {/*L400*/ "N(-O,Cl,Br)(-H)(-H)(-H)", "N(?O,Cl,Br)(-H)(-H)(-H)", ""},
    {/*L500*/ "N+1(-Br-1)(-C)(-C)(-C)(-C)", "N+1(?Br)(-C)(-C)(-C)(-C)", ""},
    {/*L100*/ "Ca(-O)", "Ca+2(?O)", ""},
    {/*L200*/ "N(=N+3)(-C)", "N+1(#N)(-C)", ""},
    {/*L200*/ "N+1(-C)(-H)", "N(-C)(-H)", ""},
    {/*L200*/ "N+1(=N-1)(=O)", "N+1(#N)(-O-1)", ""},
    {/*L200*/ "N+1(=O-1)(=O)", "N.(=O)(=O)", ""},
    {/*L200*/ "O(=C)(-C)", "O+1(=C)(-C)", ""},
    {/*L200*/ "O-1(-N+1)(-Na)", "O-1(-N+1)(?Na+1)", ""},
    {/*L300*/ "Bi(-O)(-O)(-O)", "Bi+3(?O)(?O)(?O)", ""},
    {/*L300*/ "Zn(-Cl)(-Cl)(-Cl)", "Zn-1(-Cl)(-Cl)(-Cl)", ""},
    {/*L300*/ "N+1(=O)(=O)(-O)", "N+1(=O)(-O-1)(-O)", ""},
    {/*L400*/ "S(=O)(=O)(=O)(-C,O)", "S(=O)(=O)(-O)(-C,O)", ""},
    {/*L400*/ "Cr+1(-O)(-O)(-O)(-O)", "Cr-1(-O)(-O)(-O)(-O)", ""},
    {/*L400*/ "Cr+2(-O)(-O)(-O)(-O)", "Cr-1(-O)(-O)(-O)(-O)", ""},
    {/*L400*/ "Cr-3(-O)(-O)(-O)(-O)", "Cr-1(-O)(-O)(-O)(-O)", ""},
    {/*L100*/ "H(-H)", "Hyd(-Hyd)", ""},
    {/*B202*/ "I+1(-C)(-C)", "I(-C)(-C)", "onium"},
    {/*F253*/ "C(=C)(-N+1)(-S-1)", "C(=C)(-N+1)(-S)", "MAAG SH+Noxid"},
};

}  // namespace StructureCheck
}  // namespace RDKit
