% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{get.frames}
\alias{get.frames}
\title{List frames in Stata dtas files}
\usage{
get.frames(path)
}
\arguments{
\item{path}{path to .dtas file}
}
\value{
Returns a data.frame with frame names, internal filenames and dta file format version.
}
\description{
Stata 18 introduced framesets (file extension `.dtas`) that contain zipped `dta`
files. This helper functions imports those files and returns a list of data.frames.
}
\examples{

path <- system.file("extdata", "myproject2.dtas", package="readstata13")

# print all frames in myproject2.dtas
get.frames(path)

}
