% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{data}
\name{default_settings}
\alias{default_settings}
\alias{settings}
\alias{config}
\alias{lintr-config}
\alias{lintr-settings}
\alias{.lintr}
\title{Default lintr settings}
\format{
An object of class \code{list} of length 12.
}
\usage{
default_settings
}
\description{
The default settings consist of
\itemize{
\item \code{linters}: a list of default linters (see \code{\link[=default_linters]{default_linters()}})
\item \code{encoding}: the character encoding assumed for the file
\item \code{exclude}: pattern used to exclude a line of code
\item \code{exclude_start}, \code{exclude_end}: patterns used to mark start and end of the code block to exclude
\item \code{exclude_linter}, \code{exclude_linter_sep}: patterns used to exclude linters
\item \code{exclusions}: a list of exclusions, see \code{\link[=exclude]{exclude()}} for a complete description of valid values.
\item \code{cache_directory}: location of cache directory
\item \code{comment_token}: a GitHub token character
\item \code{error_on_lint}: decides if error should be produced when any lints are found
}

There are no settings without defaults, i.e., this list describes every valid setting.
}
\examples{
# available settings
names(default_settings)

# linters included by default
names(default_settings$linters)

# default values for a few of the other settings
default_settings[c(
  "encoding",
  "exclude",
  "exclude_start",
  "exclude_end",
  "exclude_linter",
  "exclude_linter_sep",
  "exclusions",
  "error_on_lint"
)]

}
\seealso{
\code{\link[=read_settings]{read_settings()}}, \link{default_linters}
}
\keyword{datasets}
