// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use Cancellable;
use Error;
#[cfg(any(feature = "v2_40", feature = "dox"))]
use TlsCertificateRequestFlags;
#[cfg(any(feature = "v2_40", feature = "dox"))]
use TlsConnection;
use TlsInteractionResult;
use TlsPassword;
use ffi;
use glib::object::IsA;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std::mem;
use std::ptr;

glib_wrapper! {
    pub struct TlsInteraction(Object<ffi::GTlsInteraction, ffi::GTlsInteractionClass>);

    match fn {
        get_type => || ffi::g_tls_interaction_get_type(),
    }
}

pub trait TlsInteractionExt {
    fn ask_password<'a, P: Into<Option<&'a Cancellable>>>(&self, password: &TlsPassword, cancellable: P) -> Result<TlsInteractionResult, Error>;

    fn ask_password_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<TlsInteractionResult, Error>) + Send + 'static>(&self, password: &TlsPassword, cancellable: P, callback: Q);

    fn invoke_ask_password<'a, P: Into<Option<&'a Cancellable>>>(&self, password: &TlsPassword, cancellable: P) -> Result<TlsInteractionResult, Error>;

    #[cfg(any(feature = "v2_40", feature = "dox"))]
    fn invoke_request_certificate<'a, P: IsA<TlsConnection>, Q: Into<Option<&'a Cancellable>>>(&self, connection: &P, flags: TlsCertificateRequestFlags, cancellable: Q) -> Result<TlsInteractionResult, Error>;

    #[cfg(any(feature = "v2_40", feature = "dox"))]
    fn request_certificate<'a, P: IsA<TlsConnection>, Q: Into<Option<&'a Cancellable>>>(&self, connection: &P, flags: TlsCertificateRequestFlags, cancellable: Q) -> Result<TlsInteractionResult, Error>;

    #[cfg(any(feature = "v2_40", feature = "dox"))]
    fn request_certificate_async<'a, P: IsA<TlsConnection>, Q: Into<Option<&'a Cancellable>>, R: FnOnce(Result<TlsInteractionResult, Error>) + Send + 'static>(&self, connection: &P, flags: TlsCertificateRequestFlags, cancellable: Q, callback: R);
}

impl<O: IsA<TlsInteraction>> TlsInteractionExt for O {
    fn ask_password<'a, P: Into<Option<&'a Cancellable>>>(&self, password: &TlsPassword, cancellable: P) -> Result<TlsInteractionResult, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_ask_password(self.to_glib_none().0, password.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn ask_password_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<TlsInteractionResult, Error>) + Send + 'static>(&self, password: &TlsPassword, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn ask_password_async_trampoline<Q: FnOnce(Result<TlsInteractionResult, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_ask_password_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = ask_password_async_trampoline::<Q>;
        unsafe {
            ffi::g_tls_interaction_ask_password_async(self.to_glib_none().0, password.to_glib_none().0, cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn invoke_ask_password<'a, P: Into<Option<&'a Cancellable>>>(&self, password: &TlsPassword, cancellable: P) -> Result<TlsInteractionResult, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_invoke_ask_password(self.to_glib_none().0, password.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_40", feature = "dox"))]
    fn invoke_request_certificate<'a, P: IsA<TlsConnection>, Q: Into<Option<&'a Cancellable>>>(&self, connection: &P, flags: TlsCertificateRequestFlags, cancellable: Q) -> Result<TlsInteractionResult, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_invoke_request_certificate(self.to_glib_none().0, connection.to_glib_none().0, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_40", feature = "dox"))]
    fn request_certificate<'a, P: IsA<TlsConnection>, Q: Into<Option<&'a Cancellable>>>(&self, connection: &P, flags: TlsCertificateRequestFlags, cancellable: Q) -> Result<TlsInteractionResult, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_request_certificate(self.to_glib_none().0, connection.to_glib_none().0, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_40", feature = "dox"))]
    fn request_certificate_async<'a, P: IsA<TlsConnection>, Q: Into<Option<&'a Cancellable>>, R: FnOnce(Result<TlsInteractionResult, Error>) + Send + 'static>(&self, connection: &P, flags: TlsCertificateRequestFlags, cancellable: Q, callback: R) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<R>> = Box::new(Box::new(callback));
        unsafe extern "C" fn request_certificate_async_trampoline<R: FnOnce(Result<TlsInteractionResult, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_tls_interaction_request_certificate_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<R>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = request_certificate_async_trampoline::<R>;
        unsafe {
            ffi::g_tls_interaction_request_certificate_async(self.to_glib_none().0, connection.to_glib_none().0, flags.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }
}
